# クッキーのパラメータ

クッキーのパラメータは、`Query`や`Path`のパラメータを定義するのと同じ方法で定義できます。

## `Cookie`をインポート

まず、`Cookie`をインポートします:

```Python hl_lines="3"
{!../../docs_src/cookie_params/tutorial001.py!}
```

## `Cookie`のパラメータを宣言

次に、`Path`や`Query`と同じ構造を使ってクッキーのパラメータを宣言します。

最初の値がデフォルト値で、追加の検証パラメータや注釈パラメータをすべて渡すことができます:

```Python hl_lines="9"
{!../../docs_src/cookie_params/tutorial001.py!}
```

/// note | "技術詳細"

`Cookie`は`Path`と`Query`の「姉妹」クラスです。また、同じ共通の`Param`クラスを継承しています。

しかし、`fastapi`から`Query`や`Path`、`Cookie`などをインポートする場合、それらは実際には特殊なクラスを返す関数であることを覚えておいてください。

///

/// info | "情報"

クッキーを宣言するには、`Cookie`を使う必要があります。なぜなら、そうしないとパラメータがクエリのパラメータとして解釈されてしまうからです。

///

## まとめ

クッキーは`Cookie`を使って宣言し、`Query`や`Path`と同じパターンを使用する。
