Object.assign(window.search, {"doc_urls":["introduction.html#introduction","getting-started/index.html#getting-started","getting-started/pre-reqs.html#pre-requisites","getting-started/pre-reqs.html#rust","getting-started/pre-reqs.html#webassembly-target","getting-started/installation.html#installation","getting-started/installation.html#installing-from-source","getting-started/installation.html#installing-a-release-from-cratesio","getting-started/installation.html#installing-from-git-directly","getting-started/installation.html#installing-from-the-local-directory","getting-started/installation.html#installing-a-pre-compiled-binary-from-trunk","getting-started/installation.html#download-from-github-releases","getting-started/installation.html#using-cargo-binstall","getting-started/installation.html#distributions","getting-started/installation.html#brew","getting-started/installation.html#fedora","getting-started/installation.html#nix-os","getting-started/installation.html#update-check","getting-started/project.html#a-basic-project","getting-started/project.html#creating-a-project","getting-started/project.html#next-steps","commands/index.html#commands","commands/index.html#build","commands/index.html#watch","commands/index.html#serve","commands/index.html#clean","commands/index.html#config-show","commands/index.html#tools-show","configuration/index.html#configuration","configuration/index.html#configuration-files","configuration/index.html#formats","configuration/index.html#command-line-arguments-and-environment-variables","configuration/index.html#migration-from-pre-0210-the-best-approach-to-moving-forward","configuration/index.html#required-version","configuration/schema.html#configuration-schema","configuration/schema.html#obtaining-the-schema","configuration/schema.html#editoride-support","configuration/schema.html#intellij-and-alike","build/hooks.html#hooks","build/hooks.html#build-steps","build/hooks.html#hook-execution","build/hooks.html#os-specific-overrides","assets/index.html#assets","assets/index.html#link-asset-types","assets/index.html#rust","assets/index.html#sassscss","assets/index.html#css","assets/index.html#tailwind","assets/index.html#icon","assets/index.html#inline","assets/index.html#copy-file","assets/index.html#copy-dir","assets/index.html#script-asset-types","assets/index.html#script-assets","assets/index.html#js-snippets","assets/index.html#images--other-resources","assets/index.html#directives","assets/minification.html#minification","assets/sri.html#sub-resource-integrity","advanced/index.html#advanced","advanced/javascript_interop.html#javascript-interoperability","advanced/javascript_interop.html#order-of-initialization","advanced/startup_event.html#startup-event","advanced/startup_event.html#definition","advanced/startup_event.html#example","advanced/initializer.html#initializer","advanced/library.html#library-crate","advanced/paths.html#base-urls-public-urls-paths--reverse-proxies","advanced/proxy.html#backend-proxy","advanced/proxy.html#proxy-cli-flags","advanced/proxy.html#config-file","contributing.html#contributing"],"index":{"documentStore":{"docInfo":{"0":{"body":35,"breadcrumbs":2,"title":1},"1":{"body":10,"breadcrumbs":4,"title":2},"10":{"body":6,"breadcrumbs":8,"title":5},"11":{"body":18,"breadcrumbs":6,"title":3},"12":{"body":34,"breadcrumbs":6,"title":3},"13":{"body":26,"breadcrumbs":4,"title":1},"14":{"body":9,"breadcrumbs":4,"title":1},"15":{"body":10,"breadcrumbs":4,"title":1},"16":{"body":8,"breadcrumbs":5,"title":2},"17":{"body":49,"breadcrumbs":5,"title":2},"18":{"body":23,"breadcrumbs":6,"title":2},"19":{"body":112,"breadcrumbs":6,"title":2},"2":{"body":15,"breadcrumbs":6,"title":2},"20":{"body":48,"breadcrumbs":6,"title":2},"21":{"body":8,"breadcrumbs":2,"title":1},"22":{"body":32,"breadcrumbs":2,"title":1},"23":{"body":14,"breadcrumbs":2,"title":1},"24":{"body":9,"breadcrumbs":2,"title":1},"25":{"body":9,"breadcrumbs":2,"title":1},"26":{"body":15,"breadcrumbs":3,"title":2},"27":{"body":14,"breadcrumbs":3,"title":2},"28":{"body":71,"breadcrumbs":2,"title":1},"29":{"body":55,"breadcrumbs":3,"title":2},"3":{"body":38,"breadcrumbs":5,"title":1},"30":{"body":49,"breadcrumbs":2,"title":1},"31":{"body":45,"breadcrumbs":6,"title":5},"32":{"body":98,"breadcrumbs":8,"title":7},"33":{"body":68,"breadcrumbs":3,"title":2},"34":{"body":15,"breadcrumbs":4,"title":2},"35":{"body":15,"breadcrumbs":4,"title":2},"36":{"body":12,"breadcrumbs":4,"title":2},"37":{"body":17,"breadcrumbs":4,"title":2},"38":{"body":21,"breadcrumbs":2,"title":1},"39":{"body":86,"breadcrumbs":3,"title":2},"4":{"body":36,"breadcrumbs":6,"title":2},"40":{"body":129,"breadcrumbs":3,"title":2},"41":{"body":58,"breadcrumbs":4,"title":3},"42":{"body":6,"breadcrumbs":2,"title":1},"43":{"body":53,"breadcrumbs":4,"title":3},"44":{"body":469,"breadcrumbs":2,"title":1},"45":{"body":75,"breadcrumbs":2,"title":1},"46":{"body":91,"breadcrumbs":2,"title":1},"47":{"body":84,"breadcrumbs":2,"title":1},"48":{"body":53,"breadcrumbs":2,"title":1},"49":{"body":40,"breadcrumbs":2,"title":1},"5":{"body":19,"breadcrumbs":4,"title":1},"50":{"body":34,"breadcrumbs":3,"title":2},"51":{"body":35,"breadcrumbs":3,"title":2},"52":{"body":5,"breadcrumbs":4,"title":3},"53":{"body":114,"breadcrumbs":3,"title":2},"54":{"body":25,"breadcrumbs":3,"title":2},"55":{"body":94,"breadcrumbs":3,"title":2},"56":{"body":48,"breadcrumbs":2,"title":1},"57":{"body":96,"breadcrumbs":3,"title":1},"58":{"body":31,"breadcrumbs":7,"title":3},"59":{"body":6,"breadcrumbs":2,"title":1},"6":{"body":43,"breadcrumbs":5,"title":2},"60":{"body":43,"breadcrumbs":5,"title":2},"61":{"body":42,"breadcrumbs":5,"title":2},"62":{"body":15,"breadcrumbs":5,"title":2},"63":{"body":14,"breadcrumbs":4,"title":1},"64":{"body":36,"breadcrumbs":4,"title":1},"65":{"body":136,"breadcrumbs":4,"title":1},"66":{"body":28,"breadcrumbs":5,"title":2},"67":{"body":196,"breadcrumbs":15,"title":7},"68":{"body":27,"breadcrumbs":5,"title":2},"69":{"body":152,"breadcrumbs":6,"title":3},"7":{"body":10,"breadcrumbs":6,"title":3},"70":{"body":59,"breadcrumbs":5,"title":2},"71":{"body":38,"breadcrumbs":2,"title":1},"8":{"body":38,"breadcrumbs":6,"title":3},"9":{"body":16,"breadcrumbs":6,"title":3}},"docs":{"0":{"body":"Trunk is a WebAssembly (WASM) web application bundler for Rust. Trunk uses a simple, optional-config pattern for building & bundling WASM, JS snippets & other assets (images, css, scss) via a source HTML file. Or in layman's terms: Rusty things go in, webby things come out.","breadcrumbs":"Introduction » Introduction","id":"0","title":"Introduction"},"1":{"body":"The following subsections explain what is required to install and use trunk, and how you can start with a basic project.","breadcrumbs":"Getting started » Getting started","id":"1","title":"Getting started"},"10":{"body":"Pre-compiled releases have the default features enabled.","breadcrumbs":"Getting started » Installation » Installing a pre-compiled binary from trunk","id":"10","title":"Installing a pre-compiled binary from trunk"},"11":{"body":"trunk published compiled binaries for various platforms during the release process. They can be found in the GitHub release section of trunk. Just download and extract the binary as you would normally do.","breadcrumbs":"Getting started » Installation » Download from GitHub releases","id":"11","title":"Download from GitHub releases"},"12":{"body":"cargo-binstall allows to install pre-compiled binaries in a more convenient way. Given a certain pattern, it can detect the version from crates.io and then fetch the matching binary from a GitHub release. trunk supports this pattern. So assuming you have installed cargo-binstall already, you can simpy run: cargo binstall trunk","breadcrumbs":"Getting started » Installation » Using cargo binstall","id":"12","title":"Using cargo binstall"},"13":{"body":"Trunk is released by different distributions. In most cases, a distribution will build their own binaries and might not keep default feature flags. It might also be that an update to the most recent version might be delayed by the distribution's release process. As distributions will have their own update management, most likely Trunk's update check is disabled.","breadcrumbs":"Getting started » Installation » Distributions","id":"13","title":"Distributions"},"14":{"body":"trunk is available using brew and can be installed using: brew install trunk","breadcrumbs":"Getting started » Installation » Brew","id":"14","title":"Brew"},"15":{"body":"Starting with Fedora 40, trunk can be installed by executing: sudo dnf install trunk","breadcrumbs":"Getting started » Installation » Fedora","id":"15","title":"Fedora"},"16":{"body":"Using Nix, trunk can be installed using: nix-env -i trunk","breadcrumbs":"Getting started » Installation » Nix OS","id":"16","title":"Nix OS"},"17":{"body":"Since: 0.19.0-alpha.2. Trunk has an update check built in. By default, it will check the trunk crate on crates.io for a newer (non-pre-release) version. If one is found, the information will be shown in the command line. This check can be disabled entirely, by not enabling the cargo feature update_check. It can also be disabled during runtime using the environment variable TRUNK_SKIP_VERSION_CHECK, or using the command line switch --skip-version-check. The actual check with crates.io is only performed every 24 hours.","breadcrumbs":"Getting started » Installation » Update check","id":"17","title":"Update check"},"18":{"body":"For building the web application, trunk is running a combination of tools, mainly cargo build and wasm-bindgen. Therefore, having a simple cargo project and an index.html file as an entry-point is sufficient to get you started.","breadcrumbs":"Getting started » First project » A basic project","id":"18","title":"A basic project"},"19":{"body":"Start with creating a fresh Rust project and change into that folder: cargo new trunk-hello-world\ncd trunk-hello-world Add some dependencies for the web: cargo add wasm-bindgen console_error_panic_hook\ncargo add web_sys -F Window,Document,HtmlElement,Text Inside the newly created project, create a file src/main.rs with the following content: use web_sys::window; fn main() { console_error_panic_hook::set_once(); let document = window() .and_then(|win| win.document()) .expect(\"Could not access the document\"); let body = document.body().expect(\"Could not access document.body\"); let text_node = document.create_text_node(\"Hello, world from Vanilla Rust!\"); body.append_child(text_node.as_ref()) .expect(\"Failed to append text\");\n} Create an index.html in the root of project: <!DOCTYPE html>\n<html lang=\"en\">\n<head> <meta charset=\"utf-8\"/> <title>Hello World</title>\n</head>\n<body>\n</body>\n</html> Then, start trunk inside that project to have it built and served: trunk serve --open This should compile the project, run wasm_bindgen, create an index.html based on the original file which loads and initializes the application. The application itself is pretty basic, simply getting the document's body and adding a note.","breadcrumbs":"Getting started » First project » Creating a project","id":"19","title":"Creating a project"},"2":{"body":"While trunk tries to fetch tools automatically as needed (unless you're running with --offline), some pre-requisites may be required, depending on your environment.","breadcrumbs":"Getting started » Pre-requisites » Pre-requisites","id":"2","title":"Pre-requisites"},"20":{"body":"Most likely, you do not want to manually update the DOM tree of your application. You might want to add some assets, tweak the build process, use some more browser APIs, perform some HTTP requests, use existing crates for the web, and maybe even interface with the JavaScript world. However, all of this is an extension to this basic project we just created. Here are some pointers: wasm_bindgen documentation HTML Frameworks (sorted by GitHub stars) Yew Leptos Doxius More More trunk examples","breadcrumbs":"Getting started » First project » Next steps","id":"20","title":"Next steps"},"21":{"body":"Trunk ships with a set of CLI commands to help you in your development workflows.","breadcrumbs":"Commands » Commands","id":"21","title":"Commands"},"22":{"body":"trunk build runs a cargo build targeting the wasm32 instruction set, runs wasm-bindgen on the built WASM, and spawns asset build pipelines for any assets defined in the target index.html. Trunk leverages Rust's powerful concurrency primitives for maximum build speeds & throughput.","breadcrumbs":"Commands » build","id":"22","title":"build"},"23":{"body":"trunk watch does the same thing as trunk build, but also watches the filesystem for changes, triggering new builds as changes are detected.","breadcrumbs":"Commands » watch","id":"23","title":"watch"},"24":{"body":"trunk serve does the same thing as trunk watch, but also spawns a web server.","breadcrumbs":"Commands » serve","id":"24","title":"serve"},"25":{"body":"trunk clean cleans up any build artifacts generated from earlier builds.","breadcrumbs":"Commands » clean","id":"25","title":"clean"},"26":{"body":"trunk config show prints out Trunk's current config, before factoring in CLI arguments. Nice for testing & debugging.","breadcrumbs":"Commands » config show","id":"26","title":"config show"},"27":{"body":"trunk tools show prints out information about tools required by trunk and the project. It shows which tools are expected and which are found.","breadcrumbs":"Commands » tools show","id":"27","title":"tools show"},"28":{"body":"Important Trunk's configuration has massively changed in the 0.21.0 release. The goal was not to break anything, but it might have happened anyway. Also does the layering system work a bit different now. It might also be that the documentation still mentions only Trunk.toml. If that's the case, then this now includes all other configuration file variants as well. Trunk supports a layered configuration system. The base comes from a reasonable set of defaults, overridden by a configuration file, overridden command line arguments. Technically speaking, there's a project configuration struct, which has reasonable defaults. Trunk will try to locate a configuration file and load if into this struct. It will then override this configuration with settings from the command line parser (which includes environment variables).","breadcrumbs":"Configuration » Configuration","id":"28","title":"Configuration"},"29":{"body":"Trunk will try to locate a configuration file. Either in the local directory, or by using the global argument --config, which can accept either a file, or a directory. If the argument is a file, then this file will be used directly. Otherwise, Trunk will load the first file found, searching for: Trunk.toml .trunk.toml Trunk.yaml .trunk.yaml Trunk.json .trunk.json If neither of those files is found, Trunk will use the metadata from the Cargo.toml, which defaults to an empty set of metadata. The directory of the configuration file will become the project root, and all relative files will be resolved based on that project root.","breadcrumbs":"Configuration » Configuration files","id":"29","title":"Configuration files"},"3":{"body":"It might be obvious, but trunk requires an installation of Rust. Not only when installing trunk itself from sources, but also for compiling the Rust-based projects to WebAssembly. The instructions of installing Rust may vary based on your operating system, a reasonable default comes from the Rust project: https://www.rust-lang.org/learn/get-started Once installed, you should have the following tools available on your command line: rustup cargo","breadcrumbs":"Getting started » Pre-requisites » Rust","id":"3","title":"Rust"},"30":{"body":"Trunk's configuration is limited to a JSON compatible model. This means you can easily translate between those different formats. For example, having the following Trunk.toml configuration: [build]\ndist = \"dist\"\n[serve]\nport = 8080 Would be the following in YAML: build: dist: \"dist\"\nserve: port: 8080 Also Cargo.toml is based on that model. However, it moves that data down into the package.metadata.trunk section. The example above would become: [package.metadata.trunk.build]\ndist = \"dist\"\n[package.metadata.trunk.serve]\nport = 8080","breadcrumbs":"Configuration » Formats","id":"30","title":"Formats"},"31":{"body":"Command line arguments can override part of the configuration. Not all configuration aspects can be overridden by the command line arguments though. Command line arguments include the use of environment variables. Trunk supports --help on all levels of commands and sub-commands. This will show you the available options, as well as the names of the environment variables to use instead. All relative paths will be resolved against the project root, as evaluated by loading the configuration.","breadcrumbs":"Configuration » Command line arguments (and environment variables)","id":"31","title":"Command line arguments (and environment variables)"},"32":{"body":"While the goal was to support all fields from Trunk.toml, the command line arguments as well as the environment variables, it still is a version breaking the API. In some cases, it just made little sense, and so those fields got marked \"deprecated\". They trigger a warning today and might be removed in one of the next releases. Ideally, you don't need to change anything. In some ideal cases, you don't even need any configuration. In case you do, you now have some more choices. You can keep using TOML, you may hide it using .trunk.* variant. You can use YAML or JSON to leverage the JSON schema that is generated. Or if you're a fan of keeping everything in Cargo.toml, that's fine too. The choice is yours. Important You need to take care when working with older versions of Trunk though. If you use an older version of Trunk (before 0.21.0) with a project using the newer configuration files, then that version would not consider those files and might consider default settings, due to the missing Trunk.toml file.","breadcrumbs":"Configuration » Migration from pre 0.21.0 the best approach to moving forward","id":"32","title":"Migration from pre 0.21.0 the best approach to moving forward"},"33":{"body":"Starting with 0.19.0-alpha.2, it is possible to enforce having a certain version of trunk building the project. As new features get added to trunk, this might be helpful to ensure that the version of trunk building the current is actually capable of doing so. This can be done using the trunk-version (or using the alias trunk_version) on the root level of the Trunk.toml file. The version format is a \"version requirement\", the same format you might know from Cargo's version field on dependencies. This also supports pre-release requirements, which allows adopting upcoming features early. Note Versions prior do 0.19.0-alpha.2 currently do not support this check, and so they will silently ignore such an error for now.","breadcrumbs":"Configuration » Required version","id":"33","title":"Required version"},"34":{"body":"Trunk provides a JSON schema for the configuration model. This can be added to e.g. a YAML file using the following syntax: $schema: \"./schema.json\"","breadcrumbs":"Configuration » Schema » Configuration Schema","id":"34","title":"Configuration Schema"},"35":{"body":"You can generate the schema by running: trunk config generate-schema Or directly write it to a file: trunk config generate-schema path/to/file","breadcrumbs":"Configuration » Schema » Obtaining the schema","id":"35","title":"Obtaining the schema"},"36":{"body":"Your editor/IDE needs to support this functionality. Trunk only provides the schema. The following sections provide some information on how to use this.","breadcrumbs":"Configuration » Schema » Editor/IDE support","id":"36","title":"Editor/IDE support"},"37":{"body":"IntelliJ based IDEs (including Rust Rover) do support JSON schemas in YAML and JSON files. You only need to reference the schema, like: $schema: \"./schema.json\"","breadcrumbs":"Configuration » Schema » IntelliJ (and alike)","id":"37","title":"IntelliJ (and alike)"},"38":{"body":"If you find that you need Trunk to perform an additional build action that isn't supported directly, then Trunk's flexible hooks system can be used to launch external processes at various stages in the pipeline.","breadcrumbs":"Hooks » Hooks","id":"38","title":"Hooks"},"39":{"body":"This is a brief overview of Trunk's build process for the purpose of describing when hooks are executed. Please note that the exact ordering may change in the future to add new features. Step 1 — Read and parse the HTML file. Step 2 — Produce a plan of all assets to be built. Step 3 — Build all assets in parallel. Step 4 — Finalize and write assets to staging directory. Step 5 — Write HTML to staging directory. Step 6 - Replace dist directory contents with staging directory contents. The hook stages correspond to this as follows: pre_build: takes place before step 1. build: takes place at the same time as step 3, executing in parallel with asset builds. post_build: takes place after step 5 and before step 6.","breadcrumbs":"Hooks » Build steps","id":"39","title":"Build steps"},"4":{"body":"By default, the Rust installation will only install the target for your current machine. However, in this case, we want to cross-compile to WebAssembly. Therefore, it is required to install the target wasm32-unknown-unknown. Assuming you have installed Rust using the standard process and can use rustup, you can add the target using: rustup target add wasm32-unknown-unknown","breadcrumbs":"Getting started » Pre-requisites » WebAssembly target","id":"4","title":"WebAssembly target"},"40":{"body":"Hooks can be declared exclusively in Trunk.toml, and consist of a stage, command and command_arguments: stage: (required) one of pre_build, build or post_build. It specifies when in Trunk's build pipeline the hook is executed. command: (required) the name or path to the desired executable. command_arguments: (optional, defaults to none) any arguments to be passed, in the given order, to the executable. At the relevant point for each stage, all hooks for that stage are spawned simultaneously. After this, Trunk immediately waits for all the hooks to exit before proceeding, except in the case of the build stage, described further below. All hooks are executed using the same stdin and stdout as trunk. The executable is expected to return an error code of 0 to indicate success. Any other code will be treated as an error and terminate the build process. Additionally, the following environment variables are provided to the process: TRUNK_PROFILE: the build profile in use. Currently, either debug or release. TRUNK_HTML_FILE: the full path to the HTML file (typically index.html in TRUNK_SOURCE_DIR) used by trunk. TRUNK_SOURCE_DIR: the full path to the source directory in use by Trunk. This is always the directory in which TRUNK_HTML_FILE resides. TRUNK_STAGING_DIR: the full path of the Trunk staging directory. TRUNK_DIST_DIR: the full path of the Trunk dist directory. TRUNK_PUBLIC_URL: the configured public URL for Trunk.","breadcrumbs":"Hooks » Hook execution","id":"40","title":"Hook execution"},"41":{"body":"Often times you will want to perform the same build step on different OSes, requiring different commands. A typical example of this is using the sh command on Linux, but cmd on Windows. To accomodate this, you can optionally create OS-specific overrides for each hook. To do this, specify the default hook, then directly below it create a [hooks.<os>] entry where <os> can be one of windows, macos, or linux. Within this entry you must specify only the command and command_argumnets keys. You may provide multiple overrides for each hook. i.e. One for windows, one for macos, and one for linux.","breadcrumbs":"Hooks » OS-specific overrides","id":"41","title":"OS-specific overrides"},"42":{"body":"Declaring assets to be processed by Trunk is simple and extensible.","breadcrumbs":"Assets » Assets","id":"42","title":"Assets"},"43":{"body":"All link assets to be processed by Trunk must follow these three rules: Must be declared as a valid HTML link tag. Must have the attribute data-trunk. Must have the attribute rel=\"{type}\", where {type} is one of the asset types listed below. This will typically look like: <link data-trunk rel=\"{type}\" href=\"{path}\" ..other options here.. />. Each asset type described below specifies the required and optional attributes for its asset type. All <link data-trunk .../> HTML elements will be replaced with the output HTML of the associated pipeline.","breadcrumbs":"Assets » Link Asset Types","id":"43","title":"Link Asset Types"},"44":{"body":"✅ rel=\"rust\": Trunk will compile the specified Cargo project as WASM and load it. This is optional. If not specified, Trunk will look for a Cargo.toml in the parent directory of the source HTML file. href: (optional) the path to the Cargo.toml of the Rust project. If a directory is specified, then Trunk will look for the Cargo.toml in the given directory. If no value is specified, then Trunk will look for a Cargo.toml in the parent directory of the source HTML file. data-target-name: (optional) the name of the target artifact to load. If the Cargo project has multiple targets (binaries and library), this value can be used to select which one should be used by trunk. data-bin: (optional) the name of the binary to compile and load. If the Cargo project has multiple binaries, this value can be used to specify that a specific binary should be compiled (using --bin) and used by trunk. This implicitly includes data-target-name. data-type: (optional) specifies how the binary should be loaded into the project. Can be set to main or worker. main is the default. There can only be one main link. For workers a wasm-bindgen javascript wrapper and the wasm file (with _bg.wasm suffix) is created, named after the binary name (if provided) or project name. See one of the webworker examples on how to load them. data-cargo-features: (optional) Space or comma separated list of cargo features to activate. data-cargo-no-default-features: (optional) Disables the default Cargo features. data-cargo-all-features: (optional) Enables all Cargo features. Neither compatible with data-cargo-features nor data-cargo-no-default-features. data-wasm-opt: (optional) run wasm-opt with the set optimization level. The possible values are 0, 1, 2, 3, 4, s, z or an empty value for wasm-opt's default. Set this option to 0 to disable wasm-opt explicitly. The values 1-4 are increasingly stronger optimization levels for speed. s and z (z means more optimization) optimize for binary size instead. Only used in --release mode. data-wasm-opt-params: (optional) run wasm-opt with the additional params. Only used in --release mode. data-keep-debug: (optional) instruct wasm-bindgen to preserve debug info in the final WASM output, even for --release mode. This may conflict with the use of wasm-opt, so to be sure, it is recommended to set data-wasm-opt=\"0\" when using this option. data-no-demangle: (optional) instruct wasm-bindgen to not demangle Rust symbol names. data-reference-types: (optional) instruct wasm-bindgen to enable reference types . data-weak-refs: (optional) instruct wasm-bindgen to enable weak references . data-typescript: (optional) instruct wasm-bindgen to output Typescript bindings. Defaults to false. data-bindgen-target: (optional) specifies the value of the wasm-bindgen flag --target (see link for possible values). Defaults to no-modules. The main use-case is to switch to web with data-type=\"worker\" which reduces backwards compatibility but with some advantages . data-loader-shim: (optional) instruct trunk to create a loader shim for web workers. Defaults to false. data-cross-origin: (optional) the crossorigin setting when loading the code & script resources. Defaults to plain anonymous. data-integrity: (optional) the integrity digest type for code & script resources. Defaults to plain sha384. data-wasm-no-import: (optional) by default, Trunk will generate an import of functions exported from Rust. Enabling this flag disables this feature. Defaults to false. data-wasm-import-name: (optional) the name of the global variable where the functions imported from WASM will be available (under the window object). Defaults to wasmBindings (which makes them available via window.wasmBindings.<functionName>). data-target-path: (optional) Path where the output is placed inside the dist dir. If not present, the directory is placed in the dist root. The path must be a relative path without ... data-initializer: (optional) Path to the (module) JavaScript file of the initializer . data-cargo-profile: (optional) A cargo profile to use, instead of the default, for both release or dev mode. data-cargo-profile-release: (optional) A cargo profile to use, instead of the default, for the release mode. Overrides the data-cargo-profile setting. data-cargo-profile-dev: (optional) A cargo profile to use, instead of the default, for the dev mode. Overrides the data-cargo-profile setting.","breadcrumbs":"Assets » rust","id":"44","title":"rust"},"45":{"body":"✅ rel=\"sass\" or rel=\"scss\": Trunk uses the official dart-sass for compilation. Just link to your sass files from your source HTML, and Trunk will handle the rest. This content is hashed for cache control. The href attribute must be included in the link pointing to the sass/scss file to be processed. data-inline: (optional) this attribute will inline the compiled CSS from the SASS/SCSS file into a <style> tag instead of using a <link rel=\"stylesheet\"> tag. data-integrity: (optional) the integrity digest type for code & script resources. Defaults to plain sha384. data-target-path: (optional) Path where the output is placed inside the dist dir. If not present, the directory is placed in the dist root. The path must be a relative path without ...","breadcrumbs":"Assets » sass/scss","id":"45","title":"sass/scss"},"46":{"body":"✅ rel=\"css\": Trunk will copy linked css files found in the source HTML without content modification. This content is hashed for cache control. The href attribute must be included in the link pointing to the css file to be processed. In the future, Trunk will resolve local @imports, will handle minification (see trunk#7 ), and we may even look into a pattern where any CSS found in the source tree will be bundled, which would enable a nice zero-config \"component styles\" pattern. See trunk#3 for more details. data-integrity: (optional) the integrity digest type for code & script resources. Defaults to plain sha384. data-no-minify: (optional) Opt-out of minification. Also see: Minification . data-target-path: (optional) Path where the output is placed inside the dist dir. If not present, the directory is placed in the dist root. The path must be a relative path without ...","breadcrumbs":"Assets » css","id":"46","title":"css"},"47":{"body":"✅ rel=\"tailwind-css\": Trunk uses the official tailwindcss cli for compilation. Just link to your tailwind css files from your source HTML, and Trunk will handle the rest. This content is hashed for cache control. The href attribute must be included in the link pointing to the sass/scss file to be processed. data-inline: (optional) this attribute will inline the compiled CSS from the tailwind compilation into a <style> tag instead of using a <link rel=\"stylesheet\"> tag. data-integrity: (optional) the integrity digest type for code & script resources. Defaults to plain sha384. data-no-minify: (optional) Opt-out of minification. Also see: Minification . data-target-path: (optional) Path where the output is placed inside the dist dir. If not present, the directory is placed in the dist root. The path must be a relative path without ...","breadcrumbs":"Assets » tailwind","id":"47","title":"tailwind"},"48":{"body":"✅ rel=\"icon\": Trunk will copy the icon image specified in the href attribute to the dist dir. This content is hashed for cache control. data-integrity: (optional) the integrity digest type for code & script resources. Defaults to plain sha384. data-no-minify: (optional) Opt-out of minification. Also see: Minification . data-target-path: (optional) Path where the output is placed inside the dist dir. If not present, the directory is placed in the dist root. The path must be a relative path without ...","breadcrumbs":"Assets » icon","id":"48","title":"icon"},"49":{"body":"✅ rel=\"inline\": Trunk will inline the content of the file specified in the href attribute into index.html. This content is copied exactly, no hashing is performed. type: (optional) – If not present, the type is inferred by the file extension. html, svg css: CSS wrapped in style tags js: JavaScript wrapped in script tags mjs, module: JavaScript wrapped in script tags with type=\"module\"","breadcrumbs":"Assets » inline","id":"49","title":"inline"},"5":{"body":"trunk is a standard Rust command line tool and can be installed using standard Rust tooling (cargo), by downloading a pre-compiled binary, or through some distribution packagers.","breadcrumbs":"Getting started » Installation » Installation","id":"5","title":"Installation"},"50":{"body":"✅ rel=\"copy-file\": Trunk will copy the file specified in the href attribute to the dist dir. This content is copied exactly, no hashing is performed. data-target-path: (optional) Path where the output is placed inside the dist dir. If not present, the directory is placed in the dist root. The path must be a relative path without ...","breadcrumbs":"Assets » copy-file","id":"50","title":"copy-file"},"51":{"body":"✅ rel=\"copy-dir\": Trunk will recursively copy the directory specified in the href attribute to the dist dir. This content is copied exactly, no hashing is performed. data-target-path: (optional) Path where the output is placed inside the dist dir. If not present, the directory is placed in the dist root. The path must be a relative path without ...","breadcrumbs":"Assets » copy-dir","id":"51","title":"copy-dir"},"52":{"body":"Script assets are bit more diverse.","breadcrumbs":"Assets » Script Asset Types","id":"52","title":"Script Asset Types"},"53":{"body":"Classic script assets processed by Trunk must follow these three rules: Must be declared as a valid HTML script tag. Must have the attribute data-trunk. Must have the attribute src, pointing to a script file Attention A valid HTML script tag always has an end tag (like <script></script>). A self-closing script tag (like <script />) is not avalid HTML script tag and will trigger a warning an may create a non-working HTML file. This will typically look like: <script data-trunk src=\"{path}\" ..other options here..></script>. All <script data-trunk ...></script> HTML elements will be replaced with the output HTML of the associated pipeline. Trunk will copy script files found in the source HTML without content modification. This content is hashed for cache control. The src attribute must be included in the script pointing to the script file to be processed. data-no-minify: (optional) Opt-out of minification. Also see: Minification . data-target-path: (optional) Path where the output is placed inside the dist dir. If not present, the directory is placed in the dist root. The path must be a relative path without ...","breadcrumbs":"Assets » Script Assets","id":"53","title":"Script Assets"},"54":{"body":"JS snippets generated from the wasm-bindgen JS snippets feature are automatically copied to the dist dir, hashed and ready to rock. No additional setup is required. Just use the feature in your application, and Trunk will take care of the rest.","breadcrumbs":"Assets » JS Snippets","id":"54","title":"JS Snippets"},"55":{"body":"Images and other resource types can be copied into the dist dir by adding a link like this to your source HTML: <link data-trunk rel=\"copy-file\" href=\"path/to/image\"/>. Any normal file type is supported. This will cause Trunk to find the target resource, and copy it to the dist dir unmodified. No hashing will be applied. The link itself will be removed from the HTML. To copy an entire directory of assets/images, you can use the following HTML: <link data-trunk rel=\"copy-dir\" href=\"path/to/images-dir\"/>. This will allow your WASM application to reference images directly from the dist dir, and Trunk will ensure that the images are available in the dist dir to be served. Note As Trunk continues to mature, we will find better ways to include images and other resources. Hashing content for cache control is great, we just need to find a nice pattern to work with images referenced in Rust components. Please contribute to the discussion over in trunk#9 ! See you there.","breadcrumbs":"Assets » Images & Other Resources","id":"55","title":"Images & Other Resources"},"56":{"body":"You can instruct Trunk to write the URL passed to --public-url to the HTML output by adding this to your <head>: <base data-trunk-public-url/>. Trunk will set the href attribute of the element to the public URL. This changes the behavior of relative URLs to be relative to the public URL instead of the current location. You can also access this value at runtime using document.baseURI which is useful for apps that need to know the base URL on which they're hosted (e.g. for routing).","breadcrumbs":"Assets » Directives","id":"56","title":"Directives"},"57":{"body":"Trunk supports minifying assets. This is disabled by default and can be controlled on various levels. In any case, Trunk does not perform minification itself, but delegates the process to dependencies which do the actual implementation. In cases where minification breaks things, it will, most likely, be an issue with that dependency. Starting with Trunk 0.20.0, minification is disabled by default. It can be turned on from the command line using the --minify (or -M) switch. Alternatively, it can be controlled using the build.minify field in the Trunk.toml file. The value of this field is an enum, with the following possible values: never (default, never minify), on_release (minify when running Trunk with --release), always (always minify). When minification is enabled, all assets known to trunk (this excludes the copy-dir and copy-file opaque blobs to Trunk), will get minified. It is possible to opt out of this process on a per-asset basis using the data-no-minify attribute (see individual asset configuration). In this case, the asset will never get minified.","breadcrumbs":"Assets » Minification » Minification","id":"57","title":"Minification"},"58":{"body":"Trunk can automatically generate hashes of files and add the integrity attribute for resources fetched by the web application. This is enabled by default, but can be overridden using the data-integrity attribute. See the different asset types. The following values are available: none sha256 sha384 (default) sha512","breadcrumbs":"Assets » Sub-resource integrity » Sub-resource integrity","id":"58","title":"Sub-resource integrity"},"59":{"body":"There are some more advanced topics, which will be described in the following subsections.","breadcrumbs":"Advanced » Advanced","id":"59","title":"Advanced"},"6":{"body":"As trunk uses a standard Rust build and release process, you can install trunk just the \"standard way\". The following sections will give some examples. trunk supports a build time features, they are: rustls (default)Use rustls for client and server sockets\nnative-tlsEnable the use of the system native TLS stack for client sockets, and `openssl` for server sockets\nupdate_check (default)Enable the update check on startup","breadcrumbs":"Getting started » Installation » Installing from source","id":"6","title":"Installing from source"},"60":{"body":"Trunk will create the necessary JavaScript code to bootstrap and run the WebAssembly based application. It will also include all JavaScript snippets generated by wasm-bindgen for interfacing with JavaScript functionality. By default, functions exported from Rust, using wasm-bingen, can be accessed in the JavaScript code through the global variable window.wasmBindings. This behavior can be disabled, and the name can be customized. For more information see the rust asset type .","breadcrumbs":"Advanced » JavaScript interoperability » JavaScript interoperability","id":"60","title":"JavaScript interoperability"},"61":{"body":"The bindings will only be available and working when the application initialization has been completed. If your WebAssembly application renders code into the web page/DOM tree, which then calls from JavaScript into the WebAssembly application, then this will not be an issue, as the application is already initialized. However, if you want to call into the WebAssembly application from, for example, the index.html file itself, then you must delay that call until the application is started. This can be ensured by executing that code with the TrunkApplicationStartup event. Also see Startup Event .","breadcrumbs":"Advanced » JavaScript interoperability » Order of initialization","id":"61","title":"Order of initialization"},"62":{"body":"The initializer code snippet of Trunk will emit an event when the WebAssembly application has been loaded and started. Note This event is independent of the initializer functionality.","breadcrumbs":"Advanced » Startup event » Startup event","id":"62","title":"Startup event"},"63":{"body":"The event is called TrunkApplicationStarted and is executed after the WebAssembly has been loaded and initialized. The event will have custom details: { wasm // The web assembly instance\n}","breadcrumbs":"Advanced » Startup event » Definition","id":"63","title":"Definition"},"64":{"body":"The following snippet can be used to run code after the initialization of the WebAssembly application: <script type=\"module\"> addEventListener(\"TrunkApplicationStarted\", (event) => { console.log(\"application started - bindings:\", window.wasmBindings, \"WASM:\", event.detail.wasm); // wasm_ffi is a function exported from WASM to JavaScript window.wasmBindings.wasm_ffi(); // You can also run this via the WASM instance in the details // event.detail.wasm.wasm_ffi();\n});\n</script> Also see the vanilla example: https://github.com/trunk-rs/trunk/tree/main/examples/vanilla .","breadcrumbs":"Advanced » Startup event » Example","id":"64","title":"Example"},"65":{"body":"Since: 0.19.0-alpha.1. Trunk supports tapping into the initialization process of the WebAssembly application. By default, this is not active and works the same way as with previous versions. The default process is that trunk injects a small JavaScript snippet, which imports the JavaScript loader generated by wasm_bindgen and calls the init method. That will fetch the WASM blob and run it. The downside of this is, that during this process, there's no feedback for the user. Neither when it takes a bit longer to load the WASM file, nor when something goes wrong. Now it is possible to tap into this process by setting data-initializer to a JavaScript module file. This module file is required to (default) export a function, which returns the \"initializer\" instance. Here is an example: export default function myInitializer () { return { onStart: () => { // called when the loading starts }, onProgress: ({current, total}) => { // the progress while loading, will be called periodically. // \"current\" will contain the number of bytes of the WASM already loaded // \"total\" will either contain the total number of bytes expected for the WASM, or if the server did not provide // the content-length header it will contain 0. }, onComplete: () => { // called when the initialization is complete (successfully or failed) }, onSuccess: (wasm) => { // called when the initialization is completed successfully, receives the `wasm` instance }, onFailure: (error) => { // called when the initialization is completed with an error, receives the `error` } }\n}; For a full example, see: https://github.com/trunk-rs/trunk/tree/main/examples/initializer .","breadcrumbs":"Advanced » Application initializer » Initializer","id":"65","title":"Initializer"},"66":{"body":"Aside from having a main function, it is also possible to up your project as a cdylib project. In order to do that, add the following to your Cargo.toml: [lib]\ncrate-type = [\"cdylib\", \"rlib\"] And then, define the entrypoint in your lib.rs like (does not need to be async): #[wasm_bindgen(start)]\npub async fn run() {}","breadcrumbs":"Advanced » Library crate » Library crate","id":"66","title":"Library crate"},"67":{"body":"Since: 0.19.0-alpha.3. Originally trunk had a single --public-url, which allowed to set the base URL of the hosted application. Plain and simple. This was a prefix for all URLs generated and acted as a base for trunk serve. Unfortunately, life isn't that simple and naming is hard. Today trunk was three paths: The \"public base URL\": acting as a prefix for all generated URLs The \"serve base\": acting as a scope/prefix for all things served by trunk serve The \"websocket base\": acting as a base path for the auto-reload websocket All three can be configured, but there are reasonable defaults in place. By default, the serve base and websocket base default to the absolute path of the public base. The public base will have a slash appended if it doesn't have one. The public base can be one of: Unset/nothing/default (meaning /) An absolute URL (e.g. http://domain/path/app) An absolute path (e.g. /path/app) A relative path (e.g. foo or ./) If the public base is an absolute URL, then the path of that URL will be used as serve and websocket base. If the public base is a relative path, then it will be turned into an absolute one. Both approaches might result in a dysfunctional application, based on your environment. There will be a warning on the console. However, by providing an explicit value using serve-base or ws-base, this can be fixed. Why is this necessary and when is it useful? It's mostly there to provide all the knobs/configurations for the case that weren't considered. The magic of public-url worked for many, but not for all. To support such cases, it is now possible to tweak all the settings, at the cost of more complexity. Having reasonable defaults should keep it simple for the simple cases. An example use case is a reverse proxy in front of trunk serve, which can't be configured to serve the trunk websocket at the location trunk serve expects it. Now, it is possible to have --public-url to choose the base when generating links, so that it looks correct when being served by the proxy. But also use --serve-base / to keep serving resource from the root.","breadcrumbs":"Advanced » Base URLs, public URLs, paths & reverse proxies » Base URLs, public URLs, paths & reverse proxies","id":"67","title":"Base URLs, public URLs, paths & reverse proxies"},"68":{"body":"Trunk ships with a built-in proxy which can be enabled when running trunk serve. There are two ways to configure the proxy, each discussed below. All Trunk proxies will transparently pass along the request body, headers, and query parameters to the proxy backend.","breadcrumbs":"Advanced » Backend Proxy » Backend Proxy","id":"68","title":"Backend Proxy"},"69":{"body":"The trunk serve command accepts two proxy related flags. --proxy-backend specifies the URL of the backend server to which requests should be proxied. The URI segment of the given URL will be used as the path on the Trunk server to handle proxy requests. E.G., trunk serve --proxy-backend=http://localhost:9000/api/ will proxy any requests received on the path /api/ to the server listening at http://localhost:9000/api/. Further path segments or query parameters will be seamlessly passed along. --proxy-rewrite specifies an alternative URI on which the Trunk server is to listen for proxy requests. Any requests received on the given URI will be rewritten to match the URI of the proxy backend, effectively stripping the rewrite prefix. E.G., trunk serve --proxy-backend=http://localhost:9000/ --proxy-rewrite=/api/ will proxy any requests received on /api/ over to http://localhost:9000/ with the /api/ prefix stripped from the request, while everything following the /api/ prefix will be left unchanged. --proxy-insecure allows the --proxy-backend url to use a self-signed certificate for https (or any officially invalid certs, including expired). This would be used when proxying to https such as trunk serve --proxy-backend=https://localhost:3001/ --proxy-insecure where the ssl cert was self-signed, such as with mkcert , and routed through an https reverse proxy for the backend, such as local-ssl-proxy or caddy . --proxy-no-sytem-proxy bypasses the system proxy when contacting the proxy backend. --proxy-ws specifies that the proxy is for a WebSocket endpoint.","breadcrumbs":"Advanced » Backend Proxy » Proxy CLI Flags","id":"69","title":"Proxy CLI Flags"},"7":{"body":"As trunk is released on crates.io , it can be installed by simply executing: cargo install --locked trunk","breadcrumbs":"Getting started » Installation » Installing a release from crates.io","id":"7","title":"Installing a release from crates.io"},"70":{"body":"The Trunk.toml config file accepts multiple [[proxy]] sections, which allows for multiple proxies to be configured. Each section requires at least the backend field, and optionally accepts the rewrite and ws fields, both corresponding to the --proxy-* CLI flags discussed above. As it is with other Trunk config, a proxy declared via CLI will take final precedence and will cause any config file proxies to be ignored, even if there are multiple proxies declared in the config file. The following is a snippet from the Trunk.toml file in the Trunk repo: [[proxy]]\nrewrite = \"/api/v1/\"\nbackend = \"http://localhost:9000/\"","breadcrumbs":"Advanced » Backend Proxy » Config File","id":"70","title":"Config File"},"71":{"body":"Anyone and everyone is welcome to contribute! Please review the CONTRIBUTING.md document for more details. The best way to get started is to find an open issue, and then start hacking on implementing it. Letting other folks know that you are working on it, and sharing progress is a great approach. Open pull requests early and often, and please use GitHub's draft pull request feature.","breadcrumbs":"Contributing » Contributing","id":"71","title":"Contributing"},"8":{"body":"Using cargo you can also install directly from git: cargo install --git https://github.com/trunk-rs/trunk trunk This will build and install the most recent commit from the main branch. You can also select a specific commit: cargo install --git https://github.com/trunk-rs/trunk trunk --rev <commit> Or a specific tag: cargo install --git https://github.com/trunk-rs/trunk trunk --tag <tag>","breadcrumbs":"Getting started » Installation » Installing from git directly","id":"8","title":"Installing from git directly"},"9":{"body":"Assuming you have checked out the trunk repository, even with local changes, you can install a local build using: cargo install --path . trunk","breadcrumbs":"Getting started » Installation » Installing from the local directory","id":"9","title":"Installing from the local directory"}},"length":72,"save":true},"fields":["title","body","breadcrumbs"],"index":{"body":{"root":{"0":{".":{"1":{"9":{".":{"0":{"df":4,"docs":{"17":{"tf":1.0},"33":{"tf":1.4142135623730951},"65":{"tf":1.0},"67":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"2":{"0":{".":{"0":{"df":1,"docs":{"57":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"1":{".":{"0":{"df":2,"docs":{"28":{"tf":1.0},"32":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":3,"docs":{"40":{"tf":1.0},"44":{"tf":1.4142135623730951},"65":{"tf":1.0}}},"1":{"df":2,"docs":{"39":{"tf":1.4142135623730951},"44":{"tf":1.4142135623730951}}},"2":{"4":{"df":1,"docs":{"17":{"tf":1.0}}},"df":2,"docs":{"39":{"tf":1.0},"44":{"tf":1.0}}},"3":{"df":2,"docs":{"39":{"tf":1.4142135623730951},"44":{"tf":1.0}}},"4":{"0":{"df":1,"docs":{"15":{"tf":1.0}}},"df":2,"docs":{"39":{"tf":1.0},"44":{"tf":1.4142135623730951}}},"5":{"df":1,"docs":{"39":{"tf":1.4142135623730951}}},"6":{"df":1,"docs":{"39":{"tf":1.4142135623730951}}},"8":{"0":{"8":{"0":{"df":1,"docs":{"30":{"tf":1.7320508075688772}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"19":{"tf":1.0}}},"_":{"b":{"df":0,"docs":{},"g":{".":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"m":{"df":1,"docs":{"44":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"a":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"v":{"df":2,"docs":{"30":{"tf":1.0},"70":{"tf":1.0}}}},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"67":{"tf":2.23606797749979}}}}}}}},"c":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":3,"docs":{"29":{"tf":1.0},"69":{"tf":1.0},"70":{"tf":1.4142135623730951}}}},"s":{"df":0,"docs":{},"s":{"df":3,"docs":{"19":{"tf":1.4142135623730951},"56":{"tf":1.0},"60":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"d":{"df":1,"docs":{"41":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"t":{"df":1,"docs":{"67":{"tf":2.0}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"38":{"tf":1.0}}}},"v":{"df":2,"docs":{"44":{"tf":1.0},"65":{"tf":1.0}}}},"u":{"a":{"df":0,"docs":{},"l":{"df":3,"docs":{"17":{"tf":1.0},"33":{"tf":1.0},"57":{"tf":1.0}}}},"df":0,"docs":{}}}},"d":{"d":{"df":6,"docs":{"19":{"tf":1.7320508075688772},"20":{"tf":1.0},"39":{"tf":1.0},"4":{"tf":1.4142135623730951},"58":{"tf":1.0},"66":{"tf":1.0}},"e":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"(":{"\"":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"k":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"c":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"64":{"tf":1.0}}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}}}}}}},"i":{"df":0,"docs":{},"t":{"df":3,"docs":{"38":{"tf":1.0},"44":{"tf":1.0},"54":{"tf":1.0}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"40":{"tf":1.0}}}}}}}},"df":5,"docs":{"19":{"tf":1.0},"33":{"tf":1.0},"34":{"tf":1.0},"55":{"tf":1.0},"56":{"tf":1.0}},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"33":{"tf":1.0}}}}},"v":{"a":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"59":{"tf":1.4142135623730951}}},"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"44":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{},"g":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"31":{"tf":1.0}}}}}}},"df":0,"docs":{}},"l":{"df":0,"docs":{},"i":{"a":{"df":1,"docs":{"33":{"tf":1.0}}},"df":0,"docs":{},"k":{"df":1,"docs":{"37":{"tf":1.0}}}},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":6,"docs":{"12":{"tf":1.0},"33":{"tf":1.0},"55":{"tf":1.0},"67":{"tf":1.0},"69":{"tf":1.0},"70":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":2,"docs":{"68":{"tf":1.0},"69":{"tf":1.0}}}}},"p":{"df":0,"docs":{},"h":{"a":{".":{"1":{"df":1,"docs":{"65":{"tf":1.0}}},"2":{"df":2,"docs":{"17":{"tf":1.0},"33":{"tf":1.4142135623730951}}},"3":{"df":1,"docs":{"67":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"e":{"a":{"d":{"df":0,"docs":{},"i":{"df":3,"docs":{"12":{"tf":1.0},"61":{"tf":1.0},"65":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":2,"docs":{"57":{"tf":1.0},"69":{"tf":1.0}}}}}},"w":{"a":{"df":0,"docs":{},"y":{"df":3,"docs":{"40":{"tf":1.0},"53":{"tf":1.0},"57":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"n":{"d":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"(":{"df":0,"docs":{},"|":{"df":0,"docs":{},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"19":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"y":{"df":0,"docs":{},"m":{"df":1,"docs":{"44":{"tf":1.0}}}}}},"y":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"71":{"tf":1.0}}}},"t":{"df":0,"docs":{},"h":{"df":2,"docs":{"28":{"tf":1.0},"32":{"tf":1.0}}}},"w":{"a":{"df":0,"docs":{},"y":{"df":1,"docs":{"28":{"tf":1.0}}}},"df":0,"docs":{}}}},"p":{"df":0,"docs":{},"i":{"/":{"df":0,"docs":{},"v":{"1":{"df":1,"docs":{"70":{"tf":1.0}}},"df":0,"docs":{}}},"df":3,"docs":{"20":{"tf":1.0},"32":{"tf":1.0},"69":{"tf":2.0}}},"p":{"df":1,"docs":{"56":{"tf":1.0}},"e":{"df":0,"docs":{},"n":{"d":{"df":2,"docs":{"19":{"tf":1.0},"67":{"tf":1.0}}},"df":0,"docs":{}}},"l":{"df":0,"docs":{},"i":{"c":{"df":13,"docs":{"0":{"tf":1.0},"18":{"tf":1.0},"19":{"tf":1.4142135623730951},"20":{"tf":1.0},"54":{"tf":1.0},"55":{"tf":1.0},"58":{"tf":1.0},"60":{"tf":1.0},"61":{"tf":2.449489742783178},"62":{"tf":1.0},"64":{"tf":1.0},"65":{"tf":1.0},"67":{"tf":1.4142135623730951}}},"df":1,"docs":{"55":{"tf":1.0}}}},"r":{"df":0,"docs":{},"o":{"a":{"c":{"df":0,"docs":{},"h":{"df":3,"docs":{"32":{"tf":1.0},"67":{"tf":1.0},"71":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":6,"docs":{"26":{"tf":1.0},"28":{"tf":1.0},"29":{"tf":1.4142135623730951},"31":{"tf":2.0},"32":{"tf":1.0},"40":{"tf":1.0}}}}}}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"a":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"25":{"tf":1.0},"44":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"s":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"66":{"tf":1.0}}},"df":0,"docs":{}},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"31":{"tf":1.0}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"63":{"tf":1.0}}}},"df":0,"docs":{}},"t":{"df":11,"docs":{"0":{"tf":1.0},"20":{"tf":1.0},"22":{"tf":1.4142135623730951},"39":{"tf":2.0},"42":{"tf":1.4142135623730951},"43":{"tf":2.23606797749979},"52":{"tf":1.4142135623730951},"53":{"tf":1.4142135623730951},"57":{"tf":2.23606797749979},"58":{"tf":1.0},"60":{"tf":1.0}},"s":{"/":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"55":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"o":{"c":{"df":0,"docs":{},"i":{"df":2,"docs":{"43":{"tf":1.0},"53":{"tf":1.0}}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"m":{"df":3,"docs":{"12":{"tf":1.0},"4":{"tf":1.0},"9":{"tf":1.0}}}}},"y":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"66":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"53":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":12,"docs":{"43":{"tf":1.7320508075688772},"45":{"tf":1.4142135623730951},"46":{"tf":1.0},"47":{"tf":1.4142135623730951},"48":{"tf":1.0},"49":{"tf":1.0},"50":{"tf":1.0},"51":{"tf":1.0},"53":{"tf":1.7320508075688772},"56":{"tf":1.0},"57":{"tf":1.0},"58":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}}}},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":1,"docs":{"67":{"tf":1.0}},"m":{"a":{"df":0,"docs":{},"t":{"df":3,"docs":{"2":{"tf":1.0},"54":{"tf":1.0},"58":{"tf":1.0}}}},"df":0,"docs":{}}}}},"v":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":7,"docs":{"14":{"tf":1.0},"3":{"tf":1.0},"31":{"tf":1.0},"44":{"tf":1.4142135623730951},"55":{"tf":1.0},"58":{"tf":1.0},"61":{"tf":1.0}}}},"l":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"53":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"b":{"a":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"=":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"p":{":":{"/":{"/":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"c":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{":":{"9":{"0":{"0":{"0":{"/":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"i":{"df":1,"docs":{"69":{"tf":1.0}}}}},"df":0,"docs":{}},"df":1,"docs":{"69":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"s":{":":{"/":{"/":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"c":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{":":{"3":{"0":{"0":{"1":{"df":1,"docs":{"69":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":3,"docs":{"68":{"tf":1.4142135623730951},"69":{"tf":2.449489742783178},"70":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"w":{"a":{"df":0,"docs":{},"r":{"d":{"df":1,"docs":{"44":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":9,"docs":{"19":{"tf":1.0},"28":{"tf":1.0},"29":{"tf":1.0},"3":{"tf":1.4142135623730951},"30":{"tf":1.0},"37":{"tf":1.0},"56":{"tf":1.4142135623730951},"60":{"tf":1.0},"67":{"tf":4.47213595499958}}},"i":{"c":{"df":4,"docs":{"1":{"tf":1.0},"18":{"tf":1.0},"19":{"tf":1.0},"20":{"tf":1.0}}},"df":1,"docs":{"57":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":2,"docs":{"29":{"tf":1.0},"30":{"tf":1.0}}}}},"df":1,"docs":{"67":{"tf":1.0}},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":4,"docs":{"26":{"tf":1.0},"32":{"tf":1.0},"39":{"tf":1.4142135623730951},"40":{"tf":1.0}}}}},"h":{"a":{"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":2,"docs":{"56":{"tf":1.0},"60":{"tf":1.0}}}}}}},"df":0,"docs":{}},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":4,"docs":{"40":{"tf":1.0},"41":{"tf":1.0},"43":{"tf":1.4142135623730951},"68":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"32":{"tf":1.0},"71":{"tf":1.0}}}},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"55":{"tf":1.0}}}}},"w":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"30":{"tf":1.0}}}}}}}},"i":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":6,"docs":{"10":{"tf":1.0},"11":{"tf":1.4142135623730951},"12":{"tf":1.4142135623730951},"13":{"tf":1.0},"44":{"tf":2.6457513110645907},"5":{"tf":1.0}}}}},"d":{"df":3,"docs":{"44":{"tf":1.0},"61":{"tf":1.0},"64":{"tf":1.0}},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":6,"docs":{"18":{"tf":1.0},"19":{"tf":1.0},"22":{"tf":1.0},"44":{"tf":2.8284271247461903},"54":{"tf":1.0},"60":{"tf":1.0}}}}}},"df":1,"docs":{"44":{"tf":1.4142135623730951}},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"60":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"12":{"tf":2.0}}}},"df":0,"docs":{}}}},"t":{"df":3,"docs":{"28":{"tf":1.0},"52":{"tf":1.0},"65":{"tf":1.0}}}},"l":{"df":0,"docs":{},"o":{"b":{"df":2,"docs":{"57":{"tf":1.0},"65":{"tf":1.0}}},"df":0,"docs":{}}},"o":{"d":{"df":0,"docs":{},"i":{"df":2,"docs":{"19":{"tf":2.0},"68":{"tf":1.0}}},"y":{".":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"_":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"d":{"(":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"e":{".":{"a":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":1,"docs":{"19":{"tf":1.0}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"60":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"t":{"df":0,"docs":{},"h":{"df":3,"docs":{"44":{"tf":1.0},"67":{"tf":1.0},"70":{"tf":1.0}}}}},"r":{"a":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"8":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"k":{"df":3,"docs":{"28":{"tf":1.0},"32":{"tf":1.0},"57":{"tf":1.0}}}},"df":0,"docs":{},"w":{"df":1,"docs":{"14":{"tf":1.7320508075688772}}}},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":1,"docs":{"39":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"20":{"tf":1.0}}}}}}}},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"d":{".":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":1,"docs":{"57":{"tf":1.0}}}}}}}}},"df":16,"docs":{"0":{"tf":1.0},"13":{"tf":1.0},"18":{"tf":1.4142135623730951},"20":{"tf":1.0},"22":{"tf":2.23606797749979},"23":{"tf":1.4142135623730951},"25":{"tf":1.4142135623730951},"30":{"tf":1.4142135623730951},"33":{"tf":1.4142135623730951},"38":{"tf":1.0},"39":{"tf":2.23606797749979},"40":{"tf":2.23606797749979},"41":{"tf":1.0},"6":{"tf":1.4142135623730951},"8":{"tf":1.0},"9":{"tf":1.0}}},"df":0,"docs":{},"t":{"df":5,"docs":{"17":{"tf":1.0},"19":{"tf":1.0},"22":{"tf":1.0},"39":{"tf":1.0},"68":{"tf":1.0}}}}},"n":{"d":{"df":0,"docs":{},"l":{"df":2,"docs":{"0":{"tf":1.0},"46":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"0":{"tf":1.0}}}}}},"df":0,"docs":{}}},"y":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"69":{"tf":1.0}}}}},"df":0,"docs":{}},"t":{"df":0,"docs":{},"e":{"df":1,"docs":{"65":{"tf":1.4142135623730951}}}}}},"c":{"a":{"c":{"df":0,"docs":{},"h":{"df":6,"docs":{"45":{"tf":1.0},"46":{"tf":1.0},"47":{"tf":1.0},"48":{"tf":1.0},"53":{"tf":1.0},"55":{"tf":1.0}}}},"d":{"d":{"df":0,"docs":{},"i":{"df":1,"docs":{"69":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":3,"docs":{"61":{"tf":1.7320508075688772},"63":{"tf":1.0},"65":{"tf":2.449489742783178}}}},"n":{"'":{"df":0,"docs":{},"t":{"df":1,"docs":{"67":{"tf":1.0}}}},"df":0,"docs":{}},"p":{"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"33":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"e":{"df":2,"docs":{"32":{"tf":1.0},"54":{"tf":1.0}}},"g":{"df":0,"docs":{},"o":{"'":{"df":1,"docs":{"33":{"tf":1.0}}},".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":5,"docs":{"29":{"tf":1.0},"30":{"tf":1.0},"32":{"tf":1.0},"44":{"tf":2.0},"66":{"tf":1.0}}}}}}},"df":11,"docs":{"12":{"tf":2.0},"17":{"tf":1.0},"18":{"tf":1.4142135623730951},"19":{"tf":1.7320508075688772},"22":{"tf":1.0},"3":{"tf":1.0},"44":{"tf":4.358898943540674},"5":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":2.0},"9":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"e":{"df":8,"docs":{"13":{"tf":1.0},"28":{"tf":1.0},"32":{"tf":1.7320508075688772},"4":{"tf":1.0},"40":{"tf":1.0},"44":{"tf":1.0},"57":{"tf":1.7320508075688772},"67":{"tf":2.0}}}},"u":{"df":0,"docs":{},"s":{"df":2,"docs":{"55":{"tf":1.0},"70":{"tf":1.0}}}}},"d":{"df":1,"docs":{"19":{"tf":1.0}},"y":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"b":{"df":1,"docs":{"66":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"12":{"tf":1.0},"33":{"tf":1.0}}}}},"df":1,"docs":{"69":{"tf":1.4142135623730951}},"i":{"df":0,"docs":{},"f":{"df":1,"docs":{"69":{"tf":1.0}}}}}}},"h":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":7,"docs":{"19":{"tf":1.0},"23":{"tf":1.4142135623730951},"28":{"tf":1.0},"32":{"tf":1.0},"39":{"tf":1.0},"56":{"tf":1.0},"9":{"tf":1.0}}}},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"=":{"\"":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"f":{"df":1,"docs":{"19":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"k":{"df":5,"docs":{"13":{"tf":1.0},"17":{"tf":2.449489742783178},"33":{"tf":1.0},"6":{"tf":1.0},"9":{"tf":1.0}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"32":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"s":{"df":1,"docs":{"67":{"tf":1.0}}}}}},"l":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"53":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"25":{"tf":1.7320508075688772}}}},"df":0,"docs":{}},"i":{"df":5,"docs":{"21":{"tf":1.0},"26":{"tf":1.0},"47":{"tf":1.0},"69":{"tf":1.0},"70":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"6":{"tf":1.4142135623730951}}}}}},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":1,"docs":{"53":{"tf":1.0}}}}}},"m":{"d":{"df":1,"docs":{"41":{"tf":1.0}}},"df":0,"docs":{}},"o":{"d":{"df":0,"docs":{},"e":{"df":10,"docs":{"40":{"tf":1.4142135623730951},"44":{"tf":1.4142135623730951},"45":{"tf":1.0},"46":{"tf":1.0},"47":{"tf":1.0},"48":{"tf":1.0},"60":{"tf":1.4142135623730951},"61":{"tf":1.4142135623730951},"62":{"tf":1.0},"64":{"tf":1.0}}}},"df":0,"docs":{},"m":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"18":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":3,"docs":{"0":{"tf":1.0},"28":{"tf":1.0},"3":{"tf":1.0}}},"m":{"a":{"df":1,"docs":{"44":{"tf":1.0}},"n":{"d":{"_":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"df":1,"docs":{"40":{"tf":1.4142135623730951}},"m":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"41":{"tf":1.0}}}}}}}}}},"df":0,"docs":{}},"df":11,"docs":{"17":{"tf":1.4142135623730951},"21":{"tf":1.4142135623730951},"28":{"tf":1.4142135623730951},"3":{"tf":1.0},"31":{"tf":2.449489742783178},"32":{"tf":1.0},"40":{"tf":1.4142135623730951},"41":{"tf":1.7320508075688772},"5":{"tf":1.0},"57":{"tf":1.0},"69":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"8":{"tf":1.7320508075688772}}}}},"p":{"a":{"df":0,"docs":{},"t":{"df":2,"docs":{"30":{"tf":1.0},"44":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":10,"docs":{"10":{"tf":1.4142135623730951},"11":{"tf":1.0},"12":{"tf":1.0},"19":{"tf":1.0},"3":{"tf":1.0},"4":{"tf":1.0},"44":{"tf":1.7320508075688772},"45":{"tf":1.4142135623730951},"47":{"tf":1.7320508075688772},"5":{"tf":1.0}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":2,"docs":{"61":{"tf":1.0},"65":{"tf":1.7320508075688772}}},"x":{"df":1,"docs":{"67":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"n":{"df":2,"docs":{"46":{"tf":1.0},"55":{"tf":1.0}}}}}},"n":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":1,"docs":{"22":{"tf":1.0}}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":6,"docs":{"0":{"tf":1.0},"26":{"tf":1.7320508075688772},"29":{"tf":1.0},"35":{"tf":1.4142135623730951},"46":{"tf":1.0},"70":{"tf":2.23606797749979}},"u":{"df":0,"docs":{},"r":{"df":11,"docs":{"28":{"tf":2.8284271247461903},"29":{"tf":1.7320508075688772},"30":{"tf":1.4142135623730951},"31":{"tf":1.7320508075688772},"32":{"tf":1.4142135623730951},"34":{"tf":1.4142135623730951},"40":{"tf":1.0},"57":{"tf":1.0},"67":{"tf":1.4142135623730951},"68":{"tf":1.0},"70":{"tf":1.0}}}}}},"l":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"44":{"tf":1.0}}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"i":{"d":{"df":2,"docs":{"32":{"tf":1.4142135623730951},"67":{"tf":1.0}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"40":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"l":{"df":1,"docs":{"67":{"tf":1.0}},"e":{".":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{"(":{"\"":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":1,"docs":{"64":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"c":{"_":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{":":{":":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"19":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":1,"docs":{"19":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}},"t":{"a":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"69":{"tf":1.0}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"65":{"tf":1.7320508075688772}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":12,"docs":{"19":{"tf":1.0},"39":{"tf":1.4142135623730951},"45":{"tf":1.0},"46":{"tf":1.4142135623730951},"47":{"tf":1.0},"48":{"tf":1.0},"49":{"tf":1.4142135623730951},"50":{"tf":1.0},"51":{"tf":1.0},"53":{"tf":1.4142135623730951},"55":{"tf":1.0},"65":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":1,"docs":{"55":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":2,"docs":{"55":{"tf":1.0},"71":{"tf":1.4142135623730951}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{".":{"df":0,"docs":{},"m":{"d":{"df":1,"docs":{"71":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"l":{"df":7,"docs":{"45":{"tf":1.0},"46":{"tf":1.0},"47":{"tf":1.0},"48":{"tf":1.0},"53":{"tf":1.0},"55":{"tf":1.0},"57":{"tf":1.4142135623730951}}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":1,"docs":{"12":{"tf":1.0}}}}}}},"p":{"df":0,"docs":{},"i":{"df":9,"docs":{"46":{"tf":1.0},"48":{"tf":1.0},"49":{"tf":1.0},"50":{"tf":1.7320508075688772},"51":{"tf":1.7320508075688772},"53":{"tf":1.0},"54":{"tf":1.0},"55":{"tf":1.7320508075688772},"57":{"tf":1.4142135623730951}}}},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"67":{"tf":1.0}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"d":{"df":2,"docs":{"39":{"tf":1.0},"70":{"tf":1.0}}},"df":0,"docs":{}}}}}}}},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"67":{"tf":1.0}}}}},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":3,"docs":{"17":{"tf":1.0},"20":{"tf":1.0},"66":{"tf":1.4142135623730951}},"s":{".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":3,"docs":{"12":{"tf":1.0},"17":{"tf":1.4142135623730951},"7":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":6,"docs":{"19":{"tf":2.449489742783178},"20":{"tf":1.0},"41":{"tf":1.4142135623730951},"44":{"tf":1.4142135623730951},"53":{"tf":1.0},"60":{"tf":1.0}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":2,"docs":{"4":{"tf":1.0},"44":{"tf":1.0}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"44":{"tf":1.0}}}}}}}}}}}},"s":{"df":0,"docs":{},"s":{"df":5,"docs":{"0":{"tf":1.0},"45":{"tf":1.0},"46":{"tf":2.0},"47":{"tf":1.7320508075688772},"49":{"tf":1.4142135623730951}}}},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":6,"docs":{"26":{"tf":1.0},"33":{"tf":1.4142135623730951},"4":{"tf":1.0},"40":{"tf":1.0},"56":{"tf":1.0},"65":{"tf":1.4142135623730951}}}}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":2,"docs":{"60":{"tf":1.0},"63":{"tf":1.0}}}}}}}},"d":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"45":{"tf":1.0}}}},"t":{"a":{"df":15,"docs":{"30":{"tf":1.0},"43":{"tf":1.7320508075688772},"44":{"tf":5.5677643628300215},"45":{"tf":1.7320508075688772},"46":{"tf":1.7320508075688772},"47":{"tf":2.0},"48":{"tf":1.7320508075688772},"50":{"tf":1.0},"51":{"tf":1.0},"53":{"tf":2.23606797749979},"55":{"tf":1.4142135623730951},"56":{"tf":1.0},"57":{"tf":1.0},"58":{"tf":1.0},"65":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"df":3,"docs":{"26":{"tf":1.0},"40":{"tf":1.0},"44":{"tf":1.4142135623730951}}}}},"c":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":5,"docs":{"40":{"tf":1.0},"42":{"tf":1.0},"43":{"tf":1.0},"53":{"tf":1.0},"70":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{")":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"6":{"tf":1.0}}}},"u":{"df":0,"docs":{},"s":{"df":1,"docs":{"6":{"tf":1.0}}}}},"df":20,"docs":{"10":{"tf":1.0},"13":{"tf":1.0},"17":{"tf":1.0},"28":{"tf":1.4142135623730951},"29":{"tf":1.0},"3":{"tf":1.0},"32":{"tf":1.0},"4":{"tf":1.0},"40":{"tf":1.0},"41":{"tf":1.0},"44":{"tf":4.0},"45":{"tf":1.0},"46":{"tf":1.0},"47":{"tf":1.0},"48":{"tf":1.0},"57":{"tf":1.7320508075688772},"58":{"tf":1.4142135623730951},"60":{"tf":1.0},"65":{"tf":2.0},"67":{"tf":2.0}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"22":{"tf":1.0},"66":{"tf":1.0}},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"63":{"tf":1.0}}}}}}},"l":{"a":{"df":0,"docs":{},"y":{"df":2,"docs":{"13":{"tf":1.0},"61":{"tf":1.0}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"g":{"df":1,"docs":{"57":{"tf":1.0}}}}},"m":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"l":{"df":1,"docs":{"44":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":4,"docs":{"19":{"tf":1.0},"2":{"tf":1.0},"33":{"tf":1.0},"57":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"e":{"c":{"df":1,"docs":{"32":{"tf":1.0}}},"df":0,"docs":{}}}},"s":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"b":{"df":4,"docs":{"39":{"tf":1.0},"40":{"tf":1.0},"43":{"tf":1.0},"59":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":1,"docs":{"40":{"tf":1.0}}}}},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":4,"docs":{"46":{"tf":1.0},"63":{"tf":1.0},"64":{"tf":1.0},"71":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"12":{"tf":1.0},"23":{"tf":1.0}}}},"df":0,"docs":{}}},"v":{"df":1,"docs":{"44":{"tf":1.7320508075688772}},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":1,"docs":{"21":{"tf":1.0}}}}}}}},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":5,"docs":{"13":{"tf":1.0},"28":{"tf":1.0},"30":{"tf":1.0},"41":{"tf":1.4142135623730951},"58":{"tf":1.0}}}}}},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":5,"docs":{"44":{"tf":1.0},"45":{"tf":1.0},"46":{"tf":1.0},"47":{"tf":1.0},"48":{"tf":1.0}}}}}},"r":{"df":11,"docs":{"44":{"tf":1.0},"45":{"tf":1.0},"46":{"tf":1.0},"47":{"tf":1.0},"48":{"tf":1.4142135623730951},"50":{"tf":1.4142135623730951},"51":{"tf":2.0},"53":{"tf":1.0},"54":{"tf":1.0},"55":{"tf":2.449489742783178},"57":{"tf":1.0}},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"56":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":6,"docs":{"29":{"tf":1.0},"35":{"tf":1.0},"38":{"tf":1.0},"41":{"tf":1.0},"55":{"tf":1.0},"8":{"tf":1.4142135623730951}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":13,"docs":{"29":{"tf":1.7320508075688772},"39":{"tf":2.0},"40":{"tf":2.0},"44":{"tf":2.23606797749979},"45":{"tf":1.0},"46":{"tf":1.0},"47":{"tf":1.0},"48":{"tf":1.0},"50":{"tf":1.0},"51":{"tf":1.4142135623730951},"53":{"tf":1.0},"55":{"tf":1.0},"9":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"s":{"a":{"b":{"df":0,"docs":{},"l":{"df":5,"docs":{"13":{"tf":1.0},"17":{"tf":1.4142135623730951},"44":{"tf":1.7320508075688772},"57":{"tf":1.4142135623730951},"60":{"tf":1.0}}}},"df":0,"docs":{}},"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":3,"docs":{"55":{"tf":1.0},"68":{"tf":1.0},"70":{"tf":1.0}}}}}},"df":0,"docs":{},"t":{"df":13,"docs":{"30":{"tf":2.449489742783178},"39":{"tf":1.0},"40":{"tf":1.0},"44":{"tf":1.4142135623730951},"45":{"tf":1.4142135623730951},"46":{"tf":1.4142135623730951},"47":{"tf":1.4142135623730951},"48":{"tf":1.7320508075688772},"50":{"tf":1.7320508075688772},"51":{"tf":1.7320508075688772},"53":{"tf":1.4142135623730951},"54":{"tf":1.0},"55":{"tf":2.0}},"r":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":2,"docs":{"13":{"tf":2.0},"5":{"tf":1.0}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"'":{"df":1,"docs":{"13":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":1,"docs":{"52":{"tf":1.0}}}}}}},"n":{"df":0,"docs":{},"f":{"df":1,"docs":{"15":{"tf":1.0}}}},"o":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":1,"docs":{"19":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"'":{"df":1,"docs":{"19":{"tf":1.0}}},".":{"b":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"56":{"tf":1.0}}}}}}}},"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"i":{"df":1,"docs":{"19":{"tf":1.0}}},"y":{"(":{")":{".":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"(":{"\"":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"d":{"df":1,"docs":{"19":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"e":{"(":{"\"":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":1,"docs":{"19":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":4,"docs":{"19":{"tf":1.4142135623730951},"20":{"tf":1.0},"28":{"tf":1.0},"71":{"tf":1.0}}}}}}}},"df":1,"docs":{"33":{"tf":1.0}},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"n":{"'":{"df":0,"docs":{},"t":{"df":1,"docs":{"67":{"tf":1.0}}}},"df":0,"docs":{}}}},"m":{"df":1,"docs":{"20":{"tf":1.0}}},"n":{"'":{"df":0,"docs":{},"t":{"df":1,"docs":{"32":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"e":{"df":1,"docs":{"33":{"tf":1.0}}}},"w":{"df":0,"docs":{},"n":{"df":1,"docs":{"30":{"tf":1.0}},"l":{"df":0,"docs":{},"o":{"a":{"d":{"df":2,"docs":{"11":{"tf":1.4142135623730951},"5":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"65":{"tf":1.0}}},"df":0,"docs":{}}}}},"x":{"df":0,"docs":{},"i":{"df":0,"docs":{},"u":{"df":1,"docs":{"20":{"tf":1.0}}}}}},"r":{"a":{"df":0,"docs":{},"f":{"df":0,"docs":{},"t":{"df":1,"docs":{"71":{"tf":1.0}}}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"e":{"df":1,"docs":{"32":{"tf":1.0}}},"r":{"df":0,"docs":{},"e":{"df":3,"docs":{"11":{"tf":1.0},"17":{"tf":1.0},"65":{"tf":1.0}}}}},"y":{"df":0,"docs":{},"s":{"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"67":{"tf":1.0}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"g":{"df":4,"docs":{"34":{"tf":1.0},"56":{"tf":1.0},"67":{"tf":1.7320508075688772},"69":{"tf":1.4142135623730951}}}},"a":{"c":{"df":0,"docs":{},"h":{"df":5,"docs":{"40":{"tf":1.0},"41":{"tf":1.4142135623730951},"43":{"tf":1.0},"68":{"tf":1.0},"70":{"tf":1.0}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":2,"docs":{"33":{"tf":1.0},"71":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"25":{"tf":1.0}}}}}}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"30":{"tf":1.0}}}}}}},"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"/":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"36":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"69":{"tf":1.0}}}},"df":0,"docs":{}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":3,"docs":{"43":{"tf":1.0},"53":{"tf":1.0},"56":{"tf":1.0}}}}}}}},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"62":{"tf":1.0}}}},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":2,"docs":{"29":{"tf":1.0},"44":{"tf":1.0}}}}}},"n":{"a":{"b":{"df":0,"docs":{},"l":{"df":7,"docs":{"10":{"tf":1.0},"17":{"tf":1.0},"44":{"tf":2.0},"46":{"tf":1.0},"57":{"tf":1.0},"58":{"tf":1.0},"68":{"tf":1.0}}}},"df":0,"docs":{}},"d":{"df":1,"docs":{"53":{"tf":1.0}},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"69":{"tf":1.0}}}}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"c":{"df":1,"docs":{"33":{"tf":1.0}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":3,"docs":{"33":{"tf":1.0},"55":{"tf":1.0},"61":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":2,"docs":{"17":{"tf":1.0},"55":{"tf":1.0}}}},"r":{"df":0,"docs":{},"i":{"df":2,"docs":{"18":{"tf":1.0},"41":{"tf":1.4142135623730951}}},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"66":{"tf":1.0}}}}}}}}}},"u":{"df":0,"docs":{},"m":{"df":1,"docs":{"57":{"tf":1.0}}}},"v":{"df":1,"docs":{"16":{"tf":1.0}},"i":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":7,"docs":{"17":{"tf":1.0},"2":{"tf":1.0},"28":{"tf":1.0},"31":{"tf":1.7320508075688772},"32":{"tf":1.0},"40":{"tf":1.0},"67":{"tf":1.0}}}}}}}},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":3,"docs":{"33":{"tf":1.0},"40":{"tf":1.4142135623730951},"65":{"tf":1.7320508075688772}}}}}},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":1,"docs":{"31":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":6,"docs":{"20":{"tf":1.0},"32":{"tf":1.0},"44":{"tf":1.0},"46":{"tf":1.0},"70":{"tf":1.0},"9":{"tf":1.0}},"t":{".":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{".":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"m":{".":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"m":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":1,"docs":{"64":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":1,"docs":{"64":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":4,"docs":{"61":{"tf":1.4142135623730951},"62":{"tf":1.7320508075688772},"63":{"tf":1.4142135623730951},"64":{"tf":1.0}}}},"r":{"df":0,"docs":{},"y":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"71":{"tf":1.0}}}},"t":{"df":0,"docs":{},"h":{"df":2,"docs":{"32":{"tf":1.0},"69":{"tf":1.0}}}}}}}},"x":{"a":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"39":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":3,"docs":{"49":{"tf":1.0},"50":{"tf":1.0},"51":{"tf":1.0}}}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":9,"docs":{"20":{"tf":1.0},"30":{"tf":1.4142135623730951},"41":{"tf":1.0},"44":{"tf":1.0},"6":{"tf":1.0},"61":{"tf":1.0},"64":{"tf":1.4142135623730951},"65":{"tf":1.4142135623730951},"67":{"tf":1.0}}}}}},"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"40":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"u":{"d":{"df":1,"docs":{"57":{"tf":1.0}}},"df":0,"docs":{},"s":{"df":1,"docs":{"40":{"tf":1.0}}}}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":6,"docs":{"15":{"tf":1.0},"39":{"tf":1.4142135623730951},"40":{"tf":2.449489742783178},"61":{"tf":1.0},"63":{"tf":1.0},"7":{"tf":1.0}}}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"20":{"tf":1.0}}}},"t":{"df":1,"docs":{"40":{"tf":1.0}}}},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"(":{"\"":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"d":{"df":1,"docs":{"19":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"19":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":4,"docs":{"27":{"tf":1.0},"40":{"tf":1.0},"65":{"tf":1.0},"67":{"tf":1.0}}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"r":{"df":1,"docs":{"69":{"tf":1.0}}}},"l":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"1":{"tf":1.0}}}}},"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"67":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"44":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":4,"docs":{"44":{"tf":1.0},"60":{"tf":1.0},"64":{"tf":1.0},"65":{"tf":1.4142135623730951}}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":3,"docs":{"20":{"tf":1.0},"42":{"tf":1.0},"49":{"tf":1.0}}}},"r":{"df":0,"docs":{},"n":{"df":1,"docs":{"38":{"tf":1.0}}}}},"r":{"a":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"11":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"f":{"a":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"26":{"tf":1.0}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"65":{"tf":1.0}}}},"l":{"df":0,"docs":{},"s":{"df":1,"docs":{"44":{"tf":1.7320508075688772}}}},"n":{"df":1,"docs":{"32":{"tf":1.0}}}},"df":1,"docs":{"19":{"tf":1.0}},"e":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":9,"docs":{"10":{"tf":1.0},"13":{"tf":1.0},"17":{"tf":1.0},"33":{"tf":1.4142135623730951},"39":{"tf":1.0},"44":{"tf":3.0},"54":{"tf":1.4142135623730951},"6":{"tf":1.0},"71":{"tf":1.0}}}}}},"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"a":{"df":1,"docs":{"15":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}},"df":0,"docs":{},"e":{"d":{"b":{"a":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"65":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"t":{"c":{"df":0,"docs":{},"h":{"df":4,"docs":{"12":{"tf":1.0},"2":{"tf":1.0},"58":{"tf":1.0},"65":{"tf":1.0}}}},"df":0,"docs":{}}},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"d":{"df":4,"docs":{"32":{"tf":1.4142135623730951},"33":{"tf":1.0},"57":{"tf":1.4142135623730951},"70":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"l":{"df":0,"docs":{},"e":{"df":25,"docs":{"0":{"tf":1.0},"18":{"tf":1.0},"19":{"tf":1.4142135623730951},"28":{"tf":1.7320508075688772},"29":{"tf":3.0},"32":{"tf":1.7320508075688772},"33":{"tf":1.0},"34":{"tf":1.0},"35":{"tf":1.0},"37":{"tf":1.0},"39":{"tf":1.0},"40":{"tf":1.0},"44":{"tf":2.0},"45":{"tf":1.7320508075688772},"46":{"tf":1.4142135623730951},"47":{"tf":1.4142135623730951},"49":{"tf":1.4142135623730951},"50":{"tf":1.7320508075688772},"53":{"tf":2.0},"55":{"tf":1.4142135623730951},"57":{"tf":1.4142135623730951},"58":{"tf":1.0},"61":{"tf":1.0},"65":{"tf":1.7320508075688772},"70":{"tf":2.23606797749979}},"s":{"df":0,"docs":{},"y":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":1,"docs":{"23":{"tf":1.0}}}}}}}}}},"n":{"a":{"df":0,"docs":{},"l":{"df":3,"docs":{"39":{"tf":1.0},"44":{"tf":1.0},"70":{"tf":1.0}}}},"d":{"df":3,"docs":{"38":{"tf":1.0},"55":{"tf":1.7320508075688772},"71":{"tf":1.0}}},"df":0,"docs":{},"e":{"df":1,"docs":{"32":{"tf":1.0}}}},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"29":{"tf":1.0}}}}},"x":{"df":1,"docs":{"67":{"tf":1.0}}}},"l":{"a":{"df":0,"docs":{},"g":{"df":4,"docs":{"13":{"tf":1.0},"44":{"tf":1.4142135623730951},"69":{"tf":1.4142135623730951},"70":{"tf":1.0}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"38":{"tf":1.0}}}},"df":0,"docs":{}}}}},"n":{"df":2,"docs":{"19":{"tf":1.0},"66":{"tf":1.0}}},"o":{"df":0,"docs":{},"l":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"19":{"tf":1.0}}}}},"df":0,"docs":{},"k":{"df":1,"docs":{"71":{"tf":1.0}}},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":19,"docs":{"1":{"tf":1.0},"19":{"tf":1.0},"3":{"tf":1.0},"30":{"tf":1.4142135623730951},"34":{"tf":1.0},"36":{"tf":1.0},"39":{"tf":1.0},"40":{"tf":1.0},"43":{"tf":1.0},"53":{"tf":1.0},"55":{"tf":1.0},"57":{"tf":1.0},"58":{"tf":1.0},"59":{"tf":1.0},"6":{"tf":1.0},"64":{"tf":1.0},"66":{"tf":1.0},"69":{"tf":1.0},"70":{"tf":1.0}}}}}},"o":{"df":1,"docs":{"67":{"tf":1.0}}},"r":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"df":2,"docs":{"30":{"tf":1.4142135623730951},"33":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"w":{"a":{"df":0,"docs":{},"r":{"d":{"df":1,"docs":{"32":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"n":{"d":{"df":6,"docs":{"11":{"tf":1.0},"17":{"tf":1.0},"27":{"tf":1.0},"29":{"tf":1.4142135623730951},"46":{"tf":1.4142135623730951},"53":{"tf":1.0}}},"df":0,"docs":{}}}},"r":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"k":{"df":1,"docs":{"20":{"tf":1.0}}}}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"19":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"67":{"tf":1.0}}}}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":2,"docs":{"40":{"tf":2.0},"65":{"tf":1.0}}}},"n":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":7,"docs":{"36":{"tf":1.0},"44":{"tf":1.4142135623730951},"60":{"tf":1.4142135623730951},"62":{"tf":1.0},"64":{"tf":1.0},"65":{"tf":1.4142135623730951},"66":{"tf":1.0}}}}}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"40":{"tf":1.0},"69":{"tf":1.0}}}}}}},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":2,"docs":{"39":{"tf":1.0},"46":{"tf":1.0}}}}}}},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":9,"docs":{"25":{"tf":1.0},"32":{"tf":1.0},"35":{"tf":1.7320508075688772},"44":{"tf":1.0},"54":{"tf":1.0},"58":{"tf":1.0},"60":{"tf":1.0},"65":{"tf":1.0},"67":{"tf":1.7320508075688772}}}}},"t":{"df":2,"docs":{"1":{"tf":1.0},"19":{"tf":1.0}}}},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"8":{"tf":2.23606797749979}},"h":{"df":0,"docs":{},"u":{"b":{"'":{"df":1,"docs":{"71":{"tf":1.0}}},"df":3,"docs":{"11":{"tf":1.4142135623730951},"12":{"tf":1.0},"20":{"tf":1.0}}},"df":0,"docs":{}}}},"v":{"df":0,"docs":{},"e":{"df":1,"docs":{"6":{"tf":1.0}},"n":{"df":4,"docs":{"12":{"tf":1.0},"40":{"tf":1.0},"44":{"tf":1.0},"69":{"tf":1.4142135623730951}}}}}},"l":{"df":0,"docs":{},"o":{"b":{"a":{"df":0,"docs":{},"l":{"df":3,"docs":{"29":{"tf":1.0},"44":{"tf":1.0},"60":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"o":{"a":{"df":0,"docs":{},"l":{"df":2,"docs":{"28":{"tf":1.0},"32":{"tf":1.0}}}},"df":1,"docs":{"0":{"tf":1.0}},"e":{"df":1,"docs":{"65":{"tf":1.0}}}},"r":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":2,"docs":{"55":{"tf":1.0},"71":{"tf":1.0}}}},"df":0,"docs":{}}}},"h":{"a":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"71":{"tf":1.0}}}},"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"l":{"df":4,"docs":{"45":{"tf":1.0},"46":{"tf":1.0},"47":{"tf":1.0},"69":{"tf":1.0}}}},"df":0,"docs":{}},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"28":{"tf":1.0}}}}}},"r":{"d":{"df":1,"docs":{"67":{"tf":1.0}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"h":{"df":11,"docs":{"45":{"tf":1.0},"46":{"tf":1.0},"47":{"tf":1.0},"48":{"tf":1.0},"49":{"tf":1.0},"50":{"tf":1.0},"51":{"tf":1.0},"53":{"tf":1.0},"54":{"tf":1.0},"55":{"tf":1.4142135623730951},"58":{"tf":1.0}}}},"v":{"df":0,"docs":{},"e":{"df":5,"docs":{"18":{"tf":1.0},"30":{"tf":1.0},"33":{"tf":1.0},"66":{"tf":1.0},"67":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"a":{"d":{"df":2,"docs":{"19":{"tf":1.4142135623730951},"56":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"65":{"tf":1.0},"68":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":1,"docs":{"19":{"tf":1.4142135623730951}}}},"p":{"df":3,"docs":{"21":{"tf":1.0},"31":{"tf":1.0},"33":{"tf":1.0}}}},"r":{"df":0,"docs":{},"e":{".":{".":{">":{"<":{"/":{"df":0,"docs":{},"s":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"53":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":3,"docs":{"20":{"tf":1.0},"43":{"tf":1.0},"65":{"tf":1.0}}}}},"i":{"d":{"df":0,"docs":{},"e":{"df":1,"docs":{"32":{"tf":1.0}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"df":4,"docs":{"38":{"tf":1.4142135623730951},"39":{"tf":1.4142135623730951},"40":{"tf":2.449489742783178},"41":{"tf":1.7320508075688772}},"s":{".":{"<":{"df":0,"docs":{},"o":{"df":1,"docs":{"41":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"56":{"tf":1.0},"67":{"tf":1.0}}}},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"17":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"=":{"\"":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"/":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"/":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"55":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"{":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"43":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":9,"docs":{"44":{"tf":1.0},"45":{"tf":1.0},"46":{"tf":1.0},"47":{"tf":1.0},"48":{"tf":1.0},"49":{"tf":1.0},"50":{"tf":1.0},"51":{"tf":1.0},"56":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":14,"docs":{"0":{"tf":1.0},"19":{"tf":1.7320508075688772},"20":{"tf":1.0},"39":{"tf":1.4142135623730951},"40":{"tf":1.0},"43":{"tf":1.7320508075688772},"44":{"tf":1.4142135623730951},"45":{"tf":1.0},"46":{"tf":1.0},"47":{"tf":1.0},"49":{"tf":1.0},"53":{"tf":2.6457513110645907},"55":{"tf":1.7320508075688772},"56":{"tf":1.0}}}},"t":{"df":0,"docs":{},"p":{":":{"/":{"/":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"/":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"/":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":1,"docs":{"67":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"c":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{":":{"9":{"0":{"0":{"0":{"/":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"i":{"df":1,"docs":{"69":{"tf":1.0}}}}},"df":0,"docs":{}},"df":2,"docs":{"69":{"tf":1.0},"70":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":2,"docs":{"20":{"tf":1.0},"69":{"tf":1.7320508075688772}},"s":{":":{"/":{"/":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"u":{"b":{".":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"/":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"k":{"df":3,"docs":{"64":{"tf":1.0},"65":{"tf":1.0},"8":{"tf":1.7320508075688772}}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"w":{"df":0,"docs":{},"w":{"df":0,"docs":{},"w":{".":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"3":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"i":{".":{"df":1,"docs":{"41":{"tf":1.0}}},"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"48":{"tf":1.4142135623730951}}}}},"d":{"df":1,"docs":{"37":{"tf":1.0}},"e":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"32":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":2,"docs":{"33":{"tf":1.0},"70":{"tf":1.0}}}}}},"m":{"a":{"df":0,"docs":{},"g":{"df":3,"docs":{"0":{"tf":1.0},"48":{"tf":1.0},"55":{"tf":2.449489742783178}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"i":{"df":1,"docs":{"40":{"tf":1.0}}}},"df":0,"docs":{}}},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"57":{"tf":1.0},"71":{"tf":1.0}}}}}}},"i":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"44":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":5,"docs":{"28":{"tf":1.0},"32":{"tf":1.0},"44":{"tf":2.0},"46":{"tf":1.0},"65":{"tf":1.0}}}}}}},"n":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"d":{"df":11,"docs":{"28":{"tf":1.4142135623730951},"31":{"tf":1.0},"37":{"tf":1.0},"44":{"tf":1.0},"45":{"tf":1.0},"46":{"tf":1.0},"47":{"tf":1.0},"53":{"tf":1.0},"55":{"tf":1.0},"60":{"tf":1.0},"69":{"tf":1.0}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"44":{"tf":1.0}}}}}}}}},"df":0,"docs":{}}}},"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"62":{"tf":1.0}}},"df":0,"docs":{}}}},"x":{".":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":6,"docs":{"18":{"tf":1.0},"19":{"tf":1.4142135623730951},"22":{"tf":1.0},"40":{"tf":1.0},"49":{"tf":1.0},"61":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"i":{"c":{"df":1,"docs":{"40":{"tf":1.0}}},"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"d":{"df":0,"docs":{},"u":{"df":1,"docs":{"57":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"49":{"tf":1.0}}}},"o":{"df":1,"docs":{"44":{"tf":1.0}},"r":{"df":0,"docs":{},"m":{"df":4,"docs":{"17":{"tf":1.0},"27":{"tf":1.0},"36":{"tf":1.0},"60":{"tf":1.0}}}}}},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"65":{"tf":1.0}},"i":{"df":7,"docs":{"19":{"tf":1.0},"44":{"tf":1.4142135623730951},"61":{"tf":1.7320508075688772},"62":{"tf":1.4142135623730951},"63":{"tf":1.0},"64":{"tf":1.0},"65":{"tf":2.6457513110645907}}}}},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"65":{"tf":1.0}}}},"df":0,"docs":{}}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":3,"docs":{"45":{"tf":1.4142135623730951},"47":{"tf":1.4142135623730951},"49":{"tf":1.4142135623730951}}}}},"s":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"69":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}},"i":{"d":{"df":9,"docs":{"19":{"tf":1.4142135623730951},"44":{"tf":1.0},"45":{"tf":1.0},"46":{"tf":1.0},"47":{"tf":1.0},"48":{"tf":1.0},"50":{"tf":1.0},"51":{"tf":1.0},"53":{"tf":1.0}}},"df":0,"docs":{}},"t":{"a":{"df":0,"docs":{},"l":{"df":13,"docs":{"1":{"tf":1.0},"10":{"tf":1.0},"12":{"tf":1.4142135623730951},"14":{"tf":1.4142135623730951},"15":{"tf":1.4142135623730951},"16":{"tf":1.0},"3":{"tf":2.0},"4":{"tf":2.0},"5":{"tf":1.4142135623730951},"6":{"tf":1.4142135623730951},"7":{"tf":1.7320508075688772},"8":{"tf":2.449489742783178},"9":{"tf":1.7320508075688772}}},"n":{"c":{"df":3,"docs":{"63":{"tf":1.0},"64":{"tf":1.0},"65":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"a":{"d":{"df":5,"docs":{"31":{"tf":1.0},"44":{"tf":2.0},"45":{"tf":1.0},"47":{"tf":1.0},"56":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":4,"docs":{"22":{"tf":1.0},"3":{"tf":1.0},"44":{"tf":2.449489742783178},"56":{"tf":1.0}}}},"df":0,"docs":{}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"df":6,"docs":{"44":{"tf":1.4142135623730951},"45":{"tf":1.4142135623730951},"46":{"tf":1.4142135623730951},"47":{"tf":1.4142135623730951},"48":{"tf":1.4142135623730951},"58":{"tf":1.7320508075688772}}}},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"j":{"df":1,"docs":{"37":{"tf":1.4142135623730951}}}}}},"r":{"df":0,"docs":{},"f":{"a":{"c":{"df":2,"docs":{"20":{"tf":1.0},"60":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"60":{"tf":1.0}}}}}}}},"r":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"0":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"69":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"n":{"'":{"df":0,"docs":{},"t":{"df":2,"docs":{"38":{"tf":1.0},"67":{"tf":1.0}}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"u":{"df":3,"docs":{"57":{"tf":1.0},"61":{"tf":1.0},"71":{"tf":1.0}}}}},"t":{"'":{"df":1,"docs":{"67":{"tf":1.0}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":5,"docs":{"19":{"tf":1.0},"3":{"tf":1.0},"55":{"tf":1.0},"57":{"tf":1.0},"61":{"tf":1.0}}}}}}}},"j":{"a":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"s":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":7,"docs":{"20":{"tf":1.0},"44":{"tf":1.4142135623730951},"49":{"tf":1.4142135623730951},"60":{"tf":2.23606797749979},"61":{"tf":1.0},"64":{"tf":1.0},"65":{"tf":1.7320508075688772}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{},"s":{"df":3,"docs":{"0":{"tf":1.0},"49":{"tf":1.0},"54":{"tf":1.7320508075688772}},"o":{"df":0,"docs":{},"n":{"df":4,"docs":{"30":{"tf":1.0},"32":{"tf":1.4142135623730951},"34":{"tf":1.0},"37":{"tf":1.4142135623730951}}}}}},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":4,"docs":{"13":{"tf":1.0},"32":{"tf":1.4142135623730951},"44":{"tf":1.0},"67":{"tf":1.4142135623730951}}}},"y":{"df":1,"docs":{"41":{"tf":1.0}}}},"n":{"df":0,"docs":{},"o":{"b":{"df":0,"docs":{},"s":{"/":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"67":{"tf":1.0}}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{},"w":{"df":3,"docs":{"33":{"tf":1.0},"56":{"tf":1.0},"71":{"tf":1.0}},"n":{"df":1,"docs":{"57":{"tf":1.0}}}}}}},"l":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{".":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"/":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"/":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"3":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"=":{"\"":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"19":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"38":{"tf":1.0}}}},"df":0,"docs":{}}},"y":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"28":{"tf":1.4142135623730951}}}},"m":{"a":{"df":0,"docs":{},"n":{"'":{"df":1,"docs":{"0":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"t":{"df":1,"docs":{"69":{"tf":1.0}}}},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"65":{"tf":1.0}}}}}},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":1,"docs":{"20":{"tf":1.0}}}}},"t":{"df":1,"docs":{"71":{"tf":1.0}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":4,"docs":{"31":{"tf":1.0},"33":{"tf":1.0},"44":{"tf":1.4142135623730951},"57":{"tf":1.0}}},"r":{"a":{"df":0,"docs":{},"g":{"df":2,"docs":{"22":{"tf":1.0},"32":{"tf":1.0}}}},"df":0,"docs":{}}}}},"i":{"b":{".":{"df":0,"docs":{},"r":{"df":1,"docs":{"66":{"tf":1.0}}}},"df":1,"docs":{"66":{"tf":1.0}},"r":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":2,"docs":{"44":{"tf":1.0},"66":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":1,"docs":{"67":{"tf":1.0}}}},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"30":{"tf":1.0}}}}},"n":{"df":0,"docs":{},"e":{"df":7,"docs":{"17":{"tf":1.4142135623730951},"28":{"tf":1.4142135623730951},"3":{"tf":1.0},"31":{"tf":2.0},"32":{"tf":1.0},"5":{"tf":1.0},"57":{"tf":1.0}}},"k":{"df":7,"docs":{"43":{"tf":2.23606797749979},"44":{"tf":1.4142135623730951},"45":{"tf":1.7320508075688772},"46":{"tf":1.4142135623730951},"47":{"tf":1.7320508075688772},"55":{"tf":2.0},"67":{"tf":1.0}}},"u":{"df":0,"docs":{},"x":{"df":1,"docs":{"41":{"tf":1.7320508075688772}}}}},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"43":{"tf":1.0},"44":{"tf":1.0}},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"69":{"tf":1.4142135623730951}}}}}},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":1,"docs":{"32":{"tf":1.0}}}}}},"o":{"a":{"d":{"df":8,"docs":{"19":{"tf":1.0},"28":{"tf":1.0},"29":{"tf":1.0},"31":{"tf":1.0},"44":{"tf":2.449489742783178},"62":{"tf":1.0},"63":{"tf":1.0},"65":{"tf":2.0}},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"44":{"tf":1.4142135623730951},"65":{"tf":1.0}}}}},"df":0,"docs":{}},"c":{"a":{"df":0,"docs":{},"l":{"df":4,"docs":{"29":{"tf":1.0},"46":{"tf":1.0},"69":{"tf":1.0},"9":{"tf":1.7320508075688772}}},"t":{"df":4,"docs":{"28":{"tf":1.0},"29":{"tf":1.0},"56":{"tf":1.0},"67":{"tf":1.0}}}},"df":0,"docs":{},"k":{"df":1,"docs":{"7":{"tf":1.0}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"65":{"tf":1.0}}}}}},"o":{"df":0,"docs":{},"k":{"df":5,"docs":{"43":{"tf":1.0},"44":{"tf":1.7320508075688772},"46":{"tf":1.0},"53":{"tf":1.0},"67":{"tf":1.0}}}}}},"m":{"a":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"4":{"tf":1.0}}}}},"o":{"df":1,"docs":{"41":{"tf":1.4142135623730951}}}},"d":{"df":0,"docs":{},"e":{"df":1,"docs":{"32":{"tf":1.0}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"67":{"tf":1.0}}},"df":0,"docs":{}}},"i":{"df":0,"docs":{},"n":{"df":4,"docs":{"19":{"tf":1.0},"44":{"tf":2.0},"66":{"tf":1.0},"8":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"18":{"tf":1.0}}}}}},"k":{"df":0,"docs":{},"e":{"df":1,"docs":{"44":{"tf":1.0}}}},"n":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"13":{"tf":1.0}}}},"df":0,"docs":{},"i":{"df":1,"docs":{"67":{"tf":1.0}}},"u":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"20":{"tf":1.0}}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"k":{"df":1,"docs":{"32":{"tf":1.0}}}},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":1,"docs":{"28":{"tf":1.0}}}}}},"t":{"c":{"df":0,"docs":{},"h":{"df":2,"docs":{"12":{"tf":1.0},"69":{"tf":1.0}}}},"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"55":{"tf":1.0}}}}},"x":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":1,"docs":{"22":{"tf":1.0}}}}}}},"y":{"b":{"df":1,"docs":{"20":{"tf":1.0}}},"df":0,"docs":{}}},"df":1,"docs":{"57":{"tf":1.0}},"e":{"a":{"df":0,"docs":{},"n":{"df":3,"docs":{"30":{"tf":1.0},"44":{"tf":1.0},"67":{"tf":1.0}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"28":{"tf":1.0}}}}}}},"t":{"a":{"d":{"a":{"df":0,"docs":{},"t":{"a":{"df":1,"docs":{"29":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":1,"docs":{"19":{"tf":1.0}}},"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"d":{"df":1,"docs":{"65":{"tf":1.0}}},"df":0,"docs":{}}}}},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"32":{"tf":1.0}}}},"df":0,"docs":{}}},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":5,"docs":{"46":{"tf":1.7320508075688772},"47":{"tf":1.4142135623730951},"48":{"tf":1.4142135623730951},"53":{"tf":1.4142135623730951},"57":{"tf":2.23606797749979}},"i":{"df":5,"docs":{"46":{"tf":1.0},"47":{"tf":1.0},"48":{"tf":1.0},"53":{"tf":1.0},"57":{"tf":2.8284271247461903}}}}}},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"32":{"tf":1.0}}}}},"j":{"df":1,"docs":{"49":{"tf":1.0}}},"k":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"69":{"tf":1.0}}}}}},"df":0,"docs":{}},"o":{"d":{"df":0,"docs":{},"e":{"df":1,"docs":{"44":{"tf":2.449489742783178}},"l":{"df":2,"docs":{"30":{"tf":1.4142135623730951},"34":{"tf":1.0}}}},"i":{"df":0,"docs":{},"f":{"df":2,"docs":{"46":{"tf":1.0},"53":{"tf":1.0}}}},"u":{"df":0,"docs":{},"l":{"df":3,"docs":{"44":{"tf":1.4142135623730951},"49":{"tf":1.0},"65":{"tf":1.4142135623730951}}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":10,"docs":{"12":{"tf":1.0},"20":{"tf":1.7320508075688772},"32":{"tf":1.0},"44":{"tf":1.0},"46":{"tf":1.0},"52":{"tf":1.0},"59":{"tf":1.0},"60":{"tf":1.0},"67":{"tf":1.0},"71":{"tf":1.0}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"67":{"tf":1.0}}}}}},"v":{"df":0,"docs":{},"e":{"df":2,"docs":{"30":{"tf":1.0},"32":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":3,"docs":{"41":{"tf":1.0},"44":{"tf":1.4142135623730951},"70":{"tf":1.7320508075688772}}}}}}}},"y":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"65":{"tf":1.0}}}}}}}}},"n":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":5,"docs":{"31":{"tf":1.0},"40":{"tf":1.0},"44":{"tf":3.1622776601683795},"60":{"tf":1.0},"67":{"tf":1.0}}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":1,"docs":{"6":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":2,"docs":{"60":{"tf":1.0},"67":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"e":{"d":{"df":8,"docs":{"2":{"tf":1.0},"32":{"tf":1.7320508075688772},"36":{"tf":1.0},"37":{"tf":1.0},"38":{"tf":1.0},"55":{"tf":1.0},"56":{"tf":1.0},"66":{"tf":1.0}}},"df":0,"docs":{}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"57":{"tf":1.7320508075688772}}}}},"w":{"df":4,"docs":{"19":{"tf":1.0},"23":{"tf":1.0},"33":{"tf":1.0},"39":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"17":{"tf":1.0},"32":{"tf":1.0}}}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"19":{"tf":1.0}}}}},"x":{"df":0,"docs":{},"t":{"df":2,"docs":{"20":{"tf":1.0},"32":{"tf":1.0}}}}},"i":{"c":{"df":0,"docs":{},"e":{"df":3,"docs":{"26":{"tf":1.0},"46":{"tf":1.0},"55":{"tf":1.0}}}},"df":0,"docs":{},"x":{"df":1,"docs":{"16":{"tf":1.7320508075688772}}}},"o":{"df":0,"docs":{},"n":{"df":2,"docs":{"17":{"tf":1.0},"53":{"tf":1.0}},"e":{"df":2,"docs":{"40":{"tf":1.0},"58":{"tf":1.0}}}},"r":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"l":{"df":2,"docs":{"11":{"tf":1.0},"55":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"e":{"df":5,"docs":{"19":{"tf":1.0},"33":{"tf":1.0},"39":{"tf":1.0},"55":{"tf":1.0},"62":{"tf":1.0}}}},"w":{"df":5,"docs":{"28":{"tf":1.4142135623730951},"32":{"tf":1.0},"33":{"tf":1.0},"65":{"tf":1.0},"67":{"tf":1.4142135623730951}}}},"u":{"df":0,"docs":{},"m":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"65":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}}},"o":{"b":{"df":0,"docs":{},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"44":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"35":{"tf":1.0}}}}},"df":0,"docs":{}},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":1,"docs":{"3":{"tf":1.0}}}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"i":{"df":3,"docs":{"45":{"tf":1.0},"47":{"tf":1.0},"69":{"tf":1.0}}}},"df":0,"docs":{}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"2":{"tf":1.0}}}}}}},"l":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"32":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}},"n":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"s":{"df":1,"docs":{"57":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"c":{"df":1,"docs":{"3":{"tf":1.0}},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"65":{"tf":1.0}}}}}}}}},"df":7,"docs":{"17":{"tf":1.0},"32":{"tf":1.0},"40":{"tf":1.0},"41":{"tf":2.0},"43":{"tf":1.0},"44":{"tf":1.7320508075688772},"67":{"tf":1.7320508075688772}},"f":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"65":{"tf":1.0}}}}}}},"df":0,"docs":{}},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"65":{"tf":1.0}}}}}}}}}},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"65":{"tf":1.0}}}}},"df":0,"docs":{}},"u":{"c":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"65":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"p":{"a":{"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":1,"docs":{"57":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":2,"docs":{"19":{"tf":1.0},"71":{"tf":1.4142135623730951}},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"l":{"df":1,"docs":{"6":{"tf":1.0}}}}}},"r":{"df":1,"docs":{"3":{"tf":1.0}}}},"t":{"'":{"df":1,"docs":{"44":{"tf":1.0}}},"=":{"\"":{"0":{"df":1,"docs":{"44":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":6,"docs":{"44":{"tf":2.449489742783178},"46":{"tf":1.0},"47":{"tf":1.0},"48":{"tf":1.0},"53":{"tf":1.0},"57":{"tf":1.0}},"i":{"df":0,"docs":{},"m":{"df":1,"docs":{"44":{"tf":2.0}}},"o":{"df":0,"docs":{},"n":{"df":15,"docs":{"0":{"tf":1.0},"31":{"tf":1.0},"40":{"tf":1.0},"41":{"tf":1.0},"43":{"tf":1.4142135623730951},"44":{"tf":5.291502622129181},"45":{"tf":1.7320508075688772},"46":{"tf":1.7320508075688772},"47":{"tf":2.0},"48":{"tf":1.7320508075688772},"49":{"tf":1.0},"50":{"tf":1.0},"51":{"tf":1.0},"53":{"tf":1.7320508075688772},"70":{"tf":1.0}}}}}}},"r":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":4,"docs":{"39":{"tf":1.0},"40":{"tf":1.0},"61":{"tf":1.0},"66":{"tf":1.0}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":3,"docs":{"19":{"tf":1.0},"44":{"tf":1.0},"67":{"tf":1.0}}}}}}},"s":{"df":2,"docs":{"16":{"tf":1.0},"41":{"tf":2.0}}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"29":{"tf":1.0}}}}}}}}},"u":{"df":0,"docs":{},"t":{"df":9,"docs":{"0":{"tf":1.0},"26":{"tf":1.0},"27":{"tf":1.0},"46":{"tf":1.0},"47":{"tf":1.0},"48":{"tf":1.0},"53":{"tf":1.0},"57":{"tf":1.0},"9":{"tf":1.0}},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":10,"docs":{"43":{"tf":1.0},"44":{"tf":1.7320508075688772},"45":{"tf":1.0},"46":{"tf":1.0},"47":{"tf":1.0},"48":{"tf":1.0},"50":{"tf":1.0},"51":{"tf":1.0},"53":{"tf":1.4142135623730951},"56":{"tf":1.0}}}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"55":{"tf":1.0},"69":{"tf":1.0}},"r":{"df":0,"docs":{},"i":{"d":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":3,"docs":{"28":{"tf":1.4142135623730951},"31":{"tf":1.0},"58":{"tf":1.0}}}}},"df":4,"docs":{"28":{"tf":1.0},"31":{"tf":1.0},"41":{"tf":1.7320508075688772},"44":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":1,"docs":{"39":{"tf":1.0}}}}}}}}}},"p":{"a":{"c":{"df":0,"docs":{},"k":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"5":{"tf":1.0}},"e":{".":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"a":{"d":{"a":{"df":0,"docs":{},"t":{"a":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"k":{".":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"d":{"df":1,"docs":{"30":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"v":{"df":1,"docs":{"30":{"tf":1.0}}}}}}},"df":1,"docs":{"30":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"/":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":1,"docs":{"61":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"r":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":1,"docs":{"39":{"tf":1.4142135623730951}}}}}},"m":{"df":1,"docs":{"44":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"t":{"df":2,"docs":{"68":{"tf":1.0},"69":{"tf":1.0}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"44":{"tf":1.4142135623730951}}}}},"s":{"df":1,"docs":{"39":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"28":{"tf":1.0}}}}},"t":{"df":1,"docs":{"31":{"tf":1.0}}}},"s":{"df":0,"docs":{},"s":{"df":4,"docs":{"40":{"tf":1.0},"56":{"tf":1.0},"68":{"tf":1.0},"69":{"tf":1.0}}}},"t":{"df":0,"docs":{},"h":{"/":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":1,"docs":{"67":{"tf":1.0}}}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"/":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"35":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":13,"docs":{"31":{"tf":1.0},"40":{"tf":2.23606797749979},"44":{"tf":2.449489742783178},"45":{"tf":2.0},"46":{"tf":2.0},"47":{"tf":2.0},"48":{"tf":2.0},"50":{"tf":2.0},"51":{"tf":2.0},"53":{"tf":2.0},"67":{"tf":2.8284271247461903},"69":{"tf":1.7320508075688772},"9":{"tf":1.0}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":4,"docs":{"0":{"tf":1.0},"12":{"tf":1.4142135623730951},"46":{"tf":1.4142135623730951},"55":{"tf":1.0}}}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"57":{"tf":1.0}},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":8,"docs":{"17":{"tf":1.0},"20":{"tf":1.0},"38":{"tf":1.0},"41":{"tf":1.0},"49":{"tf":1.0},"50":{"tf":1.0},"51":{"tf":1.0},"57":{"tf":1.0}}}}}},"i":{"df":0,"docs":{},"o":{"d":{"df":1,"docs":{"65":{"tf":1.0}}},"df":0,"docs":{}}}}},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":5,"docs":{"22":{"tf":1.0},"38":{"tf":1.0},"40":{"tf":1.0},"43":{"tf":1.0},"53":{"tf":1.0}}}}}}}},"l":{"a":{"c":{"df":0,"docs":{},"e":{"df":10,"docs":{"39":{"tf":1.7320508075688772},"44":{"tf":1.4142135623730951},"45":{"tf":1.4142135623730951},"46":{"tf":1.4142135623730951},"47":{"tf":1.4142135623730951},"48":{"tf":1.4142135623730951},"50":{"tf":1.4142135623730951},"51":{"tf":1.4142135623730951},"53":{"tf":1.4142135623730951},"67":{"tf":1.0}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":6,"docs":{"44":{"tf":1.4142135623730951},"45":{"tf":1.0},"46":{"tf":1.0},"47":{"tf":1.0},"48":{"tf":1.0},"67":{"tf":1.0}}}},"n":{"df":1,"docs":{"39":{"tf":1.0}}},"t":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":1,"docs":{"11":{"tf":1.0}}}}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"s":{"df":3,"docs":{"39":{"tf":1.0},"55":{"tf":1.0},"71":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":6,"docs":{"18":{"tf":1.0},"40":{"tf":1.0},"45":{"tf":1.0},"46":{"tf":1.0},"47":{"tf":1.0},"53":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"20":{"tf":1.0}}}}}}},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"30":{"tf":1.7320508075688772}}}},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"l":{"df":6,"docs":{"33":{"tf":1.0},"44":{"tf":1.4142135623730951},"57":{"tf":1.4142135623730951},"65":{"tf":1.0},"66":{"tf":1.0},"67":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"t":{"_":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"d":{"df":2,"docs":{"39":{"tf":1.0},"40":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"w":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"22":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"e":{"_":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"d":{"df":2,"docs":{"39":{"tf":1.0},"40":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"c":{"df":0,"docs":{},"e":{"d":{"df":1,"docs":{"70":{"tf":1.0}}},"df":0,"docs":{}}},"df":7,"docs":{"10":{"tf":1.4142135623730951},"12":{"tf":1.0},"17":{"tf":1.0},"2":{"tf":1.4142135623730951},"32":{"tf":1.0},"33":{"tf":1.0},"5":{"tf":1.0}},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"x":{"df":2,"docs":{"67":{"tf":1.4142135623730951},"69":{"tf":1.7320508075688772}}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":9,"docs":{"44":{"tf":1.0},"45":{"tf":1.0},"46":{"tf":1.0},"47":{"tf":1.0},"48":{"tf":1.0},"49":{"tf":1.0},"50":{"tf":1.0},"51":{"tf":1.0},"53":{"tf":1.0}}}},"r":{"df":0,"docs":{},"v":{"df":1,"docs":{"44":{"tf":1.0}}}}}},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"19":{"tf":1.0}}}}},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":1,"docs":{"65":{"tf":1.0}}}}}}},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"22":{"tf":1.0}}}}},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"26":{"tf":1.0},"27":{"tf":1.0}}}},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"33":{"tf":1.0}}}}},"o":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"d":{"df":1,"docs":{"40":{"tf":1.0}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"s":{"df":16,"docs":{"11":{"tf":1.0},"13":{"tf":1.0},"20":{"tf":1.0},"38":{"tf":1.0},"39":{"tf":1.0},"4":{"tf":1.0},"40":{"tf":1.4142135623730951},"42":{"tf":1.0},"43":{"tf":1.0},"45":{"tf":1.0},"46":{"tf":1.0},"47":{"tf":1.0},"53":{"tf":1.4142135623730951},"57":{"tf":1.4142135623730951},"6":{"tf":1.0},"65":{"tf":2.0}}}}}},"d":{"df":0,"docs":{},"u":{"c":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":2,"docs":{"40":{"tf":1.0},"44":{"tf":2.8284271247461903}}}}},"g":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":2,"docs":{"65":{"tf":1.0},"71":{"tf":1.0}}}}}}},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":13,"docs":{"1":{"tf":1.0},"18":{"tf":1.4142135623730951},"19":{"tf":2.449489742783178},"20":{"tf":1.0},"27":{"tf":1.0},"28":{"tf":1.0},"29":{"tf":1.4142135623730951},"3":{"tf":1.4142135623730951},"31":{"tf":1.0},"32":{"tf":1.0},"33":{"tf":1.0},"44":{"tf":2.449489742783178},"66":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"v":{"df":0,"docs":{},"i":{"d":{"df":7,"docs":{"34":{"tf":1.0},"36":{"tf":1.4142135623730951},"40":{"tf":1.0},"41":{"tf":1.0},"44":{"tf":1.0},"65":{"tf":1.0},"67":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"x":{"df":0,"docs":{},"i":{"df":4,"docs":{"67":{"tf":1.7320508075688772},"68":{"tf":2.23606797749979},"69":{"tf":5.0990195135927845},"70":{"tf":2.6457513110645907}}}}}},"u":{"b":{"df":1,"docs":{"66":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"c":{"df":3,"docs":{"40":{"tf":1.0},"56":{"tf":2.0},"67":{"tf":3.1622776601683795}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"11":{"tf":1.0}}}}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":1,"docs":{"71":{"tf":1.4142135623730951}}}},"r":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":1,"docs":{"39":{"tf":1.0}}}}}}}},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":2,"docs":{"68":{"tf":1.0},"69":{"tf":1.0}}}}}}},"r":{"df":0,"docs":{},"e":{"a":{"d":{"df":1,"docs":{"39":{"tf":1.0}},"i":{"df":1,"docs":{"54":{"tf":1.0}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":3,"docs":{"28":{"tf":1.4142135623730951},"3":{"tf":1.0},"67":{"tf":1.4142135623730951}}}}}},"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":2,"docs":{"65":{"tf":1.4142135623730951},"69":{"tf":1.7320508075688772}}}},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"13":{"tf":1.0},"8":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"44":{"tf":1.0}}},"df":0,"docs":{}}}}}},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":1,"docs":{"51":{"tf":1.0}}}}}},"d":{"df":0,"docs":{},"u":{"c":{"df":1,"docs":{"44":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"f":{"df":1,"docs":{"44":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":3,"docs":{"37":{"tf":1.0},"44":{"tf":1.7320508075688772},"55":{"tf":1.0}},"e":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"55":{"tf":1.0}}},"df":0,"docs":{}}}}}},"l":{"=":{"\"":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"i":{"df":3,"docs":{"50":{"tf":1.0},"51":{"tf":1.0},"55":{"tf":1.4142135623730951}}}}},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"46":{"tf":1.0}}}}},"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"48":{"tf":1.0}}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"49":{"tf":1.0}}}}}}},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"44":{"tf":1.0}}}}}},"s":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"45":{"tf":1.0}}}}},"c":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"45":{"tf":1.0}}}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":2,"docs":{"45":{"tf":1.0},"47":{"tf":1.0}}}}}}}}}}}},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"47":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"{":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":1,"docs":{"43":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}},"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"69":{"tf":1.0}}}},"df":12,"docs":{"29":{"tf":1.0},"31":{"tf":1.0},"44":{"tf":1.0},"45":{"tf":1.0},"46":{"tf":1.0},"47":{"tf":1.0},"48":{"tf":1.0},"50":{"tf":1.0},"51":{"tf":1.0},"53":{"tf":1.0},"56":{"tf":1.4142135623730951},"67":{"tf":1.4142135623730951}},"e":{"a":{"df":0,"docs":{},"s":{"df":13,"docs":{"10":{"tf":1.0},"11":{"tf":1.7320508075688772},"12":{"tf":1.0},"13":{"tf":1.4142135623730951},"17":{"tf":1.0},"28":{"tf":1.0},"32":{"tf":1.0},"33":{"tf":1.0},"40":{"tf":1.0},"44":{"tf":2.449489742783178},"57":{"tf":1.0},"6":{"tf":1.0},"7":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"v":{"df":1,"docs":{"40":{"tf":1.0}}}},"o":{"a":{"d":{"df":1,"docs":{"67":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"v":{"df":2,"docs":{"32":{"tf":1.0},"55":{"tf":1.0}}}}},"n":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"61":{"tf":1.0}}}}},"df":0,"docs":{}},"p":{"df":0,"docs":{},"l":{"a":{"c":{"df":3,"docs":{"39":{"tf":1.0},"43":{"tf":1.0},"53":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"o":{"df":1,"docs":{"70":{"tf":1.0}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"9":{"tf":1.0}}}}}}}}}},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":4,"docs":{"20":{"tf":1.0},"68":{"tf":1.0},"69":{"tf":2.6457513110645907},"71":{"tf":1.4142135623730951}}}}},"i":{"df":0,"docs":{},"r":{"df":12,"docs":{"1":{"tf":1.0},"2":{"tf":1.0},"27":{"tf":1.0},"3":{"tf":1.0},"33":{"tf":1.7320508075688772},"4":{"tf":1.0},"40":{"tf":1.4142135623730951},"41":{"tf":1.0},"43":{"tf":1.0},"54":{"tf":1.0},"65":{"tf":1.0},"70":{"tf":1.0}}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"2":{"tf":1.4142135623730951}}}}}}}},"s":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"40":{"tf":1.0}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"v":{"df":3,"docs":{"29":{"tf":1.0},"31":{"tf":1.0},"46":{"tf":1.0}}}},"u":{"df":0,"docs":{},"r":{"c":{"df":8,"docs":{"44":{"tf":1.4142135623730951},"45":{"tf":1.0},"46":{"tf":1.0},"47":{"tf":1.0},"48":{"tf":1.0},"55":{"tf":2.0},"58":{"tf":1.4142135623730951},"67":{"tf":1.0}}},"df":0,"docs":{}}}},"t":{"df":3,"docs":{"45":{"tf":1.0},"47":{"tf":1.0},"54":{"tf":1.0}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":1,"docs":{"67":{"tf":1.0}}}}}},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":2,"docs":{"40":{"tf":1.0},"65":{"tf":1.4142135623730951}}}}}},"v":{"df":1,"docs":{"8":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":2,"docs":{"67":{"tf":1.4142135623730951},"69":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":1,"docs":{"71":{"tf":1.0}}}}}},"w":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":2,"docs":{"69":{"tf":1.4142135623730951},"70":{"tf":1.4142135623730951}},"e":{"=":{"/":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"i":{"df":1,"docs":{"69":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"69":{"tf":1.0}}}}}}}}}},"l":{"df":0,"docs":{},"i":{"b":{"df":1,"docs":{"66":{"tf":1.0}}},"df":0,"docs":{}}},"o":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"54":{"tf":1.0}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":13,"docs":{"19":{"tf":1.0},"29":{"tf":1.4142135623730951},"31":{"tf":1.0},"33":{"tf":1.0},"44":{"tf":1.0},"45":{"tf":1.0},"46":{"tf":1.0},"47":{"tf":1.0},"48":{"tf":1.0},"50":{"tf":1.0},"51":{"tf":1.0},"53":{"tf":1.0},"67":{"tf":1.0}}}},"u":{"df":0,"docs":{},"t":{"df":2,"docs":{"56":{"tf":1.0},"69":{"tf":1.0}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"37":{"tf":1.0}}}}}},"s":{"/":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"k":{"/":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"/":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"/":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"/":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"65":{"tf":1.0}}}}}}},"v":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"a":{"df":1,"docs":{"64":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":1,"docs":{"8":{"tf":1.7320508075688772}}}}}}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":2,"docs":{"43":{"tf":1.0},"53":{"tf":1.0}}}},"n":{"df":13,"docs":{"12":{"tf":1.0},"18":{"tf":1.0},"19":{"tf":1.0},"2":{"tf":1.0},"22":{"tf":1.4142135623730951},"35":{"tf":1.0},"44":{"tf":1.4142135623730951},"57":{"tf":1.0},"60":{"tf":1.0},"64":{"tf":1.4142135623730951},"65":{"tf":1.0},"66":{"tf":1.0},"68":{"tf":1.0}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":2,"docs":{"17":{"tf":1.0},"56":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"t":{"'":{"df":1,"docs":{"22":{"tf":1.0}}},"df":10,"docs":{"0":{"tf":1.0},"19":{"tf":1.4142135623730951},"3":{"tf":2.23606797749979},"37":{"tf":1.0},"4":{"tf":1.4142135623730951},"44":{"tf":2.0},"5":{"tf":1.4142135623730951},"55":{"tf":1.0},"6":{"tf":1.0},"60":{"tf":1.4142135623730951}},"i":{"df":1,"docs":{"0":{"tf":1.0}}},"l":{"df":1,"docs":{"6":{"tf":1.4142135623730951}}},"u":{"df":0,"docs":{},"p":{"df":2,"docs":{"3":{"tf":1.0},"4":{"tf":1.4142135623730951}}}}}}}},"s":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":7,"docs":{"23":{"tf":1.0},"24":{"tf":1.0},"33":{"tf":1.0},"39":{"tf":1.0},"40":{"tf":1.0},"41":{"tf":1.0},"65":{"tf":1.0}}}},"s":{"df":0,"docs":{},"s":{"/":{"df":0,"docs":{},"s":{"c":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":2,"docs":{"45":{"tf":1.7320508075688772},"47":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":1,"docs":{"45":{"tf":1.4142135623730951}}}}},"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"a":{".":{"df":0,"docs":{},"j":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":2,"docs":{"34":{"tf":1.0},"37":{"tf":1.0}}}}}}},"df":5,"docs":{"32":{"tf":1.0},"34":{"tf":1.7320508075688772},"35":{"tf":2.0},"36":{"tf":1.0},"37":{"tf":1.7320508075688772}}},"df":0,"docs":{}}}},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"/":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"x":{"df":1,"docs":{"67":{"tf":1.0}}}}}}}}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{">":{"<":{"/":{"df":0,"docs":{},"s":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"53":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":9,"docs":{"44":{"tf":1.4142135623730951},"45":{"tf":1.0},"46":{"tf":1.0},"47":{"tf":1.0},"48":{"tf":1.0},"49":{"tf":1.4142135623730951},"52":{"tf":1.4142135623730951},"53":{"tf":3.7416573867739413},"64":{"tf":1.4142135623730951}}}}}},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"0":{"tf":1.0}}}}},"df":1,"docs":{"44":{"tf":1.4142135623730951}},"e":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"69":{"tf":1.0}}}}}}}}},"r":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"29":{"tf":1.0}}}},"df":0,"docs":{}}},"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":5,"docs":{"11":{"tf":1.0},"30":{"tf":1.0},"36":{"tf":1.0},"6":{"tf":1.0},"70":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{},"e":{"df":12,"docs":{"44":{"tf":1.4142135623730951},"46":{"tf":1.7320508075688772},"47":{"tf":1.0},"48":{"tf":1.0},"53":{"tf":1.0},"55":{"tf":1.0},"57":{"tf":1.0},"58":{"tf":1.0},"60":{"tf":1.0},"61":{"tf":1.0},"64":{"tf":1.0},"65":{"tf":1.0}}},"g":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"69":{"tf":1.4142135623730951}}}}}}},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"44":{"tf":1.0},"8":{"tf":1.0}}}},"df":0,"docs":{}},"f":{"df":2,"docs":{"53":{"tf":1.0},"69":{"tf":1.4142135623730951}}}},"n":{"df":0,"docs":{},"s":{"df":1,"docs":{"32":{"tf":1.0}}}},"p":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"44":{"tf":1.0}}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"v":{"df":7,"docs":{"19":{"tf":1.4142135623730951},"24":{"tf":1.4142135623730951},"30":{"tf":1.4142135623730951},"55":{"tf":1.0},"67":{"tf":3.605551275463989},"68":{"tf":1.0},"69":{"tf":2.0}},"e":{"df":0,"docs":{},"r":{"df":4,"docs":{"24":{"tf":1.0},"6":{"tf":1.4142135623730951},"65":{"tf":1.0},"69":{"tf":2.0}}}}}},"t":{"df":9,"docs":{"21":{"tf":1.0},"22":{"tf":1.0},"28":{"tf":1.4142135623730951},"29":{"tf":1.0},"32":{"tf":1.0},"44":{"tf":2.6457513110645907},"56":{"tf":1.0},"65":{"tf":1.0},"67":{"tf":1.4142135623730951}},"u":{"df":0,"docs":{},"p":{"df":1,"docs":{"54":{"tf":1.0}}}}}},"h":{"a":{"2":{"5":{"6":{"df":1,"docs":{"58":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"3":{"8":{"4":{"df":6,"docs":{"44":{"tf":1.0},"45":{"tf":1.0},"46":{"tf":1.0},"47":{"tf":1.0},"48":{"tf":1.0},"58":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"5":{"1":{"2":{"df":1,"docs":{"58":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":1,"docs":{"71":{"tf":1.0}}}}},"df":1,"docs":{"41":{"tf":1.0}},"i":{"df":0,"docs":{},"m":{"df":1,"docs":{"44":{"tf":1.4142135623730951}}},"p":{"df":2,"docs":{"21":{"tf":1.0},"68":{"tf":1.0}}}},"o":{"df":0,"docs":{},"w":{"df":3,"docs":{"26":{"tf":1.4142135623730951},"27":{"tf":1.7320508075688772},"31":{"tf":1.0}},"n":{"df":1,"docs":{"17":{"tf":1.0}}}}}},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":1,"docs":{"69":{"tf":1.4142135623730951}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"33":{"tf":1.0}}}}}},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"i":{"df":1,"docs":{"12":{"tf":1.0}}},"l":{"df":4,"docs":{"0":{"tf":1.0},"18":{"tf":1.0},"42":{"tf":1.0},"67":{"tf":2.0}},"i":{"df":2,"docs":{"19":{"tf":1.0},"7":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"40":{"tf":1.0}}}},"df":0,"docs":{}}}}},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"l":{"df":1,"docs":{"67":{"tf":1.0}}}}},"z":{"df":0,"docs":{},"e":{"df":1,"docs":{"44":{"tf":1.0}}}}},"k":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":1,"docs":{"17":{"tf":1.0}}}}},"l":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"67":{"tf":1.0}}}}},"df":0,"docs":{}},"m":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":1,"docs":{"65":{"tf":1.0}}}}},"df":0,"docs":{}},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":7,"docs":{"0":{"tf":1.0},"54":{"tf":1.7320508075688772},"60":{"tf":1.0},"62":{"tf":1.0},"64":{"tf":1.0},"65":{"tf":1.0},"70":{"tf":1.0}}}}}}}},"o":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"6":{"tf":1.7320508075688772}}}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"65":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"20":{"tf":1.0}}}},"u":{"df":0,"docs":{},"r":{"c":{"df":10,"docs":{"0":{"tf":1.0},"3":{"tf":1.0},"40":{"tf":1.0},"44":{"tf":1.4142135623730951},"45":{"tf":1.0},"46":{"tf":1.4142135623730951},"47":{"tf":1.0},"53":{"tf":1.0},"55":{"tf":1.0},"6":{"tf":1.0}}},"df":0,"docs":{}}}},"p":{"a":{"c":{"df":0,"docs":{},"e":{"df":1,"docs":{"44":{"tf":1.0}}}},"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{"df":3,"docs":{"22":{"tf":1.0},"24":{"tf":1.0},"40":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"k":{"df":1,"docs":{"28":{"tf":1.0}}}},"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":3,"docs":{"41":{"tf":1.4142135623730951},"44":{"tf":1.0},"8":{"tf":1.4142135623730951}},"i":{"df":9,"docs":{"40":{"tf":1.0},"41":{"tf":1.4142135623730951},"43":{"tf":1.0},"44":{"tf":2.6457513110645907},"48":{"tf":1.0},"49":{"tf":1.0},"50":{"tf":1.0},"51":{"tf":1.0},"69":{"tf":1.7320508075688772}}}}}},"df":0,"docs":{},"e":{"d":{"df":2,"docs":{"22":{"tf":1.0},"44":{"tf":1.0}}},"df":0,"docs":{}}}},"r":{"c":{"/":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{".":{"df":0,"docs":{},"r":{"df":1,"docs":{"19":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"=":{"\"":{"df":0,"docs":{},"{":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"53":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":1,"docs":{"53":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"l":{"df":1,"docs":{"69":{"tf":1.4142135623730951}}}},"t":{"a":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"6":{"tf":1.0}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":3,"docs":{"38":{"tf":1.0},"39":{"tf":2.0},"40":{"tf":2.449489742783178}}}},"n":{"d":{"a":{"df":0,"docs":{},"r":{"d":{"df":3,"docs":{"4":{"tf":1.0},"5":{"tf":1.4142135623730951},"6":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"r":{"df":1,"docs":{"20":{"tf":1.0}},"t":{"df":12,"docs":{"1":{"tf":1.4142135623730951},"15":{"tf":1.0},"18":{"tf":1.0},"19":{"tf":1.4142135623730951},"3":{"tf":1.0},"33":{"tf":1.0},"57":{"tf":1.0},"61":{"tf":1.0},"62":{"tf":1.0},"64":{"tf":1.0},"65":{"tf":1.0},"71":{"tf":1.4142135623730951}},"u":{"df":0,"docs":{},"p":{"df":3,"docs":{"6":{"tf":1.0},"61":{"tf":1.0},"62":{"tf":1.0}}}}}}},"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"40":{"tf":1.0}}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"40":{"tf":1.0}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":3,"docs":{"20":{"tf":1.0},"39":{"tf":3.3166247903554},"41":{"tf":1.0}}}},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":2,"docs":{"28":{"tf":1.0},"32":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":1,"docs":{"69":{"tf":1.4142135623730951}}}},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"44":{"tf":1.0}}}}}}},"u":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"28":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"y":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":4,"docs":{"45":{"tf":1.0},"46":{"tf":1.0},"47":{"tf":1.0},"49":{"tf":1.0}}}}}},"u":{"b":{"df":2,"docs":{"31":{"tf":1.0},"58":{"tf":1.0}},"s":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"1":{"tf":1.0},"59":{"tf":1.0}}}},"df":0,"docs":{}}}},"c":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"40":{"tf":1.0}},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"65":{"tf":1.4142135623730951}}}}}}}}}}},"df":0,"docs":{},"h":{"df":3,"docs":{"33":{"tf":1.0},"67":{"tf":1.0},"69":{"tf":1.7320508075688772}}}},"d":{"df":0,"docs":{},"o":{"df":1,"docs":{"15":{"tf":1.0}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"i":{"df":1,"docs":{"18":{"tf":1.0}}}},"df":0,"docs":{},"x":{"df":1,"docs":{"44":{"tf":1.0}}}}}},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":13,"docs":{"12":{"tf":1.0},"28":{"tf":1.0},"31":{"tf":1.0},"32":{"tf":1.0},"33":{"tf":1.4142135623730951},"36":{"tf":1.4142135623730951},"37":{"tf":1.0},"38":{"tf":1.0},"55":{"tf":1.0},"57":{"tf":1.0},"6":{"tf":1.0},"65":{"tf":1.0},"67":{"tf":1.0}}}}}}},"r":{"df":0,"docs":{},"e":{"df":1,"docs":{"44":{"tf":1.0}}}}},"v":{"df":0,"docs":{},"g":{"df":1,"docs":{"49":{"tf":1.0}}}},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"h":{"df":3,"docs":{"17":{"tf":1.0},"44":{"tf":1.0},"57":{"tf":1.0}}}},"df":0,"docs":{}}}},"y":{"df":0,"docs":{},"m":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":1,"docs":{"44":{"tf":1.0}}}}},"df":0,"docs":{}},"n":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"x":{"df":1,"docs":{"34":{"tf":1.0}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":5,"docs":{"28":{"tf":1.4142135623730951},"3":{"tf":1.0},"38":{"tf":1.0},"6":{"tf":1.0},"69":{"tf":1.0}}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":1,"docs":{"69":{"tf":1.0}}}}}}},"t":{"a":{"df":0,"docs":{},"g":{"df":6,"docs":{"43":{"tf":1.0},"45":{"tf":1.4142135623730951},"47":{"tf":1.4142135623730951},"49":{"tf":1.7320508075688772},"53":{"tf":2.23606797749979},"8":{"tf":1.7320508075688772}}},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"c":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"47":{"tf":1.0}}}}},"df":1,"docs":{"47":{"tf":1.7320508075688772}}},"df":0,"docs":{}}}}}},"k":{"df":0,"docs":{},"e":{"df":5,"docs":{"32":{"tf":1.0},"39":{"tf":1.7320508075688772},"54":{"tf":1.0},"65":{"tf":1.0},"70":{"tf":1.0}}}},"p":{"df":1,"docs":{"65":{"tf":1.4142135623730951}}},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":11,"docs":{"22":{"tf":1.4142135623730951},"4":{"tf":2.23606797749979},"44":{"tf":2.6457513110645907},"45":{"tf":1.0},"46":{"tf":1.0},"47":{"tf":1.0},"48":{"tf":1.0},"50":{"tf":1.0},"51":{"tf":1.0},"53":{"tf":1.0},"55":{"tf":1.0}}}}}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"28":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":1,"docs":{"0":{"tf":1.0}},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"40":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"26":{"tf":1.0}}}},"x":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"d":{"df":1,"docs":{"19":{"tf":1.0}}},"df":0,"docs":{}}}},"df":1,"docs":{"19":{"tf":1.0}}}}},"h":{"a":{"df":0,"docs":{},"t":{"'":{"df":2,"docs":{"28":{"tf":1.0},"32":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"'":{"df":2,"docs":{"28":{"tf":1.0},"65":{"tf":1.0}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":2,"docs":{"18":{"tf":1.0},"4":{"tf":1.0}}}}}}},"y":{"'":{"df":0,"docs":{},"r":{"df":1,"docs":{"56":{"tf":1.0}}}},"df":0,"docs":{}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":5,"docs":{"0":{"tf":1.4142135623730951},"23":{"tf":1.0},"24":{"tf":1.0},"57":{"tf":1.0},"67":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":3,"docs":{"29":{"tf":1.0},"30":{"tf":1.0},"32":{"tf":1.4142135623730951}}}},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":2,"docs":{"31":{"tf":1.0},"32":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":3,"docs":{"43":{"tf":1.0},"53":{"tf":1.0},"67":{"tf":1.4142135623730951}}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":3,"docs":{"5":{"tf":1.0},"60":{"tf":1.0},"69":{"tf":1.0}},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"22":{"tf":1.0}}}}}}}}}}},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":3,"docs":{"39":{"tf":1.0},"41":{"tf":1.0},"6":{"tf":1.0}}}},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{">":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":1,"docs":{"19":{"tf":1.0}}}}}}}},"df":0,"docs":{}}}}},"l":{"df":1,"docs":{"6":{"tf":1.0}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"6":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"o":{"d":{"a":{"df":0,"docs":{},"y":{"df":2,"docs":{"32":{"tf":1.0},"67":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":1,"docs":{"32":{"tf":1.0}}}},"o":{"df":0,"docs":{},"l":{"df":5,"docs":{"18":{"tf":1.0},"2":{"tf":1.0},"27":{"tf":2.0},"3":{"tf":1.0},"5":{"tf":1.4142135623730951}}}},"p":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"59":{"tf":1.0}}},"df":0,"docs":{}}},"t":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"65":{"tf":1.7320508075688772}}}},"df":0,"docs":{}}},"r":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"30":{"tf":1.0}}}},"df":0,"docs":{}},"p":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"68":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"40":{"tf":1.0}}}},"df":0,"docs":{},"e":{"df":3,"docs":{"20":{"tf":1.0},"46":{"tf":1.0},"61":{"tf":1.0}}}},"i":{"df":3,"docs":{"2":{"tf":1.0},"28":{"tf":1.0},"29":{"tf":1.0}},"g":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":3,"docs":{"23":{"tf":1.0},"32":{"tf":1.0},"53":{"tf":1.0}}}}}}},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"k":{"#":{"3":{"df":1,"docs":{"46":{"tf":1.0}}},"7":{"df":1,"docs":{"46":{"tf":1.0}}},"9":{"df":1,"docs":{"55":{"tf":1.0}}},"df":0,"docs":{}},"'":{"df":7,"docs":{"13":{"tf":1.0},"26":{"tf":1.0},"28":{"tf":1.0},"30":{"tf":1.0},"38":{"tf":1.0},"39":{"tf":1.0},"40":{"tf":1.0}}},".":{"df":0,"docs":{},"j":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"29":{"tf":1.4142135623730951}}}}}},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":8,"docs":{"28":{"tf":1.0},"29":{"tf":1.4142135623730951},"30":{"tf":1.0},"32":{"tf":1.4142135623730951},"33":{"tf":1.0},"40":{"tf":1.0},"57":{"tf":1.0},"70":{"tf":1.4142135623730951}}}}}},"y":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":1,"docs":{"29":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}},"_":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"_":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":1,"docs":{"40":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"40":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}}}}},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"40":{"tf":1.0}}}}}}},"u":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"c":{"_":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"df":1,"docs":{"40":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"k":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"_":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"_":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"17":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"c":{"df":0,"docs":{},"e":{"_":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":1,"docs":{"40":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"t":{"a":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"_":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":1,"docs":{"40":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":1,"docs":{"33":{"tf":1.0}}}}}}},"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"c":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"63":{"tf":1.0}},"u":{"df":0,"docs":{},"p":{"df":1,"docs":{"61":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":60,"docs":{"0":{"tf":1.4142135623730951},"1":{"tf":1.0},"10":{"tf":1.0},"11":{"tf":1.4142135623730951},"12":{"tf":1.4142135623730951},"13":{"tf":1.0},"14":{"tf":1.4142135623730951},"15":{"tf":1.4142135623730951},"16":{"tf":1.4142135623730951},"17":{"tf":1.4142135623730951},"18":{"tf":1.0},"19":{"tf":2.0},"2":{"tf":1.0},"20":{"tf":1.0},"21":{"tf":1.0},"22":{"tf":1.4142135623730951},"23":{"tf":1.4142135623730951},"24":{"tf":1.4142135623730951},"25":{"tf":1.0},"26":{"tf":1.0},"27":{"tf":1.4142135623730951},"28":{"tf":1.4142135623730951},"29":{"tf":1.7320508075688772},"3":{"tf":1.4142135623730951},"31":{"tf":1.0},"32":{"tf":1.7320508075688772},"33":{"tf":2.0},"34":{"tf":1.0},"35":{"tf":1.4142135623730951},"36":{"tf":1.0},"38":{"tf":1.0},"40":{"tf":2.6457513110645907},"42":{"tf":1.0},"43":{"tf":2.0},"44":{"tf":2.8284271247461903},"45":{"tf":1.4142135623730951},"46":{"tf":1.4142135623730951},"47":{"tf":1.4142135623730951},"48":{"tf":1.0},"49":{"tf":1.0},"5":{"tf":1.0},"50":{"tf":1.0},"51":{"tf":1.0},"53":{"tf":2.23606797749979},"54":{"tf":1.0},"55":{"tf":2.23606797749979},"56":{"tf":1.7320508075688772},"57":{"tf":2.449489742783178},"58":{"tf":1.0},"6":{"tf":1.7320508075688772},"60":{"tf":1.0},"62":{"tf":1.0},"65":{"tf":1.4142135623730951},"67":{"tf":2.6457513110645907},"68":{"tf":1.7320508075688772},"69":{"tf":2.449489742783178},"7":{"tf":1.4142135623730951},"70":{"tf":1.4142135623730951},"8":{"tf":1.7320508075688772},"9":{"tf":1.4142135623730951}}}}}},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":2,"docs":{"57":{"tf":1.0},"67":{"tf":1.0}}}}},"w":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"k":{"df":2,"docs":{"20":{"tf":1.0},"67":{"tf":1.0}}}},"df":0,"docs":{}},"o":{"df":2,"docs":{"68":{"tf":1.0},"69":{"tf":1.0}}}},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"=":{"\"":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":2,"docs":{"49":{"tf":1.0},"64":{"tf":1.0}}}}},"df":0,"docs":{}}},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"k":{"df":1,"docs":{"44":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":12,"docs":{"43":{"tf":2.23606797749979},"44":{"tf":2.0},"45":{"tf":1.0},"46":{"tf":1.0},"47":{"tf":1.0},"48":{"tf":1.0},"49":{"tf":1.4142135623730951},"52":{"tf":1.0},"55":{"tf":1.4142135623730951},"58":{"tf":1.0},"60":{"tf":1.0},"66":{"tf":1.0}},"s":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"44":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}}},"i":{"c":{"df":4,"docs":{"40":{"tf":1.0},"41":{"tf":1.0},"43":{"tf":1.0},"53":{"tf":1.0}}},"df":0,"docs":{}}}}},"u":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"69":{"tf":1.0}}}}},"df":0,"docs":{}}},"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"44":{"tf":1.0}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":1,"docs":{"67":{"tf":1.0}}}}}}}},"k":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{"df":1,"docs":{"4":{"tf":2.0}}}}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"2":{"tf":1.0}}}}}},"m":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":1,"docs":{"55":{"tf":1.0}}}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"/":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"/":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":1,"docs":{"67":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"61":{"tf":1.0}}}}}},"p":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":1,"docs":{"33":{"tf":1.0}}}}},"d":{"a":{"df":0,"docs":{},"t":{"df":4,"docs":{"13":{"tf":1.7320508075688772},"17":{"tf":1.4142135623730951},"20":{"tf":1.0},"6":{"tf":1.0}},"e":{"_":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"k":{"df":2,"docs":{"17":{"tf":1.0},"6":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":2,"docs":{"25":{"tf":1.0},"66":{"tf":1.0}}},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"69":{"tf":2.0}}},"l":{"df":4,"docs":{"40":{"tf":1.0},"56":{"tf":2.6457513110645907},"67":{"tf":3.4641016151377544},"69":{"tf":1.7320508075688772}}}},"s":{"df":35,"docs":{"0":{"tf":1.0},"1":{"tf":1.0},"12":{"tf":1.0},"14":{"tf":1.4142135623730951},"16":{"tf":1.4142135623730951},"17":{"tf":1.4142135623730951},"19":{"tf":1.0},"20":{"tf":1.4142135623730951},"29":{"tf":1.7320508075688772},"31":{"tf":1.4142135623730951},"32":{"tf":2.23606797749979},"33":{"tf":1.4142135623730951},"34":{"tf":1.0},"36":{"tf":1.0},"38":{"tf":1.0},"4":{"tf":1.7320508075688772},"40":{"tf":2.0},"41":{"tf":1.0},"44":{"tf":3.605551275463989},"45":{"tf":1.4142135623730951},"47":{"tf":1.4142135623730951},"5":{"tf":1.0},"54":{"tf":1.0},"55":{"tf":1.0},"56":{"tf":1.4142135623730951},"57":{"tf":1.7320508075688772},"58":{"tf":1.0},"6":{"tf":1.4142135623730951},"60":{"tf":1.0},"64":{"tf":1.0},"67":{"tf":2.23606797749979},"69":{"tf":1.7320508075688772},"71":{"tf":1.0},"8":{"tf":1.0},"9":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"65":{"tf":1.0}}}}}},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"d":{"df":2,"docs":{"43":{"tf":1.0},"53":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"u":{"df":5,"docs":{"44":{"tf":2.8284271247461903},"56":{"tf":1.0},"57":{"tf":1.4142135623730951},"58":{"tf":1.0},"67":{"tf":1.0}}}},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"a":{"df":2,"docs":{"19":{"tf":1.0},"64":{"tf":1.0}}},"df":0,"docs":{}}}}},"r":{"df":0,"docs":{},"i":{"a":{"b":{"df":0,"docs":{},"l":{"df":7,"docs":{"17":{"tf":1.0},"28":{"tf":1.0},"31":{"tf":1.7320508075688772},"32":{"tf":1.0},"40":{"tf":1.0},"44":{"tf":1.0},"60":{"tf":1.0}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"28":{"tf":1.0},"32":{"tf":1.0}}}}},"df":1,"docs":{"3":{"tf":1.0}},"o":{"df":0,"docs":{},"u":{"df":3,"docs":{"11":{"tf":1.0},"38":{"tf":1.0},"57":{"tf":1.0}}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":6,"docs":{"12":{"tf":1.0},"13":{"tf":1.0},"17":{"tf":1.4142135623730951},"32":{"tf":2.0},"33":{"tf":2.8284271247461903},"65":{"tf":1.0}}}}}}}},"i":{"a":{"df":4,"docs":{"0":{"tf":1.0},"44":{"tf":1.0},"64":{"tf":1.0},"70":{"tf":1.0}}},"df":0,"docs":{}}},"w":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"40":{"tf":1.0}}}},"n":{"df":0,"docs":{},"t":{"df":4,"docs":{"20":{"tf":1.4142135623730951},"4":{"tf":1.0},"41":{"tf":1.0},"61":{"tf":1.0}}}},"r":{"df":0,"docs":{},"n":{"df":3,"docs":{"32":{"tf":1.0},"53":{"tf":1.0},"67":{"tf":1.0}}}},"s":{"df":0,"docs":{},"m":{"3":{"2":{"df":2,"docs":{"22":{"tf":1.0},"4":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"_":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"(":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"66":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":3,"docs":{"19":{"tf":1.0},"20":{"tf":1.0},"65":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":1,"docs":{"64":{"tf":1.0}}}}}},"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"44":{"tf":1.0}}},"df":0,"docs":{}}}},"df":11,"docs":{"0":{"tf":1.4142135623730951},"18":{"tf":1.0},"19":{"tf":1.0},"22":{"tf":1.4142135623730951},"44":{"tf":4.58257569495584},"54":{"tf":1.0},"55":{"tf":1.0},"60":{"tf":1.4142135623730951},"63":{"tf":1.0},"64":{"tf":1.7320508075688772},"65":{"tf":2.449489742783178}}}},"t":{"c":{"df":0,"docs":{},"h":{"df":2,"docs":{"23":{"tf":1.7320508075688772},"24":{"tf":1.0}}}},"df":0,"docs":{}},"y":{"df":6,"docs":{"12":{"tf":1.0},"55":{"tf":1.0},"6":{"tf":1.0},"65":{"tf":1.0},"68":{"tf":1.0},"71":{"tf":1.0}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"k":{"df":1,"docs":{"44":{"tf":1.4142135623730951}}}},"b":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":1,"docs":{"19":{"tf":1.0}}},"y":{"df":0,"docs":{},"s":{":":{":":{"df":0,"docs":{},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":1,"docs":{"19":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"b":{"df":0,"docs":{},"l":{"df":9,"docs":{"0":{"tf":1.0},"3":{"tf":1.0},"4":{"tf":1.4142135623730951},"60":{"tf":1.0},"61":{"tf":1.7320508075688772},"62":{"tf":1.0},"63":{"tf":1.0},"64":{"tf":1.0},"65":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"b":{"df":0,"docs":{},"i":{"df":1,"docs":{"0":{"tf":1.0}}}},"df":9,"docs":{"0":{"tf":1.0},"18":{"tf":1.0},"19":{"tf":1.0},"20":{"tf":1.0},"24":{"tf":1.0},"44":{"tf":1.4142135623730951},"58":{"tf":1.0},"61":{"tf":1.0},"63":{"tf":1.0}},"s":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":2,"docs":{"67":{"tf":2.23606797749979},"69":{"tf":1.0}}}}}},"df":0,"docs":{}}},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"k":{"df":1,"docs":{"44":{"tf":1.0}}}}}}},"df":0,"docs":{},"l":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":1,"docs":{"71":{"tf":1.0}}}}},"df":0,"docs":{},"l":{"df":3,"docs":{"28":{"tf":1.0},"31":{"tf":1.0},"32":{"tf":1.0}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"'":{"df":0,"docs":{},"t":{"df":1,"docs":{"67":{"tf":1.0}}}},"df":0,"docs":{}}}}},"i":{"df":0,"docs":{},"n":{".":{"d":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"u":{"df":1,"docs":{"19":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{",":{"d":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{",":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{",":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":1,"docs":{"19":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}}}}}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},".":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"m":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":2,"docs":{"60":{"tf":1.0},"64":{"tf":1.0}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"s":{".":{"<":{"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"44":{"tf":1.0}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"m":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":1,"docs":{"64":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":3,"docs":{"19":{"tf":1.0},"41":{"tf":1.7320508075688772},"44":{"tf":1.0}}}}},"df":0,"docs":{}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"41":{"tf":1.0}}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":8,"docs":{"44":{"tf":1.0},"45":{"tf":1.0},"46":{"tf":1.4142135623730951},"47":{"tf":1.0},"48":{"tf":1.0},"50":{"tf":1.0},"51":{"tf":1.0},"53":{"tf":1.4142135623730951}}}}}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"k":{"df":8,"docs":{"28":{"tf":1.0},"32":{"tf":1.0},"53":{"tf":1.0},"55":{"tf":1.0},"61":{"tf":1.0},"65":{"tf":1.0},"67":{"tf":1.0},"71":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"44":{"tf":1.7320508075688772}}}},"f":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":1,"docs":{"21":{"tf":1.0}}}}}}},"l":{"d":{"<":{"/":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":1,"docs":{"19":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":2,"docs":{"19":{"tf":1.7320508075688772},"20":{"tf":1.0}}},"df":0,"docs":{}}}},"r":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"49":{"tf":1.7320508075688772}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"44":{"tf":1.0}}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":3,"docs":{"35":{"tf":1.0},"39":{"tf":1.4142135623730951},"56":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"65":{"tf":1.0}}}}}},"s":{"df":3,"docs":{"67":{"tf":1.0},"69":{"tf":1.0},"70":{"tf":1.0}}}},"y":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":4,"docs":{"30":{"tf":1.0},"32":{"tf":1.0},"34":{"tf":1.0},"37":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":1,"docs":{"20":{"tf":1.0}}}},"o":{"df":0,"docs":{},"u":{"'":{"df":0,"docs":{},"r":{"df":2,"docs":{"2":{"tf":1.0},"32":{"tf":1.0}}}},"df":0,"docs":{},"r":{"df":1,"docs":{"32":{"tf":1.0}}}}}},"z":{"df":1,"docs":{"44":{"tf":1.7320508075688772}},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":1,"docs":{"46":{"tf":1.0}}}}}}}},"breadcrumbs":{"root":{"0":{".":{"1":{"9":{".":{"0":{"df":4,"docs":{"17":{"tf":1.0},"33":{"tf":1.4142135623730951},"65":{"tf":1.0},"67":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"2":{"0":{".":{"0":{"df":1,"docs":{"57":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"1":{".":{"0":{"df":2,"docs":{"28":{"tf":1.0},"32":{"tf":1.7320508075688772}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":3,"docs":{"40":{"tf":1.0},"44":{"tf":1.4142135623730951},"65":{"tf":1.0}}},"1":{"df":2,"docs":{"39":{"tf":1.4142135623730951},"44":{"tf":1.4142135623730951}}},"2":{"4":{"df":1,"docs":{"17":{"tf":1.0}}},"df":2,"docs":{"39":{"tf":1.0},"44":{"tf":1.0}}},"3":{"df":2,"docs":{"39":{"tf":1.4142135623730951},"44":{"tf":1.0}}},"4":{"0":{"df":1,"docs":{"15":{"tf":1.0}}},"df":2,"docs":{"39":{"tf":1.0},"44":{"tf":1.4142135623730951}}},"5":{"df":1,"docs":{"39":{"tf":1.4142135623730951}}},"6":{"df":1,"docs":{"39":{"tf":1.4142135623730951}}},"8":{"0":{"8":{"0":{"df":1,"docs":{"30":{"tf":1.7320508075688772}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"19":{"tf":1.0}}},"_":{"b":{"df":0,"docs":{},"g":{".":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"m":{"df":1,"docs":{"44":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"a":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"v":{"df":2,"docs":{"30":{"tf":1.0},"70":{"tf":1.0}}}},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"67":{"tf":2.23606797749979}}}}}}}},"c":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":3,"docs":{"29":{"tf":1.0},"69":{"tf":1.0},"70":{"tf":1.4142135623730951}}}},"s":{"df":0,"docs":{},"s":{"df":3,"docs":{"19":{"tf":1.4142135623730951},"56":{"tf":1.0},"60":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"d":{"df":1,"docs":{"41":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"t":{"df":1,"docs":{"67":{"tf":2.0}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"38":{"tf":1.0}}}},"v":{"df":2,"docs":{"44":{"tf":1.0},"65":{"tf":1.0}}}},"u":{"a":{"df":0,"docs":{},"l":{"df":3,"docs":{"17":{"tf":1.0},"33":{"tf":1.0},"57":{"tf":1.0}}}},"df":0,"docs":{}}}},"d":{"d":{"df":6,"docs":{"19":{"tf":1.7320508075688772},"20":{"tf":1.0},"39":{"tf":1.0},"4":{"tf":1.4142135623730951},"58":{"tf":1.0},"66":{"tf":1.0}},"e":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"(":{"\"":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"k":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"c":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"64":{"tf":1.0}}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}}}}}}},"i":{"df":0,"docs":{},"t":{"df":3,"docs":{"38":{"tf":1.0},"44":{"tf":1.0},"54":{"tf":1.0}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"40":{"tf":1.0}}}}}}}},"df":5,"docs":{"19":{"tf":1.0},"33":{"tf":1.0},"34":{"tf":1.0},"55":{"tf":1.0},"56":{"tf":1.0}},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"33":{"tf":1.0}}}}},"v":{"a":{"df":0,"docs":{},"n":{"c":{"df":12,"docs":{"59":{"tf":2.0},"60":{"tf":1.0},"61":{"tf":1.0},"62":{"tf":1.0},"63":{"tf":1.0},"64":{"tf":1.0},"65":{"tf":1.0},"66":{"tf":1.0},"67":{"tf":1.0},"68":{"tf":1.0},"69":{"tf":1.0},"70":{"tf":1.0}}},"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"44":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{},"g":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"31":{"tf":1.0}}}}}}},"df":0,"docs":{}},"l":{"df":0,"docs":{},"i":{"a":{"df":1,"docs":{"33":{"tf":1.0}}},"df":0,"docs":{},"k":{"df":1,"docs":{"37":{"tf":1.4142135623730951}}}},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":6,"docs":{"12":{"tf":1.0},"33":{"tf":1.0},"55":{"tf":1.0},"67":{"tf":1.0},"69":{"tf":1.0},"70":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":2,"docs":{"68":{"tf":1.0},"69":{"tf":1.0}}}}},"p":{"df":0,"docs":{},"h":{"a":{".":{"1":{"df":1,"docs":{"65":{"tf":1.0}}},"2":{"df":2,"docs":{"17":{"tf":1.0},"33":{"tf":1.4142135623730951}}},"3":{"df":1,"docs":{"67":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"e":{"a":{"d":{"df":0,"docs":{},"i":{"df":3,"docs":{"12":{"tf":1.0},"61":{"tf":1.0},"65":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":2,"docs":{"57":{"tf":1.0},"69":{"tf":1.0}}}}}},"w":{"a":{"df":0,"docs":{},"y":{"df":3,"docs":{"40":{"tf":1.0},"53":{"tf":1.0},"57":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"n":{"d":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"(":{"df":0,"docs":{},"|":{"df":0,"docs":{},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"19":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"y":{"df":0,"docs":{},"m":{"df":1,"docs":{"44":{"tf":1.0}}}}}},"y":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"71":{"tf":1.0}}}},"t":{"df":0,"docs":{},"h":{"df":2,"docs":{"28":{"tf":1.0},"32":{"tf":1.0}}}},"w":{"a":{"df":0,"docs":{},"y":{"df":1,"docs":{"28":{"tf":1.0}}}},"df":0,"docs":{}}}},"p":{"df":0,"docs":{},"i":{"/":{"df":0,"docs":{},"v":{"1":{"df":1,"docs":{"70":{"tf":1.0}}},"df":0,"docs":{}}},"df":3,"docs":{"20":{"tf":1.0},"32":{"tf":1.0},"69":{"tf":2.0}}},"p":{"df":1,"docs":{"56":{"tf":1.0}},"e":{"df":0,"docs":{},"n":{"d":{"df":2,"docs":{"19":{"tf":1.0},"67":{"tf":1.0}}},"df":0,"docs":{}}},"l":{"df":0,"docs":{},"i":{"c":{"df":13,"docs":{"0":{"tf":1.0},"18":{"tf":1.0},"19":{"tf":1.4142135623730951},"20":{"tf":1.0},"54":{"tf":1.0},"55":{"tf":1.0},"58":{"tf":1.0},"60":{"tf":1.0},"61":{"tf":2.449489742783178},"62":{"tf":1.0},"64":{"tf":1.0},"65":{"tf":1.4142135623730951},"67":{"tf":1.4142135623730951}}},"df":1,"docs":{"55":{"tf":1.0}}}},"r":{"df":0,"docs":{},"o":{"a":{"c":{"df":0,"docs":{},"h":{"df":3,"docs":{"32":{"tf":1.4142135623730951},"67":{"tf":1.0},"71":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":6,"docs":{"26":{"tf":1.0},"28":{"tf":1.0},"29":{"tf":1.4142135623730951},"31":{"tf":2.23606797749979},"32":{"tf":1.0},"40":{"tf":1.0}}}}}}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"a":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"25":{"tf":1.0},"44":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"s":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"66":{"tf":1.0}}},"df":0,"docs":{}},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"31":{"tf":1.0}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"63":{"tf":1.0}}}},"df":0,"docs":{}},"t":{"df":22,"docs":{"0":{"tf":1.0},"20":{"tf":1.0},"22":{"tf":1.4142135623730951},"39":{"tf":2.0},"42":{"tf":2.0},"43":{"tf":2.6457513110645907},"44":{"tf":1.0},"45":{"tf":1.0},"46":{"tf":1.0},"47":{"tf":1.0},"48":{"tf":1.0},"49":{"tf":1.0},"50":{"tf":1.0},"51":{"tf":1.0},"52":{"tf":2.0},"53":{"tf":2.0},"54":{"tf":1.0},"55":{"tf":1.0},"56":{"tf":1.0},"57":{"tf":2.449489742783178},"58":{"tf":1.4142135623730951},"60":{"tf":1.0}},"s":{"/":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"55":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"o":{"c":{"df":0,"docs":{},"i":{"df":2,"docs":{"43":{"tf":1.0},"53":{"tf":1.0}}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"m":{"df":3,"docs":{"12":{"tf":1.0},"4":{"tf":1.0},"9":{"tf":1.0}}}}},"y":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"66":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"53":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":12,"docs":{"43":{"tf":1.7320508075688772},"45":{"tf":1.4142135623730951},"46":{"tf":1.0},"47":{"tf":1.4142135623730951},"48":{"tf":1.0},"49":{"tf":1.0},"50":{"tf":1.0},"51":{"tf":1.0},"53":{"tf":1.7320508075688772},"56":{"tf":1.0},"57":{"tf":1.0},"58":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}}}},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":1,"docs":{"67":{"tf":1.0}},"m":{"a":{"df":0,"docs":{},"t":{"df":3,"docs":{"2":{"tf":1.0},"54":{"tf":1.0},"58":{"tf":1.0}}}},"df":0,"docs":{}}}}},"v":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":7,"docs":{"14":{"tf":1.0},"3":{"tf":1.0},"31":{"tf":1.0},"44":{"tf":1.4142135623730951},"55":{"tf":1.0},"58":{"tf":1.0},"61":{"tf":1.0}}}},"l":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"53":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"b":{"a":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"=":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"p":{":":{"/":{"/":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"c":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{":":{"9":{"0":{"0":{"0":{"/":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"i":{"df":1,"docs":{"69":{"tf":1.0}}}}},"df":0,"docs":{}},"df":1,"docs":{"69":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"s":{":":{"/":{"/":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"c":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{":":{"3":{"0":{"0":{"1":{"df":1,"docs":{"69":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":3,"docs":{"68":{"tf":2.0},"69":{"tf":2.6457513110645907},"70":{"tf":1.7320508075688772}}},"df":0,"docs":{}}},"w":{"a":{"df":0,"docs":{},"r":{"d":{"df":1,"docs":{"44":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":9,"docs":{"19":{"tf":1.0},"28":{"tf":1.0},"29":{"tf":1.0},"3":{"tf":1.4142135623730951},"30":{"tf":1.0},"37":{"tf":1.0},"56":{"tf":1.4142135623730951},"60":{"tf":1.0},"67":{"tf":4.69041575982343}}},"i":{"c":{"df":4,"docs":{"1":{"tf":1.0},"18":{"tf":1.4142135623730951},"19":{"tf":1.0},"20":{"tf":1.0}}},"df":1,"docs":{"57":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":2,"docs":{"29":{"tf":1.0},"30":{"tf":1.0}}}}},"df":1,"docs":{"67":{"tf":1.0}},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":4,"docs":{"26":{"tf":1.0},"32":{"tf":1.0},"39":{"tf":1.4142135623730951},"40":{"tf":1.0}}}}},"h":{"a":{"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":2,"docs":{"56":{"tf":1.0},"60":{"tf":1.0}}}}}}},"df":0,"docs":{}},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":4,"docs":{"40":{"tf":1.0},"41":{"tf":1.0},"43":{"tf":1.4142135623730951},"68":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"32":{"tf":1.4142135623730951},"71":{"tf":1.0}}}},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"55":{"tf":1.0}}}}},"w":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"30":{"tf":1.0}}}}}}}},"i":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":6,"docs":{"10":{"tf":1.4142135623730951},"11":{"tf":1.4142135623730951},"12":{"tf":1.4142135623730951},"13":{"tf":1.0},"44":{"tf":2.6457513110645907},"5":{"tf":1.0}}}}},"d":{"df":3,"docs":{"44":{"tf":1.0},"61":{"tf":1.0},"64":{"tf":1.0}},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":6,"docs":{"18":{"tf":1.0},"19":{"tf":1.0},"22":{"tf":1.0},"44":{"tf":2.8284271247461903},"54":{"tf":1.0},"60":{"tf":1.0}}}}}},"df":1,"docs":{"44":{"tf":1.4142135623730951}},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"60":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"12":{"tf":2.23606797749979}}}},"df":0,"docs":{}}}},"t":{"df":3,"docs":{"28":{"tf":1.0},"52":{"tf":1.0},"65":{"tf":1.0}}}},"l":{"df":0,"docs":{},"o":{"b":{"df":2,"docs":{"57":{"tf":1.0},"65":{"tf":1.0}}},"df":0,"docs":{}}},"o":{"d":{"df":0,"docs":{},"i":{"df":2,"docs":{"19":{"tf":2.0},"68":{"tf":1.0}}},"y":{".":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"_":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"d":{"(":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"e":{".":{"a":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":1,"docs":{"19":{"tf":1.0}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"60":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"t":{"df":0,"docs":{},"h":{"df":3,"docs":{"44":{"tf":1.0},"67":{"tf":1.0},"70":{"tf":1.0}}}}},"r":{"a":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"8":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"k":{"df":3,"docs":{"28":{"tf":1.0},"32":{"tf":1.0},"57":{"tf":1.0}}}},"df":0,"docs":{},"w":{"df":1,"docs":{"14":{"tf":2.0}}}},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":1,"docs":{"39":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"20":{"tf":1.0}}}}}}}},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"d":{".":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":1,"docs":{"57":{"tf":1.0}}}}}}}}},"df":16,"docs":{"0":{"tf":1.0},"13":{"tf":1.0},"18":{"tf":1.4142135623730951},"20":{"tf":1.0},"22":{"tf":2.449489742783178},"23":{"tf":1.4142135623730951},"25":{"tf":1.4142135623730951},"30":{"tf":1.4142135623730951},"33":{"tf":1.4142135623730951},"38":{"tf":1.0},"39":{"tf":2.449489742783178},"40":{"tf":2.23606797749979},"41":{"tf":1.0},"6":{"tf":1.4142135623730951},"8":{"tf":1.0},"9":{"tf":1.0}}},"df":0,"docs":{},"t":{"df":5,"docs":{"17":{"tf":1.0},"19":{"tf":1.0},"22":{"tf":1.0},"39":{"tf":1.0},"68":{"tf":1.0}}}}},"n":{"d":{"df":0,"docs":{},"l":{"df":2,"docs":{"0":{"tf":1.0},"46":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"0":{"tf":1.0}}}}}},"df":0,"docs":{}}},"y":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"69":{"tf":1.0}}}}},"df":0,"docs":{}},"t":{"df":0,"docs":{},"e":{"df":1,"docs":{"65":{"tf":1.4142135623730951}}}}}},"c":{"a":{"c":{"df":0,"docs":{},"h":{"df":6,"docs":{"45":{"tf":1.0},"46":{"tf":1.0},"47":{"tf":1.0},"48":{"tf":1.0},"53":{"tf":1.0},"55":{"tf":1.0}}}},"d":{"d":{"df":0,"docs":{},"i":{"df":1,"docs":{"69":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":3,"docs":{"61":{"tf":1.7320508075688772},"63":{"tf":1.0},"65":{"tf":2.449489742783178}}}},"n":{"'":{"df":0,"docs":{},"t":{"df":1,"docs":{"67":{"tf":1.0}}}},"df":0,"docs":{}},"p":{"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"33":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"e":{"df":2,"docs":{"32":{"tf":1.0},"54":{"tf":1.0}}},"g":{"df":0,"docs":{},"o":{"'":{"df":1,"docs":{"33":{"tf":1.0}}},".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":5,"docs":{"29":{"tf":1.0},"30":{"tf":1.0},"32":{"tf":1.0},"44":{"tf":2.0},"66":{"tf":1.0}}}}}}},"df":11,"docs":{"12":{"tf":2.23606797749979},"17":{"tf":1.0},"18":{"tf":1.4142135623730951},"19":{"tf":1.7320508075688772},"22":{"tf":1.0},"3":{"tf":1.0},"44":{"tf":4.358898943540674},"5":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":2.0},"9":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"e":{"df":8,"docs":{"13":{"tf":1.0},"28":{"tf":1.0},"32":{"tf":1.7320508075688772},"4":{"tf":1.0},"40":{"tf":1.0},"44":{"tf":1.0},"57":{"tf":1.7320508075688772},"67":{"tf":2.0}}}},"u":{"df":0,"docs":{},"s":{"df":2,"docs":{"55":{"tf":1.0},"70":{"tf":1.0}}}}},"d":{"df":1,"docs":{"19":{"tf":1.0}},"y":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"b":{"df":1,"docs":{"66":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"12":{"tf":1.0},"33":{"tf":1.0}}}}},"df":1,"docs":{"69":{"tf":1.4142135623730951}},"i":{"df":0,"docs":{},"f":{"df":1,"docs":{"69":{"tf":1.0}}}}}}},"h":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":7,"docs":{"19":{"tf":1.0},"23":{"tf":1.4142135623730951},"28":{"tf":1.0},"32":{"tf":1.0},"39":{"tf":1.0},"56":{"tf":1.0},"9":{"tf":1.0}}}},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"=":{"\"":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"f":{"df":1,"docs":{"19":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"k":{"df":5,"docs":{"13":{"tf":1.0},"17":{"tf":2.6457513110645907},"33":{"tf":1.0},"6":{"tf":1.0},"9":{"tf":1.0}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"32":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"s":{"df":1,"docs":{"67":{"tf":1.0}}}}}},"l":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"53":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"25":{"tf":2.0}}}},"df":0,"docs":{}},"i":{"df":5,"docs":{"21":{"tf":1.0},"26":{"tf":1.0},"47":{"tf":1.0},"69":{"tf":1.4142135623730951},"70":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"6":{"tf":1.4142135623730951}}}}}},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":1,"docs":{"53":{"tf":1.0}}}}}},"m":{"d":{"df":1,"docs":{"41":{"tf":1.0}}},"df":0,"docs":{}},"o":{"d":{"df":0,"docs":{},"e":{"df":10,"docs":{"40":{"tf":1.4142135623730951},"44":{"tf":1.4142135623730951},"45":{"tf":1.0},"46":{"tf":1.0},"47":{"tf":1.0},"48":{"tf":1.0},"60":{"tf":1.4142135623730951},"61":{"tf":1.4142135623730951},"62":{"tf":1.0},"64":{"tf":1.0}}}},"df":0,"docs":{},"m":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"18":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":3,"docs":{"0":{"tf":1.0},"28":{"tf":1.0},"3":{"tf":1.0}}},"m":{"a":{"df":1,"docs":{"44":{"tf":1.0}},"n":{"d":{"_":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"df":1,"docs":{"40":{"tf":1.4142135623730951}},"m":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"41":{"tf":1.0}}}}}}}}}},"df":0,"docs":{}},"df":17,"docs":{"17":{"tf":1.4142135623730951},"21":{"tf":2.0},"22":{"tf":1.0},"23":{"tf":1.0},"24":{"tf":1.0},"25":{"tf":1.0},"26":{"tf":1.0},"27":{"tf":1.0},"28":{"tf":1.4142135623730951},"3":{"tf":1.0},"31":{"tf":2.6457513110645907},"32":{"tf":1.0},"40":{"tf":1.4142135623730951},"41":{"tf":1.7320508075688772},"5":{"tf":1.0},"57":{"tf":1.0},"69":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"8":{"tf":1.7320508075688772}}}}},"p":{"a":{"df":0,"docs":{},"t":{"df":2,"docs":{"30":{"tf":1.0},"44":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":10,"docs":{"10":{"tf":1.7320508075688772},"11":{"tf":1.0},"12":{"tf":1.0},"19":{"tf":1.0},"3":{"tf":1.0},"4":{"tf":1.0},"44":{"tf":1.7320508075688772},"45":{"tf":1.4142135623730951},"47":{"tf":1.7320508075688772},"5":{"tf":1.0}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":2,"docs":{"61":{"tf":1.0},"65":{"tf":1.7320508075688772}}},"x":{"df":1,"docs":{"67":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"n":{"df":2,"docs":{"46":{"tf":1.0},"55":{"tf":1.0}}}}}},"n":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":1,"docs":{"22":{"tf":1.0}}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":6,"docs":{"0":{"tf":1.0},"26":{"tf":2.0},"29":{"tf":1.0},"35":{"tf":1.4142135623730951},"46":{"tf":1.0},"70":{"tf":2.449489742783178}},"u":{"df":0,"docs":{},"r":{"df":15,"docs":{"28":{"tf":3.1622776601683795},"29":{"tf":2.23606797749979},"30":{"tf":1.7320508075688772},"31":{"tf":2.0},"32":{"tf":1.7320508075688772},"33":{"tf":1.0},"34":{"tf":2.0},"35":{"tf":1.0},"36":{"tf":1.0},"37":{"tf":1.0},"40":{"tf":1.0},"57":{"tf":1.0},"67":{"tf":1.4142135623730951},"68":{"tf":1.0},"70":{"tf":1.0}}}}}},"l":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"44":{"tf":1.0}}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"i":{"d":{"df":2,"docs":{"32":{"tf":1.4142135623730951},"67":{"tf":1.0}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"40":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"l":{"df":1,"docs":{"67":{"tf":1.0}},"e":{".":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{"(":{"\"":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":1,"docs":{"64":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"c":{"_":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{":":{":":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"19":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":1,"docs":{"19":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}},"t":{"a":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"69":{"tf":1.0}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"65":{"tf":1.7320508075688772}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":12,"docs":{"19":{"tf":1.0},"39":{"tf":1.4142135623730951},"45":{"tf":1.0},"46":{"tf":1.4142135623730951},"47":{"tf":1.0},"48":{"tf":1.0},"49":{"tf":1.4142135623730951},"50":{"tf":1.0},"51":{"tf":1.0},"53":{"tf":1.4142135623730951},"55":{"tf":1.0},"65":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":1,"docs":{"55":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":2,"docs":{"55":{"tf":1.0},"71":{"tf":2.0}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{".":{"df":0,"docs":{},"m":{"d":{"df":1,"docs":{"71":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"l":{"df":7,"docs":{"45":{"tf":1.0},"46":{"tf":1.0},"47":{"tf":1.0},"48":{"tf":1.0},"53":{"tf":1.0},"55":{"tf":1.0},"57":{"tf":1.4142135623730951}}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":1,"docs":{"12":{"tf":1.0}}}}}}},"p":{"df":0,"docs":{},"i":{"df":9,"docs":{"46":{"tf":1.0},"48":{"tf":1.0},"49":{"tf":1.0},"50":{"tf":2.0},"51":{"tf":2.0},"53":{"tf":1.0},"54":{"tf":1.0},"55":{"tf":1.7320508075688772},"57":{"tf":1.4142135623730951}}}},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"67":{"tf":1.0}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"d":{"df":2,"docs":{"39":{"tf":1.0},"70":{"tf":1.0}}},"df":0,"docs":{}}}}}}}},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"67":{"tf":1.0}}}}},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":3,"docs":{"17":{"tf":1.0},"20":{"tf":1.0},"66":{"tf":2.0}},"s":{".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":3,"docs":{"12":{"tf":1.0},"17":{"tf":1.4142135623730951},"7":{"tf":1.7320508075688772}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":6,"docs":{"19":{"tf":2.6457513110645907},"20":{"tf":1.0},"41":{"tf":1.4142135623730951},"44":{"tf":1.4142135623730951},"53":{"tf":1.0},"60":{"tf":1.0}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":2,"docs":{"4":{"tf":1.0},"44":{"tf":1.0}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"44":{"tf":1.0}}}}}}}}}}}},"s":{"df":0,"docs":{},"s":{"df":5,"docs":{"0":{"tf":1.0},"45":{"tf":1.0},"46":{"tf":2.23606797749979},"47":{"tf":1.7320508075688772},"49":{"tf":1.4142135623730951}}}},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":6,"docs":{"26":{"tf":1.0},"33":{"tf":1.4142135623730951},"4":{"tf":1.0},"40":{"tf":1.0},"56":{"tf":1.0},"65":{"tf":1.4142135623730951}}}}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":2,"docs":{"60":{"tf":1.0},"63":{"tf":1.0}}}}}}}},"d":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"45":{"tf":1.0}}}},"t":{"a":{"df":15,"docs":{"30":{"tf":1.0},"43":{"tf":1.7320508075688772},"44":{"tf":5.5677643628300215},"45":{"tf":1.7320508075688772},"46":{"tf":1.7320508075688772},"47":{"tf":2.0},"48":{"tf":1.7320508075688772},"50":{"tf":1.0},"51":{"tf":1.0},"53":{"tf":2.23606797749979},"55":{"tf":1.4142135623730951},"56":{"tf":1.0},"57":{"tf":1.0},"58":{"tf":1.0},"65":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"df":3,"docs":{"26":{"tf":1.0},"40":{"tf":1.0},"44":{"tf":1.4142135623730951}}}}},"c":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":5,"docs":{"40":{"tf":1.0},"42":{"tf":1.0},"43":{"tf":1.0},"53":{"tf":1.0},"70":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{")":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"6":{"tf":1.0}}}},"u":{"df":0,"docs":{},"s":{"df":1,"docs":{"6":{"tf":1.0}}}}},"df":20,"docs":{"10":{"tf":1.0},"13":{"tf":1.0},"17":{"tf":1.0},"28":{"tf":1.4142135623730951},"29":{"tf":1.0},"3":{"tf":1.0},"32":{"tf":1.0},"4":{"tf":1.0},"40":{"tf":1.0},"41":{"tf":1.0},"44":{"tf":4.0},"45":{"tf":1.0},"46":{"tf":1.0},"47":{"tf":1.0},"48":{"tf":1.0},"57":{"tf":1.7320508075688772},"58":{"tf":1.4142135623730951},"60":{"tf":1.0},"65":{"tf":2.0},"67":{"tf":2.0}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"22":{"tf":1.0},"66":{"tf":1.0}},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"63":{"tf":1.4142135623730951}}}}}}},"l":{"a":{"df":0,"docs":{},"y":{"df":2,"docs":{"13":{"tf":1.0},"61":{"tf":1.0}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"g":{"df":1,"docs":{"57":{"tf":1.0}}}}},"m":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"l":{"df":1,"docs":{"44":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":4,"docs":{"19":{"tf":1.0},"2":{"tf":1.0},"33":{"tf":1.0},"57":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"e":{"c":{"df":1,"docs":{"32":{"tf":1.0}}},"df":0,"docs":{}}}},"s":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"b":{"df":4,"docs":{"39":{"tf":1.0},"40":{"tf":1.0},"43":{"tf":1.0},"59":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":1,"docs":{"40":{"tf":1.0}}}}},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":4,"docs":{"46":{"tf":1.0},"63":{"tf":1.0},"64":{"tf":1.0},"71":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"12":{"tf":1.0},"23":{"tf":1.0}}}},"df":0,"docs":{}}},"v":{"df":1,"docs":{"44":{"tf":1.7320508075688772}},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":1,"docs":{"21":{"tf":1.0}}}}}}}},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":5,"docs":{"13":{"tf":1.0},"28":{"tf":1.0},"30":{"tf":1.0},"41":{"tf":1.4142135623730951},"58":{"tf":1.0}}}}}},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":5,"docs":{"44":{"tf":1.0},"45":{"tf":1.0},"46":{"tf":1.0},"47":{"tf":1.0},"48":{"tf":1.0}}}}}},"r":{"df":11,"docs":{"44":{"tf":1.0},"45":{"tf":1.0},"46":{"tf":1.0},"47":{"tf":1.0},"48":{"tf":1.4142135623730951},"50":{"tf":1.4142135623730951},"51":{"tf":2.23606797749979},"53":{"tf":1.0},"54":{"tf":1.0},"55":{"tf":2.449489742783178},"57":{"tf":1.0}},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"56":{"tf":1.4142135623730951}},"l":{"df":0,"docs":{},"i":{"df":6,"docs":{"29":{"tf":1.0},"35":{"tf":1.0},"38":{"tf":1.0},"41":{"tf":1.0},"55":{"tf":1.0},"8":{"tf":1.7320508075688772}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":13,"docs":{"29":{"tf":1.7320508075688772},"39":{"tf":2.0},"40":{"tf":2.0},"44":{"tf":2.23606797749979},"45":{"tf":1.0},"46":{"tf":1.0},"47":{"tf":1.0},"48":{"tf":1.0},"50":{"tf":1.0},"51":{"tf":1.4142135623730951},"53":{"tf":1.0},"55":{"tf":1.0},"9":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}}},"s":{"a":{"b":{"df":0,"docs":{},"l":{"df":5,"docs":{"13":{"tf":1.0},"17":{"tf":1.4142135623730951},"44":{"tf":1.7320508075688772},"57":{"tf":1.4142135623730951},"60":{"tf":1.0}}}},"df":0,"docs":{}},"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":3,"docs":{"55":{"tf":1.0},"68":{"tf":1.0},"70":{"tf":1.0}}}}}},"df":0,"docs":{},"t":{"df":13,"docs":{"30":{"tf":2.449489742783178},"39":{"tf":1.0},"40":{"tf":1.0},"44":{"tf":1.4142135623730951},"45":{"tf":1.4142135623730951},"46":{"tf":1.4142135623730951},"47":{"tf":1.4142135623730951},"48":{"tf":1.7320508075688772},"50":{"tf":1.7320508075688772},"51":{"tf":1.7320508075688772},"53":{"tf":1.4142135623730951},"54":{"tf":1.0},"55":{"tf":2.0}},"r":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":2,"docs":{"13":{"tf":2.23606797749979},"5":{"tf":1.0}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"'":{"df":1,"docs":{"13":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":1,"docs":{"52":{"tf":1.0}}}}}}},"n":{"df":0,"docs":{},"f":{"df":1,"docs":{"15":{"tf":1.0}}}},"o":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":1,"docs":{"19":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"'":{"df":1,"docs":{"19":{"tf":1.0}}},".":{"b":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"56":{"tf":1.0}}}}}}}},"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"i":{"df":1,"docs":{"19":{"tf":1.0}}},"y":{"(":{")":{".":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"(":{"\"":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"d":{"df":1,"docs":{"19":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"e":{"(":{"\"":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":1,"docs":{"19":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":4,"docs":{"19":{"tf":1.4142135623730951},"20":{"tf":1.0},"28":{"tf":1.0},"71":{"tf":1.0}}}}}}}},"df":1,"docs":{"33":{"tf":1.0}},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"n":{"'":{"df":0,"docs":{},"t":{"df":1,"docs":{"67":{"tf":1.0}}}},"df":0,"docs":{}}}},"m":{"df":1,"docs":{"20":{"tf":1.0}}},"n":{"'":{"df":0,"docs":{},"t":{"df":1,"docs":{"32":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"e":{"df":1,"docs":{"33":{"tf":1.0}}}},"w":{"df":0,"docs":{},"n":{"df":1,"docs":{"30":{"tf":1.0}},"l":{"df":0,"docs":{},"o":{"a":{"d":{"df":2,"docs":{"11":{"tf":1.7320508075688772},"5":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"65":{"tf":1.0}}},"df":0,"docs":{}}}}},"x":{"df":0,"docs":{},"i":{"df":0,"docs":{},"u":{"df":1,"docs":{"20":{"tf":1.0}}}}}},"r":{"a":{"df":0,"docs":{},"f":{"df":0,"docs":{},"t":{"df":1,"docs":{"71":{"tf":1.0}}}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"e":{"df":1,"docs":{"32":{"tf":1.0}}},"r":{"df":0,"docs":{},"e":{"df":3,"docs":{"11":{"tf":1.0},"17":{"tf":1.0},"65":{"tf":1.0}}}}},"y":{"df":0,"docs":{},"s":{"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"67":{"tf":1.0}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"g":{"df":4,"docs":{"34":{"tf":1.0},"56":{"tf":1.0},"67":{"tf":1.7320508075688772},"69":{"tf":1.4142135623730951}}}},"a":{"c":{"df":0,"docs":{},"h":{"df":5,"docs":{"40":{"tf":1.0},"41":{"tf":1.4142135623730951},"43":{"tf":1.0},"68":{"tf":1.0},"70":{"tf":1.0}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":2,"docs":{"33":{"tf":1.0},"71":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"25":{"tf":1.0}}}}}}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"30":{"tf":1.0}}}}}}},"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"/":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"36":{"tf":1.7320508075688772}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"69":{"tf":1.0}}}},"df":0,"docs":{}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":3,"docs":{"43":{"tf":1.0},"53":{"tf":1.0},"56":{"tf":1.0}}}}}}}},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"62":{"tf":1.0}}}},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":2,"docs":{"29":{"tf":1.0},"44":{"tf":1.0}}}}}},"n":{"a":{"b":{"df":0,"docs":{},"l":{"df":7,"docs":{"10":{"tf":1.0},"17":{"tf":1.0},"44":{"tf":2.0},"46":{"tf":1.0},"57":{"tf":1.0},"58":{"tf":1.0},"68":{"tf":1.0}}}},"df":0,"docs":{}},"d":{"df":1,"docs":{"53":{"tf":1.0}},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"69":{"tf":1.0}}}}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"c":{"df":1,"docs":{"33":{"tf":1.0}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":3,"docs":{"33":{"tf":1.0},"55":{"tf":1.0},"61":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":2,"docs":{"17":{"tf":1.0},"55":{"tf":1.0}}}},"r":{"df":0,"docs":{},"i":{"df":2,"docs":{"18":{"tf":1.0},"41":{"tf":1.4142135623730951}}},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"66":{"tf":1.0}}}}}}}}}},"u":{"df":0,"docs":{},"m":{"df":1,"docs":{"57":{"tf":1.0}}}},"v":{"df":1,"docs":{"16":{"tf":1.0}},"i":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":7,"docs":{"17":{"tf":1.0},"2":{"tf":1.0},"28":{"tf":1.0},"31":{"tf":2.0},"32":{"tf":1.0},"40":{"tf":1.0},"67":{"tf":1.0}}}}}}}},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":3,"docs":{"33":{"tf":1.0},"40":{"tf":1.4142135623730951},"65":{"tf":1.7320508075688772}}}}}},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":1,"docs":{"31":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":6,"docs":{"20":{"tf":1.0},"32":{"tf":1.0},"44":{"tf":1.0},"46":{"tf":1.0},"70":{"tf":1.0},"9":{"tf":1.0}},"t":{".":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{".":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"m":{".":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"m":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":1,"docs":{"64":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":1,"docs":{"64":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":4,"docs":{"61":{"tf":1.4142135623730951},"62":{"tf":2.23606797749979},"63":{"tf":1.7320508075688772},"64":{"tf":1.4142135623730951}}}},"r":{"df":0,"docs":{},"y":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"71":{"tf":1.0}}}},"t":{"df":0,"docs":{},"h":{"df":2,"docs":{"32":{"tf":1.0},"69":{"tf":1.0}}}}}}}},"x":{"a":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"39":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":3,"docs":{"49":{"tf":1.0},"50":{"tf":1.0},"51":{"tf":1.0}}}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":9,"docs":{"20":{"tf":1.0},"30":{"tf":1.4142135623730951},"41":{"tf":1.0},"44":{"tf":1.0},"6":{"tf":1.0},"61":{"tf":1.0},"64":{"tf":1.7320508075688772},"65":{"tf":1.4142135623730951},"67":{"tf":1.0}}}}}},"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"40":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"u":{"d":{"df":1,"docs":{"57":{"tf":1.0}}},"df":0,"docs":{},"s":{"df":1,"docs":{"40":{"tf":1.0}}}}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":6,"docs":{"15":{"tf":1.0},"39":{"tf":1.4142135623730951},"40":{"tf":2.6457513110645907},"61":{"tf":1.0},"63":{"tf":1.0},"7":{"tf":1.0}}}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"20":{"tf":1.0}}}},"t":{"df":1,"docs":{"40":{"tf":1.0}}}},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"(":{"\"":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"d":{"df":1,"docs":{"19":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"19":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":4,"docs":{"27":{"tf":1.0},"40":{"tf":1.0},"65":{"tf":1.0},"67":{"tf":1.0}}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"r":{"df":1,"docs":{"69":{"tf":1.0}}}},"l":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"1":{"tf":1.0}}}}},"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"67":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"44":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":4,"docs":{"44":{"tf":1.0},"60":{"tf":1.0},"64":{"tf":1.0},"65":{"tf":1.4142135623730951}}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":3,"docs":{"20":{"tf":1.0},"42":{"tf":1.0},"49":{"tf":1.0}}}},"r":{"df":0,"docs":{},"n":{"df":1,"docs":{"38":{"tf":1.0}}}}},"r":{"a":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"11":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"f":{"a":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"26":{"tf":1.0}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"65":{"tf":1.0}}}},"l":{"df":0,"docs":{},"s":{"df":1,"docs":{"44":{"tf":1.7320508075688772}}}},"n":{"df":1,"docs":{"32":{"tf":1.0}}}},"df":1,"docs":{"19":{"tf":1.0}},"e":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":9,"docs":{"10":{"tf":1.0},"13":{"tf":1.0},"17":{"tf":1.0},"33":{"tf":1.4142135623730951},"39":{"tf":1.0},"44":{"tf":3.0},"54":{"tf":1.4142135623730951},"6":{"tf":1.0},"71":{"tf":1.0}}}}}},"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"a":{"df":1,"docs":{"15":{"tf":1.7320508075688772}}},"df":0,"docs":{}}}},"df":0,"docs":{},"e":{"d":{"b":{"a":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"65":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"t":{"c":{"df":0,"docs":{},"h":{"df":4,"docs":{"12":{"tf":1.0},"2":{"tf":1.0},"58":{"tf":1.0},"65":{"tf":1.0}}}},"df":0,"docs":{}}},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"d":{"df":4,"docs":{"32":{"tf":1.4142135623730951},"33":{"tf":1.0},"57":{"tf":1.4142135623730951},"70":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"l":{"df":0,"docs":{},"e":{"df":25,"docs":{"0":{"tf":1.0},"18":{"tf":1.0},"19":{"tf":1.4142135623730951},"28":{"tf":1.7320508075688772},"29":{"tf":3.1622776601683795},"32":{"tf":1.7320508075688772},"33":{"tf":1.0},"34":{"tf":1.0},"35":{"tf":1.0},"37":{"tf":1.0},"39":{"tf":1.0},"40":{"tf":1.0},"44":{"tf":2.0},"45":{"tf":1.7320508075688772},"46":{"tf":1.4142135623730951},"47":{"tf":1.4142135623730951},"49":{"tf":1.4142135623730951},"50":{"tf":2.0},"53":{"tf":2.0},"55":{"tf":1.4142135623730951},"57":{"tf":1.4142135623730951},"58":{"tf":1.0},"61":{"tf":1.0},"65":{"tf":1.7320508075688772},"70":{"tf":2.449489742783178}},"s":{"df":0,"docs":{},"y":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":1,"docs":{"23":{"tf":1.0}}}}}}}}}},"n":{"a":{"df":0,"docs":{},"l":{"df":3,"docs":{"39":{"tf":1.0},"44":{"tf":1.0},"70":{"tf":1.0}}}},"d":{"df":3,"docs":{"38":{"tf":1.0},"55":{"tf":1.7320508075688772},"71":{"tf":1.0}}},"df":0,"docs":{},"e":{"df":1,"docs":{"32":{"tf":1.0}}}},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":4,"docs":{"18":{"tf":1.0},"19":{"tf":1.0},"20":{"tf":1.0},"29":{"tf":1.0}}}}},"x":{"df":1,"docs":{"67":{"tf":1.0}}}},"l":{"a":{"df":0,"docs":{},"g":{"df":4,"docs":{"13":{"tf":1.0},"44":{"tf":1.4142135623730951},"69":{"tf":1.7320508075688772},"70":{"tf":1.0}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"38":{"tf":1.0}}}},"df":0,"docs":{}}}}},"n":{"df":2,"docs":{"19":{"tf":1.0},"66":{"tf":1.0}}},"o":{"df":0,"docs":{},"l":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"19":{"tf":1.0}}}}},"df":0,"docs":{},"k":{"df":1,"docs":{"71":{"tf":1.0}}},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":19,"docs":{"1":{"tf":1.0},"19":{"tf":1.0},"3":{"tf":1.0},"30":{"tf":1.4142135623730951},"34":{"tf":1.0},"36":{"tf":1.0},"39":{"tf":1.0},"40":{"tf":1.0},"43":{"tf":1.0},"53":{"tf":1.0},"55":{"tf":1.0},"57":{"tf":1.0},"58":{"tf":1.0},"59":{"tf":1.0},"6":{"tf":1.0},"64":{"tf":1.0},"66":{"tf":1.0},"69":{"tf":1.0},"70":{"tf":1.0}}}}}},"o":{"df":1,"docs":{"67":{"tf":1.0}}},"r":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"df":2,"docs":{"30":{"tf":1.7320508075688772},"33":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"w":{"a":{"df":0,"docs":{},"r":{"d":{"df":1,"docs":{"32":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"n":{"d":{"df":6,"docs":{"11":{"tf":1.0},"17":{"tf":1.0},"27":{"tf":1.0},"29":{"tf":1.4142135623730951},"46":{"tf":1.4142135623730951},"53":{"tf":1.0}}},"df":0,"docs":{}}}},"r":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"k":{"df":1,"docs":{"20":{"tf":1.0}}}}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"19":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"67":{"tf":1.0}}}}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":2,"docs":{"40":{"tf":2.0},"65":{"tf":1.0}}}},"n":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":7,"docs":{"36":{"tf":1.0},"44":{"tf":1.4142135623730951},"60":{"tf":1.4142135623730951},"62":{"tf":1.0},"64":{"tf":1.0},"65":{"tf":1.4142135623730951},"66":{"tf":1.0}}}}}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"40":{"tf":1.0},"69":{"tf":1.0}}}}}}},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":2,"docs":{"39":{"tf":1.0},"46":{"tf":1.0}}}}}}},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":9,"docs":{"25":{"tf":1.0},"32":{"tf":1.0},"35":{"tf":1.7320508075688772},"44":{"tf":1.0},"54":{"tf":1.0},"58":{"tf":1.0},"60":{"tf":1.0},"65":{"tf":1.0},"67":{"tf":1.7320508075688772}}}}},"t":{"df":20,"docs":{"1":{"tf":1.7320508075688772},"10":{"tf":1.0},"11":{"tf":1.0},"12":{"tf":1.0},"13":{"tf":1.0},"14":{"tf":1.0},"15":{"tf":1.0},"16":{"tf":1.0},"17":{"tf":1.0},"18":{"tf":1.0},"19":{"tf":1.4142135623730951},"2":{"tf":1.0},"20":{"tf":1.0},"3":{"tf":1.0},"4":{"tf":1.0},"5":{"tf":1.0},"6":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.0},"9":{"tf":1.0}}}},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"8":{"tf":2.449489742783178}},"h":{"df":0,"docs":{},"u":{"b":{"'":{"df":1,"docs":{"71":{"tf":1.0}}},"df":3,"docs":{"11":{"tf":1.7320508075688772},"12":{"tf":1.0},"20":{"tf":1.0}}},"df":0,"docs":{}}}},"v":{"df":0,"docs":{},"e":{"df":1,"docs":{"6":{"tf":1.0}},"n":{"df":4,"docs":{"12":{"tf":1.0},"40":{"tf":1.0},"44":{"tf":1.0},"69":{"tf":1.4142135623730951}}}}}},"l":{"df":0,"docs":{},"o":{"b":{"a":{"df":0,"docs":{},"l":{"df":3,"docs":{"29":{"tf":1.0},"44":{"tf":1.0},"60":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"o":{"a":{"df":0,"docs":{},"l":{"df":2,"docs":{"28":{"tf":1.0},"32":{"tf":1.0}}}},"df":1,"docs":{"0":{"tf":1.0}},"e":{"df":1,"docs":{"65":{"tf":1.0}}}},"r":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":2,"docs":{"55":{"tf":1.0},"71":{"tf":1.0}}}},"df":0,"docs":{}}}},"h":{"a":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"71":{"tf":1.0}}}},"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"l":{"df":4,"docs":{"45":{"tf":1.0},"46":{"tf":1.0},"47":{"tf":1.0},"69":{"tf":1.0}}}},"df":0,"docs":{}},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"28":{"tf":1.0}}}}}},"r":{"d":{"df":1,"docs":{"67":{"tf":1.0}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"h":{"df":11,"docs":{"45":{"tf":1.0},"46":{"tf":1.0},"47":{"tf":1.0},"48":{"tf":1.0},"49":{"tf":1.0},"50":{"tf":1.0},"51":{"tf":1.0},"53":{"tf":1.0},"54":{"tf":1.0},"55":{"tf":1.4142135623730951},"58":{"tf":1.0}}}},"v":{"df":0,"docs":{},"e":{"df":5,"docs":{"18":{"tf":1.0},"30":{"tf":1.0},"33":{"tf":1.0},"66":{"tf":1.0},"67":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"a":{"d":{"df":2,"docs":{"19":{"tf":1.4142135623730951},"56":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"65":{"tf":1.0},"68":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":1,"docs":{"19":{"tf":1.4142135623730951}}}},"p":{"df":3,"docs":{"21":{"tf":1.0},"31":{"tf":1.0},"33":{"tf":1.0}}}},"r":{"df":0,"docs":{},"e":{".":{".":{">":{"<":{"/":{"df":0,"docs":{},"s":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"53":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":3,"docs":{"20":{"tf":1.0},"43":{"tf":1.0},"65":{"tf":1.0}}}}},"i":{"d":{"df":0,"docs":{},"e":{"df":1,"docs":{"32":{"tf":1.0}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"df":4,"docs":{"38":{"tf":2.0},"39":{"tf":1.7320508075688772},"40":{"tf":2.8284271247461903},"41":{"tf":2.0}},"s":{".":{"<":{"df":0,"docs":{},"o":{"df":1,"docs":{"41":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"56":{"tf":1.0},"67":{"tf":1.0}}}},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"17":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"=":{"\"":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"/":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"/":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"55":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"{":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"43":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":9,"docs":{"44":{"tf":1.0},"45":{"tf":1.0},"46":{"tf":1.0},"47":{"tf":1.0},"48":{"tf":1.0},"49":{"tf":1.0},"50":{"tf":1.0},"51":{"tf":1.0},"56":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":14,"docs":{"0":{"tf":1.0},"19":{"tf":1.7320508075688772},"20":{"tf":1.0},"39":{"tf":1.4142135623730951},"40":{"tf":1.0},"43":{"tf":1.7320508075688772},"44":{"tf":1.4142135623730951},"45":{"tf":1.0},"46":{"tf":1.0},"47":{"tf":1.0},"49":{"tf":1.0},"53":{"tf":2.6457513110645907},"55":{"tf":1.7320508075688772},"56":{"tf":1.0}}}},"t":{"df":0,"docs":{},"p":{":":{"/":{"/":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"/":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"/":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":1,"docs":{"67":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"c":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{":":{"9":{"0":{"0":{"0":{"/":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"i":{"df":1,"docs":{"69":{"tf":1.0}}}}},"df":0,"docs":{}},"df":2,"docs":{"69":{"tf":1.0},"70":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":2,"docs":{"20":{"tf":1.0},"69":{"tf":1.7320508075688772}},"s":{":":{"/":{"/":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"u":{"b":{".":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"/":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"k":{"df":3,"docs":{"64":{"tf":1.0},"65":{"tf":1.0},"8":{"tf":1.7320508075688772}}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"w":{"df":0,"docs":{},"w":{"df":0,"docs":{},"w":{".":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"3":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"i":{".":{"df":1,"docs":{"41":{"tf":1.0}}},"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"48":{"tf":1.7320508075688772}}}}},"d":{"df":1,"docs":{"37":{"tf":1.0}},"e":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"32":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":2,"docs":{"33":{"tf":1.0},"70":{"tf":1.0}}}}}},"m":{"a":{"df":0,"docs":{},"g":{"df":3,"docs":{"0":{"tf":1.0},"48":{"tf":1.0},"55":{"tf":2.6457513110645907}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"i":{"df":1,"docs":{"40":{"tf":1.0}}}},"df":0,"docs":{}}},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"57":{"tf":1.0},"71":{"tf":1.0}}}}}}},"i":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"44":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":5,"docs":{"28":{"tf":1.0},"32":{"tf":1.0},"44":{"tf":2.0},"46":{"tf":1.0},"65":{"tf":1.0}}}}}}},"n":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"d":{"df":11,"docs":{"28":{"tf":1.4142135623730951},"31":{"tf":1.0},"37":{"tf":1.0},"44":{"tf":1.0},"45":{"tf":1.0},"46":{"tf":1.0},"47":{"tf":1.0},"53":{"tf":1.0},"55":{"tf":1.0},"60":{"tf":1.0},"69":{"tf":1.0}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"44":{"tf":1.0}}}}}}}}},"df":0,"docs":{}}}},"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"62":{"tf":1.0}}},"df":0,"docs":{}}}},"x":{".":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":6,"docs":{"18":{"tf":1.0},"19":{"tf":1.4142135623730951},"22":{"tf":1.0},"40":{"tf":1.0},"49":{"tf":1.0},"61":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"i":{"c":{"df":1,"docs":{"40":{"tf":1.0}}},"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"d":{"df":0,"docs":{},"u":{"df":1,"docs":{"57":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"49":{"tf":1.0}}}},"o":{"df":1,"docs":{"44":{"tf":1.0}},"r":{"df":0,"docs":{},"m":{"df":4,"docs":{"17":{"tf":1.0},"27":{"tf":1.0},"36":{"tf":1.0},"60":{"tf":1.0}}}}}},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"65":{"tf":1.0}},"i":{"df":7,"docs":{"19":{"tf":1.0},"44":{"tf":1.4142135623730951},"61":{"tf":2.0},"62":{"tf":1.4142135623730951},"63":{"tf":1.0},"64":{"tf":1.0},"65":{"tf":3.0}}}}},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"65":{"tf":1.0}}}},"df":0,"docs":{}}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":3,"docs":{"45":{"tf":1.4142135623730951},"47":{"tf":1.4142135623730951},"49":{"tf":1.7320508075688772}}}}},"s":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"69":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}},"i":{"d":{"df":9,"docs":{"19":{"tf":1.4142135623730951},"44":{"tf":1.0},"45":{"tf":1.0},"46":{"tf":1.0},"47":{"tf":1.0},"48":{"tf":1.0},"50":{"tf":1.0},"51":{"tf":1.0},"53":{"tf":1.0}}},"df":0,"docs":{}},"t":{"a":{"df":0,"docs":{},"l":{"df":16,"docs":{"1":{"tf":1.0},"10":{"tf":1.7320508075688772},"11":{"tf":1.0},"12":{"tf":1.7320508075688772},"13":{"tf":1.0},"14":{"tf":1.7320508075688772},"15":{"tf":1.7320508075688772},"16":{"tf":1.4142135623730951},"17":{"tf":1.0},"3":{"tf":2.0},"4":{"tf":2.0},"5":{"tf":2.0},"6":{"tf":2.0},"7":{"tf":2.23606797749979},"8":{"tf":2.8284271247461903},"9":{"tf":2.23606797749979}}},"n":{"c":{"df":3,"docs":{"63":{"tf":1.0},"64":{"tf":1.0},"65":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"a":{"d":{"df":5,"docs":{"31":{"tf":1.0},"44":{"tf":2.0},"45":{"tf":1.0},"47":{"tf":1.0},"56":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":4,"docs":{"22":{"tf":1.0},"3":{"tf":1.0},"44":{"tf":2.449489742783178},"56":{"tf":1.0}}}},"df":0,"docs":{}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"df":6,"docs":{"44":{"tf":1.4142135623730951},"45":{"tf":1.4142135623730951},"46":{"tf":1.4142135623730951},"47":{"tf":1.4142135623730951},"48":{"tf":1.4142135623730951},"58":{"tf":2.23606797749979}}}},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"j":{"df":1,"docs":{"37":{"tf":1.7320508075688772}}}}}},"r":{"df":0,"docs":{},"f":{"a":{"c":{"df":2,"docs":{"20":{"tf":1.0},"60":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"60":{"tf":1.7320508075688772},"61":{"tf":1.0}}}}}}}},"r":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"0":{"tf":1.7320508075688772}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"69":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"n":{"'":{"df":0,"docs":{},"t":{"df":2,"docs":{"38":{"tf":1.0},"67":{"tf":1.0}}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"u":{"df":3,"docs":{"57":{"tf":1.0},"61":{"tf":1.0},"71":{"tf":1.0}}}}},"t":{"'":{"df":1,"docs":{"67":{"tf":1.0}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":5,"docs":{"19":{"tf":1.0},"3":{"tf":1.0},"55":{"tf":1.0},"57":{"tf":1.0},"61":{"tf":1.0}}}}}}}},"j":{"a":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"s":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":7,"docs":{"20":{"tf":1.0},"44":{"tf":1.4142135623730951},"49":{"tf":1.4142135623730951},"60":{"tf":2.6457513110645907},"61":{"tf":1.4142135623730951},"64":{"tf":1.0},"65":{"tf":1.7320508075688772}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{},"s":{"df":3,"docs":{"0":{"tf":1.0},"49":{"tf":1.0},"54":{"tf":2.0}},"o":{"df":0,"docs":{},"n":{"df":4,"docs":{"30":{"tf":1.0},"32":{"tf":1.4142135623730951},"34":{"tf":1.0},"37":{"tf":1.4142135623730951}}}}}},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":4,"docs":{"13":{"tf":1.0},"32":{"tf":1.4142135623730951},"44":{"tf":1.0},"67":{"tf":1.4142135623730951}}}},"y":{"df":1,"docs":{"41":{"tf":1.0}}}},"n":{"df":0,"docs":{},"o":{"b":{"df":0,"docs":{},"s":{"/":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"67":{"tf":1.0}}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{},"w":{"df":3,"docs":{"33":{"tf":1.0},"56":{"tf":1.0},"71":{"tf":1.0}},"n":{"df":1,"docs":{"57":{"tf":1.0}}}}}}},"l":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{".":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"/":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"/":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"3":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"=":{"\"":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"19":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"38":{"tf":1.0}}}},"df":0,"docs":{}}},"y":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"28":{"tf":1.4142135623730951}}}},"m":{"a":{"df":0,"docs":{},"n":{"'":{"df":1,"docs":{"0":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"t":{"df":1,"docs":{"69":{"tf":1.0}}}},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"65":{"tf":1.0}}}}}},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":1,"docs":{"20":{"tf":1.0}}}}},"t":{"df":1,"docs":{"71":{"tf":1.0}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":4,"docs":{"31":{"tf":1.0},"33":{"tf":1.0},"44":{"tf":1.4142135623730951},"57":{"tf":1.0}}},"r":{"a":{"df":0,"docs":{},"g":{"df":2,"docs":{"22":{"tf":1.0},"32":{"tf":1.0}}}},"df":0,"docs":{}}}}},"i":{"b":{".":{"df":0,"docs":{},"r":{"df":1,"docs":{"66":{"tf":1.0}}}},"df":1,"docs":{"66":{"tf":1.0}},"r":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":2,"docs":{"44":{"tf":1.0},"66":{"tf":1.7320508075688772}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":1,"docs":{"67":{"tf":1.0}}}},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"30":{"tf":1.0}}}}},"n":{"df":0,"docs":{},"e":{"df":7,"docs":{"17":{"tf":1.4142135623730951},"28":{"tf":1.4142135623730951},"3":{"tf":1.0},"31":{"tf":2.23606797749979},"32":{"tf":1.0},"5":{"tf":1.0},"57":{"tf":1.0}}},"k":{"df":7,"docs":{"43":{"tf":2.449489742783178},"44":{"tf":1.4142135623730951},"45":{"tf":1.7320508075688772},"46":{"tf":1.4142135623730951},"47":{"tf":1.7320508075688772},"55":{"tf":2.0},"67":{"tf":1.0}}},"u":{"df":0,"docs":{},"x":{"df":1,"docs":{"41":{"tf":1.7320508075688772}}}}},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"43":{"tf":1.0},"44":{"tf":1.0}},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"69":{"tf":1.4142135623730951}}}}}},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":1,"docs":{"32":{"tf":1.0}}}}}},"o":{"a":{"d":{"df":8,"docs":{"19":{"tf":1.0},"28":{"tf":1.0},"29":{"tf":1.0},"31":{"tf":1.0},"44":{"tf":2.449489742783178},"62":{"tf":1.0},"63":{"tf":1.0},"65":{"tf":2.0}},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"44":{"tf":1.4142135623730951},"65":{"tf":1.0}}}}},"df":0,"docs":{}},"c":{"a":{"df":0,"docs":{},"l":{"df":4,"docs":{"29":{"tf":1.0},"46":{"tf":1.0},"69":{"tf":1.0},"9":{"tf":2.0}}},"t":{"df":4,"docs":{"28":{"tf":1.0},"29":{"tf":1.0},"56":{"tf":1.0},"67":{"tf":1.0}}}},"df":0,"docs":{},"k":{"df":1,"docs":{"7":{"tf":1.0}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"65":{"tf":1.0}}}}}},"o":{"df":0,"docs":{},"k":{"df":5,"docs":{"43":{"tf":1.0},"44":{"tf":1.7320508075688772},"46":{"tf":1.0},"53":{"tf":1.0},"67":{"tf":1.0}}}}}},"m":{"a":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"4":{"tf":1.0}}}}},"o":{"df":1,"docs":{"41":{"tf":1.4142135623730951}}}},"d":{"df":0,"docs":{},"e":{"df":1,"docs":{"32":{"tf":1.0}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"67":{"tf":1.0}}},"df":0,"docs":{}}},"i":{"df":0,"docs":{},"n":{"df":4,"docs":{"19":{"tf":1.0},"44":{"tf":2.0},"66":{"tf":1.0},"8":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"18":{"tf":1.0}}}}}},"k":{"df":0,"docs":{},"e":{"df":1,"docs":{"44":{"tf":1.0}}}},"n":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"13":{"tf":1.0}}}},"df":0,"docs":{},"i":{"df":1,"docs":{"67":{"tf":1.0}}},"u":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"20":{"tf":1.0}}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"k":{"df":1,"docs":{"32":{"tf":1.0}}}},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":1,"docs":{"28":{"tf":1.0}}}}}},"t":{"c":{"df":0,"docs":{},"h":{"df":2,"docs":{"12":{"tf":1.0},"69":{"tf":1.0}}}},"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"55":{"tf":1.0}}}}},"x":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":1,"docs":{"22":{"tf":1.0}}}}}}},"y":{"b":{"df":1,"docs":{"20":{"tf":1.0}}},"df":0,"docs":{}}},"df":1,"docs":{"57":{"tf":1.0}},"e":{"a":{"df":0,"docs":{},"n":{"df":3,"docs":{"30":{"tf":1.0},"44":{"tf":1.0},"67":{"tf":1.0}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"28":{"tf":1.0}}}}}}},"t":{"a":{"d":{"a":{"df":0,"docs":{},"t":{"a":{"df":1,"docs":{"29":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":1,"docs":{"19":{"tf":1.0}}},"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"d":{"df":1,"docs":{"65":{"tf":1.0}}},"df":0,"docs":{}}}}},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"32":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":5,"docs":{"46":{"tf":1.7320508075688772},"47":{"tf":1.4142135623730951},"48":{"tf":1.4142135623730951},"53":{"tf":1.4142135623730951},"57":{"tf":2.6457513110645907}},"i":{"df":5,"docs":{"46":{"tf":1.0},"47":{"tf":1.0},"48":{"tf":1.0},"53":{"tf":1.0},"57":{"tf":2.8284271247461903}}}}}},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"32":{"tf":1.0}}}}},"j":{"df":1,"docs":{"49":{"tf":1.0}}},"k":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"69":{"tf":1.0}}}}}},"df":0,"docs":{}},"o":{"d":{"df":0,"docs":{},"e":{"df":1,"docs":{"44":{"tf":2.449489742783178}},"l":{"df":2,"docs":{"30":{"tf":1.4142135623730951},"34":{"tf":1.0}}}},"i":{"df":0,"docs":{},"f":{"df":2,"docs":{"46":{"tf":1.0},"53":{"tf":1.0}}}},"u":{"df":0,"docs":{},"l":{"df":3,"docs":{"44":{"tf":1.4142135623730951},"49":{"tf":1.0},"65":{"tf":1.4142135623730951}}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":10,"docs":{"12":{"tf":1.0},"20":{"tf":1.7320508075688772},"32":{"tf":1.0},"44":{"tf":1.0},"46":{"tf":1.0},"52":{"tf":1.0},"59":{"tf":1.0},"60":{"tf":1.0},"67":{"tf":1.0},"71":{"tf":1.0}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"67":{"tf":1.0}}}}}},"v":{"df":0,"docs":{},"e":{"df":2,"docs":{"30":{"tf":1.0},"32":{"tf":1.4142135623730951}}}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":3,"docs":{"41":{"tf":1.0},"44":{"tf":1.4142135623730951},"70":{"tf":1.7320508075688772}}}}}}}},"y":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"65":{"tf":1.0}}}}}}}}},"n":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":5,"docs":{"31":{"tf":1.0},"40":{"tf":1.0},"44":{"tf":3.1622776601683795},"60":{"tf":1.0},"67":{"tf":1.0}}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":1,"docs":{"6":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":2,"docs":{"60":{"tf":1.0},"67":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"e":{"d":{"df":8,"docs":{"2":{"tf":1.0},"32":{"tf":1.7320508075688772},"36":{"tf":1.0},"37":{"tf":1.0},"38":{"tf":1.0},"55":{"tf":1.0},"56":{"tf":1.0},"66":{"tf":1.0}}},"df":0,"docs":{}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"57":{"tf":1.7320508075688772}}}}},"w":{"df":4,"docs":{"19":{"tf":1.0},"23":{"tf":1.0},"33":{"tf":1.0},"39":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"17":{"tf":1.0},"32":{"tf":1.0}}}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"19":{"tf":1.0}}}}},"x":{"df":0,"docs":{},"t":{"df":2,"docs":{"20":{"tf":1.4142135623730951},"32":{"tf":1.0}}}}},"i":{"c":{"df":0,"docs":{},"e":{"df":3,"docs":{"26":{"tf":1.0},"46":{"tf":1.0},"55":{"tf":1.0}}}},"df":0,"docs":{},"x":{"df":1,"docs":{"16":{"tf":2.0}}}},"o":{"df":0,"docs":{},"n":{"df":2,"docs":{"17":{"tf":1.0},"53":{"tf":1.0}},"e":{"df":2,"docs":{"40":{"tf":1.0},"58":{"tf":1.0}}}},"r":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"l":{"df":2,"docs":{"11":{"tf":1.0},"55":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"e":{"df":5,"docs":{"19":{"tf":1.0},"33":{"tf":1.0},"39":{"tf":1.0},"55":{"tf":1.0},"62":{"tf":1.0}}}},"w":{"df":5,"docs":{"28":{"tf":1.4142135623730951},"32":{"tf":1.0},"33":{"tf":1.0},"65":{"tf":1.0},"67":{"tf":1.4142135623730951}}}},"u":{"df":0,"docs":{},"m":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"65":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}}},"o":{"b":{"df":0,"docs":{},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"44":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"35":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":1,"docs":{"3":{"tf":1.0}}}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"i":{"df":3,"docs":{"45":{"tf":1.0},"47":{"tf":1.0},"69":{"tf":1.0}}}},"df":0,"docs":{}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"2":{"tf":1.0}}}}}}},"l":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"32":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}},"n":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"s":{"df":1,"docs":{"57":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"c":{"df":1,"docs":{"3":{"tf":1.0}},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"65":{"tf":1.0}}}}}}}}},"df":7,"docs":{"17":{"tf":1.0},"32":{"tf":1.0},"40":{"tf":1.0},"41":{"tf":2.0},"43":{"tf":1.0},"44":{"tf":1.7320508075688772},"67":{"tf":1.7320508075688772}},"f":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"65":{"tf":1.0}}}}}}},"df":0,"docs":{}},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"65":{"tf":1.0}}}}}}}}}},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"65":{"tf":1.0}}}}},"df":0,"docs":{}},"u":{"c":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"65":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"p":{"a":{"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":1,"docs":{"57":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":2,"docs":{"19":{"tf":1.0},"71":{"tf":1.4142135623730951}},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"l":{"df":1,"docs":{"6":{"tf":1.0}}}}}},"r":{"df":1,"docs":{"3":{"tf":1.0}}}},"t":{"'":{"df":1,"docs":{"44":{"tf":1.0}}},"=":{"\"":{"0":{"df":1,"docs":{"44":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":6,"docs":{"44":{"tf":2.449489742783178},"46":{"tf":1.0},"47":{"tf":1.0},"48":{"tf":1.0},"53":{"tf":1.0},"57":{"tf":1.0}},"i":{"df":0,"docs":{},"m":{"df":1,"docs":{"44":{"tf":2.0}}},"o":{"df":0,"docs":{},"n":{"df":15,"docs":{"0":{"tf":1.0},"31":{"tf":1.0},"40":{"tf":1.0},"41":{"tf":1.0},"43":{"tf":1.4142135623730951},"44":{"tf":5.291502622129181},"45":{"tf":1.7320508075688772},"46":{"tf":1.7320508075688772},"47":{"tf":2.0},"48":{"tf":1.7320508075688772},"49":{"tf":1.0},"50":{"tf":1.0},"51":{"tf":1.0},"53":{"tf":1.7320508075688772},"70":{"tf":1.0}}}}}}},"r":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":4,"docs":{"39":{"tf":1.0},"40":{"tf":1.0},"61":{"tf":1.4142135623730951},"66":{"tf":1.0}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":3,"docs":{"19":{"tf":1.0},"44":{"tf":1.0},"67":{"tf":1.0}}}}}}},"s":{"df":2,"docs":{"16":{"tf":1.4142135623730951},"41":{"tf":2.23606797749979}}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"29":{"tf":1.0}}}}}}}}},"u":{"df":0,"docs":{},"t":{"df":9,"docs":{"0":{"tf":1.0},"26":{"tf":1.0},"27":{"tf":1.0},"46":{"tf":1.0},"47":{"tf":1.0},"48":{"tf":1.0},"53":{"tf":1.0},"57":{"tf":1.0},"9":{"tf":1.0}},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":10,"docs":{"43":{"tf":1.0},"44":{"tf":1.7320508075688772},"45":{"tf":1.0},"46":{"tf":1.0},"47":{"tf":1.0},"48":{"tf":1.0},"50":{"tf":1.0},"51":{"tf":1.0},"53":{"tf":1.4142135623730951},"56":{"tf":1.0}}}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"55":{"tf":1.0},"69":{"tf":1.0}},"r":{"df":0,"docs":{},"i":{"d":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":3,"docs":{"28":{"tf":1.4142135623730951},"31":{"tf":1.0},"58":{"tf":1.0}}}}},"df":4,"docs":{"28":{"tf":1.0},"31":{"tf":1.0},"41":{"tf":2.0},"44":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":1,"docs":{"39":{"tf":1.0}}}}}}}}}},"p":{"a":{"c":{"df":0,"docs":{},"k":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"5":{"tf":1.0}},"e":{".":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"a":{"d":{"a":{"df":0,"docs":{},"t":{"a":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"k":{".":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"d":{"df":1,"docs":{"30":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"v":{"df":1,"docs":{"30":{"tf":1.0}}}}}}},"df":1,"docs":{"30":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"/":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":1,"docs":{"61":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"r":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":1,"docs":{"39":{"tf":1.4142135623730951}}}}}},"m":{"df":1,"docs":{"44":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"t":{"df":2,"docs":{"68":{"tf":1.0},"69":{"tf":1.0}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"44":{"tf":1.4142135623730951}}}}},"s":{"df":1,"docs":{"39":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"28":{"tf":1.0}}}}},"t":{"df":1,"docs":{"31":{"tf":1.0}}}},"s":{"df":0,"docs":{},"s":{"df":4,"docs":{"40":{"tf":1.0},"56":{"tf":1.0},"68":{"tf":1.0},"69":{"tf":1.0}}}},"t":{"df":0,"docs":{},"h":{"/":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":1,"docs":{"67":{"tf":1.0}}}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"/":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"35":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":13,"docs":{"31":{"tf":1.0},"40":{"tf":2.23606797749979},"44":{"tf":2.449489742783178},"45":{"tf":2.0},"46":{"tf":2.0},"47":{"tf":2.0},"48":{"tf":2.0},"50":{"tf":2.0},"51":{"tf":2.0},"53":{"tf":2.0},"67":{"tf":3.1622776601683795},"69":{"tf":1.7320508075688772},"9":{"tf":1.0}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":4,"docs":{"0":{"tf":1.0},"12":{"tf":1.4142135623730951},"46":{"tf":1.4142135623730951},"55":{"tf":1.0}}}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"57":{"tf":1.0}},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":8,"docs":{"17":{"tf":1.0},"20":{"tf":1.0},"38":{"tf":1.0},"41":{"tf":1.0},"49":{"tf":1.0},"50":{"tf":1.0},"51":{"tf":1.0},"57":{"tf":1.0}}}}}},"i":{"df":0,"docs":{},"o":{"d":{"df":1,"docs":{"65":{"tf":1.0}}},"df":0,"docs":{}}}}},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":5,"docs":{"22":{"tf":1.0},"38":{"tf":1.0},"40":{"tf":1.0},"43":{"tf":1.0},"53":{"tf":1.0}}}}}}}},"l":{"a":{"c":{"df":0,"docs":{},"e":{"df":10,"docs":{"39":{"tf":1.7320508075688772},"44":{"tf":1.4142135623730951},"45":{"tf":1.4142135623730951},"46":{"tf":1.4142135623730951},"47":{"tf":1.4142135623730951},"48":{"tf":1.4142135623730951},"50":{"tf":1.4142135623730951},"51":{"tf":1.4142135623730951},"53":{"tf":1.4142135623730951},"67":{"tf":1.0}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":6,"docs":{"44":{"tf":1.4142135623730951},"45":{"tf":1.0},"46":{"tf":1.0},"47":{"tf":1.0},"48":{"tf":1.0},"67":{"tf":1.0}}}},"n":{"df":1,"docs":{"39":{"tf":1.0}}},"t":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":1,"docs":{"11":{"tf":1.0}}}}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"s":{"df":3,"docs":{"39":{"tf":1.0},"55":{"tf":1.0},"71":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":6,"docs":{"18":{"tf":1.0},"40":{"tf":1.0},"45":{"tf":1.0},"46":{"tf":1.0},"47":{"tf":1.0},"53":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"20":{"tf":1.0}}}}}}},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"30":{"tf":1.7320508075688772}}}},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"l":{"df":6,"docs":{"33":{"tf":1.0},"44":{"tf":1.4142135623730951},"57":{"tf":1.4142135623730951},"65":{"tf":1.0},"66":{"tf":1.0},"67":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"t":{"_":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"d":{"df":2,"docs":{"39":{"tf":1.0},"40":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"w":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"22":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"e":{"_":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"d":{"df":2,"docs":{"39":{"tf":1.0},"40":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"c":{"df":0,"docs":{},"e":{"d":{"df":1,"docs":{"70":{"tf":1.0}}},"df":0,"docs":{}}},"df":9,"docs":{"10":{"tf":1.7320508075688772},"12":{"tf":1.0},"17":{"tf":1.0},"2":{"tf":2.0},"3":{"tf":1.0},"32":{"tf":1.4142135623730951},"33":{"tf":1.0},"4":{"tf":1.0},"5":{"tf":1.0}},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"x":{"df":2,"docs":{"67":{"tf":1.4142135623730951},"69":{"tf":1.7320508075688772}}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":9,"docs":{"44":{"tf":1.0},"45":{"tf":1.0},"46":{"tf":1.0},"47":{"tf":1.0},"48":{"tf":1.0},"49":{"tf":1.0},"50":{"tf":1.0},"51":{"tf":1.0},"53":{"tf":1.0}}}},"r":{"df":0,"docs":{},"v":{"df":1,"docs":{"44":{"tf":1.0}}}}}},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"19":{"tf":1.0}}}}},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":1,"docs":{"65":{"tf":1.0}}}}}}},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"22":{"tf":1.0}}}}},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"26":{"tf":1.0},"27":{"tf":1.0}}}},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"33":{"tf":1.0}}}}},"o":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"d":{"df":1,"docs":{"40":{"tf":1.0}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"s":{"df":16,"docs":{"11":{"tf":1.0},"13":{"tf":1.0},"20":{"tf":1.0},"38":{"tf":1.0},"39":{"tf":1.0},"4":{"tf":1.0},"40":{"tf":1.4142135623730951},"42":{"tf":1.0},"43":{"tf":1.0},"45":{"tf":1.0},"46":{"tf":1.0},"47":{"tf":1.0},"53":{"tf":1.4142135623730951},"57":{"tf":1.4142135623730951},"6":{"tf":1.0},"65":{"tf":2.0}}}}}},"d":{"df":0,"docs":{},"u":{"c":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":2,"docs":{"40":{"tf":1.0},"44":{"tf":2.8284271247461903}}}}},"g":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":2,"docs":{"65":{"tf":1.0},"71":{"tf":1.0}}}}}}},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":13,"docs":{"1":{"tf":1.0},"18":{"tf":2.0},"19":{"tf":2.8284271247461903},"20":{"tf":1.4142135623730951},"27":{"tf":1.0},"28":{"tf":1.0},"29":{"tf":1.4142135623730951},"3":{"tf":1.4142135623730951},"31":{"tf":1.0},"32":{"tf":1.0},"33":{"tf":1.0},"44":{"tf":2.449489742783178},"66":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"v":{"df":0,"docs":{},"i":{"d":{"df":7,"docs":{"34":{"tf":1.0},"36":{"tf":1.4142135623730951},"40":{"tf":1.0},"41":{"tf":1.0},"44":{"tf":1.0},"65":{"tf":1.0},"67":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"x":{"df":0,"docs":{},"i":{"df":4,"docs":{"67":{"tf":2.23606797749979},"68":{"tf":2.6457513110645907},"69":{"tf":5.291502622129181},"70":{"tf":2.8284271247461903}}}}}},"u":{"b":{"df":1,"docs":{"66":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"c":{"df":3,"docs":{"40":{"tf":1.0},"56":{"tf":2.0},"67":{"tf":3.4641016151377544}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"11":{"tf":1.0}}}}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":1,"docs":{"71":{"tf":1.4142135623730951}}}},"r":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":1,"docs":{"39":{"tf":1.0}}}}}}}},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":2,"docs":{"68":{"tf":1.0},"69":{"tf":1.0}}}}}}},"r":{"df":0,"docs":{},"e":{"a":{"d":{"df":1,"docs":{"39":{"tf":1.0}},"i":{"df":1,"docs":{"54":{"tf":1.0}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":3,"docs":{"28":{"tf":1.4142135623730951},"3":{"tf":1.0},"67":{"tf":1.4142135623730951}}}}}},"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":2,"docs":{"65":{"tf":1.4142135623730951},"69":{"tf":1.7320508075688772}}}},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"13":{"tf":1.0},"8":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"44":{"tf":1.0}}},"df":0,"docs":{}}}}}},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":1,"docs":{"51":{"tf":1.0}}}}}},"d":{"df":0,"docs":{},"u":{"c":{"df":1,"docs":{"44":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"f":{"df":1,"docs":{"44":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":3,"docs":{"37":{"tf":1.0},"44":{"tf":1.7320508075688772},"55":{"tf":1.0}},"e":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"55":{"tf":1.0}}},"df":0,"docs":{}}}}}},"l":{"=":{"\"":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"i":{"df":3,"docs":{"50":{"tf":1.0},"51":{"tf":1.0},"55":{"tf":1.4142135623730951}}}}},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"46":{"tf":1.0}}}}},"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"48":{"tf":1.0}}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"49":{"tf":1.0}}}}}}},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"44":{"tf":1.0}}}}}},"s":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"45":{"tf":1.0}}}}},"c":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"45":{"tf":1.0}}}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":2,"docs":{"45":{"tf":1.0},"47":{"tf":1.0}}}}}}}}}}}},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"47":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"{":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":1,"docs":{"43":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}},"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"69":{"tf":1.0}}}},"df":12,"docs":{"29":{"tf":1.0},"31":{"tf":1.0},"44":{"tf":1.0},"45":{"tf":1.0},"46":{"tf":1.0},"47":{"tf":1.0},"48":{"tf":1.0},"50":{"tf":1.0},"51":{"tf":1.0},"53":{"tf":1.0},"56":{"tf":1.4142135623730951},"67":{"tf":1.4142135623730951}},"e":{"a":{"df":0,"docs":{},"s":{"df":13,"docs":{"10":{"tf":1.0},"11":{"tf":2.0},"12":{"tf":1.0},"13":{"tf":1.4142135623730951},"17":{"tf":1.0},"28":{"tf":1.0},"32":{"tf":1.0},"33":{"tf":1.0},"40":{"tf":1.0},"44":{"tf":2.449489742783178},"57":{"tf":1.0},"6":{"tf":1.0},"7":{"tf":1.7320508075688772}}}},"df":0,"docs":{},"v":{"df":1,"docs":{"40":{"tf":1.0}}}},"o":{"a":{"d":{"df":1,"docs":{"67":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"v":{"df":2,"docs":{"32":{"tf":1.0},"55":{"tf":1.0}}}}},"n":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"61":{"tf":1.0}}}}},"df":0,"docs":{}},"p":{"df":0,"docs":{},"l":{"a":{"c":{"df":3,"docs":{"39":{"tf":1.0},"43":{"tf":1.0},"53":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"o":{"df":1,"docs":{"70":{"tf":1.0}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"9":{"tf":1.0}}}}}}}}}},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":4,"docs":{"20":{"tf":1.0},"68":{"tf":1.0},"69":{"tf":2.6457513110645907},"71":{"tf":1.4142135623730951}}}}},"i":{"df":0,"docs":{},"r":{"df":12,"docs":{"1":{"tf":1.0},"2":{"tf":1.0},"27":{"tf":1.0},"3":{"tf":1.0},"33":{"tf":2.0},"4":{"tf":1.0},"40":{"tf":1.4142135623730951},"41":{"tf":1.0},"43":{"tf":1.0},"54":{"tf":1.0},"65":{"tf":1.0},"70":{"tf":1.0}}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":3,"docs":{"2":{"tf":2.0},"3":{"tf":1.0},"4":{"tf":1.0}}}}}}}},"s":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"40":{"tf":1.0}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"v":{"df":3,"docs":{"29":{"tf":1.0},"31":{"tf":1.0},"46":{"tf":1.0}}}},"u":{"df":0,"docs":{},"r":{"c":{"df":8,"docs":{"44":{"tf":1.4142135623730951},"45":{"tf":1.0},"46":{"tf":1.0},"47":{"tf":1.0},"48":{"tf":1.0},"55":{"tf":2.23606797749979},"58":{"tf":2.0},"67":{"tf":1.0}}},"df":0,"docs":{}}}},"t":{"df":3,"docs":{"45":{"tf":1.0},"47":{"tf":1.0},"54":{"tf":1.0}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":1,"docs":{"67":{"tf":1.0}}}}}},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":2,"docs":{"40":{"tf":1.0},"65":{"tf":1.4142135623730951}}}}}},"v":{"df":1,"docs":{"8":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":2,"docs":{"67":{"tf":2.0},"69":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":1,"docs":{"71":{"tf":1.0}}}}}},"w":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":2,"docs":{"69":{"tf":1.4142135623730951},"70":{"tf":1.4142135623730951}},"e":{"=":{"/":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"i":{"df":1,"docs":{"69":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"69":{"tf":1.0}}}}}}}}}},"l":{"df":0,"docs":{},"i":{"b":{"df":1,"docs":{"66":{"tf":1.0}}},"df":0,"docs":{}}},"o":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"54":{"tf":1.0}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":13,"docs":{"19":{"tf":1.0},"29":{"tf":1.4142135623730951},"31":{"tf":1.0},"33":{"tf":1.0},"44":{"tf":1.0},"45":{"tf":1.0},"46":{"tf":1.0},"47":{"tf":1.0},"48":{"tf":1.0},"50":{"tf":1.0},"51":{"tf":1.0},"53":{"tf":1.0},"67":{"tf":1.0}}}},"u":{"df":0,"docs":{},"t":{"df":2,"docs":{"56":{"tf":1.0},"69":{"tf":1.0}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"37":{"tf":1.0}}}}}},"s":{"/":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"k":{"/":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"/":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"/":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"/":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"65":{"tf":1.0}}}}}}},"v":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"a":{"df":1,"docs":{"64":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":1,"docs":{"8":{"tf":1.7320508075688772}}}}}}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":2,"docs":{"43":{"tf":1.0},"53":{"tf":1.0}}}},"n":{"df":13,"docs":{"12":{"tf":1.0},"18":{"tf":1.0},"19":{"tf":1.0},"2":{"tf":1.0},"22":{"tf":1.4142135623730951},"35":{"tf":1.0},"44":{"tf":1.4142135623730951},"57":{"tf":1.0},"60":{"tf":1.0},"64":{"tf":1.4142135623730951},"65":{"tf":1.0},"66":{"tf":1.0},"68":{"tf":1.0}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":2,"docs":{"17":{"tf":1.0},"56":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"t":{"'":{"df":1,"docs":{"22":{"tf":1.0}}},"df":10,"docs":{"0":{"tf":1.0},"19":{"tf":1.4142135623730951},"3":{"tf":2.449489742783178},"37":{"tf":1.0},"4":{"tf":1.4142135623730951},"44":{"tf":2.23606797749979},"5":{"tf":1.4142135623730951},"55":{"tf":1.0},"6":{"tf":1.0},"60":{"tf":1.4142135623730951}},"i":{"df":1,"docs":{"0":{"tf":1.0}}},"l":{"df":1,"docs":{"6":{"tf":1.4142135623730951}}},"u":{"df":0,"docs":{},"p":{"df":2,"docs":{"3":{"tf":1.0},"4":{"tf":1.4142135623730951}}}}}}}},"s":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":7,"docs":{"23":{"tf":1.0},"24":{"tf":1.0},"33":{"tf":1.0},"39":{"tf":1.0},"40":{"tf":1.0},"41":{"tf":1.0},"65":{"tf":1.0}}}},"s":{"df":0,"docs":{},"s":{"/":{"df":0,"docs":{},"s":{"c":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":2,"docs":{"45":{"tf":2.0},"47":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":1,"docs":{"45":{"tf":1.4142135623730951}}}}},"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"a":{".":{"df":0,"docs":{},"j":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":2,"docs":{"34":{"tf":1.0},"37":{"tf":1.0}}}}}}},"df":5,"docs":{"32":{"tf":1.0},"34":{"tf":2.23606797749979},"35":{"tf":2.449489742783178},"36":{"tf":1.4142135623730951},"37":{"tf":2.0}}},"df":0,"docs":{}}}},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"/":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"x":{"df":1,"docs":{"67":{"tf":1.0}}}}}}}}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{">":{"<":{"/":{"df":0,"docs":{},"s":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"53":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":9,"docs":{"44":{"tf":1.4142135623730951},"45":{"tf":1.0},"46":{"tf":1.0},"47":{"tf":1.0},"48":{"tf":1.0},"49":{"tf":1.4142135623730951},"52":{"tf":1.7320508075688772},"53":{"tf":3.872983346207417},"64":{"tf":1.4142135623730951}}}}}},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"0":{"tf":1.0}}}}},"df":1,"docs":{"44":{"tf":1.4142135623730951}},"e":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"69":{"tf":1.0}}}}}}}}},"r":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"29":{"tf":1.0}}}},"df":0,"docs":{}}},"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":5,"docs":{"11":{"tf":1.0},"30":{"tf":1.0},"36":{"tf":1.0},"6":{"tf":1.0},"70":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{},"e":{"df":12,"docs":{"44":{"tf":1.4142135623730951},"46":{"tf":1.7320508075688772},"47":{"tf":1.0},"48":{"tf":1.0},"53":{"tf":1.0},"55":{"tf":1.0},"57":{"tf":1.0},"58":{"tf":1.0},"60":{"tf":1.0},"61":{"tf":1.0},"64":{"tf":1.0},"65":{"tf":1.0}}},"g":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"69":{"tf":1.4142135623730951}}}}}}},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"44":{"tf":1.0},"8":{"tf":1.0}}}},"df":0,"docs":{}},"f":{"df":2,"docs":{"53":{"tf":1.0},"69":{"tf":1.4142135623730951}}}},"n":{"df":0,"docs":{},"s":{"df":1,"docs":{"32":{"tf":1.0}}}},"p":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"44":{"tf":1.0}}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"v":{"df":7,"docs":{"19":{"tf":1.4142135623730951},"24":{"tf":1.7320508075688772},"30":{"tf":1.4142135623730951},"55":{"tf":1.0},"67":{"tf":3.605551275463989},"68":{"tf":1.0},"69":{"tf":2.0}},"e":{"df":0,"docs":{},"r":{"df":4,"docs":{"24":{"tf":1.0},"6":{"tf":1.4142135623730951},"65":{"tf":1.0},"69":{"tf":2.0}}}}}},"t":{"df":9,"docs":{"21":{"tf":1.0},"22":{"tf":1.0},"28":{"tf":1.4142135623730951},"29":{"tf":1.0},"32":{"tf":1.0},"44":{"tf":2.6457513110645907},"56":{"tf":1.0},"65":{"tf":1.0},"67":{"tf":1.4142135623730951}},"u":{"df":0,"docs":{},"p":{"df":1,"docs":{"54":{"tf":1.0}}}}}},"h":{"a":{"2":{"5":{"6":{"df":1,"docs":{"58":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"3":{"8":{"4":{"df":6,"docs":{"44":{"tf":1.0},"45":{"tf":1.0},"46":{"tf":1.0},"47":{"tf":1.0},"48":{"tf":1.0},"58":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"5":{"1":{"2":{"df":1,"docs":{"58":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":1,"docs":{"71":{"tf":1.0}}}}},"df":1,"docs":{"41":{"tf":1.0}},"i":{"df":0,"docs":{},"m":{"df":1,"docs":{"44":{"tf":1.4142135623730951}}},"p":{"df":2,"docs":{"21":{"tf":1.0},"68":{"tf":1.0}}}},"o":{"df":0,"docs":{},"w":{"df":3,"docs":{"26":{"tf":1.7320508075688772},"27":{"tf":2.0},"31":{"tf":1.0}},"n":{"df":1,"docs":{"17":{"tf":1.0}}}}}},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":1,"docs":{"69":{"tf":1.4142135623730951}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"33":{"tf":1.0}}}}}},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"i":{"df":1,"docs":{"12":{"tf":1.0}}},"l":{"df":4,"docs":{"0":{"tf":1.0},"18":{"tf":1.0},"42":{"tf":1.0},"67":{"tf":2.0}},"i":{"df":2,"docs":{"19":{"tf":1.0},"7":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"40":{"tf":1.0}}}},"df":0,"docs":{}}}}},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"l":{"df":1,"docs":{"67":{"tf":1.0}}}}},"z":{"df":0,"docs":{},"e":{"df":1,"docs":{"44":{"tf":1.0}}}}},"k":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":1,"docs":{"17":{"tf":1.0}}}}},"l":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"67":{"tf":1.0}}}}},"df":0,"docs":{}},"m":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":1,"docs":{"65":{"tf":1.0}}}}},"df":0,"docs":{}},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":7,"docs":{"0":{"tf":1.0},"54":{"tf":2.0},"60":{"tf":1.0},"62":{"tf":1.0},"64":{"tf":1.0},"65":{"tf":1.0},"70":{"tf":1.0}}}}}}}},"o":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"6":{"tf":1.7320508075688772}}}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"65":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"20":{"tf":1.0}}}},"u":{"df":0,"docs":{},"r":{"c":{"df":10,"docs":{"0":{"tf":1.0},"3":{"tf":1.0},"40":{"tf":1.0},"44":{"tf":1.4142135623730951},"45":{"tf":1.0},"46":{"tf":1.4142135623730951},"47":{"tf":1.0},"53":{"tf":1.0},"55":{"tf":1.0},"6":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}},"p":{"a":{"c":{"df":0,"docs":{},"e":{"df":1,"docs":{"44":{"tf":1.0}}}},"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{"df":3,"docs":{"22":{"tf":1.0},"24":{"tf":1.0},"40":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"k":{"df":1,"docs":{"28":{"tf":1.0}}}},"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":3,"docs":{"41":{"tf":1.7320508075688772},"44":{"tf":1.0},"8":{"tf":1.4142135623730951}},"i":{"df":9,"docs":{"40":{"tf":1.0},"41":{"tf":1.4142135623730951},"43":{"tf":1.0},"44":{"tf":2.6457513110645907},"48":{"tf":1.0},"49":{"tf":1.0},"50":{"tf":1.0},"51":{"tf":1.0},"69":{"tf":1.7320508075688772}}}}}},"df":0,"docs":{},"e":{"d":{"df":2,"docs":{"22":{"tf":1.0},"44":{"tf":1.0}}},"df":0,"docs":{}}}},"r":{"c":{"/":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{".":{"df":0,"docs":{},"r":{"df":1,"docs":{"19":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"=":{"\"":{"df":0,"docs":{},"{":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"53":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":1,"docs":{"53":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"l":{"df":1,"docs":{"69":{"tf":1.4142135623730951}}}},"t":{"a":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"6":{"tf":1.0}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":3,"docs":{"38":{"tf":1.0},"39":{"tf":2.0},"40":{"tf":2.449489742783178}}}},"n":{"d":{"a":{"df":0,"docs":{},"r":{"d":{"df":3,"docs":{"4":{"tf":1.0},"5":{"tf":1.4142135623730951},"6":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"r":{"df":1,"docs":{"20":{"tf":1.0}},"t":{"df":27,"docs":{"1":{"tf":2.0},"10":{"tf":1.0},"11":{"tf":1.0},"12":{"tf":1.0},"13":{"tf":1.0},"14":{"tf":1.0},"15":{"tf":1.4142135623730951},"16":{"tf":1.0},"17":{"tf":1.0},"18":{"tf":1.4142135623730951},"19":{"tf":1.7320508075688772},"2":{"tf":1.0},"20":{"tf":1.0},"3":{"tf":1.4142135623730951},"33":{"tf":1.0},"4":{"tf":1.0},"5":{"tf":1.0},"57":{"tf":1.0},"6":{"tf":1.0},"61":{"tf":1.0},"62":{"tf":1.0},"64":{"tf":1.0},"65":{"tf":1.0},"7":{"tf":1.0},"71":{"tf":1.4142135623730951},"8":{"tf":1.0},"9":{"tf":1.0}},"u":{"df":0,"docs":{},"p":{"df":5,"docs":{"6":{"tf":1.0},"61":{"tf":1.0},"62":{"tf":1.7320508075688772},"63":{"tf":1.0},"64":{"tf":1.0}}}}}}},"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"40":{"tf":1.0}}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"40":{"tf":1.0}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":3,"docs":{"20":{"tf":1.4142135623730951},"39":{"tf":3.4641016151377544},"41":{"tf":1.0}}}},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":2,"docs":{"28":{"tf":1.0},"32":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":1,"docs":{"69":{"tf":1.4142135623730951}}}},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"44":{"tf":1.0}}}}}}},"u":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"28":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"y":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":4,"docs":{"45":{"tf":1.0},"46":{"tf":1.0},"47":{"tf":1.0},"49":{"tf":1.0}}}}}},"u":{"b":{"df":2,"docs":{"31":{"tf":1.0},"58":{"tf":1.7320508075688772}},"s":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"1":{"tf":1.0},"59":{"tf":1.0}}}},"df":0,"docs":{}}}},"c":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"40":{"tf":1.0}},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"65":{"tf":1.4142135623730951}}}}}}}}}}},"df":0,"docs":{},"h":{"df":3,"docs":{"33":{"tf":1.0},"67":{"tf":1.0},"69":{"tf":1.7320508075688772}}}},"d":{"df":0,"docs":{},"o":{"df":1,"docs":{"15":{"tf":1.0}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"i":{"df":1,"docs":{"18":{"tf":1.0}}}},"df":0,"docs":{},"x":{"df":1,"docs":{"44":{"tf":1.0}}}}}},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":13,"docs":{"12":{"tf":1.0},"28":{"tf":1.0},"31":{"tf":1.0},"32":{"tf":1.0},"33":{"tf":1.4142135623730951},"36":{"tf":1.7320508075688772},"37":{"tf":1.0},"38":{"tf":1.0},"55":{"tf":1.0},"57":{"tf":1.0},"6":{"tf":1.0},"65":{"tf":1.0},"67":{"tf":1.0}}}}}}},"r":{"df":0,"docs":{},"e":{"df":1,"docs":{"44":{"tf":1.0}}}}},"v":{"df":0,"docs":{},"g":{"df":1,"docs":{"49":{"tf":1.0}}}},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"h":{"df":3,"docs":{"17":{"tf":1.0},"44":{"tf":1.0},"57":{"tf":1.0}}}},"df":0,"docs":{}}}},"y":{"df":0,"docs":{},"m":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":1,"docs":{"44":{"tf":1.0}}}}},"df":0,"docs":{}},"n":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"x":{"df":1,"docs":{"34":{"tf":1.0}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":5,"docs":{"28":{"tf":1.4142135623730951},"3":{"tf":1.0},"38":{"tf":1.0},"6":{"tf":1.0},"69":{"tf":1.0}}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":1,"docs":{"69":{"tf":1.0}}}}}}},"t":{"a":{"df":0,"docs":{},"g":{"df":6,"docs":{"43":{"tf":1.0},"45":{"tf":1.4142135623730951},"47":{"tf":1.4142135623730951},"49":{"tf":1.7320508075688772},"53":{"tf":2.23606797749979},"8":{"tf":1.7320508075688772}}},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"c":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"47":{"tf":1.0}}}}},"df":1,"docs":{"47":{"tf":2.0}}},"df":0,"docs":{}}}}}},"k":{"df":0,"docs":{},"e":{"df":5,"docs":{"32":{"tf":1.0},"39":{"tf":1.7320508075688772},"54":{"tf":1.0},"65":{"tf":1.0},"70":{"tf":1.0}}}},"p":{"df":1,"docs":{"65":{"tf":1.4142135623730951}}},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":11,"docs":{"22":{"tf":1.4142135623730951},"4":{"tf":2.449489742783178},"44":{"tf":2.6457513110645907},"45":{"tf":1.0},"46":{"tf":1.0},"47":{"tf":1.0},"48":{"tf":1.0},"50":{"tf":1.0},"51":{"tf":1.0},"53":{"tf":1.0},"55":{"tf":1.0}}}}}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"28":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":1,"docs":{"0":{"tf":1.0}},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"40":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"26":{"tf":1.0}}}},"x":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"d":{"df":1,"docs":{"19":{"tf":1.0}}},"df":0,"docs":{}}}},"df":1,"docs":{"19":{"tf":1.0}}}}},"h":{"a":{"df":0,"docs":{},"t":{"'":{"df":2,"docs":{"28":{"tf":1.0},"32":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"'":{"df":2,"docs":{"28":{"tf":1.0},"65":{"tf":1.0}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":2,"docs":{"18":{"tf":1.0},"4":{"tf":1.0}}}}}}},"y":{"'":{"df":0,"docs":{},"r":{"df":1,"docs":{"56":{"tf":1.0}}}},"df":0,"docs":{}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":5,"docs":{"0":{"tf":1.4142135623730951},"23":{"tf":1.0},"24":{"tf":1.0},"57":{"tf":1.0},"67":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":3,"docs":{"29":{"tf":1.0},"30":{"tf":1.0},"32":{"tf":1.4142135623730951}}}},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":2,"docs":{"31":{"tf":1.0},"32":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":3,"docs":{"43":{"tf":1.0},"53":{"tf":1.0},"67":{"tf":1.4142135623730951}}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":3,"docs":{"5":{"tf":1.0},"60":{"tf":1.0},"69":{"tf":1.0}},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"22":{"tf":1.0}}}}}}}}}}},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":3,"docs":{"39":{"tf":1.0},"41":{"tf":1.0},"6":{"tf":1.0}}}},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{">":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":1,"docs":{"19":{"tf":1.0}}}}}}}},"df":0,"docs":{}}}}},"l":{"df":1,"docs":{"6":{"tf":1.0}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"6":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"o":{"d":{"a":{"df":0,"docs":{},"y":{"df":2,"docs":{"32":{"tf":1.0},"67":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":1,"docs":{"32":{"tf":1.0}}}},"o":{"df":0,"docs":{},"l":{"df":5,"docs":{"18":{"tf":1.0},"2":{"tf":1.0},"27":{"tf":2.23606797749979},"3":{"tf":1.0},"5":{"tf":1.4142135623730951}}}},"p":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"59":{"tf":1.0}}},"df":0,"docs":{}}},"t":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"65":{"tf":1.7320508075688772}}}},"df":0,"docs":{}}},"r":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"30":{"tf":1.0}}}},"df":0,"docs":{}},"p":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"68":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"40":{"tf":1.0}}}},"df":0,"docs":{},"e":{"df":3,"docs":{"20":{"tf":1.0},"46":{"tf":1.0},"61":{"tf":1.0}}}},"i":{"df":3,"docs":{"2":{"tf":1.0},"28":{"tf":1.0},"29":{"tf":1.0}},"g":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":3,"docs":{"23":{"tf":1.0},"32":{"tf":1.0},"53":{"tf":1.0}}}}}}},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"k":{"#":{"3":{"df":1,"docs":{"46":{"tf":1.0}}},"7":{"df":1,"docs":{"46":{"tf":1.0}}},"9":{"df":1,"docs":{"55":{"tf":1.0}}},"df":0,"docs":{}},"'":{"df":7,"docs":{"13":{"tf":1.0},"26":{"tf":1.0},"28":{"tf":1.0},"30":{"tf":1.0},"38":{"tf":1.0},"39":{"tf":1.0},"40":{"tf":1.0}}},".":{"df":0,"docs":{},"j":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"29":{"tf":1.4142135623730951}}}}}},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":8,"docs":{"28":{"tf":1.0},"29":{"tf":1.4142135623730951},"30":{"tf":1.0},"32":{"tf":1.4142135623730951},"33":{"tf":1.0},"40":{"tf":1.0},"57":{"tf":1.0},"70":{"tf":1.4142135623730951}}}}}},"y":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":1,"docs":{"29":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}},"_":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"_":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":1,"docs":{"40":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"40":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}}}}},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"40":{"tf":1.0}}}}}}},"u":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"c":{"_":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"df":1,"docs":{"40":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"k":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"_":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"_":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"17":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"c":{"df":0,"docs":{},"e":{"_":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":1,"docs":{"40":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"t":{"a":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"_":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":1,"docs":{"40":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":1,"docs":{"33":{"tf":1.0}}}}}}},"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"c":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"63":{"tf":1.0}},"u":{"df":0,"docs":{},"p":{"df":1,"docs":{"61":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":60,"docs":{"0":{"tf":1.4142135623730951},"1":{"tf":1.0},"10":{"tf":1.4142135623730951},"11":{"tf":1.4142135623730951},"12":{"tf":1.4142135623730951},"13":{"tf":1.0},"14":{"tf":1.4142135623730951},"15":{"tf":1.4142135623730951},"16":{"tf":1.4142135623730951},"17":{"tf":1.4142135623730951},"18":{"tf":1.0},"19":{"tf":2.0},"2":{"tf":1.0},"20":{"tf":1.0},"21":{"tf":1.0},"22":{"tf":1.4142135623730951},"23":{"tf":1.4142135623730951},"24":{"tf":1.4142135623730951},"25":{"tf":1.0},"26":{"tf":1.0},"27":{"tf":1.4142135623730951},"28":{"tf":1.4142135623730951},"29":{"tf":1.7320508075688772},"3":{"tf":1.4142135623730951},"31":{"tf":1.0},"32":{"tf":1.7320508075688772},"33":{"tf":2.0},"34":{"tf":1.0},"35":{"tf":1.4142135623730951},"36":{"tf":1.0},"38":{"tf":1.0},"40":{"tf":2.6457513110645907},"42":{"tf":1.0},"43":{"tf":2.0},"44":{"tf":2.8284271247461903},"45":{"tf":1.4142135623730951},"46":{"tf":1.4142135623730951},"47":{"tf":1.4142135623730951},"48":{"tf":1.0},"49":{"tf":1.0},"5":{"tf":1.0},"50":{"tf":1.0},"51":{"tf":1.0},"53":{"tf":2.23606797749979},"54":{"tf":1.0},"55":{"tf":2.23606797749979},"56":{"tf":1.7320508075688772},"57":{"tf":2.449489742783178},"58":{"tf":1.0},"6":{"tf":1.7320508075688772},"60":{"tf":1.0},"62":{"tf":1.0},"65":{"tf":1.4142135623730951},"67":{"tf":2.6457513110645907},"68":{"tf":1.7320508075688772},"69":{"tf":2.449489742783178},"7":{"tf":1.4142135623730951},"70":{"tf":1.4142135623730951},"8":{"tf":1.7320508075688772},"9":{"tf":1.4142135623730951}}}}}},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":2,"docs":{"57":{"tf":1.0},"67":{"tf":1.0}}}}},"w":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"k":{"df":2,"docs":{"20":{"tf":1.0},"67":{"tf":1.0}}}},"df":0,"docs":{}},"o":{"df":2,"docs":{"68":{"tf":1.0},"69":{"tf":1.0}}}},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"=":{"\"":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":2,"docs":{"49":{"tf":1.0},"64":{"tf":1.0}}}}},"df":0,"docs":{}}},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"k":{"df":1,"docs":{"44":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":12,"docs":{"43":{"tf":2.449489742783178},"44":{"tf":2.0},"45":{"tf":1.0},"46":{"tf":1.0},"47":{"tf":1.0},"48":{"tf":1.0},"49":{"tf":1.4142135623730951},"52":{"tf":1.4142135623730951},"55":{"tf":1.4142135623730951},"58":{"tf":1.0},"60":{"tf":1.0},"66":{"tf":1.0}},"s":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"44":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}}},"i":{"c":{"df":4,"docs":{"40":{"tf":1.0},"41":{"tf":1.0},"43":{"tf":1.0},"53":{"tf":1.0}}},"df":0,"docs":{}}}}},"u":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"69":{"tf":1.0}}}}},"df":0,"docs":{}}},"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"44":{"tf":1.0}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":1,"docs":{"67":{"tf":1.0}}}}}}}},"k":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{"df":1,"docs":{"4":{"tf":2.0}}}}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"2":{"tf":1.0}}}}}},"m":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":1,"docs":{"55":{"tf":1.0}}}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"/":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"/":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":1,"docs":{"67":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"61":{"tf":1.0}}}}}},"p":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":1,"docs":{"33":{"tf":1.0}}}}},"d":{"a":{"df":0,"docs":{},"t":{"df":4,"docs":{"13":{"tf":1.7320508075688772},"17":{"tf":1.7320508075688772},"20":{"tf":1.0},"6":{"tf":1.0}},"e":{"_":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"k":{"df":2,"docs":{"17":{"tf":1.0},"6":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":2,"docs":{"25":{"tf":1.0},"66":{"tf":1.0}}},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"69":{"tf":2.0}}},"l":{"df":4,"docs":{"40":{"tf":1.0},"56":{"tf":2.6457513110645907},"67":{"tf":4.0},"69":{"tf":1.7320508075688772}}}},"s":{"df":35,"docs":{"0":{"tf":1.0},"1":{"tf":1.0},"12":{"tf":1.4142135623730951},"14":{"tf":1.4142135623730951},"16":{"tf":1.4142135623730951},"17":{"tf":1.4142135623730951},"19":{"tf":1.0},"20":{"tf":1.4142135623730951},"29":{"tf":1.7320508075688772},"31":{"tf":1.4142135623730951},"32":{"tf":2.23606797749979},"33":{"tf":1.4142135623730951},"34":{"tf":1.0},"36":{"tf":1.0},"38":{"tf":1.0},"4":{"tf":1.7320508075688772},"40":{"tf":2.0},"41":{"tf":1.0},"44":{"tf":3.605551275463989},"45":{"tf":1.4142135623730951},"47":{"tf":1.4142135623730951},"5":{"tf":1.0},"54":{"tf":1.0},"55":{"tf":1.0},"56":{"tf":1.4142135623730951},"57":{"tf":1.7320508075688772},"58":{"tf":1.0},"6":{"tf":1.4142135623730951},"60":{"tf":1.0},"64":{"tf":1.0},"67":{"tf":2.23606797749979},"69":{"tf":1.7320508075688772},"71":{"tf":1.0},"8":{"tf":1.0},"9":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"65":{"tf":1.0}}}}}},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"d":{"df":2,"docs":{"43":{"tf":1.0},"53":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"u":{"df":5,"docs":{"44":{"tf":2.8284271247461903},"56":{"tf":1.0},"57":{"tf":1.4142135623730951},"58":{"tf":1.0},"67":{"tf":1.0}}}},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"a":{"df":2,"docs":{"19":{"tf":1.0},"64":{"tf":1.0}}},"df":0,"docs":{}}}}},"r":{"df":0,"docs":{},"i":{"a":{"b":{"df":0,"docs":{},"l":{"df":7,"docs":{"17":{"tf":1.0},"28":{"tf":1.0},"31":{"tf":2.0},"32":{"tf":1.0},"40":{"tf":1.0},"44":{"tf":1.0},"60":{"tf":1.0}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"28":{"tf":1.0},"32":{"tf":1.0}}}}},"df":1,"docs":{"3":{"tf":1.0}},"o":{"df":0,"docs":{},"u":{"df":3,"docs":{"11":{"tf":1.0},"38":{"tf":1.0},"57":{"tf":1.0}}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":6,"docs":{"12":{"tf":1.0},"13":{"tf":1.0},"17":{"tf":1.4142135623730951},"32":{"tf":2.0},"33":{"tf":3.0},"65":{"tf":1.0}}}}}}}},"i":{"a":{"df":4,"docs":{"0":{"tf":1.0},"44":{"tf":1.0},"64":{"tf":1.0},"70":{"tf":1.0}}},"df":0,"docs":{}}},"w":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"40":{"tf":1.0}}}},"n":{"df":0,"docs":{},"t":{"df":4,"docs":{"20":{"tf":1.4142135623730951},"4":{"tf":1.0},"41":{"tf":1.0},"61":{"tf":1.0}}}},"r":{"df":0,"docs":{},"n":{"df":3,"docs":{"32":{"tf":1.0},"53":{"tf":1.0},"67":{"tf":1.0}}}},"s":{"df":0,"docs":{},"m":{"3":{"2":{"df":2,"docs":{"22":{"tf":1.0},"4":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"_":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"(":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"66":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":3,"docs":{"19":{"tf":1.0},"20":{"tf":1.0},"65":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":1,"docs":{"64":{"tf":1.0}}}}}},"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"44":{"tf":1.0}}},"df":0,"docs":{}}}},"df":11,"docs":{"0":{"tf":1.4142135623730951},"18":{"tf":1.0},"19":{"tf":1.0},"22":{"tf":1.4142135623730951},"44":{"tf":4.58257569495584},"54":{"tf":1.0},"55":{"tf":1.0},"60":{"tf":1.4142135623730951},"63":{"tf":1.0},"64":{"tf":1.7320508075688772},"65":{"tf":2.449489742783178}}}},"t":{"c":{"df":0,"docs":{},"h":{"df":2,"docs":{"23":{"tf":2.0},"24":{"tf":1.0}}}},"df":0,"docs":{}},"y":{"df":6,"docs":{"12":{"tf":1.0},"55":{"tf":1.0},"6":{"tf":1.0},"65":{"tf":1.0},"68":{"tf":1.0},"71":{"tf":1.0}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"k":{"df":1,"docs":{"44":{"tf":1.4142135623730951}}}},"b":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":1,"docs":{"19":{"tf":1.0}}},"y":{"df":0,"docs":{},"s":{":":{":":{"df":0,"docs":{},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":1,"docs":{"19":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"b":{"df":0,"docs":{},"l":{"df":9,"docs":{"0":{"tf":1.0},"3":{"tf":1.0},"4":{"tf":1.7320508075688772},"60":{"tf":1.0},"61":{"tf":1.7320508075688772},"62":{"tf":1.0},"63":{"tf":1.0},"64":{"tf":1.0},"65":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"b":{"df":0,"docs":{},"i":{"df":1,"docs":{"0":{"tf":1.0}}}},"df":9,"docs":{"0":{"tf":1.0},"18":{"tf":1.0},"19":{"tf":1.0},"20":{"tf":1.0},"24":{"tf":1.0},"44":{"tf":1.4142135623730951},"58":{"tf":1.0},"61":{"tf":1.0},"63":{"tf":1.0}},"s":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":2,"docs":{"67":{"tf":2.23606797749979},"69":{"tf":1.0}}}}}},"df":0,"docs":{}}},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"k":{"df":1,"docs":{"44":{"tf":1.0}}}}}}},"df":0,"docs":{},"l":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":1,"docs":{"71":{"tf":1.0}}}}},"df":0,"docs":{},"l":{"df":3,"docs":{"28":{"tf":1.0},"31":{"tf":1.0},"32":{"tf":1.0}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"'":{"df":0,"docs":{},"t":{"df":1,"docs":{"67":{"tf":1.0}}}},"df":0,"docs":{}}}}},"i":{"df":0,"docs":{},"n":{".":{"d":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"u":{"df":1,"docs":{"19":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{",":{"d":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{",":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{",":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":1,"docs":{"19":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}}}}}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},".":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"m":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":2,"docs":{"60":{"tf":1.0},"64":{"tf":1.0}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"s":{".":{"<":{"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"44":{"tf":1.0}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"m":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":1,"docs":{"64":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":3,"docs":{"19":{"tf":1.0},"41":{"tf":1.7320508075688772},"44":{"tf":1.0}}}}},"df":0,"docs":{}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"41":{"tf":1.0}}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":8,"docs":{"44":{"tf":1.0},"45":{"tf":1.0},"46":{"tf":1.4142135623730951},"47":{"tf":1.0},"48":{"tf":1.0},"50":{"tf":1.0},"51":{"tf":1.0},"53":{"tf":1.4142135623730951}}}}}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"k":{"df":8,"docs":{"28":{"tf":1.0},"32":{"tf":1.0},"53":{"tf":1.0},"55":{"tf":1.0},"61":{"tf":1.0},"65":{"tf":1.0},"67":{"tf":1.0},"71":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"44":{"tf":1.7320508075688772}}}},"f":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":1,"docs":{"21":{"tf":1.0}}}}}}},"l":{"d":{"<":{"/":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":1,"docs":{"19":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":2,"docs":{"19":{"tf":1.7320508075688772},"20":{"tf":1.0}}},"df":0,"docs":{}}}},"r":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"49":{"tf":1.7320508075688772}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"44":{"tf":1.0}}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":3,"docs":{"35":{"tf":1.0},"39":{"tf":1.4142135623730951},"56":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"65":{"tf":1.0}}}}}},"s":{"df":3,"docs":{"67":{"tf":1.0},"69":{"tf":1.0},"70":{"tf":1.0}}}},"y":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":4,"docs":{"30":{"tf":1.0},"32":{"tf":1.0},"34":{"tf":1.0},"37":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":1,"docs":{"20":{"tf":1.0}}}},"o":{"df":0,"docs":{},"u":{"'":{"df":0,"docs":{},"r":{"df":2,"docs":{"2":{"tf":1.0},"32":{"tf":1.0}}}},"df":0,"docs":{},"r":{"df":1,"docs":{"32":{"tf":1.0}}}}}},"z":{"df":1,"docs":{"44":{"tf":1.7320508075688772}},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":1,"docs":{"46":{"tf":1.0}}}}}}}},"title":{"root":{"0":{".":{"2":{"1":{".":{"0":{"df":1,"docs":{"32":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"a":{"d":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"59":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"k":{"df":1,"docs":{"37":{"tf":1.0}}}}},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"a":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"32":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"31":{"tf":1.0}}}}}}}}},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":4,"docs":{"42":{"tf":1.0},"43":{"tf":1.0},"52":{"tf":1.0},"53":{"tf":1.0}}}}}}},"b":{"a":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"68":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":1,"docs":{"67":{"tf":1.0}}},"i":{"c":{"df":1,"docs":{"18":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"32":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"10":{"tf":1.0}}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"12":{"tf":1.0}}}},"df":0,"docs":{}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":1,"docs":{"14":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"d":{"df":2,"docs":{"22":{"tf":1.0},"39":{"tf":1.0}}},"df":0,"docs":{}}}}},"c":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"o":{"df":1,"docs":{"12":{"tf":1.0}}}}}},"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"17":{"tf":1.0}}}},"df":0,"docs":{}}},"l":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"25":{"tf":1.0}}}},"df":0,"docs":{}},"i":{"df":1,"docs":{"69":{"tf":1.0}}}},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"n":{"d":{"df":2,"docs":{"21":{"tf":1.0},"31":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"p":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"10":{"tf":1.0}}}}}},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":2,"docs":{"26":{"tf":1.0},"70":{"tf":1.0}},"u":{"df":0,"docs":{},"r":{"df":3,"docs":{"28":{"tf":1.0},"29":{"tf":1.0},"34":{"tf":1.0}}}}}}},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"71":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"p":{"df":0,"docs":{},"i":{"df":2,"docs":{"50":{"tf":1.0},"51":{"tf":1.0}}}}},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":1,"docs":{"66":{"tf":1.0}},"s":{".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":1,"docs":{"7":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"19":{"tf":1.0}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"46":{"tf":1.0}}}}},"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"63":{"tf":1.0}}}}}}}},"i":{"df":0,"docs":{},"r":{"df":1,"docs":{"51":{"tf":1.0}},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"56":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"8":{"tf":1.0}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"9":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"13":{"tf":1.0}}}}},"df":0,"docs":{}}}}}},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"a":{"d":{"df":1,"docs":{"11":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"/":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"36":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"31":{"tf":1.0}}}}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"62":{"tf":1.0}}}}}},"x":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":1,"docs":{"64":{"tf":1.0}}}}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"40":{"tf":1.0}}}}},"df":0,"docs":{}}}},"f":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"a":{"df":1,"docs":{"15":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":3,"docs":{"29":{"tf":1.0},"50":{"tf":1.0},"70":{"tf":1.0}}}}},"l":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"69":{"tf":1.0}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"30":{"tf":1.0}}}},"df":0,"docs":{}},"w":{"a":{"df":0,"docs":{},"r":{"d":{"df":1,"docs":{"32":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"1":{"tf":1.0}}}},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"8":{"tf":1.0}},"h":{"df":0,"docs":{},"u":{"b":{"df":1,"docs":{"11":{"tf":1.0}}},"df":0,"docs":{}}}}}},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"df":2,"docs":{"38":{"tf":1.0},"40":{"tf":1.0}}}}}},"i":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"48":{"tf":1.0}}}}},"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"55":{"tf":1.0}}}},"df":0,"docs":{}},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":2,"docs":{"61":{"tf":1.0},"65":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"49":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"l":{"df":6,"docs":{"10":{"tf":1.0},"5":{"tf":1.0},"6":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.0},"9":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"df":1,"docs":{"58":{"tf":1.0}}}},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"j":{"df":1,"docs":{"37":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"60":{"tf":1.0}}}}}}}},"r":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"0":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"j":{"a":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"s":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"60":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{},"s":{"df":1,"docs":{"54":{"tf":1.0}}}},"l":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"66":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":1,"docs":{"31":{"tf":1.0}}},"k":{"df":1,"docs":{"43":{"tf":1.0}}}}},"o":{"c":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"9":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"32":{"tf":1.0}}}},"df":0,"docs":{}}},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":1,"docs":{"57":{"tf":1.0}}}}}},"o":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":1,"docs":{"32":{"tf":1.0}}}}}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":1,"docs":{"20":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"x":{"df":1,"docs":{"16":{"tf":1.0}}}}},"o":{"b":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"35":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"r":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"61":{"tf":1.0}}}}},"df":0,"docs":{}},"s":{"df":2,"docs":{"16":{"tf":1.0},"41":{"tf":1.0}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"41":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"p":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"67":{"tf":1.0}}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":3,"docs":{"10":{"tf":1.0},"2":{"tf":1.0},"32":{"tf":1.0}}},"o":{"df":0,"docs":{},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"18":{"tf":1.0},"19":{"tf":1.0}}}},"df":0,"docs":{}}},"x":{"df":0,"docs":{},"i":{"df":3,"docs":{"67":{"tf":1.0},"68":{"tf":1.0},"69":{"tf":1.0}}}}}},"u":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"67":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"s":{"df":2,"docs":{"11":{"tf":1.0},"7":{"tf":1.0}}}},"df":0,"docs":{}}},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":1,"docs":{"33":{"tf":1.0}}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"2":{"tf":1.0}}}}}}}},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"c":{"df":2,"docs":{"55":{"tf":1.0},"58":{"tf":1.0}}},"df":0,"docs":{}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":1,"docs":{"67":{"tf":1.0}}}}}}},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"3":{"tf":1.0},"44":{"tf":1.0}}}}}},"s":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"/":{"df":0,"docs":{},"s":{"c":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"45":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"a":{"df":2,"docs":{"34":{"tf":1.0},"35":{"tf":1.0}}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":2,"docs":{"52":{"tf":1.0},"53":{"tf":1.0}}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"v":{"df":1,"docs":{"24":{"tf":1.0}}}}},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":2,"docs":{"26":{"tf":1.0},"27":{"tf":1.0}}}}},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"54":{"tf":1.0}}}}}}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"c":{"df":1,"docs":{"6":{"tf":1.0}}},"df":0,"docs":{}}}},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":1,"docs":{"41":{"tf":1.0}}}}},"df":0,"docs":{}}},"t":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"1":{"tf":1.0}},"u":{"df":0,"docs":{},"p":{"df":1,"docs":{"62":{"tf":1.0}}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":2,"docs":{"20":{"tf":1.0},"39":{"tf":1.0}}}}},"u":{"b":{"df":1,"docs":{"58":{"tf":1.0}}},"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"36":{"tf":1.0}}}}}}}}},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"47":{"tf":1.0}}},"df":0,"docs":{}}}}}},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"4":{"tf":1.0}}}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":1,"docs":{"27":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"k":{"df":1,"docs":{"10":{"tf":1.0}}}}}},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":2,"docs":{"43":{"tf":1.0},"52":{"tf":1.0}}}}}},"u":{"df":0,"docs":{},"p":{"d":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"17":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"l":{"df":1,"docs":{"67":{"tf":1.4142135623730951}}}},"s":{"df":1,"docs":{"12":{"tf":1.0}}}},"v":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"31":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"33":{"tf":1.0}}}}}}}}},"w":{"a":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"23":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"b":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"4":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"lang":"English","pipeline":["trimmer","stopWordFilter","stemmer"],"ref":"id","version":"0.9.5"},"results_options":{"limit_results":30,"teaser_word_count":30},"search_options":{"bool":"OR","expand":true,"fields":{"body":{"boost":1},"breadcrumbs":{"boost":1},"title":{"boost":2}}}});