/****************************************************************************
 *  (c) Copyright 2007 Wi-Fi Alliance.  All Rights Reserved
 *
 *
 *  LICENSE
 *
 *  License is granted only to Wi-Fi Alliance members and designated
 *  contractors ($B!H(BAuthorized Licensees$B!I(B)..AN  Authorized Licensees are granted
 *  the non-exclusive, worldwide, limited right to use, copy, import, export
 *  and distribute this software:
 *  (i) solely for noncommercial applications and solely for testing Wi-Fi
 *  equipment; and
 *  (ii) solely for the purpose of embedding the software into Authorized
 *  Licensee$B!G(Bs proprietary equipment and software products for distribution to
 *  its customers under a license with at least the same restrictions as
 *  contained in this License, including, without limitation, the disclaimer of
 *  warranty and limitation of liability, below..AN  The distribution rights
 *  granted in clause
 *  (ii), above, include distribution to third party companies who will
 *  redistribute the Authorized Licensee$B!G(Bs product to their customers with or
 *  without such third party$B!G(Bs private label. Other than expressly granted
 *  herein, this License is not transferable or sublicensable, and it does not
 *  extend to and may not be used with non-Wi-Fi applications..AN  Wi-Fi Alliance
 *  reserves all rights not expressly granted herein..AN 
 *.AN 
 *  Except as specifically set forth above, commercial derivative works of
 *  this software or applications that use the Wi-Fi scripts generated by this
 *  software are NOT AUTHORIZED without specific prior written permission from
 *  Wi-Fi Alliance.
 *.AN 
 *  Non-Commercial derivative works of this software for internal use are
 *  authorized and are limited by the same restrictions; provided, however,
 *  that the Authorized Licensee shall provide Wi-Fi Alliance with a copy of
 *  such derivative works under a perpetual, payment-free license to use,
 *  modify, and distribute such derivative works for purposes of testing Wi-Fi
 *  equipment.
 *.AN 
 *  Neither the name of the author nor "Wi-Fi Alliance" may be used to endorse
 *  or promote products that are derived from or that use this software without
 *  specific prior written permission from Wi-Fi Alliance.
 *
 *  THIS SOFTWARE IS PROVIDED BY WI-FI ALLIANCE "AS IS" AND ANY EXPRESS OR
 *  IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 *  OF MERCHANTABILITY, NON-INFRINGEMENT AND FITNESS FOR A.AN PARTICULAR PURPOSE,
 *  ARE DISCLAIMED. IN NO EVENT SHALL WI-FI ALLIANCE BE LIABLE FOR ANY DIRECT,
 *  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 *  (INCLUDING, BUT NOT LIMITED TO, THE COST OF PROCUREMENT OF SUBSTITUTE
 *  GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 *  HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 *  STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE) ARISING IN ANY WAY OUT OF
 *  THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE
 ******************************************************************************
 */
 

/*
 * wfa_cmds.h:
 *   definitions of command types.
 */
#ifndef _WFA_CMDS_H
#define _WFA_CMDS_H

typedef struct _tg_ping_start
{
    char dipaddr[IPV4_ADDRESS_STRING_LEN];  /* destination/remote ip address */
    int  frameSize;
    int  frameRate;
    int  duration;
    int  type;
} tgPingStart_t;

typedef struct ca_sta_set_ip_config
{
    char intf[WFA_IF_NAME_LEN];
    int isDhcp;
    char ipaddr[WFA_IP_ADDR_STR_LEN];
    char mask[WFA_IP_MASK_STR_LEN];
    char defGateway[WFA_IP_ADDR_STR_LEN];
    char pri_dns[WFA_IP_ADDR_STR_LEN];
    char sec_dns[WFA_IP_ADDR_STR_LEN];
} caStaSetIpConfig_t;

typedef struct ca_sta_verify_ip_connection
{
   char dipaddr[WFA_IP_ADDR_STR_LEN];
   int timeout;
} caStaVerifyIpConnect_t;

typedef struct ca_sta_set_encryption
{
   char intf[WFA_IF_NAME_LEN];
   char ssid[WFA_SSID_NAME_LEN];
   int encpType;
   char keys[4][32];  /* 26 hex */
   int activeKeyIdx;
} caStaSetEncryption_t;

typedef struct ca_sta_set_mode
{
   char intf[WFA_IF_NAME_LEN];
   char ssid[WFA_SSID_NAME_LEN];
   char mode;
   int encpType;
   int channel;
   char keys[4][32];  /* 26 hex */
   int activeKeyIdx;
} caStaSetMode_t;

typedef struct ca_sta_set_psk
{
   char intf[WFA_IF_NAME_LEN];
   char ssid[WFA_SSID_NAME_LEN];
   BYTE passphrase[64];
   char keyMgmtType[8];  /* WPA-PSK */
   int encpType;    /* TKIP    */
} caStaSetPSK_t;

typedef struct ca_sta_set_eaptls
{
   char intf[WFA_IF_NAME_LEN];
   char ssid[WFA_SSID_NAME_LEN];
   char keyMgmtType[8];
   char encrptype[8];
   char trustedRootCA[128];
   char clientCertificate[128];
} caStaSetEapTLS_t;

typedef struct ca_sta_set_eapttls
{
   char intf[WFA_IF_NAME_LEN];
   char ssid[WFA_SSID_NAME_LEN];
   char username[32];
   char passwd[16];
   char keyMgmtType[8];
   char encrptype[8];
   char trustedRootCA[32];
   char clientCertificate[32];
} caStaSetEapTTLS_t;

typedef struct ca_sta_set_eapsim
{
   char intf[WFA_IF_NAME_LEN];
   char ssid[WFA_SSID_NAME_LEN];
   char username[32];
   char passwd[16];
   char keyMgmtType[8];
   char encrptype[8];
} caStaSetEapSIM_t;

typedef struct ca_sta_set_eappeap
{
   char intf[WFA_IF_NAME_LEN];
   char ssid[WFA_SSID_NAME_LEN];
   char username[32];
   char passwd[16];
   char keyMgmtType[8];
   char encrptype[8];
   char trustedRootCA[32];
   char innerEAP[16];
   int peapVersion;
} caStaSetEapPEAP_t;

typedef struct ca_sta_set_uapsd
{
   char intf[WFA_IF_NAME_LEN];
   char ssid[WFA_SSID_NAME_LEN];
   int maxSPLength;
   BYTE acBE;
   BYTE acBK;
   BYTE acVI;
   BYTE acVO;
} caStaSetUAPSD_t;

typedef struct ca_sta_set_ibss
{
   char intf[WFA_IF_NAME_LEN];
   char ssid[WFA_SSID_NAME_LEN];
   int channel;
   int encpType;
   char keys[4][32];
   int activeKeyIdx;
} caStaSetIBSS_t;

typedef struct sta_get_testdata
{
   int type;
   int next;     /* sequence number, 0 is the last one */
} caStaGetTestData_t;

typedef struct sta_debug_set
{
   unsigned short level;
   unsigned short state;
} staDebugSet_t;
typedef struct config
{
   BYTE wmm;
   int  rts_thr ;
   int  frag_thr ;
} wmmconf_t;

typedef struct wmm_tsinfo
{
unsigned int Reserved1 :1;
unsigned int TID       :4;
unsigned int direction :2;
unsigned int dummy1    :1;
unsigned int dummy2    :1;
unsigned int Reserved2 :1;
unsigned int PSB       :1;
unsigned int UP        :3;
unsigned int Reserved3 :2;
unsigned int Reserved4 :1;
unsigned int Reserved5 :7;
}wmmtsinfo_t;
typedef struct wmm_tspec
{
wmmtsinfo_t      tsinfo;
BOOL Fixed;//The MSDU Fixed Bit
unsigned short size;//The MSDU Size
unsigned short maxsize;//MAximum MSDU Size
unsigned int   min_srvc;//The minimum Service Interval
unsigned int   max_srvc;//The maximum Service Interval
unsigned int inactivity;//Inactivity Interval
unsigned int suspension;//The Suspension Interval
unsigned int srvc_strt_tim;//The Service Start Time
unsigned int mindatarate;//The Minimum Data Rate
unsigned int meandatarate;//The Minimum Data Rate
unsigned int peakdatarate;//The Minimum Data Rate
unsigned int burstsize;//The Maximum Burst Size
unsigned int delaybound;//The Delay Bound
unsigned int PHYrate;//The minimum PHY Rate
float sba;//The Surplus Bandwidth Allownce
unsigned short medium_time;//The medium time

}wmmtspec_t;
typedef struct wmmac_addts
{
   BYTE       dialog_token;
   BYTE       accesscat;
   wmmtspec_t tspec;
} wmmacadd_t;

typedef struct ca_sta_set_wmm
{
   char intf[WFA_IF_NAME_LEN];
   BYTE group;
   BYTE action;
   BYTE       send_trig;
   char       dipaddr[WFA_IP_ADDR_STR_LEN];
   BYTE       trig_ac;
   union _action
   {
       wmmconf_t   config;
       wmmacadd_t  addts;
       BYTE        delts;
   } actions;
} caStaSetWMM_t;

typedef struct dut_commands
{
   char intf[WFA_IF_NAME_LEN];
   union _cmds
   {
       int streamId;
       int iftype;
       tgProfile_t profile;
       tgPingStart_t startPing;
       char ssid[WFA_SSID_NAME_LEN];
       caStaSetIpConfig_t ipconfig;
       caStaVerifyIpConnect_t verifyIp;
       caStaSetEncryption_t wep;       
       caStaSetPSK_t        psk;
       caStaSetEapTLS_t     tls;
       caStaSetEapTTLS_t    ttls;
       caStaSetEapSIM_t     sim;
       caStaSetEapPEAP_t    peap;
       caStaSetUAPSD_t      uapsd;
       caStaSetIBSS_t       ibss;
       caStaGetTestData_t   tdata;
       caStaSetWMM_t        setwmm;
       staDebugSet_t        dbg;
   } cmdsu;    
} dutCommand_t;

extern int buildCommandProcessTable(void);
#ifdef WIN32
extern BOOL IPProperties(caStaSetIpConfig_t*, DWORD*);
extern void ResetIP(caStaSetIpConfig_t * );

#endif
#endif
