/*
 * drivers/video/sun3i/disp/de_bsp/de/ebios/de_layer.c
 *
 * (C) Copyright 2007-2012
 * Allwinner Technology Co., Ltd. <www.allwinnertech.com>
 * Danling <danliang@allwinnertech.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307 USA
 */


#include "de_bsp_i.h"
#include "de_be.h"

__s32 DE_BE_Format_To_Bpp(__u32 sel, __u8 format)
{
    __u8 bpp = 0;

	if(sel == 0)
	{
        switch(format)
        {
            case  DE_MONO_1BPP:
    			bpp = 1;
    			break;

            case DE_MONO_2BPP:
    			bpp = 2;
    			break;

            case DE_MONO_4BPP:
    			bpp = 4;
    			break;

            case DE_MONO_8BPP:
    			bpp = 8;
    			break;

            case DE_COLOR_RGB655:
            case DE_COLOR_RGB565:
            case DE_COLOR_RGB556:
            case DE_COLOR_ARGB1555:
            case DE_COLOR_RGBA5551:
    			bpp=16;
    			break;

            case DE_COLOR_RGB0888:
    			bpp = 32;
    			break;

            case DE_COLOR_ARGB8888:
    			bpp = 32;
    			break;

    		default:
                bpp = 0;
    			break;
         }
     }
     else if(sel == 1)
     {
        switch(format)
        {
            case  0:
    			bpp = 32;
    			break;

            case 1:
            case 2:
            case 3:
            case 4:
    			bpp=16;
    			break;

            case 5:
    			bpp = 1;
    			break;

            case 6:
    			bpp = 2;
    			break;

            case 7:
    			bpp = 4;
    			break;

            case 8:
    			bpp = 8;
    			break;

    		default:
                bpp = 0;
    			break;
         }
     }
    return bpp;
}

__u32 DE_BE_Offset_To_Addr(__u32 src_addr,__u32 width,__u32 x,__u32 y,__u32 bpp)
{
    __u32 addr;

    addr = src_addr + ((y*(width*bpp))>>3) + ((x*bpp)>>3);

    return addr;
}

__u32  DE_BE_Addr_To_Offset(__u32 src_addr,__u32 off_addr,__u32 width,__u32 bpp,__disp_pos_t *pos)
{
    __u32    dist;
    __disp_pos_t  offset;

    dist        = off_addr-src_addr;
    offset.y    = (dist<<3)/(width*bpp);
    offset.x    = ((dist<<3)%(width*bpp))/bpp;
    pos->x      = offset.x;
    pos->y      = offset.y;

    return 0;

}

__s32 DE_BE_Layer_Set_Work_Mode(__u32 sel, __u8 layidx,__u8 mode)
{
    if(sel == 0)
    {
        __u32 tmp;

        tmp = DE_BE_RUINT32IDX(DE_BE_LAYER_ATTRCTL_OFF0,layidx);
        DE_BE_WUINT32IDX(DE_BE_LAYER_ATTRCTL_OFF0,layidx,(tmp&0xff3fffff)|mode<<22);
    }

    return 0;
}

static __s32 DE_BE_Layer_Set_Addr(__u8 layidx,__u32 addr)   //byte
{
   DE_BE_WUINT32IDX(DE_BE_FRMBUFA_ADDR_OFF,layidx,addr>>2);
   return 0;
}

static __s32 DE_BE_Layer_Set_Line_Width(__u8 layidx,__u32 width)    //byte
{
   DE_BE_WUINT32IDX(DE_BE_FRMBUF_WLINE_OFF,layidx,width);
   return 0;
}


__s32 DE_BE_Layer_Set_Format(__u32 sel, __u8 layidx,__u8 format,__bool br_swap,__u8 order)
{
    if(sel == 0)
    {
        __u32 tmp;

        tmp = DE_BE_RUINT32IDX(DE_BE_LAYER_ATTRCTL_OFF1,layidx);
        DE_BE_WUINT32IDX(DE_BE_LAYER_ATTRCTL_OFF1,layidx,(tmp&0xfffff000)|format<<8|br_swap<<2|order);
    }
    else
    {
	    image1_reg->layer_attri[layidx].pixel_seq = order;
	    image1_reg->layer_attri[layidx].data_fmt = format;
	}
    return 0;
}


__s32 DE_BE_Layer_Set_Framebuffer(__u32 sel, __u8 layidx,layer_src_t *layer_fb)
{
	__s32 bpp;
	__u32 addr;

	bpp = DE_BE_Format_To_Bpp(sel, layer_fb->format);
	if(bpp <= 0)
	{
		return -1;
	}
	addr = DE_BE_Offset_To_Addr(layer_fb->fb_addr, layer_fb->fb_width, layer_fb->offset_x, layer_fb->offset_y,bpp);
    DE_BE_Layer_Set_Format(sel, layidx,layer_fb->format,layer_fb->br_swap,layer_fb->pixseq);
    if(sel == 0)
    {
    	DE_BE_Layer_Set_Addr(layidx,addr);
    	DE_BE_Layer_Set_Line_Width(layidx,layer_fb->fb_width*bpp);
	}
	else if(sel == 1)
	{
	    image1_reg->layer_addr[layidx].addr = addr>>2;
	    image1_reg->layer_line_width[layidx].line_width = layer_fb->fb_width*bpp;
	}

	return 0;
}


__s32 DE_BE_Layer_Set_Screen_Win(__u32 sel, __u8 layidx, __disp_rect_t * win)
{
    if(sel == 0)
    {
        __u32 tmp;

        tmp = ((((__u32)(win->y))>>31)<<31)|((((__u32)(win->y))&0x7fff)<<16)|((((__u32)(win->x))>>31)<<15)|(((__u32)(win->x))&0x7fff);
        DE_BE_WUINT32IDX(DE_BE_LAYER_CRD_CTL_OFF,layidx,tmp);
        DE_BE_WUINT32IDX(DE_BE_LAYER_SIZE_OFF,layidx,(win->height-1)<<16|(win->width-1));
    }
    else if(sel == 1)
    {
        image1_reg->layer_coord[layidx].x = win->x;
        image1_reg->layer_coord[layidx].y = win->y;
        image1_reg->layer_size[layidx].width = win->width-1;
        image1_reg->layer_size[layidx].height = win->height-1;
    }

    return 0;
}
__s32 DE_BE_Layer_Video_Enable(__u32 sel, __u8 layidx,__bool video_en)
{
    if(sel == 0)
    {
        __u32   tmp;

        tmp = DE_BE_RUINT32IDX(DE_BE_LAYER_ATTRCTL_OFF0,layidx);
        DE_BE_WUINT32IDX(DE_BE_LAYER_ATTRCTL_OFF0,layidx,(tmp&0xfffffffd)|video_en<<1);
    }
    else if(sel == 1)
    {
        image1_reg->layer_attri[layidx].video_ch = video_en;
    }

    return 0;
}

__s32 DE_BE_Layer_Yuv_Ch_Enable(__u32 sel, __u8 layidx,__bool yuv_en)
{
    if(sel == 0)
    {
        __u32   tmp;

        tmp = DE_BE_RUINT32IDX(DE_BE_LAYER_ATTRCTL_OFF0,layidx);
        DE_BE_WUINT32IDX(DE_BE_LAYER_ATTRCTL_OFF0,layidx,(tmp&0xfffffffb)|yuv_en<<2);
    }

    return 0;
}

__s32 DE_BE_Layer_Set_Prio(__u32 sel, __u8 layidx,__u8 prio)
{
    if(sel == 0)
    {
        __u32 tmp;

        tmp = DE_BE_RUINT32IDX(DE_BE_LAYER_ATTRCTL_OFF0,layidx);
        DE_BE_WUINT32IDX(DE_BE_LAYER_ATTRCTL_OFF0,layidx,(tmp&0xfffff3ff)|prio<<10);
    }
    else if(sel == 1)
    {
        image1_reg->layer_attri[layidx].priority = prio;
    }
    return 0;
 }

__s32 DE_BE_Layer_Set_Pipe(__u32 sel, __u8 layidx,__u8 pipe)
{
    if(sel == 0)
    {
        __u32 tmp;

        tmp = DE_BE_RUINT32IDX(DE_BE_LAYER_ATTRCTL_OFF0,layidx);
        DE_BE_WUINT32IDX(DE_BE_LAYER_ATTRCTL_OFF0,layidx,(tmp&0xffff7fff)|pipe<<15);
    }
    else if(sel == 1)
    {
        image1_reg->layer_attri[layidx].pipe = pipe;
    }
    return 0;
}


__s32 DE_BE_Layer_ColorKey_Enable(__u32 sel, __u8 layidx, __bool enable)
{
    if(sel == 0)
    {
        __u32 tmp;

        if(enable)
        {
            tmp = DE_BE_RUINT32IDX(DE_BE_LAYER_ATTRCTL_OFF0,layidx);
            DE_BE_WUINT32IDX(DE_BE_LAYER_ATTRCTL_OFF0,layidx,(tmp&0xfff3ffff)|1<<18);
        }
        else
        {
            tmp = DE_BE_RUINT32IDX(DE_BE_LAYER_ATTRCTL_OFF0,layidx);
            DE_BE_WUINT32IDX(DE_BE_LAYER_ATTRCTL_OFF0,layidx,(tmp&0xfff3ffff));
        }
    }

    return 0;
}

__s32 DE_BE_Layer_Alpha_Enable(__u32 sel, __u8 layidx, __bool enable)
{
    if(sel == 0)
    {
        __u32 tmp;

        if(enable)
        {
            tmp = DE_BE_RUINT32IDX(DE_BE_LAYER_ATTRCTL_OFF0,layidx);
            DE_BE_WUINT32IDX(DE_BE_LAYER_ATTRCTL_OFF0,layidx,(tmp&0xfffffffe)|0x01);
        }
        else
        {
            tmp = DE_BE_RUINT32IDX(DE_BE_LAYER_ATTRCTL_OFF0,layidx);
            DE_BE_WUINT32IDX(DE_BE_LAYER_ATTRCTL_OFF0,layidx,(tmp&0xfffffffe));
        }
    }
    else if(sel == 1)
    {
        image1_reg->layer_attri[layidx].alpha_en = enable;
    }

    return 0;
}

__s32 DE_BE_Layer_Set_Alpha_Value(__u32 sel, __u8 layidx,__u8 alpha_val)//todo,why???
{
    if(sel == 0)
    {
        __u32 tmp;

        tmp = DE_BE_RUINT32IDX(DE_BE_LAYER_ATTRCTL_OFF0,layidx);
        DE_BE_WUINT32IDX(DE_BE_LAYER_ATTRCTL_OFF0,layidx,(tmp&0x0ffffff)|alpha_val<<24);
    }
    else if(sel == 1)
    {
        //image1_reg->layer_attri[layidx].alpha_value = alpha_val;
        //OSAL_printf("^^^^lapha:<%d,%d>\n",alpha_val, image1_reg->layer_attri[layidx].alpha_value);

        *(__u32*)((__u32)image1_reg+0x54) |= (alpha_val<<24);
    }
    return 0;
}

__s32 DE_BE_Layer_Enable(__u32 sel, __u8 layidx, __bool enable)
{
    if(sel == 0)
    {
    	if(enable)
    	{
    	    DE_BE_WUINT32(DE_BE_MODE_CTL_OFF,DE_BE_RUINT32(DE_BE_MODE_CTL_OFF)|(1<<layidx)<<8);
    	}
    	else
    	{
    	    DE_BE_WUINT32(DE_BE_MODE_CTL_OFF,DE_BE_RUINT32(DE_BE_MODE_CTL_OFF)&(~((1<<layidx)<<8)));
    	}
	}
	else if(sel == 1)
	{
	    image1_reg->layer_attri[layidx].en = enable;
	}

    return 0;
}


static __s32 DE_BE_YUV_CH_Cfg_Csc_Coeff(__u8 cs_mode)//todo
{
	__u32 csc_coef_off;
	__u32 *pdest_end;
    __u32 *psrc_cur;
    __u32 *pdest_cur;

	csc_coef_off = (((cs_mode&0x3)<<7) + ((cs_mode&0x3)<<6)) + 0/*yuv in*/ + 0/*rgb out*/;

	pdest_cur = (__u32*)(DE_Get_Reg_Base(0)+DE_BE_YG_COEFF_OFF);
	psrc_cur = (__u32*)(&csc_tab[csc_coef_off>>2]);
	pdest_end = pdest_cur + 12;

    while(pdest_cur < pdest_end)
    {
    	*(volatile __u32 *)pdest_cur++ = *psrc_cur++;
    }

	return 0;
}

//==================================================================
//function name:    DE_BE_YUV_CH_Set_Format
//author:
//date:             2009-9-28
//description:      de be input YUV channel format setting
//parameters:	----format(0-4)
//					0:	planar YUV 411
//					1:	planar YUV 422
//					2:	planar YUV 444
//					3:	interleaved YUV 422
//					4:	interleaved YUV 444
//				----pixel_seq(0-3)
//					in planar data format mode
//						0:Y3Y2Y1Y0
//						1:Y0Y1Y2Y3
//					in interleaved YUV 422 data format mode
//						0:DE_SCAL_UYVY
//						1:DE_SCAL_YUYV
//						2:DE_SCAL_VYUY
//						3:DE_SCAL_YVYU
//					in interleaved YUV 444 format mode
//						0:DE_SCAL_AYUV
//						1:DE_SCAL_VUYA
//return:           if success return DIS_SUCCESS
//                  if fail return the number of fail
//modify history:
//==================================================================
static __s32 DE_BE_YUV_CH_Set_Format(__u8 format,__u8 pixel_seq)
{
    __u32 tmp;

    tmp = DE_BE_RUINT32(DE_BE_YUV_CTRL_OFF);
    tmp &= 0xffff8cff;//clear bit14:12, bit9:8
	DE_BE_WUINT32(DE_BE_YUV_CTRL_OFF, tmp | (format<<12) | (pixel_seq<<8));

	return 0;
}

static __s32 DE_BE_YUV_CH_Set_Addr(__u8 ch_no,__u32 addr)
{
	DE_BE_WUINT32IDX(DE_BE_YUV_ADDR_OFF,ch_no,addr);
	return 0;
}

static __s32 DE_BE_YUV_CH_Set_Line_Width(__u8 ch_no,__u32 width)
{
	DE_BE_WUINT32IDX(DE_BE_YUV_LINE_WIDTH_OFF,ch_no,width);
	return 0;
}

__s32 DE_BE_YUV_CH_Set_Src(de_yuv_ch_src_t * in_src)
{
	__u32 ch0_base, ch1_base, ch2_base;
	__u32 image_w;
	__u32 offset_x, offset_y;
    __u8 in_fmt,in_mode,pixseq;
    __u32 ch0_addr, ch1_addr, ch2_addr;
    __u32 ch0_line_stride, ch1_line_stride, ch2_line_stride;
    __u8 w_shift, h_shift;
	__u32 de_scal_ch0_offset;
	__u32 de_scal_ch1_offset;
	__u32 de_scal_ch2_offset;

    ch0_base = in_src->ch0_base;
    ch1_base = in_src->ch1_base;
    ch2_base = in_src->ch2_base;
    image_w = in_src->line_width;
    offset_x = in_src->offset_x;
    offset_y = in_src->offset_y;
    in_fmt = in_src->format;
    in_mode = in_src->mode;
    pixseq = in_src->pixseq;

    w_shift = (in_fmt==0x1 || in_fmt==0x3) ? 1 : ((in_fmt==0x0)? 2: 0);
    h_shift = 0;
    //modify offset and input size
    offset_x = (offset_x>>w_shift)<<w_shift;
    offset_y = (offset_y>>h_shift)<<h_shift;
    image_w =((image_w+((1<<w_shift)-1))>>w_shift)<<w_shift;
    //compute buffer address
    //--the size ratio of Y/G to UV/RB must be fit with input format and mode &&&&
    if(in_mode == 0x00)    //non macro block plannar
    {
        //line stride
        ch0_line_stride = image_w;
        ch1_line_stride = image_w>>(w_shift);
        ch2_line_stride = image_w>>(w_shift);
        //buffer address
        de_scal_ch0_offset = image_w * offset_y + offset_x;
        de_scal_ch1_offset = (image_w>>w_shift) * (offset_y>>h_shift) + (offset_x>>w_shift); //image_w'
        de_scal_ch2_offset = (image_w>>w_shift) * (offset_y>>h_shift) + (offset_x>>w_shift); //image_w'

        ch0_addr = ch0_base + de_scal_ch0_offset;
        ch1_addr = ch1_base + de_scal_ch1_offset;
        ch2_addr = ch2_base + de_scal_ch2_offset;
    }
    else if(in_mode == 0x01) //interleaved data
    {
        //line stride
        ch0_line_stride = image_w<<(0x02 - w_shift);
        ch1_line_stride = 0x00;
        ch2_line_stride = 0x00;
        //buffer address
        de_scal_ch0_offset = ((image_w * offset_y + offset_x)<<(0x02 - w_shift));
        de_scal_ch1_offset = 0x0;
        de_scal_ch2_offset = 0x0;

        ch0_addr = ch0_base + de_scal_ch0_offset;
        ch1_addr = 0x00;
        ch2_addr = 0x00;
    }
    else
    {
    	return 0;
    }
    //printk("in_fmt:%x,pixseq:%x,ch0_line_stride:%x,ch1_line_stride:%x,ch2_line_stride:%x,ch0_addr:%x,ch1_addr:%x,ch2_addr:%x\n",
    //	in_fmt,pixseq,ch0_line_stride,ch1_line_stride,ch2_line_stride,ch0_addr,ch1_addr,ch2_addr);
    DE_BE_YUV_CH_Set_Format(in_fmt,pixseq);
    //set line stride
    DE_BE_YUV_CH_Set_Line_Width(0x00, ch0_line_stride<<3);
    DE_BE_YUV_CH_Set_Line_Width(0x01, ch1_line_stride<<3);
    DE_BE_YUV_CH_Set_Line_Width(0x02, ch2_line_stride<<3);
    //set buffer address
    DE_BE_YUV_CH_Set_Addr(0x00, ch0_addr>>2);
    DE_BE_YUV_CH_Set_Addr(0x01, ch1_addr>>2);
    DE_BE_YUV_CH_Set_Addr(0x02, ch2_addr>>2);

    DE_BE_YUV_CH_Cfg_Csc_Coeff(in_src->cs_mode);
    return 0;
}

__s32 DE_BE_YUV_CH_Enable(__bool enable)
{
    if(enable)
    {
	    DE_BE_WUINT8(DE_BE_YUV_CTRL_OFF,DE_BE_RUINT8(DE_BE_YUV_CTRL_OFF)|0x01);
	}
	else
	{
	    DE_BE_WUINT8(DE_BE_YUV_CTRL_OFF,DE_BE_RUINT8(DE_BE_YUV_CTRL_OFF)&0xfe);
	}
	return 0;
}


