VARYING vec2 vTexCoord;
VARYING vec4 vColor;
VARYING vec3 vViewDir;
VARYING vec3 vViewNormal;

float fresnel = 1.0;
vec3 fViewNormal;

vec4 rainTex = vec4(1.0);
float a = 1.0;

vec3 blend_rnm(vec3 n1, vec3 n2)
{
    vec3 t = n1.xyz*vec3( 2,  2, 2) + vec3(-1, -1,  0);
    vec3 u = n2.xyz*vec3(-2, -2, 2) + vec3( 1,  1, -1);
    vec3 r = t*dot(t, u) - u*t.z;
    return normalize(r);
}

void MAIN(){
	rainTex = texture(rainmap, UV0);
	fresnel = abs(dot(normalize(vViewDir),normalize(VAR_WORLD_NORMAL)));
	fresnel *= 1.0 - abs(VAR_WORLD_NORMAL.y);
	
	a = rainTex.a*vColor.a*fresnel;
	if(a <= 0.0){discard;}

	BASE_COLOR = baseColor;
	SPECULAR_AMOUNT = 1.0;
	ROUGHNESS = 0.05;
	METALNESS = 0.0;
	NORMAL = blend_rnm(normalize(VAR_WORLD_NORMAL) * 0.5 + 0.5,rainTex.xyz);
	rainTex.rgb = rainTex.rgb * 2.0-1.0;
}

void POST_PROCESS()
{	
	vec2 screenPos = gl_FragCoord.xy/textureSize(SCREEN_TEXTURE, 0);
	vec2 screenCoord = vec2(screenPos);
	
	screenPos.x = rainTex.x > 0.0 ? mix(screenPos.x, 1.0,rainTex.x) : mix(screenPos.x, 0.0,-rainTex.x);
	screenPos.y = rainTex.y > 0.0 ? mix(screenPos.y, 1.0,rainTex.y) : mix(screenPos.y, 0.0,-rainTex.y);
	
	if (FRAMEBUFFER_Y_UP < 0.0) // effectively: if not OpenGL
        screenPos.y = 1.0 - screenPos.y;
	
    vec4 refraction = texture(SCREEN_TEXTURE, screenPos);
	
	
	a *= opacity;
	
	COLOR_SUM = vec4((DIFFUSE.rgb+SPECULAR+refraction.rgb),a);
}