/****************************************************************************
**
** Copyright (C) 2022 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of the examples of the Qt Design Studio.
**
** $QT_BEGIN_LICENSE:BSD$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** BSD License Usage
** Alternatively, you may use this file under the terms of the BSD license
** as follows:
**
** "Redistribution and use in source and binary forms, with or without
** modification, are permitted provided that the following conditions are
** met:
**   * Redistributions of source code must retain the above copyright
**     notice, this list of conditions and the following disclaimer.
**   * Redistributions in binary form must reproduce the above copyright
**     notice, this list of conditions and the following disclaimer in
**     the documentation and/or other materials provided with the
**     distribution.
**   * Neither the name of The Qt Company Ltd nor the names of its
**     contributors may be used to endorse or promote products derived
**     from this software without specific prior written permission.
**
**
** THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
** "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
** LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
** A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
** OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
** SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
** LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
** DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
** THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
** (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
** OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE."
**
** $QT_END_LICENSE$
**
****************************************************************************/
import QtQuick
import QtQuick.Timeline
import QtQuickUltralite.Extras
import MotorClusterData

Item
{
    id: root
    width: 1000
    height: 64

    property int separatorDistance: 250
    property int separatorCenter: 0

    property alias tripValue: trip.value
    property alias odoValue: odo.value
    property alias tempValue: temp.value
    property alias timeHour: clock.hour
    property alias timeMinute: clock.minute
    property bool active: false

    readonly property int margin: 23

    Dash {
        id: trip
        value: 100
        anchors.verticalCenter: parent.verticalCenter
        anchors.right: tripOdoSeparator.left
        anchors.rightMargin: 20
    }

    Rectangle {
        id: tripOdoSeparator
        opacity: 1
        height: root.height
        width: 2
        color: Style.white
        anchors.verticalCenter: parent.verticalCenter
        anchors.left: parent.left
        anchors.leftMargin: root.separatorDistance + root.separatorCenter
    }

    Dash {
        id: odo
        width: 226
        height: 50
        leftLabel: "ODO"
        anchors.verticalCenter: parent.verticalCenter
        anchors.left: tripOdoSeparator.right
        anchors.leftMargin: 20
    }

    Rectangle {
        id: tempTimeSeparator
        height: root.height
        width: 2
        color: Style.white
        anchors.verticalCenter: parent.verticalCenter
        anchors.right: parent.right
        anchors.rightMargin: root.separatorDistance - root.separatorCenter
    }

    Dash {
        id: temp
        value: 21
        leftLabel: ""
        rightLabel: "°C"
        anchors.verticalCenter: parent.verticalCenter
        anchors.right: tempTimeSeparator.left
        anchors.rightMargin: 20
    }

    Clock {
        id: clock
        anchors.verticalCenter: parent.verticalCenter
        anchors.left: tempTimeSeparator.right
        anchors.verticalCenterOffset: 3
        anchors.leftMargin: 20
    }
}

