/*
 * Decompiled with CFR 0.152.
 */
package iaik.security.dh;

import iaik.asn1.ASN1;
import iaik.asn1.CodingException;
import iaik.asn1.INTEGER;
import iaik.asn1.SEQUENCE;
import java.io.IOException;
import java.math.BigInteger;
import java.security.AlgorithmParametersSpi;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import javax.crypto.spec.DHParameterSpec;

public class DHParameters
extends AlgorithmParametersSpi {
    private int b = -1;
    BigInteger c;
    BigInteger a;

    public int hashCode() {
        return this.a.hashCode() ^ this.c.hashCode() ^ this.b;
    }

    protected String engineToString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("p: " + this.a + "\n");
        stringBuffer.append("g: " + this.c + "\n");
        if (this.b <= 0) {
            stringBuffer.append("l: " + this.b + "\n");
        }
        return stringBuffer.toString();
    }

    protected void engineInit(byte[] byArray, String string) throws IOException {
        this.engineInit(byArray);
    }

    protected void engineInit(byte[] byArray) throws IOException {
        try {
            ASN1 aSN1 = new ASN1(byArray);
            this.a = (BigInteger)aSN1.getComponentAt(0).getValue();
            this.c = (BigInteger)aSN1.getComponentAt(1).getValue();
            if (aSN1.countComponents() > 2) {
                this.b = ((BigInteger)aSN1.getComponentAt(0).getValue()).intValue();
                return;
            }
        }
        catch (CodingException codingException) {
            throw new IOException("Decoding error. " + codingException.toString());
        }
    }

    protected void engineInit(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidParameterSpecException {
        if (algorithmParameterSpec instanceof DHParameterSpec) {
            this.a = ((DHParameterSpec)algorithmParameterSpec).getP();
            this.c = ((DHParameterSpec)algorithmParameterSpec).getG();
            this.b = ((DHParameterSpec)algorithmParameterSpec).getL();
            return;
        }
        throw new InvalidParameterSpecException("Parameter must be DHParameterSpec.");
    }

    protected AlgorithmParameterSpec engineGetParameterSpec(Class clazz) throws InvalidParameterSpecException {
        DHParameterSpec dHParameterSpec = new DHParameterSpec(this.a, this.c, this.b);
        if (!dHParameterSpec.getClass().isAssignableFrom(clazz)) {
            throw new InvalidParameterSpecException("Can not convert to class " + clazz.getName());
        }
        return dHParameterSpec;
    }

    protected byte[] engineGetEncoded(String string) throws IOException {
        return this.engineGetEncoded();
    }

    protected byte[] engineGetEncoded() throws IOException {
        SEQUENCE sEQUENCE = new SEQUENCE();
        sEQUENCE.addComponent(new INTEGER(this.a));
        sEQUENCE.addComponent(new INTEGER(this.c));
        if (this.b > 0) {
            sEQUENCE.addComponent(new INTEGER(this.b));
        }
        try {
            return new ASN1(sEQUENCE).toByteArray();
        }
        catch (CodingException codingException) {
            throw new IOException("Encoding error. " + codingException.toString());
        }
    }
}

