/*
 * Decompiled with CFR 0.152.
 */
package iaik.xml.crypto.dsig.keyinfo;

import iaik.utils.RFC2253NameParser;
import iaik.utils.RFC2253NameParserException;
import iaik.xml.crypto.dom.XmldsigDOMStructure;
import iaik.xml.crypto.utils.DOMUtils;
import iaik.xml.crypto.utils.Utils;
import java.io.InputStream;
import java.security.cert.CRLException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.security.cert.X509Extension;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.dom.DOMCryptoContext;
import javax.xml.crypto.dom.DOMStructure;
import javax.xml.crypto.dsig.keyinfo.X509Data;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class X509DataImpl
extends XmldsigDOMStructure
implements X509Data {
    static /* synthetic */ Class class$javax$xml$crypto$XMLStructure;
    static /* synthetic */ Class class$java$security$cert$X509CRL;
    static /* synthetic */ Class class$java$security$cert$X509Certificate;
    static /* synthetic */ Class array$B;
    static /* synthetic */ Class class$java$lang$String;
    protected List content_;

    protected void unmarshalStructures(NodeList nodeList, DOMCryptoContext dOMCryptoContext) throws MarshalException {
        if (nodeList == null) {
            return;
        }
        int n = 0;
        while (n < nodeList.getLength()) {
            Node node = nodeList.item(n);
            if (node.getNodeType() == 1 && node.getNamespaceURI().equals("http://www.w3.org/2000/09/xmldsig#")) {
                X509Extension x509Extension;
                Object object;
                Object object2;
                if (node.getLocalName().equals("X509SubjectName")) {
                    object2 = DOMUtils.getAllTextFromChildren((Element)node);
                    try {
                        object = new RFC2253NameParser(((String)object2).replace('\n', ' ').trim()).parse();
                        this.content_.add(object.getRFC2253String());
                    }
                    catch (RFC2253NameParserException rFC2253NameParserException) {
                        throw new MarshalException("X509SubjectName '" + (String)object2 + "' is not RFC 2253 compliant.");
                    }
                } else if (node.getLocalName().equals("X509SKI")) {
                    object2 = iaik.xml.crypto.dom.DOMStructure.getBytesFromElement((Element)node);
                    this.content_.add(object2);
                } else if (node.getLocalName().equals("X509Certificate")) {
                    object2 = iaik.xml.crypto.dom.DOMStructure.getBytesFromElementStream((Element)node);
                    try {
                        object = CertificateFactory.getInstance("X509");
                        x509Extension = (X509Certificate)((CertificateFactory)object).generateCertificate((InputStream)object2);
                        this.content_.add(x509Extension);
                    }
                    catch (CertificateException certificateException) {
                        throw new MarshalException("Failed to parse X509Certificate. " + certificateException.getMessage(), certificateException);
                    }
                } else if (node.getLocalName().equals("X509CRL")) {
                    object2 = iaik.xml.crypto.dom.DOMStructure.getBytesFromElementStream((Element)node);
                    try {
                        object = CertificateFactory.getInstance("X509");
                        x509Extension = (X509CRL)((CertificateFactory)object).generateCRL((InputStream)object2);
                        this.content_.add(x509Extension);
                    }
                    catch (CertificateException certificateException) {
                        throw new MarshalException("Failed to parse X509CRL. " + certificateException.getMessage(), certificateException);
                    }
                    catch (CRLException cRLException) {
                        throw new MarshalException("Failed to parse X509CRL. " + cRLException.getMessage(), cRLException);
                    }
                } else {
                    object2 = iaik.xml.crypto.dom.DOMStructure.getInstance(node, dOMCryptoContext);
                    if (object2 != null) {
                        this.content_.add(object2);
                    } else {
                        this.content_.add(new DOMStructure(node));
                    }
                }
            }
            ++n;
        }
    }

    public Node marshal(DOMCryptoContext dOMCryptoContext, Node node, Node node2) throws MarshalException {
        Node node3 = super.marshal(dOMCryptoContext, node, node2);
        Iterator iterator = this.content_.iterator();
        while (iterator.hasNext()) {
            Element element;
            String string;
            Object object;
            Object e2 = iterator.next();
            if (e2 instanceof String) {
                object = DOMUtils.getOwnerDocument(node);
                string = dOMCryptoContext.getNamespacePrefix("http://www.w3.org/2000/09/xmldsig#", dOMCryptoContext.getDefaultNamespacePrefix());
                element = object.createElementNS("http://www.w3.org/2000/09/xmldsig#", iaik.xml.crypto.dom.DOMStructure.getQualifiedName(string, "X509SubjectName"));
                DOMUtils.addTextToElement(element, (String)e2);
                node3.appendChild(element);
                continue;
            }
            if (e2 instanceof byte[]) {
                object = DOMUtils.getOwnerDocument(node);
                string = dOMCryptoContext.getNamespacePrefix("http://www.w3.org/2000/09/xmldsig#", dOMCryptoContext.getDefaultNamespacePrefix());
                element = object.createElementNS("http://www.w3.org/2000/09/xmldsig#", iaik.xml.crypto.dom.DOMStructure.getQualifiedName(string, "X509SKI"));
                iaik.xml.crypto.dom.DOMStructure.addBytesToElement(element, (byte[])e2, dOMCryptoContext);
                node3.appendChild(element);
                continue;
            }
            if (e2 instanceof X509Certificate) {
                object = DOMUtils.getOwnerDocument(node);
                string = dOMCryptoContext.getNamespacePrefix("http://www.w3.org/2000/09/xmldsig#", dOMCryptoContext.getDefaultNamespacePrefix());
                element = object.createElementNS("http://www.w3.org/2000/09/xmldsig#", iaik.xml.crypto.dom.DOMStructure.getQualifiedName(string, "X509Certificate"));
                try {
                    iaik.xml.crypto.dom.DOMStructure.addBytesToElement(element, ((X509Certificate)e2).getEncoded(), dOMCryptoContext);
                }
                catch (CertificateEncodingException certificateEncodingException) {
                    throw new MarshalException("Failed to encode X509Certificate.", certificateEncodingException);
                }
                node3.appendChild(element);
                continue;
            }
            if (e2 instanceof X509CRL) {
                object = DOMUtils.getOwnerDocument(node);
                string = dOMCryptoContext.getNamespacePrefix("http://www.w3.org/2000/09/xmldsig#", dOMCryptoContext.getDefaultNamespacePrefix());
                element = object.createElementNS("http://www.w3.org/2000/09/xmldsig#", iaik.xml.crypto.dom.DOMStructure.getQualifiedName(string, "X509CRL"));
                try {
                    iaik.xml.crypto.dom.DOMStructure.addBytesToElement(element, ((X509CRL)e2).getEncoded(), dOMCryptoContext);
                }
                catch (CRLException cRLException) {
                    throw new MarshalException("Failed to encode X509CRL.", cRLException);
                }
                node3.appendChild(element);
                continue;
            }
            if (e2 instanceof iaik.xml.crypto.dom.DOMStructure) {
                object = (iaik.xml.crypto.dom.DOMStructure)e2;
                super.putChildStructure((iaik.xml.crypto.dom.DOMStructure)object);
                ((iaik.xml.crypto.dom.DOMStructure)object).marshal(dOMCryptoContext, this.getNode(), null);
                continue;
            }
            if (e2 instanceof DOMStructure) {
                object = ((DOMStructure)e2).getNode();
                if (object.getOwnerDocument() != node3.getOwnerDocument()) {
                    object = node3.getOwnerDocument().importNode((Node)object, true);
                }
                node3.appendChild((Node)object);
                continue;
            }
            throw new MarshalException("X509Data supports the DOM marshaling mechanism only.");
        }
        return node3;
    }

    public String getLocalName() {
        return "X509Data";
    }

    public List getContent() {
        return Collections.unmodifiableList(this.content_);
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public X509DataImpl(DOMCryptoContext dOMCryptoContext, Node node) throws MarshalException {
        super(node);
        if (dOMCryptoContext == null) {
            throw new NullPointerException("Argument 'context' must not be null");
        }
        this.content_ = new ArrayList();
        this.unmarshal(dOMCryptoContext);
        if (this.content_.isEmpty()) {
            throw new MarshalException("The content of element '" + node + "' is not complete.");
        }
    }

    public X509DataImpl(List list) {
        if (list == null) {
            throw new NullPointerException("Argument 'content' must not be null.");
        }
        if (list.isEmpty()) {
            throw new IllegalArgumentException("List 'content' must not be empty.");
        }
        this.content_ = Utils.copyList(list, new Class[]{class$java$lang$String != null ? class$java$lang$String : (class$java$lang$String = X509DataImpl.class$("java.lang.String")), array$B != null ? array$B : (array$B = X509DataImpl.class$("[B")), class$java$security$cert$X509Certificate != null ? class$java$security$cert$X509Certificate : (class$java$security$cert$X509Certificate = X509DataImpl.class$("java.security.cert.X509Certificate")), class$java$security$cert$X509CRL != null ? class$java$security$cert$X509CRL : (class$java$security$cert$X509CRL = X509DataImpl.class$("java.security.cert.X509CRL")), class$javax$xml$crypto$XMLStructure != null ? class$javax$xml$crypto$XMLStructure : (class$javax$xml$crypto$XMLStructure = X509DataImpl.class$("javax.xml.crypto.XMLStructure"))}, "content", false, false);
        Iterator iterator = this.content_.iterator();
        while (iterator.hasNext()) {
            Object e2 = iterator.next();
            if (!(e2 instanceof String)) continue;
            try {
                new RFC2253NameParser((String)e2).parse();
            }
            catch (RFC2253NameParserException rFC2253NameParserException) {
                throw new IllegalArgumentException("SubjectName '" + e2 + "' is not RFC 2253 compliant.");
            }
        }
    }
}

