/*
 * Decompiled with CFR 0.152.
 */
package iaik.xml.crypto.dsig.keyinfo;

import iaik.xml.crypto.dom.DOMStructure;
import iaik.xml.crypto.dsig.keyinfo.KeyValueType;
import iaik.xml.crypto.utils.DOMUtils;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.interfaces.DSAParams;
import java.security.interfaces.DSAPublicKey;
import java.security.spec.DSAPublicKeySpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.dom.DOMCryptoContext;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DSAKeyValueImpl
extends KeyValueType {
    protected void unmarshalStructures(NodeList nodeList, DOMCryptoContext dOMCryptoContext) throws MarshalException {
        Object object;
        if (nodeList == null) {
            return;
        }
        BigInteger bigInteger = null;
        BigInteger bigInteger2 = null;
        BigInteger bigInteger3 = null;
        BigInteger bigInteger4 = null;
        int n = 0;
        while (n < nodeList.getLength()) {
            object = nodeList.item(n);
            if (object.getNodeType() == 1 && object.getNamespaceURI().equals("http://www.w3.org/2000/09/xmldsig#")) {
                if (object.getLocalName().equals("P")) {
                    bigInteger = new BigInteger(1, DOMStructure.getBytesFromElement((Element)object));
                } else if (object.getLocalName().equals("Q")) {
                    bigInteger2 = new BigInteger(1, DOMStructure.getBytesFromElement((Element)object));
                } else if (object.getLocalName().equals("G")) {
                    bigInteger3 = new BigInteger(1, DOMStructure.getBytesFromElement((Element)object));
                } else if (object.getLocalName().equals("Y")) {
                    bigInteger4 = new BigInteger(1, DOMStructure.getBytesFromElement((Element)object));
                }
            }
            ++n;
        }
        object = new DSAPublicKeySpec(bigInteger4, bigInteger, bigInteger2, bigInteger3);
        try {
            KeyFactory keyFactory = KeyFactory.getInstance("DSA");
            this.publicKey_ = (DSAPublicKey)keyFactory.generatePublic((KeySpec)object);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new MarshalException("Failed to create DSA key.");
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            throw new MarshalException("Failed to create DSA key.");
        }
    }

    public Node marshal(DOMCryptoContext dOMCryptoContext, Node node, Node node2) throws MarshalException {
        Object object;
        BigInteger bigInteger;
        Node node3 = super.marshal(dOMCryptoContext, node, node2);
        Document document = DOMUtils.getOwnerDocument(node);
        String string = dOMCryptoContext.getNamespacePrefix("http://www.w3.org/2000/09/xmldsig#", dOMCryptoContext.getDefaultNamespacePrefix());
        DSAPublicKey dSAPublicKey = (DSAPublicKey)this.publicKey_;
        DSAParams dSAParams = dSAPublicKey.getParams();
        if (dSAParams != null) {
            Element element;
            Object object2;
            bigInteger = dSAParams.getP();
            object = dSAParams.getQ();
            if (bigInteger != null && object != null) {
                object2 = document.createElementNS("http://www.w3.org/2000/09/xmldsig#", DOMStructure.getQualifiedName(string, "P"));
                element = document.createElementNS("http://www.w3.org/2000/09/xmldsig#", DOMStructure.getQualifiedName(string, "Q"));
                DOMStructure.addBytesToElement((Element)object2, DOMUtils.bigInteger2byteArray(bigInteger), dOMCryptoContext);
                DOMStructure.addBytesToElement(element, DOMUtils.bigInteger2byteArray((BigInteger)object), dOMCryptoContext);
                node3.appendChild((Node)object2);
                node3.appendChild(element);
            }
            if ((object2 = dSAParams.getG()) != null) {
                element = document.createElementNS("http://www.w3.org/2000/09/xmldsig#", DOMStructure.getQualifiedName(string, "G"));
                DOMStructure.addBytesToElement(element, DOMUtils.bigInteger2byteArray((BigInteger)object2), dOMCryptoContext);
                node3.appendChild(element);
            }
        }
        bigInteger = dSAPublicKey.getY();
        object = document.createElementNS("http://www.w3.org/2000/09/xmldsig#", DOMStructure.getQualifiedName(string, "Y"));
        DOMStructure.addBytesToElement((Element)object, DOMUtils.bigInteger2byteArray(bigInteger), dOMCryptoContext);
        node3.appendChild((Node)object);
        return node3;
    }

    public String getLocalName() {
        return "DSAKeyValue";
    }

    public DSAKeyValueImpl(DOMCryptoContext dOMCryptoContext, Node node) throws MarshalException {
        super(node);
        if (dOMCryptoContext == null) {
            throw new NullPointerException("Argument 'context' must not be null");
        }
        this.unmarshal(dOMCryptoContext);
        if (this.publicKey_ == null) {
            throw new MarshalException("The content of element '" + node + "' is not complete.");
        }
    }

    public DSAKeyValueImpl(DSAPublicKey dSAPublicKey) {
        super(dSAPublicKey);
    }
}

