/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.txw2.output;

import com.sun.xml.internal.txw2.output.CharacterEscapeHandler;
import com.sun.xml.internal.txw2.output.DumbEscapeHandler;
import com.sun.xml.internal.txw2.output.XMLWriter;
import java.io.Writer;
import java.util.Stack;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class DataWriter
extends XMLWriter {
    private static final Object SEEN_NOTHING = new Object();
    private static final Object SEEN_ELEMENT = new Object();
    private static final Object SEEN_DATA = new Object();
    private Object state = SEEN_NOTHING;
    private Stack stateStack = new Stack();
    private String indentStep = "";
    private int depth = 0;

    public DataWriter(Writer writer, String string, CharacterEscapeHandler characterEscapeHandler) {
        super(writer, string, characterEscapeHandler);
    }

    public DataWriter(Writer writer, String string) {
        this(writer, string, DumbEscapeHandler.theInstance);
    }

    public DataWriter(Writer writer) {
        this(writer, null, DumbEscapeHandler.theInstance);
    }

    public int getIndentStep() {
        return this.indentStep.length();
    }

    public void setIndentStep(int n) {
        StringBuilder stringBuilder = new StringBuilder();
        while (n > 0) {
            stringBuilder.append(' ');
            --n;
        }
        this.setIndentStep(stringBuilder.toString());
    }

    public void setIndentStep(String string) {
        this.indentStep = string;
    }

    @Override
    public void reset() {
        this.depth = 0;
        this.state = SEEN_NOTHING;
        this.stateStack = new Stack();
        super.reset();
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        this.stateStack.push(SEEN_ELEMENT);
        this.state = SEEN_NOTHING;
        if (this.depth > 0) {
            super.characters("\n");
        }
        this.doIndent();
        super.startElement(string, string2, string3, attributes);
        ++this.depth;
    }

    @Override
    public void endElement(String string, String string2, String string3) throws SAXException {
        --this.depth;
        if (this.state == SEEN_ELEMENT) {
            super.characters("\n");
            this.doIndent();
        }
        super.endElement(string, string2, string3);
        this.state = this.stateStack.pop();
    }

    @Override
    public void characters(char[] cArray, int n, int n2) throws SAXException {
        this.state = SEEN_DATA;
        super.characters(cArray, n, n2);
    }

    @Override
    public void comment(char[] cArray, int n, int n2) throws SAXException {
        if (this.depth > 0) {
            super.characters("\n");
        }
        this.doIndent();
        super.comment(cArray, n, n2);
    }

    private void doIndent() throws SAXException {
        if (this.depth > 0) {
            char[] cArray = this.indentStep.toCharArray();
            for (int i = 0; i < this.depth; ++i) {
                this.characters(cArray, 0, cArray.length);
            }
        }
    }
}

