/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ssl.krb5;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.SecureRandom;
import java.text.MessageFormat;
import java.util.Locale;
import javax.security.auth.kerberos.KerberosKey;
import javax.security.auth.kerberos.KerberosPrincipal;
import javax.security.auth.kerberos.KerberosTicket;
import javax.security.auth.kerberos.ServicePermission;
import sun.misc.HexDumpEncoder;
import sun.security.jgss.GSSCaller;
import sun.security.jgss.krb5.Krb5Util;
import sun.security.jgss.krb5.ServiceCreds;
import sun.security.krb5.EncryptedData;
import sun.security.krb5.EncryptionKey;
import sun.security.krb5.KrbException;
import sun.security.krb5.PrincipalName;
import sun.security.krb5.internal.EncTicketPart;
import sun.security.krb5.internal.Ticket;
import sun.security.ssl.HandshakeOutStream;
import sun.security.ssl.KerberosClientKeyExchange;
import sun.security.ssl.Krb5Helper;
import sun.security.ssl.ProtocolVersion;
import sun.security.ssl.Record;
import sun.security.ssl.SSLLogger;
import sun.security.ssl.Utilities;
import sun.security.ssl.krb5.KerberosPreMasterSecret;

public final class KerberosClientKeyExchangeImpl
extends KerberosClientKeyExchange {
    private KerberosPreMasterSecret preMaster;
    private byte[] encodedTicket;
    private KerberosPrincipal peerPrincipal;
    private KerberosPrincipal localPrincipal;

    @Override
    public void init(String string, AccessControlContext accessControlContext, ProtocolVersion protocolVersion, SecureRandom secureRandom) throws IOException {
        KerberosTicket kerberosTicket = KerberosClientKeyExchangeImpl.getServiceTicket(string, accessControlContext);
        this.encodedTicket = kerberosTicket.getEncoded();
        this.peerPrincipal = kerberosTicket.getServer();
        this.localPrincipal = kerberosTicket.getClient();
        EncryptionKey encryptionKey = new EncryptionKey(kerberosTicket.getSessionKeyType(), kerberosTicket.getSessionKey().getEncoded());
        this.preMaster = new KerberosPreMasterSecret(protocolVersion, secureRandom, encryptionKey);
    }

    @Override
    public void init(ProtocolVersion protocolVersion, ProtocolVersion protocolVersion2, SecureRandom secureRandom, ByteBuffer byteBuffer, AccessControlContext accessControlContext, Object object) throws IOException {
        this.encodedTicket = Record.getBytes16(byteBuffer);
        if (SSLLogger.isOn && SSLLogger.isOn("verbose")) {
            SSLLogger.fine("encoded Kerberos service ticket", new Object[]{this.encodedTicket});
        }
        EncryptionKey encryptionKey = null;
        try {
            KerberosKey[] kerberosKeyArray;
            Ticket ticket = new Ticket(this.encodedTicket);
            EncryptedData encryptedData = ticket.encPart;
            PrincipalName principalName = ticket.sname;
            final ServiceCreds serviceCreds = (ServiceCreds)object;
            final KerberosPrincipal kerberosPrincipal = new KerberosPrincipal(principalName.toString());
            if (serviceCreds.getName() == null) {
                kerberosKeyArray = System.getSecurityManager();
                try {
                    if (kerberosKeyArray != null) {
                        kerberosKeyArray.checkPermission(Krb5Helper.getServicePermission(principalName.toString(), "accept"), accessControlContext);
                    }
                }
                catch (SecurityException securityException) {
                    object = null;
                    if (SSLLogger.isOn && SSLLogger.isOn("handshake")) {
                        SSLLogger.fine("Permission to access Kerberos secret key denied", new Object[0]);
                    }
                    throw new IOException("Kerberos service not allowed");
                }
            }
            if ((kerberosKeyArray = AccessController.doPrivileged(new PrivilegedAction<KerberosKey[]>(){

                @Override
                public KerberosKey[] run() {
                    return serviceCreds.getKKeys(kerberosPrincipal);
                }
            })).length == 0) {
                throw new IOException("Found no key for " + kerberosPrincipal + (serviceCreds.getName() == null ? "" : ", this keytab is for " + serviceCreds.getName() + " only"));
            }
            int n = encryptedData.getEType();
            Integer n2 = encryptedData.getKeyVersionNumber();
            KerberosKey kerberosKey = null;
            try {
                kerberosKey = KerberosClientKeyExchangeImpl.findKey(n, n2, kerberosKeyArray);
            }
            catch (KrbException krbException) {
                throw new IOException("Cannot find key matching version number", krbException);
            }
            if (kerberosKey == null) {
                throw new IOException("Cannot find key of appropriate type to decrypt ticket - need etype " + n);
            }
            EncryptionKey encryptionKey2 = new EncryptionKey(n, kerberosKey.getEncoded());
            byte[] byArray = encryptedData.decrypt(encryptionKey2, 2);
            byte[] byArray2 = encryptedData.reset(byArray);
            EncTicketPart encTicketPart = new EncTicketPart(byArray2);
            this.peerPrincipal = new KerberosPrincipal(encTicketPart.cname.getName());
            this.localPrincipal = new KerberosPrincipal(principalName.getName());
            encryptionKey = encTicketPart.key;
            if (SSLLogger.isOn && SSLLogger.isOn("handshake")) {
                SSLLogger.fine("server principal: " + principalName, new Object[0]);
                SSLLogger.fine("cname: " + encTicketPart.cname.toString(), new Object[0]);
            }
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (Exception exception) {
            if (SSLLogger.isOn && SSLLogger.isOn("handshake")) {
                SSLLogger.fine("KerberosWrapper error getting session key, generating random secret (" + exception.getMessage() + ")", new Object[0]);
            }
            encryptionKey = null;
        }
        Record.getBytes16(byteBuffer);
        this.preMaster = encryptionKey != null ? new KerberosPreMasterSecret(protocolVersion, protocolVersion2, secureRandom, byteBuffer, encryptionKey) : new KerberosPreMasterSecret(protocolVersion2, secureRandom);
    }

    @Override
    public int messageLength() {
        return 6 + this.encodedTicket.length + this.preMaster.getEncrypted().length;
    }

    @Override
    public void send(HandshakeOutStream handshakeOutStream) throws IOException {
        handshakeOutStream.putBytes16(this.encodedTicket);
        handshakeOutStream.putBytes16(null);
        handshakeOutStream.putBytes16(this.preMaster.getEncrypted());
    }

    @Override
    public String toString() {
        MessageFormat messageFormat = new MessageFormat("\"Kerberos ClientKeyExchange\": '{'\n  \"local_principal\":  {0}\n  \"peer_principal\":  {1}\n  \"service_ticket\": '{'\n{2}\n  '}'\n  \"random_secret\": '{'\n{3}\n  '}'\n  \"encrypted_random_secret\": '{'\n{4}\n  '}'\n'}'", Locale.ENGLISH);
        HexDumpEncoder hexDumpEncoder = new HexDumpEncoder();
        Object[] objectArray = new Object[]{this.localPrincipal.getName(), this.localPrincipal.getName(), Utilities.indent(hexDumpEncoder.encodeBuffer(this.encodedTicket), "    "), Utilities.indent(hexDumpEncoder.encodeBuffer(this.preMaster.getUnencrypted()), "    "), Utilities.indent(hexDumpEncoder.encodeBuffer(this.preMaster.getEncrypted()), "    ")};
        return messageFormat.format(objectArray);
    }

    private static KerberosTicket getServiceTicket(String string, final AccessControlContext accessControlContext) throws IOException {
        PrincipalName principalName;
        String string2;
        if ("localhost".equals(string) || "localhost.localdomain".equals(string)) {
            if (SSLLogger.isOn && SSLLogger.isOn("handshake")) {
                SSLLogger.fine("Get the local hostname", new Object[0]);
            }
            if ((string2 = AccessController.doPrivileged(new PrivilegedAction<String>(){

                @Override
                public String run() {
                    try {
                        return InetAddress.getLocalHost().getHostName();
                    }
                    catch (UnknownHostException unknownHostException) {
                        if (SSLLogger.isOn && SSLLogger.isOn("handshake")) {
                            SSLLogger.fine("Warning, cannot get the local hostname: " + unknownHostException.getMessage(), new Object[0]);
                        }
                        return null;
                    }
                }
            })) != null) {
                string = string2;
            }
        }
        string2 = "host/" + string;
        try {
            principalName = new PrincipalName(string2, 3);
        }
        catch (SecurityException securityException) {
            throw securityException;
        }
        catch (Exception exception) {
            IOException iOException = new IOException("Invalid service principal name: " + string2);
            iOException.initCause(exception);
            throw iOException;
        }
        String string3 = principalName.getRealmAsString();
        final String string4 = principalName.toString();
        final String string5 = "krbtgt/" + string3 + "@" + string3;
        final String string6 = null;
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new ServicePermission(string4, "initiate"), accessControlContext);
        }
        try {
            KerberosTicket kerberosTicket = AccessController.doPrivileged(new PrivilegedExceptionAction<KerberosTicket>(){

                @Override
                public KerberosTicket run() throws Exception {
                    return Krb5Util.getTicketFromSubjectAndTgs((GSSCaller)GSSCaller.CALLER_SSL_CLIENT, (String)string6, (String)string4, (String)string5, (AccessControlContext)accessControlContext);
                }
            });
            if (kerberosTicket == null) {
                throw new IOException("Failed to find any kerberos service ticket for " + string4);
            }
            return kerberosTicket;
        }
        catch (PrivilegedActionException privilegedActionException) {
            IOException iOException = new IOException("Attempt to obtain kerberos service ticket for " + string4 + " failed!");
            iOException.initCause(privilegedActionException);
            throw iOException;
        }
    }

    @Override
    public byte[] getUnencryptedPreMasterSecret() {
        return this.preMaster.getUnencrypted();
    }

    @Override
    public KerberosPrincipal getPeerPrincipal() {
        return this.peerPrincipal;
    }

    @Override
    public KerberosPrincipal getLocalPrincipal() {
        return this.localPrincipal;
    }

    private static boolean versionMatches(Integer n, int n2) {
        if (n == null || n == 0 || n2 == 0) {
            return true;
        }
        return n.equals(n2);
    }

    private static KerberosKey findKey(int n, Integer n2, KerberosKey[] kerberosKeyArray) throws KrbException {
        int n3;
        int n4;
        int n5;
        boolean bl = false;
        int n6 = 0;
        KerberosKey kerberosKey = null;
        for (n5 = 0; n5 < kerberosKeyArray.length; ++n5) {
            n4 = kerberosKeyArray[n5].getKeyType();
            if (n != n4) continue;
            n3 = kerberosKeyArray[n5].getVersionNumber();
            bl = true;
            if (KerberosClientKeyExchangeImpl.versionMatches(n2, n3)) {
                return kerberosKeyArray[n5];
            }
            if (n3 <= n6) continue;
            kerberosKey = kerberosKeyArray[n5];
            n6 = n3;
        }
        if (n == 1 || n == 3) {
            for (n5 = 0; n5 < kerberosKeyArray.length; ++n5) {
                n4 = kerberosKeyArray[n5].getKeyType();
                if (n4 != 1 && n4 != 3) continue;
                n3 = kerberosKeyArray[n5].getVersionNumber();
                bl = true;
                if (KerberosClientKeyExchangeImpl.versionMatches(n2, n3)) {
                    return new KerberosKey(kerberosKeyArray[n5].getPrincipal(), kerberosKeyArray[n5].getEncoded(), n, n3);
                }
                if (n3 <= n6) continue;
                kerberosKey = new KerberosKey(kerberosKeyArray[n5].getPrincipal(), kerberosKeyArray[n5].getEncoded(), n, n3);
                n6 = n3;
            }
        }
        if (bl) {
            return kerberosKey;
        }
        return null;
    }
}

