/*
 * Decompiled with CFR 0.152.
 */
package it.sogei.rcp.pki.manager;

import cryptotools.CertificateUtils;
import cryptotools.Vault;
import cryptotools.decrypter;
import cryptotools.encrypter;
import cryptotools.initEnv;
import it.sogei.rcp.interfaces.IAbsolutePath;
import it.sogei.rcp.pki.Activator;
import it.sogei.rcp.pki.bean.KeyStoreInfo;
import it.sogei.rcp.pki.exception.DecryptException;
import it.sogei.rcp.pki.exception.EncryptException;
import it.sogei.rcp.pki.exception.PkiException;
import it.sogei.rcp.util.AbsolutePath;
import it.sogei.utilities.log4j.LogUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.KeyStore;
import java.security.cert.X509Certificate;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ui.PlatformUI;

public class Encrypter {
    private KeyStoreInfo keystore;

    public Encrypter(KeyStoreInfo keystore) throws PkiException {
        this.keystore = keystore;
        CertificateUtils.installBCProvider();
        try {
            String cryptoFilePath = Activator.cryptotoolsFileMap.get(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getPerspective().getId());
            LogUtil.log((Object)this, (int)2, (String)("Encrypter crypto file path:" + cryptoFilePath));
            initEnv IE = new initEnv();
            initEnv.loadEnv((String)cryptoFilePath);
            String javaHome = System.getProperty("java.home");
            String eclipseHome = System.getProperty("eclipse.home.location").substring(6);
            LogUtil.log((Object)this, (int)2, (String)("javaHome:" + javaHome));
            LogUtil.log((Object)this, (int)2, (String)("eclipseHome:" + eclipseHome));
            if (!javaHome.contains(eclipseHome)) {
                String javaSpecVersion = System.getProperty("java.specification.version");
                String localPolicyBundlePath = null;
                int localPolicyFileLength = 0;
                if (javaSpecVersion.equals("1.6")) {
                    localPolicyBundlePath = "resource/jre1.6/local_policy.jar";
                    localPolicyFileLength = 2481;
                } else {
                    localPolicyBundlePath = "resource/jre1.7/local_policy.jar";
                    localPolicyFileLength = 2500;
                }
                InputStream istrm = Platform.getBundle((String)"it.sogei.rcp.pki").getResource(localPolicyBundlePath).openStream();
                File fdel = new File(String.valueOf(javaHome) + "/lib/security/local_policy.jar");
                AbsolutePath fcopy = new AbsolutePath(String.valueOf(javaHome) + "/lib/security/local_policy.jar");
                LogUtil.log((Object)this, (int)2, (String)("LocalPolicy Jar: " + fcopy));
                if (fdel.length() != (long)localPolicyFileLength && fdel.delete()) {
                    this.fileCopy(istrm, (IAbsolutePath)fcopy);
                    LogUtil.log((Object)this, (int)2, (String)"Sostituzione policy java avvenuta con successo.");
                }
            }
        }
        catch (Exception ex) {
            throw new PkiException("Errore nel caricamento delle configurazioni", ex);
        }
    }

    public void encrypt(IAbsolutePath pathFileToCypher, IAbsolutePath pathFileCyphered, IAbsolutePath pathFileCert) throws EncryptException {
        X509Certificate cert;
        try {
            LogUtil.log((Object)this, (int)2, (String)("Encrypt - Certificato " + pathFileCert.getAbsolutePath()));
            cert = CertificateUtils.loadCertificate((String)pathFileCert.getAbsolutePath());
        }
        catch (Exception ex) {
            throw new EncryptException("Errore nella lettura del certificato di cifratura", ex);
        }
        this.encrypt(pathFileToCypher, pathFileCyphered, cert);
    }

    public void encrypt(IAbsolutePath pathFileToCypher, IAbsolutePath pathFileCyphered, String alias) throws EncryptException {
        FileInputStream fis = null;
        try {
            try {
                KeyStore keystoreP12 = KeyStore.getInstance("PKCS12");
                fis = new FileInputStream(this.keystore.getPath().getAbsolutePath());
                keystoreP12.load(fis, this.keystore.getPassword().toCharArray());
                X509Certificate cert = (X509Certificate)keystoreP12.getCertificate(alias);
                this.encrypt(pathFileToCypher, pathFileCyphered, cert);
            }
            catch (Exception ex) {
                throw new EncryptException("Errore nella lettura del certificato dal keystore", ex);
            }
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    throw new EncryptException("Errore nella decifratura del file " + pathFileCyphered, e);
                }
            }
        }
    }

    private void encrypt(IAbsolutePath pathFileToCypher, IAbsolutePath pathFileCyphered, X509Certificate cert) throws EncryptException {
        try {
            X509Certificate[] certs = new X509Certificate[]{cert};
            encrypter.encrypt((String)pathFileToCypher.getAbsolutePath(), (String)pathFileCyphered.getAbsolutePath(), (X509Certificate[])certs);
        }
        catch (Exception ex) {
            throw new EncryptException("Errore nella cifratura del file " + pathFileToCypher, ex);
        }
    }

    public void streamEncrypt(IAbsolutePath pathFileToCypher, IAbsolutePath pathFileCyphered, IAbsolutePath pathFileCert) throws EncryptException {
        try {
            X509Certificate cert = CertificateUtils.loadCertificate((String)pathFileCert.getAbsolutePath());
            this.streamEncrypt(pathFileToCypher, pathFileCyphered, cert);
        }
        catch (Exception ex) {
            throw new EncryptException("Errore nella lettura del certificato di cifratura", ex);
        }
    }

    public void streamEncrypt(IAbsolutePath pathFileToCypher, IAbsolutePath pathFileCyphered, String alias) throws EncryptException {
        FileInputStream fis = null;
        try {
            try {
                KeyStore keystoreP12 = KeyStore.getInstance("PKCS12");
                fis = new FileInputStream(this.keystore.getPath().getAbsolutePath());
                keystoreP12.load(fis, this.keystore.getPassword().toCharArray());
                X509Certificate cert = (X509Certificate)keystoreP12.getCertificate(alias);
                this.streamEncrypt(pathFileToCypher, pathFileCyphered, cert);
            }
            catch (Exception ex) {
                throw new EncryptException("Errore nella lettura del certificato dal keystore", ex);
            }
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    throw new EncryptException("Errore nella decifratura del file " + pathFileCyphered, e);
                }
            }
        }
    }

    private void streamEncrypt(IAbsolutePath pathFileToCypher, IAbsolutePath pathFileCyphered, X509Certificate cert) throws EncryptException {
        FileInputStream fis = null;
        FileOutputStream fos = null;
        try {
            try {
                fis = new FileInputStream(pathFileToCypher.getAbsolutePath());
                fos = new FileOutputStream(pathFileCyphered.getAbsolutePath());
                X509Certificate[] certs = new X509Certificate[]{cert};
                encrypter.stream_encrypt((InputStream)fis, (OutputStream)fos, (X509Certificate[])certs);
            }
            catch (Exception ex) {
                throw new EncryptException("Errore nella cifratura del file " + pathFileToCypher, ex);
            }
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    throw new EncryptException("Errore nella decifratura del file " + pathFileCyphered, e);
                }
            }
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e) {
                    throw new EncryptException("Errore nella decifratura del file " + pathFileCyphered, e);
                }
            }
        }
    }

    public void decrypt(IAbsolutePath pathFileCyphered, IAbsolutePath pathFileDesecure) throws DecryptException {
        FileInputStream fis = null;
        FileOutputStream fos = null;
        try {
            try {
                Vault v = new Vault(this.keystore.getPath().getAbsolutePath(), "PKCS12");
                v.Open(this.keystore.getPassword());
                decrypter.setVault((Vault)v);
                fis = new FileInputStream(pathFileCyphered.getAbsolutePath());
                fos = new FileOutputStream(pathFileDesecure.getAbsolutePath());
                decrypter.desecure((InputStream)fis, (OutputStream)fos, (Vault)v);
            }
            catch (Exception ex) {
                throw new DecryptException("Errore nella decifratura del file " + pathFileCyphered, ex);
            }
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    throw new DecryptException("Errore nella decifratura del file " + pathFileCyphered, e);
                }
            }
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e) {
                    throw new DecryptException("Errore nella decifratura del file " + pathFileCyphered, e);
                }
            }
        }
    }

    public void streamDecrypt(IAbsolutePath pathFileCyphered, IAbsolutePath pathFileDesecure) throws DecryptException {
        FileInputStream fis = null;
        FileOutputStream fos = null;
        try {
            try {
                Vault v = new Vault(this.keystore.getPath().getAbsolutePath(), "PKCS12");
                v.Open(this.keystore.getPassword());
                decrypter.setVault((Vault)v);
                X509Certificate[] cert = new X509Certificate[1];
                fis = new FileInputStream(pathFileCyphered.getAbsolutePath());
                fos = new FileOutputStream(pathFileDesecure.getAbsolutePath());
                decrypter.desecureLargeData((InputStream)fis, (OutputStream)fos, (Vault)v, (X509Certificate[])cert);
            }
            catch (Exception ex) {
                throw new DecryptException("Errore nella decifratura del file " + pathFileCyphered, ex);
            }
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    throw new DecryptException("Errore nella decifratura del file " + pathFileCyphered, e);
                }
            }
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e) {
                    throw new DecryptException("Errore nella decifratura del file " + pathFileCyphered, e);
                }
            }
        }
    }

    private void fileCopy(InputStream streamSource, IAbsolutePath pathFileDest) throws Exception {
        int bytes_read;
        File outputFile = new File(pathFileDest.getAbsolutePath());
        FileOutputStream out = new FileOutputStream(outputFile);
        byte[] buffer = new byte[4096];
        while ((bytes_read = streamSource.read(buffer)) != -1) {
            out.write(buffer, 0, bytes_read);
        }
        streamSource.close();
        out.close();
    }
}

