/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.workbench.addons.dndaddon;

import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.model.application.ui.basic.MStackElement;
import org.eclipse.e4.ui.workbench.addons.dndaddon.DnDInfo;
import org.eclipse.e4.ui.workbench.addons.dndaddon.DnDManager;
import org.eclipse.e4.ui.workbench.addons.dndaddon.DragAgent;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;

public class PartDragAgent
extends DragAgent {
    public PartDragAgent(DnDManager manager) {
        super(manager);
    }

    public MUIElement getElementToDrag(DnDInfo info) {
        if (!(info.curElement instanceof MPartStack)) {
            return null;
        }
        MPartStack stack = (MPartStack)info.curElement;
        if (info.itemElement instanceof MStackElement) {
            if (info.itemElement.getTags().contains("NoMove")) {
                return null;
            }
            int tbrCount = this.dndManager.getModelService().countRenderableChildren((MUIElement)stack);
            if (tbrCount > 1 || this.dndManager.getModelService().isLastEditorStack((MUIElement)stack)) {
                this.dragElement = info.itemElement;
                return info.itemElement;
            }
        }
        if (!(stack.getWidget() instanceof CTabFolder)) {
            return null;
        }
        CTabFolder ctf = (CTabFolder)stack.getWidget();
        Point ctfPos = ctf.getDisplay().map(null, (Control)ctf, info.cursorPos);
        if (ctfPos.y > ctf.getTabHeight()) {
            return null;
        }
        if (stack.getTags().contains("NoMove")) {
            return null;
        }
        if (this.dndManager.getModelService().isLastEditorStack((MUIElement)stack)) {
            return null;
        }
        this.dragElement = info.curElement;
        return info.curElement;
    }

    public void dragStart(DnDInfo info) {
        super.dragStart(info);
        if (this.dndManager.getFeedbackStyle() != 3) {
            this.dndManager.hostElement(this.dragElement, 16, 10);
        }
    }

    public void dragFinished(boolean performDrop, DnDInfo info) {
        if (this.dragElement instanceof MPart) {
            EPartService ps = (EPartService)this.dndManager.getDragWindow().getContext().get(EPartService.class);
            ps.activate((MPart)this.dragElement);
        }
        super.dragFinished(performDrop, info);
    }
}

