/*
 * Decompiled with CFR 0.152.
 */
package it.sogei.telematico.security.login.ui.dialogs;

import it.sogei.rcp.filesystemutil.WorkSpaceUtil;
import it.sogei.rcp.security.login.beans.UtentiBean;
import it.sogei.rcp.security.login.db.DesktopDB;
import it.sogei.rcp.ui.preferences.entities.PreferenceBean;
import it.sogei.rcp.ui.preferences.entities.ScopeEnum;
import it.sogei.rcp.ui.preferences.util.PreferencesUtilRCP;
import it.sogei.telematico.security.login.ui.dialogs.CambiaPsw;
import it.sogei.telematico.security.login.ui.dialogs.CreateUser;
import it.sogei.telematico.security.login.ui.properties.Messages;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.sql.SQLException;
import java.util.ArrayList;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.operation.ModalContext;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wb.swt.SWTResourceManager;

public class ChooseUser
extends TitleAreaDialog
implements CallbackHandler {
    public static final String WS_IDENTIFIER = "DesktopUnificato.preferences";
    private static final String _KeyWorkspaceRootDir = "wsRootDir";
    private static final String _KeyRememberWorkspace = "wsRemember";
    private static final String _KeyLastUsedWorkspaces = "wsLastUsedWorkspaces";
    private static final String _StrMsg = Messages.ChooseUser_4;
    private static final String _StrError = Messages.ChooseUser_5;
    private static final String _StrErrorPassword = Messages.ChooseUser_6;
    private static final String _StrErrorPasswordError = Messages.ChooseUser_7;
    Combo _userCombo;
    private Button _RememberWorkspaceButton;
    private boolean _switchWorkspace;
    private boolean _passwordRequired;
    private boolean _multiUser;
    private String _selectedWorkspaceRootLocation;
    Text usernameField;
    Text passwordField;
    char[] password;
    String username;
    Composite outer;
    Button login;
    Button create;
    Button recuperaWSButton;
    Button cambiaPsw;
    Button eliminaUtente;
    private boolean processCallbacks = false;
    private boolean isCancelled = false;
    private boolean flagPassword = false;
    private Callback[] callbackArray;
    private GridData gridData_1;

    public ChooseUser() {
        super(Display.getDefault().getActiveShell());
        this.setHelpAvailable(false);
        this._passwordRequired = new Boolean(PreferencesUtilRCP.getPreferenceValue((PreferenceBean)new PreferenceBean("it.sogei.rcp.security.login", "security", "passwordRequired"), (ScopeEnum)ScopeEnum.CONFIGURATION));
        this._multiUser = new Boolean(PreferencesUtilRCP.getPreferenceValue((PreferenceBean)new PreferenceBean("it.sogei.rcp.security.login", "security", "multiUser"), (ScopeEnum)ScopeEnum.CONFIGURATION));
        this._selectedWorkspaceRootLocation = PreferencesUtilRCP.getPreferenceValue((PreferenceBean)new PreferenceBean("it.sogei.rcp.security.login", "security", "workspaceLocation"), (ScopeEnum)ScopeEnum.CONFIGURATION);
        this._switchWorkspace = false;
    }

    protected void handleShellCloseEvent() {
        this.isCancelled = true;
        this.processCallbacks = true;
        super.handleShellCloseEvent();
    }

    public ChooseUser(boolean switchWorkspace, Image wizardImage, boolean passwordRequired, boolean multiUser) {
        super(Display.getDefault().getActiveShell());
        this._switchWorkspace = switchWorkspace;
        this._passwordRequired = passwordRequired;
        this._multiUser = multiUser;
        if (wizardImage != null) {
            this.setTitleImage(wizardImage);
        }
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.ChooseUser_8);
    }

    protected Control createDialogArea(Composite parent) {
        this.setMessage(_StrMsg);
        try {
            this.outer = new Composite(parent, 0);
            GridLayout gridLayout = new GridLayout(2, false);
            gridLayout.verticalSpacing = 10;
            this.outer.setLayout((Layout)gridLayout);
            new FontData("Tahoma", 12, 1);
            new FontData("Tahoma", 13, 7);
            StyleRange style1 = new StyleRange();
            style1.underline = true;
            StyledText title = new StyledText(this.outer, 9);
            title.setFont(SWTResourceManager.getFont("Tahoma", 9, 1));
            title.setText(Messages.ChooseUser_11);
            title.setStyleRange(style1);
            title.setForeground(new Color(null, 239, 122, 16));
            title.setBackground(this.outer.getBackground());
            CLabel space = new CLabel(this.outer, 1);
            space.setText("");
            CLabel label = new CLabel(this.outer, 1);
            label.setForeground(new Color(null, 0, 69, 124));
            label.setFont(SWTResourceManager.getFont("Tahoma", 9, 1));
            label.setText(Messages.ChooseUser_15);
            GridData gridData = new GridData(256);
            gridData.widthHint = 128;
            this._userCombo = new Combo(this.outer, 2056);
            this._userCombo.setLayoutData((Object)gridData);
            this._userCombo.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    ChooseUser.this.username = ChooseUser.this._userCombo.getItem(ChooseUser.this._userCombo.getSelectionIndex());
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    ChooseUser.this.username = ChooseUser.this._userCombo.getItem(ChooseUser.this._userCombo.getSelectionIndex());
                }
            });
            Label labels = new Label(this.outer, 0);
            labels.setForeground(new Color(null, 0, 69, 124));
            labels.setText(Messages.ChooseUser_17);
            labels.setFont(SWTResourceManager.getFont("Tahoma", 9, 1));
            this.passwordField = new Text(this.outer, 0x400800);
            this.gridData_1 = new GridData(256);
            this.gridData_1.widthHint = 184;
            this.passwordField.setLayoutData((Object)this.gridData_1);
            this.passwordField.setFocus();
            if (!this._passwordRequired) {
                labels.setVisible(false);
                this.passwordField.setVisible(false);
            }
            this.passwordField.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent event) {
                    ChooseUser.this.password = ChooseUser.this.passwordField.getText().toCharArray();
                }
            });
            this._RememberWorkspaceButton = new Button(this.outer, 32);
            this._RememberWorkspaceButton.setText(Messages.ChooseUser_18);
            gridData = new GridData(256);
            gridData.horizontalSpan = 4;
            this._RememberWorkspaceButton.setLayoutData((Object)gridData);
            if (!this._multiUser) {
                this._RememberWorkspaceButton.setSelection(true);
                this._RememberWorkspaceButton.setVisible(false);
            } else {
                this._RememberWorkspaceButton.setVisible(false);
            }
            this.popolaComboUtenti();
            return this.outer;
        }
        catch (Exception err) {
            err.printStackTrace();
            return null;
        }
    }

    private void popolaComboUtenti() {
        try {
            DesktopDB prodottoDb = new DesktopDB();
            UtentiBean[] user = prodottoDb.selectUsers();
            ArrayList<String> utenti = new ArrayList<String>();
            if (this._userCombo.getItemCount() > 0) {
                this._userCombo.removeAll();
            }
            if (user.length > 0) {
                int i = 0;
                while (i < user.length) {
                    utenti.add(user[i].getNome());
                    ++i;
                }
                for (String last : utenti) {
                    this._userCombo.add(last);
                }
            } else {
                this._userCombo.setText("");
            }
        }
        catch (Exception err) {
            err.printStackTrace();
        }
    }

    public String getSelectedWorkspaceLocation() {
        return this._selectedWorkspaceRootLocation;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        if (this._multiUser || this._userCombo.getItemCount() == 0) {
            this.create = this.createButton(parent, 10, Messages.ChooseUser_20, false);
            this.create.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ChooseUser.this.createPressed();
                    ChooseUser.this.isCancelled = false;
                    ChooseUser.this.processCallbacks = false;
                }
            });
        }
        this.cambiaPsw = this.createButton(parent, 10, "Cambia Password", false);
        this.cambiaPsw.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ChooseUser.this.cambiaPswPressed();
                ChooseUser.this.isCancelled = false;
                ChooseUser.this.processCallbacks = false;
            }
        });
        this.login = this.createButton(parent, 2, Messages.ChooseUser_16, true);
        this.login.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ChooseUser.this.scegliUtente();
                ChooseUser.this.isCancelled = false;
                if (ChooseUser.this.flagPassword) {
                    ChooseUser.this.processCallbacks = true;
                } else {
                    ChooseUser.this.processCallbacks = false;
                }
            }
        });
        this.eliminaUtente = this.createButton(parent, 10, Messages.CancellaUtente_buttonLabel, false);
        this.eliminaUtente.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean esitoElimina = false;
                try {
                    esitoElimina = ChooseUser.this.eliminaUtentePressed();
                    if (esitoElimina) {
                        ChooseUser.this.setMessage(Messages.CancellaUtente_success, 1);
                        ChooseUser.this.passwordField.setText("");
                        ChooseUser.this.popolaComboUtenti();
                        ChooseUser.this.isCancelled = false;
                        ChooseUser.this.processCallbacks = false;
                    } else {
                        ChooseUser.this.setMessage(Messages.CancellaUtente_NoCancellato, 1);
                    }
                }
                catch (SQLException e1) {
                    MessageDialog.openError(null, (String)Messages.CancellaUtente_erroreTitolo, (String)Messages.CancellaUtente_errore);
                    e1.printStackTrace();
                }
                catch (IOException e1) {
                    MessageDialog.openError(null, (String)Messages.CancellaUtente_erroreTitolo, (String)Messages.CancellaUtente_erroreWS);
                    e1.printStackTrace();
                }
            }
        });
        Button cancel = this.createButton(parent, 1, Messages.ChooseUser_21, false);
        cancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ChooseUser.this.isCancelled = true;
                ChooseUser.this.processCallbacks = true;
            }
        });
    }

    protected void cambiaPswPressed() {
        String nome = this._userCombo.getText();
        if (nome == null || nome.equals("")) {
            this.setMessage(_StrError, 3);
            return;
        }
        try {
            UtentiBean utente = new UtentiBean();
            DesktopDB du = new DesktopDB();
            utente = du.getUtente(nome);
            CambiaPsw pwd = new CambiaPsw(utente, false, null, this._passwordRequired, this._multiUser);
            int pick = pwd.open();
            if (pick == 0) {
                this.setMessage(Messages.CambioPsw_OK, 1);
                pwd.close();
                this.cambiaPsw.setEnabled(true);
            } else {
                this.setMessage(Messages.ChooseUser_5, 3);
                this.cambiaPsw.setEnabled(true);
            }
        }
        catch (SQLException e) {
            MessageDialog.openError(null, (String)"Errore nella modifica della password", (String)"Si e' verificato un errore nella modifica della password");
            e.printStackTrace();
        }
    }

    protected boolean eliminaUtentePressed() throws SQLException, IOException {
        boolean esitoElimina = false;
        String nome = this._userCombo.getText();
        String passwordValue = this.passwordField.getText();
        if (nome == null || nome.equals("")) {
            this.setMessage(_StrError, 3);
            esitoElimina = false;
        } else {
            DesktopDB du = new DesktopDB();
            this.flagPassword = du.restituisciPassword(nome, passwordValue);
            if (this.flagPassword) {
                boolean confermaElimina = MessageDialog.openConfirm(null, (String)Messages.CancellaUtente_confermaTitle, (String)Messages.CancellaUtente_conferma);
                if (confermaElimina) {
                    try {
                        new UtentiBean();
                        du.cancellaUtente(nome);
                        du.cancellaRuoliUtente(nome);
                        MessageDialog.openInformation(null, (String)Messages.CancellaUtente_success, (String)Messages.CancellaUtente_success_detail);
                        esitoElimina = true;
                    }
                    catch (SQLException e) {
                        MessageDialog.openError(null, (String)Messages.CancellaUtente_erroreTitolo, (String)Messages.CancellaUtente_errore);
                        e.printStackTrace();
                        esitoElimina = false;
                    }
                } else {
                    esitoElimina = false;
                }
            } else {
                MessageDialog.openError(null, (String)Messages.CancellaUtente_passwordRequiredTitle, (String)Messages.CancellaUtente_passwordRequired);
                esitoElimina = false;
            }
        }
        return esitoElimina;
    }

    protected void createPressed() {
        UtentiBean utente = new UtentiBean();
        CreateUser pwd = new CreateUser(utente, false, null, this._passwordRequired, this._multiUser);
        this.create.setEnabled(false);
        int pick = pwd.open();
        if (pick == 0) {
            this.popolaComboUtenti();
            pwd.close();
            MessageDialog.openInformation(null, (String)Messages.CreateUser_31, (String)Messages.CreateUser_42);
            if (this._userCombo.getItemCount() == 0) {
                this.login.setEnabled(false);
            } else {
                this.login.setEnabled(true);
            }
        } else {
            this.setMessage(Messages.ChooseUser_5, 3);
            this.create.setEnabled(true);
        }
    }

    protected void scegliUtente() {
        String nome = this._userCombo.getText();
        String passwordValue = this.passwordField.getText();
        DesktopDB du = new DesktopDB();
        String str = null;
        try {
            this.flagPassword = du.restituisciPassword(nome, passwordValue);
            str = du.restituisciPath(nome);
        }
        catch (SQLException sQLException) {}
        if (str == null) {
            this.setMessage(_StrError, 3);
            return;
        }
        if (passwordValue.length() == 0 && this._passwordRequired) {
            this.flagPassword = false;
            this.setMessage(_StrErrorPassword, 3);
            return;
        }
        if (passwordValue.length() < 8 || passwordValue.length() > 15) {
            this.flagPassword = false;
            this.setMessage(Messages.CambiaPsw_Lenght, 3);
            return;
        }
        if (this.flagPassword) {
            String ret = ChooseUser.checkWorkspaceDirectory(this.getParentShell(), str, true, true);
            if (ret != null) {
                this.setMessage(ret, 3);
                return;
            }
            new StringBuffer();
            boolean ok = ChooseUser.checkAndCreateWorkspaceRoot(str);
            if (!ok) {
                this.setMessage(Messages.ChooseUser_22);
                return;
            }
            Location loc = Platform.getInstanceLocation();
            if (!loc.isSet()) {
                WorkSpaceUtil wsUtil = new WorkSpaceUtil();
                try {
                    wsUtil.CreateWorkspace(str);
                }
                catch (Exception exception) {
                    this.setMessage(Messages.ChooseUser_22);
                    return;
                }
            }
            this._selectedWorkspaceRootLocation = str;
            super.okPressed();
        } else if (!this.flagPassword) {
            this.setMessage(_StrErrorPasswordError, 3);
            return;
        }
    }

    public static String checkWorkspaceDirectory(Shell parentShell, String workspaceLocation, boolean askCreate, boolean fromDialog) {
        File f = new File(workspaceLocation);
        if (!f.exists()) {
            if (askCreate) {
                MessageDialog.openWarning((Shell)parentShell, (String)Messages.ChooseUser_23, (String)Messages.ChooseUser_24);
                try {
                    f.mkdirs();
                    File wsDot = new File(String.valueOf(workspaceLocation) + File.separator + WS_IDENTIFIER);
                    wsDot.createNewFile();
                }
                catch (Exception exception) {
                    return Messages.ChooseUser_25;
                }
                if (!f.exists()) {
                    return Messages.ChooseUser_26;
                }
            }
        } else {
            if (!f.canRead()) {
                return Messages.ChooseUser_27;
            }
            if (!f.isDirectory()) {
                return Messages.ChooseUser_28;
            }
        }
        File wsTest = new File(String.valueOf(workspaceLocation) + File.separator + WS_IDENTIFIER);
        if (fromDialog) {
            if (!wsTest.exists()) {
                try {
                    f.mkdirs();
                    File wsDot = new File(String.valueOf(workspaceLocation) + File.separator + WS_IDENTIFIER);
                    wsDot.createNewFile();
                }
                catch (Exception exception) {
                    return Messages.ChooseUser_29;
                }
                if (!wsTest.exists()) {
                    return Messages.ChooseUser_30;
                }
                return null;
            }
        } else if (!wsTest.exists()) {
            return Messages.ChooseUser_31;
        }
        return null;
    }

    public static boolean checkAndCreateWorkspaceRoot(String wsRoot) {
        block3: {
            try {
                File fRoot = new File(wsRoot);
                if (fRoot.exists()) break block3;
                return false;
            }
            catch (Exception err) {
                err.printStackTrace();
                return false;
            }
        }
        File dotFile = new File(String.valueOf(wsRoot) + File.separator + WS_IDENTIFIER);
        return dotFile.exists() || dotFile.createNewFile();
    }

    @Override
    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        this.callbackArray = callbacks;
        Display display = Display.getDefault();
        display.syncExec(new Runnable(){

            @Override
            public void run() {
                ChooseUser.this.isCancelled = false;
                ChooseUser.this.setBlockOnOpen(false);
                ChooseUser.this.open();
            }
        });
        try {
            ModalContext.run((IRunnableWithProgress)new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) {
                    while (!ChooseUser.this.processCallbacks) {
                        try {
                            Thread.sleep(100L);
                        }
                        catch (Exception exception) {}
                    }
                    ChooseUser.this.processCallbacks = false;
                    if (!ChooseUser.this.isCancelled()) {
                        ChooseUser.this.internalHandle();
                    }
                }
            }, (boolean)true, (IProgressMonitor)new NullProgressMonitor(), (Display)Display.getDefault());
        }
        catch (Exception e) {
            IOException ioe = new IOException();
            ioe.initCause(e);
            throw ioe;
        }
    }

    public void internalHandle() {
        Callback[] callbacks = this.getCallbacks();
        int i = 0;
        while (i < callbacks.length) {
            if (callbacks[i] instanceof NameCallback) {
                ((NameCallback)callbacks[i]).setName(this.username);
            } else if (callbacks[i] instanceof PasswordCallback) {
                ((PasswordCallback)callbacks[i]).setPassword(this.password);
            }
            ++i;
        }
    }

    public boolean isCancelled() {
        return this.isCancelled;
    }

    public Callback[] getCallbacks() {
        return this.callbackArray;
    }

    private void removeRecursive(Path path) throws IOException {
        Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Files.delete(file);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
                Files.delete(file);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                if (exc == null) {
                    Files.delete(dir);
                    return FileVisitResult.CONTINUE;
                }
                throw exc;
            }
        });
    }
}

