/*
 * Decompiled with CFR 0.152.
 */
package iaik.xml.crypto.xades.impl.dom.properties;

import iaik.xml.crypto.dom.DOMStructure;
import iaik.xml.crypto.utils.DOMUtils;
import iaik.xml.crypto.xades.OCSPIdentifier;
import iaik.xml.crypto.xades.ResponderID;
import iaik.xml.crypto.xades.dom.XadesDOMStructure;
import iaik.xml.crypto.xades.impl.dom.properties.ResponderIDImpl;
import java.text.ParseException;
import java.util.Date;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.dom.DOMCryptoContext;
import javax.xml.crypto.dom.DOMURIReference;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class OCSPIdentifierImpl
extends XadesDOMStructure
implements DOMURIReference,
OCSPIdentifier {
    private String a;
    private Date c;
    private ResponderIDImpl b;

    protected void unmarshalStructures(NodeList nodeList, DOMCryptoContext dOMCryptoContext) throws MarshalException {
        if (nodeList == null) {
            return;
        }
        int n = 0;
        while (n < nodeList.getLength()) {
            Node node = nodeList.item(n);
            if (node.getNodeType() == 1 && node.getNamespaceURI().equals("http://uri.etsi.org/01903/v1.3.2#")) {
                if (node.getLocalName().equals("ResponderID")) {
                    this.b = (ResponderIDImpl)DOMStructure.getInstance((Node)node, (DOMCryptoContext)dOMCryptoContext);
                } else if (node.getLocalName().equals("ProducedAt")) {
                    try {
                        this.c = DOMUtils.getDateTimeFromElementChildren((Element)((Element)node));
                    }
                    catch (ParseException parseException) {
                        throw new MarshalException("Failed to parse ProducedAt, " + parseException.getMessage(), parseException);
                    }
                }
            }
            ++n;
        }
    }

    protected void unmarshalAttributes(NamedNodeMap namedNodeMap, DOMCryptoContext dOMCryptoContext) throws MarshalException {
        Attr attr = (Attr)namedNodeMap.getNamedItemNS(null, "URI");
        this.a = attr != null ? attr.getValue() : null;
        super.unmarshalAttributes(namedNodeMap, dOMCryptoContext);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("    ResponderId : '" + this.b + "'\n");
        stringBuffer.append("    ProducedAt : " + this.c + "'\n");
        stringBuffer.append("    URI : " + this.a + "'\n");
        return stringBuffer.toString();
    }

    protected void marshalAttributes(DOMCryptoContext dOMCryptoContext, Element element) throws MarshalException {
        super.marshalAttributes(dOMCryptoContext, element);
        if (this.a != null) {
            Document document = DOMUtils.getOwnerDocument((Node)element);
            Attr attr = document.createAttributeNS("", "URI");
            attr.setValue(this.a);
            element.setAttributeNodeNS(attr);
        }
    }

    public Node marshal(DOMCryptoContext dOMCryptoContext, Node node, Node node2) throws MarshalException {
        Node node3 = super.marshal(dOMCryptoContext, node, node2);
        Document document = DOMUtils.getOwnerDocument((Node)node);
        String string = dOMCryptoContext.getNamespacePrefix("http://uri.etsi.org/01903/v1.3.2#", dOMCryptoContext.getDefaultNamespacePrefix());
        Node node4 = this.b.marshal(dOMCryptoContext, node, node2);
        Element element = document.createElementNS("http://uri.etsi.org/01903/v1.3.2#", DOMStructure.getQualifiedName((String)string, (String)"ProducedAt"));
        DOMUtils.addDateTimeToElement((Element)element, (Date)this.c);
        node3.appendChild(node4);
        node3.appendChild(element);
        return node3;
    }

    public String getURI() {
        return this.a;
    }

    public String getType() {
        return null;
    }

    public ResponderID getResponderId() {
        return this.b;
    }

    public Date getProducedAt() {
        return this.c;
    }

    public String getLocalName() {
        return "OCSPIdentifier";
    }

    public Node getHere() {
        return super.getHere();
    }

    public OCSPIdentifierImpl(byte[] byArray, Date date, String string) {
        if (byArray == null) {
            throw new NullPointerException("Argument 'publicKeyHash' must not be null");
        }
        this.b = new ResponderIDImpl(byArray);
        if (date == null) {
            throw new NullPointerException("Argument 'producedAt' must not be null");
        }
        this.c = date;
        this.a = string;
    }

    public OCSPIdentifierImpl(DOMCryptoContext dOMCryptoContext, Node node) throws MarshalException {
        super(node);
        if (dOMCryptoContext == null) {
            throw new NullPointerException("Argument 'context' must not be null");
        }
        this.unmarshal(dOMCryptoContext);
        if (this.b == null || this.c == null) {
            throw new MarshalException("The content of element '" + node + "' is not complete.");
        }
    }

    public OCSPIdentifierImpl(String string, Date date, String string2) {
        if (string == null) {
            throw new NullPointerException("Argument 'responderId' must not be null");
        }
        this.b = new ResponderIDImpl(string);
        if (date == null) {
            throw new NullPointerException("Argument 'producedAt' must not be null");
        }
        this.c = date;
        this.a = string2;
    }
}

