/*
 * Decompiled with CFR 0.152.
 */
package iaik.xml.crypto.xades.impl;

import iaik.asn1.CodingException;
import iaik.tsp.TimeStampReq;
import iaik.tsp.transport.tcpip.TspClientSocket;
import iaik.tsp.transport.tcpip.TspTcpIpFormatException;
import iaik.tsp.transport.tcpip.TspTcpIpResponse;
import iaik.xml.crypto.xades.impl.TSPTimeStampProcessor;
import iaik.xml.crypto.xades.timestamp.TimeStampException;
import iaik.xml.crypto.xades.timestamp.TimeStampProcessor;
import iaik.xml.crypto.xades.timestamp.TimeStampToken;
import iaik.xml.crypto.xades.timestamp.impl.TSPTimeStampTokenImpl;
import java.io.IOException;
import java.net.UnknownHostException;
import javax.xml.crypto.OctetStreamData;

public class TCPTSPTimeStampProcessor
extends TSPTimeStampProcessor
implements TimeStampProcessor {
    protected String host_;
    protected int port_;
    public static final int DEFAULT_TSP_TCP_PORT = 318;

    public TimeStampToken timeStamp(OctetStreamData octetStreamData) throws TimeStampException {
        TspTcpIpResponse tspTcpIpResponse;
        TspClientSocket tspClientSocket;
        if (octetStreamData == null) {
            throw new NullPointerException("Argument 'data' must not be null");
        }
        TimeStampReq timeStampReq = this.createTimeStampReq(this.calculateMessageImprint(octetStreamData));
        try {
            tspClientSocket = new TspClientSocket(this.host_, this.port_, 60000);
            tspTcpIpResponse = tspClientSocket.sendRequest(timeStampReq);
        }
        catch (UnknownHostException unknownHostException) {
            throw new TimeStampException("Failed to receive time-stamp, " + unknownHostException.getMessage());
        }
        catch (IOException iOException) {
            throw new TimeStampException("Failed to receive time-stamp, " + iOException.getMessage());
        }
        catch (CodingException codingException) {
            throw new TimeStampException("Failed to receive time-stamp, " + codingException.getMessage());
        }
        catch (TspTcpIpFormatException tspTcpIpFormatException) {
            throw new TimeStampException("Failed to receive time-stamp, " + tspTcpIpFormatException.getMessage());
        }
        if (tspTcpIpResponse.isErrorResponse()) {
            throw new TimeStampException("Failed to receive time-stamp, " + tspTcpIpResponse.getErrorMsg());
        }
        tspClientSocket = tspTcpIpResponse.getTimeStampResp();
        iaik.tsp.TimeStampToken timeStampToken = tspClientSocket.getTimeStampToken();
        if (timeStampToken == null) {
            throw new TimeStampException("Failed to receive time-stamp, " + tspClientSocket.getPKIStatusInfo().getPKIFailureInfo().getFailureInfo());
        }
        return new TSPTimeStampTokenImpl(timeStampToken);
    }

    public TCPTSPTimeStampProcessor(String string, int n) {
        this.host_ = string;
        this.port_ = n;
    }
}

