/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import java.sql.ResultSet;
import java.util.Properties;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.sql.execute.NoPutResultSet;
import org.apache.derby.iapi.types.SQLInteger;
import org.apache.derby.impl.sql.execute.DMLVTIResultSet;
import org.apache.derby.impl.sql.execute.TemporaryRowHolderImpl;
import org.apache.derby.impl.sql.execute.ValueRow;

class DeleteVTIResultSet
extends DMLVTIResultSet {
    private ResultSet rs;
    private TemporaryRowHolderImpl rowHolder;

    public DeleteVTIResultSet(NoPutResultSet noPutResultSet, Activation activation) throws StandardException {
        super(noPutResultSet, activation);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void openCore() throws StandardException {
        Object object;
        ExecRow execRow = this.getNextRowCore(this.sourceResultSet);
        if (execRow != null) {
            this.rs = this.activation.getTargetVTI();
        }
        if (this.constants.deferred) {
            this.activation.clearIndexScanInfo();
            if (null == this.rowHolder) {
                this.rowHolder = new TemporaryRowHolderImpl(this.activation, new Properties());
            }
        }
        try {
            while (execRow != null) {
                if (!this.constants.deferred) {
                    this.rs.deleteRow();
                } else {
                    object = new ValueRow(1);
                    object.setColumn(1, new SQLInteger(this.rs.getRow()));
                    this.rowHolder.insert((ExecRow)object);
                }
                ++this.rowCount;
                if (this.constants.singleRowSource) {
                    execRow = null;
                    continue;
                }
                execRow = this.getNextRowCore(this.sourceResultSet);
            }
        }
        catch (StandardException standardException) {
            throw standardException;
        }
        catch (Throwable throwable) {
            throw StandardException.unexpectedUserException(throwable);
        }
        if (this.constants.deferred) {
            object = this.rowHolder.getResultSet();
            try {
                try {
                    ExecRow execRow2 = null;
                    object.open();
                    while ((execRow2 = object.getNextRow()) != null) {
                        int n = execRow2.getColumn(1).getInt();
                        this.rs.absolute(n);
                        this.rs.deleteRow();
                    }
                    Object var6_8 = null;
                }
                catch (Throwable throwable) {
                    throw StandardException.unexpectedUserException(throwable);
                }
            }
            catch (Throwable throwable) {
                Object var6_9 = null;
                this.sourceResultSet.clearCurrentRow();
                object.close();
                throw throwable;
            }
            this.sourceResultSet.clearCurrentRow();
            object.close();
        }
        if (this.rowHolder != null) {
            this.rowHolder.close();
        }
    }
}

