/*
 * Decompiled with CFR 0.152.
 */
package finanze.IDTE.resources;

import finanze.IDTE.generale2005.CheckedBufferedReader;
import finanze.IDTE.generale2005.Util;
import java.io.IOException;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public abstract class ResourceLoader
implements Serializable {
    protected Object resourceData;
    protected boolean isKeyRequired;
    protected int numControlliRes = 0;
    public static final String RES_EXT = ".res";
    static /* synthetic */ Class class$0;

    protected ResourceLoader(Object resourceData) {
        if (resourceData instanceof Hashtable) {
            this.isKeyRequired = true;
        } else if (resourceData instanceof Vector) {
            this.isKeyRequired = false;
        } else {
            throw new IllegalArgumentException("Errore nel costruttore della classe '" + this.getClass().getName() + "': il tipo '" + resourceData.getClass().getName() + "' non \u00e8 un argomento valido");
        }
        this.resourceData = resourceData;
    }

    protected abstract Object createValue(String var1);

    public Enumeration elements() {
        return this.isKeyRequired ? ((Hashtable)this.resourceData).elements() : ((Vector)this.resourceData).elements();
    }

    protected Object getValue(String key) {
        return this.isKeyRequired ? ((Hashtable)this.resourceData).get(key) : null;
    }

    protected Object getValueAt(int dataIndex) {
        return this.isKeyRequired ? null : ((Vector)this.resourceData).elementAt(dataIndex);
    }

    public Enumeration keys() {
        return this.isKeyRequired ? ((Hashtable)this.resourceData).keys() : null;
    }

    public synchronized void load(String fileName) throws IOException, RuntimeException {
        boolean firstLine = false;
        this.numControlliRes = 0;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("finanze.IDTE.resources.ResourceLoader");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        CheckedBufferedReader ckReader = new CheckedBufferedReader(clazz.getResourceAsStream(fileName));
        try {
            String line;
            long resCode = this.readResourceCheckCode(ckReader);
            while ((line = ckReader.readLine()) != null) {
                if (ckReader.isCommentLine(line)) continue;
                if (!firstLine) {
                    this.numControlliRes = Util.contaCaratteri((String)line, (char)'*', (int)line.indexOf("=")) + 1;
                    firstLine = true;
                }
                this.loadData(line);
            }
        }
        catch (RuntimeException e) {
            throw new RuntimeException("Errore nella struttura del file " + fileName + ":\n" + e.getMessage());
        }
    }

    protected void loadData(String line) {
        int pos = line.indexOf(61);
        if (pos > 0) {
            ((Hashtable)this.resourceData).put(line.substring(0, pos).trim(), this.createValue(line.substring(pos + 1).trim()));
        } else {
            ((Vector)this.resourceData).addElement(this.createValue(line.trim()));
        }
    }

    private long readResourceCheckCode(CheckedBufferedReader ckReader) throws IOException {
        String line = ckReader.readLine();
        if (ckReader.isCommentLine(line)) {
            return Long.parseLong(line.substring(1).trim());
        }
        throw new RuntimeException("caratteri di controllo assenti");
    }
}

