/*
 * Decompiled with CFR 0.152.
 */
package finanze.IDTE.generale2006;

public class DataSogei {
    int fieldGiorno = 0;
    int fieldAnno = 0;
    int fieldMese = 0;
    boolean fieldOk = false;
    int fieldGiuliano = 0;
    boolean fieldBisestile = false;
    int[] gMesi = new int[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    int[] gMesiGiuliani;
    int fieldRc;
    String fieldDescrizione;
    private long fieldGiulianoAnno;
    public int MAX_ANNO;
    public int MIN_ANNO;

    public DataSogei(String data) {
        int[] nArray = new int[13];
        nArray[1] = 31;
        nArray[2] = 59;
        nArray[3] = 90;
        nArray[4] = 120;
        nArray[5] = 151;
        nArray[6] = 181;
        nArray[7] = 212;
        nArray[8] = 243;
        nArray[9] = 273;
        nArray[10] = 304;
        nArray[11] = 334;
        nArray[12] = 365;
        this.gMesiGiuliani = nArray;
        this.fieldRc = 0;
        this.fieldDescrizione = "";
        this.fieldGiulianoAnno = 0L;
        this.MAX_ANNO = 0;
        this.MIN_ANNO = 1870;
        try {
            String nome = this.getClass().getName();
            this.MAX_ANNO = Integer.parseInt(nome.substring(21, 25)) + 5;
            this.controllo(data);
        }
        catch (Exception e) {
            this.setOk(false);
            this.setRc(this.getRc() + 16);
            this.setDescrizione(String.valueOf(this.getDescrizione()) + "Errore eccezionale ");
        }
    }

    public DataSogei(String data, int minAnno, int maxAnno) {
        int[] nArray = new int[13];
        nArray[1] = 31;
        nArray[2] = 59;
        nArray[3] = 90;
        nArray[4] = 120;
        nArray[5] = 151;
        nArray[6] = 181;
        nArray[7] = 212;
        nArray[8] = 243;
        nArray[9] = 273;
        nArray[10] = 304;
        nArray[11] = 334;
        nArray[12] = 365;
        this.gMesiGiuliani = nArray;
        this.fieldRc = 0;
        this.fieldDescrizione = "";
        this.fieldGiulianoAnno = 0L;
        this.MAX_ANNO = 0;
        this.MIN_ANNO = 1870;
        try {
            this.MIN_ANNO = minAnno;
            this.MAX_ANNO = maxAnno;
            this.controllo(data);
        }
        catch (Exception e) {
            this.setOk(false);
            this.setRc(this.getRc() + 16);
            this.setDescrizione(String.valueOf(this.getDescrizione()) + "Errore eccezionale ");
        }
    }

    private void controllo(String data) {
        this.setOk(true);
        if (data.trim().length() != 6 && data.trim().length() != 8) {
            this.setOk(false);
            this.setRc(this.getRc() + 1);
            this.setDescrizione(String.valueOf(this.getDescrizione()) + "Formato errato ");
        } else {
            if (data.length() == 6) {
                this.setAnno(Integer.parseInt(data.substring(4, data.length())) + 1900);
            } else {
                this.setAnno(Integer.parseInt(data.substring(4, data.length())));
            }
            if (this.getAnno() < this.MIN_ANNO) {
                this.setOk(false);
                this.setRc(this.getRc() + 2);
                this.setDescrizione(String.valueOf(this.getDescrizione()) + "Anno antecedente al 1870 ");
            }
            if (this.getAnno() > this.MAX_ANNO) {
                this.setOk(false);
                this.setRc(this.getRc() + 2);
                this.setDescrizione(String.valueOf(this.getDescrizione()) + "Anno errato ");
            }
            this.setMese(Integer.parseInt(data.substring(2, 4)));
            this.setGiorno(Integer.parseInt(data.substring(0, 2)));
            if (this.getMese() > 12 || this.getMese() < 1) {
                this.setOk(false);
                this.setRc(this.getRc() + 4);
                this.setDescrizione(String.valueOf(this.getDescrizione()) + "Mese errato ");
            } else {
                this.setBisestile(false);
                if (this.getAnno() % 4 == 0) {
                    if (this.getAnno() % 100 == 0) {
                        if (this.getAnno() % 400 == 0) {
                            this.setBisestile(true);
                            this.gMesi[1] = this.gMesi[1] + 1;
                        }
                    } else {
                        this.setBisestile(true);
                        this.gMesi[1] = this.gMesi[1] + 1;
                    }
                }
                if (this.getGiorno() > this.gMesi[this.getMese() - 1] || this.getGiorno() < 1) {
                    this.setOk(false);
                    this.setRc(this.getRc() + 8);
                    this.setDescrizione(String.valueOf(this.getDescrizione()) + "Giorno errato ");
                }
                this.setGiuliano(this.gMesiGiuliani[this.getMese() - 1] + this.getGiorno());
                if (this.getMese() > 2 && this.getBisestile()) {
                    this.setGiuliano(this.getGiuliano() + 1);
                }
                int anniDif = this.fieldAnno - 1941;
                this.fieldGiulianoAnno = (long)((double)anniDif * 365.25) + (long)this.fieldGiuliano;
            }
        }
    }

    public int getAnno() {
        return this.fieldAnno;
    }

    public boolean getBisestile() {
        return this.fieldBisestile;
    }

    public String getDescrizione() {
        if (this.fieldDescrizione == null) {
            try {
                this.fieldDescrizione = new String();
            }
            catch (Throwable exception) {
                System.err.println("Exception creating descrizioneproperty.");
            }
        }
        return this.fieldDescrizione;
    }

    public int getGiorno() {
        return this.fieldGiorno;
    }

    public int getGiuliano() {
        return this.fieldGiuliano;
    }

    public long getGiulianoAnno() {
        return this.fieldGiulianoAnno;
    }

    public int getMese() {
        return this.fieldMese;
    }

    public boolean getOk() {
        return this.fieldOk;
    }

    public int getRc() {
        return this.fieldRc;
    }

    public void setAnno(int anno) {
        this.fieldAnno = anno;
    }

    public void setBisestile(boolean bisestile) {
        this.fieldBisestile = bisestile;
    }

    public void setDescrizione(String descrizione) {
        this.fieldDescrizione = descrizione;
    }

    public void setGiorno(int giorno) {
        this.fieldGiorno = giorno;
    }

    public void setGiuliano(int giuliano) {
        this.fieldGiuliano = giuliano;
    }

    public void setMese(int mese) {
        this.fieldMese = mese;
    }

    public void setOk(boolean ok) {
        this.fieldOk = ok;
    }

    public void setRc(int rc) {
        this.fieldRc = rc;
    }
}

