/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jfxmediaimpl.platform;

import com.sun.media.jfxmedia.Media;
import com.sun.media.jfxmedia.MediaPlayer;
import com.sun.media.jfxmedia.MetadataParser;
import com.sun.media.jfxmedia.locator.Locator;
import com.sun.media.jfxmedia.logging.Logger;
import com.sun.media.jfxmediaimpl.HostUtils;
import com.sun.media.jfxmediaimpl.platform.Platform;
import com.sun.media.jfxmediaimpl.platform.gstreamer.GSTPlatform;
import com.sun.media.jfxmediaimpl.platform.java.JavaPlatform;
import com.sun.media.jfxmediaimpl.platform.osx.OSXPlatform;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PlatformManager {
    private static String enabledPlatforms;
    private final List<Platform> platforms = new ArrayList<Platform>();

    private static void getPlatformSettings() {
        enabledPlatforms = System.getProperty("jfxmedia.platforms", "").toLowerCase();
    }

    private static boolean isPlatformEnabled(String name) {
        if (null == enabledPlatforms || enabledPlatforms.length() == 0) {
            return true;
        }
        return enabledPlatforms.indexOf(name.toLowerCase()) != -1;
    }

    public static PlatformManager getManager() {
        return PlatformManagerInitializer.globalInstance;
    }

    private PlatformManager() {
        Platform platty;
        if (PlatformManager.isPlatformEnabled("JavaPlatform") && null != (platty = JavaPlatform.getPlatformInstance())) {
            this.platforms.add(platty);
        }
        if (PlatformManager.isPlatformEnabled("GSTPlatform") && null != (platty = GSTPlatform.getPlatformInstance())) {
            this.platforms.add(platty);
        }
        if (HostUtils.isMacOSX() && PlatformManager.isPlatformEnabled("OSXPlatform") && null != (platty = OSXPlatform.getPlatformInstance())) {
            this.platforms.add(platty);
        }
        if (Logger.canLog(1)) {
            StringBuilder sb = new StringBuilder("Enabled JFXMedia platforms: ");
            for (Platform p : this.platforms) {
                sb.append("\n   - ");
                sb.append(p.getClass().getName());
            }
            Logger.logMsg(1, sb.toString());
        }
    }

    public synchronized void preloadPlatforms() {
        for (Platform platty : this.platforms) {
            platty.preloadPlatform();
        }
    }

    public synchronized void loadPlatforms() {
        Iterator<Platform> iter = this.platforms.iterator();
        while (iter.hasNext()) {
            Platform platty = iter.next();
            if (platty.loadPlatform()) continue;
            if (Logger.canLog(1)) {
                Logger.logMsg(1, "Failed to load platform: " + platty);
            }
            iter.remove();
        }
    }

    public List<String> getSupportedContentTypes() {
        ArrayList<String> outTypes = new ArrayList<String>();
        if (!this.platforms.isEmpty()) {
            for (Platform platty : this.platforms) {
                String[] npt = platty.getSupportedContentTypes();
                if (npt == null) continue;
                for (String type : npt) {
                    if (outTypes.contains(type)) continue;
                    outTypes.add(type);
                }
            }
        }
        return outTypes;
    }

    public MetadataParser createMetadataParser(Locator source) {
        for (Platform platty : this.platforms) {
            MetadataParser parser = platty.createMetadataParser(source);
            if (parser == null) continue;
            return parser;
        }
        return null;
    }

    public Media createMedia(Locator source) {
        String mimeType = source.getContentType();
        for (Platform platty : this.platforms) {
            Media outMedia;
            if (!platty.canPlayContentType(mimeType) || null == (outMedia = platty.createMedia(source))) continue;
            return outMedia;
        }
        return null;
    }

    public MediaPlayer createMediaPlayer(Locator source) {
        String mimeType = source.getContentType();
        for (Platform platty : this.platforms) {
            MediaPlayer outPlayer;
            Object cookie;
            if (!platty.canPlayContentType(mimeType) || null == (cookie = platty.prerollMediaPlayer(source)) || null == (outPlayer = platty.createMediaPlayer(source, cookie))) continue;
            return outPlayer;
        }
        return null;
    }

    static {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                PlatformManager.getPlatformSettings();
                return null;
            }
        });
    }

    private static final class PlatformManagerInitializer {
        private static final PlatformManager globalInstance = new PlatformManager();

        private PlatformManagerInitializer() {
        }
    }
}

