/*
 * Decompiled with CFR 0.152.
 */
package iaik.xml.crypto.xades.impl.dom.properties;

import iaik.xml.crypto.dom.DOMStructure;
import iaik.xml.crypto.dsig.DigestMethodImpl;
import iaik.xml.crypto.dsig.TransformsImpl;
import iaik.xml.crypto.utils.DOMUtils;
import iaik.xml.crypto.utils.URIDereferencerImpl;
import iaik.xml.crypto.xades.DigestAlgAndValue;
import iaik.xml.crypto.xades.ObjectIdentifier;
import iaik.xml.crypto.xades.SPURI;
import iaik.xml.crypto.xades.SigPolicyQualifier;
import iaik.xml.crypto.xades.SignaturePolicyId;
import iaik.xml.crypto.xades.dom.XadesDOMStructure;
import iaik.xml.crypto.xades.impl.dom.properties.IdentifierImpl;
import iaik.xml.crypto.xades.impl.dom.properties.ObjectIdentifierImpl;
import iaik.xml.crypto.xades.impl.dom.properties.SPURIImpl;
import iaik.xml.crypto.xades.impl.dom.properties.SigPolicyHashImpl;
import iaik.xml.crypto.xades.impl.dom.properties.SigPolicyQualifiersListImpl;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.xml.crypto.Data;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.OctetStreamData;
import javax.xml.crypto.URIDereferencer;
import javax.xml.crypto.URIReferenceException;
import javax.xml.crypto.XMLCryptoContext;
import javax.xml.crypto.dom.DOMCryptoContext;
import javax.xml.crypto.dsig.TransformException;
import javax.xml.crypto.dsig.TransformService;
import javax.xml.crypto.dsig.XMLSignatureException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SignaturePolicyIdImpl
extends XadesDOMStructure
implements SignaturePolicyId {
    private byte[] f;
    private Data e;
    private SigPolicyQualifiersListImpl b;
    private SigPolicyHashImpl d;
    private TransformsImpl a;
    private ObjectIdentifierImpl c;

    public boolean validate(XMLCryptoContext xMLCryptoContext, Data data) throws XMLSignatureException {
        if (data != null || this.f == null) {
            List list = DOMUtils.distributeNSDeclarations((Element)((Element)this.getNode()));
            if (data == null && (data = this.dereferenceSPURIs(xMLCryptoContext)) == null) {
                throw new XMLSignatureException("Failed to validate signature policy hash. Could not dereference any SPURI.");
            }
            try {
                if (this.a != null) {
                    data = this.a.applyTransforms(xMLCryptoContext, data);
                }
                if (!(data instanceof OctetStreamData)) {
                    TransformService transformService = TransformService.getInstance("http://www.w3.org/TR/2001/REC-xml-c14n-20010315", "DOM");
                    data = transformService.transform(data, xMLCryptoContext);
                }
                this.f = this.d.calculateDigestValue(((OctetStreamData)data).getOctetStream(), xMLCryptoContext);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new XMLSignatureException(noSuchAlgorithmException);
            }
            catch (TransformException transformException) {
                throw new XMLSignatureException(transformException);
            }
            catch (IOException iOException) {
                throw new XMLSignatureException(iOException);
            }
            DOMUtils.withdrawDistributedNSDeclarations((Element)((Element)this.getNode()), (List)list);
        }
        return this.d.getDigestValue() != null ? Arrays.equals(this.d.getDigestValue(), this.f) : false;
    }

    protected void putChildStructure(DOMStructure dOMStructure) throws MarshalException {
        super.putChildStructure(dOMStructure);
        if (dOMStructure instanceof ObjectIdentifierImpl) {
            this.c = (ObjectIdentifierImpl)dOMStructure;
            return;
        }
        if (dOMStructure instanceof TransformsImpl) {
            this.a = (TransformsImpl)dOMStructure;
            return;
        }
        if (dOMStructure instanceof SigPolicyHashImpl) {
            this.d = (SigPolicyHashImpl)dOMStructure;
            return;
        }
        if (dOMStructure instanceof SigPolicyQualifiersListImpl) {
            this.b = (SigPolicyQualifiersListImpl)dOMStructure;
        }
    }

    public Node marshal(DOMCryptoContext dOMCryptoContext, Node node, Node node2) throws MarshalException {
        Node node3 = super.marshal(dOMCryptoContext, node, node2);
        if (this.d.getDigestValue() == null) {
            try {
                Object object;
                if (this.e == null) {
                    object = null;
                    URIDereferencer uRIDereferencer = dOMCryptoContext.getURIDereferencer() != null ? dOMCryptoContext.getURIDereferencer() : new URIDereferencerImpl();
                    try {
                        object = uRIDereferencer.dereference((IdentifierImpl)this.c.getIdentifier(), dOMCryptoContext);
                    }
                    catch (URIReferenceException uRIReferenceException) {}
                    if (object == null) {
                        object = this.dereferenceSPURIs(dOMCryptoContext);
                    }
                    if (object == null) {
                        throw new MarshalException("Failed to calculate signature policy hash. Could not dereference any SPURI(s).");
                    }
                    if (this.a != null) {
                        object = this.a.applyTransforms((XMLCryptoContext)dOMCryptoContext, (Data)object);
                    }
                    this.e = object;
                }
                if (!(this.e instanceof OctetStreamData)) {
                    object = TransformService.getInstance("http://www.w3.org/TR/2001/REC-xml-c14n-20010315", "DOM");
                    this.e = object.transform(this.e, dOMCryptoContext);
                }
                this.d.calculateAndAppendDigestValue(dOMCryptoContext, ((OctetStreamData)this.e).getOctetStream());
            }
            catch (XMLSignatureException xMLSignatureException) {
                throw new MarshalException("Failed to calculate signature policy hash. " + xMLSignatureException.getMessage(), xMLSignatureException);
            }
            catch (TransformException transformException) {
                throw new MarshalException("Failed to calculate signature policy hash. " + transformException.getMessage(), transformException);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new MarshalException("Failed to calculate signature policy hash. " + noSuchAlgorithmException.getMessage(), noSuchAlgorithmException);
            }
            catch (MarshalException marshalException) {
                throw new MarshalException("Failed to calculate signature policy hash. " + marshalException.getMessage(), marshalException);
            }
            catch (IOException iOException) {
                throw new MarshalException("Failed to calculate signature policy hash. " + iOException.getMessage(), iOException);
            }
        }
        return node3;
    }

    public List getTransforms() {
        return this.a != null ? this.a.getTransforms() : Collections.unmodifiableList(new ArrayList(0));
    }

    public List getSignaturePolicyQualifiers() {
        return this.b != null ? this.b.getSigPolicyQualifiers() : Collections.unmodifiableList(new ArrayList());
    }

    public ObjectIdentifier getSigPolicyId() {
        return this.c;
    }

    public DigestAlgAndValue getSigPolicyHash() {
        return this.d;
    }

    public String getLocalName() {
        return "SignaturePolicyId";
    }

    protected List getChildStructures() {
        List list = super.getChildStructures();
        list.add(this.c);
        if (this.a != null) {
            list.add(this.a);
        }
        if (this.d != null) {
            list.add(this.d);
        }
        if (this.b != null) {
            list.add(this.b);
        }
        return list;
    }

    protected Data dereferenceSPURIs(XMLCryptoContext xMLCryptoContext) throws XMLSignatureException {
        Iterator iterator;
        Object object;
        Object object2;
        if (this.b == null) {
            return null;
        }
        ArrayList arrayList = new ArrayList();
        Iterator iterator2 = this.b.getSigPolicyQualifiers().iterator();
        while (iterator2.hasNext()) {
            object2 = iterator2.next();
            if (!(object2 instanceof SigPolicyQualifier)) continue;
            object = ((SigPolicyQualifier)object2).getContent().iterator();
            while (object.hasNext()) {
                iterator = object.next();
                if (!(iterator instanceof SPURI)) continue;
                arrayList.add(iterator);
            }
        }
        if (arrayList.isEmpty()) {
            return null;
        }
        URIDereferencer uRIDereferencer = object2 = xMLCryptoContext.getURIDereferencer() != null ? xMLCryptoContext.getURIDereferencer() : new URIDereferencerImpl();
        if (object2 == null) {
            throw new XMLSignatureException("No URIDereferencer set in provider");
        }
        object = null;
        iterator = arrayList.iterator();
        while (iterator.hasNext() && object == null) {
            SPURIImpl sPURIImpl = (SPURIImpl)iterator.next();
            try {
                object = object2.dereference(sPURIImpl, xMLCryptoContext);
            }
            catch (URIReferenceException uRIReferenceException) {}
        }
        return object;
    }

    public SignaturePolicyIdImpl(DOMCryptoContext dOMCryptoContext, Node node) throws MarshalException {
        super(node);
        if (dOMCryptoContext == null) {
            throw new NullPointerException("Argument 'context' must not be null");
        }
        this.unmarshal(dOMCryptoContext);
        if (this.c == null || this.d == null) {
            throw new MarshalException("The content of element '" + node + "' is not complete.");
        }
    }

    public SignaturePolicyIdImpl(ObjectIdentifierImpl objectIdentifierImpl, List list, SigPolicyHashImpl sigPolicyHashImpl, List list2) {
        if (objectIdentifierImpl == null) {
            throw new NullPointerException("Argument 'sigPolicyId' must not be null.");
        }
        this.c = objectIdentifierImpl;
        this.c.setLocalName("SigPolicyId");
        if (list != null && !list.isEmpty()) {
            this.a = new TransformsImpl(list);
        }
        if (sigPolicyHashImpl == null) {
            throw new NullPointerException("Argument 'sigPolicyHash' must not be null.");
        }
        this.d = sigPolicyHashImpl;
        if (list2 != null && !list2.isEmpty()) {
            this.b = new SigPolicyQualifiersListImpl(list2);
        }
    }

    public SignaturePolicyIdImpl(ObjectIdentifierImpl objectIdentifierImpl, List list, DigestMethodImpl digestMethodImpl, Data data, List list2) {
        if (objectIdentifierImpl == null) {
            throw new NullPointerException("Argument 'sigPolicyId' must not be null");
        }
        this.c = objectIdentifierImpl;
        this.c.setLocalName("SigPolicyId");
        if (list != null && !list.isEmpty()) {
            this.a = new TransformsImpl(list);
        }
        if (digestMethodImpl == null) {
            throw new NullPointerException("Argument 'digestMethod' must not be null");
        }
        this.d = new SigPolicyHashImpl(digestMethodImpl);
        this.e = data;
        if (list2 != null && !list2.isEmpty()) {
            this.b = new SigPolicyQualifiersListImpl(list2);
        }
    }
}

