/*
 * Decompiled with CFR 0.152.
 */
package sun.font;

import java.awt.Font;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.Locale;
import java.util.concurrent.ConcurrentHashMap;
import sun.font.CharToGlyphMapper;
import sun.font.Font2DHandle;
import sun.font.FontFamily;
import sun.font.FontStrike;
import sun.font.FontStrikeDesc;
import sun.font.StrikeCache;
import sun.font.StrikeMetrics;

public abstract class Font2D {
    public static final int FONT_CONFIG_RANK = 2;
    public static final int JRE_RANK = 2;
    public static final int TTF_RANK = 3;
    public static final int TYPE1_RANK = 4;
    public static final int NATIVE_RANK = 5;
    public static final int UNKNOWN_RANK = 6;
    public static final int DEFAULT_RANK = 4;
    private static final String[] boldNames = new String[]{"bold", "demibold", "demi-bold", "demi bold", "negreta", "demi"};
    private static final String[] italicNames = new String[]{"italic", "cursiva", "oblique", "inclined"};
    private static final String[] boldItalicNames = new String[]{"bolditalic", "bold-italic", "bold italic", "boldoblique", "bold-oblique", "bold oblique", "demibold italic", "negreta cursiva", "demi oblique"};
    private static final FontRenderContext DEFAULT_FRC = new FontRenderContext(null, false, false);
    public Font2DHandle handle;
    protected String familyName;
    protected String fullName;
    protected int style = 0;
    protected FontFamily family;
    protected int fontRank = 4;
    protected CharToGlyphMapper mapper;
    protected ConcurrentHashMap<FontStrikeDesc, Reference> strikeCache = new ConcurrentHashMap();
    protected Reference lastFontStrike = new SoftReference<Object>(null);

    public int getStyle() {
        return this.style;
    }

    protected void setStyle() {
        int n;
        String string = this.fullName.toLowerCase();
        for (n = 0; n < boldItalicNames.length; ++n) {
            if (string.indexOf(boldItalicNames[n]) == -1) continue;
            this.style = 3;
            return;
        }
        for (n = 0; n < italicNames.length; ++n) {
            if (string.indexOf(italicNames[n]) == -1) continue;
            this.style = 2;
            return;
        }
        for (n = 0; n < boldNames.length; ++n) {
            if (string.indexOf(boldNames[n]) == -1) continue;
            this.style = 1;
            return;
        }
    }

    int getRank() {
        return this.fontRank;
    }

    void setRank(int n) {
        this.fontRank = n;
    }

    abstract CharToGlyphMapper getMapper();

    protected int getValidatedGlyphCode(int n) {
        if (n < 0 || n >= this.getMapper().getNumGlyphs()) {
            n = this.getMapper().getMissingGlyphCode();
        }
        return n;
    }

    abstract FontStrike createStrike(FontStrikeDesc var1);

    public FontStrike getStrike(Font font) {
        FontStrike fontStrike = (FontStrike)this.lastFontStrike.get();
        if (fontStrike != null) {
            return fontStrike;
        }
        return this.getStrike(font, DEFAULT_FRC);
    }

    public FontStrike getStrike(Font font, AffineTransform affineTransform, int n, int n2) {
        double d = font.getSize2D();
        AffineTransform affineTransform2 = (AffineTransform)affineTransform.clone();
        affineTransform2.scale(d, d);
        if (font.isTransformed()) {
            affineTransform2.concatenate(font.getTransform());
        }
        if (affineTransform2.getTranslateX() != 0.0 || affineTransform2.getTranslateY() != 0.0) {
            affineTransform2.setTransform(affineTransform2.getScaleX(), affineTransform2.getShearY(), affineTransform2.getShearX(), affineTransform2.getScaleY(), 0.0, 0.0);
        }
        FontStrikeDesc fontStrikeDesc = new FontStrikeDesc(affineTransform, affineTransform2, font.getStyle(), n, n2);
        return this.getStrike(fontStrikeDesc, false);
    }

    public FontStrike getStrike(Font font, AffineTransform affineTransform, AffineTransform affineTransform2, int n, int n2) {
        FontStrikeDesc fontStrikeDesc = new FontStrikeDesc(affineTransform, affineTransform2, font.getStyle(), n, n2);
        return this.getStrike(fontStrikeDesc, false);
    }

    public FontStrike getStrike(Font font, FontRenderContext fontRenderContext) {
        AffineTransform affineTransform = fontRenderContext.getTransform();
        double d = font.getSize2D();
        affineTransform.scale(d, d);
        if (font.isTransformed()) {
            affineTransform.concatenate(font.getTransform());
            if (affineTransform.getTranslateX() != 0.0 || affineTransform.getTranslateY() != 0.0) {
                affineTransform.setTransform(affineTransform.getScaleX(), affineTransform.getShearY(), affineTransform.getShearX(), affineTransform.getScaleY(), 0.0, 0.0);
            }
        }
        int n = FontStrikeDesc.getAAHintIntVal(this, font, fontRenderContext);
        int n2 = FontStrikeDesc.getFMHintIntVal(fontRenderContext.getFractionalMetricsHint());
        FontStrikeDesc fontStrikeDesc = new FontStrikeDesc(fontRenderContext.getTransform(), affineTransform, font.getStyle(), n, n2);
        return this.getStrike(fontStrikeDesc, false);
    }

    FontStrike getStrike(FontStrikeDesc fontStrikeDesc) {
        return this.getStrike(fontStrikeDesc, true);
    }

    private FontStrike getStrike(FontStrikeDesc fontStrikeDesc, boolean bl) {
        FontStrike fontStrike = (FontStrike)this.lastFontStrike.get();
        if (fontStrike != null && fontStrikeDesc.equals(fontStrike.desc)) {
            return fontStrike;
        }
        Reference reference = this.strikeCache.get(fontStrikeDesc);
        if (reference != null && (fontStrike = (FontStrike)reference.get()) != null) {
            this.lastFontStrike = new SoftReference<FontStrike>(fontStrike);
            StrikeCache.refStrike(fontStrike);
            return fontStrike;
        }
        if (bl) {
            fontStrikeDesc = new FontStrikeDesc(fontStrikeDesc);
        }
        fontStrike = this.createStrike(fontStrikeDesc);
        int n = fontStrikeDesc.glyphTx.getType();
        reference = n == 32 || (n & 0x10) != 0 && this.strikeCache.size() > 10 ? StrikeCache.getStrikeRef(fontStrike, true) : StrikeCache.getStrikeRef(fontStrike);
        this.strikeCache.put(fontStrikeDesc, reference);
        this.lastFontStrike = new SoftReference<FontStrike>(fontStrike);
        StrikeCache.refStrike(fontStrike);
        return fontStrike;
    }

    void removeFromCache(FontStrikeDesc fontStrikeDesc) {
        Object t;
        Reference reference = this.strikeCache.get(fontStrikeDesc);
        if (reference != null && (t = reference.get()) == null) {
            this.strikeCache.remove(fontStrikeDesc);
        }
    }

    public void getFontMetrics(Font font, AffineTransform affineTransform, Object object, Object object2, float[] fArray) {
        int n = FontStrikeDesc.getAAHintIntVal(object, this, font.getSize());
        int n2 = FontStrikeDesc.getFMHintIntVal(object2);
        FontStrike fontStrike = this.getStrike(font, affineTransform, n, n2);
        StrikeMetrics strikeMetrics = fontStrike.getFontMetrics();
        fArray[0] = strikeMetrics.getAscent();
        fArray[1] = strikeMetrics.getDescent();
        fArray[2] = strikeMetrics.getLeading();
        fArray[3] = strikeMetrics.getMaxAdvance();
        this.getStyleMetrics(font.getSize2D(), fArray, 4);
    }

    public void getStyleMetrics(float f, float[] fArray, int n) {
        fArray[n] = -fArray[0] / 2.5f;
        fArray[n + 1] = f / 12.0f;
        fArray[n + 2] = fArray[n + 1] / 1.5f;
        fArray[n + 3] = fArray[n + 1];
    }

    public void getFontMetrics(Font font, FontRenderContext fontRenderContext, float[] fArray) {
        StrikeMetrics strikeMetrics = this.getStrike(font, fontRenderContext).getFontMetrics();
        fArray[0] = strikeMetrics.getAscent();
        fArray[1] = strikeMetrics.getDescent();
        fArray[2] = strikeMetrics.getLeading();
        fArray[3] = strikeMetrics.getMaxAdvance();
    }

    byte[] getTableBytes(int n) {
        return null;
    }

    protected long getUnitsPerEm() {
        return 2048L;
    }

    boolean supportsEncoding(String string) {
        return false;
    }

    public boolean canDoStyle(int n) {
        return n == this.style;
    }

    public boolean useAAForPtSize(int n) {
        return true;
    }

    public boolean hasSupplementaryChars() {
        return false;
    }

    public String getPostscriptName() {
        return this.fullName;
    }

    public String getFontName(Locale locale) {
        return this.fullName;
    }

    public String getFamilyName(Locale locale) {
        return this.familyName;
    }

    public int getNumGlyphs() {
        return this.getMapper().getNumGlyphs();
    }

    public int charToGlyph(int n) {
        return this.getMapper().charToGlyph(n);
    }

    public int getMissingGlyphCode() {
        return this.getMapper().getMissingGlyphCode();
    }

    public boolean canDisplay(char c) {
        return this.getMapper().canDisplay(c);
    }

    public boolean canDisplay(int n) {
        return this.getMapper().canDisplay(n);
    }

    public byte getBaselineFor(char c) {
        return 0;
    }

    public float getItalicAngle(Font font, AffineTransform affineTransform, Object object, Object object2) {
        int n = FontStrikeDesc.getAAHintIntVal(object, this, 12);
        int n2 = FontStrikeDesc.getFMHintIntVal(object2);
        FontStrike fontStrike = this.getStrike(font, affineTransform, n, n2);
        StrikeMetrics strikeMetrics = fontStrike.getFontMetrics();
        if (strikeMetrics.ascentY == 0.0f || strikeMetrics.ascentX == 0.0f) {
            return 0.0f;
        }
        return strikeMetrics.ascentX / -strikeMetrics.ascentY;
    }
}

