/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.policy;

import com.sun.xml.internal.ws.policy.Policy;
import com.sun.xml.internal.ws.policy.PolicyException;
import com.sun.xml.internal.ws.policy.PolicyMerger;
import com.sun.xml.internal.ws.policy.PolicySubject;
import com.sun.xml.internal.ws.policy.privateutil.LocalizationMessages;
import com.sun.xml.internal.ws.policy.privateutil.PolicyLogger;
import com.sun.xml.internal.ws.policy.privateutil.PolicyUtils;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;

final class PolicyScope {
    private static final PolicyLogger LOGGER = PolicyLogger.getLogger(PolicyScope.class);
    private final List<PolicySubject> subjects = new LinkedList<PolicySubject>();

    PolicyScope(List<PolicySubject> list) {
        if (list != null && !list.isEmpty()) {
            this.subjects.addAll(list);
        }
    }

    void attach(PolicySubject policySubject) {
        if (policySubject == null) {
            throw LOGGER.logSevereException(new IllegalArgumentException(LocalizationMessages.WSP_0020_SUBJECT_PARAM_MUST_NOT_BE_NULL()));
        }
        this.subjects.add(policySubject);
    }

    void dettachAllSubjects() {
        this.subjects.clear();
    }

    Policy getEffectivePolicy(PolicyMerger policyMerger) throws PolicyException {
        LinkedList<Policy> linkedList = new LinkedList<Policy>();
        for (PolicySubject policySubject : this.subjects) {
            linkedList.add(policySubject.getEffectivePolicy(policyMerger));
        }
        return policyMerger.merge(linkedList);
    }

    Collection<PolicySubject> getPolicySubjects() {
        return this.subjects;
    }

    public String toString() {
        return this.toString(0, new StringBuffer()).toString();
    }

    StringBuffer toString(int n, StringBuffer stringBuffer) {
        String string = PolicyUtils.Text.createIndent(n);
        stringBuffer.append(string).append("policy scope {").append(PolicyUtils.Text.NEW_LINE);
        for (PolicySubject policySubject : this.subjects) {
            policySubject.toString(n + 1, stringBuffer).append(PolicyUtils.Text.NEW_LINE);
        }
        stringBuffer.append(string).append('}');
        return stringBuffer;
    }
}

