/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.model.wsdl;

import com.sun.istack.internal.NotNull;
import com.sun.istack.internal.Nullable;
import com.sun.xml.internal.ws.api.model.wsdl.WSDLPort;
import com.sun.xml.internal.ws.api.model.wsdl.WSDLService;
import com.sun.xml.internal.ws.model.wsdl.AbstractExtensibleImpl;
import com.sun.xml.internal.ws.model.wsdl.WSDLModelImpl;
import com.sun.xml.internal.ws.model.wsdl.WSDLPortImpl;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamReader;

public final class WSDLServiceImpl
extends AbstractExtensibleImpl
implements WSDLService {
    private final QName name;
    private final Map<QName, WSDLPortImpl> ports;
    private final WSDLModelImpl parent;

    public WSDLServiceImpl(XMLStreamReader xMLStreamReader, WSDLModelImpl wSDLModelImpl, QName qName) {
        super(xMLStreamReader);
        this.parent = wSDLModelImpl;
        this.name = qName;
        this.ports = new LinkedHashMap<QName, WSDLPortImpl>();
    }

    @Override
    @NotNull
    public WSDLModelImpl getParent() {
        return this.parent;
    }

    @Override
    public QName getName() {
        return this.name;
    }

    @Override
    public WSDLPortImpl get(QName qName) {
        return this.ports.get(qName);
    }

    @Override
    public WSDLPort getFirstPort() {
        if (this.ports.isEmpty()) {
            return null;
        }
        return this.ports.values().iterator().next();
    }

    public Iterable<WSDLPortImpl> getPorts() {
        return this.ports.values();
    }

    @Nullable
    public WSDLPortImpl getMatchingPort(QName qName) {
        for (WSDLPortImpl wSDLPortImpl : this.getPorts()) {
            QName qName2 = wSDLPortImpl.getBinding().getPortTypeName();
            assert (qName2 != null);
            if (!qName2.equals(qName)) continue;
            return wSDLPortImpl;
        }
        return null;
    }

    public void put(QName qName, WSDLPortImpl wSDLPortImpl) {
        if (qName == null || wSDLPortImpl == null) {
            throw new NullPointerException();
        }
        this.ports.put(qName, wSDLPortImpl);
    }

    void freeze(WSDLModelImpl wSDLModelImpl) {
        for (WSDLPortImpl wSDLPortImpl : this.ports.values()) {
            wSDLPortImpl.freeze(wSDLModelImpl);
        }
    }
}

