/*
 * Decompiled with CFR 0.152.
 */
package com.sun.servicetag;

import com.sun.servicetag.Util;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;

class BrowserSupport {
    private static boolean isBrowseSupported = false;
    private static Method browseMethod = null;
    private static Object desktop = null;
    private static volatile Boolean result = false;

    BrowserSupport() {
    }

    private static void initX() {
        Object object;
        Method method;
        boolean bl;
        block13: {
            if (desktop != null) {
                return;
            }
            bl = false;
            method = null;
            object = null;
            try {
                Class<?> clazz = Class.forName("java.awt.Desktop", true, null);
                Method method2 = clazz.getMethod("getDesktop", new Class[0]);
                method = clazz.getMethod("browse", URI.class);
                Class<?> clazz2 = Class.forName("java.awt.Desktop$Action", true, null);
                final Method method3 = clazz.getMethod("isDesktopSupported", new Class[0]);
                Method method4 = clazz.getMethod("isSupported", clazz2);
                Field field = clazz2.getField("BROWSE");
                Thread thread = new Thread(){

                    @Override
                    public void run() {
                        block3: {
                            try {
                                result = (Boolean)method3.invoke(null, new Object[0]);
                            }
                            catch (IllegalAccessException illegalAccessException) {
                                InternalError internalError = new InternalError("Desktop.getDesktop() method not found");
                                internalError.initCause(illegalAccessException);
                            }
                            catch (InvocationTargetException invocationTargetException) {
                                if (!Util.isVerbose()) break block3;
                                invocationTargetException.printStackTrace();
                            }
                        }
                    }
                };
                thread.setDaemon(true);
                thread.start();
                try {
                    thread.join(5000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (result.booleanValue()) {
                    object = method2.invoke(null, new Object[0]);
                    result = (Boolean)method4.invoke(object, field.get(null));
                    bl = result;
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                if (Util.isVerbose()) {
                    classNotFoundException.printStackTrace();
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
                if (Util.isVerbose()) {
                    noSuchMethodException.printStackTrace();
                }
            }
            catch (NoSuchFieldException noSuchFieldException) {
                if (Util.isVerbose()) {
                    noSuchFieldException.printStackTrace();
                }
            }
            catch (IllegalAccessException illegalAccessException) {
                InternalError internalError = new InternalError("Desktop.getDesktop() method not found");
                internalError.initCause(illegalAccessException);
                throw internalError;
            }
            catch (InvocationTargetException invocationTargetException) {
                if (!Util.isVerbose()) break block13;
                invocationTargetException.printStackTrace();
            }
        }
        isBrowseSupported = bl;
        browseMethod = method;
        desktop = object;
    }

    static boolean isSupported() {
        BrowserSupport.initX();
        return isBrowseSupported;
    }

    static void browse(URI uRI) throws IOException {
        block9: {
            if (uRI == null) {
                throw new NullPointerException("null uri");
            }
            if (!BrowserSupport.isSupported()) {
                throw new UnsupportedOperationException("Browse operation is not supported");
            }
            try {
                if (Util.isVerbose()) {
                    System.out.println("desktop: " + desktop + ":browsing..." + uRI);
                }
                browseMethod.invoke(desktop, uRI);
            }
            catch (IllegalAccessException illegalAccessException) {
                InternalError internalError = new InternalError("Desktop.getDesktop() method not found");
                internalError.initCause(illegalAccessException);
                throw internalError;
            }
            catch (InvocationTargetException invocationTargetException) {
                Throwable throwable = invocationTargetException.getCause();
                if (throwable == null) break block9;
                if (throwable instanceof UnsupportedOperationException) {
                    throw (UnsupportedOperationException)throwable;
                }
                if (throwable instanceof IllegalArgumentException) {
                    throw (IllegalArgumentException)throwable;
                }
                if (throwable instanceof IOException) {
                    throw (IOException)throwable;
                }
                if (!(throwable instanceof SecurityException)) break block9;
                throw (SecurityException)throwable;
            }
        }
    }
}

