/*
 *  Author: bwilliams
 *  Created: April 6, 2012
 *
 *  Copyright (C) 2012-2016 VMware, Inc.  All rights reserved. -- VMware Confidential
 *
 *  This code was generated by the script "build/dev/codeGen/genCppXml". Please
 *  speak to Brian W. before modifying it by hand.
 *
 */

#include "stdafx.h"

#include "Doc/ProviderInfraDoc/CProviderRegDoc.h"
#include "Xml/XmlUtils/CXmlElement.h"
#include "Doc/DocXml/ProviderInfraXml/ProviderRegXml.h"

using namespace Caf;

void ProviderRegXml::add(
	const SmartPtrCProviderRegDoc providerRegDoc,
	const SmartPtrCXmlElement thisXml) {
	CAF_CM_STATIC_FUNC_VALIDATE("ProviderRegXml", "add");

	CAF_CM_ENTER {
		CAF_CM_VALIDATE_SMARTPTR(providerRegDoc);
		CAF_CM_VALIDATE_SMARTPTR(thisXml);

		const std::string providerNamespaceVal = providerRegDoc->getProviderNamespace();
		CAF_CM_VALIDATE_STRING(providerNamespaceVal);
		thisXml->addAttribute("providerNamespace", providerNamespaceVal);

		const std::string providerNameVal = providerRegDoc->getProviderName();
		CAF_CM_VALIDATE_STRING(providerNameVal);
		thisXml->addAttribute("providerName", providerNameVal);

		const std::string providerVersionVal = providerRegDoc->getProviderVersion();
		CAF_CM_VALIDATE_STRING(providerVersionVal);
		thisXml->addAttribute("providerVersion", providerVersionVal);

		const std::string staleSecVal =
			CStringConv::toString<int32>(providerRegDoc->getStaleSec());
		CAF_CM_VALIDATE_STRING(staleSecVal);
		thisXml->addAttribute("staleSec", staleSecVal);

		const std::string isSchemaVisibleVal = providerRegDoc->getIsSchemaVisible() ? "true" : "false";
		CAF_CM_VALIDATE_STRING(isSchemaVisibleVal);
		thisXml->addAttribute("isSchemaVisible", isSchemaVisibleVal);

		const std::string invokerRelPathVal = providerRegDoc->getInvokerRelPath();
		if (! invokerRelPathVal.empty()) {
			thisXml->addAttribute("invokerRelPath", invokerRelPathVal);
		}
	}
	CAF_CM_EXIT;
}

SmartPtrCProviderRegDoc ProviderRegXml::parse(
	const SmartPtrCXmlElement thisXml) {
	CAF_CM_STATIC_FUNC_VALIDATE("ProviderRegXml", "parse");

	SmartPtrCProviderRegDoc providerRegDoc;

	CAF_CM_ENTER {
		CAF_CM_VALIDATE_SMARTPTR(thisXml);

		const std::string providerNamespaceStrVal =
			thisXml->findRequiredAttribute("providerNamespace");
		const std::string providerNamespaceVal = providerNamespaceStrVal;

		const std::string providerNameStrVal =
			thisXml->findRequiredAttribute("providerName");
		const std::string providerNameVal = providerNameStrVal;

		const std::string providerVersionStrVal =
			thisXml->findRequiredAttribute("providerVersion");
		const std::string providerVersionVal = providerVersionStrVal;

		const std::string staleSecStrVal =
			thisXml->findRequiredAttribute("staleSec");
		int32 staleSecVal = 0;
		if (! staleSecStrVal.empty()) {
			staleSecVal = CStringConv::fromString<int32>(staleSecStrVal);
		}

		const std::string isSchemaVisibleStrVal =
			thisXml->findRequiredAttribute("isSchemaVisible");
		bool isSchemaVisibleVal = false;
		if (! isSchemaVisibleStrVal.empty()) {
			isSchemaVisibleVal = (isSchemaVisibleStrVal.compare("true") == 0)  ? true : false;
		}

		const std::string invokerRelPathStrVal =
			thisXml->findOptionalAttribute("invokerRelPath");
		const std::string invokerRelPathVal = invokerRelPathStrVal;

		providerRegDoc.CreateInstance();
		providerRegDoc->initialize(
			providerNamespaceVal,
			providerNameVal,
			providerVersionVal,
			staleSecVal,
			isSchemaVisibleVal,
			invokerRelPathVal);
	}
	CAF_CM_EXIT;

	return providerRegDoc;
}

