<?xml version="1.0" encoding="ISO-8859-1"?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" lang="fr" xml:lang="fr"><head>
<meta content="text/html; charset=ISO-8859-1" http-equiv="Content-Type" />
<!--
        XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
              This file is generated from xml source: DO NOT EDIT
        XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
      -->
<title>mod_reqtimeout - Serveur Apache HTTP Version 2.4</title>
<link href="../style/css/manual.css" rel="stylesheet" media="all" type="text/css" title="Main stylesheet" />
<link href="../style/css/manual-loose-100pc.css" rel="alternate stylesheet" media="all" type="text/css" title="No Sidebar - Default font size" />
<link href="../style/css/manual-print.css" rel="stylesheet" media="print" type="text/css" /><link rel="stylesheet" type="text/css" href="../style/css/prettify.css" />
<script src="../style/scripts/prettify.min.js" type="text/javascript">
</script>

<link href="../images/favicon.ico" rel="shortcut icon" /></head>
<body>
<div id="page-header">
<p class="menu"><a href="../mod/">Modules</a> | <a href="../mod/directives.html">Directives</a> | <a href="http://wiki.apache.org/httpd/FAQ">FAQ</a> | <a href="../glossary.html">Glossaire</a> | <a href="../sitemap.html">Plan du site</a></p>
<p class="apache">Serveur Apache HTTP Version 2.4</p>
<img alt="" src="../images/feather.png" /></div>
<div class="up"><a href="./"><img title="&lt;-" alt="&lt;-" src="../images/left.gif" /></a></div>
<div id="path">
<a href="http://www.apache.org/">Apache</a> &gt; <a href="http://httpd.apache.org/">Serveur HTTP</a> &gt; <a href="http://httpd.apache.org/docs/">Documentation</a> &gt; <a href="../">Version 2.4</a> &gt; <a href="./">Modules</a></div>
<div id="page-content">
<div id="preamble"><h1>Module Apache mod_reqtimeout</h1>
<div class="toplang">
<p><span>Langues Disponibles: </span><a href="../en/mod/mod_reqtimeout.html" hreflang="en" rel="alternate" title="English">&nbsp;en&nbsp;</a> |
<a href="../fr/mod/mod_reqtimeout.html" title="Franais">&nbsp;fr&nbsp;</a></p>
</div>
<table class="module"><tr><th><a href="module-dict.html#Description">Description:</a></th><td>Dfinit le dlai maximum et le taux minimum de transfert des
donnes pour la rception des requtes
</td></tr>
<tr><th><a href="module-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="module-dict.html#ModuleIdentifier">IdentificateurdeModule:</a></th><td>reqtimeout_module</td></tr>
<tr><th><a href="module-dict.html#SourceFile">FichierSource:</a></th><td>mod_reqtimeout.c</td></tr>
<tr><th><a href="module-dict.html#Compatibility">Compatibilit:</a></th><td>Disponible depuis la version 2.2.15 du serveur HTTP Apache</td></tr></table>
</div>
<div id="quickview"><h3>Sujets</h3>
<ul id="topics">
<li><img alt="" src="../images/down.gif" /> <a href="#examples">Exemples</a></li>
</ul><h3 class="directives">Directives</h3>
<ul id="toc">
<li><img alt="" src="../images/down.gif" /> <a href="#requestreadtimeout">RequestReadTimeout</a></li>
</ul>
<h3>Traitement des bugs</h3><ul class="seealso"><li><a href="https://www.apache.org/dist/httpd/CHANGES_2.4">Journal des modifications de httpd</a></li><li><a href="https://bz.apache.org/bugzilla/buglist.cgi?bug_status=__open__&amp;list_id=144532&amp;product=Apache%20httpd-2&amp;query_format=specific&amp;order=changeddate%20DESC%2Cpriority%2Cbug_severity&amp;component=mod_reqtimeout">Problmes connus</a></li><li><a href="https://bz.apache.org/bugzilla/enter_bug.cgi?product=Apache%20httpd-2&amp;component=mod_reqtimeout">Signaler un bug</a></li></ul><h3>Voir aussi</h3>
<ul class="seealso">
<li><a href="#comments_section">Commentaires</a></li></ul></div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="examples" id="examples">Exemples</a></h2>

    <ol>
      <li>
        Accorde 10 secondes pour la rception des en-ttes de la requte
	et 30 secondes pour la rception du corps :

        <pre class="prettyprint lang-config">RequestTimeout headerinit=10 body=30</pre>

      </li>

      <li>
        Accorde au moins 10 secondes pour la rception du corps de
	la requte. Si le client envoie des donnes, augmente ce dlai
	d'une seconde pour chaque paquet de 1000 octets reus, sans
	limite suprieure (sauf si une limite a t
	spcifie via la directive <code class="directive"><a href="../mod/core.html#limitrequestbody">LimitRequestBody</a></code>) :

        <pre class="prettyprint lang-config">RequestReadTimeout body=10,MinRate=1000</pre>

      </li>

      <li>
        Accorde au moins 10 secondes pour la rception de de la
	requte, en-ttes inclus. Si le client envoie des donnes, augmente ce dlai
	d'une seconde pour chaque paquet de 500 octets reus, mais
	n'alloue que 30 secondes pour la requte, en-ttes inclus :

        <pre class="prettyprint lang-config">RequestReadTimeout header=10-30,MinRate=500</pre>

      </li>

      <li>
        En gnral, un serveur doit avoir ses dlais d'en-tte et de
	corps configurs. Si les serveurs virtuels http et https
	utilisent une configuration commune, les dlais ne doivent pas
	tre dfinis trop bas :

        <pre class="prettyprint lang-config">RequestReadTimeout header=20-40,MinRate=500 body=20,MinRate=500</pre>

      </li>

    </ol>
</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="requestreadtimeout" id="requestreadtimeout">Directive</a> <a name="RequestReadTimeout" id="RequestReadTimeout">RequestReadTimeout</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Dfinit des dlais maximums pour la rception des en-ttes
et corps des requtes en provenance du client.
</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>RequestReadTimeout
[header=<var>dlai</var>[-<var>dlai-maxi</var>][,MinRate=<var>taux-mini</var>]
[body=<var>dlai</var>[-<var>dlai-maxi</var>][,MinRate=<var>taux-mini</var>]
</code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>header=20-40,MinRate=500 body=20,MinRate=500</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_reqtimeout</td></tr>
<tr><th><a href="directive-dict.html#Compatibility">Compatibilit:</a></th><td>Disponible depuis la version 2.2.15 du serveur HTTP
Apache ; dsactive par dfaut depuis la version 2.3.14.</td></tr>
</table>
    <p>Cette directive permet de dfinir diffrents dlais pour la
    rception des en-ttes et corps des requtes en provenance du
    client. Si le client ne parvient pas  respecter ces dlais, un code
    d'erreur <code>408 REQUEST TIME OUT</code> est envoy.</p>

    <p>Pour les serveurs virtuels SSL, le dlai concernant les en-ttes
    inclut le temps ncessaire  la ngociation SSL initiale. Si le
    navigateur du client est configur pour demander des listes de
    rvocations de certificats, et si le serveur correspondant n'est pas
    disponible, le dlai avant lequel le navigateur va abandonner son
    attente de CRL au cours de la ngociation SSL initiale peut tre
    assez important. Par consquent, les valeurs de dlais d'en-ttes ne
    doivent pas tre trop basses pour les serveurs virtuels SSL. Le dlai
    concernant le corps inclut le temps ncessaire  la rengociation
    SSL (si elle est ncessaire).</p>

    <p>Lorsqu'une directive <code class="directive"><a href="../mod/core.html#acceptfilter">AcceptFilter</a></code> est active (ce qui est en
    gnral le cas sous Linux et FreeBSD), la socket n'est envoye au
    processus du serveur qu'aprs la rception du premier octet (ou de
    l'ensemble de la requte si <code>httpready</code> est dfini). Le
    dlai configur pour les en-ttes via la directive
    <code>RequestReadTimeout</code> n'entre en ligne de compte qu'une fois
    la socket reue par le processus du serveur.</p>

    <p>Il existe deux mthodes pour spcifier le dlai (pour l'en-tte
    ou le corps) :
    </p>

    <ul>

    <li><strong>Valeur de dlai fixe</strong>:<br />

    <div class="example"><p><code><var>type</var>=<var>dlai</var></code></p></div>

    <p>Le temps en secondes allou pour la lecture des en-ttes ou du
    corps de la requte. La valeur 0 signifie aucune limite.</p>
    </li>

    <li><strong>Dsactivation du module pour un serveur virtuel :</strong>:<br />

    <div class="example"><p><code>header=0 body=0</code></p></div>

    <p>Avec cet exemple, le module <code class="module"><a href="../mod/mod_reqtimeout.html">mod_reqtimeout</a></code> est
    compltement dsactiv.</p>
    </li>

    <li><strong>La valeur du dlai qui est augmente lorsque des donnes
    sont reues</strong> :<br />
    <div class="example"><p><code>
    <var>type</var>=<var>dlai</var>,MinRate=<var>taux-mini</var>
    </code></p></div>

    <p>Identique  ce qui prcde, mais chaque fois que des donnes sont
    reues, la valeur du dlai est augmente en fonction du taux-mini
    spcifi (en octets par seconde).</p>
    </li>

    <li><strong>La valeur du dlai augmente lorsque des donnes sont
    reues, jusqu' une limite suprieure</strong>:<br />
    <div class="example"><p><code>
    <var>type</var>=<var>dlai</var>-<var>dlai-maxi</var>,MinRate=<var>taux-mini</var>
    </code></p></div>

    <p>Identique  ce qui prcde, mais le dlai n'augmentera pas au
    del de la borne suprieure du dlai spcifie.</p>
    </li>

    </ul>





</div>
</div>
<div class="bottomlang">
<p><span>Langues Disponibles: </span><a href="../en/mod/mod_reqtimeout.html" hreflang="en" rel="alternate" title="English">&nbsp;en&nbsp;</a> |
<a href="../fr/mod/mod_reqtimeout.html" title="Franais">&nbsp;fr&nbsp;</a></p>
</div><div class="top"><a href="#page-header"><img src="../images/up.gif" alt="top" /></a></div><div class="section"><h2><a id="comments_section" name="comments_section">Commentaires</a></h2><div class="warning"><strong>Notice:</strong><br />This is not a Q&amp;A section. Comments placed here should be pointed towards suggestions on improving the documentation or server, and may be removed again by our moderators if they are either implemented or considered invalid/off-topic. Questions on how to manage the Apache HTTP Server should be directed at either our IRC channel, #httpd, on Freenode, or sent to our <a href="http://httpd.apache.org/lists.html">mailing lists</a>.</div>
<script type="text/javascript"><!--//--><![CDATA[//><!--
var comments_shortname = 'httpd';
var comments_identifier = 'http://httpd.apache.org/docs/2.4/mod/mod_reqtimeout.html';
(function(w, d) {
    if (w.location.hostname.toLowerCase() == "httpd.apache.org") {
        d.write('<div id="comments_thread"><\/div>');
        var s = d.createElement('script');
        s.type = 'text/javascript';
        s.async = true;
        s.src = 'https://comments.apache.org/show_comments.lua?site=' + comments_shortname + '&page=' + comments_identifier;
        (d.getElementsByTagName('head')[0] || d.getElementsByTagName('body')[0]).appendChild(s);
    }
    else { 
        d.write('<div id="comments_thread">Comments are disabled for this page at the moment.<\/div>');
    }
})(window, document);
//--><!]]></script></div><div id="footer">
<p class="apache">Copyright 2016 The Apache Software Foundation.<br />Autoris sous <a href="http://www.apache.org/licenses/LICENSE-2.0">Apache License, Version 2.0</a>.</p>
<p class="menu"><a href="../mod/">Modules</a> | <a href="../mod/directives.html">Directives</a> | <a href="http://wiki.apache.org/httpd/FAQ">FAQ</a> | <a href="../glossary.html">Glossaire</a> | <a href="../sitemap.html">Plan du site</a></p></div><script type="text/javascript"><!--//--><![CDATA[//><!--
if (typeof(prettyPrint) !== 'undefined') {
    prettyPrint();
}
//--><!]]></script>
</body></html>