import QtQuick 2.8
import QtQuick.Timeline 1.0
import DigitalCluster 1.0

Item {
    id: sportModeBatterySmallMediaPlayer
    width: 1920
    height: 720

    Item {
        id: background
        anchors.fill: parent
        Image {
            id: background1
            anchors.fill: parent
            source: Themes.backgroundImage
        }
    }

    Adas {
        id: adas
        x: 532
        anchors.right: parent.right
        anchors.top: parent.top
        anchors.bottom: parent.bottom
        anchors.topMargin: 0
        anchors.bottomMargin: 0
        anchors.rightMargin: 0
    }

    SpeedGauge {
        id: speedGauge
        anchors.left: parent.left
        anchors.top: parent.top
        anchors.bottom: parent.bottom
        anchors.bottomMargin: 0
        anchors.topMargin: 0
        anchors.leftMargin: 0
        speed: 200
    }

    BatteryGauge {
        id: batteryGauge
        x: 1200
        anchors.right: parent.right
        anchors.top: parent.top
        anchors.bottom: parent.bottom
        anchors.topMargin: 0
        anchors.bottomMargin: 0
        anchors.rightMargin: 0
        batteryState: 1
        batteryLevel: 11
    }

    Gear {
        id: gear
        y: 330
        anchors.verticalCenter: parent.verticalCenter
        anchors.left: parent.left
        anchors.leftMargin: 32
        currentGear: 1
    }

    Range {
        id: range
        x: 1647
        y: 330
        anchors.verticalCenter: parent.verticalCenter
        anchors.right: parent.right
        anchors.rightMargin: 32
        currentRange: 351
    }

    BottomBar {
        id: bottomBar
        y: 624
        anchors.left: parent.left
        anchors.right: parent.right
        anchors.bottom: parent.bottom
        anchors.bottomMargin: 0
        anchors.leftMargin: 0
        anchors.rightMargin: 0
        currentTemp: 30
    }

    Telltales {
        id: tellTales
        anchors.left: parent.left
        anchors.right: parent.right
        anchors.top: parent.top
        anchors.topMargin: 0
        anchors.rightMargin: 0
        anchors.leftMargin: 0
    }

    Timeline {
        id: timeline
        animations: [
            TimelineAnimation {
                id: timelineAnimation
                pingPong: true
                running: true
                loops: -1
                duration: 15000
                to: 100
                from: 0
            }
        ]
        enabled: true
        endFrame: 100
        startFrame: 0

        KeyframeGroup {
            target: speedGauge
            property: "speed"
            Keyframe {
                frame: 0
                value: 0
            }

            Keyframe {
                easing.bezierCurve: [0.645, 0.045, 0.355, 1, 1, 1]
                frame: 16
                value: 0
            }

            Keyframe {
                easing.bezierCurve: [0.645, 0.045, 0.355, 1, 1, 1]
                frame: 100
                value: 200
            }

            Keyframe {
                easing.bezierCurve: [0.2, 0.2, 0.8, 0.8, 1, 1]
                frame: 31
                value: 5
            }
        }

        KeyframeGroup {
            target: batteryGauge
            property: "batteryLevel"
            Keyframe {
                frame: 0
                value: 100
            }

            Keyframe {
                frame: 40
                value: 50
            }

            Keyframe {
                value: 50
                frame: 55
            }

            Keyframe {
                value: 100
                frame: 100
            }
        }

        KeyframeGroup {
            target: batteryGauge
            property: "batteryState"
            Keyframe {
                value: 2
                frame: 0
            }

            Keyframe {
                value: 0
                frame: 40
            }

            Keyframe {
                value: 1
                frame: 55
            }

            Keyframe {
                value: 1
                frame: 100
            }

            Keyframe {
                value: 2
                frame: 39
            }

            Keyframe {
                value: 0
                frame: 54
            }
        }

        KeyframeGroup {
            target: bottomBar
            property: "odometerDistance"
            Keyframe {
                value: 17113
                frame: 0
            }

            Keyframe {
                value: 17158
                frame: 100
            }
        }

        KeyframeGroup {
            target: gear
            property: "currentGear"
            Keyframe {
                value: 0
                frame: 0
            }

            Keyframe {
                value: 0
                frame: 16
            }

            Keyframe {
                value: 1
                frame: 17
            }

            Keyframe {
                value: 1
                frame: 31
            }

            Keyframe {
                value: 2
                frame: 32
            }

            Keyframe {
                value: 2
                frame: 46
            }

            Keyframe {
                value: 3
                frame: 47
            }
        }

        KeyframeGroup {
            target: gear
            property: "currentDriveMode"
            Keyframe {
                value: 0
                frame: 0
            }

            Keyframe {
                value: 0
                frame: 25
            }

            Keyframe {
                value: 1
                frame: 26
            }

            Keyframe {
                value: 1
                frame: 52
            }

            Keyframe {
                value: 0
                frame: 53
            }

            Keyframe {
                value: 0
                frame: 75
            }

            Keyframe {
                value: 1
                frame: 76
            }
        }

        KeyframeGroup {
            target: bottomBar
            property: "currentTemp"
            Keyframe {
                value: 27
                frame: 0
            }

            Keyframe {
                value: 30
                frame: 100
            }
        }

        KeyframeGroup {
            target: range
            property: "currentRange"
            Keyframe {
                value: 346
                frame: 0
            }

            Keyframe {
                value: 351
                frame: 100
            }
        }
    }
}

/*##^##
Designer {
    D{i:0;height:720;width:1920}D{i:2}D{i:1}D{i:3}D{i:4}D{i:5}D{i:6}D{i:8}D{i:9}D{i:10}
}
##^##*/

