import QtQuick
import QtQuick.Controls
import Generated.DesignSystem

Rectangle {
    id: screen01
    width: 800
    height: 480
    color: Colors.currentTheme.white
    property alias sportyModeButton: sportyModeButton
    property alias speedPanel: speedPanel
    property alias lightModeButton: lightModeButton
    property alias inclinePanel: inclinePanel
    property alias heartRatePanel: heartRatePanel
    property alias stopButton: stopButton
    property alias modeSwitch: modeSwitch
    property alias trackView: trackView
    property alias elevationPanel: elevationPanel
    property alias darkModeButton: darkModeButton
    property alias pauseButton: pauseButton
    property alias startButton: startButton

    BackgroundItems {
        id: backgroundItems
        x: 0
        y: 0
        width: 800
        height: 480
        clip: true
    }

    BigButton {
        id: startButton
        x: 57
        y: 378
        width: 169
        height: 60
    }

    BigButton {
        id: pauseButton
        x: 315
        y: 378
        width: 169
        height: 60
        startTextText: qsTr("PAUSE")
        buttonIcon.source: "assets/pauseIcon.png"
        base.color: Colors.currentTheme.pauseButtonGray
    }

    BigButton {
        id: stopButton
        x: 573
        y: 378
        width: 169
        height: 60
        startTextText: qsTr("STOP")
        buttonIcon.source: "assets/stopIcon.png"
        base.color: Colors.currentTheme.stopButtonRed
    }

    TrackView {
        id: trackView
        x: 283
        y: 90
        width: 234
        height: 253
    }

    InfoPanel {
        id: heartRatePanel
        x: 72
        y: 90
        width: 120
        height: 120
    }

    InfoPanel {
        id: elevationPanel
        x: 608
        y: 90
        width: 120
        height: 120
        panelTitleText: qsTr("ELEVATION")
        infoPanelIcon.source: "assets/elevationIcon.png"
    }

    ModeSwitch {
        id: modeSwitch
        x: 228
        y: 18
        width: 88
        height: 28
    }

    Item {
        id: themeButtons
        anchors.left: parent.left
        anchors.right: parent.right
        anchors.top: parent.top
        anchors.bottom: parent.bottom
        anchors.leftMargin: 491
        anchors.rightMargin: 9
        anchors.topMargin: 14
        anchors.bottomMargin: 429
        ThemeButton {
            id: sportyModeButton
            x: 204
            y: 0
            width: 96
            height: 37
            titleText: qsTr("Sporty")
        }

        ThemeButton {
            id: darkModeButton
            x: 102
            y: 0
            width: 96
            height: 37
            titleText: qsTr("Dark")
        }

        ThemeButton {
            id: lightModeButton
            x: 0
            y: 0
            width: 96
            height: 37
            checked: true
        }
    }

    SettingsPanel {
        id: inclinePanel
        x: 30
        y: 242
        width: 188
        height: 93
    }

    SettingsPanel {
        id: speedPanel
        x: 584
        y: 243
        width: 188
        height: 93
        panelUnitText: qsTr("(MPH)")
        panelTitleText: qsTr("SPEED")
        panelIcon.source: "assets/sprintIconDark.png"
    }
}

/*##^##
Designer {
    D{i:0;uuid:"11e7234a-b0e7-5eb6-a473-4e1088b76d8d"}D{i:1;uuid:"feb2e82c-6f2a-57e5-9d18-acb41bb843b6"}
D{i:2;uuid:"5ed0691a-e4ea-53c7-9602-c59e9f08dee2"}D{i:3;uuid:"1d83b137-4bd3-5a4c-b060-e17c52addd08"}
D{i:4;uuid:"ee6513ec-6603-5007-be85-f0634ea71520"}D{i:5;uuid:"020420ac-2a57-5ff8-bdb7-2b89a87dab5b"}
D{i:6;uuid:"804f1032-eae6-54b4-89e2-895fbee595cc"}D{i:7;uuid:"5cf3534d-1253-59df-ae9a-9ab17a5469b3"}
D{i:8;uuid:"4b10a513-8d89-5194-9bd6-ff343756fcf8"}D{i:9;uuid:"9a6efefc-841e-5212-bacd-8649c943f14b"}
D{i:10;uuid:"f86e75d7-d93d-5166-a050-cbf06cd9239a"}D{i:11;uuid:"1027336b-0be1-55ad-963a-e0ed797a6768"}
D{i:12;uuid:"511335ca-1f2b-5ef9-b875-5eec250ea5f9"}D{i:13;uuid:"e3f010a3-cd1e-548b-a518-ee30239ad11e"}
D{i:14;uuid:"5cfca305-c992-52e7-9643-9ecd33417c9a"}
}
##^##*/

