import QtQuick 2.15
import QtQuick.Controls 2.15
import Outrun_Cluster 1.0

Item {
    id: item1
    property bool night: false
    width: 1920
    height: 1080

    Image {
        id: testlandscapeday
        x: -64
        y: 8
        opacity: 1
        source: "../../../images/testlandscapeday.jpg"
        scale: 1.2
        fillMode: Image.PreserveAspectFit
    }

    Image {
        id: testlandscapenight
        x: -64
        y: 0
        opacity: 0
        source: "../../../images/testlandscapenight.jpg"
        scale: 1.2
        fillMode: Image.PreserveAspectFit
    }
    states: [
        State {
            name: "day"
            when: night == false
        },
        State {
            name: "night"
            when: night == true

            PropertyChanges {
                target: testlandscapenight
                opacity: 1
            }

            PropertyChanges {
                target: testlandscapeday
                opacity: 0
            }
        }
    ]
    transitions: Transition {
        NumberAnimation {
            properties: "opacity"
            easing.type: Easing.InOutQuad
            duration: 2000
        }
    }
}

/*##^##
Designer {
    D{i:0;formeditorZoom:0.25}
}
##^##*/
