# This file is automatically generated by Qt Design Studio.
import os
import sys
from pathlib import Path

from PySide6.QtQml import QQmlApplicationEngine

project_root = Path(__file__).parent.parent.parent


def setup_qt_environment(qml_engine: QQmlApplicationEngine):
    """
    Load the QML application. Import the compiled resources when the application is deployed.
    """
    qml_app_url = "DrumpadContent/App.qml"

    if "__compiled__" in globals():
        # Application has been deployed using pyside6-deploy
        try:
            import autogen.resources  # noqa: F401
        except ImportError:
            resource_file = Path(__file__).parent / "resources.py"
            print(
                f"Error: No compiled resources found in {resource_file.absolute()}\n"
                f"Please compile the resources using pyside6-rcc or pyside6-project build",
                file=sys.stderr,
            )
            sys.exit(1)

        qml_engine.addImportPath(":/")
        qml_engine.load(f":/{qml_app_url}")
        return

    qml_engine.addImportPath(str(project_root.absolute()))
    os.environ["QT_QUICK_CONTROLS_CONF"] = str(project_root / "qtquickcontrols2.conf")
    qml_engine.load(str(project_root / qml_app_url))
