import QtQuick
import QtQuick.Studio.Components 1.0
import QtQuick.VirtualKeyboard
import QtQuick.VirtualKeyboard.Styles

KeyPanel {
    id: root

    Rectangle {
        id: keyboardShiiftKey
        anchors.left: parent.left
        anchors.right: parent.right
        anchors.top: parent.top
        anchors.bottom: parent.bottom
        anchors.rightMargin: 6
        anchors.leftMargin: 6
        anchors.topMargin: 6
        anchors.bottomMargin: 6
        color: "#5E5E5E"
        radius: 24
        border.color: "#222840"
        border.width: 1

        Image {
            id: shiftSVGID

            anchors.top: parent.top
            anchors.bottom: parent.bottom

            source: "shiftIconSVGDefault.svg"
            anchors.horizontalCenter: parent.horizontalCenter

            anchors.bottomMargin: 19
            anchors.topMargin: 19

            antialiasing: true
            fillMode: Image.PreserveAspectFit

            GlowEffect {
                source: shiftSVGID
                anchors.fill: shiftSVGID
                visible: root.control.uppercased
            }
        }

        GlowRectangle {
            id: glowRectangleID

            anchors.fill: keyboardShiiftKey
            glowRectRadius: keyboardShiiftKey.radius
            z: 2
            visible: root.control.uppercased
        }
    }
}
/*##^##
Designer {
    D{i:0;uuid:"1183c034-c4a5-5ed9-9f2e-13a108e6906c"}D{i:1;uuid:"c42fded0-93af-5754-b61a-ec790764bee6"}
}
##^##*/

