

/*
This is a UI file (.ui.qml) that is intended to be edited in Qt Design Studio only.
It is supposed to be strictly declarative and only uses a subset of QML. If you edit
this file manually, you might introduce QML code that is not supported by Qt Design Studio.
Check out https://doc.qt.io/qtcreator/creator-quick-ui-forms.html for details on .ui.qml files.
*/
import QtQuick 6.3
import QtQuick.Controls 6.3
import QtQuick3D 6.3
import AnimationTutorialStart
import Generated.QtQuick3D.BallBearing1 1.0

Rectangle {
    width: 1920
    height: Constants.height

    color: Constants.backgroundColor

    Image {
        id: background1
        x: 0
        y: 0
        source: "images/background-1.png"
        fillMode: Image.PreserveAspectFit
    }

    View3D {
        id: view3D
        anchors.fill: parent

        environment: sceneEnvironment

        SceneEnvironment {
            id: sceneEnvironment
            probeExposure: 5
            lightProbe: animationTutorial_hdr
            antialiasingMode: SceneEnvironment.MSAA
            antialiasingQuality: SceneEnvironment.High

            Texture {
                id: animationTutorial_hdr
                source: "images/animationTutorial_hdr.hdr"
            }
        }

        Node {
            id: scene

            PerspectiveCamera {
                id: sceneCamera
                z: 350
            }

            BallBearing1 {
                id: ballBearing1

                SpotLight {
                    id: lightSpot
                    x: 0
                    y: -1.283
                    color: "#4091da"
                    coneAngle: 60
                    brightness: 5
                    eulerRotation.x: 90
                    z: -0.23
                }

                SpotLight {
                    id: lightSpot1
                    x: 0
                    y: -1.283
                    color: "#9641c3"
                    brightness: 5
                    eulerRotation.x: 90
                    z: 0.23
                }
            }
        }

        Switch {
            id: switch1
            x: 906
            y: 192
        }
    }

    Item {
        id: __materialLibrary__
        DefaultMaterial {
            id: defaultMaterial
            objectName: "Default Material"
            diffuseColor: "#4aee45"
        }
    }

    Slider {
        id: slider
        x: 860
        y: 112
        to: 1000
        value: 0
    }
}

/*##^##
Designer {
D{i:0;formeditorZoom:0.5}D{i:5;cameraSpeed3d:25;cameraSpeed3dMultiplier:1}D{i:11;matPrevEnv:"Default";matPrevEnvValue:"";matPrevModel:"#Sphere"}
}
##^##*/

