.\\" auto-generated by docbook2man-spec $Revision: 1.1.1.1 $
.TH "SPI_execute" "" "2009-03-13" "" "PostgreSQL 8.1.17 Documentation"
.SH NAME
SPI_execute \- execute a command

.SH SYNOPSIS
.sp
.nf
int SPI_execute(const char * \fIcommand\fR, bool \fIread_only\fR, long \fIcount\fR)
.sp
.fi
.SH "DESCRIPTION"
.PP
\fBSPI_execute\fR executes the specified SQL command
for \fIcount\fR rows. If \fIread_only\fR
is true, the command must be read-only, and execution overhead
is somewhat reduced.
.PP
This function may only be called from a connected procedure.
.PP
If \fIcount\fR is zero then the command is executed
for all rows that it applies to. If \fIcount\fR
is greater than 0, then the number of rows for which the command
will be executed is restricted (much like a
LIMIT clause). For example,
.sp
.nf
SPI_execute("INSERT INTO foo SELECT * FROM bar", false, 5);
.sp
.fi
will allow at most 5 rows to be inserted into the table.
.PP
You may pass multiple commands in one string.
\fBSPI_execute\fR returns the
result for the command executed last. The \fIcount\fR
limit applies to each command separately, but it is not applied to
hidden commands generated by rules.
.PP
When \fIread_only\fR is false,
\fBSPI_execute\fR increments the command
counter and computes a new \fIsnapshot\fR before executing each
command in the string. The snapshot does not actually change if the
current transaction isolation level is SERIALIZABLE, but in
READ COMMITTED mode the snapshot update allows each command to
see the results of newly committed transactions from other sessions.
This is essential for consistent behavior when the commands are modifying
the database.
.PP
When \fIread_only\fR is true,
\fBSPI_execute\fR does not update either the snapshot
or the command counter, and it allows only plain \fBSELECT\fR
commands to appear in the command string. The commands are executed
using the snapshot previously established for the surrounding query.
This execution mode is somewhat faster than the read/write mode due
to eliminating per-command overhead. It also allows genuinely
\fIstable\fR functions to be built: since successive executions
will all use the same snapshot, there will be no change in the results.
.PP
It is generally unwise to mix read-only and read-write commands within
a single function using SPI; that could result in very confusing behavior,
since the read-only queries would not see the results of any database
updates done by the read-write queries.
.PP
The actual number of rows for which the (last) command was executed
is returned in the global variable SPI_processed
(unless the return value of the function is
\fBSPI_OK_UTILITY\fR). If the return value of the
function is \fBSPI_OK_SELECT\fR then you may use the
global pointer SPITupleTable *SPI_tuptable to
access the result rows.
.PP
The structure \fBSPITupleTable\fR is defined
thus:
.sp
.nf
typedef struct
{
    MemoryContext tuptabcxt;    /* memory context of result table */
    uint32      alloced;        /* number of alloced vals */
    uint32      free;           /* number of free vals */
    TupleDesc   tupdesc;        /* row descriptor */
    HeapTuple  *vals;           /* rows */
} SPITupleTable;
.sp
.fi
\fBvals\fR is an array of pointers to rows. (The number
of valid entries is given by SPI_processed.)
\fBtupdesc\fR is a row descriptor which you may pass to
SPI functions dealing with rows. \fBtuptabcxt\fR,
\fBalloced\fR, and \fBfree\fR are internal
fields not intended for use by SPI callers.
.PP
\fBSPI_finish\fR frees all
\fBSPITupleTable\fRs allocated during the current
procedure. You can free a particular result table earlier, if you
are done with it, by calling \fBSPI_freetuptable\fR.
.SH "ARGUMENTS"
.TP
\fBconst char * \fIcommand\fB\fR
string containing command to execute
.TP
\fBbool \fIread_only\fB\fR
true for read-only execution
.TP
\fBlong \fIcount\fB\fR
maximum number of rows to process or return
.SH "RETURN VALUE"
.PP
If the execution of the command was successful then one of the
following (nonnegative) values will be returned:
.TP
\fBSPI_OK_SELECT\fR
if a \fBSELECT\fR (but not \fBSELECT
INTO\fR) was executed
.TP
\fBSPI_OK_SELINTO\fR
if a \fBSELECT INTO\fR was executed
.TP
\fBSPI_OK_DELETE\fR
if a \fBDELETE\fR was executed
.TP
\fBSPI_OK_INSERT\fR
if an \fBINSERT\fR was executed
.TP
\fBSPI_OK_UPDATE\fR
if an \fBUPDATE\fR was executed
.TP
\fBSPI_OK_UTILITY\fR
if a utility command (e.g., \fBCREATE TABLE\fR)
was executed
.PP
.PP
On error, one of the following negative values is returned:
.TP
\fBSPI_ERROR_ARGUMENT\fR
if \fIcommand\fR is \fBNULL\fR or
\fIcount\fR is less than 0
.TP
\fBSPI_ERROR_COPY\fR
if \fBCOPY TO stdout\fR or \fBCOPY FROM stdin\fR
was attempted
.TP
\fBSPI_ERROR_CURSOR\fR
if \fBDECLARE\fR, \fBCLOSE\fR, or \fBFETCH\fR
was attempted
.TP
\fBSPI_ERROR_TRANSACTION\fR
if any command involving transaction manipulation was attempted
(\fBBEGIN\fR,
\fBCOMMIT\fR,
\fBROLLBACK\fR,
\fBSAVEPOINT\fR,
\fBPREPARE TRANSACTION\fR,
\fBCOMMIT PREPARED\fR,
\fBROLLBACK PREPARED\fR,
or any variant thereof)
.TP
\fBSPI_ERROR_OPUNKNOWN\fR
if the command type is unknown (shouldn't happen)
.TP
\fBSPI_ERROR_UNCONNECTED\fR
if called from an unconnected procedure
.PP
.SH "NOTES"
.PP
The functions \fBSPI_execute\fR,
\fBSPI_exec\fR,
\fBSPI_execute_plan\fR, and
\fBSPI_execp\fR change both
SPI_processed and
SPI_tuptable (just the pointer, not the contents
of the structure). Save these two global variables into local
procedure variables if you need to access the result table of
\fBSPI_execute\fR or a related function
across later calls.
