.\\" auto-generated by docbook2man-spec $Revision: 1.1.1.1 $
.TH "SET CONSTRAINTS" "" "2007-04-20" "SQL - Language Statements" "SQL Commands"
.SH NAME
SET CONSTRAINTS \- set the constraint mode of the current transaction

.SH SYNOPSIS
.sp
.nf
SET CONSTRAINTS { ALL | \fIname\fR [, ...] } { DEFERRED | IMMEDIATE }
.sp
.fi
.SH "DESCRIPTION"
.PP
\fBSET CONSTRAINTS\fR sets the behavior of constraint
evaluation in the current transaction. In
IMMEDIATE mode, constraints are checked at the
end of each statement. In DEFERRED mode,
constraints are not checked until transaction commit.
.PP
When you change the mode of a constraint to be
IMMEDIATE, the new constraint mode takes effect
retroactively: any outstanding data modifications that would have
been checked at the end of the transaction (when using
DEFERRED) are instead checked during the
execution of the \fBSET CONSTRAINTS\fR command.
.PP
Upon creation, a constraint is always give one of three
characteristics: INITIALLY DEFERRED,
INITIALLY IMMEDIATE DEFERRABLE, or
INITIALLY IMMEDIATE NOT DEFERRABLE. The third
class is not affected by the \fBSET CONSTRAINTS\fR
command.
.PP
Currently, only foreign key constraints are affected by this
setting. Check and unique constraints are always effectively
initially immediate not deferrable.
.SH "NOTES"
.PP
This command only alters the behavior of constraints within the
current transaction. Thus, if you execute this command outside of a
transaction block
(\fBBEGIN\fR/\fBCOMMIT\fR pair), it will
not appear to have any effect. If you wish to change the behavior
of a constraint without needing to issue a \fBSET
CONSTRAINTS\fR command in every transaction, specify
INITIALLY DEFERRED or INITIALLY
IMMEDIATE when you create the constraint.
.SH "COMPATIBILITY"
.PP
This command complies with the behavior defined in the SQL
standard, except for the limitation that, in
PostgreSQL, it only applies to
foreign-key constraints.
