/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.types;

import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.Commandline;
import org.apache.tools.ant.types.Environment;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.util.JavaEnvUtils;

public class CommandlineJava
implements Cloneable {
    private Commandline vmCommand = new Commandline();
    private Commandline javaCommand = new Commandline();
    private SysProperties sysProperties = new SysProperties();
    private Path classpath = null;
    private String vmVersion;
    private String maxMemory = null;
    private boolean executeJar = false;

    public CommandlineJava() {
        this.setVm(JavaEnvUtils.getJreExecutable("java"));
        this.setVmversion(JavaEnvUtils.getJavaVersion());
    }

    public Commandline.Argument createArgument() {
        return this.javaCommand.createArgument();
    }

    public Commandline.Argument createVmArgument() {
        return this.vmCommand.createArgument();
    }

    public void addSysproperty(Environment.Variable sysp) {
        this.sysProperties.addVariable(sysp);
    }

    public void setVm(String vm) {
        this.vmCommand.setExecutable(vm);
    }

    public void setVmversion(String value) {
        this.vmVersion = value;
    }

    public void setJar(String jarpathname) {
        this.javaCommand.setExecutable(jarpathname);
        this.executeJar = true;
    }

    public String getJar() {
        if (this.executeJar) {
            return this.javaCommand.getExecutable();
        }
        return null;
    }

    public void setClassname(String classname) {
        this.javaCommand.setExecutable(classname);
        this.executeJar = false;
    }

    public String getClassname() {
        if (!this.executeJar) {
            return this.javaCommand.getExecutable();
        }
        return null;
    }

    public Path createClasspath(Project p) {
        if (this.classpath == null) {
            this.classpath = new Path(p);
        }
        return this.classpath;
    }

    public String getVmversion() {
        return this.vmVersion;
    }

    public String[] getCommandline() {
        Path fullClasspath;
        String[] result = new String[this.size()];
        int pos = 0;
        String[] vmArgs = this.getActualVMCommand().getCommandline();
        result[pos++] = vmArgs[0];
        System.arraycopy(vmArgs, 1, result, pos, vmArgs.length - 1);
        pos += vmArgs.length - 1;
        if (this.sysProperties.size() > 0) {
            System.arraycopy(this.sysProperties.getVariables(), 0, result, pos, this.sysProperties.size());
            pos += this.sysProperties.size();
        }
        Path path = fullClasspath = this.classpath != null ? this.classpath.concatSystemClasspath("ignore") : null;
        if (fullClasspath != null && fullClasspath.toString().trim().length() > 0) {
            result[pos++] = "-classpath";
            result[pos++] = fullClasspath.toString();
        }
        if (this.executeJar) {
            result[pos++] = "-jar";
        }
        System.arraycopy(this.javaCommand.getCommandline(), 0, result, pos, this.javaCommand.size());
        return result;
    }

    public void setMaxmemory(String max) {
        this.maxMemory = max;
    }

    public String toString() {
        return Commandline.toString(this.getCommandline());
    }

    public String describeCommand() {
        return Commandline.describeCommand(this.getCommandline());
    }

    public String describeJavaCommand() {
        return Commandline.describeCommand(this.getJavaCommand());
    }

    private Commandline getActualVMCommand() {
        Commandline actualVMCommand = (Commandline)this.vmCommand.clone();
        if (this.maxMemory != null) {
            if (this.vmVersion.startsWith("1.1")) {
                actualVMCommand.createArgument().setValue("-mx" + this.maxMemory);
            } else {
                actualVMCommand.createArgument().setValue("-Xmx" + this.maxMemory);
            }
        }
        return actualVMCommand;
    }

    public int size() {
        Path fullClasspath;
        int size = this.getActualVMCommand().size() + this.javaCommand.size() + this.sysProperties.size();
        Path path = fullClasspath = this.classpath != null ? this.classpath.concatSystemClasspath("ignore") : null;
        if (fullClasspath != null && fullClasspath.toString().trim().length() > 0) {
            size += 2;
        }
        if (this.executeJar) {
            ++size;
        }
        return size;
    }

    public Commandline getJavaCommand() {
        return this.javaCommand;
    }

    public Commandline getVmCommand() {
        return this.getActualVMCommand();
    }

    public Path getClasspath() {
        return this.classpath;
    }

    public void setSystemProperties() throws BuildException {
        this.sysProperties.setSystem();
    }

    public void restoreSystemProperties() throws BuildException {
        this.sysProperties.restoreSystem();
    }

    public SysProperties getSystemProperties() {
        return this.sysProperties;
    }

    public Object clone() {
        CommandlineJava c = new CommandlineJava();
        c.vmCommand = (Commandline)this.vmCommand.clone();
        c.javaCommand = (Commandline)this.javaCommand.clone();
        c.sysProperties = (SysProperties)this.sysProperties.clone();
        c.maxMemory = this.maxMemory;
        if (this.classpath != null) {
            c.classpath = (Path)this.classpath.clone();
        }
        c.vmVersion = this.vmVersion;
        c.executeJar = this.executeJar;
        return c;
    }

    public void clearJavaArgs() {
        this.javaCommand.clearArgs();
    }

    public static class SysProperties
    extends Environment
    implements Cloneable {
        Properties sys = null;

        public String[] getVariables() throws BuildException {
            String[] props = super.getVariables();
            if (props == null) {
                return null;
            }
            int i = 0;
            while (i < props.length) {
                props[i] = "-D" + props[i];
                ++i;
            }
            return props;
        }

        public int size() {
            return this.variables.size();
        }

        public void setSystem() throws BuildException {
            try {
                this.sys = System.getProperties();
                Properties p = new Properties();
                Enumeration<Object> e = this.sys.keys();
                while (e.hasMoreElements()) {
                    Object o = e.nextElement();
                    p.put(o, this.sys.get(o));
                }
                Enumeration e2 = this.variables.elements();
                while (e2.hasMoreElements()) {
                    Environment.Variable v = (Environment.Variable)e2.nextElement();
                    p.put(v.getKey(), v.getValue());
                }
                System.setProperties(p);
            }
            catch (SecurityException e) {
                throw new BuildException("Cannot modify system properties", e);
            }
        }

        public void restoreSystem() throws BuildException {
            if (this.sys == null) {
                throw new BuildException("Unbalanced nesting of SysProperties");
            }
            try {
                System.setProperties(this.sys);
                this.sys = null;
            }
            catch (SecurityException e) {
                throw new BuildException("Cannot modify system properties", e);
            }
        }

        public Object clone() {
            try {
                SysProperties c = (SysProperties)super.clone();
                c.variables = (Vector)this.variables.clone();
                return c;
            }
            catch (CloneNotSupportedException e) {
                return null;
            }
        }
    }
}

