#!/usr/bin/perl

use strict;
use warnings;

my $in		= $ARGV[0];
my $tblout	= $ARGV[1];
my $bits	= $ARGV[2];

my $code	= "code$bits";

open TBLOUT,	">", $tblout	or die $!;
open IN,		"<", $in		or die $!;

print TBLOUT "/* Autogenerated, don't edit */\n";

for (<IN>) {
	if ($_ =~ /\#/) {
		next;
	}

	my $sys_name;
	my $sys_num;

	if (/(?<name>\S+)\s+(?<alias>\S+)\s+(?<code64>\d+)\s+(?<code32>(?:\d+|\!))\s+\((?<args>.+)\)/) {
		$sys_name = $+{alias};
	} elsif (/(?<name>\S+)\s+(?<code64>\d+)\s+(?<code32>(?:\d+|\!))\s+\((?<args>.+)\)/) {
		$sys_name = $+{name};
	} else {
		unlink $tblout;
		die "Invalid syscall definition file: invalid entry $_\n";
	}

	$sys_num = $+{$code};

	if ($sys_num ne "!") {
		print TBLOUT "SYSCALL($sys_name, $sys_num)\n";
	}
}
