/// <reference types="node" />
import { SignatureMaterial } from '../signature';
import { ValidBundle } from './validate';
import type { ArtifactVerificationOptions, Envelope, TransparencyLogEntry, VerificationMaterial } from '@sigstore/protobuf-specs';
import type { Entry } from '../../external/rekor';
import type { WithRequired } from '../utility';
import type { SerializedBundle } from './serialized';
export { Envelope, HashAlgorithm, PublicKeyDetails, SubjectAlternativeNameType, } from '@sigstore/protobuf-specs';
export type { ArtifactVerificationOptions, ArtifactVerificationOptions_CtlogOptions, ArtifactVerificationOptions_TlogOptions, CertificateAuthority, CertificateIdentities, CertificateIdentity, MessageSignature, ObjectIdentifierValuePair, PublicKey, PublicKeyIdentifier, RFC3161SignedTimestamp, Signature, SubjectAlternativeName, TimestampVerificationData, TransparencyLogEntry, TransparencyLogInstance, TrustedRoot, X509Certificate, X509CertificateChain, } from '@sigstore/protobuf-specs';
export type { SerializedBundle, SerializedEnvelope } from './serialized';
export type { ValidBundle as Bundle };
export declare const bundleFromJSON: (obj: any) => ValidBundle;
export declare const bundleToJSON: (bundle: ValidBundle) => SerializedBundle;
export type BundleWithCertificateChain = ValidBundle & {
    verificationMaterial: VerificationMaterial & {
        content: Extract<VerificationMaterial['content'], {
            $case: 'x509CertificateChain';
        }>;
    };
};
export declare function isBundleWithCertificateChain(bundle: ValidBundle): bundle is BundleWithCertificateChain;
export type RequiredArtifactVerificationOptions = WithRequired<ArtifactVerificationOptions, 'ctlogOptions' | 'tlogOptions'>;
export type CAArtifactVerificationOptions = WithRequired<ArtifactVerificationOptions, 'ctlogOptions'> & {
    signers?: Extract<ArtifactVerificationOptions['signers'], {
        $case: 'certificateIdentities';
    }>;
};
export declare function isCAVerificationOptions(options: ArtifactVerificationOptions): options is CAArtifactVerificationOptions;
export type VerifiableTransparencyLogEntry = WithRequired<TransparencyLogEntry, 'logId' | 'inclusionPromise' | 'kindVersion'>;
export declare function isVerifiableTransparencyLogEntry(entry: TransparencyLogEntry): entry is VerifiableTransparencyLogEntry;
export declare function toDSSEBundle({ envelope, signature, tlogEntry, timestamp, }: {
    envelope: Envelope;
    signature: SignatureMaterial;
    tlogEntry?: Entry;
    timestamp?: Buffer;
}): ValidBundle;
export declare function toMessageSignatureBundle({ digest, signature, tlogEntry, timestamp, }: {
    digest: Buffer;
    signature: SignatureMaterial;
    tlogEntry?: Entry;
    timestamp?: Buffer;
}): ValidBundle;
