const npm = require('../../npm.js')
const { promisify } = require('util')
const readdir = promisify(require('readdir-scoped-modules'))

const names = global => readdir(global ? npm.globalDir : npm.localDir)

const installedShallow = async opts => {
  const { conf: { argv: { remain } } } = opts
  if (remain.length > 3) {
    return null
  }

  const { global } = npm.flatOptions
  const locals = global ? [] : await names(false)
  const globals = (await names(true)).map(n => global ? n : `${n} -g`)
  return [...locals, ...globals]
}

module.exports = (opts, cb) =>
  installedShallow(opts).then(list => cb(null, list)).catch(cb)
