'use strict';
// The Node team wants to deprecate `process.bind(...)`.
//   https://github.com/nodejs/node/pull/2768
//
// However, we need the 'uv' binding for errname support.
// This is a defensive wrapper around it so `execa` will not fail entirely if it stops working someday.
//
// If this ever stops working. See: https://github.com/sindresorhus/execa/issues/31#issuecomment-215939939 for another possible solution.
let uv;

try {
	uv = process.binding('uv');

	if (typeof uv.errname !== 'function') {
		throw new Error('uv.errname is not a function');
	}
} catch (err) {
	console.error('execa/lib/errname: unable to establish process.binding(\'uv\')', err);
	uv = null;
}

function errname(uv, code) {
	if (uv) {
		return uv.errname(code);
	}

	if (!(code < 0)) {
		throw new Error('err >= 0');
	}

	return `Unknown system error ${code}`;
}

module.exports = code => errname(uv, code);

// used for testing the fallback behavior
module.exports.__test__ = errname;
