-- mod-version:3
local syntax = require "core.syntax"

syntax.add {
  name = "Scala",
  files = { "%.sc$", "%.scala$" },
  comment = "//",
  patterns = {
    { pattern = "//.-\n",                      type = "comment"  },
    { pattern = { "/%*", "%*/" },              type = "comment"  },
    { pattern = { '[ruU]?"', '"', '\\' },      type = "string"   },
    { pattern = { "[ruU]?'", "'", '\\' },      type = "string"   },
    { pattern = "0x[%da-fA-F]+",               type = "number"   },
    { pattern = "-?%d+[%d%.eE]*",              type = "number"   },
    { pattern = "-?%.?%d+",                    type = "number"   },
    { pattern = "[%+%-=/%*%^%%<>!~|&]",        type = "operator" },
    { pattern = '[%a_][%w_]*"""*[%a_][%w_]*"""', type = "string"   },
    { pattern = "[%a_][%w_]*%f[(]",              type = "function" },
    { pattern = "[%a_][%w_]*",                   type = "symbol"   },
  },
  symbols = {
    ["abstract"] = "keyword",
    ["case"]     = "keyword",
    ["catch"]    = "keyword",
    ["class"]    = "keyword",
    ["finally"]  = "keyword",
    ["final"]    = "keyword",
    ["do"]       = "keyword",
    ["extends"]  = "keyword",
    ["forSome"]  = "keyword",
    ["implicit"] = "keyword",
    ["lazy"]     = "keyword",
    ["match"]    = "keyword",
    ["new"]      = "keyword",
    ["override"] = "keyword",
    ["package"]  = "keyword",
    ["throw"]    = "keyword",
    ["trait"]    = "keyword",
    ["type"]     = "keyword",
    ["var"]      = "keyword",
    ["val"]      = "keyword",
    ["println"]  = "keyword",
    ["return"]   = "keyword",
    ["for"]      = "keyword",
    ["Try"]      = "keyword",
    ["def"]      = "keyword",
    ["while"]    = "keyword",
    ["with"]     = "keyword",
    ["if"]       = "keyword",
    ["else"]     = "keyword",
    ["import"]   = "keyword",
    ["object"]   = "keyword",
    ["yield"]    = "keyword",

    ["private"]   = "keyword2",
    ["protected"] = "keyword2",
    ["sealed"]    = "keyword2",
    ["super"]     = "keyword2",
    ["this"]      = "keyword2",
    ["Byte"]      = "keyword2",
    ["Short"]     = "keyword2",
    ["Int"]       = "keyword2",
    ["Long"]      = "keyword2",
    ["Float"]     = "keyword2",
    ["Double"]    = "keyword2",
    ["Char"]      = "keyword2",
    ["String"]    = "keyword2",
    ["List"]      = "keyword2",
    ["Array"]     = "keyword2",
    ["Boolean"]   = "keyword2",

    ["Null"]     = "literal",
    ["Any"]      = "literal",
    ["AnyRef"]   = "literal",
    ["Nothing"]  = "literal",
    ["Unit"]     = "literal",
    ["true"]     = "literal",
    ["false"]    = "literal",
  }
}
