%feature("docstring") OT::ArcsineFactory
"Arcsine factory.

Notes
-----
The parameters are estimated by method of moments:

.. math::
    :nowrap:

    \\begin{eqnarray*}
      \\displaystyle \\Hat{a} = \\Hat{\\mu}_x - \\Hat{\\sigma}_x \\sqrt{2}\\\\
      \\displaystyle \\Hat{b} = \\Hat{\\mu}_x + \\Hat{\\sigma}_x \\sqrt{2}
    \\end{eqnarray*}

See also
--------
DistributionFactory, Arcsine"

// ---------------------------------------------------------------------

%feature("docstring") OT::ArcsineFactory::buildAsArcsine
"Estimate the distribution as native distribution.

**Available usages**:

    buildAsArcsine()

    buildAsArcsine(*sample*)

    buildAsArcsine(*param*)

Parameters
----------
sample : 2-d sequence of float
    Sample from which the distribution parameters are estimated.
param : sequence of float
    The parameters of the  :class:`~openturns.Arcsine`.

Returns
-------
dist : :class:`~openturns.Arcsine`
    The built distribution.
    
    In the first usage, the default Arcsine distribution is built."

