/*
 * Hardware modules present on the DRA7xx chips
 *
 * Copyright (C) 2013 Texas Instruments Incorporated - http://www.ti.com
 *
 * Paul Walmsley
 * Benoit Cousson
 *
 * This file is automatically generated from the OMAP hardware databases.
 * We respectfully ask that any modifications to this file be coordinated
 * with the public linux-omap@vger.kernel.org mailing list and the
 * authors above to ensure that the autogeneration scripts are kept
 * up-to-date with the file contents.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 */

#include <linux/io.h>
#include <linux/platform_data/gpio-omap.h>
#include <linux/power/smartreflex.h>
#include <linux/i2c-omap.h>

#include <linux/omap-dma.h>
#include <linux/platform_data/spi-omap2-mcspi.h>
#include <linux/platform_data/asoc-ti-mcbsp.h>
#include <plat/dmtimer.h>

#include "omap_hwmod.h"
#include "omap_hwmod_common_data.h"
#include "cm1_7xx.h"
#include "cm2_7xx.h"
#include "prm7xx.h"
#include "i2c.h"
#include "mmc.h"
#include "wd_timer.h"

/* Base offset for all DRA7XX interrupts external to MPUSS */
#define DRA7XX_IRQ_GIC_START	32

/* Base offset for all DRA7XX dma requests */
#define DRA7XX_DMA_REQ_START	1


/*
 * IP blocks
 */

/*
 * 'l3' class
 * instance(s): l3_instr, l3_main_1, l3_main_2
 */
static struct omap_hwmod_class dra7xx_l3_hwmod_class = {
	.name	= "l3",
};

/* l3_instr */
static struct omap_hwmod dra7xx_l3_instr_hwmod = {
	.name		= "l3_instr",
	.class		= &dra7xx_l3_hwmod_class,
	.clkdm_name	= "l3instr_clkdm",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = DRA7XX_CM_L3INSTR_L3_INSTR_CLKCTRL_OFFSET,
			.context_offs = DRA7XX_RM_L3INSTR_L3_INSTR_CONTEXT_OFFSET,
			.modulemode   = MODULEMODE_HWCTRL,
		},
	},
};

/* l3_main_1 */
static struct omap_hwmod dra7xx_l3_main_1_hwmod = {
	.name		= "l3_main_1",
	.class		= &dra7xx_l3_hwmod_class,
	.clkdm_name	= "l3main1_clkdm",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = DRA7XX_CM_L3MAIN1_L3_MAIN_1_CLKCTRL_OFFSET,
			.context_offs = DRA7XX_RM_L3MAIN1_L3_MAIN_1_CONTEXT_OFFSET,
		},
	},
};

/* l3_main_2 */
static struct omap_hwmod dra7xx_l3_main_2_hwmod = {
	.name		= "l3_main_2",
	.class		= &dra7xx_l3_hwmod_class,
	.clkdm_name	= "l3instr_clkdm",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = DRA7XX_CM_L3INSTR_L3_MAIN_2_CLKCTRL_OFFSET,
			.context_offs = DRA7XX_RM_L3INSTR_L3_MAIN_2_CONTEXT_OFFSET,
			.modulemode   = MODULEMODE_HWCTRL,
		},
	},
};

/*
 * 'l4' class
 * instance(s): l4_cfg, l4_per1, l4_per2, l4_per3, l4_wkup
 */
static struct omap_hwmod_class dra7xx_l4_hwmod_class = {
	.name	= "l4",
};

/* l4_cfg */
static struct omap_hwmod dra7xx_l4_cfg_hwmod = {
	.name		= "l4_cfg",
	.class		= &dra7xx_l4_hwmod_class,
	.clkdm_name	= "l4cfg_clkdm",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = DRA7XX_CM_L4CFG_L4_CFG_CLKCTRL_OFFSET,
			.context_offs = DRA7XX_RM_L4CFG_L4_CFG_CONTEXT_OFFSET,
		},
	},
};

/* l4_per1 */
static struct omap_hwmod dra7xx_l4_per1_hwmod = {
	.name		= "l4_per1",
	.class		= &dra7xx_l4_hwmod_class,
	.clkdm_name	= "l4per_clkdm",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = DRA7XX_CM_L4PER_L4_PER1_CLKCTRL_OFFSET,
			.flags = HWMOD_OMAP4_NO_CONTEXT_LOSS_BIT,
		},
	},
};

/* l4_per2 */
static struct omap_hwmod dra7xx_l4_per2_hwmod = {
	.name		= "l4_per2",
	.class		= &dra7xx_l4_hwmod_class,
	.clkdm_name	= "l4per2_clkdm",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = DRA7XX_CM_L4PER2_L4_PER2_CLKCTRL_OFFSET,
			.flags = HWMOD_OMAP4_NO_CONTEXT_LOSS_BIT,
		},
	},
};

/* l4_per3 */
static struct omap_hwmod dra7xx_l4_per3_hwmod = {
	.name		= "l4_per3",
	.class		= &dra7xx_l4_hwmod_class,
	.clkdm_name	= "l4per3_clkdm",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = DRA7XX_CM_L4PER3_L4_PER3_CLKCTRL_OFFSET,
			.flags = HWMOD_OMAP4_NO_CONTEXT_LOSS_BIT,
		},
	},
};

/* l4_wkup */
static struct omap_hwmod dra7xx_l4_wkup_hwmod = {
	.name		= "l4_wkup",
	.class		= &dra7xx_l4_hwmod_class,
	.clkdm_name	= "wkupaon_clkdm",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = DRA7XX_CM_WKUPAON_L4_WKUP_CLKCTRL_OFFSET,
			.context_offs = DRA7XX_RM_WKUPAON_L4_WKUP_CONTEXT_OFFSET,
		},
	},
};

/*
 * 'atl' class
 *
 */

static struct omap_hwmod_class dra7xx_atl_hwmod_class = {
	.name	= "atl",
};

/* atl */
static struct omap_hwmod dra7xx_atl_hwmod = {
	.name		= "atl",
	.class		= &dra7xx_atl_hwmod_class,
	.clkdm_name	= "atl_clkdm",
	.main_clk	= "atl_gfclk_mux",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = DRA7XX_CM_ATL_ATL_CLKCTRL_OFFSET,
			.context_offs = DRA7XX_RM_ATL_ATL_CONTEXT_OFFSET,
			.modulemode   = MODULEMODE_SWCTRL,
		},
	},
};

/*
 * 'bb2d' class
 *
 */

static struct omap_hwmod_class dra7xx_bb2d_hwmod_class = {
	.name	= "bb2d",
};

/* bb2d */
static struct omap_hwmod dra7xx_bb2d_hwmod = {
	.name		= "bb2d",
	.class		= &dra7xx_bb2d_hwmod_class,
	.clkdm_name	= "dss_clkdm",
	.main_clk	= "dpll_core_h24x2_ck",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = DRA7XX_CM_DSS_BB2D_CLKCTRL_OFFSET,
			.context_offs = DRA7XX_RM_DSS_BB2D_CONTEXT_OFFSET,
			.modulemode   = MODULEMODE_SWCTRL,
		},
	},
};

/*
 * 'counter' class
 *
 */

static struct omap_hwmod_class_sysconfig dra7xx_counter_sysc = {
	.rev_offs	= 0x0000,
	.sysc_offs	= 0x0010,
	.sysc_flags	= SYSC_HAS_SIDLEMODE,
	.idlemodes	= (SIDLE_FORCE | SIDLE_NO | SIDLE_SMART |
			   SIDLE_SMART_WKUP),
	.sysc_fields	= &omap_hwmod_sysc_type1,
};

static struct omap_hwmod_class dra7xx_counter_hwmod_class = {
	.name	= "counter",
	.sysc	= &dra7xx_counter_sysc,
};

/* counter_32k */
static struct omap_hwmod dra7xx_counter_32k_hwmod = {
	.name		= "counter_32k",
	.class		= &dra7xx_counter_hwmod_class,
	.clkdm_name	= "wkupaon_clkdm",
	.flags		= HWMOD_SWSUP_SIDLE,
	.main_clk	= "wkupaon_iclk_mux",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = DRA7XX_CM_WKUPAON_COUNTER_32K_CLKCTRL_OFFSET,
			.context_offs = DRA7XX_RM_WKUPAON_COUNTER_32K_CONTEXT_OFFSET,
		},
	},
};

/*
 * 'ctrl_module' class
 *
 */

static struct omap_hwmod_class dra7xx_ctrl_module_hwmod_class = {
	.name	= "ctrl_module",
};

/* ctrl_module_wkup */
static struct omap_hwmod dra7xx_ctrl_module_wkup_hwmod = {
	.name		= "ctrl_module_wkup",
	.class		= &dra7xx_ctrl_module_hwmod_class,
	.clkdm_name	= "wkupaon_clkdm",
	.prcm = {
		.omap4 = {
			.flags = HWMOD_OMAP4_NO_CONTEXT_LOSS_BIT,
		},
	},
};

/*
 * 'dcan' class
 *
 */

static struct omap_hwmod_class dra7xx_dcan_hwmod_class = {
	.name	= "dcan",
};

/* dcan1 */
static struct omap_hwmod dra7xx_dcan1_hwmod = {
	.name		= "dcan1",
	.class		= &dra7xx_dcan_hwmod_class,
	.clkdm_name	= "wkupaon_clkdm",
	.main_clk	= "dcan1_sys_clk_mux",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = DRA7XX_CM_WKUPAON_DCAN1_CLKCTRL_OFFSET,
			.context_offs = DRA7XX_RM_WKUPAON_DCAN1_CONTEXT_OFFSET,
			.modulemode   = MODULEMODE_SWCTRL,
		},
	},
};

/* dcan2 */
static struct omap_hwmod dra7xx_dcan2_hwmod = {
	.name		= "dcan2",
	.class		= &dra7xx_dcan_hwmod_class,
	.clkdm_name	= "l4per2_clkdm",
	.main_clk	= "sys_clkin1",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = DRA7XX_CM_L4PER2_DCAN2_CLKCTRL_OFFSET,
			.context_offs = DRA7XX_RM_L4PER2_DCAN2_CONTEXT_OFFSET,
			.modulemode   = MODULEMODE_SWCTRL,
		},
	},
};

/*
 * 'dma' class
 *
 */

static struct omap_hwmod_class_sysconfig dra7xx_dma_sysc = {
	.rev_offs	= 0x0000,
	.sysc_offs	= 0x002c,
	.syss_offs	= 0x0028,
	.sysc_flags	= (SYSC_HAS_AUTOIDLE | SYSC_HAS_CLOCKACTIVITY |
			   SYSC_HAS_EMUFREE | SYSC_HAS_MIDLEMODE |
			   SYSC_HAS_SIDLEMODE | SYSC_HAS_SOFTRESET |
			   SYSS_HAS_RESET_STATUS),
	.idlemodes	= (SIDLE_FORCE | SIDLE_NO | SIDLE_SMART |
			   SIDLE_SMART_WKUP | MSTANDBY_FORCE | MSTANDBY_NO |
			   MSTANDBY_SMART | MSTANDBY_SMART_WKUP),
	.sysc_fields	= &omap_hwmod_sysc_type1,
};

static struct omap_hwmod_class dra7xx_dma_hwmod_class = {
	.name	= "dma",
	.sysc	= &dra7xx_dma_sysc,
};

/* dma dev_attr */
static struct omap_dma_dev_attr dma_dev_attr = {
	.dev_caps	= RESERVE_CHANNEL | DMA_LINKED_LCH | GLOBAL_PRIORITY |
			  IS_CSSA_32 | IS_CDSA_32 | IS_RW_PRIORITY,
	.lch_count	= 32,
};

/* dma_system */
static struct omap_hwmod_irq_info dra7xx_dma_system_irqs[] = {
	{ .name = "0", .irq = 12 + DRA7XX_IRQ_GIC_START },
	{ .name = "1", .irq = 13 + DRA7XX_IRQ_GIC_START },
	{ .name = "2", .irq = 14 + DRA7XX_IRQ_GIC_START },
	{ .name = "3", .irq = 15 + DRA7XX_IRQ_GIC_START },
	{ .irq = -1 }
};

static struct omap_hwmod dra7xx_dma_system_hwmod = {
	.name		= "dma_system",
	.class		= &dra7xx_dma_hwmod_class,
	.clkdm_name	= "dma_clkdm",
	.mpu_irqs	= dra7xx_dma_system_irqs,
	.main_clk	= "l3_iclk_div",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = DRA7XX_CM_DMA_DMA_SYSTEM_CLKCTRL_OFFSET,
			.context_offs = DRA7XX_RM_DMA_DMA_SYSTEM_CONTEXT_OFFSET,
		},
	},
	.dev_attr	= &dma_dev_attr,
};

/*
 * 'dss' class
 *
 */

static struct omap_hwmod_class_sysconfig dra7xx_dss_sysc = {
	.rev_offs	= 0x0000,
	.syss_offs	= 0x0014,
	.sysc_flags	= SYSS_HAS_RESET_STATUS,
};

static struct omap_hwmod_class dra7xx_dss_hwmod_class = {
	.name	= "dss",
	.sysc	= &dra7xx_dss_sysc,
	.reset	= omap_dss_reset,
};

/* dss */
static struct omap_hwmod_dma_info dra7xx_dss_sdma_reqs[] = {
	{ .dma_req = 75 + DRA7XX_DMA_REQ_START },
	{ .dma_req = -1 }
};

static struct omap_hwmod_opt_clk dss_opt_clks[] = {
	{ .role = "dss_clk", .clk = "dss_dss_clk" },
	{ .role = "hdmi_phy_clk", .clk = "dss_48mhz_clk" },
	{ .role = "32khz_clk", .clk = "dss_32khz_clk" },
	{ .role = "video2_clk", .clk = "dss_video2_clk" },
	{ .role = "video1_clk", .clk = "dss_video1_clk" },
	{ .role = "hdmi_clk", .clk = "dss_hdmi_clk" },
};

static struct omap_hwmod dra7xx_dss_hwmod = {
	.name		= "dss_core",
	.class		= &dra7xx_dss_hwmod_class,
	.clkdm_name	= "dss_clkdm",
	.flags		= HWMOD_CONTROL_OPT_CLKS_IN_RESET,
	.sdma_reqs	= dra7xx_dss_sdma_reqs,
	.main_clk	= "dss_dss_clk",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = DRA7XX_CM_DSS_DSS_CLKCTRL_OFFSET,
			.context_offs = DRA7XX_RM_DSS_DSS_CONTEXT_OFFSET,
			.modulemode   = MODULEMODE_SWCTRL,
		},
	},
	.opt_clks	= dss_opt_clks,
	.opt_clks_cnt	= ARRAY_SIZE(dss_opt_clks),
};

/*
 * 'dispc' class
 * display controller
 */

static struct omap_hwmod_class_sysconfig dra7xx_dispc_sysc = {
	.rev_offs	= 0x0000,
	.sysc_offs	= 0x0010,
	.syss_offs	= 0x0014,
	.sysc_flags	= (SYSC_HAS_AUTOIDLE | SYSC_HAS_CLOCKACTIVITY |
			   SYSC_HAS_ENAWAKEUP | SYSC_HAS_MIDLEMODE |
			   SYSC_HAS_SIDLEMODE | SYSC_HAS_SOFTRESET |
			   SYSS_HAS_RESET_STATUS),
	.idlemodes	= (SIDLE_FORCE | SIDLE_NO | SIDLE_SMART |
			   MSTANDBY_FORCE | MSTANDBY_NO | MSTANDBY_SMART),
	.sysc_fields	= &omap_hwmod_sysc_type1,
};

static struct omap_hwmod_class dra7xx_dispc_hwmod_class = {
	.name	= "dispc",
	.sysc	= &dra7xx_dispc_sysc,
};

/* dss_dispc */
/* dss_dispc dev_attr */
static struct omap_dss_dispc_dev_attr dss_dispc_dev_attr = {
	.has_framedonetv_irq	= 1,
	.manager_count		= 4,
};

static struct omap_hwmod dra7xx_dss_dispc_hwmod = {
	.name		= "dss_dispc",
	.class		= &dra7xx_dispc_hwmod_class,
	.clkdm_name	= "dss_clkdm",
	.main_clk	= "dss_dss_clk",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = DRA7XX_CM_DSS_DSS_CLKCTRL_OFFSET,
			.flags = HWMOD_OMAP4_NO_CONTEXT_LOSS_BIT,
		},
	},
	.dev_attr	= &dss_dispc_dev_attr,
};

/*
 * 'hdmi' class
 * hdmi controller
 */

static struct omap_hwmod_class_sysconfig dra7xx_hdmi_sysc = {
	.rev_offs	= 0x0000,
	.sysc_offs	= 0x0010,
	.sysc_flags	= (SYSC_HAS_RESET_STATUS | SYSC_HAS_SIDLEMODE |
			   SYSC_HAS_SOFTRESET),
	.idlemodes	= (SIDLE_FORCE | SIDLE_NO | SIDLE_SMART |
			   SIDLE_SMART_WKUP),
	.sysc_fields	= &omap_hwmod_sysc_type2,
};

static struct omap_hwmod_class dra7xx_hdmi_hwmod_class = {
	.name	= "hdmi",
	.sysc	= &dra7xx_hdmi_sysc,
};

/* dss_hdmi */

static struct omap_hwmod_opt_clk dss_hdmi_opt_clks[] = {
	{ .role = "sys_clk", .clk = "dss_hdmi_clk" },
};

static struct omap_hwmod dra7xx_dss_hdmi_hwmod = {
	.name		= "dss_hdmi",
	.class		= &dra7xx_hdmi_hwmod_class,
	.clkdm_name	= "dss_clkdm",
	.main_clk	= "dss_48mhz_clk",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = DRA7XX_CM_DSS_DSS_CLKCTRL_OFFSET,
			.flags = HWMOD_OMAP4_NO_CONTEXT_LOSS_BIT,
		},
	},
	.opt_clks	= dss_hdmi_opt_clks,
	.opt_clks_cnt	= ARRAY_SIZE(dss_hdmi_opt_clks),
};

/*
 * 'elm' class
 *
 */

static struct omap_hwmod_class_sysconfig dra7xx_elm_sysc = {
	.rev_offs	= 0x0000,
	.sysc_offs	= 0x0010,
	.syss_offs	= 0x0014,
	.sysc_flags	= (SYSC_HAS_AUTOIDLE | SYSC_HAS_CLOCKACTIVITY |
			   SYSC_HAS_SIDLEMODE | SYSC_HAS_SOFTRESET |
			   SYSS_HAS_RESET_STATUS),
	.idlemodes	= (SIDLE_FORCE | SIDLE_NO | SIDLE_SMART |
			   SIDLE_SMART_WKUP),
	.sysc_fields	= &omap_hwmod_sysc_type1,
};

static struct omap_hwmod_class dra7xx_elm_hwmod_class = {
	.name	= "elm",
	.sysc	= &dra7xx_elm_sysc,
};

/* elm */

static struct omap_hwmod dra7xx_elm_hwmod = {
	.name		= "elm",
	.class		= &dra7xx_elm_hwmod_class,
	.clkdm_name	= "l4per_clkdm",
	.main_clk	= "l3_iclk_div",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = DRA7XX_CM_L4PER_ELM_CLKCTRL_OFFSET,
			.context_offs = DRA7XX_RM_L4PER_ELM_CONTEXT_OFFSET,
		},
	},
};

/*
 * 'gpio' class
 *
 */

static struct omap_hwmod_class_sysconfig dra7xx_gpio_sysc = {
	.rev_offs	= 0x0000,
	.sysc_offs	= 0x0010,
	.syss_offs	= 0x0114,
	.sysc_flags	= (SYSC_HAS_AUTOIDLE | SYSC_HAS_ENAWAKEUP |
			   SYSC_HAS_SIDLEMODE | SYSC_HAS_SOFTRESET |
			   SYSS_HAS_RESET_STATUS),
	.idlemodes	= (SIDLE_FORCE | SIDLE_NO | SIDLE_SMART |
			   SIDLE_SMART_WKUP),
	.sysc_fields	= &omap_hwmod_sysc_type1,
};

static struct omap_hwmod_class dra7xx_gpio_hwmod_class = {
	.name	= "gpio",
	.sysc	= &dra7xx_gpio_sysc,
	.rev	= 2,
};

/* gpio dev_attr */
static struct omap_gpio_dev_attr gpio_dev_attr = {
	.bank_width	= 32,
	.dbck_flag	= true,
};

/* gpio1 */
static struct omap_hwmod_opt_clk gpio1_opt_clks[] = {
	{ .role = "dbclk", .clk = "gpio1_dbclk" },
};

static struct omap_hwmod dra7xx_gpio1_hwmod = {
	.name		= "gpio1",
	.class		= &dra7xx_gpio_hwmod_class,
	.clkdm_name	= "wkupaon_clkdm",
	.main_clk	= "wkupaon_iclk_mux",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = DRA7XX_CM_WKUPAON_GPIO1_CLKCTRL_OFFSET,
			.context_offs = DRA7XX_RM_WKUPAON_GPIO1_CONTEXT_OFFSET,
			.modulemode   = MODULEMODE_HWCTRL,
		},
	},
	.opt_clks	= gpio1_opt_clks,
	.opt_clks_cnt	= ARRAY_SIZE(gpio1_opt_clks),
	.dev_attr	= &gpio_dev_attr,
};

/* gpio2 */
static struct omap_hwmod_opt_clk gpio2_opt_clks[] = {
	{ .role = "dbclk", .clk = "gpio2_dbclk" },
};

static struct omap_hwmod dra7xx_gpio2_hwmod = {
	.name		= "gpio2",
	.class		= &dra7xx_gpio_hwmod_class,
	.clkdm_name	= "l4per_clkdm",
	.flags		= HWMOD_CONTROL_OPT_CLKS_IN_RESET,
	.main_clk	= "l3_iclk_div",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = DRA7XX_CM_L4PER_GPIO2_CLKCTRL_OFFSET,
			.context_offs = DRA7XX_RM_L4PER_GPIO2_CONTEXT_OFFSET,
			.modulemode   = MODULEMODE_HWCTRL,
		},
	},
	.opt_clks	= gpio2_opt_clks,
	.opt_clks_cnt	= ARRAY_SIZE(gpio2_opt_clks),
	.dev_attr	= &gpio_dev_attr,
};

/* gpio3 */
static struct omap_hwmod_opt_clk gpio3_opt_clks[] = {
	{ .role = "dbclk", .clk = "gpio3_dbclk" },
};

static struct omap_hwmod dra7xx_gpio3_hwmod = {
	.name		= "gpio3",
	.class		= &dra7xx_gpio_hwmod_class,
	.clkdm_name	= "l4per_clkdm",
	.flags		= HWMOD_CONTROL_OPT_CLKS_IN_RESET,
	.main_clk	= "l3_iclk_div",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = DRA7XX_CM_L4PER_GPIO3_CLKCTRL_OFFSET,
			.context_offs = DRA7XX_RM_L4PER_GPIO3_CONTEXT_OFFSET,
			.modulemode   = MODULEMODE_HWCTRL,
		},
	},
	.opt_clks	= gpio3_opt_clks,
	.opt_clks_cnt	= ARRAY_SIZE(gpio3_opt_clks),
	.dev_attr	= &gpio_dev_attr,
};

/* gpio4 */
static struct omap_hwmod_opt_clk gpio4_opt_clks[] = {
	{ .role = "dbclk", .clk = "gpio4_dbclk" },
};

static struct omap_hwmod dra7xx_gpio4_hwmod = {
	.name		= "gpio4",
	.class		= &dra7xx_gpio_hwmod_class,
	.clkdm_name	= "l4per_clkdm",
	.flags		= HWMOD_CONTROL_OPT_CLKS_IN_RESET,
	.main_clk	= "l3_iclk_div",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = DRA7XX_CM_L4PER_GPIO4_CLKCTRL_OFFSET,
			.context_offs = DRA7XX_RM_L4PER_GPIO4_CONTEXT_OFFSET,
			.modulemode   = MODULEMODE_HWCTRL,
		},
	},
	.opt_clks	= gpio4_opt_clks,
	.opt_clks_cnt	= ARRAY_SIZE(gpio4_opt_clks),
	.dev_attr	= &gpio_dev_attr,
};

/* gpio5 */
static struct omap_hwmod_opt_clk gpio5_opt_clks[] = {
	{ .role = "dbclk", .clk = "gpio5_dbclk" },
};

static struct omap_hwmod dra7xx_gpio5_hwmod = {
	.name		= "gpio5",
	.class		= &dra7xx_gpio_hwmod_class,
	.clkdm_name	= "l4per_clkdm",
	.flags		= HWMOD_CONTROL_OPT_CLKS_IN_RESET,
	.main_clk	= "l3_iclk_div",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = DRA7XX_CM_L4PER_GPIO5_CLKCTRL_OFFSET,
			.context_offs = DRA7XX_RM_L4PER_GPIO5_CONTEXT_OFFSET,
			.modulemode   = MODULEMODE_HWCTRL,
		},
	},
	.opt_clks	= gpio5_opt_clks,
	.opt_clks_cnt	= ARRAY_SIZE(gpio5_opt_clks),
	.dev_attr	= &gpio_dev_attr,
};

/* gpio6 */
static struct omap_hwmod_opt_clk gpio6_opt_clks[] = {
	{ .role = "dbclk", .clk = "gpio6_dbclk" },
};

static struct omap_hwmod dra7xx_gpio6_hwmod = {
	.name		= "gpio6",
	.class		= &dra7xx_gpio_hwmod_class,
	.clkdm_name	= "l4per_clkdm",
	.flags		= HWMOD_CONTROL_OPT_CLKS_IN_RESET,
	.main_clk	= "l3_iclk_div",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = DRA7XX_CM_L4PER_GPIO6_CLKCTRL_OFFSET,
			.context_offs = DRA7XX_RM_L4PER_GPIO6_CONTEXT_OFFSET,
			.modulemode   = MODULEMODE_HWCTRL,
		},
	},
	.opt_clks	= gpio6_opt_clks,
	.opt_clks_cnt	= ARRAY_SIZE(gpio6_opt_clks),
	.dev_attr	= &gpio_dev_attr,
};

/* gpio7 */
static struct omap_hwmod_opt_clk gpio7_opt_clks[] = {
	{ .role = "dbclk", .clk = "gpio7_dbclk" },
};

static struct omap_hwmod dra7xx_gpio7_hwmod = {
	.name		= "gpio7",
	.class		= &dra7xx_gpio_hwmod_class,
	.clkdm_name	= "l4per_clkdm",
	.flags		= HWMOD_CONTROL_OPT_CLKS_IN_RESET,
	.main_clk	= "l3_iclk_div",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = DRA7XX_CM_L4PER_GPIO7_CLKCTRL_OFFSET,
			.context_offs = DRA7XX_RM_L4PER_GPIO7_CONTEXT_OFFSET,
			.modulemode   = MODULEMODE_HWCTRL,
		},
	},
	.opt_clks	= gpio7_opt_clks,
	.opt_clks_cnt	= ARRAY_SIZE(gpio7_opt_clks),
	.dev_attr	= &gpio_dev_attr,
};

/* gpio8 */
static struct omap_hwmod_opt_clk gpio8_opt_clks[] = {
	{ .role = "dbclk", .clk = "gpio8_dbclk" },
};

static struct omap_hwmod dra7xx_gpio8_hwmod = {
	.name		= "gpio8",
	.class		= &dra7xx_gpio_hwmod_class,
	.clkdm_name	= "l4per_clkdm",
	.flags		= HWMOD_CONTROL_OPT_CLKS_IN_RESET,
	.main_clk	= "l3_iclk_div",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = DRA7XX_CM_L4PER_GPIO8_CLKCTRL_OFFSET,
			.context_offs = DRA7XX_RM_L4PER_GPIO8_CONTEXT_OFFSET,
			.modulemode   = MODULEMODE_HWCTRL,
		},
	},
	.opt_clks	= gpio8_opt_clks,
	.opt_clks_cnt	= ARRAY_SIZE(gpio8_opt_clks),
	.dev_attr	= &gpio_dev_attr,
};

/*
 * 'gpmc' class
 *
 */

static struct omap_hwmod_class_sysconfig dra7xx_gpmc_sysc = {
	.rev_offs	= 0x0000,
	.sysc_offs	= 0x0010,
	.syss_offs	= 0x0014,
	.sysc_flags	= (SYSC_HAS_AUTOIDLE | SYSC_HAS_SIDLEMODE |
			   SYSC_HAS_SOFTRESET | SYSS_HAS_RESET_STATUS),
	.idlemodes	= (SIDLE_FORCE | SIDLE_NO | SIDLE_SMART |
			   SIDLE_SMART_WKUP),
	.sysc_fields	= &omap_hwmod_sysc_type1,
};

static struct omap_hwmod_class dra7xx_gpmc_hwmod_class = {
	.name	= "gpmc",
	.sysc	= &dra7xx_gpmc_sysc,
};

/* gpmc */

static struct omap_hwmod dra7xx_gpmc_hwmod = {
	.name		= "gpmc",
	.class		= &dra7xx_gpmc_hwmod_class,
	.clkdm_name	= "l3main1_clkdm",
	.flags		= HWMOD_INIT_NO_IDLE | HWMOD_INIT_NO_RESET,
	.main_clk	= "l3_iclk_div",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = DRA7XX_CM_L3MAIN1_GPMC_CLKCTRL_OFFSET,
			.context_offs = DRA7XX_RM_L3MAIN1_GPMC_CONTEXT_OFFSET,
			.modulemode   = MODULEMODE_HWCTRL,
		},
	},
};

/*
 * 'hdq1w' class
 *
 */

static struct omap_hwmod_class_sysconfig dra7xx_hdq1w_sysc = {
	.rev_offs	= 0x0000,
	.sysc_offs	= 0x0014,
	.syss_offs	= 0x0018,
	.sysc_flags	= (SYSC_HAS_AUTOIDLE | SYSC_HAS_SOFTRESET |
			   SYSS_HAS_RESET_STATUS),
	.sysc_fields	= &omap_hwmod_sysc_type1,
};

static struct omap_hwmod_class dra7xx_hdq1w_hwmod_class = {
	.name	= "hdq1w",
	.sysc	= &dra7xx_hdq1w_sysc,
};

/* hdq1w */

static struct omap_hwmod dra7xx_hdq1w_hwmod = {
	.name		= "hdq1w",
	.class		= &dra7xx_hdq1w_hwmod_class,
	.clkdm_name	= "l4per_clkdm",
	.flags		= HWMOD_INIT_NO_RESET,
	.main_clk	= "func_12m_fclk",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = DRA7XX_CM_L4PER_HDQ1W_CLKCTRL_OFFSET,
			.context_offs = DRA7XX_RM_L4PER_HDQ1W_CONTEXT_OFFSET,
			.modulemode   = MODULEMODE_SWCTRL,
		},
	},
};

/*
 * 'i2c' class
 *
 */

static struct omap_hwmod_class_sysconfig dra7xx_i2c_sysc = {
	.sysc_offs	= 0x0010,
	.syss_offs	= 0x0090,
	.sysc_flags	= (SYSC_HAS_AUTOIDLE | SYSC_HAS_CLOCKACTIVITY |
			   SYSC_HAS_ENAWAKEUP | SYSC_HAS_SIDLEMODE |
			   SYSC_HAS_SOFTRESET | SYSS_HAS_RESET_STATUS),
	.idlemodes	= (SIDLE_FORCE | SIDLE_NO | SIDLE_SMART |
			   SIDLE_SMART_WKUP),
	.clockact	= CLOCKACT_TEST_ICLK,
	.sysc_fields	= &omap_hwmod_sysc_type1,
};

static struct omap_hwmod_class dra7xx_i2c_hwmod_class = {
	.name	= "i2c",
	.sysc	= &dra7xx_i2c_sysc,
	.reset	= &omap_i2c_reset,
	.rev	= OMAP_I2C_IP_VERSION_2,
};

/* i2c dev_attr */
static struct omap_i2c_dev_attr i2c_dev_attr = {
	.flags	= OMAP_I2C_FLAG_BUS_SHIFT_NONE,
};

/* i2c1 */
static struct omap_hwmod dra7xx_i2c1_hwmod = {
	.name		= "i2c1",
	.class		= &dra7xx_i2c_hwmod_class,
	.clkdm_name	= "l4per_clkdm",
	.flags		= HWMOD_16BIT_REG | HWMOD_SET_DEFAULT_CLOCKACT,
	.main_clk	= "func_96m_fclk",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = DRA7XX_CM_L4PER_I2C1_CLKCTRL_OFFSET,
			.context_offs = DRA7XX_RM_L4PER_I2C1_CONTEXT_OFFSET,
			.modulemode   = MODULEMODE_SWCTRL,
		},
	},
	.dev_attr	= &i2c_dev_attr,
};

/* i2c2 */
static struct omap_hwmod dra7xx_i2c2_hwmod = {
	.name		= "i2c2",
	.class		= &dra7xx_i2c_hwmod_class,
	.clkdm_name	= "l4per_clkdm",
	.flags		= HWMOD_16BIT_REG | HWMOD_SET_DEFAULT_CLOCKACT,
	.main_clk	= "func_96m_fclk",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = DRA7XX_CM_L4PER_I2C2_CLKCTRL_OFFSET,
			.context_offs = DRA7XX_RM_L4PER_I2C2_CONTEXT_OFFSET,
			.modulemode   = MODULEMODE_SWCTRL,
		},
	},
	.dev_attr	= &i2c_dev_attr,
};

/* i2c3 */
static struct omap_hwmod dra7xx_i2c3_hwmod = {
	.name		= "i2c3",
	.class		= &dra7xx_i2c_hwmod_class,
	.clkdm_name	= "l4per_clkdm",
	.flags		= HWMOD_16BIT_REG | HWMOD_SET_DEFAULT_CLOCKACT,
	.main_clk	= "func_96m_fclk",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = DRA7XX_CM_L4PER_I2C3_CLKCTRL_OFFSET,
			.context_offs = DRA7XX_RM_L4PER_I2C3_CONTEXT_OFFSET,
			.modulemode   = MODULEMODE_SWCTRL,
		},
	},
	.dev_attr	= &i2c_dev_attr,
};

/* i2c4 */
static struct omap_hwmod dra7xx_i2c4_hwmod = {
	.name		= "i2c4",
	.class		= &dra7xx_i2c_hwmod_class,
	.clkdm_name	= "l4per_clkdm",
	.flags		= HWMOD_16BIT_REG | HWMOD_SET_DEFAULT_CLOCKACT,
	.main_clk	= "func_96m_fclk",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = DRA7XX_CM_L4PER_I2C4_CLKCTRL_OFFSET,
			.context_offs = DRA7XX_RM_L4PER_I2C4_CONTEXT_OFFSET,
			.modulemode   = MODULEMODE_SWCTRL,
		},
	},
	.dev_attr	= &i2c_dev_attr,
};

/* i2c5 */
static struct omap_hwmod dra7xx_i2c5_hwmod = {
	.name		= "i2c5",
	.class		= &dra7xx_i2c_hwmod_class,
	.clkdm_name	= "ipu_clkdm",
	.flags		= HWMOD_16BIT_REG | HWMOD_SET_DEFAULT_CLOCKACT,
	.main_clk	= "func_96m_fclk",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = DRA7XX_CM_IPU_I2C5_CLKCTRL_OFFSET,
			.context_offs = DRA7XX_RM_IPU_I2C5_CONTEXT_OFFSET,
			.modulemode   = MODULEMODE_SWCTRL,
		},
	},
	.dev_attr	= &i2c_dev_attr,
};

/*
 * 'mcspi' class
 *
 */

static struct omap_hwmod_class_sysconfig dra7xx_mcspi_sysc = {
	.rev_offs	= 0x0000,
	.sysc_offs	= 0x0010,
	.sysc_flags	= (SYSC_HAS_EMUFREE | SYSC_HAS_RESET_STATUS |
			   SYSC_HAS_SIDLEMODE | SYSC_HAS_SOFTRESET),
	.idlemodes	= (SIDLE_FORCE | SIDLE_NO | SIDLE_SMART |
			   SIDLE_SMART_WKUP),
	.sysc_fields	= &omap_hwmod_sysc_type2,
};

static struct omap_hwmod_class dra7xx_mcspi_hwmod_class = {
	.name	= "mcspi",
	.sysc	= &dra7xx_mcspi_sysc,
	.rev	= OMAP4_MCSPI_REV,
};

/* mcspi1 */
/* mcspi1 dev_attr */
static struct omap2_mcspi_dev_attr mcspi1_dev_attr = {
	.num_chipselect	= 4,
};

static struct omap_hwmod dra7xx_mcspi1_hwmod = {
	.name		= "mcspi1",
	.class		= &dra7xx_mcspi_hwmod_class,
	.clkdm_name	= "l4per_clkdm",
	.main_clk	= "func_48m_fclk",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = DRA7XX_CM_L4PER_MCSPI1_CLKCTRL_OFFSET,
			.context_offs = DRA7XX_RM_L4PER_MCSPI1_CONTEXT_OFFSET,
			.modulemode   = MODULEMODE_SWCTRL,
		},
	},
	.dev_attr	= &mcspi1_dev_attr,
};

/* mcspi2 */
/* mcspi2 dev_attr */
static struct omap2_mcspi_dev_attr mcspi2_dev_attr = {
	.num_chipselect	= 2,
};

static struct omap_hwmod dra7xx_mcspi2_hwmod = {
	.name		= "mcspi2",
	.class		= &dra7xx_mcspi_hwmod_class,
	.clkdm_name	= "l4per_clkdm",
	.main_clk	= "func_48m_fclk",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = DRA7XX_CM_L4PER_MCSPI2_CLKCTRL_OFFSET,
			.context_offs = DRA7XX_RM_L4PER_MCSPI2_CONTEXT_OFFSET,
			.modulemode   = MODULEMODE_SWCTRL,
		},
	},
	.dev_attr	= &mcspi2_dev_attr,
};

/* mcspi3 */
/* mcspi3 dev_attr */
static struct omap2_mcspi_dev_attr mcspi3_dev_attr = {
	.num_chipselect	= 2,
};

static struct omap_hwmod dra7xx_mcspi3_hwmod = {
	.name		= "mcspi3",
	.class		= &dra7xx_mcspi_hwmod_class,
	.clkdm_name	= "l4per_clkdm",
	.main_clk	= "func_48m_fclk",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = DRA7XX_CM_L4PER_MCSPI3_CLKCTRL_OFFSET,
			.context_offs = DRA7XX_RM_L4PER_MCSPI3_CONTEXT_OFFSET,
			.modulemode   = MODULEMODE_SWCTRL,
		},
	},
	.dev_attr	= &mcspi3_dev_attr,
};

/* mcspi4 */
/* mcspi4 dev_attr */
static struct omap2_mcspi_dev_attr mcspi4_dev_attr = {
	.num_chipselect	= 1,
};

static struct omap_hwmod dra7xx_mcspi4_hwmod = {
	.name		= "mcspi4",
	.class		= &dra7xx_mcspi_hwmod_class,
	.clkdm_name	= "l4per_clkdm",
	.main_clk	= "func_48m_fclk",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = DRA7XX_CM_L4PER_MCSPI4_CLKCTRL_OFFSET,
			.context_offs = DRA7XX_RM_L4PER_MCSPI4_CONTEXT_OFFSET,
			.modulemode   = MODULEMODE_SWCTRL,
		},
	},
	.dev_attr	= &mcspi4_dev_attr,
};

/*
 * 'mmc' class
 *
 */

static struct omap_hwmod_class_sysconfig dra7xx_mmc_sysc = {
	.rev_offs	= 0x0000,
	.sysc_offs	= 0x0010,
	.sysc_flags	= (SYSC_HAS_EMUFREE | SYSC_HAS_MIDLEMODE |
			   SYSC_HAS_RESET_STATUS | SYSC_HAS_SIDLEMODE |
			   SYSC_HAS_SOFTRESET),
	.idlemodes	= (SIDLE_FORCE | SIDLE_NO | SIDLE_SMART |
			   SIDLE_SMART_WKUP | MSTANDBY_FORCE | MSTANDBY_NO |
			   MSTANDBY_SMART | MSTANDBY_SMART_WKUP),
	.sysc_fields	= &omap_hwmod_sysc_type2,
};

static struct omap_hwmod_class dra7xx_mmc_hwmod_class = {
	.name	= "mmc",
	.sysc	= &dra7xx_mmc_sysc,
};

/* mmc1 */
static struct omap_hwmod_opt_clk mmc1_opt_clks[] = {
	{ .role = "clk32k", .clk = "mmc1_clk32k" },
};

/* mmc1 dev_attr */
static struct omap_mmc_dev_attr mmc1_dev_attr = {
	.flags	= OMAP_HSMMC_SUPPORTS_DUAL_VOLT,
};

static struct omap_hwmod dra7xx_mmc1_hwmod = {
	.name		= "mmc1",
	.class		= &dra7xx_mmc_hwmod_class,
	.clkdm_name	= "l3init_clkdm",
	.main_clk	= "mmc1_fclk_div",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = DRA7XX_CM_L3INIT_MMC1_CLKCTRL_OFFSET,
			.context_offs = DRA7XX_RM_L3INIT_MMC1_CONTEXT_OFFSET,
			.modulemode   = MODULEMODE_SWCTRL,
		},
	},
	.opt_clks	= mmc1_opt_clks,
	.opt_clks_cnt	= ARRAY_SIZE(mmc1_opt_clks),
	.dev_attr	= &mmc1_dev_attr,
};

/* mmc2 */
static struct omap_hwmod_opt_clk mmc2_opt_clks[] = {
	{ .role = "clk32k", .clk = "mmc2_clk32k" },
};

static struct omap_hwmod dra7xx_mmc2_hwmod = {
	.name		= "mmc2",
	.class		= &dra7xx_mmc_hwmod_class,
	.clkdm_name	= "l3init_clkdm",
	.main_clk	= "mmc2_fclk_div",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = DRA7XX_CM_L3INIT_MMC2_CLKCTRL_OFFSET,
			.context_offs = DRA7XX_RM_L3INIT_MMC2_CONTEXT_OFFSET,
			.modulemode   = MODULEMODE_SWCTRL,
		},
	},
	.opt_clks	= mmc2_opt_clks,
	.opt_clks_cnt	= ARRAY_SIZE(mmc2_opt_clks),
};

/* mmc3 */
static struct omap_hwmod_opt_clk mmc3_opt_clks[] = {
	{ .role = "clk32k", .clk = "mmc3_clk32k" },
};

static struct omap_hwmod dra7xx_mmc3_hwmod = {
	.name		= "mmc3",
	.class		= &dra7xx_mmc_hwmod_class,
	.clkdm_name	= "l4per_clkdm",
	.main_clk	= "mmc3_gfclk_div",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = DRA7XX_CM_L4PER_MMC3_CLKCTRL_OFFSET,
			.context_offs = DRA7XX_RM_L4PER_MMC3_CONTEXT_OFFSET,
			.modulemode   = MODULEMODE_SWCTRL,
		},
	},
	.opt_clks	= mmc3_opt_clks,
	.opt_clks_cnt	= ARRAY_SIZE(mmc3_opt_clks),
};

/* mmc4 */
static struct omap_hwmod_opt_clk mmc4_opt_clks[] = {
	{ .role = "clk32k", .clk = "mmc4_clk32k" },
};

static struct omap_hwmod dra7xx_mmc4_hwmod = {
	.name		= "mmc4",
	.class		= &dra7xx_mmc_hwmod_class,
	.clkdm_name	= "l4per_clkdm",
	.main_clk	= "mmc4_gfclk_div",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = DRA7XX_CM_L4PER_MMC4_CLKCTRL_OFFSET,
			.context_offs = DRA7XX_RM_L4PER_MMC4_CONTEXT_OFFSET,
			.modulemode   = MODULEMODE_SWCTRL,
		},
	},
	.opt_clks	= mmc4_opt_clks,
	.opt_clks_cnt	= ARRAY_SIZE(mmc4_opt_clks),
};

/*
 * 'mpu' class
 *
 */

static struct omap_hwmod_class dra7xx_mpu_hwmod_class = {
	.name	= "mpu",
};

/* mpu */
static struct omap_hwmod dra7xx_mpu_hwmod = {
	.name		= "mpu",
	.class		= &dra7xx_mpu_hwmod_class,
	.clkdm_name	= "mpu_clkdm",
	.flags		= HWMOD_INIT_NO_IDLE | HWMOD_INIT_NO_RESET,
	.main_clk	= "dpll_mpu_m2_ck",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = DRA7XX_CM_MPU_MPU_CLKCTRL_OFFSET,
			.context_offs = DRA7XX_RM_MPU_MPU_CONTEXT_OFFSET,
		},
	},
};

/*
 * 'ocp2scp' class
 *
 */

static struct omap_hwmod_class_sysconfig dra7xx_ocp2scp_sysc = {
	.rev_offs	= 0x0000,
	.sysc_offs	= 0x0010,
	.syss_offs	= 0x0014,
	.sysc_flags	= (SYSC_HAS_AUTOIDLE | SYSC_HAS_SIDLEMODE |
			   SYSC_HAS_SOFTRESET | SYSS_HAS_RESET_STATUS),
	.idlemodes	= (SIDLE_FORCE | SIDLE_NO | SIDLE_SMART |
			   SIDLE_SMART_WKUP),
	.sysc_fields	= &omap_hwmod_sysc_type1,
};

static struct omap_hwmod_class dra7xx_ocp2scp_hwmod_class = {
	.name	= "ocp2scp",
	.sysc	= &dra7xx_ocp2scp_sysc,
};

/* ocp2scp1 */
static struct omap_hwmod dra7xx_ocp2scp1_hwmod = {
	.name		= "ocp2scp1",
	.class		= &dra7xx_ocp2scp_hwmod_class,
	.clkdm_name	= "l3init_clkdm",
	.main_clk	= "l4_root_clk_div",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = DRA7XX_CM_L3INIT_OCP2SCP1_CLKCTRL_OFFSET,
			.context_offs = DRA7XX_RM_L3INIT_OCP2SCP1_CONTEXT_OFFSET,
			.modulemode   = MODULEMODE_HWCTRL,
		},
	},
};

/*
 * 'qspi' class
 *
 */

static struct omap_hwmod_class_sysconfig dra7xx_qspi_sysc = {
	.sysc_offs	= 0x0010,
	.sysc_flags	= SYSC_HAS_SIDLEMODE,
	.idlemodes	= (SIDLE_FORCE | SIDLE_NO | SIDLE_SMART |
			   SIDLE_SMART_WKUP),
	.sysc_fields	= &omap_hwmod_sysc_type2,
};

static struct omap_hwmod_class dra7xx_qspi_hwmod_class = {
	.name	= "qspi",
	.sysc	= &dra7xx_qspi_sysc,
};

/* qspi */
static struct omap_hwmod dra7xx_qspi_hwmod = {
	.name		= "qspi",
	.class		= &dra7xx_qspi_hwmod_class,
	.clkdm_name	= "l4per2_clkdm",
	.main_clk	= "qspi_gfclk_div",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = DRA7XX_CM_L4PER2_QSPI_CLKCTRL_OFFSET,
			.context_offs = DRA7XX_RM_L4PER2_QSPI_CONTEXT_OFFSET,
			.modulemode   = MODULEMODE_SWCTRL,
		},
	},
};

/*
 * 'sata' class
 *
 */

static struct omap_hwmod_class_sysconfig dra7xx_sata_sysc = {
	.sysc_offs	= 0x0000,
	.sysc_flags	= (SYSC_HAS_MIDLEMODE | SYSC_HAS_SIDLEMODE),
	.idlemodes	= (SIDLE_FORCE | SIDLE_NO | SIDLE_SMART |
			   SIDLE_SMART_WKUP | MSTANDBY_FORCE | MSTANDBY_NO |
			   MSTANDBY_SMART | MSTANDBY_SMART_WKUP),
	.sysc_fields	= &omap_hwmod_sysc_type2,
};

static struct omap_hwmod_class dra7xx_sata_hwmod_class = {
	.name	= "sata",
	.sysc	= &dra7xx_sata_sysc,
};

/* sata */
static struct omap_hwmod_opt_clk sata_opt_clks[] = {
	{ .role = "ref_clk", .clk = "sata_ref_clk" },
};

static struct omap_hwmod dra7xx_sata_hwmod = {
	.name		= "sata",
	.class		= &dra7xx_sata_hwmod_class,
	.clkdm_name	= "l3init_clkdm",
	.flags		= HWMOD_SWSUP_SIDLE | HWMOD_SWSUP_MSTANDBY,
	.main_clk	= "func_48m_fclk",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = DRA7XX_CM_L3INIT_SATA_CLKCTRL_OFFSET,
			.context_offs = DRA7XX_RM_L3INIT_SATA_CONTEXT_OFFSET,
			.modulemode   = MODULEMODE_SWCTRL,
		},
	},
	.opt_clks	= sata_opt_clks,
	.opt_clks_cnt	= ARRAY_SIZE(sata_opt_clks),
};

/*
 * 'smartreflex' class
 *
 */

/* The IP is not compliant to type1 / type2 scheme */
static struct omap_hwmod_sysc_fields omap_hwmod_sysc_type_smartreflex = {
	.sidle_shift	= 24,
	.enwkup_shift	= 26,
};

static struct omap_hwmod_class_sysconfig dra7xx_smartreflex_sysc = {
	.sysc_offs	= 0x0038,
	.sysc_flags	= (SYSC_HAS_ENAWAKEUP | SYSC_HAS_SIDLEMODE),
	.idlemodes	= (SIDLE_FORCE | SIDLE_NO | SIDLE_SMART |
			   SIDLE_SMART_WKUP),
	.sysc_fields	= &omap_hwmod_sysc_type_smartreflex,
};

static struct omap_hwmod_class dra7xx_smartreflex_hwmod_class = {
	.name	= "smartreflex",
	.sysc	= &dra7xx_smartreflex_sysc,
	.rev	= 2,
};

/* smartreflex_core */
/* smartreflex_core dev_attr */
static struct omap_smartreflex_dev_attr smartreflex_core_dev_attr = {
	.sensor_voltdm_name	= "core",
};

static struct omap_hwmod dra7xx_smartreflex_core_hwmod = {
	.name		= "smartreflex_core",
	.class		= &dra7xx_smartreflex_hwmod_class,
	.clkdm_name	= "coreaon_clkdm",
	.main_clk	= "wkupaon_iclk_mux",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = DRA7XX_CM_COREAON_SMARTREFLEX_CORE_CLKCTRL_OFFSET,
			.context_offs = DRA7XX_RM_COREAON_SMARTREFLEX_CORE_CONTEXT_OFFSET,
			.modulemode   = MODULEMODE_SWCTRL,
		},
	},
	.dev_attr	= &smartreflex_core_dev_attr,
};

/* smartreflex_mpu */
/* smartreflex_mpu dev_attr */
static struct omap_smartreflex_dev_attr smartreflex_mpu_dev_attr = {
	.sensor_voltdm_name	= "mpu",
};

static struct omap_hwmod dra7xx_smartreflex_mpu_hwmod = {
	.name		= "smartreflex_mpu",
	.class		= &dra7xx_smartreflex_hwmod_class,
	.clkdm_name	= "coreaon_clkdm",
	.main_clk	= "wkupaon_iclk_mux",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = DRA7XX_CM_COREAON_SMARTREFLEX_MPU_CLKCTRL_OFFSET,
			.context_offs = DRA7XX_RM_COREAON_SMARTREFLEX_MPU_CONTEXT_OFFSET,
			.modulemode   = MODULEMODE_SWCTRL,
		},
	},
	.dev_attr	= &smartreflex_mpu_dev_attr,
};

/*
 * 'spinlock' class
 *
 */

static struct omap_hwmod_class_sysconfig dra7xx_spinlock_sysc = {
	.rev_offs	= 0x0000,
	.sysc_offs	= 0x0010,
	.syss_offs	= 0x0014,
	.sysc_flags	= (SYSC_HAS_AUTOIDLE | SYSC_HAS_CLOCKACTIVITY |
			   SYSC_HAS_ENAWAKEUP | SYSC_HAS_SIDLEMODE |
			   SYSC_HAS_SOFTRESET | SYSS_HAS_RESET_STATUS),
	.idlemodes	= (SIDLE_FORCE | SIDLE_NO | SIDLE_SMART |
			   SIDLE_SMART_WKUP),
	.sysc_fields	= &omap_hwmod_sysc_type1,
};

static struct omap_hwmod_class dra7xx_spinlock_hwmod_class = {
	.name	= "spinlock",
	.sysc	= &dra7xx_spinlock_sysc,
};

/* spinlock */
static struct omap_hwmod dra7xx_spinlock_hwmod = {
	.name		= "spinlock",
	.class		= &dra7xx_spinlock_hwmod_class,
	.clkdm_name	= "l4cfg_clkdm",
	.main_clk	= "l3_iclk_div",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = DRA7XX_CM_L4CFG_SPINLOCK_CLKCTRL_OFFSET,
			.context_offs = DRA7XX_RM_L4CFG_SPINLOCK_CONTEXT_OFFSET,
		},
	},
};

/*
 * 'timer' class
 *
 * This class contains several variants: ['timer_1ms', 'timer_secure',
 * 'timer']
 */

static struct omap_hwmod_class_sysconfig dra7xx_timer_1ms_sysc = {
	.rev_offs	= 0x0000,
	.sysc_offs	= 0x0010,
	.sysc_flags	= (SYSC_HAS_EMUFREE | SYSC_HAS_RESET_STATUS |
			   SYSC_HAS_SIDLEMODE | SYSC_HAS_SOFTRESET),
	.idlemodes	= (SIDLE_FORCE | SIDLE_NO | SIDLE_SMART |
			   SIDLE_SMART_WKUP),
	.sysc_fields	= &omap_hwmod_sysc_type2,
};

static struct omap_hwmod_class dra7xx_timer_1ms_hwmod_class = {
	.name	= "timer",
	.sysc	= &dra7xx_timer_1ms_sysc,
};

static struct omap_hwmod_class_sysconfig dra7xx_timer_secure_sysc = {
	.rev_offs	= 0x0000,
	.sysc_offs	= 0x0010,
	.sysc_flags	= (SYSC_HAS_EMUFREE | SYSC_HAS_RESET_STATUS |
			   SYSC_HAS_SIDLEMODE | SYSC_HAS_SOFTRESET),
	.idlemodes	= (SIDLE_FORCE | SIDLE_NO | SIDLE_SMART |
			   SIDLE_SMART_WKUP),
	.sysc_fields	= &omap_hwmod_sysc_type2,
};

static struct omap_hwmod_class dra7xx_timer_secure_hwmod_class = {
	.name	= "timer",
	.sysc	= &dra7xx_timer_secure_sysc,
};

static struct omap_hwmod_class_sysconfig dra7xx_timer_sysc = {
	.rev_offs	= 0x0000,
	.sysc_offs	= 0x0010,
	.sysc_flags	= (SYSC_HAS_EMUFREE | SYSC_HAS_RESET_STATUS |
			   SYSC_HAS_SIDLEMODE | SYSC_HAS_SOFTRESET),
	.idlemodes	= (SIDLE_FORCE | SIDLE_NO | SIDLE_SMART |
			   SIDLE_SMART_WKUP),
	.sysc_fields	= &omap_hwmod_sysc_type2,
};

static struct omap_hwmod_class dra7xx_timer_hwmod_class = {
	.name	= "timer",
	.sysc	= &dra7xx_timer_sysc,
};

/* timer1 */
static struct omap_hwmod dra7xx_timer1_hwmod = {
	.name		= "timer1",
	.class		= &dra7xx_timer_1ms_hwmod_class,
	.clkdm_name	= "wkupaon_clkdm",
	.main_clk	= "timer1_gfclk_mux",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = DRA7XX_CM_WKUPAON_TIMER1_CLKCTRL_OFFSET,
			.context_offs = DRA7XX_RM_WKUPAON_TIMER1_CONTEXT_OFFSET,
			.modulemode   = MODULEMODE_SWCTRL,
		},
	},
};

/* timer2 */
static struct omap_hwmod dra7xx_timer2_hwmod = {
	.name		= "timer2",
	.class		= &dra7xx_timer_1ms_hwmod_class,
	.clkdm_name	= "l4per_clkdm",
	.main_clk	= "timer2_gfclk_mux",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = DRA7XX_CM_L4PER_TIMER2_CLKCTRL_OFFSET,
			.context_offs = DRA7XX_RM_L4PER_TIMER2_CONTEXT_OFFSET,
			.modulemode   = MODULEMODE_SWCTRL,
		},
	},
};

/* timer3 */
static struct omap_hwmod dra7xx_timer3_hwmod = {
	.name		= "timer3",
	.class		= &dra7xx_timer_hwmod_class,
	.clkdm_name	= "l4per_clkdm",
	.main_clk	= "timer3_gfclk_mux",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = DRA7XX_CM_L4PER_TIMER3_CLKCTRL_OFFSET,
			.context_offs = DRA7XX_RM_L4PER_TIMER3_CONTEXT_OFFSET,
			.modulemode   = MODULEMODE_SWCTRL,
		},
	},
};

/* timer4 */
static struct omap_hwmod dra7xx_timer4_hwmod = {
	.name		= "timer4",
	.class		= &dra7xx_timer_secure_hwmod_class,
	.clkdm_name	= "l4per_clkdm",
	.main_clk	= "timer4_gfclk_mux",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = DRA7XX_CM_L4PER_TIMER4_CLKCTRL_OFFSET,
			.context_offs = DRA7XX_RM_L4PER_TIMER4_CONTEXT_OFFSET,
			.modulemode   = MODULEMODE_SWCTRL,
		},
	},
};

/* timer5 */
static struct omap_hwmod dra7xx_timer5_hwmod = {
	.name		= "timer5",
	.class		= &dra7xx_timer_hwmod_class,
	.clkdm_name	= "ipu_clkdm",
	.main_clk	= "timer5_gfclk_mux",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = DRA7XX_CM_IPU_TIMER5_CLKCTRL_OFFSET,
			.context_offs = DRA7XX_RM_IPU_TIMER5_CONTEXT_OFFSET,
			.modulemode   = MODULEMODE_SWCTRL,
		},
	},
};

/* timer6 */
static struct omap_hwmod dra7xx_timer6_hwmod = {
	.name		= "timer6",
	.class		= &dra7xx_timer_hwmod_class,
	.clkdm_name	= "ipu_clkdm",
	.main_clk	= "timer6_gfclk_mux",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = DRA7XX_CM_IPU_TIMER6_CLKCTRL_OFFSET,
			.context_offs = DRA7XX_RM_IPU_TIMER6_CONTEXT_OFFSET,
			.modulemode   = MODULEMODE_SWCTRL,
		},
	},
};

/* timer7 */
static struct omap_hwmod dra7xx_timer7_hwmod = {
	.name		= "timer7",
	.class		= &dra7xx_timer_hwmod_class,
	.clkdm_name	= "ipu_clkdm",
	.main_clk	= "timer7_gfclk_mux",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = DRA7XX_CM_IPU_TIMER7_CLKCTRL_OFFSET,
			.context_offs = DRA7XX_RM_IPU_TIMER7_CONTEXT_OFFSET,
			.modulemode   = MODULEMODE_SWCTRL,
		},
	},
};

/* timer8 */
static struct omap_hwmod dra7xx_timer8_hwmod = {
	.name		= "timer8",
	.class		= &dra7xx_timer_hwmod_class,
	.clkdm_name	= "ipu_clkdm",
	.main_clk	= "timer8_gfclk_mux",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = DRA7XX_CM_IPU_TIMER8_CLKCTRL_OFFSET,
			.context_offs = DRA7XX_RM_IPU_TIMER8_CONTEXT_OFFSET,
			.modulemode   = MODULEMODE_SWCTRL,
		},
	},
};

/* timer9 */
static struct omap_hwmod dra7xx_timer9_hwmod = {
	.name		= "timer9",
	.class		= &dra7xx_timer_hwmod_class,
	.clkdm_name	= "l4per_clkdm",
	.main_clk	= "timer9_gfclk_mux",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = DRA7XX_CM_L4PER_TIMER9_CLKCTRL_OFFSET,
			.context_offs = DRA7XX_RM_L4PER_TIMER9_CONTEXT_OFFSET,
			.modulemode   = MODULEMODE_SWCTRL,
		},
	},
};

/* timer10 */
static struct omap_hwmod dra7xx_timer10_hwmod = {
	.name		= "timer10",
	.class		= &dra7xx_timer_1ms_hwmod_class,
	.clkdm_name	= "l4per_clkdm",
	.main_clk	= "timer10_gfclk_mux",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = DRA7XX_CM_L4PER_TIMER10_CLKCTRL_OFFSET,
			.context_offs = DRA7XX_RM_L4PER_TIMER10_CONTEXT_OFFSET,
			.modulemode   = MODULEMODE_SWCTRL,
		},
	},
};

/* timer11 */
static struct omap_hwmod dra7xx_timer11_hwmod = {
	.name		= "timer11",
	.class		= &dra7xx_timer_hwmod_class,
	.clkdm_name	= "l4per_clkdm",
	.main_clk	= "timer11_gfclk_mux",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = DRA7XX_CM_L4PER_TIMER11_CLKCTRL_OFFSET,
			.context_offs = DRA7XX_RM_L4PER_TIMER11_CONTEXT_OFFSET,
			.modulemode   = MODULEMODE_SWCTRL,
		},
	},
};

/*
 * 'uart' class
 *
 */

static struct omap_hwmod_class_sysconfig dra7xx_uart_sysc = {
	.rev_offs	= 0x0050,
	.sysc_offs	= 0x0054,
	.syss_offs	= 0x0058,
	.sysc_flags	= (SYSC_HAS_AUTOIDLE | SYSC_HAS_ENAWAKEUP |
			   SYSC_HAS_SIDLEMODE | SYSC_HAS_SOFTRESET |
			   SYSS_HAS_RESET_STATUS),
	.idlemodes	= (SIDLE_FORCE | SIDLE_NO | SIDLE_SMART |
			   SIDLE_SMART_WKUP),
	.sysc_fields	= &omap_hwmod_sysc_type1,
};

static struct omap_hwmod_class dra7xx_uart_hwmod_class = {
	.name	= "uart",
	.sysc	= &dra7xx_uart_sysc,
};

/* uart1 */
static struct omap_hwmod dra7xx_uart1_hwmod = {
	.name		= "uart1",
	.class		= &dra7xx_uart_hwmod_class,
	.clkdm_name	= "l4per_clkdm",
	.main_clk	= "uart1_gfclk_mux",
	.flags		= HWMOD_SWSUP_SIDLE_ACT,
	.prcm = {
		.omap4 = {
			.clkctrl_offs = DRA7XX_CM_L4PER_UART1_CLKCTRL_OFFSET,
			.context_offs = DRA7XX_RM_L4PER_UART1_CONTEXT_OFFSET,
			.modulemode   = MODULEMODE_SWCTRL,
		},
	},
};

/* uart2 */
static struct omap_hwmod dra7xx_uart2_hwmod = {
	.name		= "uart2",
	.class		= &dra7xx_uart_hwmod_class,
	.clkdm_name	= "l4per_clkdm",
	.main_clk	= "uart2_gfclk_mux",
	.flags		= HWMOD_SWSUP_SIDLE_ACT,
	.prcm = {
		.omap4 = {
			.clkctrl_offs = DRA7XX_CM_L4PER_UART2_CLKCTRL_OFFSET,
			.context_offs = DRA7XX_RM_L4PER_UART2_CONTEXT_OFFSET,
			.modulemode   = MODULEMODE_SWCTRL,
		},
	},
};

/* uart3 */
static struct omap_hwmod dra7xx_uart3_hwmod = {
	.name		= "uart3",
	.class		= &dra7xx_uart_hwmod_class,
	.clkdm_name	= "l4per_clkdm",
	.main_clk	= "uart3_gfclk_mux",
	.flags		= HWMOD_SWSUP_SIDLE_ACT,
	.prcm = {
		.omap4 = {
			.clkctrl_offs = DRA7XX_CM_L4PER_UART3_CLKCTRL_OFFSET,
			.context_offs = DRA7XX_RM_L4PER_UART3_CONTEXT_OFFSET,
			.modulemode   = MODULEMODE_SWCTRL,
		},
	},
};

/* uart4 */
static struct omap_hwmod dra7xx_uart4_hwmod = {
	.name		= "uart4",
	.class		= &dra7xx_uart_hwmod_class,
	.clkdm_name	= "l4per_clkdm",
	.main_clk	= "uart4_gfclk_mux",
	.flags		= HWMOD_SWSUP_SIDLE_ACT,
	.prcm = {
		.omap4 = {
			.clkctrl_offs = DRA7XX_CM_L4PER_UART4_CLKCTRL_OFFSET,
			.context_offs = DRA7XX_RM_L4PER_UART4_CONTEXT_OFFSET,
			.modulemode   = MODULEMODE_SWCTRL,
		},
	},
};

/* uart5 */
static struct omap_hwmod dra7xx_uart5_hwmod = {
	.name		= "uart5",
	.class		= &dra7xx_uart_hwmod_class,
	.clkdm_name	= "l4per_clkdm",
	.main_clk	= "uart5_gfclk_mux",
	.flags		= HWMOD_SWSUP_SIDLE_ACT,
	.prcm = {
		.omap4 = {
			.clkctrl_offs = DRA7XX_CM_L4PER_UART5_CLKCTRL_OFFSET,
			.context_offs = DRA7XX_RM_L4PER_UART5_CONTEXT_OFFSET,
			.modulemode   = MODULEMODE_SWCTRL,
		},
	},
};

/* uart6 */
static struct omap_hwmod dra7xx_uart6_hwmod = {
	.name		= "uart6",
	.class		= &dra7xx_uart_hwmod_class,
	.clkdm_name	= "ipu_clkdm",
	.main_clk	= "uart6_gfclk_mux",
	.flags		= HWMOD_SWSUP_SIDLE_ACT,
	.prcm = {
		.omap4 = {
			.clkctrl_offs = DRA7XX_CM_IPU_UART6_CLKCTRL_OFFSET,
			.context_offs = DRA7XX_RM_IPU_UART6_CONTEXT_OFFSET,
			.modulemode   = MODULEMODE_SWCTRL,
		},
	},
};

/*
 * 'usb_otg_ss' class
 *
 */

static struct omap_hwmod_class dra7xx_usb_otg_ss_hwmod_class = {
	.name	= "usb_otg_ss",
};

/* usb_otg_ss1 */
static struct omap_hwmod_opt_clk usb_otg_ss1_opt_clks[] = {
	{ .role = "refclk960m", .clk = "usb_otg_ss1_refclk960m" },
};

static struct omap_hwmod dra7xx_usb_otg_ss1_hwmod = {
	.name		= "usb_otg_ss1",
	.class		= &dra7xx_usb_otg_ss_hwmod_class,
	.clkdm_name	= "l3init_clkdm",
	.main_clk	= "dpll_core_h13x2_ck",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = DRA7XX_CM_L3INIT_USB_OTG_SS1_CLKCTRL_OFFSET,
			.context_offs = DRA7XX_RM_L3INIT_USB_OTG_SS1_CONTEXT_OFFSET,
			.modulemode   = MODULEMODE_HWCTRL,
		},
	},
	.opt_clks	= usb_otg_ss1_opt_clks,
	.opt_clks_cnt	= ARRAY_SIZE(usb_otg_ss1_opt_clks),
};

/* usb_otg_ss2 */
static struct omap_hwmod_opt_clk usb_otg_ss2_opt_clks[] = {
	{ .role = "refclk960m", .clk = "usb_otg_ss2_refclk960m" },
};

static struct omap_hwmod dra7xx_usb_otg_ss2_hwmod = {
	.name		= "usb_otg_ss2",
	.class		= &dra7xx_usb_otg_ss_hwmod_class,
	.clkdm_name	= "l3init_clkdm",
	.main_clk	= "dpll_core_h13x2_ck",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = DRA7XX_CM_L3INIT_USB_OTG_SS2_CLKCTRL_OFFSET,
			.context_offs = DRA7XX_RM_L3INIT_USB_OTG_SS2_CONTEXT_OFFSET,
			.modulemode   = MODULEMODE_HWCTRL,
		},
	},
	.opt_clks	= usb_otg_ss2_opt_clks,
	.opt_clks_cnt	= ARRAY_SIZE(usb_otg_ss2_opt_clks),
};

/* usb_otg_ss3 */
static struct omap_hwmod dra7xx_usb_otg_ss3_hwmod = {
	.name		= "usb_otg_ss3",
	.class		= &dra7xx_usb_otg_ss_hwmod_class,
	.clkdm_name	= "l3init_clkdm",
	.main_clk	= "dpll_core_h13x2_ck",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = DRA7XX_CM_L3INIT_USB_OTG_SS3_CLKCTRL_OFFSET,
			.context_offs = DRA7XX_RM_L3INIT_USB_OTG_SS3_CONTEXT_OFFSET,
			.modulemode   = MODULEMODE_HWCTRL,
		},
	},
};

/* usb_otg_ss4 */
static struct omap_hwmod dra7xx_usb_otg_ss4_hwmod = {
	.name		= "usb_otg_ss4",
	.class		= &dra7xx_usb_otg_ss_hwmod_class,
	.clkdm_name	= "l3init_clkdm",
	.main_clk	= "dpll_core_h13x2_ck",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = DRA7XX_CM_L3INIT_USB_OTG_SS4_CLKCTRL_OFFSET,
			.context_offs = DRA7XX_RM_L3INIT_USB_OTG_SS4_CONTEXT_OFFSET,
			.modulemode   = MODULEMODE_HWCTRL,
		},
	},
};

/*
 * 'vcp' class
 *
 */

static struct omap_hwmod_class dra7xx_vcp_hwmod_class = {
	.name	= "vcp",
};

/* vcp1 */
static struct omap_hwmod dra7xx_vcp1_hwmod = {
	.name		= "vcp1",
	.class		= &dra7xx_vcp_hwmod_class,
	.clkdm_name	= "l3main1_clkdm",
	.main_clk	= "l3_iclk_div",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = DRA7XX_CM_L3MAIN1_VCP1_CLKCTRL_OFFSET,
			.context_offs = DRA7XX_RM_L3MAIN1_VCP1_CONTEXT_OFFSET,
		},
	},
};

/* vcp2 */
static struct omap_hwmod dra7xx_vcp2_hwmod = {
	.name		= "vcp2",
	.class		= &dra7xx_vcp_hwmod_class,
	.clkdm_name	= "l3main1_clkdm",
	.main_clk	= "l3_iclk_div",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = DRA7XX_CM_L3MAIN1_VCP2_CLKCTRL_OFFSET,
			.context_offs = DRA7XX_RM_L3MAIN1_VCP2_CONTEXT_OFFSET,
		},
	},
};

/*
 * 'wd_timer' class
 *
 */

static struct omap_hwmod_class_sysconfig dra7xx_wd_timer_sysc = {
	.rev_offs	= 0x0000,
	.sysc_offs	= 0x0010,
	.syss_offs	= 0x0014,
	.sysc_flags	= (SYSC_HAS_EMUFREE | SYSC_HAS_SIDLEMODE |
			   SYSC_HAS_SOFTRESET | SYSS_HAS_RESET_STATUS),
	.idlemodes	= (SIDLE_FORCE | SIDLE_NO | SIDLE_SMART |
			   SIDLE_SMART_WKUP),
	.sysc_fields	= &omap_hwmod_sysc_type1,
};

static struct omap_hwmod_class dra7xx_wd_timer_hwmod_class = {
	.name		= "wd_timer",
	.sysc		= &dra7xx_wd_timer_sysc,
	.pre_shutdown	= &omap2_wd_timer_disable,
	.reset		= &omap2_wd_timer_reset,
};

/* wd_timer2 */
static struct omap_hwmod dra7xx_wd_timer2_hwmod = {
	.name		= "wd_timer2",
	.class		= &dra7xx_wd_timer_hwmod_class,
	.clkdm_name	= "wkupaon_clkdm",
	.main_clk	= "sys_32k_ck",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = DRA7XX_CM_WKUPAON_WD_TIMER2_CLKCTRL_OFFSET,
			.context_offs = DRA7XX_RM_WKUPAON_WD_TIMER2_CONTEXT_OFFSET,
			.modulemode   = MODULEMODE_SWCTRL,
		},
	},
};


/*
 * Interfaces
 */

/* l3_main_2 -> l3_instr */
static struct omap_hwmod_ocp_if dra7xx_l3_main_2__l3_instr = {
	.master		= &dra7xx_l3_main_2_hwmod,
	.slave		= &dra7xx_l3_instr_hwmod,
	.clk		= "l3_iclk_div",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* l4_cfg -> l3_main_1 */
static struct omap_hwmod_ocp_if dra7xx_l4_cfg__l3_main_1 = {
	.master		= &dra7xx_l4_cfg_hwmod,
	.slave		= &dra7xx_l3_main_1_hwmod,
	.clk		= "l3_iclk_div",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* mpu -> l3_main_1 */
static struct omap_hwmod_ocp_if dra7xx_mpu__l3_main_1 = {
	.master		= &dra7xx_mpu_hwmod,
	.slave		= &dra7xx_l3_main_1_hwmod,
	.clk		= "l3_iclk_div",
	.user		= OCP_USER_MPU,
};

/* l3_main_1 -> l3_main_2 */
static struct omap_hwmod_ocp_if dra7xx_l3_main_1__l3_main_2 = {
	.master		= &dra7xx_l3_main_1_hwmod,
	.slave		= &dra7xx_l3_main_2_hwmod,
	.clk		= "l3_iclk_div",
	.user		= OCP_USER_MPU,
};

/* l4_cfg -> l3_main_2 */
static struct omap_hwmod_ocp_if dra7xx_l4_cfg__l3_main_2 = {
	.master		= &dra7xx_l4_cfg_hwmod,
	.slave		= &dra7xx_l3_main_2_hwmod,
	.clk		= "l3_iclk_div",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* l3_main_1 -> l4_cfg */
static struct omap_hwmod_ocp_if dra7xx_l3_main_1__l4_cfg = {
	.master		= &dra7xx_l3_main_1_hwmod,
	.slave		= &dra7xx_l4_cfg_hwmod,
	.clk		= "l3_iclk_div",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* l3_main_1 -> l4_per1 */
static struct omap_hwmod_ocp_if dra7xx_l3_main_1__l4_per1 = {
	.master		= &dra7xx_l3_main_1_hwmod,
	.slave		= &dra7xx_l4_per1_hwmod,
	.clk		= "l3_iclk_div",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* l3_main_1 -> l4_per2 */
static struct omap_hwmod_ocp_if dra7xx_l3_main_1__l4_per2 = {
	.master		= &dra7xx_l3_main_1_hwmod,
	.slave		= &dra7xx_l4_per2_hwmod,
	.clk		= "l3_iclk_div",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* l3_main_1 -> l4_per3 */
static struct omap_hwmod_ocp_if dra7xx_l3_main_1__l4_per3 = {
	.master		= &dra7xx_l3_main_1_hwmod,
	.slave		= &dra7xx_l4_per3_hwmod,
	.clk		= "l3_iclk_div",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* l3_main_1 -> l4_wkup */
static struct omap_hwmod_ocp_if dra7xx_l3_main_1__l4_wkup = {
	.master		= &dra7xx_l3_main_1_hwmod,
	.slave		= &dra7xx_l4_wkup_hwmod,
	.clk		= "wkupaon_iclk_mux",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* l4_per2 -> atl */
static struct omap_hwmod_ocp_if dra7xx_l4_per2__atl = {
	.master		= &dra7xx_l4_per2_hwmod,
	.slave		= &dra7xx_atl_hwmod,
	.clk		= "l3_iclk_div",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* l3_main_1 -> bb2d */
static struct omap_hwmod_ocp_if dra7xx_l3_main_1__bb2d = {
	.master		= &dra7xx_l3_main_1_hwmod,
	.slave		= &dra7xx_bb2d_hwmod,
	.clk		= "l3_iclk_div",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* l4_wkup -> counter_32k */
static struct omap_hwmod_ocp_if dra7xx_l4_wkup__counter_32k = {
	.master		= &dra7xx_l4_wkup_hwmod,
	.slave		= &dra7xx_counter_32k_hwmod,
	.clk		= "wkupaon_iclk_mux",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* l4_wkup -> ctrl_module_wkup */
static struct omap_hwmod_ocp_if dra7xx_l4_wkup__ctrl_module_wkup = {
	.master		= &dra7xx_l4_wkup_hwmod,
	.slave		= &dra7xx_ctrl_module_wkup_hwmod,
	.clk		= "wkupaon_iclk_mux",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* l4_wkup -> dcan1 */
static struct omap_hwmod_ocp_if dra7xx_l4_wkup__dcan1 = {
	.master		= &dra7xx_l4_wkup_hwmod,
	.slave		= &dra7xx_dcan1_hwmod,
	.clk		= "wkupaon_iclk_mux",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* l4_per2 -> dcan2 */
static struct omap_hwmod_ocp_if dra7xx_l4_per2__dcan2 = {
	.master		= &dra7xx_l4_per2_hwmod,
	.slave		= &dra7xx_dcan2_hwmod,
	.clk		= "l3_iclk_div",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

static struct omap_hwmod_addr_space dra7xx_dma_system_addrs[] = {
	{
		.pa_start	= 0x4a056000,
		.pa_end		= 0x4a056fff,
		.flags		= ADDR_TYPE_RT
	},
	{ }
};

/* l4_cfg -> dma_system */
static struct omap_hwmod_ocp_if dra7xx_l4_cfg__dma_system = {
	.master		= &dra7xx_l4_cfg_hwmod,
	.slave		= &dra7xx_dma_system_hwmod,
	.clk		= "l3_iclk_div",
	.addr		= dra7xx_dma_system_addrs,
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

static struct omap_hwmod_addr_space dra7xx_dss_addrs[] = {
	{
		.name		= "family",
		.pa_start	= 0x58000000,
		.pa_end		= 0x5800007f,
		.flags		= ADDR_TYPE_RT
	},
};

/* l3_main_1 -> dss */
static struct omap_hwmod_ocp_if dra7xx_l3_main_1__dss = {
	.master		= &dra7xx_l3_main_1_hwmod,
	.slave		= &dra7xx_dss_hwmod,
	.clk		= "l3_iclk_div",
	.addr		= dra7xx_dss_addrs,
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

static struct omap_hwmod_addr_space dra7xx_dss_dispc_addrs[] = {
	{
		.name		= "dispc",
		.pa_start	= 0x58001000,
		.pa_end		= 0x58001fff,
		.flags		= ADDR_TYPE_RT
	},
};

/* l3_main_1 -> dispc */
static struct omap_hwmod_ocp_if dra7xx_l3_main_1__dispc = {
	.master		= &dra7xx_l3_main_1_hwmod,
	.slave		= &dra7xx_dss_dispc_hwmod,
	.clk		= "l3_iclk_div",
	.addr		= dra7xx_dss_dispc_addrs,
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

static struct omap_hwmod_addr_space dra7xx_dss_hdmi_addrs[] = {
	{
		.name		= "hdmi_wp",
		.pa_start	= 0x58040000,
		.pa_end		= 0x580400ff,
		.flags		= ADDR_TYPE_RT
	},
	{ }
};

/* l3_main_1 -> dispc */
static struct omap_hwmod_ocp_if dra7xx_l3_main_1__hdmi = {
	.master		= &dra7xx_l3_main_1_hwmod,
	.slave		= &dra7xx_dss_hdmi_hwmod,
	.clk		= "l3_iclk_div",
	.addr		= dra7xx_dss_hdmi_addrs,
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

static struct omap_hwmod_addr_space dra7xx_elm_addrs[] = {
	{
		.pa_start	= 0x48078000,
		.pa_end		= 0x48078fff,
		.flags		= ADDR_TYPE_RT
	},
	{ }
};

/* l4_per1 -> elm */
static struct omap_hwmod_ocp_if dra7xx_l4_per1__elm = {
	.master		= &dra7xx_l4_per1_hwmod,
	.slave		= &dra7xx_elm_hwmod,
	.clk		= "l3_iclk_div",
	.addr		= dra7xx_elm_addrs,
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* l4_wkup -> gpio1 */
static struct omap_hwmod_ocp_if dra7xx_l4_wkup__gpio1 = {
	.master		= &dra7xx_l4_wkup_hwmod,
	.slave		= &dra7xx_gpio1_hwmod,
	.clk		= "wkupaon_iclk_mux",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* l4_per1 -> gpio2 */
static struct omap_hwmod_ocp_if dra7xx_l4_per1__gpio2 = {
	.master		= &dra7xx_l4_per1_hwmod,
	.slave		= &dra7xx_gpio2_hwmod,
	.clk		= "l3_iclk_div",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* l4_per1 -> gpio3 */
static struct omap_hwmod_ocp_if dra7xx_l4_per1__gpio3 = {
	.master		= &dra7xx_l4_per1_hwmod,
	.slave		= &dra7xx_gpio3_hwmod,
	.clk		= "l3_iclk_div",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* l4_per1 -> gpio4 */
static struct omap_hwmod_ocp_if dra7xx_l4_per1__gpio4 = {
	.master		= &dra7xx_l4_per1_hwmod,
	.slave		= &dra7xx_gpio4_hwmod,
	.clk		= "l3_iclk_div",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* l4_per1 -> gpio5 */
static struct omap_hwmod_ocp_if dra7xx_l4_per1__gpio5 = {
	.master		= &dra7xx_l4_per1_hwmod,
	.slave		= &dra7xx_gpio5_hwmod,
	.clk		= "l3_iclk_div",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* l4_per1 -> gpio6 */
static struct omap_hwmod_ocp_if dra7xx_l4_per1__gpio6 = {
	.master		= &dra7xx_l4_per1_hwmod,
	.slave		= &dra7xx_gpio6_hwmod,
	.clk		= "l3_iclk_div",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* l4_per1 -> gpio7 */
static struct omap_hwmod_ocp_if dra7xx_l4_per1__gpio7 = {
	.master		= &dra7xx_l4_per1_hwmod,
	.slave		= &dra7xx_gpio7_hwmod,
	.clk		= "l3_iclk_div",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* l4_per1 -> gpio8 */
static struct omap_hwmod_ocp_if dra7xx_l4_per1__gpio8 = {
	.master		= &dra7xx_l4_per1_hwmod,
	.slave		= &dra7xx_gpio8_hwmod,
	.clk		= "l3_iclk_div",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

static struct omap_hwmod_addr_space dra7xx_gpmc_addrs[] = {
	{
		.pa_start	= 0x50000000,
		.pa_end		= 0x500003ff,
		.flags		= ADDR_TYPE_RT
	},
	{ }
};

/* l3_main_1 -> gpmc */
static struct omap_hwmod_ocp_if dra7xx_l3_main_1__gpmc = {
	.master		= &dra7xx_l3_main_1_hwmod,
	.slave		= &dra7xx_gpmc_hwmod,
	.clk		= "l3_iclk_div",
	.addr		= dra7xx_gpmc_addrs,
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

static struct omap_hwmod_addr_space dra7xx_hdq1w_addrs[] = {
	{
		.pa_start	= 0x480b2000,
		.pa_end		= 0x480b201f,
		.flags		= ADDR_TYPE_RT
	},
	{ }
};

/* l4_per1 -> hdq1w */
static struct omap_hwmod_ocp_if dra7xx_l4_per1__hdq1w = {
	.master		= &dra7xx_l4_per1_hwmod,
	.slave		= &dra7xx_hdq1w_hwmod,
	.clk		= "l3_iclk_div",
	.addr		= dra7xx_hdq1w_addrs,
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* l4_per1 -> i2c1 */
static struct omap_hwmod_ocp_if dra7xx_l4_per1__i2c1 = {
	.master		= &dra7xx_l4_per1_hwmod,
	.slave		= &dra7xx_i2c1_hwmod,
	.clk		= "l3_iclk_div",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* l4_per1 -> i2c2 */
static struct omap_hwmod_ocp_if dra7xx_l4_per1__i2c2 = {
	.master		= &dra7xx_l4_per1_hwmod,
	.slave		= &dra7xx_i2c2_hwmod,
	.clk		= "l3_iclk_div",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* l4_per1 -> i2c3 */
static struct omap_hwmod_ocp_if dra7xx_l4_per1__i2c3 = {
	.master		= &dra7xx_l4_per1_hwmod,
	.slave		= &dra7xx_i2c3_hwmod,
	.clk		= "l3_iclk_div",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* l4_per1 -> i2c4 */
static struct omap_hwmod_ocp_if dra7xx_l4_per1__i2c4 = {
	.master		= &dra7xx_l4_per1_hwmod,
	.slave		= &dra7xx_i2c4_hwmod,
	.clk		= "l3_iclk_div",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* l4_per1 -> i2c5 */
static struct omap_hwmod_ocp_if dra7xx_l4_per1__i2c5 = {
	.master		= &dra7xx_l4_per1_hwmod,
	.slave		= &dra7xx_i2c5_hwmod,
	.clk		= "l3_iclk_div",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* l4_per1 -> mcspi1 */
static struct omap_hwmod_ocp_if dra7xx_l4_per1__mcspi1 = {
	.master		= &dra7xx_l4_per1_hwmod,
	.slave		= &dra7xx_mcspi1_hwmod,
	.clk		= "l3_iclk_div",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* l4_per1 -> mcspi2 */
static struct omap_hwmod_ocp_if dra7xx_l4_per1__mcspi2 = {
	.master		= &dra7xx_l4_per1_hwmod,
	.slave		= &dra7xx_mcspi2_hwmod,
	.clk		= "l3_iclk_div",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* l4_per1 -> mcspi3 */
static struct omap_hwmod_ocp_if dra7xx_l4_per1__mcspi3 = {
	.master		= &dra7xx_l4_per1_hwmod,
	.slave		= &dra7xx_mcspi3_hwmod,
	.clk		= "l3_iclk_div",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* l4_per1 -> mcspi4 */
static struct omap_hwmod_ocp_if dra7xx_l4_per1__mcspi4 = {
	.master		= &dra7xx_l4_per1_hwmod,
	.slave		= &dra7xx_mcspi4_hwmod,
	.clk		= "l3_iclk_div",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* l4_per1 -> mmc1 */
static struct omap_hwmod_ocp_if dra7xx_l4_per1__mmc1 = {
	.master		= &dra7xx_l4_per1_hwmod,
	.slave		= &dra7xx_mmc1_hwmod,
	.clk		= "l3_iclk_div",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* l4_per1 -> mmc2 */
static struct omap_hwmod_ocp_if dra7xx_l4_per1__mmc2 = {
	.master		= &dra7xx_l4_per1_hwmod,
	.slave		= &dra7xx_mmc2_hwmod,
	.clk		= "l3_iclk_div",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* l4_per1 -> mmc3 */
static struct omap_hwmod_ocp_if dra7xx_l4_per1__mmc3 = {
	.master		= &dra7xx_l4_per1_hwmod,
	.slave		= &dra7xx_mmc3_hwmod,
	.clk		= "l3_iclk_div",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* l4_per1 -> mmc4 */
static struct omap_hwmod_ocp_if dra7xx_l4_per1__mmc4 = {
	.master		= &dra7xx_l4_per1_hwmod,
	.slave		= &dra7xx_mmc4_hwmod,
	.clk		= "l3_iclk_div",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* l4_cfg -> mpu */
static struct omap_hwmod_ocp_if dra7xx_l4_cfg__mpu = {
	.master		= &dra7xx_l4_cfg_hwmod,
	.slave		= &dra7xx_mpu_hwmod,
	.clk		= "l3_iclk_div",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

static struct omap_hwmod_addr_space dra7xx_ocp2scp1_addrs[] = {
	{
		.pa_start	= 0x4a080000,
		.pa_end		= 0x4a08001f,
		.flags		= ADDR_TYPE_RT
	},
	{ }
};

/* l4_cfg -> ocp2scp1 */
static struct omap_hwmod_ocp_if dra7xx_l4_cfg__ocp2scp1 = {
	.master		= &dra7xx_l4_cfg_hwmod,
	.slave		= &dra7xx_ocp2scp1_hwmod,
	.clk		= "l4_root_clk_div",
	.addr		= dra7xx_ocp2scp1_addrs,
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

static struct omap_hwmod_addr_space dra7xx_qspi_addrs[] = {
	{
		.pa_start	= 0x4b300000,
		.pa_end		= 0x4b30007f,
		.flags		= ADDR_TYPE_RT
	},
	{ }
};

/* l3_main_1 -> qspi */
static struct omap_hwmod_ocp_if dra7xx_l3_main_1__qspi = {
	.master		= &dra7xx_l3_main_1_hwmod,
	.slave		= &dra7xx_qspi_hwmod,
	.clk		= "l3_iclk_div",
	.addr		= dra7xx_qspi_addrs,
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

static struct omap_hwmod_addr_space dra7xx_sata_addrs[] = {
	{
		.name		= "sysc",
		.pa_start	= 0x4a141100,
		.pa_end		= 0x4a141107,
		.flags		= ADDR_TYPE_RT
	},
	{ }
};

/* l4_cfg -> sata */
static struct omap_hwmod_ocp_if dra7xx_l4_cfg__sata = {
	.master		= &dra7xx_l4_cfg_hwmod,
	.slave		= &dra7xx_sata_hwmod,
	.clk		= "l3_iclk_div",
	.addr		= dra7xx_sata_addrs,
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

static struct omap_hwmod_addr_space dra7xx_smartreflex_core_addrs[] = {
	{
		.pa_start	= 0x4a0dd000,
		.pa_end		= 0x4a0dd07f,
		.flags		= ADDR_TYPE_RT
	},
	{ }
};

/* l4_cfg -> smartreflex_core */
static struct omap_hwmod_ocp_if dra7xx_l4_cfg__smartreflex_core = {
	.master		= &dra7xx_l4_cfg_hwmod,
	.slave		= &dra7xx_smartreflex_core_hwmod,
	.clk		= "l4_root_clk_div",
	.addr		= dra7xx_smartreflex_core_addrs,
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

static struct omap_hwmod_addr_space dra7xx_smartreflex_mpu_addrs[] = {
	{
		.pa_start	= 0x4a0d9000,
		.pa_end		= 0x4a0d907f,
		.flags		= ADDR_TYPE_RT
	},
	{ }
};

/* l4_cfg -> smartreflex_mpu */
static struct omap_hwmod_ocp_if dra7xx_l4_cfg__smartreflex_mpu = {
	.master		= &dra7xx_l4_cfg_hwmod,
	.slave		= &dra7xx_smartreflex_mpu_hwmod,
	.clk		= "l4_root_clk_div",
	.addr		= dra7xx_smartreflex_mpu_addrs,
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

static struct omap_hwmod_addr_space dra7xx_spinlock_addrs[] = {
	{
		.pa_start	= 0x4a0f6000,
		.pa_end		= 0x4a0f6fff,
		.flags		= ADDR_TYPE_RT
	},
	{ }
};

/* l4_cfg -> spinlock */
static struct omap_hwmod_ocp_if dra7xx_l4_cfg__spinlock = {
	.master		= &dra7xx_l4_cfg_hwmod,
	.slave		= &dra7xx_spinlock_hwmod,
	.clk		= "l3_iclk_div",
	.addr		= dra7xx_spinlock_addrs,
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* l4_wkup -> timer1 */
static struct omap_hwmod_ocp_if dra7xx_l4_wkup__timer1 = {
	.master		= &dra7xx_l4_wkup_hwmod,
	.slave		= &dra7xx_timer1_hwmod,
	.clk		= "wkupaon_iclk_mux",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* l4_per1 -> timer2 */
static struct omap_hwmod_ocp_if dra7xx_l4_per1__timer2 = {
	.master		= &dra7xx_l4_per1_hwmod,
	.slave		= &dra7xx_timer2_hwmod,
	.clk		= "l3_iclk_div",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* l4_per1 -> timer3 */
static struct omap_hwmod_ocp_if dra7xx_l4_per1__timer3 = {
	.master		= &dra7xx_l4_per1_hwmod,
	.slave		= &dra7xx_timer3_hwmod,
	.clk		= "l3_iclk_div",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* l4_per1 -> timer4 */
static struct omap_hwmod_ocp_if dra7xx_l4_per1__timer4 = {
	.master		= &dra7xx_l4_per1_hwmod,
	.slave		= &dra7xx_timer4_hwmod,
	.clk		= "l3_iclk_div",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* l4_per3 -> timer5 */
static struct omap_hwmod_ocp_if dra7xx_l4_per3__timer5 = {
	.master		= &dra7xx_l4_per3_hwmod,
	.slave		= &dra7xx_timer5_hwmod,
	.clk		= "l3_iclk_div",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* l4_per3 -> timer6 */
static struct omap_hwmod_ocp_if dra7xx_l4_per3__timer6 = {
	.master		= &dra7xx_l4_per3_hwmod,
	.slave		= &dra7xx_timer6_hwmod,
	.clk		= "l3_iclk_div",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* l4_per3 -> timer7 */
static struct omap_hwmod_ocp_if dra7xx_l4_per3__timer7 = {
	.master		= &dra7xx_l4_per3_hwmod,
	.slave		= &dra7xx_timer7_hwmod,
	.clk		= "l3_iclk_div",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* l4_per3 -> timer8 */
static struct omap_hwmod_ocp_if dra7xx_l4_per3__timer8 = {
	.master		= &dra7xx_l4_per3_hwmod,
	.slave		= &dra7xx_timer8_hwmod,
	.clk		= "l3_iclk_div",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* l4_per1 -> timer9 */
static struct omap_hwmod_ocp_if dra7xx_l4_per1__timer9 = {
	.master		= &dra7xx_l4_per1_hwmod,
	.slave		= &dra7xx_timer9_hwmod,
	.clk		= "l3_iclk_div",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* l4_per1 -> timer10 */
static struct omap_hwmod_ocp_if dra7xx_l4_per1__timer10 = {
	.master		= &dra7xx_l4_per1_hwmod,
	.slave		= &dra7xx_timer10_hwmod,
	.clk		= "l3_iclk_div",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* l4_per1 -> timer11 */
static struct omap_hwmod_ocp_if dra7xx_l4_per1__timer11 = {
	.master		= &dra7xx_l4_per1_hwmod,
	.slave		= &dra7xx_timer11_hwmod,
	.clk		= "l3_iclk_div",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* l4_per1 -> uart1 */
static struct omap_hwmod_ocp_if dra7xx_l4_per1__uart1 = {
	.master		= &dra7xx_l4_per1_hwmod,
	.slave		= &dra7xx_uart1_hwmod,
	.clk		= "l3_iclk_div",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* l4_per1 -> uart2 */
static struct omap_hwmod_ocp_if dra7xx_l4_per1__uart2 = {
	.master		= &dra7xx_l4_per1_hwmod,
	.slave		= &dra7xx_uart2_hwmod,
	.clk		= "l3_iclk_div",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* l4_per1 -> uart3 */
static struct omap_hwmod_ocp_if dra7xx_l4_per1__uart3 = {
	.master		= &dra7xx_l4_per1_hwmod,
	.slave		= &dra7xx_uart3_hwmod,
	.clk		= "l3_iclk_div",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* l4_per1 -> uart4 */
static struct omap_hwmod_ocp_if dra7xx_l4_per1__uart4 = {
	.master		= &dra7xx_l4_per1_hwmod,
	.slave		= &dra7xx_uart4_hwmod,
	.clk		= "l3_iclk_div",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* l4_per1 -> uart5 */
static struct omap_hwmod_ocp_if dra7xx_l4_per1__uart5 = {
	.master		= &dra7xx_l4_per1_hwmod,
	.slave		= &dra7xx_uart5_hwmod,
	.clk		= "l3_iclk_div",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* l4_per1 -> uart6 */
static struct omap_hwmod_ocp_if dra7xx_l4_per1__uart6 = {
	.master		= &dra7xx_l4_per1_hwmod,
	.slave		= &dra7xx_uart6_hwmod,
	.clk		= "l3_iclk_div",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* l4_per3 -> usb_otg_ss1 */
static struct omap_hwmod_ocp_if dra7xx_l4_per3__usb_otg_ss1 = {
	.master		= &dra7xx_l4_per3_hwmod,
	.slave		= &dra7xx_usb_otg_ss1_hwmod,
	.clk		= "dpll_core_h13x2_ck",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* l4_per3 -> usb_otg_ss2 */
static struct omap_hwmod_ocp_if dra7xx_l4_per3__usb_otg_ss2 = {
	.master		= &dra7xx_l4_per3_hwmod,
	.slave		= &dra7xx_usb_otg_ss2_hwmod,
	.clk		= "dpll_core_h13x2_ck",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* l4_per3 -> usb_otg_ss3 */
static struct omap_hwmod_ocp_if dra7xx_l4_per3__usb_otg_ss3 = {
	.master		= &dra7xx_l4_per3_hwmod,
	.slave		= &dra7xx_usb_otg_ss3_hwmod,
	.clk		= "dpll_core_h13x2_ck",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* l4_per3 -> usb_otg_ss4 */
static struct omap_hwmod_ocp_if dra7xx_l4_per3__usb_otg_ss4 = {
	.master		= &dra7xx_l4_per3_hwmod,
	.slave		= &dra7xx_usb_otg_ss4_hwmod,
	.clk		= "dpll_core_h13x2_ck",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* l3_main_1 -> vcp1 */
static struct omap_hwmod_ocp_if dra7xx_l3_main_1__vcp1 = {
	.master		= &dra7xx_l3_main_1_hwmod,
	.slave		= &dra7xx_vcp1_hwmod,
	.clk		= "l3_iclk_div",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* l4_per2 -> vcp1 */
static struct omap_hwmod_ocp_if dra7xx_l4_per2__vcp1 = {
	.master		= &dra7xx_l4_per2_hwmod,
	.slave		= &dra7xx_vcp1_hwmod,
	.clk		= "l3_iclk_div",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* l3_main_1 -> vcp2 */
static struct omap_hwmod_ocp_if dra7xx_l3_main_1__vcp2 = {
	.master		= &dra7xx_l3_main_1_hwmod,
	.slave		= &dra7xx_vcp2_hwmod,
	.clk		= "l3_iclk_div",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* l4_per2 -> vcp2 */
static struct omap_hwmod_ocp_if dra7xx_l4_per2__vcp2 = {
	.master		= &dra7xx_l4_per2_hwmod,
	.slave		= &dra7xx_vcp2_hwmod,
	.clk		= "l3_iclk_div",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* l4_wkup -> wd_timer2 */
static struct omap_hwmod_ocp_if dra7xx_l4_wkup__wd_timer2 = {
	.master		= &dra7xx_l4_wkup_hwmod,
	.slave		= &dra7xx_wd_timer2_hwmod,
	.clk		= "wkupaon_iclk_mux",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

static struct omap_hwmod_ocp_if *dra7xx_hwmod_ocp_ifs[] __initdata = {
	&dra7xx_l3_main_2__l3_instr,
	&dra7xx_l4_cfg__l3_main_1,
	&dra7xx_mpu__l3_main_1,
	&dra7xx_l3_main_1__l3_main_2,
	&dra7xx_l4_cfg__l3_main_2,
	&dra7xx_l3_main_1__l4_cfg,
	&dra7xx_l3_main_1__l4_per1,
	&dra7xx_l3_main_1__l4_per2,
	&dra7xx_l3_main_1__l4_per3,
	&dra7xx_l3_main_1__l4_wkup,
	&dra7xx_l4_per2__atl,
	&dra7xx_l3_main_1__bb2d,
	&dra7xx_l4_wkup__counter_32k,
	&dra7xx_l4_wkup__ctrl_module_wkup,
	&dra7xx_l4_wkup__dcan1,
	&dra7xx_l4_per2__dcan2,
	&dra7xx_l4_cfg__dma_system,
	&dra7xx_l3_main_1__dss,
	&dra7xx_l3_main_1__dispc,
	&dra7xx_l3_main_1__hdmi,
	&dra7xx_l4_per1__elm,
	&dra7xx_l4_wkup__gpio1,
	&dra7xx_l4_per1__gpio2,
	&dra7xx_l4_per1__gpio3,
	&dra7xx_l4_per1__gpio4,
	&dra7xx_l4_per1__gpio5,
	&dra7xx_l4_per1__gpio6,
	&dra7xx_l4_per1__gpio7,
	&dra7xx_l4_per1__gpio8,
	&dra7xx_l3_main_1__gpmc,
	&dra7xx_l4_per1__hdq1w,
	&dra7xx_l4_per1__i2c1,
	&dra7xx_l4_per1__i2c2,
	&dra7xx_l4_per1__i2c3,
	&dra7xx_l4_per1__i2c4,
	&dra7xx_l4_per1__i2c5,
	&dra7xx_l4_per1__mcspi1,
	&dra7xx_l4_per1__mcspi2,
	&dra7xx_l4_per1__mcspi3,
	&dra7xx_l4_per1__mcspi4,
	&dra7xx_l4_per1__mmc1,
	&dra7xx_l4_per1__mmc2,
	&dra7xx_l4_per1__mmc3,
	&dra7xx_l4_per1__mmc4,
	&dra7xx_l4_cfg__mpu,
	&dra7xx_l4_cfg__ocp2scp1,
	&dra7xx_l3_main_1__qspi,
	&dra7xx_l4_cfg__sata,
	&dra7xx_l4_cfg__smartreflex_core,
	&dra7xx_l4_cfg__smartreflex_mpu,
	&dra7xx_l4_cfg__spinlock,
	&dra7xx_l4_wkup__timer1,
	&dra7xx_l4_per1__timer2,
	&dra7xx_l4_per1__timer3,
	&dra7xx_l4_per1__timer4,
	&dra7xx_l4_per3__timer5,
	&dra7xx_l4_per3__timer6,
	&dra7xx_l4_per3__timer7,
	&dra7xx_l4_per3__timer8,
	&dra7xx_l4_per1__timer9,
	&dra7xx_l4_per1__timer10,
	&dra7xx_l4_per1__timer11,
	&dra7xx_l4_per1__uart1,
	&dra7xx_l4_per1__uart2,
	&dra7xx_l4_per1__uart3,
	&dra7xx_l4_per1__uart4,
	&dra7xx_l4_per1__uart5,
	&dra7xx_l4_per1__uart6,
	&dra7xx_l4_per3__usb_otg_ss1,
	&dra7xx_l4_per3__usb_otg_ss2,
	&dra7xx_l4_per3__usb_otg_ss3,
	&dra7xx_l4_per3__usb_otg_ss4,
	&dra7xx_l3_main_1__vcp1,
	&dra7xx_l4_per2__vcp1,
	&dra7xx_l3_main_1__vcp2,
	&dra7xx_l4_per2__vcp2,
	&dra7xx_l4_wkup__wd_timer2,
	NULL,
};

int __init dra7xx_hwmod_init(void)
{
	omap_hwmod_init();
	return omap_hwmod_register_links(dra7xx_hwmod_ocp_ifs);
}
