/*
 * Copyright 2011 Analog Devices Inc.
 *
 * Licensed under the GPL-2 or later.
 */

#ifndef _CDEF_BF60X_H
#define _CDEF_BF60X_H

/* ************************************************************** */
/* SYSTEM & MMR ADDRESS DEFINITIONS COMMON TO ALL ADSP-BF60x    */
/* ************************************************************** */

/* Debug/MP/Emulation Registers (0xFFC00014 - 0xFFC00014) */

#define bfin_read_CHIPID()		bfin_read32(CHIPID)
#define bfin_write_CHIPID(val)		bfin_write32(CHIPID, val)

/* System Reset and Interrubfin_read_()t Controller (0xFFC00100 - 0xFFC00104) */

/* SEC0 Registers */
#define bfin_read_SEC0_CCTL()		bfin_read32(SEC0_CCTL)
#define bfin_write_SEC0_CCTL(val)	bfin_write32(SEC0_CCTL, val)
#define bfin_read_SEC0_CSID()		bfin_read32(SEC0_CSID)
#define bfin_write_SEC0_CSID(val)	bfin_write32(SEC0_CSID, val)
#define bfin_read_SEC_GCTL()		bfin_read32(SEC_GCTL)
#define bfin_write_SEC_GCTL(val)	bfin_write32(SEC_GCTL, val)

#define bfin_read_SEC_FCTL()		bfin_read32(SEC_FCTL)
#define bfin_write_SEC_FCTL(val)	bfin_write32(SEC_FCTL, val)

#define bfin_read_SEC_SCTL(sid)		bfin_read32((SEC_SCTL0 + (sid) * 8))
#define bfin_write_SEC_SCTL(sid, val)	bfin_write32((SEC_SCTL0 + (sid) * 8), val)

#define bfin_read_SEC_SSTAT(sid)	bfin_read32((SEC_SSTAT0 + (sid) * 8))
#define bfin_write_SEC_SSTAT(sid, val)	bfin_write32((SEC_SSTAT0 + (sid) * 8), val)

/* RCU0 Registers */
#define bfin_read_RCU0_CTL()		bfin_read32(RCU0_CTL)
#define bfin_write_RCU0_CTL(val)	bfin_write32(RCU0_CTL, val)

/* Watchdog Timer Registers */
#define bfin_read_WDOG_CTL()		bfin_read16(WDOG_CTL)
#define bfin_write_WDOG_CTL(val)	bfin_write16(WDOG_CTL, val)
#define bfin_read_WDOG_CNT()		bfin_read32(WDOG_CNT)
#define bfin_write_WDOG_CNT(val)	bfin_write32(WDOG_CNT, val)
#define bfin_read_WDOG_STAT()		bfin_read32(WDOG_STAT)
#define bfin_write_WDOG_STAT(val)	bfin_write32(WDOG_STAT, val)

/* RTC Registers */

/* UART0 Registers */

#define bfin_read_UART0_REVID()		bfin_read32(UART0_REVID)
#define bfin_write_UART0_REVID(val)	bfin_write32(UART0_REVID, val)
#define bfin_read_UART0_GCTL()		bfin_read32(UART0_GCTL)
#define bfin_write_UART0_GCTL(val)	bfin_write32(UART0_GCTL, val)
#define bfin_read_UART0_STAT()		bfin_read32(UART0_STAT)
#define bfin_write_UART0_STAT(val)	bfin_write32(UART0_STAT, val)
#define bfin_read_UART0_SCR()		bfin_read32(UART0_SCR)
#define bfin_write_UART0_SCR(val)	bfin_write32(UART0_SCR, val)
#define bfin_read_UART0_CLK()		bfin_read32(UART0_CLK)
#define bfin_write_UART0_CLK(val)	bfin_write32(UART0_CLK, val)
#define bfin_read_UART0_IER()		bfin_read32(UART0_IER)
#define bfin_write_UART0_IER(val)	bfin_write32(UART0_IER, val)
#define bfin_read_UART0_IER_SET()	bfin_read32(UART0_IER_SET)
#define bfin_write_UART0_IER_SET(val)	bfin_write32(UART0_IER_SET, val)
#define bfin_read_UART0_IER_CLEAR()	bfin_read32(UART0_IER_CLEAR)
#define bfin_write_UART0_IER_CLEAR(val)	bfin_write32(UART0_IER_CLEAR, val)
#define bfin_read_UART0_RBR()		bfin_read32(UART0_RBR)
#define bfin_write_UART0_RBR(val)	bfin_write32(UART0_RBR, val)
#define bfin_read_UART0_THR()		bfin_read32(UART0_THR)
#define bfin_write_UART0_THR(val)	bfin_write32(UART0_THR, val)
#define bfin_read_UART0_TAIP()		bfin_read32(UART0_TAIP)
#define bfin_write_UART0_TAIP(val)	bfin_write32(UART0_TAIP, val)
#define bfin_read_UART0_TSR()		bfin_read32(UART0_TSR)
#define bfin_write_UART0_TSR(val)	bfin_write32(UART0_TSR, val)
#define bfin_read_UART0_RSR()		bfin_read32(UART0_RSR)
#define bfin_write_UART0_RSR(val)	bfin_write32(UART0_RSR, val)
#define bfin_read_UART0_TXCNT()		bfin_read32(UART0_TXCNT)
#define bfin_write_UART0_TXCNT(val)	bfin_write32(UART0_TXCNT, val)
#define bfin_read_UART0_RXCNT()		bfin_read32(UART0_RXCNT)
#define bfin_write_UART0_RXCNT(val)	bfin_write32(UART0_RXCNT, val)

/* UART1 Registers */

#define bfin_read_UART1_REVID()		bfin_read32(UART1_REVID)
#define bfin_write_UART1_REVID(val)	bfin_write32(UART1_REVID, val)
#define bfin_read_UART1_GCTL()		bfin_read32(UART1_GCTL)
#define bfin_write_UART1_GCTL(val)	bfin_write32(UART1_GCTL, val)
#define bfin_read_UART1_STAT()		bfin_read32(UART1_STAT)
#define bfin_write_UART1_STAT(val)	bfin_write32(UART1_STAT, val)
#define bfin_read_UART1_SCR()		bfin_read32(UART1_SCR)
#define bfin_write_UART1_SCR(val)	bfin_write32(UART1_SCR, val)
#define bfin_read_UART1_CLK()		bfin_read32(UART1_CLK)
#define bfin_write_UART1_CLK(val)	bfin_write32(UART1_CLK, val)
#define bfin_read_UART1_IER()		bfin_read32(UART1_IER)
#define bfin_write_UART1_IER(val)	bfin_write32(UART1_IER, val)
#define bfin_read_UART1_IER_SET()	bfin_read32(UART1_IER_SET)
#define bfin_write_UART1_IER_SET(val)	bfin_write32(UART1_IER_SET, val)
#define bfin_read_UART1_IER_CLEAR()	bfin_read32(UART1_IER_CLEAR)
#define bfin_write_UART1_IER_CLEAR(val)	bfin_write32(UART1_IER_CLEAR, val)
#define bfin_read_UART1_RBR()		bfin_read32(UART1_RBR)
#define bfin_write_UART1_RBR(val)	bfin_write32(UART1_RBR, val)
#define bfin_read_UART1_THR()		bfin_read32(UART1_THR)
#define bfin_write_UART1_THR(val)	bfin_write32(UART1_THR, val)
#define bfin_read_UART1_TAIP()		bfin_read32(UART1_TAIP)
#define bfin_write_UART1_TAIP(val)	bfin_write32(UART1_TAIP, val)
#define bfin_read_UART1_TSR()		bfin_read32(UART1_TSR)
#define bfin_write_UART1_TSR(val)	bfin_write32(UART1_TSR, val)
#define bfin_read_UART1_RSR()		bfin_read32(UART1_RSR)
#define bfin_write_UART1_RSR(val)	bfin_write32(UART1_RSR, val)
#define bfin_read_UART1_TXCNT()		bfin_read32(UART1_TXCNT)
#define bfin_write_UART1_TXCNT(val)	bfin_write32(UART1_TXCNT, val)
#define bfin_read_UART1_RXCNT()		bfin_read32(UART1_RXCNT)
#define bfin_write_UART1_RXCNT(val)	bfin_write32(UART1_RXCNT, val)


/* SPI0 Registers */

#define bfin_read_SPI0_CTL()		bfin_read32(SPI0_CTL)
#define bfin_write_SPI0_CTL(val)	bfin_write32(SPI0_CTL, val)
#define bfin_read_SPI0_RXCTL()		bfin_read32(SPI0_RXCTL)
#define bfin_write_SPI0_RXCTL(val)	bfin_write32(SPI0_RXCTL, val)
#define bfin_read_SPI0_TXCTL()		bfin_read32(SPI0_TXCTL)
#define bfin_write_SPI0_TXCTL(val)	bfin_write32(SPI0_TXCTL, val)
#define bfin_read_SPI0_CLK()		bfin_read32(SPI0_CLK)
#define bfin_write_SPI0_CLK(val)	bfin_write32(SPI0_CLK, val)
#define bfin_read_SPI0_DLY()		bfin_read32(SPI0_DLY)
#define bfin_write_SPI0_DLY(val)	bfin_write32(SPI0_DLY, val)
#define bfin_read_SPI0_SLVSEL()		bfin_read32(SPI0_SLVSEL)
#define bfin_write_SPI0_SLVSEL(val)	bfin_write32(SPI0_SLVSEL, val)
#define bfin_read_SPI0_RWC()		bfin_read32(SPI0_RWC)
#define bfin_write_SPI0_RWC(val)	bfin_write32(SPI0_RWC, val)
#define bfin_read_SPI0_RWCR()		bfin_read32(SPI0_RWCR)
#define bfin_write_SPI0_RWCR(val)	bfin_write32(SPI0_RWCR, val)
#define bfin_read_SPI0_TWC()		bfin_read32(SPI0_TWC)
#define bfin_write_SPI0_TWC(val)	bfin_write32(SPI0_TWC, val)
#define bfin_read_SPI0_TWCR()		bfin_read32(SPI0_TWCR)
#define bfin_write_SPI0_TWCR(val)	bfin_write32(SPI0_TWCR, val)
#define bfin_read_SPI0_IMSK()		bfin_read32(SPI0_IMSK)
#define bfin_write_SPI0_IMSK(val)	bfin_write32(SPI0_IMSK, val)
#define bfin_read_SPI0_IMSK_CLR()	bfin_read32(SPI0_IMSK_CLR)
#define bfin_write_SPI0_IMSK_CLR(val)	bfin_write32(SPI0_IMSK_CLR, val)
#define bfin_read_SPI0_IMSK_SET()	bfin_read32(SPI0_IMSK_SET)
#define bfin_write_SPI0_IMSK_SET(val)	bfin_write32(SPI0_IMSK_SET, val)
#define bfin_read_SPI0_STAT()		bfin_read32(SPI0_STAT)
#define bfin_write_SPI0_STAT(val)	bfin_write32(SPI0_STAT, val)
#define bfin_read_SPI0_ILAT()		bfin_read32(SPI0_ILAT)
#define bfin_write_SPI0_ILAT(val)	bfin_write32(SPI0_ILAT, val)
#define bfin_read_SPI0_ILAT_CLR()	bfin_read32(SPI0_ILAT_CLR)
#define bfin_write_SPI0_ILAT_CLR(val)	bfin_write32(SPI0_ILAT_CLR, val)
#define bfin_read_SPI0_RFIFO()		bfin_read32(SPI0_RFIFO)
#define bfin_write_SPI0_RFIFO(val)	bfin_write32(SPI0_RFIFO, val)
#define bfin_read_SPI0_TFIFO()		bfin_read32(SPI0_TFIFO)
#define bfin_write_SPI0_TFIFO(val)	bfin_write32(SPI0_TFIFO, val)

/* SPI1 Registers */

#define bfin_read_SPI1_CTL()		bfin_read32(SPI1_CTL)
#define bfin_write_SPI1_CTL(val)	bfin_write32(SPI1_CTL, val)
#define bfin_read_SPI1_RXCTL()		bfin_read32(SPI1_RXCTL)
#define bfin_write_SPI1_RXCTL(val)	bfin_write32(SPI1_RXCTL, val)
#define bfin_read_SPI1_TXCTL()		bfin_read32(SPI1_TXCTL)
#define bfin_write_SPI1_TXCTL(val)	bfin_write32(SPI1_TXCTL, val)
#define bfin_read_SPI1_CLK()		bfin_read32(SPI1_CLK)
#define bfin_write_SPI1_CLK(val)	bfin_write32(SPI1_CLK, val)
#define bfin_read_SPI1_DLY()		bfin_read32(SPI1_DLY)
#define bfin_write_SPI1_DLY(val)	bfin_write32(SPI1_DLY, val)
#define bfin_read_SPI1_SLVSEL()		bfin_read32(SPI1_SLVSEL)
#define bfin_write_SPI1_SLVSEL(val)	bfin_write32(SPI1_SLVSEL, val)
#define bfin_read_SPI1_RWC()		bfin_read32(SPI1_RWC)
#define bfin_write_SPI1_RWC(val)	bfin_write32(SPI1_RWC, val)
#define bfin_read_SPI1_RWCR()		bfin_read32(SPI1_RWCR)
#define bfin_write_SPI1_RWCR(val)	bfin_write32(SPI1_RWCR, val)
#define bfin_read_SPI1_TWC()		bfin_read32(SPI1_TWC)
#define bfin_write_SPI1_TWC(val)	bfin_write32(SPI1_TWC, val)
#define bfin_read_SPI1_TWCR()		bfin_read32(SPI1_TWCR)
#define bfin_write_SPI1_TWCR(val)	bfin_write32(SPI1_TWCR, val)
#define bfin_read_SPI1_IMSK()		bfin_read32(SPI1_IMSK)
#define bfin_write_SPI1_IMSK(val)	bfin_write32(SPI1_IMSK, val)
#define bfin_read_SPI1_IMSK_CLR()	bfin_read32(SPI1_IMSK_CLR)
#define bfin_write_SPI1_IMSK_CLR(val)	bfin_write32(SPI1_IMSK_CLR, val)
#define bfin_read_SPI1_IMSK_SET()	bfin_read32(SPI1_IMSK_SET)
#define bfin_write_SPI1_IMSK_SET(val)	bfin_write32(SPI1_IMSK_SET, val)
#define bfin_read_SPI1_STAT()		bfin_read32(SPI1_STAT)
#define bfin_write_SPI1_STAT(val)	bfin_write32(SPI1_STAT, val)
#define bfin_read_SPI1_ILAT()		bfin_read32(SPI1_ILAT)
#define bfin_write_SPI1_ILAT(val)	bfin_write32(SPI1_ILAT, val)
#define bfin_read_SPI1_ILAT_CLR()	bfin_read32(SPI1_ILAT_CLR)
#define bfin_write_SPI1_ILAT_CLR(val)	bfin_write32(SPI1_ILAT_CLR, val)
#define bfin_read_SPI1_RFIFO()		bfin_read32(SPI1_RFIFO)
#define bfin_write_SPI1_RFIFO(val)	bfin_write32(SPI1_RFIFO, val)
#define bfin_read_SPI1_TFIFO()		bfin_read32(SPI1_TFIFO)
#define bfin_write_SPI1_TFIFO(val)	bfin_write32(SPI1_TFIFO, val)

/* Timer 0-7 registers */
#define bfin_read_TIMER0_CONFIG()            bfin_read16(TIMER0_CONFIG)
#define bfin_write_TIMER0_CONFIG(val)        bfin_write16(TIMER0_CONFIG, val)
#define bfin_read_TIMER0_COUNTER()           bfin_read32(TIMER0_COUNTER)
#define bfin_write_TIMER0_COUNTER(val)       bfin_write32(TIMER0_COUNTER, val)
#define bfin_read_TIMER0_PERIOD()            bfin_read32(TIMER0_PERIOD)
#define bfin_write_TIMER0_PERIOD(val)        bfin_write32(TIMER0_PERIOD, val)
#define bfin_read_TIMER0_WIDTH()             bfin_read32(TIMER0_WIDTH)
#define bfin_write_TIMER0_WIDTH(val)         bfin_write32(TIMER0_WIDTH, val)
#define bfin_read_TIMER1_CONFIG()            bfin_read16(TIMER1_CONFIG)
#define bfin_write_TIMER1_CONFIG(val)        bfin_write16(TIMER1_CONFIG, val)
#define bfin_read_TIMER1_COUNTER()           bfin_read32(TIMER1_COUNTER)
#define bfin_write_TIMER1_COUNTER(val)       bfin_write32(TIMER1_COUNTER, val)
#define bfin_read_TIMER1_PERIOD()            bfin_read32(TIMER1_PERIOD)
#define bfin_write_TIMER1_PERIOD(val)        bfin_write32(TIMER1_PERIOD, val)
#define bfin_read_TIMER1_WIDTH()             bfin_read32(TIMER1_WIDTH)
#define bfin_write_TIMER1_WIDTH(val)         bfin_write32(TIMER1_WIDTH, val)
#define bfin_read_TIMER2_CONFIG()            bfin_read16(TIMER2_CONFIG)
#define bfin_write_TIMER2_CONFIG(val)        bfin_write16(TIMER2_CONFIG, val)
#define bfin_read_TIMER2_COUNTER()           bfin_read32(TIMER2_COUNTER)
#define bfin_write_TIMER2_COUNTER(val)       bfin_write32(TIMER2_COUNTER, val)
#define bfin_read_TIMER2_PERIOD()            bfin_read32(TIMER2_PERIOD)
#define bfin_write_TIMER2_PERIOD(val)        bfin_write32(TIMER2_PERIOD, val)
#define bfin_read_TIMER2_WIDTH()             bfin_read32(TIMER2_WIDTH)
#define bfin_write_TIMER2_WIDTH(val)         bfin_write32(TIMER2_WIDTH, val)
#define bfin_read_TIMER3_CONFIG()            bfin_read16(TIMER3_CONFIG)
#define bfin_write_TIMER3_CONFIG(val)        bfin_write16(TIMER3_CONFIG, val)
#define bfin_read_TIMER3_COUNTER()           bfin_read32(TIMER3_COUNTER)
#define bfin_write_TIMER3_COUNTER(val)       bfin_write32(TIMER3_COUNTER, val)
#define bfin_read_TIMER3_PERIOD()            bfin_read32(TIMER3_PERIOD)
#define bfin_write_TIMER3_PERIOD(val)        bfin_write32(TIMER3_PERIOD, val)
#define bfin_read_TIMER3_WIDTH()             bfin_read32(TIMER3_WIDTH)
#define bfin_write_TIMER3_WIDTH(val)         bfin_write32(TIMER3_WIDTH, val)
#define bfin_read_TIMER4_CONFIG()            bfin_read16(TIMER4_CONFIG)
#define bfin_write_TIMER4_CONFIG(val)        bfin_write16(TIMER4_CONFIG, val)
#define bfin_read_TIMER4_COUNTER()           bfin_read32(TIMER4_COUNTER)
#define bfin_write_TIMER4_COUNTER(val)       bfin_write32(TIMER4_COUNTER, val)
#define bfin_read_TIMER4_PERIOD()            bfin_read32(TIMER4_PERIOD)
#define bfin_write_TIMER4_PERIOD(val)        bfin_write32(TIMER4_PERIOD, val)
#define bfin_read_TIMER4_WIDTH()             bfin_read32(TIMER4_WIDTH)
#define bfin_write_TIMER4_WIDTH(val)         bfin_write32(TIMER4_WIDTH, val)
#define bfin_read_TIMER5_CONFIG()            bfin_read16(TIMER5_CONFIG)
#define bfin_write_TIMER5_CONFIG(val)        bfin_write16(TIMER5_CONFIG, val)
#define bfin_read_TIMER5_COUNTER()           bfin_read32(TIMER5_COUNTER)
#define bfin_write_TIMER5_COUNTER(val)       bfin_write32(TIMER5_COUNTER, val)
#define bfin_read_TIMER5_PERIOD()            bfin_read32(TIMER5_PERIOD)
#define bfin_write_TIMER5_PERIOD(val)        bfin_write32(TIMER5_PERIOD, val)
#define bfin_read_TIMER5_WIDTH()             bfin_read32(TIMER5_WIDTH)
#define bfin_write_TIMER5_WIDTH(val)         bfin_write32(TIMER5_WIDTH, val)
#define bfin_read_TIMER6_CONFIG()            bfin_read16(TIMER6_CONFIG)
#define bfin_write_TIMER6_CONFIG(val)        bfin_write16(TIMER6_CONFIG, val)
#define bfin_read_TIMER6_COUNTER()           bfin_read32(TIMER6_COUNTER)
#define bfin_write_TIMER6_COUNTER(val)       bfin_write32(TIMER6_COUNTER, val)
#define bfin_read_TIMER6_PERIOD()            bfin_read32(TIMER6_PERIOD)
#define bfin_write_TIMER6_PERIOD(val)        bfin_write32(TIMER6_PERIOD, val)
#define bfin_read_TIMER6_WIDTH()             bfin_read32(TIMER6_WIDTH)
#define bfin_write_TIMER6_WIDTH(val)         bfin_write32(TIMER6_WIDTH, val)
#define bfin_read_TIMER7_CONFIG()            bfin_read16(TIMER7_CONFIG)
#define bfin_write_TIMER7_CONFIG(val)        bfin_write16(TIMER7_CONFIG, val)
#define bfin_read_TIMER7_COUNTER()           bfin_read32(TIMER7_COUNTER)
#define bfin_write_TIMER7_COUNTER(val)       bfin_write32(TIMER7_COUNTER, val)
#define bfin_read_TIMER7_PERIOD()            bfin_read32(TIMER7_PERIOD)
#define bfin_write_TIMER7_PERIOD(val)        bfin_write32(TIMER7_PERIOD, val)
#define bfin_read_TIMER7_WIDTH()             bfin_read32(TIMER7_WIDTH)
#define bfin_write_TIMER7_WIDTH(val)         bfin_write32(TIMER7_WIDTH, val)




/* Two Wire Interface Registers (TWI0) */

/* SPORT1 Registers */


/* SMC Registers */
#define bfin_read_SMC_GCTL() bfin_read32(SMC_GCTL)
#define bfin_write_SMC_GCTL(val) bfin_write32(SMC_GCTL, val)
#define bfin_read_SMC_GSTAT() bfin_read32(SMC_GSTAT)
#define bfin_read_SMC_B0CTL() bfin_read32(SMC_B0CTL)
#define bfin_write_SMC_B0CTL(val) bfin_write32(SMC_B0CTL, val)
#define bfin_read_SMC_B0TIM() bfin_read32(SMC_B0TIM)
#define bfin_write_SMC_B0TIM(val) bfin_write32(SMC_B0TIM, val)
#define bfin_read_SMC_B0ETIM() bfin_read32(SMC_B0ETIM)
#define bfin_write_SMC_B0ETIM(val) bfin_write32(SMC_B0ETIM, val)
#define bfin_read_SMC_B1CTL() bfin_read32(SMC_B1CTL)
#define bfin_write_SMC_B1CTL(val) bfin_write32(SMC_B1CTL, val)
#define bfin_read_SMC_B1TIM() bfin_read32(SMC_B1TIM)
#define bfin_write_SMC_B1TIM(val) bfin_write32(SMC_B1TIM, val)
#define bfin_read_SMC_B1ETIM() bfin_read32(SMC_B1ETIM)
#define bfin_write_SMC_B1ETIM(val) bfin_write32(SMC_B1ETIM, val)
#define bfin_read_SMC_B2CTL() bfin_read32(SMC_B2CTL)
#define bfin_write_SMC_B2CTL(val) bfin_write32(SMC_B2CTL, val)
#define bfin_read_SMC_B2TIM() bfin_read32(SMC_B2TIM)
#define bfin_write_SMC_B2TIM(val) bfin_write32(SMC_B2TIM, val)
#define bfin_read_SMC_B2ETIM() bfin_read32(SMC_B2ETIM)
#define bfin_write_SMC_B2ETIM(val) bfin_write32(SMC_B2ETIM, val)
#define bfin_read_SMC_B3CTL() bfin_read32(SMC_B3CTL)
#define bfin_write_SMC_B3CTL(val) bfin_write32(SMC_B3CTL, val)
#define bfin_read_SMC_B3TIM() bfin_read32(SMC_B3TIM)
#define bfin_write_SMC_B3TIM(val) bfin_write32(SMC_B3TIM, val)
#define bfin_read_SMC_B3ETIM() bfin_read32(SMC_B3ETIM)
#define bfin_write_SMC_B3ETIM(val) bfin_write32(SMC_B3ETIM, val)

/* DDR2 Memory Control Registers */
#define bfin_read_DMC0_CFG() bfin_read32(DMC0_CFG)
#define bfin_write_DMC0_CFG(val) bfin_write32(DMC0_CFG, val)
#define bfin_read_DMC0_TR0() bfin_read32(DMC0_TR0)
#define bfin_write_DMC0_TR0(val) bfin_write32(DMC0_TR0, val)
#define bfin_read_DMC0_TR1() bfin_read32(DMC0_TR1)
#define bfin_write_DMC0_TR1(val) bfin_write32(DMC0_TR1, val)
#define bfin_read_DMC0_TR2() bfin_read32(DMC0_TR2)
#define bfin_write_DMC0_TR2(val) bfin_write32(DMC0_TR2, val)
#define bfin_read_DMC0_MR() bfin_read32(DMC0_MR)
#define bfin_write_DMC0_MR(val) bfin_write32(DMC0_MR, val)
#define bfin_read_DMC0_EMR1() bfin_read32(DMC0_EMR1)
#define bfin_write_DMC0_EMR1(val) bfin_write32(DMC0_EMR1, val)
#define bfin_read_DMC0_CTL() bfin_read32(DMC0_CTL)
#define bfin_write_DMC0_CTL(val) bfin_write32(DMC0_CTL, val)
#define bfin_read_DMC0_STAT() bfin_read32(DMC0_STAT)
#define bfin_write_DMC0_STAT(val) bfin_write32(DMC0_STAT, val)
#define bfin_read_DMC0_DLLCTL() bfin_read32(DMC0_DLLCTL)
#define bfin_write_DMC0_DLLCTL(val) bfin_write32(DMC0_DLLCTL, val)

/* DDR BankRead and Write Count Registers */


/* DMA Channel 0 Registers */

#define bfin_read_DMA0_NEXT_DESC_PTR() 		bfin_read32(DMA0_NEXT_DESC_PTR)
#define bfin_write_DMA0_NEXT_DESC_PTR(val) 	bfin_write32(DMA0_NEXT_DESC_PTR, val)
#define bfin_read_DMA0_START_ADDR() 		bfin_read32(DMA0_START_ADDR)
#define bfin_write_DMA0_START_ADDR(val) 	bfin_write32(DMA0_START_ADDR, val)
#define bfin_read_DMA0_CONFIG()			bfin_read32(DMA0_CONFIG)
#define bfin_write_DMA0_CONFIG(val)		bfin_write32(DMA0_CONFIG, val)
#define bfin_read_DMA0_X_COUNT()		bfin_read32(DMA0_X_COUNT)
#define bfin_write_DMA0_X_COUNT(val)		bfin_write32(DMA0_X_COUNT, val)
#define bfin_read_DMA0_X_MODIFY()		bfin_read32(DMA0_X_MODIFY)
#define bfin_write_DMA0_X_MODIFY(val) 		bfin_write32(DMA0_X_MODIFY, val)
#define bfin_read_DMA0_Y_COUNT()		bfin_read32(DMA0_Y_COUNT)
#define bfin_write_DMA0_Y_COUNT(val)		bfin_write32(DMA0_Y_COUNT, val)
#define bfin_read_DMA0_Y_MODIFY()		bfin_read32(DMA0_Y_MODIFY)
#define bfin_write_DMA0_Y_MODIFY(val) 		bfin_write32(DMA0_Y_MODIFY, val)
#define bfin_read_DMA0_CURR_DESC_PTR() 		bfin_read32(DMA0_CURR_DESC_PTR)
#define bfin_write_DMA0_CURR_DESC_PTR(val) 	bfin_write32(DMA0_CURR_DESC_PTR, val)
#define bfin_read_DMA0_PREV_DESC_PTR() 		bfin_read32(DMA0_PREV_DESC_PTR)
#define bfin_write_DMA0_PREV_DESC_PTR(val) 	bfin_write32(DMA0_PREV_DESC_PTR, val)
#define bfin_read_DMA0_CURR_ADDR() 		bfin_read32(DMA0_CURR_ADDR)
#define bfin_write_DMA0_CURR_ADDR(val) 		bfin_write32(DMA0_CURR_ADDR, val)
#define bfin_read_DMA0_IRQ_STATUS()		bfin_read32(DMA0_IRQ_STATUS)
#define bfin_write_DMA0_IRQ_STATUS(val)		bfin_write32(DMA0_IRQ_STATUS, val)
#define bfin_read_DMA0_CURR_X_COUNT()		bfin_read32(DMA0_CURR_X_COUNT)
#define bfin_write_DMA0_CURR_X_COUNT(val)	bfin_write32(DMA0_CURR_X_COUNT, val)
#define bfin_read_DMA0_CURR_Y_COUNT()		bfin_read32(DMA0_CURR_Y_COUNT)
#define bfin_write_DMA0_CURR_Y_COUNT(val)	bfin_write32(DMA0_CURR_Y_COUNT, val)
#define bfin_read_DMA0_BWL_COUNT()		bfin_read32(DMA0_BWL_COUNT)
#define bfin_write_DMA0_BWL_COUNT(val)		bfin_write32(DMA0_BWL_COUNT, val)
#define bfin_read_DMA0_CURR_BWL_COUNT()		bfin_read32(DMA0_CURR_BWL_COUNT)
#define bfin_write_DMA0_CURR_BWL_COUNT(val)	bfin_write32(DMA0_CURR_BWL_COUNT, val)
#define bfin_read_DMA0_BWM_COUNT()		bfin_read32(DMA0_BWM_COUNT)
#define bfin_write_DMA0_BWM_COUNT(val)		bfin_write32(DMA0_BWM_COUNT, val)
#define bfin_read_DMA0_CURR_BWM_COUNT()		bfin_read32(DMA0_CURR_BWM_COUNT)
#define bfin_write_DMA0_CURR_BWM_COUNT(val)	bfin_write32(DMA0_CURR_BWM_COUNT, val)

/* DMA Channel 1 Registers */

#define bfin_read_DMA1_NEXT_DESC_PTR() 		bfin_read32(DMA1_NEXT_DESC_PTR)
#define bfin_write_DMA1_NEXT_DESC_PTR(val) 	bfin_write32(DMA1_NEXT_DESC_PTR, val)
#define bfin_read_DMA1_START_ADDR() 		bfin_read32(DMA1_START_ADDR)
#define bfin_write_DMA1_START_ADDR(val) 	bfin_write32(DMA1_START_ADDR, val)
#define bfin_read_DMA1_CONFIG()			bfin_read32(DMA1_CONFIG)
#define bfin_write_DMA1_CONFIG(val)		bfin_write32(DMA1_CONFIG, val)
#define bfin_read_DMA1_X_COUNT()		bfin_read32(DMA1_X_COUNT)
#define bfin_write_DMA1_X_COUNT(val)		bfin_write32(DMA1_X_COUNT, val)
#define bfin_read_DMA1_X_MODIFY()		bfin_read32(DMA1_X_MODIFY)
#define bfin_write_DMA1_X_MODIFY(val) 		bfin_write32(DMA1_X_MODIFY, val)
#define bfin_read_DMA1_Y_COUNT()		bfin_read32(DMA1_Y_COUNT)
#define bfin_write_DMA1_Y_COUNT(val)		bfin_write32(DMA1_Y_COUNT, val)
#define bfin_read_DMA1_Y_MODIFY()		bfin_read32(DMA1_Y_MODIFY)
#define bfin_write_DMA1_Y_MODIFY(val) 		bfin_write32(DMA1_Y_MODIFY, val)
#define bfin_read_DMA1_CURR_DESC_PTR() 		bfin_read32(DMA1_CURR_DESC_PTR)
#define bfin_write_DMA1_CURR_DESC_PTR(val) 	bfin_write32(DMA1_CURR_DESC_PTR, val)
#define bfin_read_DMA1_PREV_DESC_PTR() 		bfin_read32(DMA1_PREV_DESC_PTR)
#define bfin_write_DMA1_PREV_DESC_PTR(val) 	bfin_write32(DMA1_PREV_DESC_PTR, val)
#define bfin_read_DMA1_CURR_ADDR() 		bfin_read32(DMA1_CURR_ADDR)
#define bfin_write_DMA1_CURR_ADDR(val) 		bfin_write32(DMA1_CURR_ADDR, val)
#define bfin_read_DMA1_IRQ_STATUS()		bfin_read32(DMA1_IRQ_STATUS)
#define bfin_write_DMA1_IRQ_STATUS(val)		bfin_write32(DMA1_IRQ_STATUS, val)
#define bfin_read_DMA1_CURR_X_COUNT()		bfin_read32(DMA1_CURR_X_COUNT)
#define bfin_write_DMA1_CURR_X_COUNT(val)	bfin_write32(DMA1_CURR_X_COUNT, val)
#define bfin_read_DMA1_CURR_Y_COUNT()		bfin_read32(DMA1_CURR_Y_COUNT)
#define bfin_write_DMA1_CURR_Y_COUNT(val)	bfin_write32(DMA1_CURR_Y_COUNT, val)
#define bfin_read_DMA1_BWL_COUNT()		bfin_read32(DMA1_BWL_COUNT)
#define bfin_write_DMA1_BWL_COUNT(val)		bfin_write32(DMA1_BWL_COUNT, val)
#define bfin_read_DMA1_CURR_BWL_COUNT()		bfin_read32(DMA1_CURR_BWL_COUNT)
#define bfin_write_DMA1_CURR_BWL_COUNT(val)	bfin_write32(DMA1_CURR_BWL_COUNT, val)
#define bfin_read_DMA1_BWM_COUNT()		bfin_read32(DMA1_BWM_COUNT)
#define bfin_write_DMA1_BWM_COUNT(val)		bfin_write32(DMA1_BWM_COUNT, val)
#define bfin_read_DMA1_CURR_BWM_COUNT()		bfin_read32(DMA1_CURR_BWM_COUNT)
#define bfin_write_DMA1_CURR_BWM_COUNT(val)	bfin_write32(DMA1_CURR_BWM_COUNT, val)

/* DMA Channel 2 Registers */

#define bfin_read_DMA2_NEXT_DESC_PTR() 		bfin_read32(DMA2_NEXT_DESC_PTR)
#define bfin_write_DMA2_NEXT_DESC_PTR(val) 	bfin_write32(DMA2_NEXT_DESC_PTR, val)
#define bfin_read_DMA2_START_ADDR() 		bfin_read32(DMA2_START_ADDR)
#define bfin_write_DMA2_START_ADDR(val) 	bfin_write32(DMA2_START_ADDR, val)
#define bfin_read_DMA2_CONFIG()			bfin_read32(DMA2_CONFIG)
#define bfin_write_DMA2_CONFIG(val)		bfin_write32(DMA2_CONFIG, val)
#define bfin_read_DMA2_X_COUNT()		bfin_read32(DMA2_X_COUNT)
#define bfin_write_DMA2_X_COUNT(val)		bfin_write32(DMA2_X_COUNT, val)
#define bfin_read_DMA2_X_MODIFY()		bfin_read32(DMA2_X_MODIFY)
#define bfin_write_DMA2_X_MODIFY(val) 		bfin_write32(DMA2_X_MODIFY, val)
#define bfin_read_DMA2_Y_COUNT()		bfin_read32(DMA2_Y_COUNT)
#define bfin_write_DMA2_Y_COUNT(val)		bfin_write32(DMA2_Y_COUNT, val)
#define bfin_read_DMA2_Y_MODIFY()		bfin_read32(DMA2_Y_MODIFY)
#define bfin_write_DMA2_Y_MODIFY(val) 		bfin_write32(DMA2_Y_MODIFY, val)
#define bfin_read_DMA2_CURR_DESC_PTR() 		bfin_read32(DMA2_CURR_DESC_PTR)
#define bfin_write_DMA2_CURR_DESC_PTR(val) 	bfin_write32(DMA2_CURR_DESC_PTR, val)
#define bfin_read_DMA2_PREV_DESC_PTR() 		bfin_read32(DMA2_PREV_DESC_PTR)
#define bfin_write_DMA2_PREV_DESC_PTR(val) 	bfin_write32(DMA2_PREV_DESC_PTR, val)
#define bfin_read_DMA2_CURR_ADDR() 		bfin_read32(DMA2_CURR_ADDR)
#define bfin_write_DMA2_CURR_ADDR(val) 		bfin_write32(DMA2_CURR_ADDR, val)
#define bfin_read_DMA2_IRQ_STATUS()		bfin_read32(DMA2_IRQ_STATUS)
#define bfin_write_DMA2_IRQ_STATUS(val)		bfin_write32(DMA2_IRQ_STATUS, val)
#define bfin_read_DMA2_CURR_X_COUNT()		bfin_read32(DMA2_CURR_X_COUNT)
#define bfin_write_DMA2_CURR_X_COUNT(val)	bfin_write32(DMA2_CURR_X_COUNT, val)
#define bfin_read_DMA2_CURR_Y_COUNT()		bfin_read32(DMA2_CURR_Y_COUNT)
#define bfin_write_DMA2_CURR_Y_COUNT(val)	bfin_write32(DMA2_CURR_Y_COUNT, val)
#define bfin_read_DMA2_BWL_COUNT()		bfin_read32(DMA2_BWL_COUNT)
#define bfin_write_DMA2_BWL_COUNT(val)		bfin_write32(DMA2_BWL_COUNT, val)
#define bfin_read_DMA2_CURR_BWL_COUNT()		bfin_read32(DMA2_CURR_BWL_COUNT)
#define bfin_write_DMA2_CURR_BWL_COUNT(val)	bfin_write32(DMA2_CURR_BWL_COUNT, val)
#define bfin_read_DMA2_BWM_COUNT()		bfin_read32(DMA2_BWM_COUNT)
#define bfin_write_DMA2_BWM_COUNT(val)		bfin_write32(DMA2_BWM_COUNT, val)
#define bfin_read_DMA2_CURR_BWM_COUNT()		bfin_read32(DMA2_CURR_BWM_COUNT)
#define bfin_write_DMA2_CURR_BWM_COUNT(val)	bfin_write32(DMA2_CURR_BWM_COUNT, val)

/* DMA Channel 3 Registers */

#define bfin_read_DMA3_NEXT_DESC_PTR() 		bfin_read32(DMA3_NEXT_DESC_PTR)
#define bfin_write_DMA3_NEXT_DESC_PTR(val) 	bfin_write32(DMA3_NEXT_DESC_PTR, val)
#define bfin_read_DMA3_START_ADDR() 		bfin_read32(DMA3_START_ADDR)
#define bfin_write_DMA3_START_ADDR(val) 	bfin_write32(DMA3_START_ADDR, val)
#define bfin_read_DMA3_CONFIG()			bfin_read32(DMA3_CONFIG)
#define bfin_write_DMA3_CONFIG(val)		bfin_write32(DMA3_CONFIG, val)
#define bfin_read_DMA3_X_COUNT()		bfin_read32(DMA3_X_COUNT)
#define bfin_write_DMA3_X_COUNT(val)		bfin_write32(DMA3_X_COUNT, val)
#define bfin_read_DMA3_X_MODIFY()		bfin_read32(DMA3_X_MODIFY)
#define bfin_write_DMA3_X_MODIFY(val) 		bfin_write32(DMA3_X_MODIFY, val)
#define bfin_read_DMA3_Y_COUNT()		bfin_read32(DMA3_Y_COUNT)
#define bfin_write_DMA3_Y_COUNT(val)		bfin_write32(DMA3_Y_COUNT, val)
#define bfin_read_DMA3_Y_MODIFY()		bfin_read32(DMA3_Y_MODIFY)
#define bfin_write_DMA3_Y_MODIFY(val) 		bfin_write32(DMA3_Y_MODIFY, val)
#define bfin_read_DMA3_CURR_DESC_PTR() 		bfin_read32(DMA3_CURR_DESC_PTR)
#define bfin_write_DMA3_CURR_DESC_PTR(val) 	bfin_write32(DMA3_CURR_DESC_PTR, val)
#define bfin_read_DMA3_PREV_DESC_PTR() 		bfin_read32(DMA3_PREV_DESC_PTR)
#define bfin_write_DMA3_PREV_DESC_PTR(val) 	bfin_write32(DMA3_PREV_DESC_PTR, val)
#define bfin_read_DMA3_CURR_ADDR() 		bfin_read32(DMA3_CURR_ADDR)
#define bfin_write_DMA3_CURR_ADDR(val) 		bfin_write32(DMA3_CURR_ADDR, val)
#define bfin_read_DMA3_IRQ_STATUS()		bfin_read32(DMA3_IRQ_STATUS)
#define bfin_write_DMA3_IRQ_STATUS(val)		bfin_write32(DMA3_IRQ_STATUS, val)
#define bfin_read_DMA3_CURR_X_COUNT()		bfin_read32(DMA3_CURR_X_COUNT)
#define bfin_write_DMA3_CURR_X_COUNT(val)	bfin_write32(DMA3_CURR_X_COUNT, val)
#define bfin_read_DMA3_CURR_Y_COUNT()		bfin_read32(DMA3_CURR_Y_COUNT)
#define bfin_write_DMA3_CURR_Y_COUNT(val)	bfin_write32(DMA3_CURR_Y_COUNT, val)
#define bfin_read_DMA3_BWL_COUNT()		bfin_read32(DMA3_BWL_COUNT)
#define bfin_write_DMA3_BWL_COUNT(val)		bfin_write32(DMA3_BWL_COUNT, val)
#define bfin_read_DMA3_CURR_BWL_COUNT()		bfin_read32(DMA3_CURR_BWL_COUNT)
#define bfin_write_DMA3_CURR_BWL_COUNT(val)	bfin_write32(DMA3_CURR_BWL_COUNT, val)
#define bfin_read_DMA3_BWM_COUNT()		bfin_read32(DMA3_BWM_COUNT)
#define bfin_write_DMA3_BWM_COUNT(val)		bfin_write32(DMA3_BWM_COUNT, val)
#define bfin_read_DMA3_CURR_BWM_COUNT()		bfin_read32(DMA3_CURR_BWM_COUNT)
#define bfin_write_DMA3_CURR_BWM_COUNT(val)	bfin_write32(DMA3_CURR_BWM_COUNT, val)

/* DMA Channel 4 Registers */

#define bfin_read_DMA4_NEXT_DESC_PTR() 		bfin_read32(DMA4_NEXT_DESC_PTR)
#define bfin_write_DMA4_NEXT_DESC_PTR(val) 	bfin_write32(DMA4_NEXT_DESC_PTR, val)
#define bfin_read_DMA4_START_ADDR() 		bfin_read32(DMA4_START_ADDR)
#define bfin_write_DMA4_START_ADDR(val) 	bfin_write32(DMA4_START_ADDR, val)
#define bfin_read_DMA4_CONFIG()			bfin_read32(DMA4_CONFIG)
#define bfin_write_DMA4_CONFIG(val)		bfin_write32(DMA4_CONFIG, val)
#define bfin_read_DMA4_X_COUNT()		bfin_read32(DMA4_X_COUNT)
#define bfin_write_DMA4_X_COUNT(val)		bfin_write32(DMA4_X_COUNT, val)
#define bfin_read_DMA4_X_MODIFY()		bfin_read32(DMA4_X_MODIFY)
#define bfin_write_DMA4_X_MODIFY(val) 		bfin_write32(DMA4_X_MODIFY, val)
#define bfin_read_DMA4_Y_COUNT()		bfin_read32(DMA4_Y_COUNT)
#define bfin_write_DMA4_Y_COUNT(val)		bfin_write32(DMA4_Y_COUNT, val)
#define bfin_read_DMA4_Y_MODIFY()		bfin_read32(DMA4_Y_MODIFY)
#define bfin_write_DMA4_Y_MODIFY(val) 		bfin_write32(DMA4_Y_MODIFY, val)
#define bfin_read_DMA4_CURR_DESC_PTR() 		bfin_read32(DMA4_CURR_DESC_PTR)
#define bfin_write_DMA4_CURR_DESC_PTR(val) 	bfin_write32(DMA4_CURR_DESC_PTR, val)
#define bfin_read_DMA4_PREV_DESC_PTR() 		bfin_read32(DMA4_PREV_DESC_PTR)
#define bfin_write_DMA4_PREV_DESC_PTR(val) 	bfin_write32(DMA4_PREV_DESC_PTR, val)
#define bfin_read_DMA4_CURR_ADDR() 		bfin_read32(DMA4_CURR_ADDR)
#define bfin_write_DMA4_CURR_ADDR(val) 		bfin_write32(DMA4_CURR_ADDR, val)
#define bfin_read_DMA4_IRQ_STATUS()		bfin_read32(DMA4_IRQ_STATUS)
#define bfin_write_DMA4_IRQ_STATUS(val)		bfin_write32(DMA4_IRQ_STATUS, val)
#define bfin_read_DMA4_CURR_X_COUNT()		bfin_read32(DMA4_CURR_X_COUNT)
#define bfin_write_DMA4_CURR_X_COUNT(val)	bfin_write32(DMA4_CURR_X_COUNT, val)
#define bfin_read_DMA4_CURR_Y_COUNT()		bfin_read32(DMA4_CURR_Y_COUNT)
#define bfin_write_DMA4_CURR_Y_COUNT(val)	bfin_write32(DMA4_CURR_Y_COUNT, val)
#define bfin_read_DMA4_BWL_COUNT()		bfin_read32(DMA4_BWL_COUNT)
#define bfin_write_DMA4_BWL_COUNT(val)		bfin_write32(DMA4_BWL_COUNT, val)
#define bfin_read_DMA4_CURR_BWL_COUNT()		bfin_read32(DMA4_CURR_BWL_COUNT)
#define bfin_write_DMA4_CURR_BWL_COUNT(val)	bfin_write32(DMA4_CURR_BWL_COUNT, val)
#define bfin_read_DMA4_BWM_COUNT()		bfin_read32(DMA4_BWM_COUNT)
#define bfin_write_DMA4_BWM_COUNT(val)		bfin_write32(DMA4_BWM_COUNT, val)
#define bfin_read_DMA4_CURR_BWM_COUNT()		bfin_read32(DMA4_CURR_BWM_COUNT)
#define bfin_write_DMA4_CURR_BWM_COUNT(val)	bfin_write32(DMA4_CURR_BWM_COUNT, val)

/* DMA Channel 5 Registers */

#define bfin_read_DMA5_NEXT_DESC_PTR() 		bfin_read32(DMA5_NEXT_DESC_PTR)
#define bfin_write_DMA5_NEXT_DESC_PTR(val) 	bfin_write32(DMA5_NEXT_DESC_PTR, val)
#define bfin_read_DMA5_START_ADDR() 		bfin_read32(DMA5_START_ADDR)
#define bfin_write_DMA5_START_ADDR(val) 	bfin_write32(DMA5_START_ADDR, val)
#define bfin_read_DMA5_CONFIG()			bfin_read32(DMA5_CONFIG)
#define bfin_write_DMA5_CONFIG(val)		bfin_write32(DMA5_CONFIG, val)
#define bfin_read_DMA5_X_COUNT()		bfin_read32(DMA5_X_COUNT)
#define bfin_write_DMA5_X_COUNT(val)		bfin_write32(DMA5_X_COUNT, val)
#define bfin_read_DMA5_X_MODIFY()		bfin_read32(DMA5_X_MODIFY)
#define bfin_write_DMA5_X_MODIFY(val) 		bfin_write32(DMA5_X_MODIFY, val)
#define bfin_read_DMA5_Y_COUNT()		bfin_read32(DMA5_Y_COUNT)
#define bfin_write_DMA5_Y_COUNT(val)		bfin_write32(DMA5_Y_COUNT, val)
#define bfin_read_DMA5_Y_MODIFY()		bfin_read32(DMA5_Y_MODIFY)
#define bfin_write_DMA5_Y_MODIFY(val) 		bfin_write32(DMA5_Y_MODIFY, val)
#define bfin_read_DMA5_CURR_DESC_PTR() 		bfin_read32(DMA5_CURR_DESC_PTR)
#define bfin_write_DMA5_CURR_DESC_PTR(val) 	bfin_write32(DMA5_CURR_DESC_PTR, val)
#define bfin_read_DMA5_PREV_DESC_PTR() 		bfin_read32(DMA5_PREV_DESC_PTR)
#define bfin_write_DMA5_PREV_DESC_PTR(val) 	bfin_write32(DMA5_PREV_DESC_PTR, val)
#define bfin_read_DMA5_CURR_ADDR() 		bfin_read32(DMA5_CURR_ADDR)
#define bfin_write_DMA5_CURR_ADDR(val) 		bfin_write32(DMA5_CURR_ADDR, val)
#define bfin_read_DMA5_IRQ_STATUS()		bfin_read32(DMA5_IRQ_STATUS)
#define bfin_write_DMA5_IRQ_STATUS(val)		bfin_write32(DMA5_IRQ_STATUS, val)
#define bfin_read_DMA5_CURR_X_COUNT()		bfin_read32(DMA5_CURR_X_COUNT)
#define bfin_write_DMA5_CURR_X_COUNT(val)	bfin_write32(DMA5_CURR_X_COUNT, val)
#define bfin_read_DMA5_CURR_Y_COUNT()		bfin_read32(DMA5_CURR_Y_COUNT)
#define bfin_write_DMA5_CURR_Y_COUNT(val)	bfin_write32(DMA5_CURR_Y_COUNT, val)
#define bfin_read_DMA5_BWL_COUNT()		bfin_read32(DMA5_BWL_COUNT)
#define bfin_write_DMA5_BWL_COUNT(val)		bfin_write32(DMA5_BWL_COUNT, val)
#define bfin_read_DMA5_CURR_BWL_COUNT()		bfin_read32(DMA5_CURR_BWL_COUNT)
#define bfin_write_DMA5_CURR_BWL_COUNT(val)	bfin_write32(DMA5_CURR_BWL_COUNT, val)
#define bfin_read_DMA5_BWM_COUNT()		bfin_read32(DMA5_BWM_COUNT)
#define bfin_write_DMA5_BWM_COUNT(val)		bfin_write32(DMA5_BWM_COUNT, val)
#define bfin_read_DMA5_CURR_BWM_COUNT()		bfin_read32(DMA5_CURR_BWM_COUNT)
#define bfin_write_DMA5_CURR_BWM_COUNT(val)	bfin_write32(DMA5_CURR_BWM_COUNT, val)

/* DMA Channel 6 Registers */

#define bfin_read_DMA6_NEXT_DESC_PTR() 		bfin_read32(DMA6_NEXT_DESC_PTR)
#define bfin_write_DMA6_NEXT_DESC_PTR(val) 	bfin_write32(DMA6_NEXT_DESC_PTR, val)
#define bfin_read_DMA6_START_ADDR() 		bfin_read32(DMA6_START_ADDR)
#define bfin_write_DMA6_START_ADDR(val) 	bfin_write32(DMA6_START_ADDR, val)
#define bfin_read_DMA6_CONFIG()			bfin_read32(DMA6_CONFIG)
#define bfin_write_DMA6_CONFIG(val)		bfin_write32(DMA6_CONFIG, val)
#define bfin_read_DMA6_X_COUNT()		bfin_read32(DMA6_X_COUNT)
#define bfin_write_DMA6_X_COUNT(val)		bfin_write32(DMA6_X_COUNT, val)
#define bfin_read_DMA6_X_MODIFY()		bfin_read32(DMA6_X_MODIFY)
#define bfin_write_DMA6_X_MODIFY(val) 		bfin_write32(DMA6_X_MODIFY, val)
#define bfin_read_DMA6_Y_COUNT()		bfin_read32(DMA6_Y_COUNT)
#define bfin_write_DMA6_Y_COUNT(val)		bfin_write32(DMA6_Y_COUNT, val)
#define bfin_read_DMA6_Y_MODIFY()		bfin_read32(DMA6_Y_MODIFY)
#define bfin_write_DMA6_Y_MODIFY(val) 		bfin_write32(DMA6_Y_MODIFY, val)
#define bfin_read_DMA6_CURR_DESC_PTR() 		bfin_read32(DMA6_CURR_DESC_PTR)
#define bfin_write_DMA6_CURR_DESC_PTR(val) 	bfin_write32(DMA6_CURR_DESC_PTR, val)
#define bfin_read_DMA6_PREV_DESC_PTR() 		bfin_read32(DMA6_PREV_DESC_PTR)
#define bfin_write_DMA6_PREV_DESC_PTR(val) 	bfin_write32(DMA6_PREV_DESC_PTR, val)
#define bfin_read_DMA6_CURR_ADDR() 		bfin_read32(DMA6_CURR_ADDR)
#define bfin_write_DMA6_CURR_ADDR(val) 		bfin_write32(DMA6_CURR_ADDR, val)
#define bfin_read_DMA6_IRQ_STATUS()		bfin_read32(DMA6_IRQ_STATUS)
#define bfin_write_DMA6_IRQ_STATUS(val)		bfin_write32(DMA6_IRQ_STATUS, val)
#define bfin_read_DMA6_CURR_X_COUNT()		bfin_read32(DMA6_CURR_X_COUNT)
#define bfin_write_DMA6_CURR_X_COUNT(val)	bfin_write32(DMA6_CURR_X_COUNT, val)
#define bfin_read_DMA6_CURR_Y_COUNT()		bfin_read32(DMA6_CURR_Y_COUNT)
#define bfin_write_DMA6_CURR_Y_COUNT(val)	bfin_write32(DMA6_CURR_Y_COUNT, val)
#define bfin_read_DMA6_BWL_COUNT()		bfin_read32(DMA6_BWL_COUNT)
#define bfin_write_DMA6_BWL_COUNT(val)		bfin_write32(DMA6_BWL_COUNT, val)
#define bfin_read_DMA6_CURR_BWL_COUNT()		bfin_read32(DMA6_CURR_BWL_COUNT)
#define bfin_write_DMA6_CURR_BWL_COUNT(val)	bfin_write32(DMA6_CURR_BWL_COUNT, val)
#define bfin_read_DMA6_BWM_COUNT()		bfin_read32(DMA6_BWM_COUNT)
#define bfin_write_DMA6_BWM_COUNT(val)		bfin_write32(DMA6_BWM_COUNT, val)
#define bfin_read_DMA6_CURR_BWM_COUNT()		bfin_read32(DMA6_CURR_BWM_COUNT)
#define bfin_write_DMA6_CURR_BWM_COUNT(val)	bfin_write32(DMA6_CURR_BWM_COUNT, val)

/* DMA Channel 7 Registers */

#define bfin_read_DMA7_NEXT_DESC_PTR() 		bfin_read32(DMA7_NEXT_DESC_PTR)
#define bfin_write_DMA7_NEXT_DESC_PTR(val) 	bfin_write32(DMA7_NEXT_DESC_PTR, val)
#define bfin_read_DMA7_START_ADDR() 		bfin_read32(DMA7_START_ADDR)
#define bfin_write_DMA7_START_ADDR(val) 	bfin_write32(DMA7_START_ADDR, val)
#define bfin_read_DMA7_CONFIG()			bfin_read32(DMA7_CONFIG)
#define bfin_write_DMA7_CONFIG(val)		bfin_write32(DMA7_CONFIG, val)
#define bfin_read_DMA7_X_COUNT()		bfin_read32(DMA7_X_COUNT)
#define bfin_write_DMA7_X_COUNT(val)		bfin_write32(DMA7_X_COUNT, val)
#define bfin_read_DMA7_X_MODIFY()		bfin_read32(DMA7_X_MODIFY)
#define bfin_write_DMA7_X_MODIFY(val) 		bfin_write32(DMA7_X_MODIFY, val)
#define bfin_read_DMA7_Y_COUNT()		bfin_read32(DMA7_Y_COUNT)
#define bfin_write_DMA7_Y_COUNT(val)		bfin_write32(DMA7_Y_COUNT, val)
#define bfin_read_DMA7_Y_MODIFY()		bfin_read32(DMA7_Y_MODIFY)
#define bfin_write_DMA7_Y_MODIFY(val) 		bfin_write32(DMA7_Y_MODIFY, val)
#define bfin_read_DMA7_CURR_DESC_PTR() 		bfin_read32(DMA7_CURR_DESC_PTR)
#define bfin_write_DMA7_CURR_DESC_PTR(val) 	bfin_write32(DMA7_CURR_DESC_PTR, val)
#define bfin_read_DMA7_PREV_DESC_PTR() 		bfin_read32(DMA7_PREV_DESC_PTR)
#define bfin_write_DMA7_PREV_DESC_PTR(val) 	bfin_write32(DMA7_PREV_DESC_PTR, val)
#define bfin_read_DMA7_CURR_ADDR() 		bfin_read32(DMA7_CURR_ADDR)
#define bfin_write_DMA7_CURR_ADDR(val) 		bfin_write32(DMA7_CURR_ADDR, val)
#define bfin_read_DMA7_IRQ_STATUS()		bfin_read32(DMA7_IRQ_STATUS)
#define bfin_write_DMA7_IRQ_STATUS(val)		bfin_write32(DMA7_IRQ_STATUS, val)
#define bfin_read_DMA7_CURR_X_COUNT()		bfin_read32(DMA7_CURR_X_COUNT)
#define bfin_write_DMA7_CURR_X_COUNT(val)	bfin_write32(DMA7_CURR_X_COUNT, val)
#define bfin_read_DMA7_CURR_Y_COUNT()		bfin_read32(DMA7_CURR_Y_COUNT)
#define bfin_write_DMA7_CURR_Y_COUNT(val)	bfin_write32(DMA7_CURR_Y_COUNT, val)
#define bfin_read_DMA7_BWL_COUNT()		bfin_read32(DMA7_BWL_COUNT)
#define bfin_write_DMA7_BWL_COUNT(val)		bfin_write32(DMA7_BWL_COUNT, val)
#define bfin_read_DMA7_CURR_BWL_COUNT()		bfin_read32(DMA7_CURR_BWL_COUNT)
#define bfin_write_DMA7_CURR_BWL_COUNT(val)	bfin_write32(DMA7_CURR_BWL_COUNT, val)
#define bfin_read_DMA7_BWM_COUNT()		bfin_read32(DMA7_BWM_COUNT)
#define bfin_write_DMA7_BWM_COUNT(val)		bfin_write32(DMA7_BWM_COUNT, val)
#define bfin_read_DMA7_CURR_BWM_COUNT()		bfin_read32(DMA7_CURR_BWM_COUNT)
#define bfin_write_DMA7_CURR_BWM_COUNT(val)	bfin_write32(DMA7_CURR_BWM_COUNT, val)

/* DMA Channel 8 Registers */

#define bfin_read_DMA8_NEXT_DESC_PTR() 		bfin_read32(DMA8_NEXT_DESC_PTR)
#define bfin_write_DMA8_NEXT_DESC_PTR(val) 	bfin_write32(DMA8_NEXT_DESC_PTR, val)
#define bfin_read_DMA8_START_ADDR() 		bfin_read32(DMA8_START_ADDR)
#define bfin_write_DMA8_START_ADDR(val) 	bfin_write32(DMA8_START_ADDR, val)
#define bfin_read_DMA8_CONFIG()			bfin_read32(DMA8_CONFIG)
#define bfin_write_DMA8_CONFIG(val)		bfin_write32(DMA8_CONFIG, val)
#define bfin_read_DMA8_X_COUNT()		bfin_read32(DMA8_X_COUNT)
#define bfin_write_DMA8_X_COUNT(val)		bfin_write32(DMA8_X_COUNT, val)
#define bfin_read_DMA8_X_MODIFY()		bfin_read32(DMA8_X_MODIFY)
#define bfin_write_DMA8_X_MODIFY(val) 		bfin_write32(DMA8_X_MODIFY, val)
#define bfin_read_DMA8_Y_COUNT()		bfin_read32(DMA8_Y_COUNT)
#define bfin_write_DMA8_Y_COUNT(val)		bfin_write32(DMA8_Y_COUNT, val)
#define bfin_read_DMA8_Y_MODIFY()		bfin_read32(DMA8_Y_MODIFY)
#define bfin_write_DMA8_Y_MODIFY(val) 		bfin_write32(DMA8_Y_MODIFY, val)
#define bfin_read_DMA8_CURR_DESC_PTR() 		bfin_read32(DMA8_CURR_DESC_PTR)
#define bfin_write_DMA8_CURR_DESC_PTR(val) 	bfin_write32(DMA8_CURR_DESC_PTR, val)
#define bfin_read_DMA8_PREV_DESC_PTR() 		bfin_read32(DMA8_PREV_DESC_PTR)
#define bfin_write_DMA8_PREV_DESC_PTR(val) 	bfin_write32(DMA8_PREV_DESC_PTR, val)
#define bfin_read_DMA8_CURR_ADDR() 		bfin_read32(DMA8_CURR_ADDR)
#define bfin_write_DMA8_CURR_ADDR(val) 		bfin_write32(DMA8_CURR_ADDR, val)
#define bfin_read_DMA8_IRQ_STATUS()		bfin_read32(DMA8_IRQ_STATUS)
#define bfin_write_DMA8_IRQ_STATUS(val)		bfin_write32(DMA8_IRQ_STATUS, val)
#define bfin_read_DMA8_CURR_X_COUNT()		bfin_read32(DMA8_CURR_X_COUNT)
#define bfin_write_DMA8_CURR_X_COUNT(val)	bfin_write32(DMA8_CURR_X_COUNT, val)
#define bfin_read_DMA8_CURR_Y_COUNT()		bfin_read32(DMA8_CURR_Y_COUNT)
#define bfin_write_DMA8_CURR_Y_COUNT(val)	bfin_write32(DMA8_CURR_Y_COUNT, val)
#define bfin_read_DMA8_BWL_COUNT()		bfin_read32(DMA8_BWL_COUNT)
#define bfin_write_DMA8_BWL_COUNT(val)		bfin_write32(DMA8_BWL_COUNT, val)
#define bfin_read_DMA8_CURR_BWL_COUNT()		bfin_read32(DMA8_CURR_BWL_COUNT)
#define bfin_write_DMA8_CURR_BWL_COUNT(val)	bfin_write32(DMA8_CURR_BWL_COUNT, val)
#define bfin_read_DMA8_BWM_COUNT()		bfin_read32(DMA8_BWM_COUNT)
#define bfin_write_DMA8_BWM_COUNT(val)		bfin_write32(DMA8_BWM_COUNT, val)
#define bfin_read_DMA8_CURR_BWM_COUNT()		bfin_read32(DMA8_CURR_BWM_COUNT)
#define bfin_write_DMA8_CURR_BWM_COUNT(val)	bfin_write32(DMA8_CURR_BWM_COUNT, val)

/* DMA Channel 9 Registers */

#define bfin_read_DMA9_NEXT_DESC_PTR() 		bfin_read32(DMA9_NEXT_DESC_PTR)
#define bfin_write_DMA9_NEXT_DESC_PTR(val) 	bfin_write32(DMA9_NEXT_DESC_PTR, val)
#define bfin_read_DMA9_START_ADDR() 		bfin_read32(DMA9_START_ADDR)
#define bfin_write_DMA9_START_ADDR(val) 	bfin_write32(DMA9_START_ADDR, val)
#define bfin_read_DMA9_CONFIG()			bfin_read32(DMA9_CONFIG)
#define bfin_write_DMA9_CONFIG(val)		bfin_write32(DMA9_CONFIG, val)
#define bfin_read_DMA9_X_COUNT()		bfin_read32(DMA9_X_COUNT)
#define bfin_write_DMA9_X_COUNT(val)		bfin_write32(DMA9_X_COUNT, val)
#define bfin_read_DMA9_X_MODIFY()		bfin_read32(DMA9_X_MODIFY)
#define bfin_write_DMA9_X_MODIFY(val) 		bfin_write32(DMA9_X_MODIFY, val)
#define bfin_read_DMA9_Y_COUNT()		bfin_read32(DMA9_Y_COUNT)
#define bfin_write_DMA9_Y_COUNT(val)		bfin_write32(DMA9_Y_COUNT, val)
#define bfin_read_DMA9_Y_MODIFY()		bfin_read32(DMA9_Y_MODIFY)
#define bfin_write_DMA9_Y_MODIFY(val) 		bfin_write32(DMA9_Y_MODIFY, val)
#define bfin_read_DMA9_CURR_DESC_PTR() 		bfin_read32(DMA9_CURR_DESC_PTR)
#define bfin_write_DMA9_CURR_DESC_PTR(val) 	bfin_write32(DMA9_CURR_DESC_PTR, val)
#define bfin_read_DMA9_PREV_DESC_PTR() 		bfin_read32(DMA9_PREV_DESC_PTR)
#define bfin_write_DMA9_PREV_DESC_PTR(val) 	bfin_write32(DMA9_PREV_DESC_PTR, val)
#define bfin_read_DMA9_CURR_ADDR() 		bfin_read32(DMA9_CURR_ADDR)
#define bfin_write_DMA9_CURR_ADDR(val) 		bfin_write32(DMA9_CURR_ADDR, val)
#define bfin_read_DMA9_IRQ_STATUS()		bfin_read32(DMA9_IRQ_STATUS)
#define bfin_write_DMA9_IRQ_STATUS(val)		bfin_write32(DMA9_IRQ_STATUS, val)
#define bfin_read_DMA9_CURR_X_COUNT()		bfin_read32(DMA9_CURR_X_COUNT)
#define bfin_write_DMA9_CURR_X_COUNT(val)	bfin_write32(DMA9_CURR_X_COUNT, val)
#define bfin_read_DMA9_CURR_Y_COUNT()		bfin_read32(DMA9_CURR_Y_COUNT)
#define bfin_write_DMA9_CURR_Y_COUNT(val)	bfin_write32(DMA9_CURR_Y_COUNT, val)
#define bfin_read_DMA9_BWL_COUNT()		bfin_read32(DMA9_BWL_COUNT)
#define bfin_write_DMA9_BWL_COUNT(val)		bfin_write32(DMA9_BWL_COUNT, val)
#define bfin_read_DMA9_CURR_BWL_COUNT()		bfin_read32(DMA9_CURR_BWL_COUNT)
#define bfin_write_DMA9_CURR_BWL_COUNT(val)	bfin_write32(DMA9_CURR_BWL_COUNT, val)
#define bfin_read_DMA9_BWM_COUNT()		bfin_read32(DMA9_BWM_COUNT)
#define bfin_write_DMA9_BWM_COUNT(val)		bfin_write32(DMA9_BWM_COUNT, val)
#define bfin_read_DMA9_CURR_BWM_COUNT()		bfin_read32(DMA9_CURR_BWM_COUNT)
#define bfin_write_DMA9_CURR_BWM_COUNT(val)	bfin_write32(DMA9_CURR_BWM_COUNT, val)

/* DMA Channel 10 Registers */

#define bfin_read_DMA10_NEXT_DESC_PTR() 	bfin_read32(DMA10_NEXT_DESC_PTR)
#define bfin_write_DMA10_NEXT_DESC_PTR(val) 	bfin_write32(DMA10_NEXT_DESC_PTR, val)
#define bfin_read_DMA10_START_ADDR() 		bfin_read32(DMA10_START_ADDR)
#define bfin_write_DMA10_START_ADDR(val) 	bfin_write32(DMA10_START_ADDR, val)
#define bfin_read_DMA10_CONFIG()		bfin_read32(DMA10_CONFIG)
#define bfin_write_DMA10_CONFIG(val)		bfin_write32(DMA10_CONFIG, val)
#define bfin_read_DMA10_X_COUNT()		bfin_read32(DMA10_X_COUNT)
#define bfin_write_DMA10_X_COUNT(val)		bfin_write32(DMA10_X_COUNT, val)
#define bfin_read_DMA10_X_MODIFY()		bfin_read32(DMA10_X_MODIFY)
#define bfin_write_DMA10_X_MODIFY(val) 		bfin_write32(DMA10_X_MODIFY, val)
#define bfin_read_DMA10_Y_COUNT()		bfin_read32(DMA10_Y_COUNT)
#define bfin_write_DMA10_Y_COUNT(val)		bfin_write32(DMA10_Y_COUNT, val)
#define bfin_read_DMA10_Y_MODIFY()		bfin_read32(DMA10_Y_MODIFY)
#define bfin_write_DMA10_Y_MODIFY(val) 		bfin_write32(DMA10_Y_MODIFY, val)
#define bfin_read_DMA10_CURR_DESC_PTR() 	bfin_read32(DMA10_CURR_DESC_PTR)
#define bfin_write_DMA10_CURR_DESC_PTR(val) 	bfin_write32(DMA10_CURR_DESC_PTR, val)
#define bfin_read_DMA10_PREV_DESC_PTR() 	bfin_read32(DMA10_PREV_DESC_PTR)
#define bfin_write_DMA10_PREV_DESC_PTR(val) 	bfin_write32(DMA10_PREV_DESC_PTR, val)
#define bfin_read_DMA10_CURR_ADDR() 		bfin_read32(DMA10_CURR_ADDR)
#define bfin_write_DMA10_CURR_ADDR(val) 	bfin_write32(DMA10_CURR_ADDR, val)
#define bfin_read_DMA10_IRQ_STATUS()		bfin_read32(DMA10_IRQ_STATUS)
#define bfin_write_DMA10_IRQ_STATUS(val)	bfin_write32(DMA10_IRQ_STATUS, val)
#define bfin_read_DMA10_CURR_X_COUNT()		bfin_read32(DMA10_CURR_X_COUNT)
#define bfin_write_DMA10_CURR_X_COUNT(val)	bfin_write32(DMA10_CURR_X_COUNT, val)
#define bfin_read_DMA10_CURR_Y_COUNT()		bfin_read32(DMA10_CURR_Y_COUNT)
#define bfin_write_DMA10_CURR_Y_COUNT(val)	bfin_write32(DMA10_CURR_Y_COUNT, val)
#define bfin_read_DMA10_BWL_COUNT()		bfin_read32(DMA10_BWL_COUNT)
#define bfin_write_DMA10_BWL_COUNT(val)		bfin_write32(DMA10_BWL_COUNT, val)
#define bfin_read_DMA10_CURR_BWL_COUNT()	bfin_read32(DMA10_CURR_BWL_COUNT)
#define bfin_write_DMA10_CURR_BWL_COUNT(val)	bfin_write32(DMA10_CURR_BWL_COUNT, val)
#define bfin_read_DMA10_BWM_COUNT()		bfin_read32(DMA10_BWM_COUNT)
#define bfin_write_DMA10_BWM_COUNT(val)		bfin_write32(DMA10_BWM_COUNT, val)
#define bfin_read_DMA10_CURR_BWM_COUNT()	bfin_read32(DMA10_CURR_BWM_COUNT)
#define bfin_write_DMA10_CURR_BWM_COUNT(val)	bfin_write32(DMA10_CURR_BWM_COUNT, val)

/* DMA Channel 11 Registers */

#define bfin_read_DMA11_NEXT_DESC_PTR() 	bfin_read32(DMA11_NEXT_DESC_PTR)
#define bfin_write_DMA11_NEXT_DESC_PTR(val) 	bfin_write32(DMA11_NEXT_DESC_PTR, val)
#define bfin_read_DMA11_START_ADDR() 		bfin_read32(DMA11_START_ADDR)
#define bfin_write_DMA11_START_ADDR(val) 	bfin_write32(DMA11_START_ADDR, val)
#define bfin_read_DMA11_CONFIG()		bfin_read32(DMA11_CONFIG)
#define bfin_write_DMA11_CONFIG(val)		bfin_write32(DMA11_CONFIG, val)
#define bfin_read_DMA11_X_COUNT()		bfin_read32(DMA11_X_COUNT)
#define bfin_write_DMA11_X_COUNT(val)		bfin_write32(DMA11_X_COUNT, val)
#define bfin_read_DMA11_X_MODIFY()		bfin_read32(DMA11_X_MODIFY)
#define bfin_write_DMA11_X_MODIFY(val) 		bfin_write32(DMA11_X_MODIFY, val)
#define bfin_read_DMA11_Y_COUNT()		bfin_read32(DMA11_Y_COUNT)
#define bfin_write_DMA11_Y_COUNT(val)		bfin_write32(DMA11_Y_COUNT, val)
#define bfin_read_DMA11_Y_MODIFY()		bfin_read32(DMA11_Y_MODIFY)
#define bfin_write_DMA11_Y_MODIFY(val) 		bfin_write32(DMA11_Y_MODIFY, val)
#define bfin_read_DMA11_CURR_DESC_PTR() 	bfin_read32(DMA11_CURR_DESC_PTR)
#define bfin_write_DMA11_CURR_DESC_PTR(val) 	bfin_write32(DMA11_CURR_DESC_PTR, val)
#define bfin_read_DMA11_PREV_DESC_PTR() 	bfin_read32(DMA11_PREV_DESC_PTR)
#define bfin_write_DMA11_PREV_DESC_PTR(val) 	bfin_write32(DMA11_PREV_DESC_PTR, val)
#define bfin_read_DMA11_CURR_ADDR() 		bfin_read32(DMA11_CURR_ADDR)
#define bfin_write_DMA11_CURR_ADDR(val) 	bfin_write32(DMA11_CURR_ADDR, val)
#define bfin_read_DMA11_IRQ_STATUS()		bfin_read32(DMA11_IRQ_STATUS)
#define bfin_write_DMA11_IRQ_STATUS(val)	bfin_write32(DMA11_IRQ_STATUS, val)
#define bfin_read_DMA11_CURR_X_COUNT()		bfin_read32(DMA11_CURR_X_COUNT)
#define bfin_write_DMA11_CURR_X_COUNT(val)	bfin_write32(DMA11_CURR_X_COUNT, val)
#define bfin_read_DMA11_CURR_Y_COUNT()		bfin_read32(DMA11_CURR_Y_COUNT)
#define bfin_write_DMA11_CURR_Y_COUNT(val)	bfin_write32(DMA11_CURR_Y_COUNT, val)
#define bfin_read_DMA11_BWL_COUNT()		bfin_read32(DMA11_BWL_COUNT)
#define bfin_write_DMA11_BWL_COUNT(val)		bfin_write32(DMA11_BWL_COUNT, val)
#define bfin_read_DMA11_CURR_BWL_COUNT()	bfin_read32(DMA11_CURR_BWL_COUNT)
#define bfin_write_DMA11_CURR_BWL_COUNT(val)	bfin_write32(DMA11_CURR_BWL_COUNT, val)
#define bfin_read_DMA11_BWM_COUNT()		bfin_read32(DMA11_BWM_COUNT)
#define bfin_write_DMA11_BWM_COUNT(val)		bfin_write32(DMA11_BWM_COUNT, val)
#define bfin_read_DMA11_CURR_BWM_COUNT()	bfin_read32(DMA11_CURR_BWM_COUNT)
#define bfin_write_DMA11_CURR_BWM_COUNT(val)	bfin_write32(DMA11_CURR_BWM_COUNT, val)

/* DMA Channel 12 Registers */

#define bfin_read_DMA12_NEXT_DESC_PTR() 	bfin_read32(DMA12_NEXT_DESC_PTR)
#define bfin_write_DMA12_NEXT_DESC_PTR(val) 	bfin_write32(DMA12_NEXT_DESC_PTR, val)
#define bfin_read_DMA12_START_ADDR() 		bfin_read32(DMA12_START_ADDR)
#define bfin_write_DMA12_START_ADDR(val) 	bfin_write32(DMA12_START_ADDR, val)
#define bfin_read_DMA12_CONFIG()		bfin_read32(DMA12_CONFIG)
#define bfin_write_DMA12_CONFIG(val)		bfin_write32(DMA12_CONFIG, val)
#define bfin_read_DMA12_X_COUNT()		bfin_read32(DMA12_X_COUNT)
#define bfin_write_DMA12_X_COUNT(val)		bfin_write32(DMA12_X_COUNT, val)
#define bfin_read_DMA12_X_MODIFY()		bfin_read32(DMA12_X_MODIFY)
#define bfin_write_DMA12_X_MODIFY(val) 		bfin_write32(DMA12_X_MODIFY, val)
#define bfin_read_DMA12_Y_COUNT()		bfin_read32(DMA12_Y_COUNT)
#define bfin_write_DMA12_Y_COUNT(val)		bfin_write32(DMA12_Y_COUNT, val)
#define bfin_read_DMA12_Y_MODIFY()		bfin_read32(DMA12_Y_MODIFY)
#define bfin_write_DMA12_Y_MODIFY(val) 		bfin_write32(DMA12_Y_MODIFY, val)
#define bfin_read_DMA12_CURR_DESC_PTR() 	bfin_read32(DMA12_CURR_DESC_PTR)
#define bfin_write_DMA12_CURR_DESC_PTR(val) 	bfin_write32(DMA12_CURR_DESC_PTR, val)
#define bfin_read_DMA12_PREV_DESC_PTR() 	bfin_read32(DMA12_PREV_DESC_PTR)
#define bfin_write_DMA12_PREV_DESC_PTR(val) 	bfin_write32(DMA12_PREV_DESC_PTR, val)
#define bfin_read_DMA12_CURR_ADDR() 		bfin_read32(DMA12_CURR_ADDR)
#define bfin_write_DMA12_CURR_ADDR(val) 	bfin_write32(DMA12_CURR_ADDR, val)
#define bfin_read_DMA12_IRQ_STATUS()		bfin_read32(DMA12_IRQ_STATUS)
#define bfin_write_DMA12_IRQ_STATUS(val)	bfin_write32(DMA12_IRQ_STATUS, val)
#define bfin_read_DMA12_CURR_X_COUNT()		bfin_read32(DMA12_CURR_X_COUNT)
#define bfin_write_DMA12_CURR_X_COUNT(val)	bfin_write32(DMA12_CURR_X_COUNT, val)
#define bfin_read_DMA12_CURR_Y_COUNT()		bfin_read32(DMA12_CURR_Y_COUNT)
#define bfin_write_DMA12_CURR_Y_COUNT(val)	bfin_write32(DMA12_CURR_Y_COUNT, val)
#define bfin_read_DMA12_BWL_COUNT()		bfin_read32(DMA12_BWL_COUNT)
#define bfin_write_DMA12_BWL_COUNT(val)		bfin_write32(DMA12_BWL_COUNT, val)
#define bfin_read_DMA12_CURR_BWL_COUNT()	bfin_read32(DMA12_CURR_BWL_COUNT)
#define bfin_write_DMA12_CURR_BWL_COUNT(val)	bfin_write32(DMA12_CURR_BWL_COUNT, val)
#define bfin_read_DMA12_BWM_COUNT()		bfin_read32(DMA12_BWM_COUNT)
#define bfin_write_DMA12_BWM_COUNT(val)		bfin_write32(DMA12_BWM_COUNT, val)
#define bfin_read_DMA12_CURR_BWM_COUNT()	bfin_read32(DMA12_CURR_BWM_COUNT)
#define bfin_write_DMA12_CURR_BWM_COUNT(val)	bfin_write32(DMA12_CURR_BWM_COUNT, val)

/* DMA Channel 13 Registers */

#define bfin_read_DMA13_NEXT_DESC_PTR() 	bfin_read32(DMA13_NEXT_DESC_PTR)
#define bfin_write_DMA13_NEXT_DESC_PTR(val) 	bfin_write32(DMA13_NEXT_DESC_PTR, val)
#define bfin_read_DMA13_START_ADDR() 		bfin_read32(DMA13_START_ADDR)
#define bfin_write_DMA13_START_ADDR(val) 	bfin_write32(DMA13_START_ADDR, val)
#define bfin_read_DMA13_CONFIG()		bfin_read32(DMA13_CONFIG)
#define bfin_write_DMA13_CONFIG(val)		bfin_write32(DMA13_CONFIG, val)
#define bfin_read_DMA13_X_COUNT()		bfin_read32(DMA13_X_COUNT)
#define bfin_write_DMA13_X_COUNT(val)		bfin_write32(DMA13_X_COUNT, val)
#define bfin_read_DMA13_X_MODIFY()		bfin_read32(DMA13_X_MODIFY)
#define bfin_write_DMA13_X_MODIFY(val) 		bfin_write32(DMA13_X_MODIFY, val)
#define bfin_read_DMA13_Y_COUNT()		bfin_read32(DMA13_Y_COUNT)
#define bfin_write_DMA13_Y_COUNT(val)		bfin_write32(DMA13_Y_COUNT, val)
#define bfin_read_DMA13_Y_MODIFY()		bfin_read32(DMA13_Y_MODIFY)
#define bfin_write_DMA13_Y_MODIFY(val) 		bfin_write32(DMA13_Y_MODIFY, val)
#define bfin_read_DMA13_CURR_DESC_PTR() 	bfin_read32(DMA13_CURR_DESC_PTR)
#define bfin_write_DMA13_CURR_DESC_PTR(val) 	bfin_write32(DMA13_CURR_DESC_PTR, val)
#define bfin_read_DMA13_PREV_DESC_PTR() 	bfin_read32(DMA13_PREV_DESC_PTR)
#define bfin_write_DMA13_PREV_DESC_PTR(val) 	bfin_write32(DMA13_PREV_DESC_PTR, val)
#define bfin_read_DMA13_CURR_ADDR() 		bfin_read32(DMA13_CURR_ADDR)
#define bfin_write_DMA13_CURR_ADDR(val) 	bfin_write32(DMA13_CURR_ADDR, val)
#define bfin_read_DMA13_IRQ_STATUS()		bfin_read32(DMA13_IRQ_STATUS)
#define bfin_write_DMA13_IRQ_STATUS(val)	bfin_write32(DMA13_IRQ_STATUS, val)
#define bfin_read_DMA13_CURR_X_COUNT()		bfin_read32(DMA13_CURR_X_COUNT)
#define bfin_write_DMA13_CURR_X_COUNT(val)	bfin_write32(DMA13_CURR_X_COUNT, val)
#define bfin_read_DMA13_CURR_Y_COUNT()		bfin_read32(DMA13_CURR_Y_COUNT)
#define bfin_write_DMA13_CURR_Y_COUNT(val)	bfin_write32(DMA13_CURR_Y_COUNT, val)
#define bfin_read_DMA13_BWL_COUNT()		bfin_read32(DMA13_BWL_COUNT)
#define bfin_write_DMA13_BWL_COUNT(val)		bfin_write32(DMA13_BWL_COUNT, val)
#define bfin_read_DMA13_CURR_BWL_COUNT()	bfin_read32(DMA13_CURR_BWL_COUNT)
#define bfin_write_DMA13_CURR_BWL_COUNT(val)	bfin_write32(DMA13_CURR_BWL_COUNT, val)
#define bfin_read_DMA13_BWM_COUNT()		bfin_read32(DMA13_BWM_COUNT)
#define bfin_write_DMA13_BWM_COUNT(val)		bfin_write32(DMA13_BWM_COUNT, val)
#define bfin_read_DMA13_CURR_BWM_COUNT()	bfin_read32(DMA13_CURR_BWM_COUNT)
#define bfin_write_DMA13_CURR_BWM_COUNT(val)	bfin_write32(DMA13_CURR_BWM_COUNT, val)

/* DMA Channel 14 Registers */

#define bfin_read_DMA14_NEXT_DESC_PTR() 	bfin_read32(DMA14_NEXT_DESC_PTR)
#define bfin_write_DMA14_NEXT_DESC_PTR(val) 	bfin_write32(DMA14_NEXT_DESC_PTR, val)
#define bfin_read_DMA14_START_ADDR() 		bfin_read32(DMA14_START_ADDR)
#define bfin_write_DMA14_START_ADDR(val) 	bfin_write32(DMA14_START_ADDR, val)
#define bfin_read_DMA14_CONFIG()		bfin_read32(DMA14_CONFIG)
#define bfin_write_DMA14_CONFIG(val)		bfin_write32(DMA14_CONFIG, val)
#define bfin_read_DMA14_X_COUNT()		bfin_read32(DMA14_X_COUNT)
#define bfin_write_DMA14_X_COUNT(val)		bfin_write32(DMA14_X_COUNT, val)
#define bfin_read_DMA14_X_MODIFY()		bfin_read32(DMA14_X_MODIFY)
#define bfin_write_DMA14_X_MODIFY(val) 		bfin_write32(DMA14_X_MODIFY, val)
#define bfin_read_DMA14_Y_COUNT()		bfin_read32(DMA14_Y_COUNT)
#define bfin_write_DMA14_Y_COUNT(val)		bfin_write32(DMA14_Y_COUNT, val)
#define bfin_read_DMA14_Y_MODIFY()		bfin_read32(DMA14_Y_MODIFY)
#define bfin_write_DMA14_Y_MODIFY(val) 		bfin_write32(DMA14_Y_MODIFY, val)
#define bfin_read_DMA14_CURR_DESC_PTR() 	bfin_read32(DMA14_CURR_DESC_PTR)
#define bfin_write_DMA14_CURR_DESC_PTR(val) 	bfin_write32(DMA14_CURR_DESC_PTR, val)
#define bfin_read_DMA14_PREV_DESC_PTR() 	bfin_read32(DMA14_PREV_DESC_PTR)
#define bfin_write_DMA14_PREV_DESC_PTR(val) 	bfin_write32(DMA14_PREV_DESC_PTR, val)
#define bfin_read_DMA14_CURR_ADDR() 		bfin_read32(DMA14_CURR_ADDR)
#define bfin_write_DMA14_CURR_ADDR(val) 	bfin_write32(DMA14_CURR_ADDR, val)
#define bfin_read_DMA14_IRQ_STATUS()		bfin_read32(DMA14_IRQ_STATUS)
#define bfin_write_DMA14_IRQ_STATUS(val)	bfin_write32(DMA14_IRQ_STATUS, val)
#define bfin_read_DMA14_CURR_X_COUNT()		bfin_read32(DMA14_CURR_X_COUNT)
#define bfin_write_DMA14_CURR_X_COUNT(val)	bfin_write32(DMA14_CURR_X_COUNT, val)
#define bfin_read_DMA14_CURR_Y_COUNT()		bfin_read32(DMA14_CURR_Y_COUNT)
#define bfin_write_DMA14_CURR_Y_COUNT(val)	bfin_write32(DMA14_CURR_Y_COUNT, val)
#define bfin_read_DMA14_BWL_COUNT()		bfin_read32(DMA14_BWL_COUNT)
#define bfin_write_DMA14_BWL_COUNT(val)		bfin_write32(DMA14_BWL_COUNT, val)
#define bfin_read_DMA14_CURR_BWL_COUNT()	bfin_read32(DMA14_CURR_BWL_COUNT)
#define bfin_write_DMA14_CURR_BWL_COUNT(val)	bfin_write32(DMA14_CURR_BWL_COUNT, val)
#define bfin_read_DMA14_BWM_COUNT()		bfin_read32(DMA14_BWM_COUNT)
#define bfin_write_DMA14_BWM_COUNT(val)		bfin_write32(DMA14_BWM_COUNT, val)
#define bfin_read_DMA14_CURR_BWM_COUNT()	bfin_read32(DMA14_CURR_BWM_COUNT)
#define bfin_write_DMA14_CURR_BWM_COUNT(val)	bfin_write32(DMA14_CURR_BWM_COUNT, val)

/* DMA Channel 15 Registers */

#define bfin_read_DMA15_NEXT_DESC_PTR() 	bfin_read32(DMA15_NEXT_DESC_PTR)
#define bfin_write_DMA15_NEXT_DESC_PTR(val) 	bfin_write32(DMA15_NEXT_DESC_PTR, val)
#define bfin_read_DMA15_START_ADDR() 		bfin_read32(DMA15_START_ADDR)
#define bfin_write_DMA15_START_ADDR(val) 	bfin_write32(DMA15_START_ADDR, val)
#define bfin_read_DMA15_CONFIG()		bfin_read32(DMA15_CONFIG)
#define bfin_write_DMA15_CONFIG(val)		bfin_write32(DMA15_CONFIG, val)
#define bfin_read_DMA15_X_COUNT()		bfin_read32(DMA15_X_COUNT)
#define bfin_write_DMA15_X_COUNT(val)		bfin_write32(DMA15_X_COUNT, val)
#define bfin_read_DMA15_X_MODIFY()		bfin_read32(DMA15_X_MODIFY)
#define bfin_write_DMA15_X_MODIFY(val) 		bfin_write32(DMA15_X_MODIFY, val)
#define bfin_read_DMA15_Y_COUNT()		bfin_read32(DMA15_Y_COUNT)
#define bfin_write_DMA15_Y_COUNT(val)		bfin_write32(DMA15_Y_COUNT, val)
#define bfin_read_DMA15_Y_MODIFY()		bfin_read32(DMA15_Y_MODIFY)
#define bfin_write_DMA15_Y_MODIFY(val) 		bfin_write32(DMA15_Y_MODIFY, val)
#define bfin_read_DMA15_CURR_DESC_PTR() 	bfin_read32(DMA15_CURR_DESC_PTR)
#define bfin_write_DMA15_CURR_DESC_PTR(val) 	bfin_write32(DMA15_CURR_DESC_PTR, val)
#define bfin_read_DMA15_PREV_DESC_PTR() 	bfin_read32(DMA15_PREV_DESC_PTR)
#define bfin_write_DMA15_PREV_DESC_PTR(val) 	bfin_write32(DMA15_PREV_DESC_PTR, val)
#define bfin_read_DMA15_CURR_ADDR() 		bfin_read32(DMA15_CURR_ADDR)
#define bfin_write_DMA15_CURR_ADDR(val) 	bfin_write32(DMA15_CURR_ADDR, val)
#define bfin_read_DMA15_IRQ_STATUS()		bfin_read32(DMA15_IRQ_STATUS)
#define bfin_write_DMA15_IRQ_STATUS(val)	bfin_write32(DMA15_IRQ_STATUS, val)
#define bfin_read_DMA15_CURR_X_COUNT()		bfin_read32(DMA15_CURR_X_COUNT)
#define bfin_write_DMA15_CURR_X_COUNT(val)	bfin_write32(DMA15_CURR_X_COUNT, val)
#define bfin_read_DMA15_CURR_Y_COUNT()		bfin_read32(DMA15_CURR_Y_COUNT)
#define bfin_write_DMA15_CURR_Y_COUNT(val)	bfin_write32(DMA15_CURR_Y_COUNT, val)
#define bfin_read_DMA15_BWL_COUNT()		bfin_read32(DMA15_BWL_COUNT)
#define bfin_write_DMA15_BWL_COUNT(val)		bfin_write32(DMA15_BWL_COUNT, val)
#define bfin_read_DMA15_CURR_BWL_COUNT()	bfin_read32(DMA15_CURR_BWL_COUNT)
#define bfin_write_DMA15_CURR_BWL_COUNT(val)	bfin_write32(DMA15_CURR_BWL_COUNT, val)
#define bfin_read_DMA15_BWM_COUNT()		bfin_read32(DMA15_BWM_COUNT)
#define bfin_write_DMA15_BWM_COUNT(val)		bfin_write32(DMA15_BWM_COUNT, val)
#define bfin_read_DMA15_CURR_BWM_COUNT()	bfin_read32(DMA15_CURR_BWM_COUNT)
#define bfin_write_DMA15_CURR_BWM_COUNT(val)	bfin_write32(DMA15_CURR_BWM_COUNT, val)

/* DMA Channel 16 Registers */

#define bfin_read_DMA16_NEXT_DESC_PTR() 	bfin_read32(DMA16_NEXT_DESC_PTR)
#define bfin_write_DMA16_NEXT_DESC_PTR(val) 	bfin_write32(DMA16_NEXT_DESC_PTR, val)
#define bfin_read_DMA16_START_ADDR() 		bfin_read32(DMA16_START_ADDR)
#define bfin_write_DMA16_START_ADDR(val) 	bfin_write32(DMA16_START_ADDR, val)
#define bfin_read_DMA16_CONFIG()		bfin_read32(DMA16_CONFIG)
#define bfin_write_DMA16_CONFIG(val)		bfin_write32(DMA16_CONFIG, val)
#define bfin_read_DMA16_X_COUNT()		bfin_read32(DMA16_X_COUNT)
#define bfin_write_DMA16_X_COUNT(val)		bfin_write32(DMA16_X_COUNT, val)
#define bfin_read_DMA16_X_MODIFY()		bfin_read32(DMA16_X_MODIFY)
#define bfin_write_DMA16_X_MODIFY(val) 		bfin_write32(DMA16_X_MODIFY, val)
#define bfin_read_DMA16_Y_COUNT()		bfin_read32(DMA16_Y_COUNT)
#define bfin_write_DMA16_Y_COUNT(val)		bfin_write32(DMA16_Y_COUNT, val)
#define bfin_read_DMA16_Y_MODIFY()		bfin_read32(DMA16_Y_MODIFY)
#define bfin_write_DMA16_Y_MODIFY(val) 		bfin_write32(DMA16_Y_MODIFY, val)
#define bfin_read_DMA16_CURR_DESC_PTR() 	bfin_read32(DMA16_CURR_DESC_PTR)
#define bfin_write_DMA16_CURR_DESC_PTR(val) 	bfin_write32(DMA16_CURR_DESC_PTR, val)
#define bfin_read_DMA16_PREV_DESC_PTR() 	bfin_read32(DMA16_PREV_DESC_PTR)
#define bfin_write_DMA16_PREV_DESC_PTR(val) 	bfin_write32(DMA16_PREV_DESC_PTR, val)
#define bfin_read_DMA16_CURR_ADDR() 		bfin_read32(DMA16_CURR_ADDR)
#define bfin_write_DMA16_CURR_ADDR(val) 	bfin_write32(DMA16_CURR_ADDR, val)
#define bfin_read_DMA16_IRQ_STATUS()		bfin_read32(DMA16_IRQ_STATUS)
#define bfin_write_DMA16_IRQ_STATUS(val)	bfin_write32(DMA16_IRQ_STATUS, val)
#define bfin_read_DMA16_CURR_X_COUNT()		bfin_read32(DMA16_CURR_X_COUNT)
#define bfin_write_DMA16_CURR_X_COUNT(val)	bfin_write32(DMA16_CURR_X_COUNT, val)
#define bfin_read_DMA16_CURR_Y_COUNT()		bfin_read32(DMA16_CURR_Y_COUNT)
#define bfin_write_DMA16_CURR_Y_COUNT(val)	bfin_write32(DMA16_CURR_Y_COUNT, val)
#define bfin_read_DMA16_BWL_COUNT()		bfin_read32(DMA16_BWL_COUNT)
#define bfin_write_DMA16_BWL_COUNT(val)		bfin_write32(DMA16_BWL_COUNT, val)
#define bfin_read_DMA16_CURR_BWL_COUNT()	bfin_read32(DMA16_CURR_BWL_COUNT)
#define bfin_write_DMA16_CURR_BWL_COUNT(val)	bfin_write32(DMA16_CURR_BWL_COUNT, val)
#define bfin_read_DMA16_BWM_COUNT()		bfin_read32(DMA16_BWM_COUNT)
#define bfin_write_DMA16_BWM_COUNT(val)		bfin_write32(DMA16_BWM_COUNT, val)
#define bfin_read_DMA16_CURR_BWM_COUNT()	bfin_read32(DMA16_CURR_BWM_COUNT)
#define bfin_write_DMA16_CURR_BWM_COUNT(val)	bfin_write32(DMA16_CURR_BWM_COUNT, val)

/* DMA Channel 17 Registers */

#define bfin_read_DMA17_NEXT_DESC_PTR() 	bfin_read32(DMA17_NEXT_DESC_PTR)
#define bfin_write_DMA17_NEXT_DESC_PTR(val) 	bfin_write32(DMA17_NEXT_DESC_PTR, val)
#define bfin_read_DMA17_START_ADDR() 		bfin_read32(DMA17_START_ADDR)
#define bfin_write_DMA17_START_ADDR(val) 	bfin_write32(DMA17_START_ADDR, val)
#define bfin_read_DMA17_CONFIG()		bfin_read32(DMA17_CONFIG)
#define bfin_write_DMA17_CONFIG(val)		bfin_write32(DMA17_CONFIG, val)
#define bfin_read_DMA17_X_COUNT()		bfin_read32(DMA17_X_COUNT)
#define bfin_write_DMA17_X_COUNT(val)		bfin_write32(DMA17_X_COUNT, val)
#define bfin_read_DMA17_X_MODIFY()		bfin_read32(DMA17_X_MODIFY)
#define bfin_write_DMA17_X_MODIFY(val) 		bfin_write32(DMA17_X_MODIFY, val)
#define bfin_read_DMA17_Y_COUNT()		bfin_read32(DMA17_Y_COUNT)
#define bfin_write_DMA17_Y_COUNT(val)		bfin_write32(DMA17_Y_COUNT, val)
#define bfin_read_DMA17_Y_MODIFY()		bfin_read32(DMA17_Y_MODIFY)
#define bfin_write_DMA17_Y_MODIFY(val) 		bfin_write32(DMA17_Y_MODIFY, val)
#define bfin_read_DMA17_CURR_DESC_PTR() 	bfin_read32(DMA17_CURR_DESC_PTR)
#define bfin_write_DMA17_CURR_DESC_PTR(val) 	bfin_write32(DMA17_CURR_DESC_PTR, val)
#define bfin_read_DMA17_PREV_DESC_PTR() 	bfin_read32(DMA17_PREV_DESC_PTR)
#define bfin_write_DMA17_PREV_DESC_PTR(val) 	bfin_write32(DMA17_PREV_DESC_PTR, val)
#define bfin_read_DMA17_CURR_ADDR() 		bfin_read32(DMA17_CURR_ADDR)
#define bfin_write_DMA17_CURR_ADDR(val) 	bfin_write32(DMA17_CURR_ADDR, val)
#define bfin_read_DMA17_IRQ_STATUS()		bfin_read32(DMA17_IRQ_STATUS)
#define bfin_write_DMA17_IRQ_STATUS(val)	bfin_write32(DMA17_IRQ_STATUS, val)
#define bfin_read_DMA17_CURR_X_COUNT()		bfin_read32(DMA17_CURR_X_COUNT)
#define bfin_write_DMA17_CURR_X_COUNT(val)	bfin_write32(DMA17_CURR_X_COUNT, val)
#define bfin_read_DMA17_CURR_Y_COUNT()		bfin_read32(DMA17_CURR_Y_COUNT)
#define bfin_write_DMA17_CURR_Y_COUNT(val)	bfin_write32(DMA17_CURR_Y_COUNT, val)
#define bfin_read_DMA17_BWL_COUNT()		bfin_read32(DMA17_BWL_COUNT)
#define bfin_write_DMA17_BWL_COUNT(val)		bfin_write32(DMA17_BWL_COUNT, val)
#define bfin_read_DMA17_CURR_BWL_COUNT()	bfin_read32(DMA17_CURR_BWL_COUNT)
#define bfin_write_DMA17_CURR_BWL_COUNT(val)	bfin_write32(DMA17_CURR_BWL_COUNT, val)
#define bfin_read_DMA17_BWM_COUNT()		bfin_read32(DMA17_BWM_COUNT)
#define bfin_write_DMA17_BWM_COUNT(val)		bfin_write32(DMA17_BWM_COUNT, val)
#define bfin_read_DMA17_CURR_BWM_COUNT()	bfin_read32(DMA17_CURR_BWM_COUNT)
#define bfin_write_DMA17_CURR_BWM_COUNT(val)	bfin_write32(DMA17_CURR_BWM_COUNT, val)

/* DMA Channel 18 Registers */

#define bfin_read_DMA18_NEXT_DESC_PTR() 	bfin_read32(DMA18_NEXT_DESC_PTR)
#define bfin_write_DMA18_NEXT_DESC_PTR(val) 	bfin_write32(DMA18_NEXT_DESC_PTR, val)
#define bfin_read_DMA18_START_ADDR() 		bfin_read32(DMA18_START_ADDR)
#define bfin_write_DMA18_START_ADDR(val) 	bfin_write32(DMA18_START_ADDR, val)
#define bfin_read_DMA18_CONFIG()		bfin_read32(DMA18_CONFIG)
#define bfin_write_DMA18_CONFIG(val)		bfin_write32(DMA18_CONFIG, val)
#define bfin_read_DMA18_X_COUNT()		bfin_read32(DMA18_X_COUNT)
#define bfin_write_DMA18_X_COUNT(val)		bfin_write32(DMA18_X_COUNT, val)
#define bfin_read_DMA18_X_MODIFY()		bfin_read32(DMA18_X_MODIFY)
#define bfin_write_DMA18_X_MODIFY(val) 		bfin_write32(DMA18_X_MODIFY, val)
#define bfin_read_DMA18_Y_COUNT()		bfin_read32(DMA18_Y_COUNT)
#define bfin_write_DMA18_Y_COUNT(val)		bfin_write32(DMA18_Y_COUNT, val)
#define bfin_read_DMA18_Y_MODIFY()		bfin_read32(DMA18_Y_MODIFY)
#define bfin_write_DMA18_Y_MODIFY(val) 		bfin_write32(DMA18_Y_MODIFY, val)
#define bfin_read_DMA18_CURR_DESC_PTR() 	bfin_read32(DMA18_CURR_DESC_PTR)
#define bfin_write_DMA18_CURR_DESC_PTR(val) 	bfin_write32(DMA18_CURR_DESC_PTR, val)
#define bfin_read_DMA18_PREV_DESC_PTR() 	bfin_read32(DMA18_PREV_DESC_PTR)
#define bfin_write_DMA18_PREV_DESC_PTR(val) 	bfin_write32(DMA18_PREV_DESC_PTR, val)
#define bfin_read_DMA18_CURR_ADDR() 		bfin_read32(DMA18_CURR_ADDR)
#define bfin_write_DMA18_CURR_ADDR(val) 	bfin_write32(DMA18_CURR_ADDR, val)
#define bfin_read_DMA18_IRQ_STATUS()		bfin_read32(DMA18_IRQ_STATUS)
#define bfin_write_DMA18_IRQ_STATUS(val)	bfin_write32(DMA18_IRQ_STATUS, val)
#define bfin_read_DMA18_CURR_X_COUNT()		bfin_read32(DMA18_CURR_X_COUNT)
#define bfin_write_DMA18_CURR_X_COUNT(val)	bfin_write32(DMA18_CURR_X_COUNT, val)
#define bfin_read_DMA18_CURR_Y_COUNT()		bfin_read32(DMA18_CURR_Y_COUNT)
#define bfin_write_DMA18_CURR_Y_COUNT(val)	bfin_write32(DMA18_CURR_Y_COUNT, val)
#define bfin_read_DMA18_BWL_COUNT()		bfin_read32(DMA18_BWL_COUNT)
#define bfin_write_DMA18_BWL_COUNT(val)		bfin_write32(DMA18_BWL_COUNT, val)
#define bfin_read_DMA18_CURR_BWL_COUNT()	bfin_read32(DMA18_CURR_BWL_COUNT)
#define bfin_write_DMA18_CURR_BWL_COUNT(val)	bfin_write32(DMA18_CURR_BWL_COUNT, val)
#define bfin_read_DMA18_BWM_COUNT()		bfin_read32(DMA18_BWM_COUNT)
#define bfin_write_DMA18_BWM_COUNT(val)		bfin_write32(DMA18_BWM_COUNT, val)
#define bfin_read_DMA18_CURR_BWM_COUNT()	bfin_read32(DMA18_CURR_BWM_COUNT)
#define bfin_write_DMA18_CURR_BWM_COUNT(val)	bfin_write32(DMA18_CURR_BWM_COUNT, val)

/* DMA Channel 19 Registers */

#define bfin_read_DMA19_NEXT_DESC_PTR() 	bfin_read32(DMA19_NEXT_DESC_PTR)
#define bfin_write_DMA19_NEXT_DESC_PTR(val) 	bfin_write32(DMA19_NEXT_DESC_PTR, val)
#define bfin_read_DMA19_START_ADDR() 		bfin_read32(DMA19_START_ADDR)
#define bfin_write_DMA19_START_ADDR(val) 	bfin_write32(DMA19_START_ADDR, val)
#define bfin_read_DMA19_CONFIG()		bfin_read32(DMA19_CONFIG)
#define bfin_write_DMA19_CONFIG(val)		bfin_write32(DMA19_CONFIG, val)
#define bfin_read_DMA19_X_COUNT()		bfin_read32(DMA19_X_COUNT)
#define bfin_write_DMA19_X_COUNT(val)		bfin_write32(DMA19_X_COUNT, val)
#define bfin_read_DMA19_X_MODIFY()		bfin_read32(DMA19_X_MODIFY)
#define bfin_write_DMA19_X_MODIFY(val) 		bfin_write32(DMA19_X_MODIFY, val)
#define bfin_read_DMA19_Y_COUNT()		bfin_read32(DMA19_Y_COUNT)
#define bfin_write_DMA19_Y_COUNT(val)		bfin_write32(DMA19_Y_COUNT, val)
#define bfin_read_DMA19_Y_MODIFY()		bfin_read32(DMA19_Y_MODIFY)
#define bfin_write_DMA19_Y_MODIFY(val) 		bfin_write32(DMA19_Y_MODIFY, val)
#define bfin_read_DMA19_CURR_DESC_PTR() 	bfin_read32(DMA19_CURR_DESC_PTR)
#define bfin_write_DMA19_CURR_DESC_PTR(val) 	bfin_write32(DMA19_CURR_DESC_PTR, val)
#define bfin_read_DMA19_PREV_DESC_PTR() 	bfin_read32(DMA19_PREV_DESC_PTR)
#define bfin_write_DMA19_PREV_DESC_PTR(val) 	bfin_write32(DMA19_PREV_DESC_PTR, val)
#define bfin_read_DMA19_CURR_ADDR() 		bfin_read32(DMA19_CURR_ADDR)
#define bfin_write_DMA19_CURR_ADDR(val) 	bfin_write32(DMA19_CURR_ADDR, val)
#define bfin_read_DMA19_IRQ_STATUS()		bfin_read32(DMA19_IRQ_STATUS)
#define bfin_write_DMA19_IRQ_STATUS(val)	bfin_write32(DMA19_IRQ_STATUS, val)
#define bfin_read_DMA19_CURR_X_COUNT()		bfin_read32(DMA19_CURR_X_COUNT)
#define bfin_write_DMA19_CURR_X_COUNT(val)	bfin_write32(DMA19_CURR_X_COUNT, val)
#define bfin_read_DMA19_CURR_Y_COUNT()		bfin_read32(DMA19_CURR_Y_COUNT)
#define bfin_write_DMA19_CURR_Y_COUNT(val)	bfin_write32(DMA19_CURR_Y_COUNT, val)
#define bfin_read_DMA19_BWL_COUNT()		bfin_read32(DMA19_BWL_COUNT)
#define bfin_write_DMA19_BWL_COUNT(val)		bfin_write32(DMA19_BWL_COUNT, val)
#define bfin_read_DMA19_CURR_BWL_COUNT()	bfin_read32(DMA19_CURR_BWL_COUNT)
#define bfin_write_DMA19_CURR_BWL_COUNT(val)	bfin_write32(DMA19_CURR_BWL_COUNT, val)
#define bfin_read_DMA19_BWM_COUNT()		bfin_read32(DMA19_BWM_COUNT)
#define bfin_write_DMA19_BWM_COUNT(val)		bfin_write32(DMA19_BWM_COUNT, val)
#define bfin_read_DMA19_CURR_BWM_COUNT()	bfin_read32(DMA19_CURR_BWM_COUNT)
#define bfin_write_DMA19_CURR_BWM_COUNT(val)	bfin_write32(DMA19_CURR_BWM_COUNT, val)

/* DMA Channel 20 Registers */

#define bfin_read_DMA20_NEXT_DESC_PTR() 	bfin_read32(DMA20_NEXT_DESC_PTR)
#define bfin_write_DMA20_NEXT_DESC_PTR(val) 	bfin_write32(DMA20_NEXT_DESC_PTR, val)
#define bfin_read_DMA20_START_ADDR() 		bfin_read32(DMA20_START_ADDR)
#define bfin_write_DMA20_START_ADDR(val) 	bfin_write32(DMA20_START_ADDR, val)
#define bfin_read_DMA20_CONFIG()		bfin_read32(DMA20_CONFIG)
#define bfin_write_DMA20_CONFIG(val)		bfin_write32(DMA20_CONFIG, val)
#define bfin_read_DMA20_X_COUNT()		bfin_read32(DMA20_X_COUNT)
#define bfin_write_DMA20_X_COUNT(val)		bfin_write32(DMA20_X_COUNT, val)
#define bfin_read_DMA20_X_MODIFY()		bfin_read32(DMA20_X_MODIFY)
#define bfin_write_DMA20_X_MODIFY(val) 		bfin_write32(DMA20_X_MODIFY, val)
#define bfin_read_DMA20_Y_COUNT()		bfin_read32(DMA20_Y_COUNT)
#define bfin_write_DMA20_Y_COUNT(val)		bfin_write32(DMA20_Y_COUNT, val)
#define bfin_read_DMA20_Y_MODIFY()		bfin_read32(DMA20_Y_MODIFY)
#define bfin_write_DMA20_Y_MODIFY(val) 		bfin_write32(DMA20_Y_MODIFY, val)
#define bfin_read_DMA20_CURR_DESC_PTR() 	bfin_read32(DMA20_CURR_DESC_PTR)
#define bfin_write_DMA20_CURR_DESC_PTR(val) 	bfin_write32(DMA20_CURR_DESC_PTR, val)
#define bfin_read_DMA20_PREV_DESC_PTR() 	bfin_read32(DMA20_PREV_DESC_PTR)
#define bfin_write_DMA20_PREV_DESC_PTR(val) 	bfin_write32(DMA20_PREV_DESC_PTR, val)
#define bfin_read_DMA20_CURR_ADDR() 		bfin_read32(DMA20_CURR_ADDR)
#define bfin_write_DMA20_CURR_ADDR(val) 	bfin_write32(DMA20_CURR_ADDR, val)
#define bfin_read_DMA20_IRQ_STATUS()		bfin_read32(DMA20_IRQ_STATUS)
#define bfin_write_DMA20_IRQ_STATUS(val)	bfin_write32(DMA20_IRQ_STATUS, val)
#define bfin_read_DMA20_CURR_X_COUNT()		bfin_read32(DMA20_CURR_X_COUNT)
#define bfin_write_DMA20_CURR_X_COUNT(val)	bfin_write32(DMA20_CURR_X_COUNT, val)
#define bfin_read_DMA20_CURR_Y_COUNT()		bfin_read32(DMA20_CURR_Y_COUNT)
#define bfin_write_DMA20_CURR_Y_COUNT(val)	bfin_write32(DMA20_CURR_Y_COUNT, val)
#define bfin_read_DMA20_BWL_COUNT()		bfin_read32(DMA20_BWL_COUNT)
#define bfin_write_DMA20_BWL_COUNT(val)		bfin_write32(DMA20_BWL_COUNT, val)
#define bfin_read_DMA20_CURR_BWL_COUNT()	bfin_read32(DMA20_CURR_BWL_COUNT)
#define bfin_write_DMA20_CURR_BWL_COUNT(val)	bfin_write32(DMA20_CURR_BWL_COUNT, val)
#define bfin_read_DMA20_BWM_COUNT()		bfin_read32(DMA20_BWM_COUNT)
#define bfin_write_DMA20_BWM_COUNT(val)		bfin_write32(DMA20_BWM_COUNT, val)
#define bfin_read_DMA20_CURR_BWM_COUNT()	bfin_read32(DMA20_CURR_BWM_COUNT)
#define bfin_write_DMA20_CURR_BWM_COUNT(val)	bfin_write32(DMA20_CURR_BWM_COUNT, val)


/* MDMA Stream 0 Registers (DMA Channel 21 and 22) */

#define bfin_read_MDMA0_DEST_CRC0_NEXT_DESC_PTR() 	bfin_read32(MDMA0_DEST_CRC0_NEXT_DESC_PTR)
#define bfin_write_MDMA0_DEST_CRC0_NEXT_DESC_PTR(val) 	bfin_write32(MDMA0_DEST_CRC0_NEXT_DESC_PTR, val)
#define bfin_read_MDMA0_DEST_CRC0_START_ADDR() 		bfin_read32(MDMA0_DEST_CRC0_START_ADDR)
#define bfin_write_MDMA0_DEST_CRC0_START_ADDR(val) 	bfin_write32(MDMA0_DEST_CRC0_START_ADDR, val)
#define bfin_read_MDMA0_DEST_CRC0_CONFIG()		bfin_read32(MDMA0_DEST_CRC0_CONFIG)
#define bfin_write_MDMA0_DEST_CRC0_CONFIG(val)		bfin_write32(MDMA0_DEST_CRC0_CONFIG, val)
#define bfin_read_MDMA0_DEST_CRC0_X_COUNT()		bfin_read32(MDMA0_DEST_CRC0_X_COUNT)
#define bfin_write_MDMA0_DEST_CRC0_X_COUNT(val)		bfin_write32(MDMA0_DEST_CRC0_X_COUNT, val)
#define bfin_read_MDMA0_DEST_CRC0_X_MODIFY()		bfin_read32(MDMA0_DEST_CRC0_X_MODIFY)
#define bfin_write_MDMA0_DEST_CRC0_X_MODIFY(val) 	bfin_write32(MDMA0_DEST_CRC0_X_MODIFY, val)
#define bfin_read_MDMA0_DEST_CRC0_Y_COUNT()		bfin_read32(MDMA0_DEST_CRC0_Y_COUNT)
#define bfin_write_MDMA0_DEST_CRC0_Y_COUNT(val)		bfin_write32(MDMA0_DEST_CRC0_Y_COUNT, val)
#define bfin_read_MDMA0_DEST_CRC0_Y_MODIFY()		bfin_read32(MDMA0_DEST_CRC0_Y_MODIFY)
#define bfin_write_MDMA0_DEST_CRC0_Y_MODIFY(val) 	bfin_write32(MDMA0_DEST_CRC0_Y_MODIFY, val)
#define bfin_read_MDMA0_DEST_CRC0_CURR_DESC_PTR() 	bfin_read32(MDMA0_DEST_CRC0_CURR_DESC_PTR)
#define bfin_write_MDMA0_DEST_CRC0_CURR_DESC_PTR(val) 	bfin_write32(MDMA0_DEST_CRC0_CURR_DESC_PTR, val)
#define bfin_read_MDMA0_DEST_CRC0_PREV_DESC_PTR() 	bfin_read32(MDMA0_DEST_CRC0_PREV_DESC_PTR)
#define bfin_write_MDMA0_DEST_CRC0_PREV_DESC_PTR(val) 	bfin_write32(MDMA0_DEST_CRC0_PREV_DESC_PTR, val)
#define bfin_read_MDMA0_DEST_CRC0_CURR_ADDR() 		bfin_read32(MDMA0_DEST_CRC0_CURR_ADDR)
#define bfin_write_MDMA0_DEST_CRC0_CURR_ADDR(val) 	bfin_write32(MDMA0_DEST_CRC0_CURR_ADDR, val)
#define bfin_read_MDMA0_DEST_CRC0_IRQ_STATUS()		bfin_read32(MDMA0_DEST_CRC0_IRQ_STATUS)
#define bfin_write_MDMA0_DEST_CRC0_IRQ_STATUS(val)	bfin_write32(MDMA0_DEST_CRC0_IRQ_STATUS, val)
#define bfin_read_MDMA0_DEST_CRC0_CURR_X_COUNT()	bfin_read32(MDMA0_DEST_CRC0_CURR_X_COUNT)
#define bfin_write_MDMA0_DEST_CRC0_CURR_X_COUNT(val)	bfin_write32(MDMA0_DEST_CRC0_CURR_X_COUNT, val)
#define bfin_read_MDMA0_DEST_CRC0_CURR_Y_COUNT()	bfin_read32(MDMA0_DEST_CRC0_CURR_Y_COUNT)
#define bfin_write_MDMA0_DEST_CRC0_CURR_Y_COUNT(val)	bfin_write32(MDMA0_DEST_CRC0_CURR_Y_COUNT, val)
#define bfin_read_MDMA0_SRC_CRC0_NEXT_DESC_PTR() 	bfin_read32(MDMA0_SRC_CRC0_NEXT_DESC_PTR)
#define bfin_write_MDMA0_SRC_CRC0_NEXT_DESC_PTR(val) 	bfin_write32(MDMA0_SRC_CRC0_NEXT_DESC_PTR, val)
#define bfin_read_MDMA0_SRC_CRC0_START_ADDR() 		bfin_read32(MDMA0_SRC_CRC0_START_ADDR)
#define bfin_write_MDMA0_SRC_CRC0_START_ADDR(val) 	bfin_write32(MDMA0_SRC_CRC0_START_ADDR, val)
#define bfin_read_MDMA0_SRC_CRC0_CONFIG()		bfin_read32(MDMA0_SRC_CRC0_CONFIG)
#define bfin_write_MDMA0_SRC_CRC0_CONFIG(val)		bfin_write32(MDMA0_SRC_CRC0_CONFIG, val)
#define bfin_read_MDMA0_SRC_CRC0_X_COUNT()		bfin_read32(MDMA0_SRC_CRC0_X_COUNT)
#define bfin_write_MDMA0_SRC_CRC0_X_COUNT(val)		bfin_write32(MDMA0_SRC_CRC0_X_COUNT, val)
#define bfin_read_MDMA0_SRC_CRC0_X_MODIFY()		bfin_read32(MDMA0_SRC_CRC0_X_MODIFY)
#define bfin_write_MDMA0_SRC_CRC0_X_MODIFY(val) 	bfin_write32(MDMA0_SRC_CRC0_X_MODIFY, val)
#define bfin_read_MDMA0_SRC_CRC0_Y_COUNT()		bfin_read32(MDMA0_SRC_CRC0_Y_COUNT)
#define bfin_write_MDMA0_SRC_CRC0_Y_COUNT(val)		bfin_write32(MDMA0_SRC_CRC0_Y_COUNT, val)
#define bfin_read_MDMA0_SRC_CRC0_Y_MODIFY()		bfin_read32(MDMA0_SRC_CRC0_Y_MODIFY)
#define bfin_write_MDMA0_SRC_CRC0_Y_MODIFY(val) 	bfin_write32(MDMA0_SRC_CRC0_Y_MODIFY, val)
#define bfin_read_MDMA0_SRC_CRC0_CURR_DESC_PTR() 	bfin_read32(MDMA0_SRC_CRC0_CURR_DESC_PTR)
#define bfin_write_MDMA0_SRC_CRC0_CURR_DESC_PTR(val) 	bfin_write32(MDMA0_SRC_CRC0_CURR_DESC_PTR, val)
#define bfin_read_MDMA0_SRC_CRC0_PREV_DESC_PTR() 	bfin_read32(MDMA0_SRC_CRC0_PREV_DESC_PTR)
#define bfin_write_MDMA0_SRC_CRC0_PREV_DESC_PTR(val) 	bfin_write32(MDMA0_SRC_CRC0_PREV_DESC_PTR, val)
#define bfin_read_MDMA0_SRC_CRC0_CURR_ADDR() 		bfin_read32(MDMA0_SRC_CRC0_CURR_ADDR)
#define bfin_write_MDMA0_SRC_CRC0_CURR_ADDR(val) 	bfin_write32(MDMA0_SRC_CRC0_CURR_ADDR, val)
#define bfin_read_MDMA0_SRC_CRC0_IRQ_STATUS()		bfin_read32(MDMA0_SRC_CRC0_IRQ_STATUS)
#define bfin_write_MDMA0_SRC_CRC0_IRQ_STATUS(val)	bfin_write32(MDMA0_SRC_CRC0_IRQ_STATUS, val)
#define bfin_read_MDMA0_SRC_CRC0_CURR_X_COUNT()		bfin_read32(MDMA0_SRC_CRC0_CURR_X_COUNT)
#define bfin_write_MDMA0_SRC_CRC0_CURR_X_COUNT(val)	bfin_write32(MDMA0_SRC_CRC0_CURR_X_COUNT, val)
#define bfin_read_MDMA0_SRC_CRC0_CURR_Y_COUNT()		bfin_read32(MDMA0_SRC_CRC0_CURR_Y_COUNT)
#define bfin_write_MDMA0_SRC_CRC0_CURR_Y_COUNT(val)	bfin_write32(MDMA0_SRC_CRC0_CURR_Y_COUNT, val)

/* MDMA Stream 1 Registers (DMA Channel 23 and 24) */

#define bfin_read_MDMA1_DEST_CRC1_NEXT_DESC_PTR() 	bfin_read32(MDMA1_DEST_CRC1_NEXT_DESC_PTR)
#define bfin_write_MDMA1_DEST_CRC1_NEXT_DESC_PTR(val) 	bfin_write32(MDMA1_DEST_CRC1_NEXT_DESC_PTR, val)
#define bfin_read_MDMA1_DEST_CRC1_START_ADDR() 		bfin_read32(MDMA1_DEST_CRC1_START_ADDR)
#define bfin_write_MDMA1_DEST_CRC1_START_ADDR(val) 	bfin_write32(MDMA1_DEST_CRC1_START_ADDR, val)
#define bfin_read_MDMA1_DEST_CRC1_CONFIG()		bfin_read32(MDMA1_DEST_CRC1_CONFIG)
#define bfin_write_MDMA1_DEST_CRC1_CONFIG(val)		bfin_write32(MDMA1_DEST_CRC1_CONFIG, val)
#define bfin_read_MDMA1_DEST_CRC1_X_COUNT()		bfin_read32(MDMA1_DEST_CRC1_X_COUNT)
#define bfin_write_MDMA1_DEST_CRC1_X_COUNT(val)		bfin_write32(MDMA1_DEST_CRC1_X_COUNT, val)
#define bfin_read_MDMA1_DEST_CRC1_X_MODIFY()		bfin_read32(MDMA1_DEST_CRC1_X_MODIFY)
#define bfin_write_MDMA1_DEST_CRC1_X_MODIFY(val) 	bfin_write32(MDMA1_DEST_CRC1_X_MODIFY, val)
#define bfin_read_MDMA1_DEST_CRC1_Y_COUNT()		bfin_read32(MDMA1_DEST_CRC1_Y_COUNT)
#define bfin_write_MDMA1_DEST_CRC1_Y_COUNT(val)		bfin_write32(MDMA1_DEST_CRC1_Y_COUNT, val)
#define bfin_read_MDMA1_DEST_CRC1_Y_MODIFY()		bfin_read32(MDMA1_DEST_CRC1_Y_MODIFY)
#define bfin_write_MDMA1_DEST_CRC1_Y_MODIFY(val) 	bfin_write32(MDMA1_DEST_CRC1_Y_MODIFY, val)
#define bfin_read_MDMA1_DEST_CRC1_CURR_DESC_PTR() 	bfin_read32(MDMA1_DEST_CRC1_CURR_DESC_PTR)
#define bfin_write_MDMA1_DEST_CRC1_CURR_DESC_PTR(val) 	bfin_write32(MDMA1_DEST_CRC1_CURR_DESC_PTR, val)
#define bfin_read_MDMA1_DEST_CRC1_PREV_DESC_PTR() 	bfin_read32(MDMA1_DEST_CRC1_PREV_DESC_PTR)
#define bfin_write_MDMA1_DEST_CRC1_PREV_DESC_PTR(val) 	bfin_write32(MDMA1_DEST_CRC1_PREV_DESC_PTR, val)
#define bfin_read_MDMA1_DEST_CRC1_CURR_ADDR() 		bfin_read32(MDMA1_DEST_CRC1_CURR_ADDR)
#define bfin_write_MDMA1_DEST_CRC1_CURR_ADDR(val) 	bfin_write32(MDMA1_DEST_CRC1_CURR_ADDR, val)
#define bfin_read_MDMA1_DEST_CRC1_IRQ_STATUS()		bfin_read32(MDMA1_DEST_CRC1_IRQ_STATUS)
#define bfin_write_MDMA1_DEST_CRC1_IRQ_STATUS(val)	bfin_write32(MDMA1_DEST_CRC1_IRQ_STATUS, val)
#define bfin_read_MDMA1_DEST_CRC1_CURR_X_COUNT()	bfin_read32(MDMA1_DEST_CRC1_CURR_X_COUNT)
#define bfin_write_MDMA1_DEST_CRC1_CURR_X_COUNT(val)	bfin_write32(MDMA1_DEST_CRC1_CURR_X_COUNT, val)
#define bfin_read_MDMA1_DEST_CRC1_CURR_Y_COUNT()	bfin_read32(MDMA1_DEST_CRC1_CURR_Y_COUNT)
#define bfin_write_MDMA1_DEST_CRC1_CURR_Y_COUNT(val)	bfin_write32(MDMA1_DEST_CRC1_CURR_Y_COUNT, val)
#define bfin_read_MDMA1_SRC_CRC1_NEXT_DESC_PTR() 	bfin_read32(MDMA1_SRC_CRC1_NEXT_DESC_PTR)
#define bfin_write_MDMA1_SRC_CRC1_NEXT_DESC_PTR(val) 	bfin_write32(MDMA1_SRC_CRC1_NEXT_DESC_PTR, val)
#define bfin_read_MDMA1_SRC_CRC1_START_ADDR() 		bfin_read32(MDMA1_SRC_CRC1_START_ADDR)
#define bfin_write_MDMA1_SRC_CRC1_START_ADDR(val) 	bfin_write32(MDMA1_SRC_CRC1_START_ADDR, val)
#define bfin_read_MDMA1_SRC_CRC1_CONFIG()		bfin_read32(MDMA1_SRC_CRC1_CONFIG)
#define bfin_write_MDMA1_SRC_CRC1_CONFIG(val)		bfin_write32(MDMA1_SRC_CRC1_CONFIG, val)
#define bfin_read_MDMA1_SRC_CRC1_X_COUNT()		bfin_read32(MDMA1_SRC_CRC1_X_COUNT)
#define bfin_write_MDMA1_SRC_CRC1_X_COUNT(val)		bfin_write32(MDMA1_SRC_CRC1_X_COUNT, val)
#define bfin_read_MDMA1_SRC_CRC1_X_MODIFY()		bfin_read32(MDMA1_SRC_CRC1_X_MODIFY)
#define bfin_write_MDMA1_SRC_CRC1_X_MODIFY(val) 	bfin_write32(MDMA1_SRC_CRC1_X_MODIFY, val)
#define bfin_read_MDMA1_SRC_CRC1_Y_COUNT()		bfin_read32(MDMA1_SRC_CRC1_Y_COUNT)
#define bfin_write_MDMA1_SRC_CRC1_Y_COUNT(val)		bfin_write32(MDMA1_SRC_CRC1_Y_COUNT, val)
#define bfin_read_MDMA1_SRC_CRC1_Y_MODIFY()		bfin_read32(MDMA1_SRC_CRC1_Y_MODIFY)
#define bfin_write_MDMA1_SRC_CRC1_Y_MODIFY(val) 	bfin_write32(MDMA1_SRC_CRC1_Y_MODIFY, val)
#define bfin_read_MDMA1_SRC_CRC1_CURR_DESC_PTR() 	bfin_read32(MDMA1_SRC_CRC1_CURR_DESC_PTR)
#define bfin_write_MDMA1_SRC_CRC1_CURR_DESC_PTR(val) 	bfin_write32(MDMA1_SRC_CRC1_CURR_DESC_PTR, val)
#define bfin_read_MDMA1_SRC_CRC1_PREV_DESC_PTR() 	bfin_read32(MDMA1_SRC_CRC1_PREV_DESC_PTR)
#define bfin_write_MDMA1_SRC_CRC1_PREV_DESC_PTR(val) 	bfin_write32(MDMA1_SRC_CRC1_PREV_DESC_PTR, val)
#define bfin_read_MDMA1_SRC_CRC1_CURR_ADDR() 		bfin_read32(MDMA1_SRC_CRC1_CURR_ADDR)
#define bfin_write_MDMA1_SRC_CRC1_CURR_ADDR(val) 	bfin_write32(MDMA1_SRC_CRC1_CURR_ADDR, val)
#define bfin_read_MDMA1_SRC_CRC1_IRQ_STATUS()		bfin_read32(MDMA1_SRC_CRC1_IRQ_STATUS)
#define bfin_write_MDMA1_SRC_CRC1_IRQ_STATUS(val)	bfin_write32(MDMA1_SRC_CRC1_IRQ_STATUS, val)
#define bfin_read_MDMA1_SRC_CRC1_CURR_X_COUNT()		bfin_read32(MDMA1_SRC_CRC1_CURR_X_COUNT)
#define bfin_write_MDMA1_SRC_CRC1_CURR_X_COUNT(val)	bfin_write32(MDMA1_SRC_CRC1_CURR_X_COUNT, val)
#define bfin_read_MDMA1_SRC_CRC1_CURR_Y_COUNT()		bfin_read32(MDMA1_SRC_CRC1_CURR_Y_COUNT)
#define bfin_write_MDMA1_SRC_CRC1_CURR_Y_COUNT(val)	bfin_write32(MDMA1_SRC_CRC1_CURR_Y_COUNT, val)


/* MDMA Stream 2 Registers (DMA Channel 25 and 26) */

#define bfin_read_MDMA2_DEST_NEXT_DESC_PTR() 		bfin_read32(MDMA2_DEST_NEXT_DESC_PTR)
#define bfin_write_MDMA2_DEST_NEXT_DESC_PTR(val) 	bfin_write32(MDMA2_DEST_NEXT_DESC_PTR, val)
#define bfin_read_MDMA2_DEST_START_ADDR() 		bfin_read32(MDMA2_DEST_START_ADDR)
#define bfin_write_MDMA2_DEST_START_ADDR(val) 		bfin_write32(MDMA2_DEST_START_ADDR, val)
#define bfin_read_MDMA2_DEST_CONFIG()			bfin_read32(MDMA2_DEST_CONFIG)
#define bfin_write_MDMA2_DEST_CONFIG(val)		bfin_write32(MDMA2_DEST_CONFIG, val)
#define bfin_read_MDMA2_DEST_X_COUNT()			bfin_read32(MDMA2_DEST_X_COUNT)
#define bfin_write_MDMA2_DEST_X_COUNT(val)		bfin_write32(MDMA2_DEST_X_COUNT, val)
#define bfin_read_MDMA2_DEST_X_MODIFY()			bfin_read32(MDMA2_DEST_X_MODIFY)
#define bfin_write_MDMA2_DEST_X_MODIFY(val) 		bfin_write32(MDMA2_DEST_X_MODIFY, val)
#define bfin_read_MDMA2_DEST_Y_COUNT()			bfin_read32(MDMA2_DEST_Y_COUNT)
#define bfin_write_MDMA2_DEST_Y_COUNT(val)		bfin_write32(MDMA2_DEST_Y_COUNT, val)
#define bfin_read_MDMA2_DEST_Y_MODIFY()			bfin_read32(MDMA2_DEST_Y_MODIFY)
#define bfin_write_MDMA2_DEST_Y_MODIFY(val) 		bfin_write32(MDMA2_DEST_Y_MODIFY, val)
#define bfin_read_MDMA2_DEST_CURR_DESC_PTR() 		bfin_read32(MDMA2_DEST_CURR_DESC_PTR)
#define bfin_write_MDMA2_DEST_CURR_DESC_PTR(val) 	bfin_write32(MDMA2_DEST_CURR_DESC_PTR, val)
#define bfin_read_MDMA2_DEST_PREV_DESC_PTR() 		bfin_read32(MDMA2_DEST_PREV_DESC_PTR)
#define bfin_write_MDMA2_DEST_PREV_DESC_PTR(val) 	bfin_write32(MDMA2_DEST_PREV_DESC_PTR, val)
#define bfin_read_MDMA2_DEST_CURR_ADDR() 		bfin_read32(MDMA2_DEST_CURR_ADDR)
#define bfin_write_MDMA2_DEST_CURR_ADDR(val) 		bfin_write32(MDMA2_DEST_CURR_ADDR, val)
#define bfin_read_MDMA2_DEST_IRQ_STATUS()		bfin_read32(MDMA2_DEST_IRQ_STATUS)
#define bfin_write_MDMA2_DEST_IRQ_STATUS(val)		bfin_write32(MDMA2_DEST_IRQ_STATUS, val)
#define bfin_read_MDMA2_DEST_CURR_X_COUNT()		bfin_read32(MDMA2_DEST_CURR_X_COUNT)
#define bfin_write_MDMA2_DEST_CURR_X_COUNT(val)		bfin_write32(MDMA2_DEST_CURR_X_COUNT, val)
#define bfin_read_MDMA2_DEST_CURR_Y_COUNT()		bfin_read32(MDMA2_DEST_CURR_Y_COUNT)
#define bfin_write_MDMA2_DEST_CURR_Y_COUNT(val)		bfin_write32(MDMA2_DEST_CURR_Y_COUNT, val)
#define bfin_read_MDMA2_SRC_NEXT_DESC_PTR() 		bfin_read32(MDMA2_SRC_NEXT_DESC_PTR)
#define bfin_write_MDMA2_SRC_NEXT_DESC_PTR(val) 	bfin_write32(MDMA2_SRC_NEXT_DESC_PTR, val)
#define bfin_read_MDMA2_SRC_START_ADDR() 		bfin_read32(MDMA2_SRC_START_ADDR)
#define bfin_write_MDMA2_SRC_START_ADDR(val) 		bfin_write32(MDMA2_SRC_START_ADDR, val)
#define bfin_read_MDMA2_SRC_CONFIG()			bfin_read32(MDMA2_SRC_CONFIG)
#define bfin_write_MDMA2_SRC_CONFIG(val)		bfin_write32(MDMA2_SRC_CONFIG, val)
#define bfin_read_MDMA2_SRC_X_COUNT()			bfin_read32(MDMA2_SRC_X_COUNT)
#define bfin_write_MDMA2_SRC_X_COUNT(val)		bfin_write32(MDMA2_SRC_X_COUNT, val)
#define bfin_read_MDMA2_SRC_X_MODIFY()			bfin_read32(MDMA2_SRC_X_MODIFY)
#define bfin_write_MDMA2_SRC_X_MODIFY(val) 		bfin_write32(MDMA2_SRC_X_MODIFY, val)
#define bfin_read_MDMA2_SRC_Y_COUNT()			bfin_read32(MDMA2_SRC_Y_COUNT)
#define bfin_write_MDMA2_SRC_Y_COUNT(val)		bfin_write32(MDMA2_SRC_Y_COUNT, val)
#define bfin_read_MDMA2_SRC_Y_MODIFY()			bfin_read32(MDMA2_SRC_Y_MODIFY)
#define bfin_write_MDMA2_SRC_Y_MODIFY(val) 		bfin_write32(MDMA2_SRC_Y_MODIFY, val)
#define bfin_read_MDMA2_SRC_CURR_DESC_PTR() 		bfin_read32(MDMA2_SRC_CURR_DESC_PTR)
#define bfin_write_MDMA2_SRC_CURR_DESC_PTR(val)		bfin_write32(MDMA2_SRC_CURR_DESC_PTR, val)
#define bfin_read_MDMA2_SRC_PREV_DESC_PTR() 		bfin_read32(MDMA2_SRC_PREV_DESC_PTR)
#define bfin_write_MDMA2_SRC_PREV_DESC_PTR(val) 	bfin_write32(MDMA2_SRC_PREV_DESC_PTR, val)
#define bfin_read_MDMA2_SRC_CURR_ADDR() 		bfin_read32(MDMA2_SRC_CURR_ADDR)
#define bfin_write_MDMA2_SRC_CURR_ADDR(val) 		bfin_write32(MDMA2_SRC_CURR_ADDR, val)
#define bfin_read_MDMA2_SRC_IRQ_STATUS()		bfin_read32(MDMA2_SRC_IRQ_STATUS)
#define bfin_write_MDMA2_SRC_IRQ_STATUS(val)		bfin_write32(MDMA2_SRC_IRQ_STATUS, val)
#define bfin_read_MDMA2_SRC_CURR_X_COUNT()		bfin_read32(MDMA2_SRC_CURR_X_COUNT)
#define bfin_write_MDMA2_SRC_CURR_X_COUNT(val)		bfin_write32(MDMA2_SRC_CURR_X_COUNT, val)
#define bfin_read_MDMA2_SRC_CURR_Y_COUNT()		bfin_read32(MDMA2_SRC_CURR_Y_COUNT)
#define bfin_write_MDMA2_SRC_CURR_Y_COUNT(val)		bfin_write32(MDMA2_SRC_CURR_Y_COUNT, val)

/* MDMA Stream 3 Registers (DMA Channel 27 and 28) */

#define bfin_read_MDMA3_DEST_NEXT_DESC_PTR() 		bfin_read32(MDMA3_DEST_NEXT_DESC_PTR)
#define bfin_write_MDMA3_DEST_NEXT_DESC_PTR(val) 	bfin_write32(MDMA3_DEST_NEXT_DESC_PTR, val)
#define bfin_read_MDMA3_DEST_START_ADDR() 		bfin_read32(MDMA3_DEST_START_ADDR)
#define bfin_write_MDMA3_DEST_START_ADDR(val) 		bfin_write32(MDMA3_DEST_START_ADDR, val)
#define bfin_read_MDMA3_DEST_CONFIG()			bfin_read32(MDMA3_DEST_CONFIG)
#define bfin_write_MDMA3_DEST_CONFIG(val)		bfin_write32(MDMA3_DEST_CONFIG, val)
#define bfin_read_MDMA3_DEST_X_COUNT()			bfin_read32(MDMA3_DEST_X_COUNT)
#define bfin_write_MDMA3_DEST_X_COUNT(val)		bfin_write32(MDMA3_DEST_X_COUNT, val)
#define bfin_read_MDMA3_DEST_X_MODIFY()			bfin_read32(MDMA3_DEST_X_MODIFY)
#define bfin_write_MDMA3_DEST_X_MODIFY(val) 		bfin_write32(MDMA3_DEST_X_MODIFY, val)
#define bfin_read_MDMA3_DEST_Y_COUNT()			bfin_read32(MDMA3_DEST_Y_COUNT)
#define bfin_write_MDMA3_DEST_Y_COUNT(val)		bfin_write32(MDMA3_DEST_Y_COUNT, val)
#define bfin_read_MDMA3_DEST_Y_MODIFY()			bfin_read32(MDMA3_DEST_Y_MODIFY)
#define bfin_write_MDMA3_DEST_Y_MODIFY(val) 		bfin_write32(MDMA3_DEST_Y_MODIFY, val)
#define bfin_read_MDMA3_DEST_CURR_DESC_PTR() 		bfin_read32(MDMA3_DEST_CURR_DESC_PTR)
#define bfin_write_MDMA3_DEST_CURR_DESC_PTR(val) 	bfin_write32(MDMA3_DEST_CURR_DESC_PTR, val)
#define bfin_read_MDMA3_DEST_PREV_DESC_PTR()	 	bfin_read32(MDMA3_DEST_PREV_DESC_PTR)
#define bfin_write_MDMA3_DEST_PREV_DESC_PTR(val) 	bfin_write32(MDMA3_DEST_PREV_DESC_PTR, val)
#define bfin_read_MDMA3_DEST_CURR_ADDR() 		bfin_read32(MDMA3_DEST_CURR_ADDR)
#define bfin_write_MDMA3_DEST_CURR_ADDR(val) 		bfin_write32(MDMA3_DEST_CURR_ADDR, val)
#define bfin_read_MDMA3_DEST_IRQ_STATUS()		bfin_read32(MDMA3_DEST_IRQ_STATUS)
#define bfin_write_MDMA3_DEST_IRQ_STATUS(val)		bfin_write32(MDMA3_DEST_IRQ_STATUS, val)
#define bfin_read_MDMA3_DEST_CURR_X_COUNT()		bfin_read32(MDMA3_DEST_CURR_X_COUNT)
#define bfin_write_MDMA3_DEST_CURR_X_COUNT(val)		bfin_write32(MDMA3_DEST_CURR_X_COUNT, val)
#define bfin_read_MDMA3_DEST_CURR_Y_COUNT()		bfin_read32(MDMA3_DEST_CURR_Y_COUNT)
#define bfin_write_MDMA3_DEST_CURR_Y_COUNT(val)		bfin_write32(MDMA3_DEST_CURR_Y_COUNT, val)
#define bfin_read_MDMA3_SRC_NEXT_DESC_PTR() 		bfin_read32(MDMA3_SRC_NEXT_DESC_PTR)
#define bfin_write_MDMA3_SRC_NEXT_DESC_PTR(val) 	bfin_write32(MDMA3_SRC_NEXT_DESC_PTR, val)
#define bfin_read_MDMA3_SRC_START_ADDR() 		bfin_read32(MDMA3_SRC_START_ADDR)
#define bfin_write_MDMA3_SRC_START_ADDR(val) 		bfin_write32(MDMA3_SRC_START_ADDR, val)
#define bfin_read_MDMA3_SRC_CONFIG()			bfin_read32(MDMA3_SRC_CONFIG)
#define bfin_write_MDMA3_SRC_CONFIG(val)		bfin_write32(MDMA3_SRC_CONFIG, val)
#define bfin_read_MDMA3_SRC_X_COUNT()			bfin_read32(MDMA3_SRC_X_COUNT)
#define bfin_write_MDMA3_SRC_X_COUNT(val)		bfin_write32(MDMA3_SRC_X_COUNT, val)
#define bfin_read_MDMA3_SRC_X_MODIFY()			bfin_read32(MDMA3_SRC_X_MODIFY)
#define bfin_write_MDMA3_SRC_X_MODIFY(val) 		bfin_write32(MDMA3_SRC_X_MODIFY, val)
#define bfin_read_MDMA3_SRC_Y_COUNT()			bfin_read32(MDMA3_SRC_Y_COUNT)
#define bfin_write_MDMA3_SRC_Y_COUNT(val)		bfin_write32(MDMA3_SRC_Y_COUNT, val)
#define bfin_read_MDMA3_SRC_Y_MODIFY()			bfin_read32(MDMA3_SRC_Y_MODIFY)
#define bfin_write_MDMA3_SRC_Y_MODIFY(val) 		bfin_write32(MDMA3_SRC_Y_MODIFY, val)
#define bfin_read_MDMA3_SRC_CURR_DESC_PTR() 		bfin_read32(MDMA3_SRC_CURR_DESC_PTR)
#define bfin_write_MDMA3_SRC_CURR_DESC_PTR(val) 	bfin_write32(MDMA3_SRC_CURR_DESC_PTR, val)
#define bfin_read_MDMA3_SRC_PREV_DESC_PTR() 		bfin_read32(MDMA3_SRC_PREV_DESC_PTR)
#define bfin_write_MDMA3_SRC_PREV_DESC_PTR(val) 	bfin_write32(MDMA3_SRC_PREV_DESC_PTR, val)
#define bfin_read_MDMA3_SRC_CURR_ADDR() 		bfin_read32(MDMA3_SRC_CURR_ADDR)
#define bfin_write_MDMA3_SRC_CURR_ADDR(val) 		bfin_write32(MDMA3_SRC_CURR_ADDR, val)
#define bfin_read_MDMA3_SRC_IRQ_STATUS()		bfin_read32(MDMA3_SRC_IRQ_STATUS)
#define bfin_write_MDMA3_SRC_IRQ_STATUS(val)		bfin_write32(MDMA3_SRC_IRQ_STATUS, val)
#define bfin_read_MDMA3_SRC_CURR_X_COUNT()		bfin_read32(MDMA3_SRC_CURR_X_COUNT)
#define bfin_write_MDMA3_SRC_CURR_X_COUNT(val)		bfin_write32(MDMA3_SRC_CURR_X_COUNT, val)
#define bfin_read_MDMA3_SRC_CURR_Y_COUNT()		bfin_read32(MDMA3_SRC_CURR_Y_COUNT)
#define bfin_write_MDMA3_SRC_CURR_Y_COUNT(val)		bfin_write32(MDMA3_SRC_CURR_Y_COUNT, val)


/* DMA Channel 29 Registers */

#define bfin_read_DMA29_NEXT_DESC_PTR() 	bfin_read32(DMA29_NEXT_DESC_PTR)
#define bfin_write_DMA29_NEXT_DESC_PTR(val) 	bfin_write32(DMA29_NEXT_DESC_PTR, val)
#define bfin_read_DMA29_START_ADDR() 		bfin_read32(DMA29_START_ADDR)
#define bfin_write_DMA29_START_ADDR(val) 	bfin_write32(DMA29_START_ADDR, val)
#define bfin_read_DMA29_CONFIG()		bfin_read32(DMA29_CONFIG)
#define bfin_write_DMA29_CONFIG(val)		bfin_write32(DMA29_CONFIG, val)
#define bfin_read_DMA29_X_COUNT()		bfin_read32(DMA29_X_COUNT)
#define bfin_write_DMA29_X_COUNT(val)		bfin_write32(DMA29_X_COUNT, val)
#define bfin_read_DMA29_X_MODIFY()		bfin_read32(DMA29_X_MODIFY)
#define bfin_write_DMA29_X_MODIFY(val) 		bfin_write32(DMA29_X_MODIFY, val)
#define bfin_read_DMA29_Y_COUNT()		bfin_read32(DMA29_Y_COUNT)
#define bfin_write_DMA29_Y_COUNT(val)		bfin_write32(DMA29_Y_COUNT, val)
#define bfin_read_DMA29_Y_MODIFY()		bfin_read32(DMA29_Y_MODIFY)
#define bfin_write_DMA29_Y_MODIFY(val) 		bfin_write32(DMA29_Y_MODIFY, val)
#define bfin_read_DMA29_CURR_DESC_PTR() 	bfin_read32(DMA29_CURR_DESC_PTR)
#define bfin_write_DMA29_CURR_DESC_PTR(val) 	bfin_write32(DMA29_CURR_DESC_PTR, val)
#define bfin_read_DMA29_PREV_DESC_PTR() 	bfin_read32(DMA29_PREV_DESC_PTR)
#define bfin_write_DMA29_PREV_DESC_PTR(val) 	bfin_write32(DMA29_PREV_DESC_PTR, val)
#define bfin_read_DMA29_CURR_ADDR() 		bfin_read32(DMA29_CURR_ADDR)
#define bfin_write_DMA29_CURR_ADDR(val) 	bfin_write32(DMA29_CURR_ADDR, val)
#define bfin_read_DMA29_IRQ_STATUS()		bfin_read32(DMA29_IRQ_STATUS)
#define bfin_write_DMA29_IRQ_STATUS(val)	bfin_write32(DMA29_IRQ_STATUS, val)
#define bfin_read_DMA29_CURR_X_COUNT()		bfin_read32(DMA29_CURR_X_COUNT)
#define bfin_write_DMA29_CURR_X_COUNT(val)	bfin_write32(DMA29_CURR_X_COUNT, val)
#define bfin_read_DMA29_CURR_Y_COUNT()		bfin_read32(DMA29_CURR_Y_COUNT)
#define bfin_write_DMA29_CURR_Y_COUNT(val)	bfin_write32(DMA29_CURR_Y_COUNT, val)
#define bfin_read_DMA29_BWL_COUNT()		bfin_read32(DMA29_BWL_COUNT)
#define bfin_write_DMA29_BWL_COUNT(val)		bfin_write32(DMA29_BWL_COUNT, val)
#define bfin_read_DMA29_CURR_BWL_COUNT()	bfin_read32(DMA29_CURR_BWL_COUNT)
#define bfin_write_DMA29_CURR_BWL_COUNT(val)	bfin_write32(DMA29_CURR_BWL_COUNT, val)
#define bfin_read_DMA29_BWM_COUNT()		bfin_read32(DMA29_BWM_COUNT)
#define bfin_write_DMA29_BWM_COUNT(val)		bfin_write32(DMA29_BWM_COUNT, val)
#define bfin_read_DMA29_CURR_BWM_COUNT()	bfin_read32(DMA29_CURR_BWM_COUNT)
#define bfin_write_DMA29_CURR_BWM_COUNT(val)	bfin_write32(DMA29_CURR_BWM_COUNT, val)

/* DMA Channel 30 Registers */

#define bfin_read_DMA30_NEXT_DESC_PTR() 	bfin_read32(DMA30_NEXT_DESC_PTR)
#define bfin_write_DMA30_NEXT_DESC_PTR(val) 	bfin_write32(DMA30_NEXT_DESC_PTR, val)
#define bfin_read_DMA30_START_ADDR() 		bfin_read32(DMA30_START_ADDR)
#define bfin_write_DMA30_START_ADDR(val) 	bfin_write32(DMA30_START_ADDR, val)
#define bfin_read_DMA30_CONFIG()		bfin_read32(DMA30_CONFIG)
#define bfin_write_DMA30_CONFIG(val)		bfin_write32(DMA30_CONFIG, val)
#define bfin_read_DMA30_X_COUNT()		bfin_read32(DMA30_X_COUNT)
#define bfin_write_DMA30_X_COUNT(val)		bfin_write32(DMA30_X_COUNT, val)
#define bfin_read_DMA30_X_MODIFY()		bfin_read32(DMA30_X_MODIFY)
#define bfin_write_DMA30_X_MODIFY(val) 		bfin_write32(DMA30_X_MODIFY, val)
#define bfin_read_DMA30_Y_COUNT()		bfin_read32(DMA30_Y_COUNT)
#define bfin_write_DMA30_Y_COUNT(val)		bfin_write32(DMA30_Y_COUNT, val)
#define bfin_read_DMA30_Y_MODIFY()		bfin_read32(DMA30_Y_MODIFY)
#define bfin_write_DMA30_Y_MODIFY(val) 		bfin_write32(DMA30_Y_MODIFY, val)
#define bfin_read_DMA30_CURR_DESC_PTR() 	bfin_read32(DMA30_CURR_DESC_PTR)
#define bfin_write_DMA30_CURR_DESC_PTR(val) 	bfin_write32(DMA30_CURR_DESC_PTR, val)
#define bfin_read_DMA30_PREV_DESC_PTR() 	bfin_read32(DMA30_PREV_DESC_PTR)
#define bfin_write_DMA30_PREV_DESC_PTR(val) 	bfin_write32(DMA30_PREV_DESC_PTR, val)
#define bfin_read_DMA30_CURR_ADDR() 		bfin_read32(DMA30_CURR_ADDR)
#define bfin_write_DMA30_CURR_ADDR(val) 	bfin_write32(DMA30_CURR_ADDR, val)
#define bfin_read_DMA30_IRQ_STATUS()		bfin_read32(DMA30_IRQ_STATUS)
#define bfin_write_DMA30_IRQ_STATUS(val)	bfin_write32(DMA30_IRQ_STATUS, val)
#define bfin_read_DMA30_CURR_X_COUNT()		bfin_read32(DMA30_CURR_X_COUNT)
#define bfin_write_DMA30_CURR_X_COUNT(val)	bfin_write32(DMA30_CURR_X_COUNT, val)
#define bfin_read_DMA30_CURR_Y_COUNT()		bfin_read32(DMA30_CURR_Y_COUNT)
#define bfin_write_DMA30_CURR_Y_COUNT(val)	bfin_write32(DMA30_CURR_Y_COUNT, val)
#define bfin_read_DMA30_BWL_COUNT()		bfin_read32(DMA30_BWL_COUNT)
#define bfin_write_DMA30_BWL_COUNT(val)		bfin_write32(DMA30_BWL_COUNT, val)
#define bfin_read_DMA30_CURR_BWL_COUNT()	bfin_read32(DMA30_CURR_BWL_COUNT)
#define bfin_write_DMA30_CURR_BWL_COUNT(val)	bfin_write32(DMA30_CURR_BWL_COUNT, val)
#define bfin_read_DMA30_BWM_COUNT()		bfin_read32(DMA30_BWM_COUNT)
#define bfin_write_DMA30_BWM_COUNT(val)		bfin_write32(DMA30_BWM_COUNT, val)
#define bfin_read_DMA30_CURR_BWM_COUNT()	bfin_read32(DMA30_CURR_BWM_COUNT)
#define bfin_write_DMA30_CURR_BWM_COUNT(val)	bfin_write32(DMA30_CURR_BWM_COUNT, val)

/* DMA Channel 31 Registers */

#define bfin_read_DMA31_NEXT_DESC_PTR() 	bfin_read32(DMA31_NEXT_DESC_PTR)
#define bfin_write_DMA31_NEXT_DESC_PTR(val) 	bfin_write32(DMA31_NEXT_DESC_PTR, val)
#define bfin_read_DMA31_START_ADDR() 		bfin_read32(DMA31_START_ADDR)
#define bfin_write_DMA31_START_ADDR(val) 	bfin_write32(DMA31_START_ADDR, val)
#define bfin_read_DMA31_CONFIG()		bfin_read32(DMA31_CONFIG)
#define bfin_write_DMA31_CONFIG(val)		bfin_write32(DMA31_CONFIG, val)
#define bfin_read_DMA31_X_COUNT()		bfin_read32(DMA31_X_COUNT)
#define bfin_write_DMA31_X_COUNT(val)		bfin_write32(DMA31_X_COUNT, val)
#define bfin_read_DMA31_X_MODIFY()		bfin_read32(DMA31_X_MODIFY)
#define bfin_write_DMA31_X_MODIFY(val) 		bfin_write32(DMA31_X_MODIFY, val)
#define bfin_read_DMA31_Y_COUNT()		bfin_read32(DMA31_Y_COUNT)
#define bfin_write_DMA31_Y_COUNT(val)		bfin_write32(DMA31_Y_COUNT, val)
#define bfin_read_DMA31_Y_MODIFY()		bfin_read32(DMA31_Y_MODIFY)
#define bfin_write_DMA31_Y_MODIFY(val) 		bfin_write32(DMA31_Y_MODIFY, val)
#define bfin_read_DMA31_CURR_DESC_PTR() 	bfin_read32(DMA31_CURR_DESC_PTR)
#define bfin_write_DMA31_CURR_DESC_PTR(val) 	bfin_write32(DMA31_CURR_DESC_PTR, val)
#define bfin_read_DMA31_PREV_DESC_PTR() 	bfin_read32(DMA31_PREV_DESC_PTR)
#define bfin_write_DMA31_PREV_DESC_PTR(val) 	bfin_write32(DMA31_PREV_DESC_PTR, val)
#define bfin_read_DMA31_CURR_ADDR() 		bfin_read32(DMA31_CURR_ADDR)
#define bfin_write_DMA31_CURR_ADDR(val) 	bfin_write32(DMA31_CURR_ADDR, val)
#define bfin_read_DMA31_IRQ_STATUS()		bfin_read32(DMA31_IRQ_STATUS)
#define bfin_write_DMA31_IRQ_STATUS(val)	bfin_write32(DMA31_IRQ_STATUS, val)
#define bfin_read_DMA31_CURR_X_COUNT()		bfin_read32(DMA31_CURR_X_COUNT)
#define bfin_write_DMA31_CURR_X_COUNT(val)	bfin_write32(DMA31_CURR_X_COUNT, val)
#define bfin_read_DMA31_CURR_Y_COUNT()		bfin_read32(DMA31_CURR_Y_COUNT)
#define bfin_write_DMA31_CURR_Y_COUNT(val)	bfin_write32(DMA31_CURR_Y_COUNT, val)
#define bfin_read_DMA31_BWL_COUNT()		bfin_read32(DMA31_BWL_COUNT)
#define bfin_write_DMA31_BWL_COUNT(val)		bfin_write32(DMA31_BWL_COUNT, val)
#define bfin_read_DMA31_CURR_BWL_COUNT()	bfin_read32(DMA31_CURR_BWL_COUNT)
#define bfin_write_DMA31_CURR_BWL_COUNT(val)	bfin_write32(DMA31_CURR_BWL_COUNT, val)
#define bfin_read_DMA31_BWM_COUNT()		bfin_read32(DMA31_BWM_COUNT)
#define bfin_write_DMA31_BWM_COUNT(val)		bfin_write32(DMA31_BWM_COUNT, val)
#define bfin_read_DMA31_CURR_BWM_COUNT()	bfin_read32(DMA31_CURR_BWM_COUNT)
#define bfin_write_DMA31_CURR_BWM_COUNT(val)	bfin_write32(DMA31_CURR_BWM_COUNT, val)

/* DMA Channel 32 Registers */

#define bfin_read_DMA32_NEXT_DESC_PTR() 	bfin_read32(DMA32_NEXT_DESC_PTR)
#define bfin_write_DMA32_NEXT_DESC_PTR(val) 	bfin_write32(DMA32_NEXT_DESC_PTR, val)
#define bfin_read_DMA32_START_ADDR() 		bfin_read32(DMA32_START_ADDR)
#define bfin_write_DMA32_START_ADDR(val) 	bfin_write32(DMA32_START_ADDR, val)
#define bfin_read_DMA32_CONFIG()		bfin_read32(DMA32_CONFIG)
#define bfin_write_DMA32_CONFIG(val)		bfin_write32(DMA32_CONFIG, val)
#define bfin_read_DMA32_X_COUNT()		bfin_read32(DMA32_X_COUNT)
#define bfin_write_DMA32_X_COUNT(val)		bfin_write32(DMA32_X_COUNT, val)
#define bfin_read_DMA32_X_MODIFY()		bfin_read32(DMA32_X_MODIFY)
#define bfin_write_DMA32_X_MODIFY(val) 		bfin_write32(DMA32_X_MODIFY, val)
#define bfin_read_DMA32_Y_COUNT()		bfin_read32(DMA32_Y_COUNT)
#define bfin_write_DMA32_Y_COUNT(val)		bfin_write32(DMA32_Y_COUNT, val)
#define bfin_read_DMA32_Y_MODIFY()		bfin_read32(DMA32_Y_MODIFY)
#define bfin_write_DMA32_Y_MODIFY(val) 		bfin_write32(DMA32_Y_MODIFY, val)
#define bfin_read_DMA32_CURR_DESC_PTR() 	bfin_read32(DMA32_CURR_DESC_PTR)
#define bfin_write_DMA32_CURR_DESC_PTR(val) 	bfin_write32(DMA32_CURR_DESC_PTR, val)
#define bfin_read_DMA32_PREV_DESC_PTR() 	bfin_read32(DMA32_PREV_DESC_PTR)
#define bfin_write_DMA32_PREV_DESC_PTR(val) 	bfin_write32(DMA32_PREV_DESC_PTR, val)
#define bfin_read_DMA32_CURR_ADDR() 		bfin_read32(DMA32_CURR_ADDR)
#define bfin_write_DMA32_CURR_ADDR(val) 	bfin_write32(DMA32_CURR_ADDR, val)
#define bfin_read_DMA32_IRQ_STATUS()		bfin_read32(DMA32_IRQ_STATUS)
#define bfin_write_DMA32_IRQ_STATUS(val)	bfin_write32(DMA32_IRQ_STATUS, val)
#define bfin_read_DMA32_CURR_X_COUNT()		bfin_read32(DMA32_CURR_X_COUNT)
#define bfin_write_DMA32_CURR_X_COUNT(val)	bfin_write32(DMA32_CURR_X_COUNT, val)
#define bfin_read_DMA32_CURR_Y_COUNT()		bfin_read32(DMA32_CURR_Y_COUNT)
#define bfin_write_DMA32_CURR_Y_COUNT(val)	bfin_write32(DMA32_CURR_Y_COUNT, val)
#define bfin_read_DMA32_BWL_COUNT()		bfin_read32(DMA32_BWL_COUNT)
#define bfin_write_DMA32_BWL_COUNT(val)		bfin_write32(DMA32_BWL_COUNT, val)
#define bfin_read_DMA32_CURR_BWL_COUNT()	bfin_read32(DMA32_CURR_BWL_COUNT)
#define bfin_write_DMA32_CURR_BWL_COUNT(val)	bfin_write32(DMA32_CURR_BWL_COUNT, val)
#define bfin_read_DMA32_BWM_COUNT()		bfin_read32(DMA32_BWM_COUNT)
#define bfin_write_DMA32_BWM_COUNT(val)		bfin_write32(DMA32_BWM_COUNT, val)
#define bfin_read_DMA32_CURR_BWM_COUNT()	bfin_read32(DMA32_CURR_BWM_COUNT)
#define bfin_write_DMA32_CURR_BWM_COUNT(val)	bfin_write32(DMA32_CURR_BWM_COUNT, val)

/* DMA Channel 33 Registers */

#define bfin_read_DMA33_NEXT_DESC_PTR() 	bfin_read32(DMA33_NEXT_DESC_PTR)
#define bfin_write_DMA33_NEXT_DESC_PTR(val) 	bfin_write32(DMA33_NEXT_DESC_PTR, val)
#define bfin_read_DMA33_START_ADDR() 		bfin_read32(DMA33_START_ADDR)
#define bfin_write_DMA33_START_ADDR(val) 	bfin_write32(DMA33_START_ADDR, val)
#define bfin_read_DMA33_CONFIG()		bfin_read32(DMA33_CONFIG)
#define bfin_write_DMA33_CONFIG(val)		bfin_write32(DMA33_CONFIG, val)
#define bfin_read_DMA33_X_COUNT()		bfin_read32(DMA33_X_COUNT)
#define bfin_write_DMA33_X_COUNT(val)		bfin_write32(DMA33_X_COUNT, val)
#define bfin_read_DMA33_X_MODIFY()		bfin_read32(DMA33_X_MODIFY)
#define bfin_write_DMA33_X_MODIFY(val) 		bfin_write32(DMA33_X_MODIFY, val)
#define bfin_read_DMA33_Y_COUNT()		bfin_read32(DMA33_Y_COUNT)
#define bfin_write_DMA33_Y_COUNT(val)		bfin_write32(DMA33_Y_COUNT, val)
#define bfin_read_DMA33_Y_MODIFY()		bfin_read32(DMA33_Y_MODIFY)
#define bfin_write_DMA33_Y_MODIFY(val) 		bfin_write32(DMA33_Y_MODIFY, val)
#define bfin_read_DMA33_CURR_DESC_PTR() 	bfin_read32(DMA33_CURR_DESC_PTR)
#define bfin_write_DMA33_CURR_DESC_PTR(val) 	bfin_write32(DMA33_CURR_DESC_PTR, val)
#define bfin_read_DMA33_PREV_DESC_PTR() 	bfin_read32(DMA33_PREV_DESC_PTR)
#define bfin_write_DMA33_PREV_DESC_PTR(val) 	bfin_write32(DMA33_PREV_DESC_PTR, val)
#define bfin_read_DMA33_CURR_ADDR() 		bfin_read32(DMA33_CURR_ADDR)
#define bfin_write_DMA33_CURR_ADDR(val) 	bfin_write32(DMA33_CURR_ADDR, val)
#define bfin_read_DMA33_IRQ_STATUS()		bfin_read32(DMA33_IRQ_STATUS)
#define bfin_write_DMA33_IRQ_STATUS(val)	bfin_write32(DMA33_IRQ_STATUS, val)
#define bfin_read_DMA33_CURR_X_COUNT()		bfin_read32(DMA33_CURR_X_COUNT)
#define bfin_write_DMA33_CURR_X_COUNT(val)	bfin_write32(DMA33_CURR_X_COUNT, val)
#define bfin_read_DMA33_CURR_Y_COUNT()		bfin_read32(DMA33_CURR_Y_COUNT)
#define bfin_write_DMA33_CURR_Y_COUNT(val)	bfin_write32(DMA33_CURR_Y_COUNT, val)
#define bfin_read_DMA33_BWL_COUNT()		bfin_read32(DMA33_BWL_COUNT)
#define bfin_write_DMA33_BWL_COUNT(val)		bfin_write32(DMA33_BWL_COUNT, val)
#define bfin_read_DMA33_CURR_BWL_COUNT()	bfin_read32(DMA33_CURR_BWL_COUNT)
#define bfin_write_DMA33_CURR_BWL_COUNT(val)	bfin_write32(DMA33_CURR_BWL_COUNT, val)
#define bfin_read_DMA33_BWM_COUNT()		bfin_read32(DMA33_BWM_COUNT)
#define bfin_write_DMA33_BWM_COUNT(val)		bfin_write32(DMA33_BWM_COUNT, val)
#define bfin_read_DMA33_CURR_BWM_COUNT()	bfin_read32(DMA33_CURR_BWM_COUNT)
#define bfin_write_DMA33_CURR_BWM_COUNT(val)	bfin_write32(DMA33_CURR_BWM_COUNT, val)

/* DMA Channel 34 Registers */

#define bfin_read_DMA34_NEXT_DESC_PTR() 	bfin_read32(DMA34_NEXT_DESC_PTR)
#define bfin_write_DMA34_NEXT_DESC_PTR(val) 	bfin_write32(DMA34_NEXT_DESC_PTR, val)
#define bfin_read_DMA34_START_ADDR() 		bfin_read32(DMA34_START_ADDR)
#define bfin_write_DMA34_START_ADDR(val) 	bfin_write32(DMA34_START_ADDR, val)
#define bfin_read_DMA34_CONFIG()		bfin_read32(DMA34_CONFIG)
#define bfin_write_DMA34_CONFIG(val)		bfin_write32(DMA34_CONFIG, val)
#define bfin_read_DMA34_X_COUNT()		bfin_read32(DMA34_X_COUNT)
#define bfin_write_DMA34_X_COUNT(val)		bfin_write32(DMA34_X_COUNT, val)
#define bfin_read_DMA34_X_MODIFY()		bfin_read32(DMA34_X_MODIFY)
#define bfin_write_DMA34_X_MODIFY(val) 		bfin_write32(DMA34_X_MODIFY, val)
#define bfin_read_DMA34_Y_COUNT()		bfin_read32(DMA34_Y_COUNT)
#define bfin_write_DMA34_Y_COUNT(val)		bfin_write32(DMA34_Y_COUNT, val)
#define bfin_read_DMA34_Y_MODIFY()		bfin_read32(DMA34_Y_MODIFY)
#define bfin_write_DMA34_Y_MODIFY(val) 		bfin_write32(DMA34_Y_MODIFY, val)
#define bfin_read_DMA34_CURR_DESC_PTR() 	bfin_read32(DMA34_CURR_DESC_PTR)
#define bfin_write_DMA34_CURR_DESC_PTR(val) 	bfin_write32(DMA34_CURR_DESC_PTR, val)
#define bfin_read_DMA34_PREV_DESC_PTR() 	bfin_read32(DMA34_PREV_DESC_PTR)
#define bfin_write_DMA34_PREV_DESC_PTR(val) 	bfin_write32(DMA34_PREV_DESC_PTR, val)
#define bfin_read_DMA34_CURR_ADDR() 		bfin_read32(DMA34_CURR_ADDR)
#define bfin_write_DMA34_CURR_ADDR(val) 	bfin_write32(DMA34_CURR_ADDR, val)
#define bfin_read_DMA34_IRQ_STATUS()		bfin_read32(DMA34_IRQ_STATUS)
#define bfin_write_DMA34_IRQ_STATUS(val)	bfin_write32(DMA34_IRQ_STATUS, val)
#define bfin_read_DMA34_CURR_X_COUNT()		bfin_read32(DMA34_CURR_X_COUNT)
#define bfin_write_DMA34_CURR_X_COUNT(val)	bfin_write32(DMA34_CURR_X_COUNT, val)
#define bfin_read_DMA34_CURR_Y_COUNT()		bfin_read32(DMA34_CURR_Y_COUNT)
#define bfin_write_DMA34_CURR_Y_COUNT(val)	bfin_write32(DMA34_CURR_Y_COUNT, val)
#define bfin_read_DMA34_BWL_COUNT()		bfin_read32(DMA34_BWL_COUNT)
#define bfin_write_DMA34_BWL_COUNT(val)		bfin_write32(DMA34_BWL_COUNT, val)
#define bfin_read_DMA34_CURR_BWL_COUNT()	bfin_read32(DMA34_CURR_BWL_COUNT)
#define bfin_write_DMA34_CURR_BWL_COUNT(val)	bfin_write32(DMA34_CURR_BWL_COUNT, val)
#define bfin_read_DMA34_BWM_COUNT()		bfin_read32(DMA34_BWM_COUNT)
#define bfin_write_DMA34_BWM_COUNT(val)		bfin_write32(DMA34_BWM_COUNT, val)
#define bfin_read_DMA34_CURR_BWM_COUNT()	bfin_read32(DMA34_CURR_BWM_COUNT)
#define bfin_write_DMA34_CURR_BWM_COUNT(val)	bfin_write32(DMA34_CURR_BWM_COUNT, val)

/* DMA Channel 35 Registers */

#define bfin_read_DMA35_NEXT_DESC_PTR() 	bfin_read32(DMA35_NEXT_DESC_PTR)
#define bfin_write_DMA35_NEXT_DESC_PTR(val) 	bfin_write32(DMA35_NEXT_DESC_PTR, val)
#define bfin_read_DMA35_START_ADDR() 		bfin_read32(DMA35_START_ADDR)
#define bfin_write_DMA35_START_ADDR(val) 	bfin_write32(DMA35_START_ADDR, val)
#define bfin_read_DMA35_CONFIG()		bfin_read32(DMA35_CONFIG)
#define bfin_write_DMA35_CONFIG(val)		bfin_write32(DMA35_CONFIG, val)
#define bfin_read_DMA35_X_COUNT()		bfin_read32(DMA35_X_COUNT)
#define bfin_write_DMA35_X_COUNT(val)		bfin_write32(DMA35_X_COUNT, val)
#define bfin_read_DMA35_X_MODIFY()		bfin_read32(DMA35_X_MODIFY)
#define bfin_write_DMA35_X_MODIFY(val) 		bfin_write32(DMA35_X_MODIFY, val)
#define bfin_read_DMA35_Y_COUNT()		bfin_read32(DMA35_Y_COUNT)
#define bfin_write_DMA35_Y_COUNT(val)		bfin_write32(DMA35_Y_COUNT, val)
#define bfin_read_DMA35_Y_MODIFY()		bfin_read32(DMA35_Y_MODIFY)
#define bfin_write_DMA35_Y_MODIFY(val) 		bfin_write32(DMA35_Y_MODIFY, val)
#define bfin_read_DMA35_CURR_DESC_PTR() 	bfin_read32(DMA35_CURR_DESC_PTR)
#define bfin_write_DMA35_CURR_DESC_PTR(val) 	bfin_write32(DMA35_CURR_DESC_PTR, val)
#define bfin_read_DMA35_PREV_DESC_PTR() 	bfin_read32(DMA35_PREV_DESC_PTR)
#define bfin_write_DMA35_PREV_DESC_PTR(val) 	bfin_write32(DMA35_PREV_DESC_PTR, val)
#define bfin_read_DMA35_CURR_ADDR() 		bfin_read32(DMA35_CURR_ADDR)
#define bfin_write_DMA35_CURR_ADDR(val) 	bfin_write32(DMA35_CURR_ADDR, val)
#define bfin_read_DMA35_IRQ_STATUS()		bfin_read32(DMA35_IRQ_STATUS)
#define bfin_write_DMA35_IRQ_STATUS(val)	bfin_write32(DMA35_IRQ_STATUS, val)
#define bfin_read_DMA35_CURR_X_COUNT()		bfin_read32(DMA35_CURR_X_COUNT)
#define bfin_write_DMA35_CURR_X_COUNT(val)	bfin_write32(DMA35_CURR_X_COUNT, val)
#define bfin_read_DMA35_CURR_Y_COUNT()		bfin_read32(DMA35_CURR_Y_COUNT)
#define bfin_write_DMA35_CURR_Y_COUNT(val)	bfin_write32(DMA35_CURR_Y_COUNT, val)
#define bfin_read_DMA35_BWL_COUNT()		bfin_read32(DMA35_BWL_COUNT)
#define bfin_write_DMA35_BWL_COUNT(val)		bfin_write32(DMA35_BWL_COUNT, val)
#define bfin_read_DMA35_CURR_BWL_COUNT()	bfin_read32(DMA35_CURR_BWL_COUNT)
#define bfin_write_DMA35_CURR_BWL_COUNT(val)	bfin_write32(DMA35_CURR_BWL_COUNT, val)
#define bfin_read_DMA35_BWM_COUNT()		bfin_read32(DMA35_BWM_COUNT)
#define bfin_write_DMA35_BWM_COUNT(val)		bfin_write32(DMA35_BWM_COUNT, val)
#define bfin_read_DMA35_CURR_BWM_COUNT()	bfin_read32(DMA35_CURR_BWM_COUNT)
#define bfin_write_DMA35_CURR_BWM_COUNT(val)	bfin_write32(DMA35_CURR_BWM_COUNT, val)

/* DMA Channel 36 Registers */

#define bfin_read_DMA36_NEXT_DESC_PTR() 	bfin_read32(DMA36_NEXT_DESC_PTR)
#define bfin_write_DMA36_NEXT_DESC_PTR(val) 	bfin_write32(DMA36_NEXT_DESC_PTR, val)
#define bfin_read_DMA36_START_ADDR() 		bfin_read32(DMA36_START_ADDR)
#define bfin_write_DMA36_START_ADDR(val) 	bfin_write32(DMA36_START_ADDR, val)
#define bfin_read_DMA36_CONFIG()		bfin_read32(DMA36_CONFIG)
#define bfin_write_DMA36_CONFIG(val)		bfin_write32(DMA36_CONFIG, val)
#define bfin_read_DMA36_X_COUNT()		bfin_read32(DMA36_X_COUNT)
#define bfin_write_DMA36_X_COUNT(val)		bfin_write32(DMA36_X_COUNT, val)
#define bfin_read_DMA36_X_MODIFY()		bfin_read32(DMA36_X_MODIFY)
#define bfin_write_DMA36_X_MODIFY(val) 		bfin_write32(DMA36_X_MODIFY, val)
#define bfin_read_DMA36_Y_COUNT()		bfin_read32(DMA36_Y_COUNT)
#define bfin_write_DMA36_Y_COUNT(val)		bfin_write32(DMA36_Y_COUNT, val)
#define bfin_read_DMA36_Y_MODIFY()		bfin_read32(DMA36_Y_MODIFY)
#define bfin_write_DMA36_Y_MODIFY(val) 		bfin_write32(DMA36_Y_MODIFY, val)
#define bfin_read_DMA36_CURR_DESC_PTR() 	bfin_read32(DMA36_CURR_DESC_PTR)
#define bfin_write_DMA36_CURR_DESC_PTR(val) 	bfin_write32(DMA36_CURR_DESC_PTR, val)
#define bfin_read_DMA36_PREV_DESC_PTR() 	bfin_read32(DMA36_PREV_DESC_PTR)
#define bfin_write_DMA36_PREV_DESC_PTR(val) 	bfin_write32(DMA36_PREV_DESC_PTR, val)
#define bfin_read_DMA36_CURR_ADDR() 		bfin_read32(DMA36_CURR_ADDR)
#define bfin_write_DMA36_CURR_ADDR(val) 	bfin_write32(DMA36_CURR_ADDR, val)
#define bfin_read_DMA36_IRQ_STATUS()		bfin_read32(DMA36_IRQ_STATUS)
#define bfin_write_DMA36_IRQ_STATUS(val)	bfin_write32(DMA36_IRQ_STATUS, val)
#define bfin_read_DMA36_CURR_X_COUNT()		bfin_read32(DMA36_CURR_X_COUNT)
#define bfin_write_DMA36_CURR_X_COUNT(val)	bfin_write32(DMA36_CURR_X_COUNT, val)
#define bfin_read_DMA36_CURR_Y_COUNT()		bfin_read32(DMA36_CURR_Y_COUNT)
#define bfin_write_DMA36_CURR_Y_COUNT(val)	bfin_write32(DMA36_CURR_Y_COUNT, val)
#define bfin_read_DMA36_BWL_COUNT()		bfin_read32(DMA36_BWL_COUNT)
#define bfin_write_DMA36_BWL_COUNT(val)		bfin_write32(DMA36_BWL_COUNT, val)
#define bfin_read_DMA36_CURR_BWL_COUNT()	bfin_read32(DMA36_CURR_BWL_COUNT)
#define bfin_write_DMA36_CURR_BWL_COUNT(val)	bfin_write32(DMA36_CURR_BWL_COUNT, val)
#define bfin_read_DMA36_BWM_COUNT()		bfin_read32(DMA36_BWM_COUNT)
#define bfin_write_DMA36_BWM_COUNT(val)		bfin_write32(DMA36_BWM_COUNT, val)
#define bfin_read_DMA36_CURR_BWM_COUNT()	bfin_read32(DMA36_CURR_BWM_COUNT)
#define bfin_write_DMA36_CURR_BWM_COUNT(val)	bfin_write32(DMA36_CURR_BWM_COUNT, val)

/* DMA Channel 37 Registers */

#define bfin_read_DMA37_NEXT_DESC_PTR() 	bfin_read32(DMA37_NEXT_DESC_PTR)
#define bfin_write_DMA37_NEXT_DESC_PTR(val) 	bfin_write32(DMA37_NEXT_DESC_PTR, val)
#define bfin_read_DMA37_START_ADDR() 		bfin_read32(DMA37_START_ADDR)
#define bfin_write_DMA37_START_ADDR(val) 	bfin_write32(DMA37_START_ADDR, val)
#define bfin_read_DMA37_CONFIG()		bfin_read32(DMA37_CONFIG)
#define bfin_write_DMA37_CONFIG(val)		bfin_write32(DMA37_CONFIG, val)
#define bfin_read_DMA37_X_COUNT()		bfin_read32(DMA37_X_COUNT)
#define bfin_write_DMA37_X_COUNT(val)		bfin_write32(DMA37_X_COUNT, val)
#define bfin_read_DMA37_X_MODIFY()		bfin_read32(DMA37_X_MODIFY)
#define bfin_write_DMA37_X_MODIFY(val) 		bfin_write32(DMA37_X_MODIFY, val)
#define bfin_read_DMA37_Y_COUNT()		bfin_read32(DMA37_Y_COUNT)
#define bfin_write_DMA37_Y_COUNT(val)		bfin_write32(DMA37_Y_COUNT, val)
#define bfin_read_DMA37_Y_MODIFY()		bfin_read32(DMA37_Y_MODIFY)
#define bfin_write_DMA37_Y_MODIFY(val) 		bfin_write32(DMA37_Y_MODIFY, val)
#define bfin_read_DMA37_CURR_DESC_PTR() 	bfin_read32(DMA37_CURR_DESC_PTR)
#define bfin_write_DMA37_CURR_DESC_PTR(val) 	bfin_write32(DMA37_CURR_DESC_PTR, val)
#define bfin_read_DMA37_PREV_DESC_PTR() 	bfin_read32(DMA37_PREV_DESC_PTR)
#define bfin_write_DMA37_PREV_DESC_PTR(val) 	bfin_write32(DMA37_PREV_DESC_PTR, val)
#define bfin_read_DMA37_CURR_ADDR() 		bfin_read32(DMA37_CURR_ADDR)
#define bfin_write_DMA37_CURR_ADDR(val) 	bfin_write32(DMA37_CURR_ADDR, val)
#define bfin_read_DMA37_IRQ_STATUS()		bfin_read32(DMA37_IRQ_STATUS)
#define bfin_write_DMA37_IRQ_STATUS(val)	bfin_write32(DMA37_IRQ_STATUS, val)
#define bfin_read_DMA37_CURR_X_COUNT()		bfin_read32(DMA37_CURR_X_COUNT)
#define bfin_write_DMA37_CURR_X_COUNT(val)	bfin_write32(DMA37_CURR_X_COUNT, val)
#define bfin_read_DMA37_CURR_Y_COUNT()		bfin_read32(DMA37_CURR_Y_COUNT)
#define bfin_write_DMA37_CURR_Y_COUNT(val)	bfin_write32(DMA37_CURR_Y_COUNT, val)
#define bfin_read_DMA37_BWL_COUNT()		bfin_read32(DMA37_BWL_COUNT)
#define bfin_write_DMA37_BWL_COUNT(val)		bfin_write32(DMA37_BWL_COUNT, val)
#define bfin_read_DMA37_CURR_BWL_COUNT()	bfin_read32(DMA37_CURR_BWL_COUNT)
#define bfin_write_DMA37_CURR_BWL_COUNT(val)	bfin_write32(DMA37_CURR_BWL_COUNT, val)
#define bfin_read_DMA37_BWM_COUNT()		bfin_read32(DMA37_BWM_COUNT)
#define bfin_write_DMA37_BWM_COUNT(val)		bfin_write32(DMA37_BWM_COUNT, val)
#define bfin_read_DMA37_CURR_BWM_COUNT()	bfin_read32(DMA37_CURR_BWM_COUNT)
#define bfin_write_DMA37_CURR_BWM_COUNT(val)	bfin_write32(DMA37_CURR_BWM_COUNT, val)

/* DMA Channel 38 Registers */

#define bfin_read_DMA38_NEXT_DESC_PTR() 	bfin_read32(DMA38_NEXT_DESC_PTR)
#define bfin_write_DMA38_NEXT_DESC_PTR(val) 	bfin_write32(DMA38_NEXT_DESC_PTR, val)
#define bfin_read_DMA38_START_ADDR() 		bfin_read32(DMA38_START_ADDR)
#define bfin_write_DMA38_START_ADDR(val) 	bfin_write32(DMA38_START_ADDR, val)
#define bfin_read_DMA38_CONFIG()		bfin_read32(DMA38_CONFIG)
#define bfin_write_DMA38_CONFIG(val)		bfin_write32(DMA38_CONFIG, val)
#define bfin_read_DMA38_X_COUNT()		bfin_read32(DMA38_X_COUNT)
#define bfin_write_DMA38_X_COUNT(val)		bfin_write32(DMA38_X_COUNT, val)
#define bfin_read_DMA38_X_MODIFY()		bfin_read32(DMA38_X_MODIFY)
#define bfin_write_DMA38_X_MODIFY(val) 		bfin_write32(DMA38_X_MODIFY, val)
#define bfin_read_DMA38_Y_COUNT()		bfin_read32(DMA38_Y_COUNT)
#define bfin_write_DMA38_Y_COUNT(val)		bfin_write32(DMA38_Y_COUNT, val)
#define bfin_read_DMA38_Y_MODIFY()		bfin_read32(DMA38_Y_MODIFY)
#define bfin_write_DMA38_Y_MODIFY(val) 		bfin_write32(DMA38_Y_MODIFY, val)
#define bfin_read_DMA38_CURR_DESC_PTR() 	bfin_read32(DMA38_CURR_DESC_PTR)
#define bfin_write_DMA38_CURR_DESC_PTR(val) 	bfin_write32(DMA38_CURR_DESC_PTR, val)
#define bfin_read_DMA38_PREV_DESC_PTR() 	bfin_read32(DMA38_PREV_DESC_PTR)
#define bfin_write_DMA38_PREV_DESC_PTR(val) 	bfin_write32(DMA38_PREV_DESC_PTR, val)
#define bfin_read_DMA38_CURR_ADDR() 		bfin_read32(DMA38_CURR_ADDR)
#define bfin_write_DMA38_CURR_ADDR(val) 	bfin_write32(DMA38_CURR_ADDR, val)
#define bfin_read_DMA38_IRQ_STATUS()		bfin_read32(DMA38_IRQ_STATUS)
#define bfin_write_DMA38_IRQ_STATUS(val)	bfin_write32(DMA38_IRQ_STATUS, val)
#define bfin_read_DMA38_CURR_X_COUNT()		bfin_read32(DMA38_CURR_X_COUNT)
#define bfin_write_DMA38_CURR_X_COUNT(val)	bfin_write32(DMA38_CURR_X_COUNT, val)
#define bfin_read_DMA38_CURR_Y_COUNT()		bfin_read32(DMA38_CURR_Y_COUNT)
#define bfin_write_DMA38_CURR_Y_COUNT(val)	bfin_write32(DMA38_CURR_Y_COUNT, val)
#define bfin_read_DMA38_BWL_COUNT()		bfin_read32(DMA38_BWL_COUNT)
#define bfin_write_DMA38_BWL_COUNT(val)		bfin_write32(DMA38_BWL_COUNT, val)
#define bfin_read_DMA38_CURR_BWL_COUNT()	bfin_read32(DMA38_CURR_BWL_COUNT)
#define bfin_write_DMA38_CURR_BWL_COUNT(val)	bfin_write32(DMA38_CURR_BWL_COUNT, val)
#define bfin_read_DMA38_BWM_COUNT()		bfin_read32(DMA38_BWM_COUNT)
#define bfin_write_DMA38_BWM_COUNT(val)		bfin_write32(DMA38_BWM_COUNT, val)
#define bfin_read_DMA38_CURR_BWM_COUNT()	bfin_read32(DMA38_CURR_BWM_COUNT)
#define bfin_write_DMA38_CURR_BWM_COUNT(val)	bfin_write32(DMA38_CURR_BWM_COUNT, val)

/* DMA Channel 39 Registers */

#define bfin_read_DMA39_NEXT_DESC_PTR() 	bfin_read32(DMA39_NEXT_DESC_PTR)
#define bfin_write_DMA39_NEXT_DESC_PTR(val) 	bfin_write32(DMA39_NEXT_DESC_PTR, val)
#define bfin_read_DMA39_START_ADDR() 		bfin_read32(DMA39_START_ADDR)
#define bfin_write_DMA39_START_ADDR(val) 	bfin_write32(DMA39_START_ADDR, val)
#define bfin_read_DMA39_CONFIG()		bfin_read32(DMA39_CONFIG)
#define bfin_write_DMA39_CONFIG(val)		bfin_write32(DMA39_CONFIG, val)
#define bfin_read_DMA39_X_COUNT()		bfin_read32(DMA39_X_COUNT)
#define bfin_write_DMA39_X_COUNT(val)		bfin_write32(DMA39_X_COUNT, val)
#define bfin_read_DMA39_X_MODIFY()		bfin_read32(DMA39_X_MODIFY)
#define bfin_write_DMA39_X_MODIFY(val) 		bfin_write32(DMA39_X_MODIFY, val)
#define bfin_read_DMA39_Y_COUNT()		bfin_read32(DMA39_Y_COUNT)
#define bfin_write_DMA39_Y_COUNT(val)		bfin_write32(DMA39_Y_COUNT, val)
#define bfin_read_DMA39_Y_MODIFY()		bfin_read32(DMA39_Y_MODIFY)
#define bfin_write_DMA39_Y_MODIFY(val) 		bfin_write32(DMA39_Y_MODIFY, val)
#define bfin_read_DMA39_CURR_DESC_PTR() 	bfin_read32(DMA39_CURR_DESC_PTR)
#define bfin_write_DMA39_CURR_DESC_PTR(val) 	bfin_write32(DMA39_CURR_DESC_PTR, val)
#define bfin_read_DMA39_PREV_DESC_PTR() 	bfin_read32(DMA39_PREV_DESC_PTR)
#define bfin_write_DMA39_PREV_DESC_PTR(val) 	bfin_write32(DMA39_PREV_DESC_PTR, val)
#define bfin_read_DMA39_CURR_ADDR() 		bfin_read32(DMA39_CURR_ADDR)
#define bfin_write_DMA39_CURR_ADDR(val) 	bfin_write32(DMA39_CURR_ADDR, val)
#define bfin_read_DMA39_IRQ_STATUS()		bfin_read32(DMA39_IRQ_STATUS)
#define bfin_write_DMA39_IRQ_STATUS(val)	bfin_write32(DMA39_IRQ_STATUS, val)
#define bfin_read_DMA39_CURR_X_COUNT()		bfin_read32(DMA39_CURR_X_COUNT)
#define bfin_write_DMA39_CURR_X_COUNT(val)	bfin_write32(DMA39_CURR_X_COUNT, val)
#define bfin_read_DMA39_CURR_Y_COUNT()		bfin_read32(DMA39_CURR_Y_COUNT)
#define bfin_write_DMA39_CURR_Y_COUNT(val)	bfin_write32(DMA39_CURR_Y_COUNT, val)
#define bfin_read_DMA39_BWL_COUNT()		bfin_read32(DMA39_BWL_COUNT)
#define bfin_write_DMA39_BWL_COUNT(val)		bfin_write32(DMA39_BWL_COUNT, val)
#define bfin_read_DMA39_CURR_BWL_COUNT()	bfin_read32(DMA39_CURR_BWL_COUNT)
#define bfin_write_DMA39_CURR_BWL_COUNT(val)	bfin_write32(DMA39_CURR_BWL_COUNT, val)
#define bfin_read_DMA39_BWM_COUNT()		bfin_read32(DMA39_BWM_COUNT)
#define bfin_write_DMA39_BWM_COUNT(val)		bfin_write32(DMA39_BWM_COUNT, val)
#define bfin_read_DMA39_CURR_BWM_COUNT()	bfin_read32(DMA39_CURR_BWM_COUNT)
#define bfin_write_DMA39_CURR_BWM_COUNT(val)	bfin_write32(DMA39_CURR_BWM_COUNT, val)

/* DMA Channel 40 Registers */

#define bfin_read_DMA40_NEXT_DESC_PTR() 	bfin_read32(DMA40_NEXT_DESC_PTR)
#define bfin_write_DMA40_NEXT_DESC_PTR(val) 	bfin_write32(DMA40_NEXT_DESC_PTR, val)
#define bfin_read_DMA40_START_ADDR() 		bfin_read32(DMA40_START_ADDR)
#define bfin_write_DMA40_START_ADDR(val) 	bfin_write32(DMA40_START_ADDR, val)
#define bfin_read_DMA40_CONFIG()		bfin_read32(DMA40_CONFIG)
#define bfin_write_DMA40_CONFIG(val)		bfin_write32(DMA40_CONFIG, val)
#define bfin_read_DMA40_X_COUNT()		bfin_read32(DMA40_X_COUNT)
#define bfin_write_DMA40_X_COUNT(val)		bfin_write32(DMA40_X_COUNT, val)
#define bfin_read_DMA40_X_MODIFY()		bfin_read32(DMA40_X_MODIFY)
#define bfin_write_DMA40_X_MODIFY(val) 		bfin_write32(DMA40_X_MODIFY, val)
#define bfin_read_DMA40_Y_COUNT()		bfin_read32(DMA40_Y_COUNT)
#define bfin_write_DMA40_Y_COUNT(val)		bfin_write32(DMA40_Y_COUNT, val)
#define bfin_read_DMA40_Y_MODIFY()		bfin_read32(DMA40_Y_MODIFY)
#define bfin_write_DMA40_Y_MODIFY(val) 		bfin_write32(DMA40_Y_MODIFY, val)
#define bfin_read_DMA40_CURR_DESC_PTR() 	bfin_read32(DMA40_CURR_DESC_PTR)
#define bfin_write_DMA40_CURR_DESC_PTR(val) 	bfin_write32(DMA40_CURR_DESC_PTR, val)
#define bfin_read_DMA40_PREV_DESC_PTR() 	bfin_read32(DMA40_PREV_DESC_PTR)
#define bfin_write_DMA40_PREV_DESC_PTR(val) 	bfin_write32(DMA40_PREV_DESC_PTR, val)
#define bfin_read_DMA40_CURR_ADDR() 		bfin_read32(DMA40_CURR_ADDR)
#define bfin_write_DMA40_CURR_ADDR(val) 	bfin_write32(DMA40_CURR_ADDR, val)
#define bfin_read_DMA40_IRQ_STATUS()		bfin_read32(DMA40_IRQ_STATUS)
#define bfin_write_DMA40_IRQ_STATUS(val)	bfin_write32(DMA40_IRQ_STATUS, val)
#define bfin_read_DMA40_CURR_X_COUNT()		bfin_read32(DMA40_CURR_X_COUNT)
#define bfin_write_DMA40_CURR_X_COUNT(val)	bfin_write32(DMA40_CURR_X_COUNT, val)
#define bfin_read_DMA40_CURR_Y_COUNT()		bfin_read32(DMA40_CURR_Y_COUNT)
#define bfin_write_DMA40_CURR_Y_COUNT(val)	bfin_write32(DMA40_CURR_Y_COUNT, val)
#define bfin_read_DMA40_BWL_COUNT()		bfin_read32(DMA40_BWL_COUNT)
#define bfin_write_DMA40_BWL_COUNT(val)		bfin_write32(DMA40_BWL_COUNT, val)
#define bfin_read_DMA40_CURR_BWL_COUNT()	bfin_read32(DMA40_CURR_BWL_COUNT)
#define bfin_write_DMA40_CURR_BWL_COUNT(val)	bfin_write32(DMA40_CURR_BWL_COUNT, val)
#define bfin_read_DMA40_BWM_COUNT()		bfin_read32(DMA40_BWM_COUNT)
#define bfin_write_DMA40_BWM_COUNT(val)		bfin_write32(DMA40_BWM_COUNT, val)
#define bfin_read_DMA40_CURR_BWM_COUNT()	bfin_read32(DMA40_CURR_BWM_COUNT)
#define bfin_write_DMA40_CURR_BWM_COUNT(val)	bfin_write32(DMA40_CURR_BWM_COUNT, val)

/* DMA Channel 41 Registers */

#define bfin_read_DMA41_NEXT_DESC_PTR() 	bfin_read32(DMA41_NEXT_DESC_PTR)
#define bfin_write_DMA41_NEXT_DESC_PTR(val) 	bfin_write32(DMA41_NEXT_DESC_PTR, val)
#define bfin_read_DMA41_START_ADDR() 		bfin_read32(DMA41_START_ADDR)
#define bfin_write_DMA41_START_ADDR(val) 	bfin_write32(DMA41_START_ADDR, val)
#define bfin_read_DMA41_CONFIG()		bfin_read32(DMA41_CONFIG)
#define bfin_write_DMA41_CONFIG(val)		bfin_write32(DMA41_CONFIG, val)
#define bfin_read_DMA41_X_COUNT()		bfin_read32(DMA41_X_COUNT)
#define bfin_write_DMA41_X_COUNT(val)		bfin_write32(DMA41_X_COUNT, val)
#define bfin_read_DMA41_X_MODIFY()		bfin_read32(DMA41_X_MODIFY)
#define bfin_write_DMA41_X_MODIFY(val) 		bfin_write32(DMA41_X_MODIFY, val)
#define bfin_read_DMA41_Y_COUNT()		bfin_read32(DMA41_Y_COUNT)
#define bfin_write_DMA41_Y_COUNT(val)		bfin_write32(DMA41_Y_COUNT, val)
#define bfin_read_DMA41_Y_MODIFY()		bfin_read32(DMA41_Y_MODIFY)
#define bfin_write_DMA41_Y_MODIFY(val) 		bfin_write32(DMA41_Y_MODIFY, val)
#define bfin_read_DMA41_CURR_DESC_PTR() 	bfin_read32(DMA41_CURR_DESC_PTR)
#define bfin_write_DMA41_CURR_DESC_PTR(val) 	bfin_write32(DMA41_CURR_DESC_PTR, val)
#define bfin_read_DMA41_PREV_DESC_PTR() 	bfin_read32(DMA41_PREV_DESC_PTR)
#define bfin_write_DMA41_PREV_DESC_PTR(val) 	bfin_write32(DMA41_PREV_DESC_PTR, val)
#define bfin_read_DMA41_CURR_ADDR() 		bfin_read32(DMA41_CURR_ADDR)
#define bfin_write_DMA41_CURR_ADDR(val) 	bfin_write32(DMA41_CURR_ADDR, val)
#define bfin_read_DMA41_IRQ_STATUS()		bfin_read32(DMA41_IRQ_STATUS)
#define bfin_write_DMA41_IRQ_STATUS(val)	bfin_write32(DMA41_IRQ_STATUS, val)
#define bfin_read_DMA41_CURR_X_COUNT()		bfin_read32(DMA41_CURR_X_COUNT)
#define bfin_write_DMA41_CURR_X_COUNT(val)	bfin_write32(DMA41_CURR_X_COUNT, val)
#define bfin_read_DMA41_CURR_Y_COUNT()		bfin_read32(DMA41_CURR_Y_COUNT)
#define bfin_write_DMA41_CURR_Y_COUNT(val)	bfin_write32(DMA41_CURR_Y_COUNT, val)
#define bfin_read_DMA41_BWL_COUNT()		bfin_read32(DMA41_BWL_COUNT)
#define bfin_write_DMA41_BWL_COUNT(val)		bfin_write32(DMA41_BWL_COUNT, val)
#define bfin_read_DMA41_CURR_BWL_COUNT()	bfin_read32(DMA41_CURR_BWL_COUNT)
#define bfin_write_DMA41_CURR_BWL_COUNT(val)	bfin_write32(DMA41_CURR_BWL_COUNT, val)
#define bfin_read_DMA41_BWM_COUNT()		bfin_read32(DMA41_BWM_COUNT)
#define bfin_write_DMA41_BWM_COUNT(val)		bfin_write32(DMA41_BWM_COUNT, val)
#define bfin_read_DMA41_CURR_BWM_COUNT()	bfin_read32(DMA41_CURR_BWM_COUNT)
#define bfin_write_DMA41_CURR_BWM_COUNT(val)	bfin_write32(DMA41_CURR_BWM_COUNT, val)

/* DMA Channel 42 Registers */

#define bfin_read_DMA42_NEXT_DESC_PTR() 	bfin_read32(DMA42_NEXT_DESC_PTR)
#define bfin_write_DMA42_NEXT_DESC_PTR(val) 	bfin_write32(DMA42_NEXT_DESC_PTR, val)
#define bfin_read_DMA42_START_ADDR() 		bfin_read32(DMA42_START_ADDR)
#define bfin_write_DMA42_START_ADDR(val) 	bfin_write32(DMA42_START_ADDR, val)
#define bfin_read_DMA42_CONFIG()		bfin_read32(DMA42_CONFIG)
#define bfin_write_DMA42_CONFIG(val)		bfin_write32(DMA42_CONFIG, val)
#define bfin_read_DMA42_X_COUNT()		bfin_read32(DMA42_X_COUNT)
#define bfin_write_DMA42_X_COUNT(val)		bfin_write32(DMA42_X_COUNT, val)
#define bfin_read_DMA42_X_MODIFY()		bfin_read32(DMA42_X_MODIFY)
#define bfin_write_DMA42_X_MODIFY(val) 		bfin_write32(DMA42_X_MODIFY, val)
#define bfin_read_DMA42_Y_COUNT()		bfin_read32(DMA42_Y_COUNT)
#define bfin_write_DMA42_Y_COUNT(val)		bfin_write32(DMA42_Y_COUNT, val)
#define bfin_read_DMA42_Y_MODIFY()		bfin_read32(DMA42_Y_MODIFY)
#define bfin_write_DMA42_Y_MODIFY(val) 		bfin_write32(DMA42_Y_MODIFY, val)
#define bfin_read_DMA42_CURR_DESC_PTR() 	bfin_read32(DMA42_CURR_DESC_PTR)
#define bfin_write_DMA42_CURR_DESC_PTR(val) 	bfin_write32(DMA42_CURR_DESC_PTR, val)
#define bfin_read_DMA42_PREV_DESC_PTR() 	bfin_read32(DMA42_PREV_DESC_PTR)
#define bfin_write_DMA42_PREV_DESC_PTR(val) 	bfin_write32(DMA42_PREV_DESC_PTR, val)
#define bfin_read_DMA42_CURR_ADDR() 		bfin_read32(DMA42_CURR_ADDR)
#define bfin_write_DMA42_CURR_ADDR(val) 	bfin_write32(DMA42_CURR_ADDR, val)
#define bfin_read_DMA42_IRQ_STATUS()		bfin_read32(DMA42_IRQ_STATUS)
#define bfin_write_DMA42_IRQ_STATUS(val)	bfin_write32(DMA42_IRQ_STATUS, val)
#define bfin_read_DMA42_CURR_X_COUNT()		bfin_read32(DMA42_CURR_X_COUNT)
#define bfin_write_DMA42_CURR_X_COUNT(val)	bfin_write32(DMA42_CURR_X_COUNT, val)
#define bfin_read_DMA42_CURR_Y_COUNT()		bfin_read32(DMA42_CURR_Y_COUNT)
#define bfin_write_DMA42_CURR_Y_COUNT(val)	bfin_write32(DMA42_CURR_Y_COUNT, val)
#define bfin_read_DMA42_BWL_COUNT()		bfin_read32(DMA42_BWL_COUNT)
#define bfin_write_DMA42_BWL_COUNT(val)		bfin_write32(DMA42_BWL_COUNT, val)
#define bfin_read_DMA42_CURR_BWL_COUNT()	bfin_read32(DMA42_CURR_BWL_COUNT)
#define bfin_write_DMA42_CURR_BWL_COUNT(val)	bfin_write32(DMA42_CURR_BWL_COUNT, val)
#define bfin_read_DMA42_BWM_COUNT()		bfin_read32(DMA42_BWM_COUNT)
#define bfin_write_DMA42_BWM_COUNT(val)		bfin_write32(DMA42_BWM_COUNT, val)
#define bfin_read_DMA42_CURR_BWM_COUNT()	bfin_read32(DMA42_CURR_BWM_COUNT)
#define bfin_write_DMA42_CURR_BWM_COUNT(val)	bfin_write32(DMA42_CURR_BWM_COUNT, val)

/* DMA Channel 43 Registers */

#define bfin_read_DMA43_NEXT_DESC_PTR() 	bfin_read32(DMA43_NEXT_DESC_PTR)
#define bfin_write_DMA43_NEXT_DESC_PTR(val) 	bfin_write32(DMA43_NEXT_DESC_PTR, val)
#define bfin_read_DMA43_START_ADDR() 		bfin_read32(DMA43_START_ADDR)
#define bfin_write_DMA43_START_ADDR(val) 	bfin_write32(DMA43_START_ADDR, val)
#define bfin_read_DMA43_CONFIG()		bfin_read32(DMA43_CONFIG)
#define bfin_write_DMA43_CONFIG(val)		bfin_write32(DMA43_CONFIG, val)
#define bfin_read_DMA43_X_COUNT()		bfin_read32(DMA43_X_COUNT)
#define bfin_write_DMA43_X_COUNT(val)		bfin_write32(DMA43_X_COUNT, val)
#define bfin_read_DMA43_X_MODIFY()		bfin_read32(DMA43_X_MODIFY)
#define bfin_write_DMA43_X_MODIFY(val) 		bfin_write32(DMA43_X_MODIFY, val)
#define bfin_read_DMA43_Y_COUNT()		bfin_read32(DMA43_Y_COUNT)
#define bfin_write_DMA43_Y_COUNT(val)		bfin_write32(DMA43_Y_COUNT, val)
#define bfin_read_DMA43_Y_MODIFY()		bfin_read32(DMA43_Y_MODIFY)
#define bfin_write_DMA43_Y_MODIFY(val) 		bfin_write32(DMA43_Y_MODIFY, val)
#define bfin_read_DMA43_CURR_DESC_PTR() 	bfin_read32(DMA43_CURR_DESC_PTR)
#define bfin_write_DMA43_CURR_DESC_PTR(val) 	bfin_write32(DMA43_CURR_DESC_PTR, val)
#define bfin_read_DMA43_PREV_DESC_PTR() 	bfin_read32(DMA43_PREV_DESC_PTR)
#define bfin_write_DMA43_PREV_DESC_PTR(val) 	bfin_write32(DMA43_PREV_DESC_PTR, val)
#define bfin_read_DMA43_CURR_ADDR() 		bfin_read32(DMA43_CURR_ADDR)
#define bfin_write_DMA43_CURR_ADDR(val) 	bfin_write32(DMA43_CURR_ADDR, val)
#define bfin_read_DMA43_IRQ_STATUS()		bfin_read32(DMA43_IRQ_STATUS)
#define bfin_write_DMA43_IRQ_STATUS(val)	bfin_write32(DMA43_IRQ_STATUS, val)
#define bfin_read_DMA43_CURR_X_COUNT()		bfin_read32(DMA43_CURR_X_COUNT)
#define bfin_write_DMA43_CURR_X_COUNT(val)	bfin_write32(DMA43_CURR_X_COUNT, val)
#define bfin_read_DMA43_CURR_Y_COUNT()		bfin_read32(DMA43_CURR_Y_COUNT)
#define bfin_write_DMA43_CURR_Y_COUNT(val)	bfin_write32(DMA43_CURR_Y_COUNT, val)
#define bfin_read_DMA43_BWL_COUNT()		bfin_read32(DMA43_BWL_COUNT)
#define bfin_write_DMA43_BWL_COUNT(val)		bfin_write32(DMA43_BWL_COUNT, val)
#define bfin_read_DMA43_CURR_BWL_COUNT()	bfin_read32(DMA43_CURR_BWL_COUNT)
#define bfin_write_DMA43_CURR_BWL_COUNT(val)	bfin_write32(DMA43_CURR_BWL_COUNT, val)
#define bfin_read_DMA43_BWM_COUNT()		bfin_read32(DMA43_BWM_COUNT)
#define bfin_write_DMA43_BWM_COUNT(val)		bfin_write32(DMA43_BWM_COUNT, val)
#define bfin_read_DMA43_CURR_BWM_COUNT()	bfin_read32(DMA43_CURR_BWM_COUNT)
#define bfin_write_DMA43_CURR_BWM_COUNT(val)	bfin_write32(DMA43_CURR_BWM_COUNT, val)

/* DMA Channel 44 Registers */

#define bfin_read_DMA44_NEXT_DESC_PTR() 	bfin_read32(DMA44_NEXT_DESC_PTR)
#define bfin_write_DMA44_NEXT_DESC_PTR(val) 	bfin_write32(DMA44_NEXT_DESC_PTR, val)
#define bfin_read_DMA44_START_ADDR() 		bfin_read32(DMA44_START_ADDR)
#define bfin_write_DMA44_START_ADDR(val) 	bfin_write32(DMA44_START_ADDR, val)
#define bfin_read_DMA44_CONFIG()		bfin_read32(DMA44_CONFIG)
#define bfin_write_DMA44_CONFIG(val)		bfin_write32(DMA44_CONFIG, val)
#define bfin_read_DMA44_X_COUNT()		bfin_read32(DMA44_X_COUNT)
#define bfin_write_DMA44_X_COUNT(val)		bfin_write32(DMA44_X_COUNT, val)
#define bfin_read_DMA44_X_MODIFY()		bfin_read32(DMA44_X_MODIFY)
#define bfin_write_DMA44_X_MODIFY(val) 		bfin_write32(DMA44_X_MODIFY, val)
#define bfin_read_DMA44_Y_COUNT()		bfin_read32(DMA44_Y_COUNT)
#define bfin_write_DMA44_Y_COUNT(val)		bfin_write32(DMA44_Y_COUNT, val)
#define bfin_read_DMA44_Y_MODIFY()		bfin_read32(DMA44_Y_MODIFY)
#define bfin_write_DMA44_Y_MODIFY(val) 		bfin_write32(DMA44_Y_MODIFY, val)
#define bfin_read_DMA44_CURR_DESC_PTR() 	bfin_read32(DMA44_CURR_DESC_PTR)
#define bfin_write_DMA44_CURR_DESC_PTR(val) 	bfin_write32(DMA44_CURR_DESC_PTR, val)
#define bfin_read_DMA44_PREV_DESC_PTR() 	bfin_read32(DMA44_PREV_DESC_PTR)
#define bfin_write_DMA44_PREV_DESC_PTR(val) 	bfin_write32(DMA44_PREV_DESC_PTR, val)
#define bfin_read_DMA44_CURR_ADDR() 		bfin_read32(DMA44_CURR_ADDR)
#define bfin_write_DMA44_CURR_ADDR(val) 	bfin_write32(DMA44_CURR_ADDR, val)
#define bfin_read_DMA44_IRQ_STATUS()		bfin_read32(DMA44_IRQ_STATUS)
#define bfin_write_DMA44_IRQ_STATUS(val)	bfin_write32(DMA44_IRQ_STATUS, val)
#define bfin_read_DMA44_CURR_X_COUNT()		bfin_read32(DMA44_CURR_X_COUNT)
#define bfin_write_DMA44_CURR_X_COUNT(val)	bfin_write32(DMA44_CURR_X_COUNT, val)
#define bfin_read_DMA44_CURR_Y_COUNT()		bfin_read32(DMA44_CURR_Y_COUNT)
#define bfin_write_DMA44_CURR_Y_COUNT(val)	bfin_write32(DMA44_CURR_Y_COUNT, val)
#define bfin_read_DMA44_BWL_COUNT()		bfin_read32(DMA44_BWL_COUNT)
#define bfin_write_DMA44_BWL_COUNT(val)		bfin_write32(DMA44_BWL_COUNT, val)
#define bfin_read_DMA44_CURR_BWL_COUNT()	bfin_read32(DMA44_CURR_BWL_COUNT)
#define bfin_write_DMA44_CURR_BWL_COUNT(val)	bfin_write32(DMA44_CURR_BWL_COUNT, val)
#define bfin_read_DMA44_BWM_COUNT()		bfin_read32(DMA44_BWM_COUNT)
#define bfin_write_DMA44_BWM_COUNT(val)		bfin_write32(DMA44_BWM_COUNT, val)
#define bfin_read_DMA44_CURR_BWM_COUNT()	bfin_read32(DMA44_CURR_BWM_COUNT)
#define bfin_write_DMA44_CURR_BWM_COUNT(val)	bfin_write32(DMA44_CURR_BWM_COUNT, val)

/* DMA Channel 45 Registers */

#define bfin_read_DMA45_NEXT_DESC_PTR() 	bfin_read32(DMA45_NEXT_DESC_PTR)
#define bfin_write_DMA45_NEXT_DESC_PTR(val) 	bfin_write32(DMA45_NEXT_DESC_PTR, val)
#define bfin_read_DMA45_START_ADDR() 		bfin_read32(DMA45_START_ADDR)
#define bfin_write_DMA45_START_ADDR(val) 	bfin_write32(DMA45_START_ADDR, val)
#define bfin_read_DMA45_CONFIG()		bfin_read32(DMA45_CONFIG)
#define bfin_write_DMA45_CONFIG(val)		bfin_write32(DMA45_CONFIG, val)
#define bfin_read_DMA45_X_COUNT()		bfin_read32(DMA45_X_COUNT)
#define bfin_write_DMA45_X_COUNT(val)		bfin_write32(DMA45_X_COUNT, val)
#define bfin_read_DMA45_X_MODIFY()		bfin_read32(DMA45_X_MODIFY)
#define bfin_write_DMA45_X_MODIFY(val) 		bfin_write32(DMA45_X_MODIFY, val)
#define bfin_read_DMA45_Y_COUNT()		bfin_read32(DMA45_Y_COUNT)
#define bfin_write_DMA45_Y_COUNT(val)		bfin_write32(DMA45_Y_COUNT, val)
#define bfin_read_DMA45_Y_MODIFY()		bfin_read32(DMA45_Y_MODIFY)
#define bfin_write_DMA45_Y_MODIFY(val) 		bfin_write32(DMA45_Y_MODIFY, val)
#define bfin_read_DMA45_CURR_DESC_PTR() 	bfin_read32(DMA45_CURR_DESC_PTR)
#define bfin_write_DMA45_CURR_DESC_PTR(val) 	bfin_write32(DMA45_CURR_DESC_PTR, val)
#define bfin_read_DMA45_PREV_DESC_PTR() 	bfin_read32(DMA45_PREV_DESC_PTR)
#define bfin_write_DMA45_PREV_DESC_PTR(val) 	bfin_write32(DMA45_PREV_DESC_PTR, val)
#define bfin_read_DMA45_CURR_ADDR() 		bfin_read32(DMA45_CURR_ADDR)
#define bfin_write_DMA45_CURR_ADDR(val) 	bfin_write32(DMA45_CURR_ADDR, val)
#define bfin_read_DMA45_IRQ_STATUS()		bfin_read32(DMA45_IRQ_STATUS)
#define bfin_write_DMA45_IRQ_STATUS(val)	bfin_write32(DMA45_IRQ_STATUS, val)
#define bfin_read_DMA45_CURR_X_COUNT()		bfin_read32(DMA45_CURR_X_COUNT)
#define bfin_write_DMA45_CURR_X_COUNT(val)	bfin_write32(DMA45_CURR_X_COUNT, val)
#define bfin_read_DMA45_CURR_Y_COUNT()		bfin_read32(DMA45_CURR_Y_COUNT)
#define bfin_write_DMA45_CURR_Y_COUNT(val)	bfin_write32(DMA45_CURR_Y_COUNT, val)
#define bfin_read_DMA45_BWL_COUNT()		bfin_read32(DMA45_BWL_COUNT)
#define bfin_write_DMA45_BWL_COUNT(val)		bfin_write32(DMA45_BWL_COUNT, val)
#define bfin_read_DMA45_CURR_BWL_COUNT()	bfin_read32(DMA45_CURR_BWL_COUNT)
#define bfin_write_DMA45_CURR_BWL_COUNT(val)	bfin_write32(DMA45_CURR_BWL_COUNT, val)
#define bfin_read_DMA45_BWM_COUNT()		bfin_read32(DMA45_BWM_COUNT)
#define bfin_write_DMA45_BWM_COUNT(val)		bfin_write32(DMA45_BWM_COUNT, val)
#define bfin_read_DMA45_CURR_BWM_COUNT()	bfin_read32(DMA45_CURR_BWM_COUNT)
#define bfin_write_DMA45_CURR_BWM_COUNT(val)	bfin_write32(DMA45_CURR_BWM_COUNT, val)

/* DMA Channel 46 Registers */

#define bfin_read_DMA46_NEXT_DESC_PTR() 	bfin_read32(DMA46_NEXT_DESC_PTR)
#define bfin_write_DMA46_NEXT_DESC_PTR(val) 	bfin_write32(DMA46_NEXT_DESC_PTR, val)
#define bfin_read_DMA46_START_ADDR() 		bfin_read32(DMA46_START_ADDR)
#define bfin_write_DMA46_START_ADDR(val) 	bfin_write32(DMA46_START_ADDR, val)
#define bfin_read_DMA46_CONFIG()		bfin_read32(DMA46_CONFIG)
#define bfin_write_DMA46_CONFIG(val)		bfin_write32(DMA46_CONFIG, val)
#define bfin_read_DMA46_X_COUNT()		bfin_read32(DMA46_X_COUNT)
#define bfin_write_DMA46_X_COUNT(val)		bfin_write32(DMA46_X_COUNT, val)
#define bfin_read_DMA46_X_MODIFY()		bfin_read32(DMA46_X_MODIFY)
#define bfin_write_DMA46_X_MODIFY(val) 		bfin_write32(DMA46_X_MODIFY, val)
#define bfin_read_DMA46_Y_COUNT()		bfin_read32(DMA46_Y_COUNT)
#define bfin_write_DMA46_Y_COUNT(val)		bfin_write32(DMA46_Y_COUNT, val)
#define bfin_read_DMA46_Y_MODIFY()		bfin_read32(DMA46_Y_MODIFY)
#define bfin_write_DMA46_Y_MODIFY(val) 		bfin_write32(DMA46_Y_MODIFY, val)
#define bfin_read_DMA46_CURR_DESC_PTR() 	bfin_read32(DMA46_CURR_DESC_PTR)
#define bfin_write_DMA46_CURR_DESC_PTR(val) 	bfin_write32(DMA46_CURR_DESC_PTR, val)
#define bfin_read_DMA46_PREV_DESC_PTR() 	bfin_read32(DMA46_PREV_DESC_PTR)
#define bfin_write_DMA46_PREV_DESC_PTR(val) 	bfin_write32(DMA46_PREV_DESC_PTR, val)
#define bfin_read_DMA46_CURR_ADDR() 		bfin_read32(DMA46_CURR_ADDR)
#define bfin_write_DMA46_CURR_ADDR(val) 	bfin_write32(DMA46_CURR_ADDR, val)
#define bfin_read_DMA46_IRQ_STATUS()		bfin_read32(DMA46_IRQ_STATUS)
#define bfin_write_DMA46_IRQ_STATUS(val)	bfin_write32(DMA46_IRQ_STATUS, val)
#define bfin_read_DMA46_CURR_X_COUNT()		bfin_read32(DMA46_CURR_X_COUNT)
#define bfin_write_DMA46_CURR_X_COUNT(val)	bfin_write32(DMA46_CURR_X_COUNT, val)
#define bfin_read_DMA46_CURR_Y_COUNT()		bfin_read32(DMA46_CURR_Y_COUNT)
#define bfin_write_DMA46_CURR_Y_COUNT(val)	bfin_write32(DMA46_CURR_Y_COUNT, val)
#define bfin_read_DMA46_BWL_COUNT()		bfin_read32(DMA46_BWL_COUNT)
#define bfin_write_DMA46_BWL_COUNT(val)		bfin_write32(DMA46_BWL_COUNT, val)
#define bfin_read_DMA46_CURR_BWL_COUNT()	bfin_read32(DMA46_CURR_BWL_COUNT)
#define bfin_write_DMA46_CURR_BWL_COUNT(val)	bfin_write32(DMA46_CURR_BWL_COUNT, val)
#define bfin_read_DMA46_BWM_COUNT()		bfin_read32(DMA46_BWM_COUNT)
#define bfin_write_DMA46_BWM_COUNT(val)		bfin_write32(DMA46_BWM_COUNT, val)
#define bfin_read_DMA46_CURR_BWM_COUNT()	bfin_read32(DMA46_CURR_BWM_COUNT)
#define bfin_write_DMA46_CURR_BWM_COUNT(val)	bfin_write32(DMA46_CURR_BWM_COUNT, val)


/* EPPI1 Registers */


/* Port Interrubfin_read_()t 0 Registers (32-bit) */

#define bfin_read_PINT0_MASK_SET()		bfin_read32(PINT0_MASK_SET)
#define bfin_write_PINT0_MASK_SET(val)		bfin_write32(PINT0_MASK_SET, val)
#define bfin_read_PINT0_MASK_CLEAR()		bfin_read32(PINT0_MASK_CLEAR)
#define bfin_write_PINT0_MASK_CLEAR(val)	bfin_write32(PINT0_MASK_CLEAR, val)
#define bfin_read_PINT0_REQUEST()		bfin_read32(PINT0_REQUEST)
#define bfin_write_PINT0_REQUEST(val)		bfin_write32(PINT0_REQUEST, val)
#define bfin_read_PINT0_ASSIGN()		bfin_read32(PINT0_ASSIGN)
#define bfin_write_PINT0_ASSIGN(val)		bfin_write32(PINT0_ASSIGN, val)
#define bfin_read_PINT0_EDGE_SET()		bfin_read32(PINT0_EDGE_SET)
#define bfin_write_PINT0_EDGE_SET(val)		bfin_write32(PINT0_EDGE_SET, val)
#define bfin_read_PINT0_EDGE_CLEAR()		bfin_read32(PINT0_EDGE_CLEAR)
#define bfin_write_PINT0_EDGE_CLEAR(val)	bfin_write32(PINT0_EDGE_CLEAR, val)
#define bfin_read_PINT0_INVERT_SET()		bfin_read32(PINT0_INVERT_SET)
#define bfin_write_PINT0_INVERT_SET(val)	bfin_write32(PINT0_INVERT_SET, val)
#define bfin_read_PINT0_INVERT_CLEAR()		bfin_read32(PINT0_INVERT_CLEAR)
#define bfin_write_PINT0_INVERT_CLEAR(val)	bfin_write32(PINT0_INVERT_CLEAR, val)
#define bfin_read_PINT0_PINSTATE()		bfin_read32(PINT0_PINSTATE)
#define bfin_write_PINT0_PINSTATE(val)		bfin_write32(PINT0_PINSTATE, val)
#define bfin_read_PINT0_LATCH()			bfin_read32(PINT0_LATCH)
#define bfin_write_PINT0_LATCH(val)		bfin_write32(PINT0_LATCH, val)

/* Port Interrubfin_read_()t 1 Registers (32-bit) */

#define bfin_read_PINT1_MASK_SET()		bfin_read32(PINT1_MASK_SET)
#define bfin_write_PINT1_MASK_SET(val)		bfin_write32(PINT1_MASK_SET, val)
#define bfin_read_PINT1_MASK_CLEAR()		bfin_read32(PINT1_MASK_CLEAR)
#define bfin_write_PINT1_MASK_CLEAR(val)	bfin_write32(PINT1_MASK_CLEAR, val)
#define bfin_read_PINT1_REQUEST()		bfin_read32(PINT1_REQUEST)
#define bfin_write_PINT1_REQUEST(val)		bfin_write32(PINT1_REQUEST, val)
#define bfin_read_PINT1_ASSIGN()		bfin_read32(PINT1_ASSIGN)
#define bfin_write_PINT1_ASSIGN(val)		bfin_write32(PINT1_ASSIGN, val)
#define bfin_read_PINT1_EDGE_SET()		bfin_read32(PINT1_EDGE_SET)
#define bfin_write_PINT1_EDGE_SET(val)		bfin_write32(PINT1_EDGE_SET, val)
#define bfin_read_PINT1_EDGE_CLEAR()		bfin_read32(PINT1_EDGE_CLEAR)
#define bfin_write_PINT1_EDGE_CLEAR(val)	bfin_write32(PINT1_EDGE_CLEAR, val)
#define bfin_read_PINT1_INVERT_SET()		bfin_read32(PINT1_INVERT_SET)
#define bfin_write_PINT1_INVERT_SET(val)	bfin_write32(PINT1_INVERT_SET, val)
#define bfin_read_PINT1_INVERT_CLEAR()		bfin_read32(PINT1_INVERT_CLEAR)
#define bfin_write_PINT1_INVERT_CLEAR(val)	bfin_write32(PINT1_INVERT_CLEAR, val)
#define bfin_read_PINT1_PINSTATE()		bfin_read32(PINT1_PINSTATE)
#define bfin_write_PINT1_PINSTATE(val)		bfin_write32(PINT1_PINSTATE, val)
#define bfin_read_PINT1_LATCH()			bfin_read32(PINT1_LATCH)
#define bfin_write_PINT1_LATCH(val)		bfin_write32(PINT1_LATCH, val)

/* Port Interrubfin_read_()t 2 Registers (32-bit) */

#define bfin_read_PINT2_MASK_SET()		bfin_read32(PINT2_MASK_SET)
#define bfin_write_PINT2_MASK_SET(val)		bfin_write32(PINT2_MASK_SET, val)
#define bfin_read_PINT2_MASK_CLEAR()		bfin_read32(PINT2_MASK_CLEAR)
#define bfin_write_PINT2_MASK_CLEAR(val)	bfin_write32(PINT2_MASK_CLEAR, val)
#define bfin_read_PINT2_REQUEST()		bfin_read32(PINT2_REQUEST)
#define bfin_write_PINT2_REQUEST(val)		bfin_write32(PINT2_REQUEST, val)
#define bfin_read_PINT2_ASSIGN()		bfin_read32(PINT2_ASSIGN)
#define bfin_write_PINT2_ASSIGN(val)		bfin_write32(PINT2_ASSIGN, val)
#define bfin_read_PINT2_EDGE_SET()		bfin_read32(PINT2_EDGE_SET)
#define bfin_write_PINT2_EDGE_SET(val)		bfin_write32(PINT2_EDGE_SET, val)
#define bfin_read_PINT2_EDGE_CLEAR()		bfin_read32(PINT2_EDGE_CLEAR)
#define bfin_write_PINT2_EDGE_CLEAR(val)	bfin_write32(PINT2_EDGE_CLEAR, val)
#define bfin_read_PINT2_INVERT_SET()		bfin_read32(PINT2_INVERT_SET)
#define bfin_write_PINT2_INVERT_SET(val)	bfin_write32(PINT2_INVERT_SET, val)
#define bfin_read_PINT2_INVERT_CLEAR()		bfin_read32(PINT2_INVERT_CLEAR)
#define bfin_write_PINT2_INVERT_CLEAR(val)	bfin_write32(PINT2_INVERT_CLEAR, val)
#define bfin_read_PINT2_PINSTATE()		bfin_read32(PINT2_PINSTATE)
#define bfin_write_PINT2_PINSTATE(val)		bfin_write32(PINT2_PINSTATE, val)
#define bfin_read_PINT2_LATCH()			bfin_read32(PINT2_LATCH)
#define bfin_write_PINT2_LATCH(val)		bfin_write32(PINT2_LATCH, val)

/* Port Interrubfin_read_()t 3 Registers (32-bit) */

#define bfin_read_PINT3_MASK_SET()		bfin_read32(PINT3_MASK_SET)
#define bfin_write_PINT3_MASK_SET(val)		bfin_write32(PINT3_MASK_SET, val)
#define bfin_read_PINT3_MASK_CLEAR()		bfin_read32(PINT3_MASK_CLEAR)
#define bfin_write_PINT3_MASK_CLEAR(val)	bfin_write32(PINT3_MASK_CLEAR, val)
#define bfin_read_PINT3_REQUEST()		bfin_read32(PINT3_REQUEST)
#define bfin_write_PINT3_REQUEST(val)		bfin_write32(PINT3_REQUEST, val)
#define bfin_read_PINT3_ASSIGN()		bfin_read32(PINT3_ASSIGN)
#define bfin_write_PINT3_ASSIGN(val)		bfin_write32(PINT3_ASSIGN, val)
#define bfin_read_PINT3_EDGE_SET()		bfin_read32(PINT3_EDGE_SET)
#define bfin_write_PINT3_EDGE_SET(val)		bfin_write32(PINT3_EDGE_SET, val)
#define bfin_read_PINT3_EDGE_CLEAR()		bfin_read32(PINT3_EDGE_CLEAR)
#define bfin_write_PINT3_EDGE_CLEAR(val)	bfin_write32(PINT3_EDGE_CLEAR, val)
#define bfin_read_PINT3_INVERT_SET()		bfin_read32(PINT3_INVERT_SET)
#define bfin_write_PINT3_INVERT_SET(val)	bfin_write32(PINT3_INVERT_SET, val)
#define bfin_read_PINT3_INVERT_CLEAR()		bfin_read32(PINT3_INVERT_CLEAR)
#define bfin_write_PINT3_INVERT_CLEAR(val)	bfin_write32(PINT3_INVERT_CLEAR, val)
#define bfin_read_PINT3_PINSTATE()		bfin_read32(PINT3_PINSTATE)
#define bfin_write_PINT3_PINSTATE(val)		bfin_write32(PINT3_PINSTATE, val)
#define bfin_read_PINT3_LATCH()			bfin_read32(PINT3_LATCH)
#define bfin_write_PINT3_LATCH(val)		bfin_write32(PINT3_LATCH, val)

/* Port Interrubfin_read_()t 4 Registers (32-bit) */

#define bfin_read_PINT4_MASK_SET()		bfin_read32(PINT4_MASK_SET)
#define bfin_write_PINT4_MASK_SET(val)		bfin_write32(PINT4_MASK_SET, val)
#define bfin_read_PINT4_MASK_CLEAR()		bfin_read32(PINT4_MASK_CLEAR)
#define bfin_write_PINT4_MASK_CLEAR(val)	bfin_write32(PINT4_MASK_CLEAR, val)
#define bfin_read_PINT4_REQUEST()		bfin_read32(PINT4_REQUEST)
#define bfin_write_PINT4_REQUEST(val)		bfin_write32(PINT4_REQUEST, val)
#define bfin_read_PINT4_ASSIGN()		bfin_read32(PINT4_ASSIGN)
#define bfin_write_PINT4_ASSIGN(val)		bfin_write32(PINT4_ASSIGN, val)
#define bfin_read_PINT4_EDGE_SET()		bfin_read32(PINT4_EDGE_SET)
#define bfin_write_PINT4_EDGE_SET(val)		bfin_write32(PINT4_EDGE_SET, val)
#define bfin_read_PINT4_EDGE_CLEAR()		bfin_read32(PINT4_EDGE_CLEAR)
#define bfin_write_PINT4_EDGE_CLEAR(val)	bfin_write32(PINT4_EDGE_CLEAR, val)
#define bfin_read_PINT4_INVERT_SET()		bfin_read32(PINT4_INVERT_SET)
#define bfin_write_PINT4_INVERT_SET(val)	bfin_write32(PINT4_INVERT_SET, val)
#define bfin_read_PINT4_INVERT_CLEAR()		bfin_read32(PINT4_INVERT_CLEAR)
#define bfin_write_PINT4_INVERT_CLEAR(val)	bfin_write32(PINT4_INVERT_CLEAR, val)
#define bfin_read_PINT4_PINSTATE()		bfin_read32(PINT4_PINSTATE)
#define bfin_write_PINT4_PINSTATE(val)		bfin_write32(PINT4_PINSTATE, val)
#define bfin_read_PINT4_LATCH()			bfin_read32(PINT4_LATCH)
#define bfin_write_PINT4_LATCH(val)		bfin_write32(PINT4_LATCH, val)

/* Port Interrubfin_read_()t 5 Registers (32-bit) */

#define bfin_read_PINT5_MASK_SET()		bfin_read32(PINT5_MASK_SET)
#define bfin_write_PINT5_MASK_SET(val)		bfin_write32(PINT5_MASK_SET, val)
#define bfin_read_PINT5_MASK_CLEAR()		bfin_read32(PINT5_MASK_CLEAR)
#define bfin_write_PINT5_MASK_CLEAR(val)	bfin_write32(PINT5_MASK_CLEAR, val)
#define bfin_read_PINT5_REQUEST()		bfin_read32(PINT5_REQUEST)
#define bfin_write_PINT5_REQUEST(val)		bfin_write32(PINT5_REQUEST, val)
#define bfin_read_PINT5_ASSIGN()		bfin_read32(PINT5_ASSIGN)
#define bfin_write_PINT5_ASSIGN(val)		bfin_write32(PINT5_ASSIGN, val)
#define bfin_read_PINT5_EDGE_SET()		bfin_read32(PINT5_EDGE_SET)
#define bfin_write_PINT5_EDGE_SET(val)		bfin_write32(PINT5_EDGE_SET, val)
#define bfin_read_PINT5_EDGE_CLEAR()		bfin_read32(PINT5_EDGE_CLEAR)
#define bfin_write_PINT5_EDGE_CLEAR(val)	bfin_write32(PINT5_EDGE_CLEAR, val)
#define bfin_read_PINT5_INVERT_SET()		bfin_read32(PINT5_INVERT_SET)
#define bfin_write_PINT5_INVERT_SET(val)	bfin_write32(PINT5_INVERT_SET, val)
#define bfin_read_PINT5_INVERT_CLEAR()		bfin_read32(PINT5_INVERT_CLEAR)
#define bfin_write_PINT5_INVERT_CLEAR(val)	bfin_write32(PINT5_INVERT_CLEAR, val)
#define bfin_read_PINT5_PINSTATE()		bfin_read32(PINT5_PINSTATE)
#define bfin_write_PINT5_PINSTATE(val)		bfin_write32(PINT5_PINSTATE, val)
#define bfin_read_PINT5_LATCH()			bfin_read32(PINT5_LATCH)
#define bfin_write_PINT5_LATCH(val)		bfin_write32(PINT5_LATCH, val)

/* Port A Registers */

#define bfin_read_PORTA_FER()		bfin_read32(PORTA_FER)
#define bfin_write_PORTA_FER(val)	bfin_write32(PORTA_FER, val)
#define bfin_read_PORTA_FER_SET()	bfin_read32(PORTA_FER_SET)
#define bfin_write_PORTA_FER_SET(val)	bfin_write32(PORTA_FER_SET, val)
#define bfin_read_PORTA_FER_CLEAR()	bfin_read32(PORTA_FER_CLEAR)
#define bfin_write_PORTA_FER_CLEAR(val)	bfin_write32(PORTA_FER_CLEAR, val)
#define bfin_read_PORTA()		bfin_read32(PORTA)
#define bfin_write_PORTA(val)		bfin_write32(PORTA, val)
#define bfin_read_PORTA_SET()		bfin_read32(PORTA_SET)
#define bfin_write_PORTA_SET(val)	bfin_write32(PORTA_SET, val)
#define bfin_read_PORTA_CLEAR()		bfin_read32(PORTA_CLEAR)
#define bfin_write_PORTA_CLEAR(val)	bfin_write32(PORTA_CLEAR, val)
#define bfin_read_PORTA_DIR()		bfin_read32(PORTA_DIR)
#define bfin_write_PORTA_DIR(val)	bfin_write32(PORTA_DIR, val)
#define bfin_read_PORTA_DIR_SET()	bfin_read32(PORTA_DIR_SET)
#define bfin_write_PORTA_DIR_SET(val)	bfin_write32(PORTA_DIR_SET, val)
#define bfin_read_PORTA_DIR_CLEAR()	bfin_read32(PORTA_DIR_CLEAR)
#define bfin_write_PORTA_DIR_CLEAR(val)	bfin_write32(PORTA_DIR_CLEAR, val)
#define bfin_read_PORTA_INEN()		bfin_read32(PORTA_INEN)
#define bfin_write_PORTA_INEN(val)	bfin_write32(PORTA_INEN, val)
#define bfin_read_PORTA_INEN_SET()	bfin_read32(PORTA_INEN_SET)
#define bfin_write_PORTA_INEN_SET(val)	bfin_write32(PORTA_INEN_SET, val)
#define bfin_read_PORTA_INEN_CLEAR()	bfin_read32(PORTA_INEN_CLEAR)
#define bfin_write_PORTA_INEN_CLEAR(val)	bfin_write32(PORTA_INEN_CLEAR, val)
#define bfin_read_PORTA_MUX()		bfin_read32(PORTA_MUX)
#define bfin_write_PORTA_MUX(val)	bfin_write32(PORTA_MUX, val)
#define bfin_read_PORTA_DATA_TGL()	bfin_read32(PORTA_DATA_TGL)
#define bfin_write_PORTA_DATA_TGL(val)	bfin_write32(PORTA_DATA_TGL, val)
#define bfin_read_PORTA_POL()		bfin_read32(PORTA_POL)
#define bfin_write_PORTA_POL(val)	bfin_write32(PORTA_POL, val)
#define bfin_read_PORTA_POL_SET()	bfin_read32(PORTA_POL_SET)
#define bfin_write_PORTA_POL_SET(val)	bfin_write32(PORTA_POL_SET, val)
#define bfin_read_PORTA_POL_CLEAR()	bfin_read32(PORTA_POL_CLEAR)
#define bfin_write_PORTA_POL_CLEAR(val)	bfin_write32(PORTA_POL_CLEAR, val)
#define bfin_read_PORTA_LOCK()		bfin_read32(PORTA_LOCK)
#define bfin_write_PORTA_LOCK(val)	bfin_write32(PORTA_LOCK, val)
#define bfin_read_PORTA_REVID()		bfin_read32(PORTA_REVID)
#define bfin_write_PORTA_REVID(val)	bfin_write32(PORTA_REVID, val)



/* Port B Registers */
#define bfin_read_PORTB_FER()		bfin_read32(PORTB_FER)
#define bfin_write_PORTB_FER(val)	bfin_write32(PORTB_FER, val)
#define bfin_read_PORTB_FER_SET()	bfin_read32(PORTB_FER_SET)
#define bfin_write_PORTB_FER_SET(val)	bfin_write32(PORTB_FER_SET, val)
#define bfin_read_PORTB_FER_CLEAR()	bfin_read32(PORTB_FER_CLEAR)
#define bfin_write_PORTB_FER_CLEAR(val)	bfin_write32(PORTB_FER_CLEAR, val)
#define bfin_read_PORTB()		bfin_read32(PORTB)
#define bfin_write_PORTB(val)		bfin_write32(PORTB, val)
#define bfin_read_PORTB_SET()		bfin_read32(PORTB_SET)
#define bfin_write_PORTB_SET(val)	bfin_write32(PORTB_SET, val)
#define bfin_read_PORTB_CLEAR()		bfin_read32(PORTB_CLEAR)
#define bfin_write_PORTB_CLEAR(val)	bfin_write32(PORTB_CLEAR, val)
#define bfin_read_PORTB_DIR()		bfin_read32(PORTB_DIR)
#define bfin_write_PORTB_DIR(val)	bfin_write32(PORTB_DIR, val)
#define bfin_read_PORTB_DIR_SET()	bfin_read32(PORTB_DIR_SET)
#define bfin_write_PORTB_DIR_SET(val)	bfin_write32(PORTB_DIR_SET, val)
#define bfin_read_PORTB_DIR_CLEAR()	bfin_read32(PORTB_DIR_CLEAR)
#define bfin_write_PORTB_DIR_CLEAR(val)	bfin_write32(PORTB_DIR_CLEAR, val)
#define bfin_read_PORTB_INEN()		bfin_read32(PORTB_INEN)
#define bfin_write_PORTB_INEN(val)	bfin_write32(PORTB_INEN, val)
#define bfin_read_PORTB_INEN_SET()	bfin_read32(PORTB_INEN_SET)
#define bfin_write_PORTB_INEN_SET(val)	bfin_write32(PORTB_INEN_SET, val)
#define bfin_read_PORTB_INEN_CLEAR()	bfin_read32(PORTB_INEN_CLEAR)
#define bfin_write_PORTB_INEN_CLEAR(val)	bfin_write32(PORTB_INEN_CLEAR, val)
#define bfin_read_PORTB_MUX()		bfin_read32(PORTB_MUX)
#define bfin_write_PORTB_MUX(val)	bfin_write32(PORTB_MUX, val)
#define bfin_read_PORTB_DATA_TGL()	bfin_read32(PORTB_DATA_TGL)
#define bfin_write_PORTB_DATA_TGL(val)	bfin_write32(PORTB_DATA_TGL, val)
#define bfin_read_PORTB_POL()		bfin_read32(PORTB_POL)
#define bfin_write_PORTB_POL(val)	bfin_write32(PORTB_POL, val)
#define bfin_read_PORTB_POL_SET()	bfin_read32(PORTB_POL_SET)
#define bfin_write_PORTB_POL_SET(val)	bfin_write32(PORTB_POL_SET, val)
#define bfin_read_PORTB_POL_CLEAR()	bfin_read32(PORTB_POL_CLEAR)
#define bfin_write_PORTB_POL_CLEAR(val)	bfin_write32(PORTB_POL_CLEAR, val)
#define bfin_read_PORTB_LOCK()		bfin_read32(PORTB_LOCK)
#define bfin_write_PORTB_LOCK(val)	bfin_write32(PORTB_LOCK, val)
#define bfin_read_PORTB_REVID()		bfin_read32(PORTB_REVID)
#define bfin_write_PORTB_REVID(val)	bfin_write32(PORTB_REVID, val)


/* Port C Registers */
#define bfin_read_PORTC_FER()		bfin_read32(PORTC_FER)
#define bfin_write_PORTC_FER(val)	bfin_write32(PORTC_FER, val)
#define bfin_read_PORTC_FER_SET()	bfin_read32(PORTC_FER_SET)
#define bfin_write_PORTC_FER_SET(val)	bfin_write32(PORTC_FER_SET, val)
#define bfin_read_PORTC_FER_CLEAR()	bfin_read32(PORTC_FER_CLEAR)
#define bfin_write_PORTC_FER_CLEAR(val)	bfin_write32(PORTC_FER_CLEAR, val)
#define bfin_read_PORTC()		bfin_read32(PORTC)
#define bfin_write_PORTC(val)		bfin_write32(PORTC, val)
#define bfin_read_PORTC_SET()		bfin_read32(PORTC_SET)
#define bfin_write_PORTC_SET(val)	bfin_write32(PORTC_SET, val)
#define bfin_read_PORTC_CLEAR()		bfin_read32(PORTC_CLEAR)
#define bfin_write_PORTC_CLEAR(val)	bfin_write32(PORTC_CLEAR, val)
#define bfin_read_PORTC_DIR()		bfin_read32(PORTC_DIR)
#define bfin_write_PORTC_DIR(val)	bfin_write32(PORTC_DIR, val)
#define bfin_read_PORTC_DIR_SET()	bfin_read32(PORTC_DIR_SET)
#define bfin_write_PORTC_DIR_SET(val)	bfin_write32(PORTC_DIR_SET, val)
#define bfin_read_PORTC_DIR_CLEAR()	bfin_read32(PORTC_DIR_CLEAR)
#define bfin_write_PORTC_DIR_CLEAR(val)	bfin_write32(PORTC_DIR_CLEAR, val)
#define bfin_read_PORTC_INEN()		bfin_read32(PORTC_INEN)
#define bfin_write_PORTC_INEN(val)	bfin_write32(PORTC_INEN, val)
#define bfin_read_PORTC_INEN_SET()	bfin_read32(PORTC_INEN_SET)
#define bfin_write_PORTC_INEN_SET(val)	bfin_write32(PORTC_INEN_SET, val)
#define bfin_read_PORTC_INEN_CLEAR()	bfin_read32(PORTC_INEN_CLEAR)
#define bfin_write_PORTC_INEN_CLEAR(val)	bfin_write32(PORTC_INEN_CLEAR, val)
#define bfin_read_PORTC_MUX()		bfin_read32(PORTC_MUX)
#define bfin_write_PORTC_MUX(val)	bfin_write32(PORTC_MUX, val)
#define bfin_read_PORTC_DATA_TGL()	bfin_read32(PORTC_DATA_TGL)
#define bfin_write_PORTC_DATA_TGL(val)	bfin_write32(PORTC_DATA_TGL, val)
#define bfin_read_PORTC_POL()		bfin_read32(PORTC_POL)
#define bfin_write_PORTC_POL(val)	bfin_write32(PORTC_POL, val)
#define bfin_read_PORTC_POL_SET()	bfin_read32(PORTC_POL_SET)
#define bfin_write_PORTC_POL_SET(val)	bfin_write32(PORTC_POL_SET, val)
#define bfin_read_PORTC_POL_CLEAR()	bfin_read32(PORTC_POL_CLEAR)
#define bfin_write_PORTC_POL_CLEAR(val)	bfin_write32(PORTC_POL_CLEAR, val)
#define bfin_read_PORTC_LOCK()		bfin_read32(PORTC_LOCK)
#define bfin_write_PORTC_LOCK(val)	bfin_write32(PORTC_LOCK, val)
#define bfin_read_PORTC_REVID()		bfin_read32(PORTC_REVID)
#define bfin_write_PORTC_REVID(val)	bfin_write32(PORTC_REVID, val)


/* Port D Registers */
#define bfin_read_PORTD_FER()		bfin_read32(PORTD_FER)
#define bfin_write_PORTD_FER(val)	bfin_write32(PORTD_FER, val)
#define bfin_read_PORTD_FER_SET()	bfin_read32(PORTD_FER_SET)
#define bfin_write_PORTD_FER_SET(val)	bfin_write32(PORTD_FER_SET, val)
#define bfin_read_PORTD_FER_CLEAR()	bfin_read32(PORTD_FER_CLEAR)
#define bfin_write_PORTD_FER_CLEAR(val)	bfin_write32(PORTD_FER_CLEAR, val)
#define bfin_read_PORTD()		bfin_read32(PORTD)
#define bfin_write_PORTD(val)		bfin_write32(PORTD, val)
#define bfin_read_PORTD_SET()		bfin_read32(PORTD_SET)
#define bfin_write_PORTD_SET(val)	bfin_write32(PORTD_SET, val)
#define bfin_read_PORTD_CLEAR()		bfin_read32(PORTD_CLEAR)
#define bfin_write_PORTD_CLEAR(val)	bfin_write32(PORTD_CLEAR, val)
#define bfin_read_PORTD_DIR()		bfin_read32(PORTD_DIR)
#define bfin_write_PORTD_DIR(val)	bfin_write32(PORTD_DIR, val)
#define bfin_read_PORTD_DIR_SET()	bfin_read32(PORTD_DIR_SET)
#define bfin_write_PORTD_DIR_SET(val)	bfin_write32(PORTD_DIR_SET, val)
#define bfin_read_PORTD_DIR_CLEAR()	bfin_read32(PORTD_DIR_CLEAR)
#define bfin_write_PORTD_DIR_CLEAR(val)	bfin_write32(PORTD_DIR_CLEAR, val)
#define bfin_read_PORTD_INEN()		bfin_read32(PORTD_INEN)
#define bfin_write_PORTD_INEN(val)	bfin_write32(PORTD_INEN, val)
#define bfin_read_PORTD_INEN_SET()	bfin_read32(PORTD_INEN_SET)
#define bfin_write_PORTD_INEN_SET(val)	bfin_write32(PORTD_INEN_SET, val)
#define bfin_read_PORTD_INEN_CLEAR()	bfin_read32(PORTD_INEN_CLEAR)
#define bfin_write_PORTD_INEN_CLEAR(val)	bfin_write32(PORTD_INEN_CLEAR, val)
#define bfin_read_PORTD_MUX()		bfin_read32(PORTD_MUX)
#define bfin_write_PORTD_MUX(val)	bfin_write32(PORTD_MUX, val)
#define bfin_read_PORTD_DATA_TGL()	bfin_read32(PORTD_DATA_TGL)
#define bfin_write_PORTD_DATA_TGL(val)	bfin_write32(PORTD_DATA_TGL, val)
#define bfin_read_PORTD_POL()		bfin_read32(PORTD_POL)
#define bfin_write_PORTD_POL(val)	bfin_write32(PORTD_POL, val)
#define bfin_read_PORTD_POL_SET()	bfin_read32(PORTD_POL_SET)
#define bfin_write_PORTD_POL_SET(val)	bfin_write32(PORTD_POL_SET, val)
#define bfin_read_PORTD_POL_CLEAR()	bfin_read32(PORTD_POL_CLEAR)
#define bfin_write_PORTD_POL_CLEAR(val)	bfin_write32(PORTD_POL_CLEAR, val)
#define bfin_read_PORTD_LOCK()		bfin_read32(PORTD_LOCK)
#define bfin_write_PORTD_LOCK(val)	bfin_write32(PORTD_LOCK, val)
#define bfin_read_PORTD_REVID()		bfin_read32(PORTD_REVID)
#define bfin_write_PORTD_REVID(val)	bfin_write32(PORTD_REVID, val)


/* Port E Registers */
#define bfin_read_PORTE_FER()		bfin_read32(PORTE_FER)
#define bfin_write_PORTE_FER(val)	bfin_write32(PORTE_FER, val)
#define bfin_read_PORTE_FER_SET()	bfin_read32(PORTE_FER_SET)
#define bfin_write_PORTE_FER_SET(val)	bfin_write32(PORTE_FER_SET, val)
#define bfin_read_PORTE_FER_CLEAR()	bfin_read32(PORTE_FER_CLEAR)
#define bfin_write_PORTE_FER_CLEAR(val)	bfin_write32(PORTE_FER_CLEAR, val)
#define bfin_read_PORTE()		bfin_read32(PORTE)
#define bfin_write_PORTE(val)		bfin_write32(PORTE, val)
#define bfin_read_PORTE_SET()		bfin_read32(PORTE_SET)
#define bfin_write_PORTE_SET(val)	bfin_write32(PORTE_SET, val)
#define bfin_read_PORTE_CLEAR()		bfin_read32(PORTE_CLEAR)
#define bfin_write_PORTE_CLEAR(val)	bfin_write32(PORTE_CLEAR, val)
#define bfin_read_PORTE_DIR()		bfin_read32(PORTE_DIR)
#define bfin_write_PORTE_DIR(val)	bfin_write32(PORTE_DIR, val)
#define bfin_read_PORTE_DIR_SET()	bfin_read32(PORTE_DIR_SET)
#define bfin_write_PORTE_DIR_SET(val)	bfin_write32(PORTE_DIR_SET, val)
#define bfin_read_PORTE_DIR_CLEAR()	bfin_read32(PORTE_DIR_CLEAR)
#define bfin_write_PORTE_DIR_CLEAR(val)	bfin_write32(PORTE_DIR_CLEAR, val)
#define bfin_read_PORTE_INEN()		bfin_read32(PORTE_INEN)
#define bfin_write_PORTE_INEN(val)	bfin_write32(PORTE_INEN, val)
#define bfin_read_PORTE_INEN_SET()	bfin_read32(PORTE_INEN_SET)
#define bfin_write_PORTE_INEN_SET(val)	bfin_write32(PORTE_INEN_SET, val)
#define bfin_read_PORTE_INEN_CLEAR()	bfin_read32(PORTE_INEN_CLEAR)
#define bfin_write_PORTE_INEN_CLEAR(val)	bfin_write32(PORTE_INEN_CLEAR, val)
#define bfin_read_PORTE_MUX()		bfin_read32(PORTE_MUX)
#define bfin_write_PORTE_MUX(val)	bfin_write32(PORTE_MUX, val)
#define bfin_read_PORTE_DATA_TGL()	bfin_read32(PORTE_DATA_TGL)
#define bfin_write_PORTE_DATA_TGL(val)	bfin_write32(PORTE_DATA_TGL, val)
#define bfin_read_PORTE_POL()		bfin_read32(PORTE_POL)
#define bfin_write_PORTE_POL(val)	bfin_write32(PORTE_POL, val)
#define bfin_read_PORTE_POL_SET()	bfin_read32(PORTE_POL_SET)
#define bfin_write_PORTE_POL_SET(val)	bfin_write32(PORTE_POL_SET, val)
#define bfin_read_PORTE_POL_CLEAR()	bfin_read32(PORTE_POL_CLEAR)
#define bfin_write_PORTE_POL_CLEAR(val)	bfin_write32(PORTE_POL_CLEAR, val)
#define bfin_read_PORTE_LOCK()		bfin_read32(PORTE_LOCK)
#define bfin_write_PORTE_LOCK(val)	bfin_write32(PORTE_LOCK, val)
#define bfin_read_PORTE_REVID()		bfin_read32(PORTE_REVID)
#define bfin_write_PORTE_REVID(val)	bfin_write32(PORTE_REVID, val)


/* Port F Registers */
#define bfin_read_PORTF_FER()		bfin_read32(PORTF_FER)
#define bfin_write_PORTF_FER(val)	bfin_write32(PORTF_FER, val)
#define bfin_read_PORTF_FER_SET()	bfin_read32(PORTF_FER_SET)
#define bfin_write_PORTF_FER_SET(val)	bfin_write32(PORTF_FER_SET, val)
#define bfin_read_PORTF_FER_CLEAR()	bfin_read32(PORTF_FER_CLEAR)
#define bfin_write_PORTF_FER_CLEAR(val)	bfin_write32(PORTF_FER_CLEAR, val)
#define bfin_read_PORTF()		bfin_read32(PORTF)
#define bfin_write_PORTF(val)		bfin_write32(PORTF, val)
#define bfin_read_PORTF_SET()		bfin_read32(PORTF_SET)
#define bfin_write_PORTF_SET(val)	bfin_write32(PORTF_SET, val)
#define bfin_read_PORTF_CLEAR()		bfin_read32(PORTF_CLEAR)
#define bfin_write_PORTF_CLEAR(val)	bfin_write32(PORTF_CLEAR, val)
#define bfin_read_PORTF_DIR()		bfin_read32(PORTF_DIR)
#define bfin_write_PORTF_DIR(val)	bfin_write32(PORTF_DIR, val)
#define bfin_read_PORTF_DIR_SET()	bfin_read32(PORTF_DIR_SET)
#define bfin_write_PORTF_DIR_SET(val)	bfin_write32(PORTF_DIR_SET, val)
#define bfin_read_PORTF_DIR_CLEAR()	bfin_read32(PORTF_DIR_CLEAR)
#define bfin_write_PORTF_DIR_CLEAR(val)	bfin_write32(PORTF_DIR_CLEAR, val)
#define bfin_read_PORTF_INEN()		bfin_read32(PORTF_INEN)
#define bfin_write_PORTF_INEN(val)	bfin_write32(PORTF_INEN, val)
#define bfin_read_PORTF_INEN_SET()	bfin_read32(PORTF_INEN_SET)
#define bfin_write_PORTF_INEN_SET(val)	bfin_write32(PORTF_INEN_SET, val)
#define bfin_read_PORTF_INEN_CLEAR()	bfin_read32(PORTF_INEN_CLEAR)
#define bfin_write_PORTF_INEN_CLEAR(val)	bfin_write32(PORTF_INEN_CLEAR, val)
#define bfin_read_PORTF_MUX()		bfin_read32(PORTF_MUX)
#define bfin_write_PORTF_MUX(val)	bfin_write32(PORTF_MUX, val)
#define bfin_read_PORTF_DATA_TGL()	bfin_read32(PORTF_DATA_TGL)
#define bfin_write_PORTF_DATA_TGL(val)	bfin_write32(PORTF_DATA_TGL, val)
#define bfin_read_PORTF_POL()		bfin_read32(PORTF_POL)
#define bfin_write_PORTF_POL(val)	bfin_write32(PORTF_POL, val)
#define bfin_read_PORTF_POL_SET()	bfin_read32(PORTF_POL_SET)
#define bfin_write_PORTF_POL_SET(val)	bfin_write32(PORTF_POL_SET, val)
#define bfin_read_PORTF_POL_CLEAR()	bfin_read32(PORTF_POL_CLEAR)
#define bfin_write_PORTF_POL_CLEAR(val)	bfin_write32(PORTF_POL_CLEAR, val)
#define bfin_read_PORTF_LOCK()		bfin_read32(PORTF_LOCK)
#define bfin_write_PORTF_LOCK(val)	bfin_write32(PORTF_LOCK, val)
#define bfin_read_PORTF_REVID()		bfin_read32(PORTF_REVID)
#define bfin_write_PORTF_REVID(val)	bfin_write32(PORTF_REVID, val)


/* Port G Registers */
#define bfin_read_PORTG_FER()		bfin_read32(PORTG_FER)
#define bfin_write_PORTG_FER(val)	bfin_write32(PORTG_FER, val)
#define bfin_read_PORTG_FER_SET()	bfin_read32(PORTG_FER_SET)
#define bfin_write_PORTG_FER_SET(val)	bfin_write32(PORTG_FER_SET, val)
#define bfin_read_PORTG_FER_CLEAR()	bfin_read32(PORTG_FER_CLEAR)
#define bfin_write_PORTG_FER_CLEAR(val)	bfin_write32(PORTG_FER_CLEAR, val)
#define bfin_read_PORTG()		bfin_read32(PORTG)
#define bfin_write_PORTG(val)		bfin_write32(PORTG, val)
#define bfin_read_PORTG_SET()		bfin_read32(PORTG_SET)
#define bfin_write_PORTG_SET(val)	bfin_write32(PORTG_SET, val)
#define bfin_read_PORTG_CLEAR()		bfin_read32(PORTG_CLEAR)
#define bfin_write_PORTG_CLEAR(val)	bfin_write32(PORTG_CLEAR, val)
#define bfin_read_PORTG_DIR()		bfin_read32(PORTG_DIR)
#define bfin_write_PORTG_DIR(val)	bfin_write32(PORTG_DIR, val)
#define bfin_read_PORTG_DIR_SET()	bfin_read32(PORTG_DIR_SET)
#define bfin_write_PORTG_DIR_SET(val)	bfin_write32(PORTG_DIR_SET, val)
#define bfin_read_PORTG_DIR_CLEAR()	bfin_read32(PORTG_DIR_CLEAR)
#define bfin_write_PORTG_DIR_CLEAR(val)	bfin_write32(PORTG_DIR_CLEAR, val)
#define bfin_read_PORTG_INEN()		bfin_read32(PORTG_INEN)
#define bfin_write_PORTG_INEN(val)	bfin_write32(PORTG_INEN, val)
#define bfin_read_PORTG_INEN_SET()	bfin_read32(PORTG_INEN_SET)
#define bfin_write_PORTG_INEN_SET(val)	bfin_write32(PORTG_INEN_SET, val)
#define bfin_read_PORTG_INEN_CLEAR()	bfin_read32(PORTG_INEN_CLEAR)
#define bfin_write_PORTG_INEN_CLEAR(val)	bfin_write32(PORTG_INEN_CLEAR, val)
#define bfin_read_PORTG_MUX()		bfin_read32(PORTG_MUX)
#define bfin_write_PORTG_MUX(val)	bfin_write32(PORTG_MUX, val)
#define bfin_read_PORTG_DATA_TGL()	bfin_read32(PORTG_DATA_TGL)
#define bfin_write_PORTG_DATA_TGL(val)	bfin_write32(PORTG_DATA_TGL, val)
#define bfin_read_PORTG_POL()		bfin_read32(PORTG_POL)
#define bfin_write_PORTG_POL(val)	bfin_write32(PORTG_POL, val)
#define bfin_read_PORTG_POL_SET()	bfin_read32(PORTG_POL_SET)
#define bfin_write_PORTG_POL_SET(val)	bfin_write32(PORTG_POL_SET, val)
#define bfin_read_PORTG_POL_CLEAR()	bfin_read32(PORTG_POL_CLEAR)
#define bfin_write_PORTG_POL_CLEAR(val)	bfin_write32(PORTG_POL_CLEAR, val)
#define bfin_read_PORTG_LOCK()		bfin_read32(PORTG_LOCK)
#define bfin_write_PORTG_LOCK(val)	bfin_write32(PORTG_LOCK, val)
#define bfin_read_PORTG_REVID()		bfin_read32(PORTG_REVID)
#define bfin_write_PORTG_REVID(val)	bfin_write32(PORTG_REVID, val)




/* CAN Controller 0 Config 1 Registers */

#define bfin_read_CAN0_MC1()		bfin_read16(CAN0_MC1)
#define bfin_write_CAN0_MC1(val)	bfin_write16(CAN0_MC1, val)
#define bfin_read_CAN0_MD1()		bfin_read16(CAN0_MD1)
#define bfin_write_CAN0_MD1(val)	bfin_write16(CAN0_MD1, val)
#define bfin_read_CAN0_TRS1()		bfin_read16(CAN0_TRS1)
#define bfin_write_CAN0_TRS1(val)	bfin_write16(CAN0_TRS1, val)
#define bfin_read_CAN0_TRR1()		bfin_read16(CAN0_TRR1)
#define bfin_write_CAN0_TRR1(val)	bfin_write16(CAN0_TRR1, val)
#define bfin_read_CAN0_TA1()		bfin_read16(CAN0_TA1)
#define bfin_write_CAN0_TA1(val)	bfin_write16(CAN0_TA1, val)
#define bfin_read_CAN0_AA1()		bfin_read16(CAN0_AA1)
#define bfin_write_CAN0_AA1(val)	bfin_write16(CAN0_AA1, val)
#define bfin_read_CAN0_RMP1()		bfin_read16(CAN0_RMP1)
#define bfin_write_CAN0_RMP1(val)	bfin_write16(CAN0_RMP1, val)
#define bfin_read_CAN0_RML1()		bfin_read16(CAN0_RML1)
#define bfin_write_CAN0_RML1(val)	bfin_write16(CAN0_RML1, val)
#define bfin_read_CAN0_MBTIF1()		bfin_read16(CAN0_MBTIF1)
#define bfin_write_CAN0_MBTIF1(val)	bfin_write16(CAN0_MBTIF1, val)
#define bfin_read_CAN0_MBRIF1()		bfin_read16(CAN0_MBRIF1)
#define bfin_write_CAN0_MBRIF1(val)	bfin_write16(CAN0_MBRIF1, val)
#define bfin_read_CAN0_MBIM1()		bfin_read16(CAN0_MBIM1)
#define bfin_write_CAN0_MBIM1(val)	bfin_write16(CAN0_MBIM1, val)
#define bfin_read_CAN0_RFH1()		bfin_read16(CAN0_RFH1)
#define bfin_write_CAN0_RFH1(val)	bfin_write16(CAN0_RFH1, val)
#define bfin_read_CAN0_OPSS1()		bfin_read16(CAN0_OPSS1)
#define bfin_write_CAN0_OPSS1(val)	bfin_write16(CAN0_OPSS1, val)

/* CAN Controller 0 Config 2 Registers */

#define bfin_read_CAN0_MC2()		bfin_read16(CAN0_MC2)
#define bfin_write_CAN0_MC2(val)	bfin_write16(CAN0_MC2, val)
#define bfin_read_CAN0_MD2()		bfin_read16(CAN0_MD2)
#define bfin_write_CAN0_MD2(val)	bfin_write16(CAN0_MD2, val)
#define bfin_read_CAN0_TRS2()		bfin_read16(CAN0_TRS2)
#define bfin_write_CAN0_TRS2(val)	bfin_write16(CAN0_TRS2, val)
#define bfin_read_CAN0_TRR2()		bfin_read16(CAN0_TRR2)
#define bfin_write_CAN0_TRR2(val)	bfin_write16(CAN0_TRR2, val)
#define bfin_read_CAN0_TA2()		bfin_read16(CAN0_TA2)
#define bfin_write_CAN0_TA2(val)	bfin_write16(CAN0_TA2, val)
#define bfin_read_CAN0_AA2()		bfin_read16(CAN0_AA2)
#define bfin_write_CAN0_AA2(val)	bfin_write16(CAN0_AA2, val)
#define bfin_read_CAN0_RMP2()		bfin_read16(CAN0_RMP2)
#define bfin_write_CAN0_RMP2(val)	bfin_write16(CAN0_RMP2, val)
#define bfin_read_CAN0_RML2()		bfin_read16(CAN0_RML2)
#define bfin_write_CAN0_RML2(val)	bfin_write16(CAN0_RML2, val)
#define bfin_read_CAN0_MBTIF2()		bfin_read16(CAN0_MBTIF2)
#define bfin_write_CAN0_MBTIF2(val)	bfin_write16(CAN0_MBTIF2, val)
#define bfin_read_CAN0_MBRIF2()		bfin_read16(CAN0_MBRIF2)
#define bfin_write_CAN0_MBRIF2(val)	bfin_write16(CAN0_MBRIF2, val)
#define bfin_read_CAN0_MBIM2()		bfin_read16(CAN0_MBIM2)
#define bfin_write_CAN0_MBIM2(val)	bfin_write16(CAN0_MBIM2, val)
#define bfin_read_CAN0_RFH2()		bfin_read16(CAN0_RFH2)
#define bfin_write_CAN0_RFH2(val)	bfin_write16(CAN0_RFH2, val)
#define bfin_read_CAN0_OPSS2()		bfin_read16(CAN0_OPSS2)
#define bfin_write_CAN0_OPSS2(val)	bfin_write16(CAN0_OPSS2, val)

/* CAN Controller 0 Clock/Interrubfin_read_()t/Counter Registers */

#define bfin_read_CAN0_CLOCK()		bfin_read16(CAN0_CLOCK)
#define bfin_write_CAN0_CLOCK(val)	bfin_write16(CAN0_CLOCK, val)
#define bfin_read_CAN0_TIMING()		bfin_read16(CAN0_TIMING)
#define bfin_write_CAN0_TIMING(val)	bfin_write16(CAN0_TIMING, val)
#define bfin_read_CAN0_DEBUG()		bfin_read16(CAN0_DEBUG)
#define bfin_write_CAN0_DEBUG(val)	bfin_write16(CAN0_DEBUG, val)
#define bfin_read_CAN0_STATUS()		bfin_read16(CAN0_STATUS)
#define bfin_write_CAN0_STATUS(val)	bfin_write16(CAN0_STATUS, val)
#define bfin_read_CAN0_CEC()		bfin_read16(CAN0_CEC)
#define bfin_write_CAN0_CEC(val)	bfin_write16(CAN0_CEC, val)
#define bfin_read_CAN0_GIS()		bfin_read16(CAN0_GIS)
#define bfin_write_CAN0_GIS(val)	bfin_write16(CAN0_GIS, val)
#define bfin_read_CAN0_GIM()		bfin_read16(CAN0_GIM)
#define bfin_write_CAN0_GIM(val)	bfin_write16(CAN0_GIM, val)
#define bfin_read_CAN0_GIF()		bfin_read16(CAN0_GIF)
#define bfin_write_CAN0_GIF(val)	bfin_write16(CAN0_GIF, val)
#define bfin_read_CAN0_CONTROL()	bfin_read16(CAN0_CONTROL)
#define bfin_write_CAN0_CONTROL(val)	bfin_write16(CAN0_CONTROL, val)
#define bfin_read_CAN0_INTR()		bfin_read16(CAN0_INTR)
#define bfin_write_CAN0_INTR(val)	bfin_write16(CAN0_INTR, val)
#define bfin_read_CAN0_MBTD()		bfin_read16(CAN0_MBTD)
#define bfin_write_CAN0_MBTD(val)	bfin_write16(CAN0_MBTD, val)
#define bfin_read_CAN0_EWR()		bfin_read16(CAN0_EWR)
#define bfin_write_CAN0_EWR(val)	bfin_write16(CAN0_EWR, val)
#define bfin_read_CAN0_ESR()		bfin_read16(CAN0_ESR)
#define bfin_write_CAN0_ESR(val)	bfin_write16(CAN0_ESR, val)
#define bfin_read_CAN0_UCCNT()		bfin_read16(CAN0_UCCNT)
#define bfin_write_CAN0_UCCNT(val)	bfin_write16(CAN0_UCCNT, val)
#define bfin_read_CAN0_UCRC()		bfin_read16(CAN0_UCRC)
#define bfin_write_CAN0_UCRC(val)	bfin_write16(CAN0_UCRC, val)
#define bfin_read_CAN0_UCCNF()		bfin_read16(CAN0_UCCNF)
#define bfin_write_CAN0_UCCNF(val)	bfin_write16(CAN0_UCCNF, val)

/* CAN Controller 0 Accebfin_read_()tance Registers */

#define bfin_read_CAN0_AM00L()		bfin_read16(CAN0_AM00L)
#define bfin_write_CAN0_AM00L(val)	bfin_write16(CAN0_AM00L, val)
#define bfin_read_CAN0_AM00H()		bfin_read16(CAN0_AM00H)
#define bfin_write_CAN0_AM00H(val)	bfin_write16(CAN0_AM00H, val)
#define bfin_read_CAN0_AM01L()		bfin_read16(CAN0_AM01L)
#define bfin_write_CAN0_AM01L(val)	bfin_write16(CAN0_AM01L, val)
#define bfin_read_CAN0_AM01H()		bfin_read16(CAN0_AM01H)
#define bfin_write_CAN0_AM01H(val)	bfin_write16(CAN0_AM01H, val)
#define bfin_read_CAN0_AM02L()		bfin_read16(CAN0_AM02L)
#define bfin_write_CAN0_AM02L(val)	bfin_write16(CAN0_AM02L, val)
#define bfin_read_CAN0_AM02H()		bfin_read16(CAN0_AM02H)
#define bfin_write_CAN0_AM02H(val)	bfin_write16(CAN0_AM02H, val)
#define bfin_read_CAN0_AM03L()		bfin_read16(CAN0_AM03L)
#define bfin_write_CAN0_AM03L(val)	bfin_write16(CAN0_AM03L, val)
#define bfin_read_CAN0_AM03H()		bfin_read16(CAN0_AM03H)
#define bfin_write_CAN0_AM03H(val)	bfin_write16(CAN0_AM03H, val)
#define bfin_read_CAN0_AM04L()		bfin_read16(CAN0_AM04L)
#define bfin_write_CAN0_AM04L(val)	bfin_write16(CAN0_AM04L, val)
#define bfin_read_CAN0_AM04H()		bfin_read16(CAN0_AM04H)
#define bfin_write_CAN0_AM04H(val)	bfin_write16(CAN0_AM04H, val)
#define bfin_read_CAN0_AM05L()		bfin_read16(CAN0_AM05L)
#define bfin_write_CAN0_AM05L(val)	bfin_write16(CAN0_AM05L, val)
#define bfin_read_CAN0_AM05H()		bfin_read16(CAN0_AM05H)
#define bfin_write_CAN0_AM05H(val)	bfin_write16(CAN0_AM05H, val)
#define bfin_read_CAN0_AM06L()		bfin_read16(CAN0_AM06L)
#define bfin_write_CAN0_AM06L(val)	bfin_write16(CAN0_AM06L, val)
#define bfin_read_CAN0_AM06H()		bfin_read16(CAN0_AM06H)
#define bfin_write_CAN0_AM06H(val)	bfin_write16(CAN0_AM06H, val)
#define bfin_read_CAN0_AM07L()		bfin_read16(CAN0_AM07L)
#define bfin_write_CAN0_AM07L(val)	bfin_write16(CAN0_AM07L, val)
#define bfin_read_CAN0_AM07H()		bfin_read16(CAN0_AM07H)
#define bfin_write_CAN0_AM07H(val)	bfin_write16(CAN0_AM07H, val)
#define bfin_read_CAN0_AM08L()		bfin_read16(CAN0_AM08L)
#define bfin_write_CAN0_AM08L(val)	bfin_write16(CAN0_AM08L, val)
#define bfin_read_CAN0_AM08H()		bfin_read16(CAN0_AM08H)
#define bfin_write_CAN0_AM08H(val)	bfin_write16(CAN0_AM08H, val)
#define bfin_read_CAN0_AM09L()		bfin_read16(CAN0_AM09L)
#define bfin_write_CAN0_AM09L(val)	bfin_write16(CAN0_AM09L, val)
#define bfin_read_CAN0_AM09H()		bfin_read16(CAN0_AM09H)
#define bfin_write_CAN0_AM09H(val)	bfin_write16(CAN0_AM09H, val)
#define bfin_read_CAN0_AM10L()		bfin_read16(CAN0_AM10L)
#define bfin_write_CAN0_AM10L(val)	bfin_write16(CAN0_AM10L, val)
#define bfin_read_CAN0_AM10H()		bfin_read16(CAN0_AM10H)
#define bfin_write_CAN0_AM10H(val)	bfin_write16(CAN0_AM10H, val)
#define bfin_read_CAN0_AM11L()		bfin_read16(CAN0_AM11L)
#define bfin_write_CAN0_AM11L(val)	bfin_write16(CAN0_AM11L, val)
#define bfin_read_CAN0_AM11H()		bfin_read16(CAN0_AM11H)
#define bfin_write_CAN0_AM11H(val)	bfin_write16(CAN0_AM11H, val)
#define bfin_read_CAN0_AM12L()		bfin_read16(CAN0_AM12L)
#define bfin_write_CAN0_AM12L(val)	bfin_write16(CAN0_AM12L, val)
#define bfin_read_CAN0_AM12H()		bfin_read16(CAN0_AM12H)
#define bfin_write_CAN0_AM12H(val)	bfin_write16(CAN0_AM12H, val)
#define bfin_read_CAN0_AM13L()		bfin_read16(CAN0_AM13L)
#define bfin_write_CAN0_AM13L(val)	bfin_write16(CAN0_AM13L, val)
#define bfin_read_CAN0_AM13H()		bfin_read16(CAN0_AM13H)
#define bfin_write_CAN0_AM13H(val)	bfin_write16(CAN0_AM13H, val)
#define bfin_read_CAN0_AM14L()		bfin_read16(CAN0_AM14L)
#define bfin_write_CAN0_AM14L(val)	bfin_write16(CAN0_AM14L, val)
#define bfin_read_CAN0_AM14H()		bfin_read16(CAN0_AM14H)
#define bfin_write_CAN0_AM14H(val)	bfin_write16(CAN0_AM14H, val)
#define bfin_read_CAN0_AM15L()		bfin_read16(CAN0_AM15L)
#define bfin_write_CAN0_AM15L(val)	bfin_write16(CAN0_AM15L, val)
#define bfin_read_CAN0_AM15H()		bfin_read16(CAN0_AM15H)
#define bfin_write_CAN0_AM15H(val)	bfin_write16(CAN0_AM15H, val)

/* CAN Controller 0 Accebfin_read_()tance Registers */

#define bfin_read_CAN0_AM16L()		bfin_read16(CAN0_AM16L)
#define bfin_write_CAN0_AM16L(val)	bfin_write16(CAN0_AM16L, val)
#define bfin_read_CAN0_AM16H()		bfin_read16(CAN0_AM16H)
#define bfin_write_CAN0_AM16H(val)	bfin_write16(CAN0_AM16H, val)
#define bfin_read_CAN0_AM17L()		bfin_read16(CAN0_AM17L)
#define bfin_write_CAN0_AM17L(val)	bfin_write16(CAN0_AM17L, val)
#define bfin_read_CAN0_AM17H()		bfin_read16(CAN0_AM17H)
#define bfin_write_CAN0_AM17H(val)	bfin_write16(CAN0_AM17H, val)
#define bfin_read_CAN0_AM18L()		bfin_read16(CAN0_AM18L)
#define bfin_write_CAN0_AM18L(val)	bfin_write16(CAN0_AM18L, val)
#define bfin_read_CAN0_AM18H()		bfin_read16(CAN0_AM18H)
#define bfin_write_CAN0_AM18H(val)	bfin_write16(CAN0_AM18H, val)
#define bfin_read_CAN0_AM19L()		bfin_read16(CAN0_AM19L)
#define bfin_write_CAN0_AM19L(val)	bfin_write16(CAN0_AM19L, val)
#define bfin_read_CAN0_AM19H()		bfin_read16(CAN0_AM19H)
#define bfin_write_CAN0_AM19H(val)	bfin_write16(CAN0_AM19H, val)
#define bfin_read_CAN0_AM20L()		bfin_read16(CAN0_AM20L)
#define bfin_write_CAN0_AM20L(val)	bfin_write16(CAN0_AM20L, val)
#define bfin_read_CAN0_AM20H()		bfin_read16(CAN0_AM20H)
#define bfin_write_CAN0_AM20H(val)	bfin_write16(CAN0_AM20H, val)
#define bfin_read_CAN0_AM21L()		bfin_read16(CAN0_AM21L)
#define bfin_write_CAN0_AM21L(val)	bfin_write16(CAN0_AM21L, val)
#define bfin_read_CAN0_AM21H()		bfin_read16(CAN0_AM21H)
#define bfin_write_CAN0_AM21H(val)	bfin_write16(CAN0_AM21H, val)
#define bfin_read_CAN0_AM22L()		bfin_read16(CAN0_AM22L)
#define bfin_write_CAN0_AM22L(val)	bfin_write16(CAN0_AM22L, val)
#define bfin_read_CAN0_AM22H()		bfin_read16(CAN0_AM22H)
#define bfin_write_CAN0_AM22H(val)	bfin_write16(CAN0_AM22H, val)
#define bfin_read_CAN0_AM23L()		bfin_read16(CAN0_AM23L)
#define bfin_write_CAN0_AM23L(val)	bfin_write16(CAN0_AM23L, val)
#define bfin_read_CAN0_AM23H()		bfin_read16(CAN0_AM23H)
#define bfin_write_CAN0_AM23H(val)	bfin_write16(CAN0_AM23H, val)
#define bfin_read_CAN0_AM24L()		bfin_read16(CAN0_AM24L)
#define bfin_write_CAN0_AM24L(val)	bfin_write16(CAN0_AM24L, val)
#define bfin_read_CAN0_AM24H()		bfin_read16(CAN0_AM24H)
#define bfin_write_CAN0_AM24H(val)	bfin_write16(CAN0_AM24H, val)
#define bfin_read_CAN0_AM25L()		bfin_read16(CAN0_AM25L)
#define bfin_write_CAN0_AM25L(val)	bfin_write16(CAN0_AM25L, val)
#define bfin_read_CAN0_AM25H()		bfin_read16(CAN0_AM25H)
#define bfin_write_CAN0_AM25H(val)	bfin_write16(CAN0_AM25H, val)
#define bfin_read_CAN0_AM26L()		bfin_read16(CAN0_AM26L)
#define bfin_write_CAN0_AM26L(val)	bfin_write16(CAN0_AM26L, val)
#define bfin_read_CAN0_AM26H()		bfin_read16(CAN0_AM26H)
#define bfin_write_CAN0_AM26H(val)	bfin_write16(CAN0_AM26H, val)
#define bfin_read_CAN0_AM27L()		bfin_read16(CAN0_AM27L)
#define bfin_write_CAN0_AM27L(val)	bfin_write16(CAN0_AM27L, val)
#define bfin_read_CAN0_AM27H()		bfin_read16(CAN0_AM27H)
#define bfin_write_CAN0_AM27H(val)	bfin_write16(CAN0_AM27H, val)
#define bfin_read_CAN0_AM28L()		bfin_read16(CAN0_AM28L)
#define bfin_write_CAN0_AM28L(val)	bfin_write16(CAN0_AM28L, val)
#define bfin_read_CAN0_AM28H()		bfin_read16(CAN0_AM28H)
#define bfin_write_CAN0_AM28H(val)	bfin_write16(CAN0_AM28H, val)
#define bfin_read_CAN0_AM29L()		bfin_read16(CAN0_AM29L)
#define bfin_write_CAN0_AM29L(val)	bfin_write16(CAN0_AM29L, val)
#define bfin_read_CAN0_AM29H()		bfin_read16(CAN0_AM29H)
#define bfin_write_CAN0_AM29H(val)	bfin_write16(CAN0_AM29H, val)
#define bfin_read_CAN0_AM30L()		bfin_read16(CAN0_AM30L)
#define bfin_write_CAN0_AM30L(val)	bfin_write16(CAN0_AM30L, val)
#define bfin_read_CAN0_AM30H()		bfin_read16(CAN0_AM30H)
#define bfin_write_CAN0_AM30H(val)	bfin_write16(CAN0_AM30H, val)
#define bfin_read_CAN0_AM31L()		bfin_read16(CAN0_AM31L)
#define bfin_write_CAN0_AM31L(val)	bfin_write16(CAN0_AM31L, val)
#define bfin_read_CAN0_AM31H()		bfin_read16(CAN0_AM31H)
#define bfin_write_CAN0_AM31H(val)	bfin_write16(CAN0_AM31H, val)

/* CAN Controller 0 Mailbox Data Registers */

#define bfin_read_CAN0_MB00_DATA0()		bfin_read16(CAN0_MB00_DATA0)
#define bfin_write_CAN0_MB00_DATA0(val)		bfin_write16(CAN0_MB00_DATA0, val)
#define bfin_read_CAN0_MB00_DATA1()		bfin_read16(CAN0_MB00_DATA1)
#define bfin_write_CAN0_MB00_DATA1(val)		bfin_write16(CAN0_MB00_DATA1, val)
#define bfin_read_CAN0_MB00_DATA2()		bfin_read16(CAN0_MB00_DATA2)
#define bfin_write_CAN0_MB00_DATA2(val)		bfin_write16(CAN0_MB00_DATA2, val)
#define bfin_read_CAN0_MB00_DATA3()		bfin_read16(CAN0_MB00_DATA3)
#define bfin_write_CAN0_MB00_DATA3(val)		bfin_write16(CAN0_MB00_DATA3, val)
#define bfin_read_CAN0_MB00_LENGTH()		bfin_read16(CAN0_MB00_LENGTH)
#define bfin_write_CAN0_MB00_LENGTH(val)	bfin_write16(CAN0_MB00_LENGTH, val)
#define bfin_read_CAN0_MB00_TIMESTAMP()		bfin_read16(CAN0_MB00_TIMESTAMP)
#define bfin_write_CAN0_MB00_TIMESTAMP(val)	bfin_write16(CAN0_MB00_TIMESTAMP, val)
#define bfin_read_CAN0_MB00_ID0()		bfin_read16(CAN0_MB00_ID0)
#define bfin_write_CAN0_MB00_ID0(val)		bfin_write16(CAN0_MB00_ID0, val)
#define bfin_read_CAN0_MB00_ID1()		bfin_read16(CAN0_MB00_ID1)
#define bfin_write_CAN0_MB00_ID1(val)		bfin_write16(CAN0_MB00_ID1, val)
#define bfin_read_CAN0_MB01_DATA0()		bfin_read16(CAN0_MB01_DATA0)
#define bfin_write_CAN0_MB01_DATA0(val)		bfin_write16(CAN0_MB01_DATA0, val)
#define bfin_read_CAN0_MB01_DATA1()		bfin_read16(CAN0_MB01_DATA1)
#define bfin_write_CAN0_MB01_DATA1(val)		bfin_write16(CAN0_MB01_DATA1, val)
#define bfin_read_CAN0_MB01_DATA2()		bfin_read16(CAN0_MB01_DATA2)
#define bfin_write_CAN0_MB01_DATA2(val)		bfin_write16(CAN0_MB01_DATA2, val)
#define bfin_read_CAN0_MB01_DATA3()		bfin_read16(CAN0_MB01_DATA3)
#define bfin_write_CAN0_MB01_DATA3(val)		bfin_write16(CAN0_MB01_DATA3, val)
#define bfin_read_CAN0_MB01_LENGTH()		bfin_read16(CAN0_MB01_LENGTH)
#define bfin_write_CAN0_MB01_LENGTH(val)	bfin_write16(CAN0_MB01_LENGTH, val)
#define bfin_read_CAN0_MB01_TIMESTAMP()		bfin_read16(CAN0_MB01_TIMESTAMP)
#define bfin_write_CAN0_MB01_TIMESTAMP(val)	bfin_write16(CAN0_MB01_TIMESTAMP, val)
#define bfin_read_CAN0_MB01_ID0()		bfin_read16(CAN0_MB01_ID0)
#define bfin_write_CAN0_MB01_ID0(val)		bfin_write16(CAN0_MB01_ID0, val)
#define bfin_read_CAN0_MB01_ID1()		bfin_read16(CAN0_MB01_ID1)
#define bfin_write_CAN0_MB01_ID1(val)		bfin_write16(CAN0_MB01_ID1, val)
#define bfin_read_CAN0_MB02_DATA0()		bfin_read16(CAN0_MB02_DATA0)
#define bfin_write_CAN0_MB02_DATA0(val)		bfin_write16(CAN0_MB02_DATA0, val)
#define bfin_read_CAN0_MB02_DATA1()		bfin_read16(CAN0_MB02_DATA1)
#define bfin_write_CAN0_MB02_DATA1(val)		bfin_write16(CAN0_MB02_DATA1, val)
#define bfin_read_CAN0_MB02_DATA2()		bfin_read16(CAN0_MB02_DATA2)
#define bfin_write_CAN0_MB02_DATA2(val)		bfin_write16(CAN0_MB02_DATA2, val)
#define bfin_read_CAN0_MB02_DATA3()		bfin_read16(CAN0_MB02_DATA3)
#define bfin_write_CAN0_MB02_DATA3(val)		bfin_write16(CAN0_MB02_DATA3, val)
#define bfin_read_CAN0_MB02_LENGTH()		bfin_read16(CAN0_MB02_LENGTH)
#define bfin_write_CAN0_MB02_LENGTH(val)	bfin_write16(CAN0_MB02_LENGTH, val)
#define bfin_read_CAN0_MB02_TIMESTAMP()		bfin_read16(CAN0_MB02_TIMESTAMP)
#define bfin_write_CAN0_MB02_TIMESTAMP(val)	bfin_write16(CAN0_MB02_TIMESTAMP, val)
#define bfin_read_CAN0_MB02_ID0()		bfin_read16(CAN0_MB02_ID0)
#define bfin_write_CAN0_MB02_ID0(val)		bfin_write16(CAN0_MB02_ID0, val)
#define bfin_read_CAN0_MB02_ID1()		bfin_read16(CAN0_MB02_ID1)
#define bfin_write_CAN0_MB02_ID1(val)		bfin_write16(CAN0_MB02_ID1, val)
#define bfin_read_CAN0_MB03_DATA0()		bfin_read16(CAN0_MB03_DATA0)
#define bfin_write_CAN0_MB03_DATA0(val)		bfin_write16(CAN0_MB03_DATA0, val)
#define bfin_read_CAN0_MB03_DATA1()		bfin_read16(CAN0_MB03_DATA1)
#define bfin_write_CAN0_MB03_DATA1(val)		bfin_write16(CAN0_MB03_DATA1, val)
#define bfin_read_CAN0_MB03_DATA2()		bfin_read16(CAN0_MB03_DATA2)
#define bfin_write_CAN0_MB03_DATA2(val)		bfin_write16(CAN0_MB03_DATA2, val)
#define bfin_read_CAN0_MB03_DATA3()		bfin_read16(CAN0_MB03_DATA3)
#define bfin_write_CAN0_MB03_DATA3(val)		bfin_write16(CAN0_MB03_DATA3, val)
#define bfin_read_CAN0_MB03_LENGTH()		bfin_read16(CAN0_MB03_LENGTH)
#define bfin_write_CAN0_MB03_LENGTH(val)	bfin_write16(CAN0_MB03_LENGTH, val)
#define bfin_read_CAN0_MB03_TIMESTAMP()		bfin_read16(CAN0_MB03_TIMESTAMP)
#define bfin_write_CAN0_MB03_TIMESTAMP(val)	bfin_write16(CAN0_MB03_TIMESTAMP, val)
#define bfin_read_CAN0_MB03_ID0()		bfin_read16(CAN0_MB03_ID0)
#define bfin_write_CAN0_MB03_ID0(val)		bfin_write16(CAN0_MB03_ID0, val)
#define bfin_read_CAN0_MB03_ID1()		bfin_read16(CAN0_MB03_ID1)
#define bfin_write_CAN0_MB03_ID1(val)		bfin_write16(CAN0_MB03_ID1, val)
#define bfin_read_CAN0_MB04_DATA0()		bfin_read16(CAN0_MB04_DATA0)
#define bfin_write_CAN0_MB04_DATA0(val)		bfin_write16(CAN0_MB04_DATA0, val)
#define bfin_read_CAN0_MB04_DATA1()		bfin_read16(CAN0_MB04_DATA1)
#define bfin_write_CAN0_MB04_DATA1(val)		bfin_write16(CAN0_MB04_DATA1, val)
#define bfin_read_CAN0_MB04_DATA2()		bfin_read16(CAN0_MB04_DATA2)
#define bfin_write_CAN0_MB04_DATA2(val)		bfin_write16(CAN0_MB04_DATA2, val)
#define bfin_read_CAN0_MB04_DATA3()		bfin_read16(CAN0_MB04_DATA3)
#define bfin_write_CAN0_MB04_DATA3(val)		bfin_write16(CAN0_MB04_DATA3, val)
#define bfin_read_CAN0_MB04_LENGTH()		bfin_read16(CAN0_MB04_LENGTH)
#define bfin_write_CAN0_MB04_LENGTH(val)	bfin_write16(CAN0_MB04_LENGTH, val)
#define bfin_read_CAN0_MB04_TIMESTAMP()		bfin_read16(CAN0_MB04_TIMESTAMP)
#define bfin_write_CAN0_MB04_TIMESTAMP(val)	bfin_write16(CAN0_MB04_TIMESTAMP, val)
#define bfin_read_CAN0_MB04_ID0()		bfin_read16(CAN0_MB04_ID0)
#define bfin_write_CAN0_MB04_ID0(val)		bfin_write16(CAN0_MB04_ID0, val)
#define bfin_read_CAN0_MB04_ID1()		bfin_read16(CAN0_MB04_ID1)
#define bfin_write_CAN0_MB04_ID1(val)		bfin_write16(CAN0_MB04_ID1, val)
#define bfin_read_CAN0_MB05_DATA0()		bfin_read16(CAN0_MB05_DATA0)
#define bfin_write_CAN0_MB05_DATA0(val)		bfin_write16(CAN0_MB05_DATA0, val)
#define bfin_read_CAN0_MB05_DATA1()		bfin_read16(CAN0_MB05_DATA1)
#define bfin_write_CAN0_MB05_DATA1(val)		bfin_write16(CAN0_MB05_DATA1, val)
#define bfin_read_CAN0_MB05_DATA2()		bfin_read16(CAN0_MB05_DATA2)
#define bfin_write_CAN0_MB05_DATA2(val)		bfin_write16(CAN0_MB05_DATA2, val)
#define bfin_read_CAN0_MB05_DATA3()		bfin_read16(CAN0_MB05_DATA3)
#define bfin_write_CAN0_MB05_DATA3(val)		bfin_write16(CAN0_MB05_DATA3, val)
#define bfin_read_CAN0_MB05_LENGTH()		bfin_read16(CAN0_MB05_LENGTH)
#define bfin_write_CAN0_MB05_LENGTH(val)	bfin_write16(CAN0_MB05_LENGTH, val)
#define bfin_read_CAN0_MB05_TIMESTAMP()		bfin_read16(CAN0_MB05_TIMESTAMP)
#define bfin_write_CAN0_MB05_TIMESTAMP(val)	bfin_write16(CAN0_MB05_TIMESTAMP, val)
#define bfin_read_CAN0_MB05_ID0()		bfin_read16(CAN0_MB05_ID0)
#define bfin_write_CAN0_MB05_ID0(val)		bfin_write16(CAN0_MB05_ID0, val)
#define bfin_read_CAN0_MB05_ID1()		bfin_read16(CAN0_MB05_ID1)
#define bfin_write_CAN0_MB05_ID1(val)		bfin_write16(CAN0_MB05_ID1, val)
#define bfin_read_CAN0_MB06_DATA0()		bfin_read16(CAN0_MB06_DATA0)
#define bfin_write_CAN0_MB06_DATA0(val)		bfin_write16(CAN0_MB06_DATA0, val)
#define bfin_read_CAN0_MB06_DATA1()		bfin_read16(CAN0_MB06_DATA1)
#define bfin_write_CAN0_MB06_DATA1(val)		bfin_write16(CAN0_MB06_DATA1, val)
#define bfin_read_CAN0_MB06_DATA2()		bfin_read16(CAN0_MB06_DATA2)
#define bfin_write_CAN0_MB06_DATA2(val)		bfin_write16(CAN0_MB06_DATA2, val)
#define bfin_read_CAN0_MB06_DATA3()		bfin_read16(CAN0_MB06_DATA3)
#define bfin_write_CAN0_MB06_DATA3(val)		bfin_write16(CAN0_MB06_DATA3, val)
#define bfin_read_CAN0_MB06_LENGTH()		bfin_read16(CAN0_MB06_LENGTH)
#define bfin_write_CAN0_MB06_LENGTH(val)	bfin_write16(CAN0_MB06_LENGTH, val)
#define bfin_read_CAN0_MB06_TIMESTAMP()		bfin_read16(CAN0_MB06_TIMESTAMP)
#define bfin_write_CAN0_MB06_TIMESTAMP(val)	bfin_write16(CAN0_MB06_TIMESTAMP, val)
#define bfin_read_CAN0_MB06_ID0()		bfin_read16(CAN0_MB06_ID0)
#define bfin_write_CAN0_MB06_ID0(val)		bfin_write16(CAN0_MB06_ID0, val)
#define bfin_read_CAN0_MB06_ID1()		bfin_read16(CAN0_MB06_ID1)
#define bfin_write_CAN0_MB06_ID1(val)		bfin_write16(CAN0_MB06_ID1, val)
#define bfin_read_CAN0_MB07_DATA0()		bfin_read16(CAN0_MB07_DATA0)
#define bfin_write_CAN0_MB07_DATA0(val)		bfin_write16(CAN0_MB07_DATA0, val)
#define bfin_read_CAN0_MB07_DATA1()		bfin_read16(CAN0_MB07_DATA1)
#define bfin_write_CAN0_MB07_DATA1(val)		bfin_write16(CAN0_MB07_DATA1, val)
#define bfin_read_CAN0_MB07_DATA2()		bfin_read16(CAN0_MB07_DATA2)
#define bfin_write_CAN0_MB07_DATA2(val)		bfin_write16(CAN0_MB07_DATA2, val)
#define bfin_read_CAN0_MB07_DATA3()		bfin_read16(CAN0_MB07_DATA3)
#define bfin_write_CAN0_MB07_DATA3(val)		bfin_write16(CAN0_MB07_DATA3, val)
#define bfin_read_CAN0_MB07_LENGTH()		bfin_read16(CAN0_MB07_LENGTH)
#define bfin_write_CAN0_MB07_LENGTH(val)	bfin_write16(CAN0_MB07_LENGTH, val)
#define bfin_read_CAN0_MB07_TIMESTAMP()		bfin_read16(CAN0_MB07_TIMESTAMP)
#define bfin_write_CAN0_MB07_TIMESTAMP(val)	bfin_write16(CAN0_MB07_TIMESTAMP, val)
#define bfin_read_CAN0_MB07_ID0()		bfin_read16(CAN0_MB07_ID0)
#define bfin_write_CAN0_MB07_ID0(val)		bfin_write16(CAN0_MB07_ID0, val)
#define bfin_read_CAN0_MB07_ID1()		bfin_read16(CAN0_MB07_ID1)
#define bfin_write_CAN0_MB07_ID1(val)		bfin_write16(CAN0_MB07_ID1, val)
#define bfin_read_CAN0_MB08_DATA0()		bfin_read16(CAN0_MB08_DATA0)
#define bfin_write_CAN0_MB08_DATA0(val)		bfin_write16(CAN0_MB08_DATA0, val)
#define bfin_read_CAN0_MB08_DATA1()		bfin_read16(CAN0_MB08_DATA1)
#define bfin_write_CAN0_MB08_DATA1(val)		bfin_write16(CAN0_MB08_DATA1, val)
#define bfin_read_CAN0_MB08_DATA2()		bfin_read16(CAN0_MB08_DATA2)
#define bfin_write_CAN0_MB08_DATA2(val)		bfin_write16(CAN0_MB08_DATA2, val)
#define bfin_read_CAN0_MB08_DATA3()		bfin_read16(CAN0_MB08_DATA3)
#define bfin_write_CAN0_MB08_DATA3(val)		bfin_write16(CAN0_MB08_DATA3, val)
#define bfin_read_CAN0_MB08_LENGTH()		bfin_read16(CAN0_MB08_LENGTH)
#define bfin_write_CAN0_MB08_LENGTH(val)	bfin_write16(CAN0_MB08_LENGTH, val)
#define bfin_read_CAN0_MB08_TIMESTAMP()		bfin_read16(CAN0_MB08_TIMESTAMP)
#define bfin_write_CAN0_MB08_TIMESTAMP(val)	bfin_write16(CAN0_MB08_TIMESTAMP, val)
#define bfin_read_CAN0_MB08_ID0()		bfin_read16(CAN0_MB08_ID0)
#define bfin_write_CAN0_MB08_ID0(val)		bfin_write16(CAN0_MB08_ID0, val)
#define bfin_read_CAN0_MB08_ID1()		bfin_read16(CAN0_MB08_ID1)
#define bfin_write_CAN0_MB08_ID1(val)		bfin_write16(CAN0_MB08_ID1, val)
#define bfin_read_CAN0_MB09_DATA0()		bfin_read16(CAN0_MB09_DATA0)
#define bfin_write_CAN0_MB09_DATA0(val)		bfin_write16(CAN0_MB09_DATA0, val)
#define bfin_read_CAN0_MB09_DATA1()		bfin_read16(CAN0_MB09_DATA1)
#define bfin_write_CAN0_MB09_DATA1(val)		bfin_write16(CAN0_MB09_DATA1, val)
#define bfin_read_CAN0_MB09_DATA2()		bfin_read16(CAN0_MB09_DATA2)
#define bfin_write_CAN0_MB09_DATA2(val)		bfin_write16(CAN0_MB09_DATA2, val)
#define bfin_read_CAN0_MB09_DATA3()		bfin_read16(CAN0_MB09_DATA3)
#define bfin_write_CAN0_MB09_DATA3(val)		bfin_write16(CAN0_MB09_DATA3, val)
#define bfin_read_CAN0_MB09_LENGTH()		bfin_read16(CAN0_MB09_LENGTH)
#define bfin_write_CAN0_MB09_LENGTH(val)	bfin_write16(CAN0_MB09_LENGTH, val)
#define bfin_read_CAN0_MB09_TIMESTAMP()		bfin_read16(CAN0_MB09_TIMESTAMP)
#define bfin_write_CAN0_MB09_TIMESTAMP(val)	bfin_write16(CAN0_MB09_TIMESTAMP, val)
#define bfin_read_CAN0_MB09_ID0()		bfin_read16(CAN0_MB09_ID0)
#define bfin_write_CAN0_MB09_ID0(val)		bfin_write16(CAN0_MB09_ID0, val)
#define bfin_read_CAN0_MB09_ID1()		bfin_read16(CAN0_MB09_ID1)
#define bfin_write_CAN0_MB09_ID1(val)		bfin_write16(CAN0_MB09_ID1, val)
#define bfin_read_CAN0_MB10_DATA0()		bfin_read16(CAN0_MB10_DATA0)
#define bfin_write_CAN0_MB10_DATA0(val)		bfin_write16(CAN0_MB10_DATA0, val)
#define bfin_read_CAN0_MB10_DATA1()		bfin_read16(CAN0_MB10_DATA1)
#define bfin_write_CAN0_MB10_DATA1(val)		bfin_write16(CAN0_MB10_DATA1, val)
#define bfin_read_CAN0_MB10_DATA2()		bfin_read16(CAN0_MB10_DATA2)
#define bfin_write_CAN0_MB10_DATA2(val)		bfin_write16(CAN0_MB10_DATA2, val)
#define bfin_read_CAN0_MB10_DATA3()		bfin_read16(CAN0_MB10_DATA3)
#define bfin_write_CAN0_MB10_DATA3(val)		bfin_write16(CAN0_MB10_DATA3, val)
#define bfin_read_CAN0_MB10_LENGTH()		bfin_read16(CAN0_MB10_LENGTH)
#define bfin_write_CAN0_MB10_LENGTH(val)	bfin_write16(CAN0_MB10_LENGTH, val)
#define bfin_read_CAN0_MB10_TIMESTAMP()		bfin_read16(CAN0_MB10_TIMESTAMP)
#define bfin_write_CAN0_MB10_TIMESTAMP(val)	bfin_write16(CAN0_MB10_TIMESTAMP, val)
#define bfin_read_CAN0_MB10_ID0()		bfin_read16(CAN0_MB10_ID0)
#define bfin_write_CAN0_MB10_ID0(val)		bfin_write16(CAN0_MB10_ID0, val)
#define bfin_read_CAN0_MB10_ID1()		bfin_read16(CAN0_MB10_ID1)
#define bfin_write_CAN0_MB10_ID1(val)		bfin_write16(CAN0_MB10_ID1, val)
#define bfin_read_CAN0_MB11_DATA0()		bfin_read16(CAN0_MB11_DATA0)
#define bfin_write_CAN0_MB11_DATA0(val)		bfin_write16(CAN0_MB11_DATA0, val)
#define bfin_read_CAN0_MB11_DATA1()		bfin_read16(CAN0_MB11_DATA1)
#define bfin_write_CAN0_MB11_DATA1(val)		bfin_write16(CAN0_MB11_DATA1, val)
#define bfin_read_CAN0_MB11_DATA2()		bfin_read16(CAN0_MB11_DATA2)
#define bfin_write_CAN0_MB11_DATA2(val)		bfin_write16(CAN0_MB11_DATA2, val)
#define bfin_read_CAN0_MB11_DATA3()		bfin_read16(CAN0_MB11_DATA3)
#define bfin_write_CAN0_MB11_DATA3(val)		bfin_write16(CAN0_MB11_DATA3, val)
#define bfin_read_CAN0_MB11_LENGTH()		bfin_read16(CAN0_MB11_LENGTH)
#define bfin_write_CAN0_MB11_LENGTH(val)	bfin_write16(CAN0_MB11_LENGTH, val)
#define bfin_read_CAN0_MB11_TIMESTAMP()		bfin_read16(CAN0_MB11_TIMESTAMP)
#define bfin_write_CAN0_MB11_TIMESTAMP(val)	bfin_write16(CAN0_MB11_TIMESTAMP, val)
#define bfin_read_CAN0_MB11_ID0()		bfin_read16(CAN0_MB11_ID0)
#define bfin_write_CAN0_MB11_ID0(val)		bfin_write16(CAN0_MB11_ID0, val)
#define bfin_read_CAN0_MB11_ID1()		bfin_read16(CAN0_MB11_ID1)
#define bfin_write_CAN0_MB11_ID1(val)		bfin_write16(CAN0_MB11_ID1, val)
#define bfin_read_CAN0_MB12_DATA0()		bfin_read16(CAN0_MB12_DATA0)
#define bfin_write_CAN0_MB12_DATA0(val)		bfin_write16(CAN0_MB12_DATA0, val)
#define bfin_read_CAN0_MB12_DATA1()		bfin_read16(CAN0_MB12_DATA1)
#define bfin_write_CAN0_MB12_DATA1(val)		bfin_write16(CAN0_MB12_DATA1, val)
#define bfin_read_CAN0_MB12_DATA2()		bfin_read16(CAN0_MB12_DATA2)
#define bfin_write_CAN0_MB12_DATA2(val)		bfin_write16(CAN0_MB12_DATA2, val)
#define bfin_read_CAN0_MB12_DATA3()		bfin_read16(CAN0_MB12_DATA3)
#define bfin_write_CAN0_MB12_DATA3(val)		bfin_write16(CAN0_MB12_DATA3, val)
#define bfin_read_CAN0_MB12_LENGTH()		bfin_read16(CAN0_MB12_LENGTH)
#define bfin_write_CAN0_MB12_LENGTH(val)	bfin_write16(CAN0_MB12_LENGTH, val)
#define bfin_read_CAN0_MB12_TIMESTAMP()		bfin_read16(CAN0_MB12_TIMESTAMP)
#define bfin_write_CAN0_MB12_TIMESTAMP(val)	bfin_write16(CAN0_MB12_TIMESTAMP, val)
#define bfin_read_CAN0_MB12_ID0()		bfin_read16(CAN0_MB12_ID0)
#define bfin_write_CAN0_MB12_ID0(val)		bfin_write16(CAN0_MB12_ID0, val)
#define bfin_read_CAN0_MB12_ID1()		bfin_read16(CAN0_MB12_ID1)
#define bfin_write_CAN0_MB12_ID1(val)		bfin_write16(CAN0_MB12_ID1, val)
#define bfin_read_CAN0_MB13_DATA0()		bfin_read16(CAN0_MB13_DATA0)
#define bfin_write_CAN0_MB13_DATA0(val)		bfin_write16(CAN0_MB13_DATA0, val)
#define bfin_read_CAN0_MB13_DATA1()		bfin_read16(CAN0_MB13_DATA1)
#define bfin_write_CAN0_MB13_DATA1(val)		bfin_write16(CAN0_MB13_DATA1, val)
#define bfin_read_CAN0_MB13_DATA2()		bfin_read16(CAN0_MB13_DATA2)
#define bfin_write_CAN0_MB13_DATA2(val)		bfin_write16(CAN0_MB13_DATA2, val)
#define bfin_read_CAN0_MB13_DATA3()		bfin_read16(CAN0_MB13_DATA3)
#define bfin_write_CAN0_MB13_DATA3(val)		bfin_write16(CAN0_MB13_DATA3, val)
#define bfin_read_CAN0_MB13_LENGTH()		bfin_read16(CAN0_MB13_LENGTH)
#define bfin_write_CAN0_MB13_LENGTH(val)	bfin_write16(CAN0_MB13_LENGTH, val)
#define bfin_read_CAN0_MB13_TIMESTAMP()		bfin_read16(CAN0_MB13_TIMESTAMP)
#define bfin_write_CAN0_MB13_TIMESTAMP(val)	bfin_write16(CAN0_MB13_TIMESTAMP, val)
#define bfin_read_CAN0_MB13_ID0()		bfin_read16(CAN0_MB13_ID0)
#define bfin_write_CAN0_MB13_ID0(val)		bfin_write16(CAN0_MB13_ID0, val)
#define bfin_read_CAN0_MB13_ID1()		bfin_read16(CAN0_MB13_ID1)
#define bfin_write_CAN0_MB13_ID1(val)		bfin_write16(CAN0_MB13_ID1, val)
#define bfin_read_CAN0_MB14_DATA0()		bfin_read16(CAN0_MB14_DATA0)
#define bfin_write_CAN0_MB14_DATA0(val)		bfin_write16(CAN0_MB14_DATA0, val)
#define bfin_read_CAN0_MB14_DATA1()		bfin_read16(CAN0_MB14_DATA1)
#define bfin_write_CAN0_MB14_DATA1(val)		bfin_write16(CAN0_MB14_DATA1, val)
#define bfin_read_CAN0_MB14_DATA2()		bfin_read16(CAN0_MB14_DATA2)
#define bfin_write_CAN0_MB14_DATA2(val)		bfin_write16(CAN0_MB14_DATA2, val)
#define bfin_read_CAN0_MB14_DATA3()		bfin_read16(CAN0_MB14_DATA3)
#define bfin_write_CAN0_MB14_DATA3(val)		bfin_write16(CAN0_MB14_DATA3, val)
#define bfin_read_CAN0_MB14_LENGTH()		bfin_read16(CAN0_MB14_LENGTH)
#define bfin_write_CAN0_MB14_LENGTH(val)	bfin_write16(CAN0_MB14_LENGTH, val)
#define bfin_read_CAN0_MB14_TIMESTAMP()		bfin_read16(CAN0_MB14_TIMESTAMP)
#define bfin_write_CAN0_MB14_TIMESTAMP(val)	bfin_write16(CAN0_MB14_TIMESTAMP, val)
#define bfin_read_CAN0_MB14_ID0()		bfin_read16(CAN0_MB14_ID0)
#define bfin_write_CAN0_MB14_ID0(val)		bfin_write16(CAN0_MB14_ID0, val)
#define bfin_read_CAN0_MB14_ID1()		bfin_read16(CAN0_MB14_ID1)
#define bfin_write_CAN0_MB14_ID1(val)		bfin_write16(CAN0_MB14_ID1, val)
#define bfin_read_CAN0_MB15_DATA0()		bfin_read16(CAN0_MB15_DATA0)
#define bfin_write_CAN0_MB15_DATA0(val)		bfin_write16(CAN0_MB15_DATA0, val)
#define bfin_read_CAN0_MB15_DATA1()		bfin_read16(CAN0_MB15_DATA1)
#define bfin_write_CAN0_MB15_DATA1(val)		bfin_write16(CAN0_MB15_DATA1, val)
#define bfin_read_CAN0_MB15_DATA2()		bfin_read16(CAN0_MB15_DATA2)
#define bfin_write_CAN0_MB15_DATA2(val)		bfin_write16(CAN0_MB15_DATA2, val)
#define bfin_read_CAN0_MB15_DATA3()		bfin_read16(CAN0_MB15_DATA3)
#define bfin_write_CAN0_MB15_DATA3(val)		bfin_write16(CAN0_MB15_DATA3, val)
#define bfin_read_CAN0_MB15_LENGTH()		bfin_read16(CAN0_MB15_LENGTH)
#define bfin_write_CAN0_MB15_LENGTH(val)	bfin_write16(CAN0_MB15_LENGTH, val)
#define bfin_read_CAN0_MB15_TIMESTAMP()		bfin_read16(CAN0_MB15_TIMESTAMP)
#define bfin_write_CAN0_MB15_TIMESTAMP(val)	bfin_write16(CAN0_MB15_TIMESTAMP, val)
#define bfin_read_CAN0_MB15_ID0()		bfin_read16(CAN0_MB15_ID0)
#define bfin_write_CAN0_MB15_ID0(val)		bfin_write16(CAN0_MB15_ID0, val)
#define bfin_read_CAN0_MB15_ID1()		bfin_read16(CAN0_MB15_ID1)
#define bfin_write_CAN0_MB15_ID1(val)		bfin_write16(CAN0_MB15_ID1, val)

/* CAN Controller 0 Mailbox Data Registers */

#define bfin_read_CAN0_MB16_DATA0()		bfin_read16(CAN0_MB16_DATA0)
#define bfin_write_CAN0_MB16_DATA0(val)		bfin_write16(CAN0_MB16_DATA0, val)
#define bfin_read_CAN0_MB16_DATA1()		bfin_read16(CAN0_MB16_DATA1)
#define bfin_write_CAN0_MB16_DATA1(val)		bfin_write16(CAN0_MB16_DATA1, val)
#define bfin_read_CAN0_MB16_DATA2()		bfin_read16(CAN0_MB16_DATA2)
#define bfin_write_CAN0_MB16_DATA2(val)		bfin_write16(CAN0_MB16_DATA2, val)
#define bfin_read_CAN0_MB16_DATA3()		bfin_read16(CAN0_MB16_DATA3)
#define bfin_write_CAN0_MB16_DATA3(val)		bfin_write16(CAN0_MB16_DATA3, val)
#define bfin_read_CAN0_MB16_LENGTH()		bfin_read16(CAN0_MB16_LENGTH)
#define bfin_write_CAN0_MB16_LENGTH(val)	bfin_write16(CAN0_MB16_LENGTH, val)
#define bfin_read_CAN0_MB16_TIMESTAMP()		bfin_read16(CAN0_MB16_TIMESTAMP)
#define bfin_write_CAN0_MB16_TIMESTAMP(val)	bfin_write16(CAN0_MB16_TIMESTAMP, val)
#define bfin_read_CAN0_MB16_ID0()		bfin_read16(CAN0_MB16_ID0)
#define bfin_write_CAN0_MB16_ID0(val)		bfin_write16(CAN0_MB16_ID0, val)
#define bfin_read_CAN0_MB16_ID1()		bfin_read16(CAN0_MB16_ID1)
#define bfin_write_CAN0_MB16_ID1(val)		bfin_write16(CAN0_MB16_ID1, val)
#define bfin_read_CAN0_MB17_DATA0()		bfin_read16(CAN0_MB17_DATA0)
#define bfin_write_CAN0_MB17_DATA0(val)		bfin_write16(CAN0_MB17_DATA0, val)
#define bfin_read_CAN0_MB17_DATA1()		bfin_read16(CAN0_MB17_DATA1)
#define bfin_write_CAN0_MB17_DATA1(val)		bfin_write16(CAN0_MB17_DATA1, val)
#define bfin_read_CAN0_MB17_DATA2()		bfin_read16(CAN0_MB17_DATA2)
#define bfin_write_CAN0_MB17_DATA2(val)		bfin_write16(CAN0_MB17_DATA2, val)
#define bfin_read_CAN0_MB17_DATA3()		bfin_read16(CAN0_MB17_DATA3)
#define bfin_write_CAN0_MB17_DATA3(val)		bfin_write16(CAN0_MB17_DATA3, val)
#define bfin_read_CAN0_MB17_LENGTH()		bfin_read16(CAN0_MB17_LENGTH)
#define bfin_write_CAN0_MB17_LENGTH(val)	bfin_write16(CAN0_MB17_LENGTH, val)
#define bfin_read_CAN0_MB17_TIMESTAMP()		bfin_read16(CAN0_MB17_TIMESTAMP)
#define bfin_write_CAN0_MB17_TIMESTAMP(val)	bfin_write16(CAN0_MB17_TIMESTAMP, val)
#define bfin_read_CAN0_MB17_ID0()		bfin_read16(CAN0_MB17_ID0)
#define bfin_write_CAN0_MB17_ID0(val)		bfin_write16(CAN0_MB17_ID0, val)
#define bfin_read_CAN0_MB17_ID1()		bfin_read16(CAN0_MB17_ID1)
#define bfin_write_CAN0_MB17_ID1(val)		bfin_write16(CAN0_MB17_ID1, val)
#define bfin_read_CAN0_MB18_DATA0()		bfin_read16(CAN0_MB18_DATA0)
#define bfin_write_CAN0_MB18_DATA0(val)		bfin_write16(CAN0_MB18_DATA0, val)
#define bfin_read_CAN0_MB18_DATA1()		bfin_read16(CAN0_MB18_DATA1)
#define bfin_write_CAN0_MB18_DATA1(val)		bfin_write16(CAN0_MB18_DATA1, val)
#define bfin_read_CAN0_MB18_DATA2()		bfin_read16(CAN0_MB18_DATA2)
#define bfin_write_CAN0_MB18_DATA2(val)		bfin_write16(CAN0_MB18_DATA2, val)
#define bfin_read_CAN0_MB18_DATA3()		bfin_read16(CAN0_MB18_DATA3)
#define bfin_write_CAN0_MB18_DATA3(val)		bfin_write16(CAN0_MB18_DATA3, val)
#define bfin_read_CAN0_MB18_LENGTH()		bfin_read16(CAN0_MB18_LENGTH)
#define bfin_write_CAN0_MB18_LENGTH(val)	bfin_write16(CAN0_MB18_LENGTH, val)
#define bfin_read_CAN0_MB18_TIMESTAMP()		bfin_read16(CAN0_MB18_TIMESTAMP)
#define bfin_write_CAN0_MB18_TIMESTAMP(val)	bfin_write16(CAN0_MB18_TIMESTAMP, val)
#define bfin_read_CAN0_MB18_ID0()		bfin_read16(CAN0_MB18_ID0)
#define bfin_write_CAN0_MB18_ID0(val)		bfin_write16(CAN0_MB18_ID0, val)
#define bfin_read_CAN0_MB18_ID1()		bfin_read16(CAN0_MB18_ID1)
#define bfin_write_CAN0_MB18_ID1(val)		bfin_write16(CAN0_MB18_ID1, val)
#define bfin_read_CAN0_MB19_DATA0()		bfin_read16(CAN0_MB19_DATA0)
#define bfin_write_CAN0_MB19_DATA0(val)		bfin_write16(CAN0_MB19_DATA0, val)
#define bfin_read_CAN0_MB19_DATA1()		bfin_read16(CAN0_MB19_DATA1)
#define bfin_write_CAN0_MB19_DATA1(val)		bfin_write16(CAN0_MB19_DATA1, val)
#define bfin_read_CAN0_MB19_DATA2()		bfin_read16(CAN0_MB19_DATA2)
#define bfin_write_CAN0_MB19_DATA2(val)		bfin_write16(CAN0_MB19_DATA2, val)
#define bfin_read_CAN0_MB19_DATA3()		bfin_read16(CAN0_MB19_DATA3)
#define bfin_write_CAN0_MB19_DATA3(val)		bfin_write16(CAN0_MB19_DATA3, val)
#define bfin_read_CAN0_MB19_LENGTH()		bfin_read16(CAN0_MB19_LENGTH)
#define bfin_write_CAN0_MB19_LENGTH(val)	bfin_write16(CAN0_MB19_LENGTH, val)
#define bfin_read_CAN0_MB19_TIMESTAMP()		bfin_read16(CAN0_MB19_TIMESTAMP)
#define bfin_write_CAN0_MB19_TIMESTAMP(val)	bfin_write16(CAN0_MB19_TIMESTAMP, val)
#define bfin_read_CAN0_MB19_ID0()		bfin_read16(CAN0_MB19_ID0)
#define bfin_write_CAN0_MB19_ID0(val)		bfin_write16(CAN0_MB19_ID0, val)
#define bfin_read_CAN0_MB19_ID1()		bfin_read16(CAN0_MB19_ID1)
#define bfin_write_CAN0_MB19_ID1(val)		bfin_write16(CAN0_MB19_ID1, val)
#define bfin_read_CAN0_MB20_DATA0()		bfin_read16(CAN0_MB20_DATA0)
#define bfin_write_CAN0_MB20_DATA0(val)		bfin_write16(CAN0_MB20_DATA0, val)
#define bfin_read_CAN0_MB20_DATA1()		bfin_read16(CAN0_MB20_DATA1)
#define bfin_write_CAN0_MB20_DATA1(val)		bfin_write16(CAN0_MB20_DATA1, val)
#define bfin_read_CAN0_MB20_DATA2()		bfin_read16(CAN0_MB20_DATA2)
#define bfin_write_CAN0_MB20_DATA2(val)		bfin_write16(CAN0_MB20_DATA2, val)
#define bfin_read_CAN0_MB20_DATA3()		bfin_read16(CAN0_MB20_DATA3)
#define bfin_write_CAN0_MB20_DATA3(val)		bfin_write16(CAN0_MB20_DATA3, val)
#define bfin_read_CAN0_MB20_LENGTH()		bfin_read16(CAN0_MB20_LENGTH)
#define bfin_write_CAN0_MB20_LENGTH(val)	bfin_write16(CAN0_MB20_LENGTH, val)
#define bfin_read_CAN0_MB20_TIMESTAMP()		bfin_read16(CAN0_MB20_TIMESTAMP)
#define bfin_write_CAN0_MB20_TIMESTAMP(val)	bfin_write16(CAN0_MB20_TIMESTAMP, val)
#define bfin_read_CAN0_MB20_ID0()		bfin_read16(CAN0_MB20_ID0)
#define bfin_write_CAN0_MB20_ID0(val)		bfin_write16(CAN0_MB20_ID0, val)
#define bfin_read_CAN0_MB20_ID1()		bfin_read16(CAN0_MB20_ID1)
#define bfin_write_CAN0_MB20_ID1(val)		bfin_write16(CAN0_MB20_ID1, val)
#define bfin_read_CAN0_MB21_DATA0()		bfin_read16(CAN0_MB21_DATA0)
#define bfin_write_CAN0_MB21_DATA0(val)		bfin_write16(CAN0_MB21_DATA0, val)
#define bfin_read_CAN0_MB21_DATA1()		bfin_read16(CAN0_MB21_DATA1)
#define bfin_write_CAN0_MB21_DATA1(val)		bfin_write16(CAN0_MB21_DATA1, val)
#define bfin_read_CAN0_MB21_DATA2()		bfin_read16(CAN0_MB21_DATA2)
#define bfin_write_CAN0_MB21_DATA2(val)		bfin_write16(CAN0_MB21_DATA2, val)
#define bfin_read_CAN0_MB21_DATA3()		bfin_read16(CAN0_MB21_DATA3)
#define bfin_write_CAN0_MB21_DATA3(val)		bfin_write16(CAN0_MB21_DATA3, val)
#define bfin_read_CAN0_MB21_LENGTH()		bfin_read16(CAN0_MB21_LENGTH)
#define bfin_write_CAN0_MB21_LENGTH(val)	bfin_write16(CAN0_MB21_LENGTH, val)
#define bfin_read_CAN0_MB21_TIMESTAMP()		bfin_read16(CAN0_MB21_TIMESTAMP)
#define bfin_write_CAN0_MB21_TIMESTAMP(val)	bfin_write16(CAN0_MB21_TIMESTAMP, val)
#define bfin_read_CAN0_MB21_ID0()		bfin_read16(CAN0_MB21_ID0)
#define bfin_write_CAN0_MB21_ID0(val)		bfin_write16(CAN0_MB21_ID0, val)
#define bfin_read_CAN0_MB21_ID1()		bfin_read16(CAN0_MB21_ID1)
#define bfin_write_CAN0_MB21_ID1(val)		bfin_write16(CAN0_MB21_ID1, val)
#define bfin_read_CAN0_MB22_DATA0()		bfin_read16(CAN0_MB22_DATA0)
#define bfin_write_CAN0_MB22_DATA0(val)		bfin_write16(CAN0_MB22_DATA0, val)
#define bfin_read_CAN0_MB22_DATA1()		bfin_read16(CAN0_MB22_DATA1)
#define bfin_write_CAN0_MB22_DATA1(val)		bfin_write16(CAN0_MB22_DATA1, val)
#define bfin_read_CAN0_MB22_DATA2()		bfin_read16(CAN0_MB22_DATA2)
#define bfin_write_CAN0_MB22_DATA2(val)		bfin_write16(CAN0_MB22_DATA2, val)
#define bfin_read_CAN0_MB22_DATA3()		bfin_read16(CAN0_MB22_DATA3)
#define bfin_write_CAN0_MB22_DATA3(val)		bfin_write16(CAN0_MB22_DATA3, val)
#define bfin_read_CAN0_MB22_LENGTH()		bfin_read16(CAN0_MB22_LENGTH)
#define bfin_write_CAN0_MB22_LENGTH(val)	bfin_write16(CAN0_MB22_LENGTH, val)
#define bfin_read_CAN0_MB22_TIMESTAMP()		bfin_read16(CAN0_MB22_TIMESTAMP)
#define bfin_write_CAN0_MB22_TIMESTAMP(val)	bfin_write16(CAN0_MB22_TIMESTAMP, val)
#define bfin_read_CAN0_MB22_ID0()		bfin_read16(CAN0_MB22_ID0)
#define bfin_write_CAN0_MB22_ID0(val)		bfin_write16(CAN0_MB22_ID0, val)
#define bfin_read_CAN0_MB22_ID1()		bfin_read16(CAN0_MB22_ID1)
#define bfin_write_CAN0_MB22_ID1(val)		bfin_write16(CAN0_MB22_ID1, val)
#define bfin_read_CAN0_MB23_DATA0()		bfin_read16(CAN0_MB23_DATA0)
#define bfin_write_CAN0_MB23_DATA0(val)		bfin_write16(CAN0_MB23_DATA0, val)
#define bfin_read_CAN0_MB23_DATA1()		bfin_read16(CAN0_MB23_DATA1)
#define bfin_write_CAN0_MB23_DATA1(val)		bfin_write16(CAN0_MB23_DATA1, val)
#define bfin_read_CAN0_MB23_DATA2()		bfin_read16(CAN0_MB23_DATA2)
#define bfin_write_CAN0_MB23_DATA2(val)		bfin_write16(CAN0_MB23_DATA2, val)
#define bfin_read_CAN0_MB23_DATA3()		bfin_read16(CAN0_MB23_DATA3)
#define bfin_write_CAN0_MB23_DATA3(val)		bfin_write16(CAN0_MB23_DATA3, val)
#define bfin_read_CAN0_MB23_LENGTH()		bfin_read16(CAN0_MB23_LENGTH)
#define bfin_write_CAN0_MB23_LENGTH(val)	bfin_write16(CAN0_MB23_LENGTH, val)
#define bfin_read_CAN0_MB23_TIMESTAMP()		bfin_read16(CAN0_MB23_TIMESTAMP)
#define bfin_write_CAN0_MB23_TIMESTAMP(val)	bfin_write16(CAN0_MB23_TIMESTAMP, val)
#define bfin_read_CAN0_MB23_ID0()		bfin_read16(CAN0_MB23_ID0)
#define bfin_write_CAN0_MB23_ID0(val)		bfin_write16(CAN0_MB23_ID0, val)
#define bfin_read_CAN0_MB23_ID1()		bfin_read16(CAN0_MB23_ID1)
#define bfin_write_CAN0_MB23_ID1(val)		bfin_write16(CAN0_MB23_ID1, val)
#define bfin_read_CAN0_MB24_DATA0()		bfin_read16(CAN0_MB24_DATA0)
#define bfin_write_CAN0_MB24_DATA0(val)		bfin_write16(CAN0_MB24_DATA0, val)
#define bfin_read_CAN0_MB24_DATA1()		bfin_read16(CAN0_MB24_DATA1)
#define bfin_write_CAN0_MB24_DATA1(val)		bfin_write16(CAN0_MB24_DATA1, val)
#define bfin_read_CAN0_MB24_DATA2()		bfin_read16(CAN0_MB24_DATA2)
#define bfin_write_CAN0_MB24_DATA2(val)		bfin_write16(CAN0_MB24_DATA2, val)
#define bfin_read_CAN0_MB24_DATA3()		bfin_read16(CAN0_MB24_DATA3)
#define bfin_write_CAN0_MB24_DATA3(val)		bfin_write16(CAN0_MB24_DATA3, val)
#define bfin_read_CAN0_MB24_LENGTH()		bfin_read16(CAN0_MB24_LENGTH)
#define bfin_write_CAN0_MB24_LENGTH(val)	bfin_write16(CAN0_MB24_LENGTH, val)
#define bfin_read_CAN0_MB24_TIMESTAMP()		bfin_read16(CAN0_MB24_TIMESTAMP)
#define bfin_write_CAN0_MB24_TIMESTAMP(val)	bfin_write16(CAN0_MB24_TIMESTAMP, val)
#define bfin_read_CAN0_MB24_ID0()		bfin_read16(CAN0_MB24_ID0)
#define bfin_write_CAN0_MB24_ID0(val)		bfin_write16(CAN0_MB24_ID0, val)
#define bfin_read_CAN0_MB24_ID1()		bfin_read16(CAN0_MB24_ID1)
#define bfin_write_CAN0_MB24_ID1(val)		bfin_write16(CAN0_MB24_ID1, val)
#define bfin_read_CAN0_MB25_DATA0()		bfin_read16(CAN0_MB25_DATA0)
#define bfin_write_CAN0_MB25_DATA0(val)		bfin_write16(CAN0_MB25_DATA0, val)
#define bfin_read_CAN0_MB25_DATA1()		bfin_read16(CAN0_MB25_DATA1)
#define bfin_write_CAN0_MB25_DATA1(val)		bfin_write16(CAN0_MB25_DATA1, val)
#define bfin_read_CAN0_MB25_DATA2()		bfin_read16(CAN0_MB25_DATA2)
#define bfin_write_CAN0_MB25_DATA2(val)		bfin_write16(CAN0_MB25_DATA2, val)
#define bfin_read_CAN0_MB25_DATA3()		bfin_read16(CAN0_MB25_DATA3)
#define bfin_write_CAN0_MB25_DATA3(val)		bfin_write16(CAN0_MB25_DATA3, val)
#define bfin_read_CAN0_MB25_LENGTH()		bfin_read16(CAN0_MB25_LENGTH)
#define bfin_write_CAN0_MB25_LENGTH(val)	bfin_write16(CAN0_MB25_LENGTH, val)
#define bfin_read_CAN0_MB25_TIMESTAMP()		bfin_read16(CAN0_MB25_TIMESTAMP)
#define bfin_write_CAN0_MB25_TIMESTAMP(val)	bfin_write16(CAN0_MB25_TIMESTAMP, val)
#define bfin_read_CAN0_MB25_ID0()		bfin_read16(CAN0_MB25_ID0)
#define bfin_write_CAN0_MB25_ID0(val)		bfin_write16(CAN0_MB25_ID0, val)
#define bfin_read_CAN0_MB25_ID1()		bfin_read16(CAN0_MB25_ID1)
#define bfin_write_CAN0_MB25_ID1(val)		bfin_write16(CAN0_MB25_ID1, val)
#define bfin_read_CAN0_MB26_DATA0()		bfin_read16(CAN0_MB26_DATA0)
#define bfin_write_CAN0_MB26_DATA0(val)		bfin_write16(CAN0_MB26_DATA0, val)
#define bfin_read_CAN0_MB26_DATA1()		bfin_read16(CAN0_MB26_DATA1)
#define bfin_write_CAN0_MB26_DATA1(val)		bfin_write16(CAN0_MB26_DATA1, val)
#define bfin_read_CAN0_MB26_DATA2()		bfin_read16(CAN0_MB26_DATA2)
#define bfin_write_CAN0_MB26_DATA2(val)		bfin_write16(CAN0_MB26_DATA2, val)
#define bfin_read_CAN0_MB26_DATA3()		bfin_read16(CAN0_MB26_DATA3)
#define bfin_write_CAN0_MB26_DATA3(val)		bfin_write16(CAN0_MB26_DATA3, val)
#define bfin_read_CAN0_MB26_LENGTH()		bfin_read16(CAN0_MB26_LENGTH)
#define bfin_write_CAN0_MB26_LENGTH(val)	bfin_write16(CAN0_MB26_LENGTH, val)
#define bfin_read_CAN0_MB26_TIMESTAMP()		bfin_read16(CAN0_MB26_TIMESTAMP)
#define bfin_write_CAN0_MB26_TIMESTAMP(val)	bfin_write16(CAN0_MB26_TIMESTAMP, val)
#define bfin_read_CAN0_MB26_ID0()		bfin_read16(CAN0_MB26_ID0)
#define bfin_write_CAN0_MB26_ID0(val)		bfin_write16(CAN0_MB26_ID0, val)
#define bfin_read_CAN0_MB26_ID1()		bfin_read16(CAN0_MB26_ID1)
#define bfin_write_CAN0_MB26_ID1(val)		bfin_write16(CAN0_MB26_ID1, val)
#define bfin_read_CAN0_MB27_DATA0()		bfin_read16(CAN0_MB27_DATA0)
#define bfin_write_CAN0_MB27_DATA0(val)		bfin_write16(CAN0_MB27_DATA0, val)
#define bfin_read_CAN0_MB27_DATA1()		bfin_read16(CAN0_MB27_DATA1)
#define bfin_write_CAN0_MB27_DATA1(val)		bfin_write16(CAN0_MB27_DATA1, val)
#define bfin_read_CAN0_MB27_DATA2()		bfin_read16(CAN0_MB27_DATA2)
#define bfin_write_CAN0_MB27_DATA2(val)		bfin_write16(CAN0_MB27_DATA2, val)
#define bfin_read_CAN0_MB27_DATA3()		bfin_read16(CAN0_MB27_DATA3)
#define bfin_write_CAN0_MB27_DATA3(val)		bfin_write16(CAN0_MB27_DATA3, val)
#define bfin_read_CAN0_MB27_LENGTH()		bfin_read16(CAN0_MB27_LENGTH)
#define bfin_write_CAN0_MB27_LENGTH(val)	bfin_write16(CAN0_MB27_LENGTH, val)
#define bfin_read_CAN0_MB27_TIMESTAMP()		bfin_read16(CAN0_MB27_TIMESTAMP)
#define bfin_write_CAN0_MB27_TIMESTAMP(val)	bfin_write16(CAN0_MB27_TIMESTAMP, val)
#define bfin_read_CAN0_MB27_ID0()		bfin_read16(CAN0_MB27_ID0)
#define bfin_write_CAN0_MB27_ID0(val)		bfin_write16(CAN0_MB27_ID0, val)
#define bfin_read_CAN0_MB27_ID1()		bfin_read16(CAN0_MB27_ID1)
#define bfin_write_CAN0_MB27_ID1(val)		bfin_write16(CAN0_MB27_ID1, val)
#define bfin_read_CAN0_MB28_DATA0()		bfin_read16(CAN0_MB28_DATA0)
#define bfin_write_CAN0_MB28_DATA0(val)		bfin_write16(CAN0_MB28_DATA0, val)
#define bfin_read_CAN0_MB28_DATA1()		bfin_read16(CAN0_MB28_DATA1)
#define bfin_write_CAN0_MB28_DATA1(val)		bfin_write16(CAN0_MB28_DATA1, val)
#define bfin_read_CAN0_MB28_DATA2()		bfin_read16(CAN0_MB28_DATA2)
#define bfin_write_CAN0_MB28_DATA2(val)		bfin_write16(CAN0_MB28_DATA2, val)
#define bfin_read_CAN0_MB28_DATA3()		bfin_read16(CAN0_MB28_DATA3)
#define bfin_write_CAN0_MB28_DATA3(val)		bfin_write16(CAN0_MB28_DATA3, val)
#define bfin_read_CAN0_MB28_LENGTH()		bfin_read16(CAN0_MB28_LENGTH)
#define bfin_write_CAN0_MB28_LENGTH(val)	bfin_write16(CAN0_MB28_LENGTH, val)
#define bfin_read_CAN0_MB28_TIMESTAMP()		bfin_read16(CAN0_MB28_TIMESTAMP)
#define bfin_write_CAN0_MB28_TIMESTAMP(val)	bfin_write16(CAN0_MB28_TIMESTAMP, val)
#define bfin_read_CAN0_MB28_ID0()		bfin_read16(CAN0_MB28_ID0)
#define bfin_write_CAN0_MB28_ID0(val)		bfin_write16(CAN0_MB28_ID0, val)
#define bfin_read_CAN0_MB28_ID1()		bfin_read16(CAN0_MB28_ID1)
#define bfin_write_CAN0_MB28_ID1(val)		bfin_write16(CAN0_MB28_ID1, val)
#define bfin_read_CAN0_MB29_DATA0()		bfin_read16(CAN0_MB29_DATA0)
#define bfin_write_CAN0_MB29_DATA0(val)		bfin_write16(CAN0_MB29_DATA0, val)
#define bfin_read_CAN0_MB29_DATA1()		bfin_read16(CAN0_MB29_DATA1)
#define bfin_write_CAN0_MB29_DATA1(val)		bfin_write16(CAN0_MB29_DATA1, val)
#define bfin_read_CAN0_MB29_DATA2()		bfin_read16(CAN0_MB29_DATA2)
#define bfin_write_CAN0_MB29_DATA2(val)		bfin_write16(CAN0_MB29_DATA2, val)
#define bfin_read_CAN0_MB29_DATA3()		bfin_read16(CAN0_MB29_DATA3)
#define bfin_write_CAN0_MB29_DATA3(val)		bfin_write16(CAN0_MB29_DATA3, val)
#define bfin_read_CAN0_MB29_LENGTH()		bfin_read16(CAN0_MB29_LENGTH)
#define bfin_write_CAN0_MB29_LENGTH(val)	bfin_write16(CAN0_MB29_LENGTH, val)
#define bfin_read_CAN0_MB29_TIMESTAMP()		bfin_read16(CAN0_MB29_TIMESTAMP)
#define bfin_write_CAN0_MB29_TIMESTAMP(val)	bfin_write16(CAN0_MB29_TIMESTAMP, val)
#define bfin_read_CAN0_MB29_ID0()		bfin_read16(CAN0_MB29_ID0)
#define bfin_write_CAN0_MB29_ID0(val)		bfin_write16(CAN0_MB29_ID0, val)
#define bfin_read_CAN0_MB29_ID1()		bfin_read16(CAN0_MB29_ID1)
#define bfin_write_CAN0_MB29_ID1(val)		bfin_write16(CAN0_MB29_ID1, val)
#define bfin_read_CAN0_MB30_DATA0()		bfin_read16(CAN0_MB30_DATA0)
#define bfin_write_CAN0_MB30_DATA0(val)		bfin_write16(CAN0_MB30_DATA0, val)
#define bfin_read_CAN0_MB30_DATA1()		bfin_read16(CAN0_MB30_DATA1)
#define bfin_write_CAN0_MB30_DATA1(val)		bfin_write16(CAN0_MB30_DATA1, val)
#define bfin_read_CAN0_MB30_DATA2()		bfin_read16(CAN0_MB30_DATA2)
#define bfin_write_CAN0_MB30_DATA2(val)		bfin_write16(CAN0_MB30_DATA2, val)
#define bfin_read_CAN0_MB30_DATA3()		bfin_read16(CAN0_MB30_DATA3)
#define bfin_write_CAN0_MB30_DATA3(val)		bfin_write16(CAN0_MB30_DATA3, val)
#define bfin_read_CAN0_MB30_LENGTH()		bfin_read16(CAN0_MB30_LENGTH)
#define bfin_write_CAN0_MB30_LENGTH(val)	bfin_write16(CAN0_MB30_LENGTH, val)
#define bfin_read_CAN0_MB30_TIMESTAMP()		bfin_read16(CAN0_MB30_TIMESTAMP)
#define bfin_write_CAN0_MB30_TIMESTAMP(val)	bfin_write16(CAN0_MB30_TIMESTAMP, val)
#define bfin_read_CAN0_MB30_ID0()		bfin_read16(CAN0_MB30_ID0)
#define bfin_write_CAN0_MB30_ID0(val)		bfin_write16(CAN0_MB30_ID0, val)
#define bfin_read_CAN0_MB30_ID1()		bfin_read16(CAN0_MB30_ID1)
#define bfin_write_CAN0_MB30_ID1(val)		bfin_write16(CAN0_MB30_ID1, val)
#define bfin_read_CAN0_MB31_DATA0()		bfin_read16(CAN0_MB31_DATA0)
#define bfin_write_CAN0_MB31_DATA0(val)		bfin_write16(CAN0_MB31_DATA0, val)
#define bfin_read_CAN0_MB31_DATA1()		bfin_read16(CAN0_MB31_DATA1)
#define bfin_write_CAN0_MB31_DATA1(val)		bfin_write16(CAN0_MB31_DATA1, val)
#define bfin_read_CAN0_MB31_DATA2()		bfin_read16(CAN0_MB31_DATA2)
#define bfin_write_CAN0_MB31_DATA2(val)		bfin_write16(CAN0_MB31_DATA2, val)
#define bfin_read_CAN0_MB31_DATA3()		bfin_read16(CAN0_MB31_DATA3)
#define bfin_write_CAN0_MB31_DATA3(val)		bfin_write16(CAN0_MB31_DATA3, val)
#define bfin_read_CAN0_MB31_LENGTH()		bfin_read16(CAN0_MB31_LENGTH)
#define bfin_write_CAN0_MB31_LENGTH(val)	bfin_write16(CAN0_MB31_LENGTH, val)
#define bfin_read_CAN0_MB31_TIMESTAMP()		bfin_read16(CAN0_MB31_TIMESTAMP)
#define bfin_write_CAN0_MB31_TIMESTAMP(val)	bfin_write16(CAN0_MB31_TIMESTAMP, val)
#define bfin_read_CAN0_MB31_ID0()		bfin_read16(CAN0_MB31_ID0)
#define bfin_write_CAN0_MB31_ID0(val)		bfin_write16(CAN0_MB31_ID0, val)
#define bfin_read_CAN0_MB31_ID1()		bfin_read16(CAN0_MB31_ID1)
#define bfin_write_CAN0_MB31_ID1(val)		bfin_write16(CAN0_MB31_ID1, val)

/* Counter Registers */

#define bfin_read_CNT_CONFIG()		bfin_read16(CNT_CONFIG)
#define bfin_write_CNT_CONFIG(val)	bfin_write16(CNT_CONFIG, val)
#define bfin_read_CNT_IMASK()		bfin_read16(CNT_IMASK)
#define bfin_write_CNT_IMASK(val)	bfin_write16(CNT_IMASK, val)
#define bfin_read_CNT_STATUS()		bfin_read16(CNT_STATUS)
#define bfin_write_CNT_STATUS(val)	bfin_write16(CNT_STATUS, val)
#define bfin_read_CNT_COMMAND()		bfin_read16(CNT_COMMAND)
#define bfin_write_CNT_COMMAND(val)	bfin_write16(CNT_COMMAND, val)
#define bfin_read_CNT_DEBOUNCE()	bfin_read16(CNT_DEBOUNCE)
#define bfin_write_CNT_DEBOUNCE(val)	bfin_write16(CNT_DEBOUNCE, val)
#define bfin_read_CNT_COUNTER()		bfin_read32(CNT_COUNTER)
#define bfin_write_CNT_COUNTER(val)	bfin_write32(CNT_COUNTER, val)
#define bfin_read_CNT_MAX()		bfin_read32(CNT_MAX)
#define bfin_write_CNT_MAX(val)		bfin_write32(CNT_MAX, val)
#define bfin_read_CNT_MIN()		bfin_read32(CNT_MIN)
#define bfin_write_CNT_MIN(val)		bfin_write32(CNT_MIN, val)

/* RSI Register */
#define bfin_read_RSI_CLK_CTL()		bfin_read16(RSI_CLK_CONTROL)
#define bfin_write_RSI_CLK_CTL(val)	bfin_write16(RSI_CLK_CONTROL, val)
#define bfin_read_RSI_ARGUMENT()	bfin_read32(RSI_ARGUMENT)
#define bfin_write_RSI_ARGUMENT(val)	bfin_write32(RSI_ARGUMENT, val)
#define bfin_read_RSI_COMMAND()		bfin_read16(RSI_COMMAND)
#define bfin_write_RSI_COMMAND(val)	bfin_write16(RSI_COMMAND, val)
#define bfin_read_RSI_RESP_CMD()	bfin_read16(RSI_RESP_CMD)
#define bfin_write_RSI_RESP_CMD(val)	bfin_write16(RSI_RESP_CMD, val)
#define bfin_read_RSI_RESPONSE0()	bfin_read32(RSI_RESPONSE0)
#define bfin_write_RSI_RESPONSE0(val)	bfin_write32(RSI_RESPONSE0, val)
#define bfin_read_RSI_RESPONSE1()	bfin_read32(RSI_RESPONSE1)
#define bfin_write_RSI_RESPONSE1(val)	bfin_write32(RSI_RESPONSE1, val)
#define bfin_read_RSI_RESPONSE2()	bfin_read32(RSI_RESPONSE2)
#define bfin_write_RSI_RESPONSE2(val)	bfin_write32(RSI_RESPONSE2, val)
#define bfin_read_RSI_RESPONSE3()	bfin_read32(RSI_RESPONSE3)
#define bfin_write_RSI_RESPONSE3(val)	bfin_write32(RSI_RESPONSE3, val)
#define bfin_read_RSI_DATA_TIMER()	bfin_read32(RSI_DATA_TIMER)
#define bfin_write_RSI_DATA_TIMER(val)	bfin_write32(RSI_DATA_TIMER, val)
#define bfin_read_RSI_DATA_LGTH()	bfin_read16(RSI_DATA_LGTH)
#define bfin_write_RSI_DATA_LGTH(val)	bfin_write16(RSI_DATA_LGTH, val)
#define bfin_read_RSI_DATA_CTL()	bfin_read16(RSI_DATA_CONTROL)
#define bfin_write_RSI_DATA_CTL(val)	bfin_write16(RSI_DATA_CONTROL, val)
#define bfin_read_RSI_DATA_CNT()	bfin_read16(RSI_DATA_CNT)
#define bfin_write_RSI_DATA_CNT(val)	bfin_write16(RSI_DATA_CNT, val)
#define bfin_read_RSI_STATUS()		bfin_read32(RSI_STATUS)
#define bfin_write_RSI_STATUS(val)	bfin_write32(RSI_STATUS, val)
#define bfin_read_RSI_STATUS_CLR()	bfin_read16(RSI_STATUSCL)
#define bfin_write_RSI_STATUS_CLR(val)	bfin_write16(RSI_STATUSCL, val)
#define bfin_read_RSI_MASK0()		bfin_read32(RSI_MASK0)
#define bfin_write_RSI_MASK0(val)	bfin_write32(RSI_MASK0, val)
#define bfin_read_RSI_MASK1()		bfin_read32(RSI_MASK1)
#define bfin_write_RSI_MASK1(val)	bfin_write32(RSI_MASK1, val)
#define bfin_read_RSI_FIFO_CNT()	bfin_read16(RSI_FIFO_CNT)
#define bfin_write_RSI_FIFO_CNT(val)	bfin_write16(RSI_FIFO_CNT, val)
#define bfin_read_RSI_CEATA_CONTROL()	bfin_read16(RSI_CEATA_CONTROL)
#define bfin_write_RSI_CEATA_CONTROL(val)	bfin_write16(RSI_CEATA_CONTROL, val)
#define bfin_read_RSI_BLKSZ()		bfin_read16(RSI_BLKSZ)
#define bfin_write_RSI_BLKSZ(val)	bfin_write16(RSI_BLKSZ, val)
#define bfin_read_RSI_FIFO()		bfin_read32(RSI_FIFO)
#define bfin_write_RSI_FIFO(val)	bfin_write32(RSI_FIFO, val)
#define bfin_read_RSI_E_STATUS()	bfin_read32(RSI_ESTAT)
#define bfin_write_RSI_E_STATUS(val)	bfin_write32(RSI_ESTAT, val)
#define bfin_read_RSI_E_MASK()		bfin_read32(RSI_EMASK)
#define bfin_write_RSI_E_MASK(val)	bfin_write32(RSI_EMASK, val)
#define bfin_read_RSI_CFG()		bfin_read16(RSI_CONFIG)
#define bfin_write_RSI_CFG(val)		bfin_write16(RSI_CONFIG, val)
#define bfin_read_RSI_RD_WAIT_EN()	bfin_read16(RSI_RD_WAIT_EN)
#define bfin_write_RSI_RD_WAIT_EN(val)	bfin_write16(RSI_RD_WAIT_EN, val)
#define bfin_read_RSI_PID0()		bfin_read16(RSI_PID0)
#define bfin_write_RSI_PID0(val)	bfin_write16(RSI_PID0, val)
#define bfin_read_RSI_PID1()		bfin_read16(RSI_PID1)
#define bfin_write_RSI_PID1(val)	bfin_write16(RSI_PID1, val)
#define bfin_read_RSI_PID2()		bfin_read16(RSI_PID2)
#define bfin_write_RSI_PID2(val)	bfin_write16(RSI_PID2, val)
#define bfin_read_RSI_PID3()		bfin_read16(RSI_PID3)
#define bfin_write_RSI_PID3(val)	bfin_write16(RSI_PID3, val)

/* usb register */
#define bfin_read_USB_PLLOSC_CTRL()    bfin_read16(USB_PLL_OSC)
#define bfin_write_USB_PLLOSC_CTRL(val) bfin_write16(USB_PLL_OSC, val)
#define bfin_write_USB_VBUS_CTL(val) bfin_write8(USB_VBUS_CTL, val)
#define bfin_write_USB_APHY_CNTRL(val) bfin_write8(USB_PHY_CTL, val)
#define bfin_read_USB_APHY_CNTRL() bfin_read8(USB_PHY_CTL)

#endif /* _CDEF_BF60X_H */

