/* 
 *    Imagine for use with the Onyx (PCX-U) CPU interface 
 *
 *    Copyright (C) 2001 Randolph Chung <tausq at parisc-linux.org>
 *    Copyright (C) 2001 Hewlett-Packard (Grant Grundler)
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
#ifndef PERF_IMAGES_H
#define PERF_IMAGES_H

/* Magic numbers taken without modification from HPUX stuff */

#define PCXU_IMAGE_SIZE 584

static uint32_t onyx_images[][PCXU_IMAGE_SIZE/sizeof(uint32_t)] = {
/*
 * CPI:
 *
 * Counts the following:
 *
 * ctr0 : total cycles
 * ctr1 : total cycles where nothing retired
 * ctr2 : total instructions retired, including nullified
 * ctr3 : total instructions retired, less nullified instructions
 */
         {
         0x4c00c000, 0x00000000, 0x00060000, 0x00000000,
         0xe0e0e0e0, 0x004e0004, 0x07ffffff, 0xffc01380,
         0x0101ffff, 0xfffff104, 0xe000c07f, 0xfffffffc,
         0x01380010, 0x1fffffff, 0xff000000, 0x00000000,
         0x00000fff, 0xff00000f, 0xffff0000, 0x0fffff00,
         0x000fffff, 0x00000000, 0x00000000, 0x00ffffff,
         0xfffff000, 0x0000000f, 0xffffffff, 0xff000000,
         0x0000ffff, 0xfffffff0, 0x00000000, 0x0fffffff,
         0xffff0000, 0x00000000, 0x6fffffff, 0xffffffff,
         0xfff55fff, 0xffffffff, 0xffffffff, 0xf0000000,
         0xf0000030, 0x00003c00, 0x067f080c, 0x02019fc0,
         0x02804067, 0xf0009030, 0x19fc002c, 0x40067f08,
         0x0c12019f, 0xc0028440, 0x67f00091, 0x3019fc00,
         0x2fc007ff, 0xf800f001, 0xfffe003c, 0x007fff80,
         0x0f001fff, 0xe003c007, 0xfff800f0, 0x01fffe00,
         0x3c007fff, 0x800f001f, 0xffe003c0, 0x07fff800,
         0xf001fffe, 0x003c007f, 0xff800f00, 0x1fffe003,
         0xc007fff8, 0x00f001ff, 0xfe003c00, 0x7fff800f,
         0x001fffe0, 0x03c007ff, 0xf800f001, 0xfffe003c,
         0x007fff80, 0x0f001fff, 0xe003c007, 0xfff800f0,
         0x01fffe00, 0x3c007fff, 0x800f001f, 0xffe00000,
         0x00000000, 0x00000000, 0x00000000, 0x00000000,
         0x6fff0000, 0x00000000, 0x60000000, 0x00000000,
         0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
         0xfffffc00, 0x00000000, 0xffffffff, 0xffffffff,
         0xffffffff, 0xffffffff, 0xfffffc00, 0x00000000,
         0xffffaaaa, 0xffffffff, 0xf3ffffff, 0xffffffff,
         0xfdffffff, 0xffffffff, 0xfe000000, 0x00000000,
         0xffffaaaa, 0xffffffff, 0xf3ffffff, 0xffffffff,
         0xfdffffff, 0xffffffff, 0xfe000000, 0x00000000,
         0xffffffff, 0xfffff9ff, 0xfe000000, 0x00000000,
         0xffffffff, 0xfffff9ff, 0xfe000000, 0x00000000,
         0x00030000, 0x00000000, 0xffffffff, 0xffffffff,
         0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
         0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
         0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
         0xffffffff, 0xffffffff},

/* Bus utilization image (bus_util)
 *
 * ctr0 : counts address valid cycles
 * ctr1 : counts data valid cycles
 * ctr2 : counts overflow from counter 0
 * ctr3 : counts overflow from counter 1
 */
         {
         0x0c01e000, 0x00000000, 0x00060000, 0x00000000,
         0xefefefef, 0xffffffff, 0xffffffff, 0xffffffff,
         0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
         0xffffffff, 0xffffffff, 0xff000000, 0x00000000,
         0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
         0xffffffff, 0x00000000, 0xffffffff, 0xffffffff,
         0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
         0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
         0xffff0000, 0x00000000, 0xffffffff, 0xffffffff,
         0xffffffff, 0xffffffff, 0xffffffff, 0xf0000000,
         0x0000000c, 0x00003c00, 0x07930000, 0x0041e4c0,
         0x01002079, 0x3000800c, 0x1e4c0030, 0x00279300,
         0x010049e4, 0xc0014022, 0x79300090, 0x0c9e4c00,
         0x34004793, 0x00020051, 0xe4c00180, 0x24793000,
         0xa00d1e4c, 0x00380067, 0x93000300, 0x59e4c001,
         0xc0267930, 0x00b00d9e, 0x4c003fff, 0xffffffff,
         0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
         0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
         0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
         0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
         0xffffffff, 0xffffffff, 0xffffffff, 0xfffffc00,
         0x00000000, 0x00000000, 0x00000000, 0x00000000,
         0xffff0000, 0x00000000, 0xf0000000, 0x00000000,
         0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
         0xfffffc00, 0x00000000, 0xffffffff, 0xffffffff,
         0xffffffff, 0xffffffff, 0xfffffc00, 0x00000000,
         0xffffffff, 0xffffffff, 0xf3ffffff, 0xffffffff,
         0xfdffffff, 0xffffffff, 0xfe000000, 0x00000000,
         0xffffffff, 0xffffffff, 0xf3ffffff, 0xffffffff,
         0xfdffffff, 0xffffffff, 0xfe000000, 0x00000000,
         0xffffffff, 0xfffff9ff, 0xfe000000, 0x00000000,
         0xffffffff, 0xfffff9ff, 0xfe000000, 0x00000000,
         0x00100000, 0x00000000, 0xffffffff, 0xffffffff,
         0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
         0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
         0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
         0xffffffff, 0xffffffff },

/*
 * TLB counts (same as tlbStats image):
 *
 * Counts the following:
 *
 * ctr0: DTLB misses
 * ctr1: ITLB misses
 * ctr2: total cycles in the miss handlers
 * ctr3: total cycles
 */

         {
         0x0c00c000, 0x00000000, 0x00060000, 0x00000000,
         0xe7e7e0e0, 0x004e0004, 0x07ffffff, 0xffc01380,
         0x0101ffff, 0xfffff104, 0xe000c06a, 0xafffc85c,
         0x01380010, 0x1fffffff, 0xff000000, 0x00000000,
         0x01b9e000, 0x0001b8c0, 0x00000000, 0x0fffff00,
         0x000fffff, 0x00000000, 0x00000000, 0x00400000,
         0x00001000, 0x00000004, 0x00000000, 0x01000000,
         0x0000ffff, 0xfffffff0, 0x00000000, 0x0fffffff,
         0xffff0000, 0x00000000, 0x6fffffff, 0xffffffff,
         0xfff55ff5, 0xffffffff, 0xffffffff, 0xf0000000,
         0xf0000000, 0x00003c00, 0x01ff0001, 0x08007fc2,
         0x02c1001f, 0xf0807100, 0x1bfc200c, 0x4806ff00,
         0x03f001ff, 0xfe003c00, 0x7fff800f, 0x001fffe0,
         0x03c007ff, 0xf800f001, 0xfffe003c, 0x007fff80,
         0x0f001fff, 0xe003c007, 0xfff800f0, 0x01fffe00,
         0x3c007fff, 0x800f001f, 0xffe003c0, 0x07fff800,
         0xf001fffe, 0x003c007f, 0xff800f00, 0x1fffe003,
         0xc007fff8, 0x00f001ff, 0xfe003c00, 0x7fff800f,
         0x001fffe0, 0x03c007ff, 0xf800f001, 0xfffe003c,
         0x007fff80, 0x0f001fff, 0xe003c007, 0xfff800f0,
         0x01fffe00, 0x3c007fff, 0x800f001f, 0xffe00000,
         0x00000000, 0x00000000, 0x00000000, 0x00000000,
         0x6fff0000, 0x00000000, 0x60000000, 0x00000000,
         0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
         0xfffffc00, 0x00000000, 0xffffffff, 0xffffffff,
         0xffffffff, 0xffffffff, 0xfffffc00, 0x00000000,
         0xffffaaaa, 0xffffffff, 0xf3ffffff, 0xffffffff,
         0xfdffffff, 0xffffffff, 0xfe000000, 0x00000000,
         0xffffaaaa, 0xffffffff, 0xf3ffffff, 0xffffffff,
         0xfdffffff, 0xffffffff, 0xfe000000, 0x00000000,
         0xffffffff, 0xfffff9ff, 0xfe000000, 0x00000000,
         0xffffffff, 0xfffff9ff, 0xfe000000, 0x00000000,
         0x00030000, 0x00000000, 0xffffffff, 0xffffffff,
         0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
         0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
         0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
         0xffffffff, 0xffffffff },

/* tlbHandMiss
 *
 * ctr0: counts TLB misses 
 * ctr1: counts dmisses inside tlb miss handlers 
 * ctr2: counts cycles in the tlb miss handlers 
 * ctr3: counts overflows of ctr2 
 */
{
0x1c00c000,00000000,0x00060000,00000000,
0xe7e7e0e0,0x004e0004,0x07ffffff,0xffc01380,
0x0101ffff,0xfffff104,0xe000c06a,0xafffc85c,
0x01380010,0x1fffffff,0xff000000,00000000,
0x01b9e000,0x0001b8c0,00000000,0x0fffff00,
0x000fffff,00000000,00000000,0x00400000,
0x00001000,0x00000004,00000000,0x01000000,
0x0000ffff,0xfffffff0,00000000,0x0fffffff,
0xffff0000,00000000,0x6fffffff,0xffffffff,
0xfff55ff5,0xffffffff,0xffffffff,0xf0000000,
0xf0000000,0x00003c00,0x01fd0000,0x08007f42,
0x0281001f,0xd080a100,0x19f42008,0x44067d08,
0x0612019f,0x400084c0,0x67d00060,0x0047f400,
0x042011fd,0x080b0404,0x7f4202c4,0x0167d080,
0x311059f4,0x201c4816,0x7d000313,0x059f4001,
0xfc007fff,0x800f001f,0xffe003c0,0x07fff800,
0xf001fffe,0x003c007f,0xff800f00,0x1fffe003,
0xc007fff8,0x00f001ff,0xfe003c00,0x7fff800f,
0x001fffe0,0x03c007ff,0xf800f001,0xfffe003c,
0x007fff80,0x0f001fff,0xe003c007,0xfff800f0,
0x01fffe00,0x3c007fff,0x800f001f,0xffe00000,
00000000,00000000,00000000,00000000,
0x6fff0000,00000000,0x60000000,00000000,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xfffffc00,00000000,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xfffffc00,00000000,
0xffffaaaa,0xffffffff,0xf3ffffff,0xffffffff,
0xfdffffff,0xffffffff,0xfe000000,00000000,
0xffffaaaa,0xffffffff,0xf3ffffff,0xffffffff,
0xfdffffff,0xffffffff,0xfe000000,00000000,
0xffffffff,0xfffff9ff,0xfe000000,00000000,
0xffffffff,0xfffff9ff,0xfe000000,00000000,
0x00030000,00000000,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xffffffff,0xffffffff},

/* branch_taken image (ptkn image)
 *
 * ctr0: overflow for ctr1
 * ctr1: predicted taken branches, actually taken
 * ctr2: all predicted taken branches (nullfied or not)
 * ctr3: overflow for ctr2
 */

        {
        0xcc01e000, 0x00000000, 0x00060000, 0x00000000,
        0xa08080a0, 0xffffffff, 0xffffffff, 0xffffffff,
        0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
        0xffffffff, 0xffffffff, 0xff000000, 0x00000000,
        0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
        0xffffffff, 0x00000000, 0xffffffff, 0xffffffff,
        0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
        0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
        0xffff0000, 0x00000000, 0xffffffff, 0xffffffff,
        0xffffffff, 0xffffffff, 0xffffffff, 0xf0000000,
        0xf0000000, 0x00003c00, 0x04f90000, 0x02013e40,
        0x0081004f, 0x90004060, 0x13e40018, 0x0024f900,
        0x0802093e, 0x40028102, 0x4f9000c0, 0x6093e400,
        0x380014f9, 0x00010205, 0x3e4000c1, 0x014f9000,
        0x506053e4, 0x001c0034, 0xf9000902, 0x0d3e4002,
        0xc1034f90, 0x00d060d3, 0xe4003fff, 0xffffffff,
        0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
        0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
        0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
        0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
        0xffffffff, 0xffffffff, 0xffffffff, 0xfffffc00,
        0x00000000, 0x00000000, 0x00000000, 0x00000000,
        0xffff0000, 0x00000000, 0xf0000000, 0x00000000,
        0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
        0xfffffc00, 0x00000000, 0xffffffff, 0xffffffff,
        0xffffffff, 0xffffffff, 0xfffffc00, 0x00000000,
        0xffffffff, 0xffffffff, 0xf3ffffff, 0xffffffff,
        0xfdffffff, 0xffffffff, 0xfe000000, 0x00000000,
        0xffffffff, 0xffffffff, 0xf3ffffff, 0xffffffff,
        0xfdffffff, 0xffffffff, 0xfe000000, 0x00000000,
        0xffffffff, 0xfffff9ff, 0xfe000000, 0x00000000,
        0xffffffff, 0xfffff9ff, 0xfe000000, 0x00000000,
        0x00030000, 0x00000000, 0xffffffff, 0xffffffff,
        0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
        0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
        0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
        0xffffffff, 0xffffffff },

/* branch_nottaken (pntkn image)
 *
 * ctr0: overflow for ctr1
 * ctr1: counts branches predicted not-taken, but actually taken
 * ctr2: counts all predictable branches predicted not-taken
 * ctr3: overflow for ctr2
 */
{
0xcc01e000,00000000,0x00060000,00000000,
0xc0c0c0e0,0xffb1fffb,0xfff7ffff,0xffffffff,
0xffffffff,0xfffffffb,0x1fffbfff,0x7fffffff,
0xfcc7ffff,0xffdffffa,0x5f000000,00000000,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xffffffff,00000000,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xffff0000,00000000,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xffffffff,0xf0000000,
0xf0000060,0x00003c00,0x04f90000,0x02013e40,
0x0081004f,0x90004060,0x13e40018,0x0024f900,
0x0802093e,0x40028102,0x4f9000c0,0x6093e400,
0x380014f9,0x00010205,0x3e4000c1,0x014f9000,
0x506053e4,0x001c0034,0xf9000902,0x0d3e4002,
0xc1034f90,0x00d060d3,0xe4003fff,0xffffffff,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xffffffff,0xfffffc00,
00000000,00000000,00000000,00000000,
0xffff0000,00000000,0xf0000000,00000000,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xfffffc00,00000000,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xfffffc00,00000000,
0xffffffff,0xffffffff,0xf3ffffff,0xffffffff,
0xfdffffff,0xffffffff,0xfe000000,00000000,
0xffffffff,0xffffffff,0xf3ffffff,0xffffffff,
0xfdffffff,0xffffffff,0xfe000000,00000000,
0xffffffff,0xfffff9ff,0xfe000000,00000000,
0xffffffff,0xfffff9ff,0xfe000000,00000000,
0x00030000,00000000,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xffffffff,0xffffffff},


/* imiss image
 *
 * ctr0 : counts imiss aligned on 0
 * ctr1 : counts imiss aligned on 4
 * ctr2 : counts imiss aligned on 8
 * ctr3 : counts imiss aligned on C
 */
         {
         0x0c00c000, 0x00000000, 0x00010000, 0x00000000,
         0xe7ebedee, 0xffffffff, 0xffffffff, 0xffffffff,
         0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
         0xffffffff, 0xffffffff, 0xff000000, 0x00000000,
         0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
         0xffffffff, 0x00000000, 0xffffffff, 0xffffffff,
         0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
         0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
         0xffff0000, 0x00000000, 0x6fffffff, 0xffffffff,
         0xfff55fff, 0xffffffff, 0xffffffff, 0xf0000000,
         0xf0000000, 0x00003c00, 0x007f0000, 0x01001fc0,
         0x00408007, 0xf0002030, 0x01fc000c, 0x10007f00,
         0x0405001f, 0xc0014180, 0x07f00060, 0x7001fc00,
         0x1c20007f, 0x00080900, 0x1fc00242, 0x8007f000,
         0xa0b001fc, 0x002c3000, 0x7f000c0d, 0x001fc003,
         0x438007f0, 0x00e0f001, 0xfc003fff, 0xfffff800,
         0xfffffffe, 0x003fffff, 0xff800fff, 0xffffe003,
         0xfffffff8, 0x00ffffff, 0xfe003fff, 0xffff800f,
         0xffffffe0, 0x03ffffff, 0xf800ffff, 0xfffe003f,
         0xffffff80, 0x0fffffff, 0xe003ffff, 0xfff800ff,
         0xfffffe00, 0x3fffffff, 0x800fffff, 0xffe00000,
         0x00000000, 0x00000000, 0x00000000, 0x00000000,
         0x6fff0000, 0x00000000, 0x60000000, 0x00000000,
         0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
         0xfffffc00, 0x00000000, 0xffffffff, 0xffffffff,
         0xffffffff, 0xffffffff, 0xfffffc00, 0x00000000,
         0xffffaaaa, 0xffffffff, 0xf3ffffff, 0xffffffff,
         0xfdffffff, 0xffffffff, 0xfe000000, 0x00000000,
         0xffffaaaa, 0xffffffff, 0xf3ffffff, 0xffffffff,
         0xfdffffff, 0xffffffff, 0xfe000000, 0x00000000,
         0xffffffff, 0xfffff9ff, 0xfe000000, 0x00000000,
         0xffffffff, 0xfffff9ff, 0xfe000000, 0x00000000,
         0x00030000, 0x00000000, 0xffffffff, 0xffffffff,
         0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
         0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
         0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
         0xffffffff, 0xffffffff},

/* dmiss image
 * 
 * ctr0 : counts cycles
 * ctr1 : counts cycles where something retired
 * ctr2 : counts dmisses
 * ctr3 : (same as ctr2)
 */
         {
         0x3c00c000, 0x00000000, 0x00060000, 0x00000000,
         0xe0e0e0e0, 0xffffffff, 0xffffffff, 0xffffffff,
         0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
         0xffffffff, 0xffffffff, 0xff000000, 0x00000000,
         0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
         0xffffffff, 0x00000000, 0xffffffff, 0xffffffff,
         0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
         0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
         0xffff0000, 0x00000000, 0x6fffffff, 0xffffffff,
         0xffffffff, 0xffffffff, 0xffffffff, 0xf0000000,
         0xf0000000, 0x00003c04, 0x007f0009, 0x02001fc0,
         0x0280c007, 0xf000b040, 0x01fc0030, 0x14007f00,
         0x0d06001f, 0xc00381c0, 0x07f000f0, 0x8001fc00,
         0x2024007f, 0x00090a00, 0x1fc00282, 0xc007f000,
         0xb0c001fc, 0x00303400, 0x7f000d0e, 0x001fc003,
         0x83c007f0, 0x00f00001, 0xfc0023ff, 0xfffff800,
         0xfffffffe, 0x003fffff, 0xff800fff, 0xffffe003,
         0xfffffff8, 0x00ffffff, 0xfe003fff, 0xffff800f,
         0xffffffe0, 0x03ffffff, 0xf800ffff, 0xfffe003f,
         0xffffff80, 0x0fffffff, 0xe003ffff, 0xfff800ff,
         0xfffffe00, 0x3fffffff, 0x800fffff, 0xffe00000,
         0x00000000, 0x00000000, 0x00000000, 0x00000000,
         0x6fff0000, 0x00000000, 0x60000000, 0x00000000,
         0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
         0xfffffc00, 0x00000000, 0xffffffff, 0xffffffff,
         0xffffffff, 0xffffffff, 0xfffffc00, 0x00000000,
         0xffffaaaa, 0xffffffff, 0xf3ffffff, 0xffffffff,
         0xfdffffff, 0xffffffff, 0xfe000000, 0x00000000,
         0xffffaaaa, 0xffffffff, 0xf3ffffff, 0xffffffff,
         0xfdffffff, 0xffffffff, 0xfe000000, 0x00000000,
         0xffffffff, 0xfffff9ff, 0xfe000000, 0x00000000,
         0xffffffff, 0xfffff9ff, 0xfe000000, 0x00000000,
         0x00030000, 0x00000000, 0xffffffff, 0xffffffff,
         0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
         0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
         0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
         0xffffffff, 0xffffffff },

/* dcmiss 
 *
 * ctr0: counts store instructions retired 
 * ctr1: counts load instructions retired
 * ctr2: counts dmisses 
 * ctr3: counts READ_SHARED_OR_PRIV and READ_PRIVATE transactions on Runway 
 */
{
0x2c90c000,00000000,0x00060000,00000000,
0xe0e0e0e0,0xffffffff,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xff000000,00000000,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xffffffff,00000000,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xffff0000,00000000,0x6fffffff,0xffffffff,
0xffffffff,0xffffffff,0xffffffff,0xf0000000,
0xf00000e8,0x00003c02,0x00bf0001,0x02002fc0,
0x0080a00b,0xf0003040,0x02fc0010,0x1200bf00,
0x0506002f,0xc00181a0,0x0bf00070,0x8002fc00,
0x202200bf,0x00090a00,0x2fc00282,0xa00bf000,
0xb0c002fc,0x00303200,0xbf000d0e,0x002fc003,
0x83a00bf0,0x00ffffff,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xffffffff,0xfffffc00,
00000000,00000000,00000000,00000000,
0x6fff0000,00000000,0x60000000,00000000,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xfffffc00,00000000,0x55555555,0xd5555555,
0x55555555,0x75555555,0x5e1ffc00,00000000,
0xffffffff,0xffffffff,0xf3ffffff,0xffffffff,
0xfdffffff,0xffffffff,0xfe000000,00000000,
0xffffffff,0xffffffff,0xf3ffffff,0xffffffff,
0xfdffffff,0xffffffff,0xfe000000,00000000,
0xffffffff,0xfffff9ff,0xfe000000,00000000,
0xffffffff,0xfffff9ff,0xfe000000,00000000,
0x00100000,00000000,0xf8000000,00000000,
00000000,00000000,0xf4000000,00000000,
0xffffffff,0xffffffff,0x00ffffff,0xffffffff,
00000000,00000000,0x00ffffff,0xffffffff,
0xffffffff,0xffffffff },

/* big_cpi
 *
 * ctr0: counts total cycles 
 * ctr1: counts overflows of ctr0 (for greater than 32-bit values) 
 * ctr2: counts overflows of ctr3 (for greater than 32-bit values) 
 * ctr3: counts unnullified instructions retired 
 */
{
0x0c00c000,00000000,0x00060000,00000000,
0xe7e7e0e0,0x004e0004,0x07ffffff,0xffc01380,
0x0101ffff,0xfffff104,0xe000c06a,0xafffc85c,
0x01380010,0x1fffffff,0xff000000,00000000,
0x01b9e000,0x0001b8c0,00000000,0x0fffff00,
0x000fffff,00000000,00000000,0x00400000,
0x00001000,0x00000004,00000000,0x01000000,
0x0000ffff,0xfffffff0,00000000,0x0fffffff,
0xffff0000,00000000,0x6fffffff,0xffffffff,
0xfff55ff5,0xffffffff,0xffffffff,0xf0000000,
0xf0000010,0x00003c00,0x01760008,0x00025d80,
0x02800417,0x6000c001,0x25d80038,0x04017600,
0x0901025d,0x8002c044,0x176000d0,0x1125d800,
0x3c2001f6,0x08080400,0x7d820203,0x001f6080,
0x804027d8,0x20282009,0xf6080a0c,0x027d8202,
0x81041f60,0x80c08107,0xd8203030,0x41f6080c,
0x04127d82,0x0382049f,0x6080e0c1,0x27d82038,
0x4006f608,0x081011bd,0x82030400,0xef6080a1,
0x013bd820,0x384806f6,0x00081211,0xbd800304,
0x80ef6000,0xa1213bd8,0x003bc007,0xfff800f0,
0x01fffe00,0x3c007fff,0x800f001f,0xffe00000,
00000000,00000000,00000000,00000000,
0x6fff0000,00000000,0x60000000,00000000,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xfffffc00,00000000,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xfffffc00,00000000,
0xffffaaaa,0xffffffff,0xf3ffffff,0xffffffff,
0xfdffffff,0xffffffff,0xfe000000,00000000,
0xffffaaaa,0xffffffff,0xf3ffffff,0xffffffff,
0xfdffffff,0xffffffff,0xfe000000,00000000,
0xffffffff,0xfffff9ff,0xfe000000,00000000,
0xffffffff,0xfffff9ff,0xfe000000,00000000,
0x00030000,00000000,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xffffffff,0xffffffff },

/* big_ls
 *
 * ctr0:counts the total number of cycles for which local_stall_A1 is asserted. 
 * ctr1: is the overflow for counter 0. 
 * ctr2: counts IFLUSH_AV 
 * ctr3: is the overflow for counter 2. 
 */
{
0x0c000000,00000000,0x00060000,00000000,
0xefefefef,0xffffffff,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xff000000,00000000,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xffffffff,00000000,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xffff0000,00000000,0x0fffffff,0xffffffff,
0xffffffff,0xffffffff,0xffffffff,0xf0000000,
00000000,0x00029408,0x02f50002,0x0800bd40,
0x0202802f,0x5000a000,0x4bd40004,0x0812f500,
0x030804bd,0x40024281,0x2f5000b0,0x010bd400,
0x100842f5,0x00060810,0xbd400302,0x842f5000,
0xe0014bd4,0x00140852,0xf5000708,0x14bd4003,
0x42852f50,0x00ff001f,0xffe003c0,0x07fff800,
0xf001fffe,0x003c007f,0xff800f00,0x1fffe003,
0xc007fff8,0x00f001ff,0xfe003c00,0x7fff800f,
0x001fffe0,0x03c007ff,0xf800f001,0xfffe003c,
0x007fff80,0x0f001fff,0xe003c007,0xfff800f0,
0x01fffe00,0x3c007fff,0x800f001f,0xffe00000,
00000000,00000000,00000000,00000000,
0x0df70000,00000000,00000000,00000000,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xfffffc00,00000000,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xfffffc00,00000000,
0xffffffff,0xffffffff,0xf3ffffff,0xffffffff,
0xfdffffff,0xffffffff,0xfe000000,00000000,
0xffffffff,0xffffffff,0xf3ffffff,0xffffffff,
0xfdffffff,0xffffffff,0xfe000000,00000000,
0xffffffff,0xfffff9ff,0xfe000000,00000000,
0xffffffff,0xfffff9ff,0xfe000000,00000000,
0x00030000,00000000,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xffffffff,0xffffffff },

/* br_abort
 *
 * ctr0: counts BRAD_STALLH 
 * ctr1: counts ONE_QUAD 
 * ctr2: counts BR0_ABRT 
 * ctr3: counts BR1_ABRT
 */
{
0x0c002000,00000000,0x00060000,00000000,
0xe0e0e0e0,0xffffffff,0xffffffff,0xffffffff,
0xffffffff,0xffa5ffff,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xff000000,00000000,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xffffffff,00000000,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xffff0000,00000000,0x1fffffff,0xffffffff,
0xfff7fff7,0xffffffff,0xffffffff,0xf0000000,
00000000,0x0003f800,0x007f000e,0x01001fc0,
0x03c08007,0xf000c030,0x01fc0034,0x10007f00,
0x0a05001f,0xc002c180,0x07f00080,0x7001fc00,
0x2420007f,0x00060900,0x1fc001c2,0x8007f000,
0x40b001fc,0x00143000,0x7f00020d,0x001fc000,
0xc38007f0,0x0000f001,0xfc0007ff,0xfffff800,
0xfffffffe,0x003fffff,0xff800fff,0xffffe003,
0xfffffff8,0x00ffffff,0xfe003fff,0xffff800f,
0xffffffe0,0x03ffffff,0xf800ffff,0xfffe003f,
0xffffff80,0x0fffffff,0xe003ffff,0xfff800ff,
0xfffffe00,0x3fffffff,0x800fffff,0xffe00000,
00000000,00000000,00000000,00000000,
0x1a250000,00000000,0x10000000,00000000,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xfffffc00,00000000,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xfffffc00,00000000,
0xffffaaaa,0xffffffff,0xf3ffffff,0xffffffff,
0xfdffffff,0xffffffff,0xfe000000,00000000,
0xffffaaaa,0xffffffff,0xf3ffffff,0xffffffff,
0xfdffffff,0xffffffff,0xfe000000,00000000,
0xffffffff,0xfffff9ff,0xfe000000,00000000,
0xffffffff,0xfffff9ff,0xfe000000,00000000,
0x00030000,00000000,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xffffffff,0xffffffff},

/* isnt
 *
 * ctr0: counts the total number of cycles for which iside_notrans is asserted 
 * ctr1: counts the number of times iside_notrans is asserted for 1-4 cycles 
 * ctr2: counts the number of times iside_notrans is asserted for 5-7 cycles 
 * ctr3: counts the number of times iside_notrans is asserted for > 7 cycles 
 */
{
0x0c018000,00000000,0x00060000,00000000,
0xefefefef,0xffffffff,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xff000000,00000000,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xffffffff,00000000,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xffff0000,00000000,0xcfffffff,0xffffffff,
0xffffffff,0xffffffff,0xffffffff,0xf0000000,
00000000,0x00021c20,0x03ff0808,0x1800ffc4,
0x0204003f,0xf0004280,0x0ffc6020,0x8003ff00,
0x043800ff,0xc8020c00,0x3ff00044,0x800ffca0,
0x210003ff,0x00045800,0xffcc0214,0x003ff000,
0x26800ffc,0xe0218003,0xff000278,0x00ffd002,
0x1c003ff0,0x0028800f,0xfd002200,0x03ff0001,
0xf001fffe,0x003c007f,0xff800f00,0x1fffe003,
0xc007fff8,0x00f001ff,0xfe003c00,0x7fff800f,
0x001fffe0,0x03c007ff,0xf800f001,0xfffe003c,
0x007fff80,0x0f001fff,0xe003c007,0xfff800f0,
0x01fffe00,0x3c007fff,0x800f001f,0xffe00000,
00000000,00000000,00000000,00000000,
0xcdff0000,00000000,0xc0000000,00000000,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xfffffc00,00000000,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xfffffc00,00000000,
0xffffffff,0xffffffff,0xf3ffffff,0xffffffff,
0xfdffffff,0xffffffff,0xfe000000,00000000,
0xffffffff,0xffffffff,0xf3ffffff,0xffffffff,
0xfdffffff,0xffffffff,0xfe000000,00000000,
0xffffffff,0xfffff9ff,0xfe000000,00000000,
0xffffffff,0xfffff9ff,0xfe000000,00000000,
0x00030000,00000000,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xffffffff,0xffffffff},

/* quadrant
 *
 * ctr0: Total number of instructions in quadrant 0 
 * ctr1: Total number of instructions in quadrant 1 
 * ctr2: Total number of instructions in quadrant 2 
 * ctr3: Total number of instructions in quadrant 3 
 * Works only with 32-bit
 */

   {
   0x0c01e000,   0x00000000,   0x00060000,   0x00000000,
   0xe0e0e0e0,   0x004e0004,   0x07ffffff,   0xffc01380,
   0x0101ffff,   0xfffff004,   0xe000407f,   0xfffffffc,
   0x01380010,   0x1fffffff,   0xff000000,   0x00000000,
   0x00000fff,   0xff00000f,   0xffff0000,   0x0fffff00,
   0x000fffff,   0x00000000,   0x00000000,   0x00ffffff,
   0xffcff000,   0x0000040f,   0xfffffffc,   0xff000000,
   0x0080ffff,   0xffffcff0,   0x0000000c,   0x0fffffff,
   0xfcff0000,   0x00000000,   0xffffffff,   0xffffffff,
   0xfff55ff5,   0x5fffffff,   0xffffffff,   0xf0000000,
   0xf00000f0,   0x00003c00,   0x007f0000,   0x01001fc0,
   0x00408007,   0xf0002030,   0x01fc000c,   0x10007f00,
   0x0405001f,   0xc0014180,   0x07f00060,   0x7001fc00,
   0x1c20007f,   0x00080900,   0x1fc00242,   0x8007f000,
   0xa0b001fc,   0x002c3000,   0x7f000c0d,   0x001fc003,
   0x438007f0,   0x00e0f001,   0xfc003fff,   0xffffffff,
   0xffffffff,   0xffffffff,   0xffffffff,   0xffffffff,
   0xffffffff,   0xffffffff,   0xffffffff,   0xffffffff,
   0xffffffff,   0xffffffff,   0xffffffff,   0xffffffff,
   0xffffffff,   0xffffffff,   0xffffffff,   0xffffffff,
   0xffffffff,   0xffffffff,   0xffffffff,   0xfffffc00,
   0x00000000,   0x00000000,   0x00000000,   0x00000000,
   0xffff0000,   0x00000000,   0xf0000000,   0x00000000,
   0xffffffff,   0xffffffff,   0xffffffff,   0xffffffff,
   0xfffffc00,   0x00000000,   0xffffffff,   0xffffffff,
   0xffffffff,   0xffffffff,   0xfffffc00,   0x00000000,
   0xffffffff,   0xffffffff,   0xf3ffffff,   0xffffffff,
   0xfdffffff,   0xffffffff,   0xfe000000,   0x00000000,
   0xffffffff,   0xffffffff,   0xf3ffffff,   0xffffffff,
   0xfdffffff,   0xffffffff,   0xfe000000,   0x00000000,
   0xffffffff,   0xfffff9ff,   0xfe000000,   0x00000000,
   0xffffffff,   0xfffff9ff,   0xfe000000,   0x00000000,
   0x00030000,   0x00000000,   0xffffffff,   0xffffffff,
   0xffffffff,   0xffffffff,   0xffffffff,   0xffffffff,
   0xffffffff,   0xffffffff,   0xffffffff,   0xffffffff,
   0xffffffff,   0xffffffff,   0xffffffff,   0xffffffff,
   0xffffffff,   0xffffffff},

/* rw_pdfet (READ_PRIV transactions)
 *
 * ctr0: counts address valid cycles 
 * ctr1: counts *all* data valid cycles 
 * ctr2: is the overflow from counter 0 
 * ctr3: is the overflow from counter 1 
 */
{
0x0c01e000,00000000,0x00060000,00000000,
0xefefefef,0xffffffff,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xff000000,00000000,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xffffffff,00000000,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xffff0000,00000000,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xffffffff,0xf0000000,
0x0000000c,0x00003c00,0x07930000,0x0041e4c0,
0x01002079,0x3000800c,0x1e4c0030,0x00279300,
0x010049e4,0xc0014022,0x79300090,0x0c9e4c00,
0x34004793,0x00020051,0xe4c00180,0x24793000,
0xa00d1e4c,0x00380067,0x93000300,0x59e4c001,
0xc0267930,0x00b00d9e,0x4c003fff,0xffffffff,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xffffffff,0xfffffc00,
00000000,00000000,00000000,00000000,
0xffff0000,00000000,0xf0000000,00000000,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xfffffc00,00000000,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xfffffc00,00000000,
0xffffffff,0xffffffff,0xf3ffffff,0xffffffff,
0xfdffffff,0xffffffff,0xfe000000,00000000,
0xffffffff,0xffffffff,0xf3ffffff,0xffffffff,
0xfdffffff,0xffffffff,0xfe000000,00000000,
0xffffffff,0xfffff9ff,0xfe000000,00000000,
0xffffffff,0xfffff9ff,0xfe000000,00000000,
0x00100000,00000000,0xf8000000,00000000,
00000000,00000000,00000000,00000000,
0xffffffff,0xffffffff,0x00ffffff,0xffffffff,
00000000,00000000,00000000,00000000,
0xffffffff,0xffffffff},

/* rw_wdfet (WRITEBACKS)
 *
 * ctr0: counts address valid cycles 
 * ctr1: counts *all* data valid cycles 
 * ctr2: is the overflow from counter 0 
 * ctr3: is the overflow from counter 1
 */
{
0x0c01e000,00000000,0x00060000,00000000,
0xefefefef,0xffffffff,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xff000000,00000000,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xffffffff,00000000,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xffff0000,00000000,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xffffffff,0xf0000000,
0x0000000c,0x00003c00,0x07930000,0x0041e4c0,
0x01002079,0x3000800c,0x1e4c0030,0x00279300,
0x010049e4,0xc0014022,0x79300090,0x0c9e4c00,
0x34004793,0x00020051,0xe4c00180,0x24793000,
0xa00d1e4c,0x00380067,0x93000300,0x59e4c001,
0xc0267930,0x00b00d9e,0x4c003fff,0xffffffff,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xffffffff,0xfffffc00,
00000000,00000000,00000000,00000000,
0xffff0000,00000000,0xf0000000,00000000,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xfffffc00,00000000,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xfffffc00,00000000,
0xffffffff,0xffffffff,0xf3ffffff,0xffffffff,
0xfdffffff,0xffffffff,0xfe000000,00000000,
0xffffffff,0xffffffff,0xf3ffffff,0xffffffff,
0xfdffffff,0xffffffff,0xfe000000,00000000,
0xffffffff,0xfffff9ff,0xfe000000,00000000,
0xffffffff,0xfffff9ff,0xfe000000,00000000,
0x00100000,00000000,0x98000000,00000000,
00000000,00000000,00000000,00000000,
0xffffffff,0xffffffff,0x00ffffff,0xffffffff,
00000000,00000000,00000000,00000000,
0xffffffff,0xffffffff},

/* shlib_cpi
 *
 * ctr0: Total number of instructions in quad 0 
 * ctr1: Total number of CPU clock cycles in quad 0 
 * ctr2: total instructions without nullified   
 * ctr3: total number of CPU clock cycles 
 */
   {
   0x0c01e000,   0x00000000,   0x00060000,   0x00000000,
   0xe0e0e0e0,   0x004e0004,   0x07ffffff,   0xffc01380,
   0x0101ffff,   0xfffff004,   0xe000407f,   0xfffffffc,
   0x01380010,   0x1fffffff,   0xff000000,   0x00000000,
   0x00000fff,   0xff00000f,   0xffffffff,   0xffffffff,
   0xffffffff,   0x00000000,   0x00000000,   0x00ffffff,
   0xffcff000,   0x0000000f,   0xfffffffc,   0xffffffff,
   0xffffffff,   0xffffffff,   0xffffffff,   0xffffffff,
   0xffff0000,   0x00000000,   0xffffffff,   0xffffffff,
   0xfff77ff5,   0x7fffffff,   0xffffffff,   0xf0000000,
   0xf00000a0,   0x00003c00,   0x01ff0005,   0x08007fc0,
   0x03c1001f,   0xf08030c0,   0x07fc203c,   0x4001ff08,
   0x0118007f,   0xc003c500,   0x1ff08031,   0xc007fc00,
   0x3fffffff,   0xf800ffff,   0xfffe003f,   0xffffff80,
   0x0fffffff,   0xe003ffff,   0xfff800ff,   0xfffffe00,
   0x3fffffff,   0x800fffff,   0xffe003ff,   0xfffff800,
   0xfffffffe,   0x003fffff,   0xff800fff,   0xffffe003,
   0xfffffff8,   0x00ffffff,   0xfe003fff,   0xffff800f,
   0xffffffe0,   0x03ffffff,   0xf800ffff,   0xfffe003f,
   0xffffff80,   0x0fffffff,   0xe003ffff,   0xfff800ff,
   0xfffffe00,   0x3fffffff,   0x800fffff,   0xffe00000,
   0x00000000,   0x00000000,   0x00000000,   0x00000000,
   0xffff0000,   0x00000000,   0xf0000000,   0x00000000,
   0xffffffff,   0xffffffff,   0xffffffff,   0xffffffff,
   0xfffffc00,   0x00000000,   0xffffffff,   0xffffffff,
   0xffffffff,   0xffffffff,   0xfffffc00,   0x00000000,
   0xffffffff,   0xffffffff,   0xf3ffffff,   0xffffffff,
   0xfdffffff,   0xffffffff,   0xfe000000,   0x00000000,
   0xffffffff,   0xffffffff,   0xf3ffffff,   0xffffffff,
   0xfdffffff,   0xffffffff,   0xfe000000,   0x00000000,
   0xffffffff,   0xfffff9ff,   0xfe000000,   0x00000000,
   0xffffffff,   0xfffff9ff,   0xfe000000,   0x00000000,
   0x00030000,   0x00000000,   0xffffffff,   0xffffffff,
   0xffffffff,   0xffffffff,   0xffffffff,   0xffffffff,
   0xffffffff,   0xffffffff,   0xffffffff,   0xffffffff,
   0xffffffff,   0xffffffff,   0xffffffff,   0xffffffff,
   0xffffffff,   0xffffffff},


/* addr_inv_abort_alu
 *
 * ctr0: counts ABORT_ALU0L 
 * ctr1: counts ABORT_ALU1L 
 * ctr2: counts ADDR0_INVALID 
 * ctr3: counts ADDR1_INVALID 
 */

{
0x0c00c000,00000000,0x00060000,00000000,
0xe0e0e0e0,0xffffffff,0xffffffff,0xffffffff,
0xffffffff,0xffa5ffff,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xff000000,00000000,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xffffffff,00000000,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xffff0000,00000000,0x6fffffff,0xffffffff,
0xfff7fff7,0xffffffff,0xffffffff,0xf0000000,
00000000,0x0003f800,0x007f000d,0x01001fc0,
0x03008007,0xf000f030,0x01fc0038,0x10007f00,
0x0905001f,0xc0020180,0x07f000b0,0x7001fc00,
0x2820007f,0x00050900,0x1fc00102,0x8007f000,
0x70b001fc,0x00183000,0x7f00010d,0x001fc000,
0x038007f0,0x0030f001,0xfc000bff,0xfffff800,
0xfffffffe,0x003fffff,0xff800fff,0xffffe003,
0xfffffff8,0x00ffffff,0xfe003fff,0xffff800f,
0xffffffe0,0x03ffffff,0xf800ffff,0xfffe003f,
0xffffff80,0x0fffffff,0xe003ffff,0xfff800ff,
0xfffffe00,0x3fffffff,0x800fffff,0xffe00000,
00000000,00000000,00000000,00000000,
0x65380000,00000000,0x60000000,00000000,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xfffffc00,00000000,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xfffffc00,00000000,
0xffffaaaa,0xffffffff,0xf3ffffff,0xffffffff,
0xfdffffff,0xffffffff,0xfe000000,00000000,
0xffffaaaa,0xffffffff,0xf3ffffff,0xffffffff,
0xfdffffff,0xffffffff,0xfe000000,00000000,
0xffffffff,0xfffff9ff,0xfe000000,00000000,
0xffffffff,0xfffff9ff,0xfe000000,00000000,
0x00030000,00000000,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xffffffff,0xffffffff },



/* brad_stall
 *
 * ctr0: counts the total number of cycles for which brad_stall is asserted 
 * ctr1: counts the number of times brad_stall is asserted for 1-4 cycles 
 * ctr2: counts the number of times brad_stall is asserted for 5-7 cycles 
 * ctr3: counts the number of times brad_stall is asserted for > 7 cycles 
 */
{
0x0c002000,00000000,0x00060000,00000000,
0xefefefef,0xffffffff,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xff000000,00000000,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xffffffff,00000000,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xffff0000,00000000,0x1fffffff,0xffffffff,
0xffffffff,0xffffffff,0xffffffff,0xf0000000,
00000000,0x00021c20,0x03ff0808,0x1800ffc4,
0x0204003f,0xf0004280,0x0ffc6020,0x8003ff00,
0x043800ff,0xc8020c00,0x3ff00044,0x800ffca0,
0x210003ff,0x00045800,0xffcc0214,0x003ff000,
0x26800ffc,0xe0218003,0xff000278,0x00ffd002,
0x1c003ff0,0x0028800f,0xfd002200,0x03ff0001,
0xf001fffe,0x003c007f,0xff800f00,0x1fffe003,
0xc007fff8,0x00f001ff,0xfe003c00,0x7fff800f,
0x001fffe0,0x03c007ff,0xf800f001,0xfffe003c,
0x007fff80,0x0f001fff,0xe003c007,0xfff800f0,
0x01fffe00,0x3c007fff,0x800f001f,0xffe00000,
00000000,00000000,00000000,00000000,
0x1bff0000,00000000,0x10000000,00000000,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xfffffc00,00000000,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xfffffc00,00000000,
0xffffffff,0xffffffff,0xf3ffffff,0xffffffff,
0xfdffffff,0xffffffff,0xfe000000,00000000,
0xffffffff,0xffffffff,0xf3ffffff,0xffffffff,
0xfdffffff,0xffffffff,0xfe000000,00000000,
0xffffffff,0xfffff9ff,0xfe000000,00000000,
0xffffffff,0xfffff9ff,0xfe000000,00000000,
0x00030000,00000000,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xffffffff,0xffffffff},

/* cntl_in_pipel
 *
 * ctr0: counts the total number of cycles for which cntl_in_pipel is asserted 
 * ctr1: counts the number of times cntl_in_pipel is asserted for 1-4 cycles 
 * ctr2: counts the number of times cntl_in_pipel is asserted for 5-7 cycles 
 * ctr3: counts the number of times cntl_in_pipel is asserted for > 7 cycles 
 */
{
0x0c006000,00000000,0x00060000,00000000,
0xefefefef,0xffffffff,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xff000000,00000000,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xffffffff,00000000,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xffff0000,00000000,0x3fffffff,0xffffffff,
0xffffffff,0xffffffff,0xffffffff,0xf0000000,
00000000,0x00021c00,0x03ff0808,0x1000ffc4,
0x0206003f,0xf0004200,0x0ffc6020,0xa003ff00,
0x043000ff,0xc8020e00,0x3ff00044,0x000ffca0,
0x212003ff,0x00045000,0xffcc0216,0x003ff000,
0x26000ffc,0xe021a003,0xff000270,0x00ffd002,
0x1e003ff0,0x0028000f,0xfd002220,0x03ff0001,
0xf001fffe,0x003c007f,0xff800f00,0x1fffe003,
0xc007fff8,0x00f001ff,0xfe003c00,0x7fff800f,
0x001fffe0,0x03c007ff,0xf800f001,0xfffe003c,
0x007fff80,0x0f001fff,0xe003c007,0xfff800f0,
0x01fffe00,0x3c007fff,0x800f001f,0xffe00000,
00000000,00000000,00000000,00000000,
0x3fff0000,00000000,0x30000000,00000000,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xfffffc00,00000000,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xfffffc00,00000000,
0xffffffff,0xffffffff,0xf3ffffff,0xffffffff,
0xfdffffff,0xffffffff,0xfe000000,00000000,
0xffffffff,0xffffffff,0xf3ffffff,0xffffffff,
0xfdffffff,0xffffffff,0xfe000000,00000000,
0xffffffff,0xfffff9ff,0xfe000000,00000000,
0xffffffff,0xfffff9ff,0xfe000000,00000000,
0x00030000,00000000,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xffffffff,0xffffffff },


/* dsnt_xfh
 *
 * ctr0: counts dside_notrans 
 * ctr1: counts xfhang 
 * ctr2: is the overflow for ctr0 
 * ctr3: is the overflow for ctr1 
 */
{
0x0c018000,00000000,0x00060000,00000000,
0xefefefef,0xffffffff,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xff000000,00000000,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xffffffff,00000000,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xffff0000,00000000,0xcfffffff,0xffffffff,
0xffffffff,0xffffffff,0xffffffff,0xf0000000,
00000000,0x00030000,0x01f30000,0x00087cc0,
0x0040041f,0x30002001,0x87cc000c,0x1001f300,
0x0404087c,0xc0014104,0x1f300060,0x4187cc00,
0x1c2001f3,0x00080808,0x7cc00242,0x041f3000,
0xa08187cc,0x002c3001,0xf3000c0c,0x087cc003,
0x43041f30,0x00e0c187,0xcc003fc0,0x07fff800,
0xf001fffe,0x003c007f,0xff800f00,0x1fffe003,
0xc007fff8,0x00f001ff,0xfe003c00,0x7fff800f,
0x001fffe0,0x03c007ff,0xf800f001,0xfffe003c,
0x007fff80,0x0f001fff,0xe003c007,0xfff800f0,
0x01fffe00,0x3c007fff,0x800f001f,0xffe00000,
00000000,00000000,00000000,00000000,
0xcb3f0000,00000000,0xc0000000,00000000,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xfffffc00,00000000,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xfffffc00,00000000,
0xffffffff,0xffffffff,0xf3ffffff,0xffffffff,
0xfdffffff,0xffffffff,0xfe000000,00000000,
0xffffffff,0xffffffff,0xf3ffffff,0xffffffff,
0xfdffffff,0xffffffff,0xfe000000,00000000,
0xffffffff,0xfffff9ff,0xfe000000,00000000,
0xffffffff,0xfffff9ff,0xfe000000,00000000,
0x00030000,00000000,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xffffffff,0xffffffff }, 

/* fet_sig1
 *
 * ctr0: counts ICORE_AV 
 * ctr1: counts ITRANS_STALL 
 * ctr2: counts SEL_PCQH 
 * ctr3: counts OUT_OF_CONTEXT 
 */
{
0x0c000000,00000000,0x00060000,00000000,
0xe0e0e0e0,0xffffffff,0xffffffff,0xffffffff,
0xffffffff,0xffa5ffff,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xff000000,00000000,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xffffffff,00000000,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xffff0000,00000000,0x0fffffff,0xffffffff,
0xfff7fff7,0xffffffff,0xffffffff,0xf0000000,
00000000,0x0003f800,0x007f000e,0x01001fc0,
0x03c08007,0xf000c030,0x01fc0034,0x10007f00,
0x0a05001f,0xc002c180,0x07f00080,0x7001fc00,
0x2420007f,0x00060900,0x1fc001c2,0x8007f000,
0x40b001fc,0x00143000,0x7f00020d,0x001fc000,
0xc38007f0,0x0000f001,0xfc0007ff,0xfffff800,
0xfffffffe,0x003fffff,0xff800fff,0xffffe003,
0xfffffff8,0x00ffffff,0xfe003fff,0xffff800f,
0xffffffe0,0x03ffffff,0xf800ffff,0xfffe003f,
0xffffff80,0x0fffffff,0xe003ffff,0xfff800ff,
0xfffffe00,0x3fffffff,0x800fffff,0xffe00000,
00000000,00000000,00000000,00000000,
0x07c10000,00000000,00000000,00000000,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xfffffc00,00000000,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xfffffc00,00000000,
0xffffaaaa,0xffffffff,0xf3ffffff,0xffffffff,
0xfdffffff,0xffffffff,0xfe000000,00000000,
0xffffaaaa,0xffffffff,0xf3ffffff,0xffffffff,
0xfdffffff,0xffffffff,0xfe000000,00000000,
0xffffffff,0xfffff9ff,0xfe000000,00000000,
0xffffffff,0xfffff9ff,0xfe000000,00000000,
0x00030000,00000000,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xffffffff,0xffffffff},

/* fet_sig2
 *
 * ctr0: counts ICORE_AV  
 * ctr1: counts IRTN_AV 
 * ctr2: counts ADDRESS_INC 
 * ctr3: counts ADDRESS_DEC 
 */
{
0x0c000000,00000000,0x00060000,00000000,
0xe0e0e0e0,0xffffffff,0xffffffff,0xffffffff,
0xffffffff,0xffa5ffff,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xff000000,00000000,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xffffffff,00000000,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xffff0000,00000000,0x0fffffff,0xffffffff,
0xfff7fff7,0xffffffff,0xffffffff,0xf0000000,
00000000,0x0003f800,0x007f000e,0x01001fc0,
0x03c08007,0xf000c030,0x01fc0034,0x10007f00,
0x0a05001f,0xc002c180,0x07f00080,0x7001fc00,
0x2420007f,0x00060900,0x1fc001c2,0x8007f000,
0x40b001fc,0x00143000,0x7f00020d,0x001fc000,
0xc38007f0,0x0000f001,0xfc0007ff,0xfffff800,
0xfffffffe,0x003fffff,0xff800fff,0xffffe003,
0xfffffff8,0x00ffffff,0xfe003fff,0xffff800f,
0xffffffe0,0x03ffffff,0xf800ffff,0xfffe003f,
0xffffff80,0x0fffffff,0xe003ffff,0xfff800ff,
0xfffffe00,0x3fffffff,0x800fffff,0xffe00000,
00000000,00000000,00000000,00000000,
0x06930000,00000000,00000000,00000000,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xfffffc00,00000000,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xfffffc00,00000000,
0xffffaaaa,0xffffffff,0xf3ffffff,0xffffffff,
0xfdffffff,0xffffffff,0xfe000000,00000000,
0xffffaaaa,0xffffffff,0xf3ffffff,0xffffffff,
0xfdffffff,0xffffffff,0xfe000000,00000000,
0xffffffff,0xfffff9ff,0xfe000000,00000000,
0xffffffff,0xfffff9ff,0xfe000000,00000000,
0x00030000,00000000,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xffffffff,0xffffffff },

/* g7_1
 *
 * ctr0: counts HIT_RETRY0 
 * ctr1: counts HIT_RETRY1 
 * ctr2: counts GO_TAG_E 
 * ctr3: counts GO_TAG_O 
 */
{
0x0c00e000,00000000,0x00060000,00000000,
0xe0e0e0e0,0xffffffff,0xffffffff,0xffffffff,
0xffffffff,0xffa5ffff,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xff000000,00000000,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xffffffff,00000000,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xffff0000,00000000,0x7fffffff,0xffffffff,
0xfff7fff7,0xffffffff,0xffffffff,0xf0000000,
00000000,0x0003f800,0x007f000e,0x01001fc0,
0x03c08007,0xf000c030,0x01fc0034,0x10007f00,
0x0a05001f,0xc002c180,0x07f00080,0x7001fc00,
0x2420007f,0x00060900,0x1fc001c2,0x8007f000,
0x40b001fc,0x00143000,0x7f00020d,0x001fc000,
0xc38007f0,0x0000f001,0xfc0007ff,0xfffff800,
0xfffffffe,0x003fffff,0xff800fff,0xffffe003,
0xfffffff8,0x00ffffff,0xfe003fff,0xffff800f,
0xffffffe0,0x03ffffff,0xf800ffff,0xfffe003f,
0xffffff80,0x0fffffff,0xe003ffff,0xfff800ff,
0xfffffe00,0x3fffffff,0x800fffff,0xffe00000,
00000000,00000000,00000000,00000000,
0x71c10000,00000000,0x70000000,00000000,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xfffffc00,00000000,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xfffffc00,00000000,
0xffffaaaa,0xffffffff,0xf3ffffff,0xffffffff,
0xfdffffff,0xffffffff,0xfe000000,00000000,
0xffffaaaa,0xffffffff,0xf3ffffff,0xffffffff,
0xfdffffff,0xffffffff,0xfe000000,00000000,
0xffffffff,0xfffff9ff,0xfe000000,00000000,
0xffffffff,0xfffff9ff,0xfe000000,00000000,
0x00030000,00000000,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xffffffff,0xffffffff },

/* g7_2
 *
 * ctr0: counts HIT_DM0 
 * ctr1: counts HIT_DM1 
 * ctr2: counts GO_STORE_E 
 * ctr3: counts GO_STORE_O 
 */
{
0x0c00e000,00000000,0x00060000,00000000,
0xe0e0e0e0,0xffffffff,0xffffffff,0xffffffff,
0xffffffff,0xffa5ffff,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xff000000,00000000,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xffffffff,00000000,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xffff0000,00000000,0x7fffffff,0xffffffff,
0xfff7fff7,0xffffffff,0xffffffff,0xf0000000,
00000000,0x0003f800,0x007f000e,0x01001fc0,
0x03c08007,0xf000c030,0x01fc0034,0x10007f00,
0x0a05001f,0xc002c180,0x07f00080,0x7001fc00,
0x2420007f,0x00060900,0x1fc001c2,0x8007f000,
0x40b001fc,0x00143000,0x7f00020d,0x001fc000,
0xc38007f0,0x0000f001,0xfc0007ff,0xfffff800,
0xfffffffe,0x003fffff,0xff800fff,0xffffe003,
0xfffffff8,0x00ffffff,0xfe003fff,0xffff800f,
0xffffffe0,0x03ffffff,0xf800ffff,0xfffe003f,
0xffffff80,0x0fffffff,0xe003ffff,0xfff800ff,
0xfffffe00,0x3fffffff,0x800fffff,0xffe00000,
00000000,00000000,00000000,00000000,
0x72930000,00000000,0x70000000,00000000,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xfffffc00,00000000,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xfffffc00,00000000,
0xffffaaaa,0xffffffff,0xf3ffffff,0xffffffff,
0xfdffffff,0xffffffff,0xfe000000,00000000,
0xffffaaaa,0xffffffff,0xf3ffffff,0xffffffff,
0xfdffffff,0xffffffff,0xfe000000,00000000,
0xffffffff,0xfffff9ff,0xfe000000,00000000,
0xffffffff,0xfffff9ff,0xfe000000,00000000,
0x00030000,00000000,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xffffffff,0xffffffff },

/* g7_3
 *
 * ctr0: counts HIT_DV0 
 * ctr1: counts HIT_DV1 
 * ctr2: counts STBYPT_E (load bypasses from store queue) 
 * ctr3: counts STBYPT_O
 */
{
0x0c00e000,00000000,0x00060000,00000000,
0xe0e0e0e0,0xffffffff,0xffffffff,0xffffffff,
0xffffffff,0xffa5ffff,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xff000000,00000000,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xffffffff,00000000,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xffff0000,00000000,0x7fffffff,0xffffffff,
0xfff7fff7,0xffffffff,0xffffffff,0xf0000000,
00000000,0x0003f800,0x007f0002,0x01001fc0,
0x00c08007,0xf0000030,0x01fc0004,0x10007f00,
0x0605001f,0xc001c180,0x07f00040,0x7001fc00,
0x1420007f,0x000a0900,0x1fc002c2,0x8007f000,
0x80b001fc,0x00243000,0x7f000e0d,0x001fc003,
0xc38007f0,0x00c0f001,0xfc0037ff,0xfffff800,
0xfffffffe,0x003fffff,0xff800fff,0xffffe003,
0xfffffff8,0x00ffffff,0xfe003fff,0xffff800f,
0xffffffe0,0x03ffffff,0xf800ffff,0xfffe003f,
0xffffff80,0x0fffffff,0xe003ffff,0xfff800ff,
0xfffffe00,0x3fffffff,0x800fffff,0xffe00000,
00000000,00000000,00000000,00000000,
0x77250000,00000000,0x70000000,00000000,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xfffffc00,00000000,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xfffffc00,00000000,
0xffffaaaa,0xffffffff,0xf3ffffff,0xffffffff,
0xfdffffff,0xffffffff,0xfe000000,00000000,
0xffffaaaa,0xffffffff,0xf3ffffff,0xffffffff,
0xfdffffff,0xffffffff,0xfe000000,00000000,
0xffffffff,0xfffff9ff,0xfe000000,00000000,
0xffffffff,0xfffff9ff,0xfe000000,00000000,
0x00030000,00000000,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xffffffff,0xffffffff },

/* g7_4
 *
 * ctr0: counts HIT_DIRTY0 
 * ctr1: counts HIT_DIRTY1 
 * ctr2: counts CA_BYP_E (quick launch) 
 * ctr3: counts CA_BYP_O 
 */
{
0x0c00e000,00000000,0x00060000,00000000,
0xe0e0e0e0,0xffffffff,0xffffffff,0xffffffff,
0xffffffff,0xffa5ffff,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xff000000,00000000,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xffffffff,00000000,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xffff0000,00000000,0x7fffffff,0xffffffff,
0xfff7fff7,0xffffffff,0xffffffff,0xf0000000,
00000000,0x0003f800,0x007f000e,0x01001fc0,
0x03c08007,0xf000c030,0x01fc0034,0x10007f00,
0x0a05001f,0xc002c180,0x07f00080,0x7001fc00,
0x2420007f,0x00060900,0x1fc001c2,0x8007f000,
0x40b001fc,0x00143000,0x7f00020d,0x001fc000,
0xc38007f0,0x0000f001,0xfc0007ff,0xfffff800,
0xfffffffe,0x003fffff,0xff800fff,0xffffe003,
0xfffffff8,0x00ffffff,0xfe003fff,0xffff800f,
0xffffffe0,0x03ffffff,0xf800ffff,0xfffe003f,
0xffffff80,0x0fffffff,0xe003ffff,0xfff800ff,
0xfffffe00,0x3fffffff,0x800fffff,0xffe00000,
00000000,00000000,00000000,00000000,
0x7bb70000,00000000,0x70000000,00000000,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xfffffc00,00000000,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xfffffc00,00000000,
0xffffaaaa,0xffffffff,0xf3ffffff,0xffffffff,
0xfdffffff,0xffffffff,0xfe000000,00000000,
0xffffaaaa,0xffffffff,0xf3ffffff,0xffffffff,
0xfdffffff,0xffffffff,0xfe000000,00000000,
0xffffffff,0xfffff9ff,0xfe000000,00000000,
0xffffffff,0xfffff9ff,0xfe000000,00000000,
0x00030000,00000000,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xffffffff,0xffffffff },


/* mpb_labort
 *
 * ctr0: counts L_ABORT_ALU0L
 * ctr1: counts L_ABORT_ALU1L 
 * ctr2: counts MPB0H 
 * ctr3: counts MPB1H 
 */
{
0x0c00c000,00000000,0x00060000,00000000,
0xe0e0e0e0,0xffffffff,0xffffffff,0xffffffff,
0xffffffff,0xffa5ffff,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xff000000,00000000,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xffffffff,00000000,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xffff0000,00000000,0x6fffffff,0xffffffff,
0xfff7fff7,0xffffffff,0xffffffff,0xf0000000,
00000000,0x0003f800,0x007f000e,0x01001fc0,
0x03c08007,0xf000c030,0x01fc0034,0x10007f00,
0x0a05001f,0xc002c180,0x07f00080,0x7001fc00,
0x2420007f,0x00060900,0x1fc001c2,0x8007f000,
0x40b001fc,0x00143000,0x7f00020d,0x001fc000,
0xc38007f0,0x0000f001,0xfc0007ff,0xfffff800,
0xfffffffe,0x003fffff,0xff800fff,0xffffe003,
0xfffffff8,0x00ffffff,0xfe003fff,0xffff800f,
0xffffffe0,0x03ffffff,0xf800ffff,0xfffe003f,
0xffffff80,0x0fffffff,0xe003ffff,0xfff800ff,
0xfffffe00,0x3fffffff,0x800fffff,0xffe00000,
00000000,00000000,00000000,00000000,
0x605c0000,00000000,0x60000000,00000000,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xfffffc00,00000000,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xfffffc00,00000000,
0xffffaaaa,0xffffffff,0xf3ffffff,0xffffffff,
0xfdffffff,0xffffffff,0xfe000000,00000000,
0xffffaaaa,0xffffffff,0xf3ffffff,0xffffffff,
0xfdffffff,0xffffffff,0xfe000000,00000000,
0xffffffff,0xfffff9ff,0xfe000000,00000000,
0xffffffff,0xfffff9ff,0xfe000000,00000000,
0x00030000,00000000,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xffffffff,0xffffffff },

/* panic
 *
 * ctr0: is the overflow for counter 1 
 * ctr1: counts traps and RFI's 
 * ctr2: counts panic traps 
 * ctr3: is the overflow for counter 2
 */
{
0x0c002000,00000000,0x00060000,00000000,
0xe7efe0e0,0xffffffff,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xffffffff,0xfffffffc,
0x41380030,0x1aabfff2,0x17000000,00000000,
0x01b80000,0x3effffff,0xffffffff,0xffffffff,
0xffffffff,00000000,00000000,0x00400000,
0x00001fff,0xffffffff,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xffff0000,00000000,0x1fffffff,0xffffffff,
0xfff7fff7,0xffffffff,0xffffffff,0xf0000000,
0xb0000000,0x00012c04,0x05790804,0x14013e44,
0x0008004f,0x90000040,0x15e46000,0xc0047920,
0x004a003e,0x40011080,0x0f900024,0x4003e460,
0x00c80479,0x00023301,0x1e400100,0x4157d080,
0x514053f4,0x40048014,0xfd000104,0x055f4600,
0x4c0147d2,0x0014a043,0xf4001508,0x10fd0003,
0x44043f46,0x004c8147,0xd0003330,0x51f40014,
0x04257908,0x0c14093e,0x44020802,0x4f900080,
0x4095e460,0x20c02479,0x20084a08,0x3e400310,
0x820f9000,0xa44083e4,0x6020c824,0x79000a33,
0x091e4003,0x3c007fff,0x800f001f,0xffe00000,
00000000,00000000,00000000,00000000,
0x10400000,00000000,0x10000000,00000000,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xfffffc00,00000000,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xfffffc00,00000000,
0xffffffff,0xffffffff,0xf3ffffff,0xffffffff,
0xfdffffff,0xffffffff,0xfe000000,00000000,
0xffffffff,0xffffffff,0xf3ffffff,0xffffffff,
0xfdffffff,0xffffffff,0xfe000000,00000000,
0xffffffff,0xfffff9ff,0xfe000000,00000000,
0xffffffff,0xfffff9ff,0xfe000000,00000000,
0x00030000,00000000,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xffffffff,0xffffffff },

/* rare_inst
 *
 * ctr0: counts sync and syncdma instructions 
 * ctr1: counts pxtlbx,x instructions 
 * ctr2: counts ixtlbt instructions 
 * ctr3: counts cycles 
 */
{
0x0c01e000,00000000,0x00060000,00000000,
0xe0e0e0e0,0x004e000c,0x000843fc,0x85c09380,
0x0121ebfd,0xff217124,0xe0004000,0x943fc85f,
0xffffffff,0xffffffff,0xff000000,00000000,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xffffffff,00000000,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xffff0000,00000000,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xffffffff,0xf0000000,
0xe00000e0,0x00003c00,0x007f0001,0x01001fc0,
0x00408007,0xf0003030,0x01fc000c,0x10007f00,
0x0505001f,0xc0014180,0x07f00070,0x7001fc00,
0x1c20007f,0x00090900,0x1fc00242,0x8007f000,
0xb0b001fc,0x002c3000,0x7f000d0d,0x001fc003,
0x438007f0,0x00f0f001,0xfc003fff,0xfffff800,
0xfffffffe,0x003fffff,0xff800fff,0xffffe003,
0xfffffff8,0x00ffffff,0xfe003fff,0xffff800f,
0xffffffe0,0x03ffffff,0xf800ffff,0xfffe003f,
0xffffff80,0x0fffffff,0xe003ffff,0xfff800ff,
0xfffffe00,0x3fffffff,0x800fffff,0xffe00000,
00000000,00000000,00000000,00000000,
0xffff0000,00000000,0xf0000000,00000000,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xfffffc00,00000000,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xfffffc00,00000000,
0xffffffff,0xffffffff,0xf3ffffff,0xffffffff,
0xfdffffff,0xffffffff,0xfe000000,00000000,
0xffffffff,0xffffffff,0xf3ffffff,0xffffffff,
0xfdffffff,0xffffffff,0xfe000000,00000000,
0xffffffff,0xfffff9ff,0xfe000000,00000000,
0xffffffff,0xfffff9ff,0xfe000000,00000000,
0x00030000,00000000,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xffffffff,0xffffffff },

/* rw_dfet (for D-cache misses and writebacks)
 *
 * ctr0: counts address valid cycles 
 * ctr1: counts *all* data valid cycles 
 * ctr2: is the overflow from counter 0 
 * ctr3: is the overflow from counter 1 
 */
{
0x0c01e000,00000000,0x00060000,00000000,
0xefefefef,0xffffffff,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xff000000,00000000,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xffffffff,00000000,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xffff0000,00000000,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xffffffff,0xf0000000,
0x0000000c,0x00003c00,0x07930000,0x0041e4c0,
0x01002079,0x3000800c,0x1e4c0030,0x00279300,
0x010049e4,0xc0014022,0x79300090,0x0c9e4c00,
0x34004793,0x00020051,0xe4c00180,0x24793000,
0xa00d1e4c,0x00380067,0x93000300,0x59e4c001,
0xc0267930,0x00b00d9e,0x4c003fff,0xffffffff,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xffffffff,0xfffffc00,
00000000,00000000,00000000,00000000,
0xffff0000,00000000,0xf0000000,00000000,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xfffffc00,00000000,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xfffffc00,00000000,
0xffffffff,0xffffffff,0xf3ffffff,0xffffffff,
0xfdffffff,0xffffffff,0xfe000000,00000000,
0xffffffff,0xffffffff,0xf3ffffff,0xffffffff,
0xfdffffff,0xffffffff,0xfe000000,00000000,
0xffffffff,0xfffff9ff,0xfe000000,00000000,
0xffffffff,0xfffff9ff,0xfe000000,00000000,
0x00100000,00000000,0xf0000000,00000000,
00000000,00000000,0x98000000,00000000,
0xffffffff,0xffffffff,0x0fffffff,0xffffffff,
00000000,00000000,0x00ffffff,0xffffffff,
0xffffffff,0xffffffff },

/* rw_ifet (I-cache misses -- actually dumb READ transactions)
 *
 * ctr0: counts address valid cycles 
 * ctr1: counts *all* data valid cycles 
 * ctr2: is the overflow from counter 0 
 * ctr3: is the overflow from counter 1 
 */
{
0x0c01e000,00000000,0x00060000,00000000,
0xefefefef,0xffffffff,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xff000000,00000000,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xffffffff,00000000,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xffff0000,00000000,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xffffffff,0xf0000000,
0x0000000c,0x00003c00,0x07930000,0x0041e4c0,
0x01002079,0x3000800c,0x1e4c0030,0x00279300,
0x010049e4,0xc0014022,0x79300090,0x0c9e4c00,
0x34004793,0x00020051,0xe4c00180,0x24793000,
0xa00d1e4c,0x00380067,0x93000300,0x59e4c001,
0xc0267930,0x00b00d9e,0x4c003fff,0xffffffff,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xffffffff,0xfffffc00,
00000000,00000000,00000000,00000000,
0xffff0000,00000000,0xf0000000,00000000,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xfffffc00,00000000,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xfffffc00,00000000,
0xffffffff,0xffffffff,0xf3ffffff,0xffffffff,
0xfdffffff,0xffffffff,0xfe000000,00000000,
0xffffffff,0xffffffff,0xf3ffffff,0xffffffff,
0xfdffffff,0xffffffff,0xfe000000,00000000,
0xffffffff,0xfffff9ff,0xfe000000,00000000,
0xffffffff,0xfffff9ff,0xfe000000,00000000,
0x00100000,00000000,0xd0000000,00000000,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0x00ffffff,0xffffffff,
0xffffffff,0xffffffff,00000000,00000000,
0xffffffff,0xffffffff },


/* rw_sdfet (READ_SHARED_OR_PRIVATE transactions)
 *
 * ctr0: counts address valid cycles
 * ctr1: counts *all* data valid cycles 
 * ctr2: is the overflow from counter 0 
 * ctr3: is the overflow from counter 1 
 */
{
0x0c01e000,00000000,0x00060000,00000000,
0xefefefef,0xffffffff,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xff000000,00000000,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xffffffff,00000000,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xffff0000,00000000,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xffffffff,0xf0000000,
0x0000000c,0x00003c00,0x07930000,0x0041e4c0,
0x01002079,0x3000800c,0x1e4c0030,0x00279300,
0x010049e4,0xc0014022,0x79300090,0x0c9e4c00,
0x34004793,0x00020051,0xe4c00180,0x24793000,
0xa00d1e4c,0x00380067,0x93000300,0x59e4c001,
0xc0267930,0x00b00d9e,0x4c003fff,0xffffffff,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xffffffff,0xfffffc00,
00000000,00000000,00000000,00000000,
0xffff0000,00000000,0xf0000000,00000000,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xfffffc00,00000000,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xfffffc00,00000000,
0xffffffff,0xffffffff,0xf3ffffff,0xffffffff,
0xfdffffff,0xffffffff,0xfe000000,00000000,
0xffffffff,0xffffffff,0xf3ffffff,0xffffffff,
0xfdffffff,0xffffffff,0xfe000000,00000000,
0xffffffff,0xfffff9ff,0xfe000000,00000000,
0xffffffff,0xfffff9ff,0xfe000000,00000000,
0x00100000,00000000,0xf4000000,00000000,
00000000,00000000,00000000,00000000,
0xffffffff,0xffffffff,0x00ffffff,0xffffffff,
00000000,00000000,00000000,00000000,
0xffffffff,0xffffffff },


/* spec_ifet
 *
 * ICORE_AV fires for every request which the Instruction Fetch Unit sends
 * to the Runway Interface Block.  Hence, this counts all I-misses, speculative
 * or not, but does *not* include I-cache prefetches, which are generated by
 * RIB.
 * IRTN_AV fires twice for every I-cache miss returning from RIB to the IFU.
 * It will not fire if a second I-cache miss is issued from the IFU to RIB
 * before the first returns.  Therefore, if the IRTN_AV count is much less
 * than 2x the ICORE_AV count, many speculative I-cache misses are occurring
 * which are "discovered" to be incorrect fairly quickly.
 * The ratio of I-cache miss transactions on Runway to the ICORE_AV count is
 * a measure of the effectiveness of instruction prefetching.  This ratio
 * should be between 1 and 2.  If it is close to 1, most prefetches are
 * eventually called for by the IFU; if it is close to 2, almost no prefetches
 * are useful and they are wasted bus traffic.
 *
 * ctr0: counts ICORE_AV 
 * ctr1: counts IRTN_AV 
 * ctr2: counts all non-coherent READ transactions on Runway. (TTYPE D0) 
 *	This should be just I-cache miss and I-prefetch transactions.
 * ctr3: counts total processor cycles 
 */
{
0x0c000000,00000000,0x00060000,00000000,
0xefefefef,0xffffffff,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xff000000,00000000,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xffffffff,00000000,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xffff0000,00000000,0x0fffffff,0xffffffff,
0xffffffff,0xffffffff,0xffffffff,0xf0000000,
0x00000008,0x00030c00,0x01bf0001,0x00806fc0,
0x00c1001b,0xf0005048,0x06fc001c,0x2001bf00,
0x0908806f,0xc002c300,0x1bf000d0,0xc806fc00,
0x3fffffff,0xffffffff,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xffffffff,0xfffffc00,
00000000,00000000,00000000,00000000,
0x06bf0000,00000000,00000000,00000000,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xfffffc00,00000000,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xfffffc00,00000000,
0xffffffff,0xffffffff,0xf3ffffff,0xffffffff,
0xfdffffff,0xffffffff,0xfe000000,00000000,
0xffffffff,0xffffffff,0xf3ffffff,0xffffffff,
0xfdffffff,0xffffffff,0xfe000000,00000000,
0xffffffff,0xfffff9ff,0xfe000000,00000000,
0xffffffff,0xfffff9ff,0xfe000000,00000000,
0x00110000,00000000,0xd0ffffff,0xffffffff,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0x00ffffff,0xffffffff,
0xffffffff,0xffffffff,00000000,00000000,
0xffffffff,0xffffffff },

/* st_cond0
 *
 * ctr0: is the overflow for ctr1
 * ctr1: counts major ops 0C and 0E (fp ops, not fmac or fmpyadd) 
 * ctr2: counts B,L (including long and push) and GATE (including nullified),
 *	 predicted not-taken
 * ctr3: is the overflow for ctr2 
 */
{
0x4c01e000,00000000,0x00060000,00000000,
0xe0e0c0e0,0xffffffff,0xffffffff,0xffc13380,
0x0101ffff,0xffa1f057,0xe000407f,0xdfffc87f,
0xffffffff,0xffffffff,0xff000000,00000000,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xffffffff,00000000,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xffff0000,00000000,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xffffffff,0xf0000000,
0xf0000060,0x00003c00,0x04f90000,0x02013e40,
0x0081004f,0x90004060,0x13e40018,0x0024f900,
0x0802093e,0x40028102,0x4f9000c0,0x6093e400,
0x380014f9,0x00010205,0x3e4000c1,0x014f9000,
0x506053e4,0x001c0034,0xf9000902,0x0d3e4002,
0xc1034f90,0x00d060d3,0xe4003fff,0xffffffff,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xffffffff,0xfffffc00,
00000000,00000000,00000000,00000000,
0xffff0000,00000000,0xf0000000,00000000,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xfffffc00,00000000,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xfffffc00,00000000,
0xffffffff,0xffffffff,0xf3ffffff,0xffffffff,
0xfdffffff,0xffffffff,0xfe000000,00000000,
0xffffffff,0xffffffff,0xf3ffffff,0xffffffff,
0xfdffffff,0xffffffff,0xfe000000,00000000,
0xffffffff,0xfffff9ff,0xfe000000,00000000,
0xffffffff,0xfffff9ff,0xfe000000,00000000,
0x00030000,00000000,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xffffffff,0xffffffff },

/* st_cond1
 *
 * ctr0: is the overflow for ctr1 
 * ctr1: counts major ops 1x (most of the load/stores) 
 * ctr2: counts CMPB (dw) predicted not-taken 
 * ctr3: is the overflow for ctr2 
 */
{
0x4c01e000,00000000,0x00060000,00000000,
0xe0e0c0e0,0xffffffff,0xffffffff,0xffc01b80,
0x0101ffff,0xffb7f03d,0xe000407f,0xffffc8ff,
0xffffffff,0xffffffff,0xff000000,00000000,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xffffffff,00000000,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xffff0000,00000000,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xffffffff,0xf0000000,
0xf0000060,0x00003c00,0x04f90000,0x02013e40,
0x0081004f,0x90004060,0x13e40018,0x0024f900,
0x0802093e,0x40028102,0x4f9000c0,0x6093e400,
0x380014f9,0x00010205,0x3e4000c1,0x014f9000,
0x506053e4,0x001c0034,0xf9000902,0x0d3e4002,
0xc1034f90,0x00d060d3,0xe4003fff,0xffffffff,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xffffffff,0xfffffc00,
00000000,00000000,00000000,00000000,
0xffff0000,00000000,0xf0000000,00000000,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xfffffc00,00000000,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xfffffc00,00000000,
0xffffffff,0xffffffff,0xf3ffffff,0xffffffff,
0xfdffffff,0xffffffff,0xfe000000,00000000,
0xffffffff,0xffffffff,0xf3ffffff,0xffffffff,
0xfdffffff,0xffffffff,0xfe000000,00000000,
0xffffffff,0xfffff9ff,0xfe000000,00000000,
0xffffffff,0xfffff9ff,0xfe000000,00000000,
0x00030000,00000000,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xffffffff,0xffffffff },

/* st_cond2
 *
 * ctr0: is the overflow for ctr1 
 * ctr1: counts major op 03 
 * ctr2: counts CMPIB (dw) predicted not taken. 
 * ctr3: is the overflow for ctr2 
 */
{
0x4c01e000,00000000,0x00060000,00000000,
0xe0e0c0e0,0xffffffff,0xffffffff,0xffc09780,
0x0101ffff,0xff21f077,0xe000407f,0xffffc87f,
0xffffffff,0xffffffff,0xff000000,00000000,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xffffffff,00000000,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xffff0000,00000000,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xffffffff,0xf0000000,
0xf0000060,0x00003c00,0x04f90000,0x02013e40,
0x0081004f,0x90004060,0x13e40018,0x0024f900,
0x0802093e,0x40028102,0x4f9000c0,0x6093e400,
0x380014f9,0x00010205,0x3e4000c1,0x014f9000,
0x506053e4,0x001c0034,0xf9000902,0x0d3e4002,
0xc1034f90,0x00d060d3,0xe4003fff,0xffffffff,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xffffffff,0xfffffc00,
00000000,00000000,00000000,00000000,
0xffff0000,00000000,0xf0000000,00000000,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xfffffc00,00000000,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xfffffc00,00000000,
0xffffffff,0xffffffff,0xf3ffffff,0xffffffff,
0xfdffffff,0xffffffff,0xfe000000,00000000,
0xffffffff,0xffffffff,0xf3ffffff,0xffffffff,
0xfdffffff,0xffffffff,0xfe000000,00000000,
0xffffffff,0xfffff9ff,0xfe000000,00000000,
0xffffffff,0xfffff9ff,0xfe000000,00000000,
0x00030000,00000000,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xffffffff,0xffffffff },

/* st_cond3
 *
 * ctr0: is the overflow for ctr1 
 * ctr1: counts major ops 06 & 26 
 * ctr2: counts BB, BVB, MOVB, MOVIB (incl. nullified) predicted not-taken 
 * ctr3: is the overflow for ctr2 
 */
{
0x4c01e000,00000000,0x00060000,00000000,
0xe0e0c0e0,0xffffffff,0xffffffff,0xffc03780,
0x0101ffff,0xff29f016,0xe000407f,0xffffe97f,
0xffffffff,0xffffffff,0xff000000,00000000,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xffffffff,00000000,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xffff0000,00000000,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xffffffff,0xf0000000,
0xf0000060,0x00003c00,0x04f90000,0x02013e40,
0x0081004f,0x90004060,0x13e40018,0x0024f900,
0x0802093e,0x40028102,0x4f9000c0,0x6093e400,
0x380014f9,0x00010205,0x3e4000c1,0x014f9000,
0x506053e4,0x001c0034,0xf9000902,0x0d3e4002,
0xc1034f90,0x00d060d3,0xe4003fff,0xffffffff,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xffffffff,0xfffffc00,
00000000,00000000,00000000,00000000,
0xffff0000,00000000,0xf0000000,00000000,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xfffffc00,00000000,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xfffffc00,00000000,
0xffffffff,0xffffffff,0xf3ffffff,0xffffffff,
0xfdffffff,0xffffffff,0xfe000000,00000000,
0xffffffff,0xffffffff,0xf3ffffff,0xffffffff,
0xfdffffff,0xffffffff,0xfe000000,00000000,
0xffffffff,0xfffff9ff,0xfe000000,00000000,
0xffffffff,0xfffff9ff,0xfe000000,00000000,
0x00030000,00000000,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xffffffff,0xffffffff },

/* st_cond4
 *
 * ctr0: is the overflow for ctr1 
 * ctr1: counts major op 2E 
 * ctr2: counts CMPB, CMPIB, ADDB, ADDIB (incl. nullified) predicted not-taken 
 * ctr3: is the overflow for ctr2 
 */
{
0x4c01e000,00000000,0x00060000,00000000,
0xe0e0c0e0,0xffffffff,0xffffffff,0xffc17780,
0x0101ffff,0xff21f014,0xe000407f,0xffffe9ff,
0xffffffff,0xffffffff,0xff000000,00000000,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xffffffff,00000000,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xffff0000,00000000,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xffffffff,0xf0000000,
0xf0000060,0x00003c00,0x04f90000,0x02013e40,
0x0081004f,0x90004060,0x13e40018,0x0024f900,
0x0802093e,0x40028102,0x4f9000c0,0x6093e400,
0x380014f9,0x00010205,0x3e4000c1,0x014f9000,
0x506053e4,0x001c0034,0xf9000902,0x0d3e4002,
0xc1034f90,0x00d060d3,0xe4003fff,0xffffffff,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xffffffff,0xfffffc00,
00000000,00000000,00000000,00000000,
0xffff0000,00000000,0xf0000000,00000000,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xfffffc00,00000000,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xfffffc00,00000000,
0xffffffff,0xffffffff,0xf3ffffff,0xffffffff,
0xfdffffff,0xffffffff,0xfe000000,00000000,
0xffffffff,0xffffffff,0xf3ffffff,0xffffffff,
0xfdffffff,0xffffffff,0xfe000000,00000000,
0xffffffff,0xfffff9ff,0xfe000000,00000000,
0xffffffff,0xfffff9ff,0xfe000000,00000000,
0x00030000,00000000,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xffffffff,0xffffffff },

/* st_unpred0
 *
 * ctr0: is the overflow for ctr1 
 * ctr1: counts BE and BE,L 
 * ctr2: counts BE and BE,L including nullified 
 * ctr3: is the overflow for ctr2 
 */
{
0x4c01e000,00000000,0x00060000,00000000,
0xe0c0c0e0,0xffffffff,0xffffffff,0xffdf5bbf,
0xffffffff,0xff25f7d6,0xefffffff,0xffffc97f,
0xffffffff,0xffffffff,0xff000000,00000000,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xffffffff,00000000,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xffff0000,00000000,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xffffffff,0xf0000000,
0xf0000060,0x00003c00,0x04f90000,0x02013e40,
0x0081004f,0x90004060,0x13e40018,0x0024f900,
0x0802093e,0x40028102,0x4f9000c0,0x6093e400,
0x380014f9,0x00010205,0x3e4000c1,0x014f9000,
0x506053e4,0x001c0034,0xf9000902,0x0d3e4002,
0xc1034f90,0x00d060d3,0xe4003fff,0xffffffff,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xffffffff,0xfffffc00,
00000000,00000000,00000000,00000000,
0xffff0000,00000000,0xf0000000,00000000,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xfffffc00,00000000,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xfffffc00,00000000,
0xffffffff,0xffffffff,0xf3ffffff,0xffffffff,
0xfdffffff,0xffffffff,0xfe000000,00000000,
0xffffffff,0xffffffff,0xf3ffffff,0xffffffff,
0xfdffffff,0xffffffff,0xfe000000,00000000,
0xffffffff,0xfffff9ff,0xfe000000,00000000,
0xffffffff,0xfffff9ff,0xfe000000,00000000,
0x00030000,00000000,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xffffffff,0xffffffff },

/* st_unpred1
 *
 * ctr0: is the overflow for ctr1 
 * ctr1: counts BLR, BV, BVE, BVE,L 
 * ctr2: counts BLR, BV, BVE, BVE,L including nullified 
 * ctr3: is the overflow for ctr2 
 */
{
0x4c01e000,00000000,0x00060000,00000000,
0xe0c0c0e0,0xffffffff,0xffffffff,0xffc15f80,
0x0501ff7f,0xff21f057,0xe001407f,0xdfffc87f,
0xffffffff,0xffffffff,0xff000000,00000000,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xffffffff,00000000,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xffff0000,00000000,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xffffffff,0xf0000000,
0xf0000060,0x00003c00,0x04f90000,0x02013e40,
0x0081004f,0x90004060,0x13e40018,0x0024f900,
0x0802093e,0x40028102,0x4f9000c0,0x6093e400,
0x380014f9,0x00010205,0x3e4000c1,0x014f9000,
0x506053e4,0x001c0034,0xf9000902,0x0d3e4002,
0xc1034f90,0x00d060d3,0xe4003fff,0xffffffff,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xffffffff,0xfffffc00,
00000000,00000000,00000000,00000000,
0xffff0000,00000000,0xf0000000,00000000,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xfffffc00,00000000,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xfffffc00,00000000,
0xffffffff,0xffffffff,0xf3ffffff,0xffffffff,
0xfdffffff,0xffffffff,0xfe000000,00000000,
0xffffffff,0xffffffff,0xf3ffffff,0xffffffff,
0xfdffffff,0xffffffff,0xfe000000,00000000,
0xffffffff,0xfffff9ff,0xfe000000,00000000,
0xffffffff,0xfffff9ff,0xfe000000,00000000,
0x00030000,00000000,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xffffffff,0xffffffff },

/* unpred
 *
 * ctr0: counts non-nullified unpredictable branches 
 * ctr1: is the overflow for ctr0 
 * ctr2: counts all unpredictable branches (nullified or not) 
 * ctr3: is the overflow for ctr2 
 */
{
0xcc01e000,00000000,0x00060000,00000000,
0x20202020,0xff31ffff,0xfff7fffe,0x97ffcc7f,
0xfffffdff,0xffa5fff3,0x1fffffff,0x7fffe97f,
0xffffffff,0xffffffff,0xff000000,00000000,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xffffffff,00000000,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xffff0000,00000000,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xffffffff,0xf0000000,
0xf00000a0,0x00003c00,0x02f50000,0x0004bd40,
0x0040802f,0x50002020,0x4bd4000c,0x0042f500,
0x040014bd,0x40014084,0x2f500060,0x214bd400,
0x1c2002f5,0x00080804,0xbd400242,0x802f5000,
0xa0a04bd4,0x002c2042,0xf5000c08,0x14bd4003,
0x42842f50,0x00e0a14b,0xd4003fff,0xffffffff,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xffffffff,0xfffffc00,
00000000,00000000,00000000,00000000,
0xffff0000,00000000,0xf0000000,00000000,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xfffffc00,00000000,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xfffffc00,00000000,
0xffffffff,0xffffffff,0xf3ffffff,0xffffffff,
0xfdffffff,0xffffffff,0xfe000000,00000000,
0xffffffff,0xffffffff,0xf3ffffff,0xffffffff,
0xfdffffff,0xffffffff,0xfe000000,00000000,
0xffffffff,0xfffff9ff,0xfe000000,00000000,
0xffffffff,0xfffff9ff,0xfe000000,00000000,
0x00030000,00000000,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xffffffff,0xffffffff },
   

/* go_store
 *
 * ctr0: Overflow for counter 2 
 * ctr1: Overflow for counter 3 
 * ctr2: count of GO_STORE_E signal 
 * ctr3: count of GO_STORE_O signal 
 */

   {
   0x0c00e000,   0x00000000,   0x00060000,   0x00000000,
   0xe0e0e0e0,   0xffffffff,   0xffffffff,   0xffffffff,
   0xffffffff,   0xffa5ffff,   0xffffffff,   0xffffffff,
   0xffffffff,   0xffffffff,   0xff000000,   0x00000000,
   0xffffffff,   0xffffffff,   0xffffffff,   0xffffffff,
   0xffffffff,   0x00000000,   0xffffffff,   0xffffffff,
   0xffffffff,   0xffffffff,   0xffffffff,   0xffffffff,
   0xffffffff,   0xffffffff,   0xffffffff,   0xffffffff,
   0xffff0000,   0x00000000,   0x7fffffff,   0xffffffff,
   0xffffffff,   0xffffffff,   0xffffffff,   0xf0000000,
   0x00000000,   0x0000c000,   0x067c0000,   0x01019f00,
   0x00408067,   0xc0002030,   0x19f0000c,   0x000e7c00,
   0x0401039f,   0x00014080,   0xe7c00060,   0x3039f000,
   0x1c00167c,   0x00080105,   0x9f000240,   0x8167c000,
   0xa03059f0,   0x002c001e,   0x7c000c01,   0x079f0003,
   0x4081e7c0,   0x00e03079,   0xf0003fc0,   0x07fff800,
   0xf001fffe,   0x003c007f,   0xff800f00,   0x1fffe003,
   0xc007fff8,   0x00f001ff,   0xfe003c00,   0x7fff800f,
   0x001fffe0,   0x03c007ff,   0xf800f001,   0xfffe003c,
   0x007fff80,   0x0f001fff,   0xe003c007,   0xfff800f0,
   0x01fffe00,   0x3c007fff,   0x800f001f,   0xffe00000,
   0x00000000,   0x00000000,   0x00000000,   0x00000000,
   0x70130000,   0x00000000,   0x70000000,   0x00000000,
   0xffffffff,   0xffffffff,   0xffffffff,   0xffffffff,
   0xfffffc00,   0x00000000,   0xffffffff,   0xffffffff,
   0xffffffff,   0xffffffff,   0xfffffc00,   0x00000000,
   0xffffaaaa,   0xffffffff,   0xf3ffffff,   0xffffffff,
   0xfdffffff,   0xffffffff,   0xfe000000,   0x00000000,
   0xffffaaaa,   0xffffffff,   0xf3ffffff,   0xffffffff,
   0xfdffffff,   0xffffffff,   0xfe000000,   0x00000000,
   0xffffffff,   0xfffff9ff,   0xfe000000,   0x00000000,
   0xffffffff,   0xfffff9ff,   0xfe000000,   0x00000000,
   0x00030000,   0x00000000,   0xffffffff,   0xffffffff,
   0xffffffff,   0xffffffff,   0xffffffff,   0xffffffff,
   0xffffffff,   0xffffffff,   0xffffffff,   0xffffffff,
   0xffffffff,   0xffffffff,   0xffffffff,   0xffffffff,
   0xffffffff,   0xffffffff
   },


/* shlib_call
 *
 * ctr0: SharedLib call Depth1 
 * ctr1: SharedLib call Depth2 
 * ctr2: SharedLib call Depth3 
 * ctr3: SharedLib call Depth>3 
 */
   {
   0x0c01e000,   0x00000000,   0x00060000,   0x00000000,
   0xe0e0e0e0,   0xc76fa005,   0x07dd7e9c,   0x87115b80,
   0x01100200,   0x07200004,   0xe000407f,   0xfffffffc,
   0x01380010,   0x1fffffff,   0xff000000,   0x00000000,
   0xffffffff,   0xffffffff,   0xffffffff,   0xffffffff,
   0xffffffff,   0x00000000,   0xffffffff,   0xffffffff,
   0xffffffff,   0xffffffff,   0xffffffff,   0xffffffff,
   0xffffffff,   0xffffffff,   0xffffffff,   0xffffffff,
   0xffff0000,   0x00000000,   0xffffffff,   0xffffffff,
   0xffffffff,   0xffffffff,   0xffffffff,   0xf0000000,
   0xf0000000,   0x00003c20,   0x01ff0808,   0x04007fc0,
   0x0003001f,   0xf0000180,   0x07fc4010,   0x5001ff00,
   0x001c007f,   0xc2000a00,   0x1ff18022,   0x4007fc20,
   0x00b001ff,   0x10003800,   0x7fc8004d,   0x001ff100,
   0x03c007fc,   0x60012001,   0xff280144,   0x007fc600,
   0x13001ff2,   0x00058007,   0xfcc00550,   0x01ff2000,
   0x5c007fca,   0x001a001f,   0xf3801640,   0x07fca001,
   0xb001ff30,   0x0078007f,   0xd0005d00,   0x1ff30007,
   0xc007fce0,   0x022001ff,   0x48018400,   0x7fce0023,
   0x001ff400,   0x098007fd,   0x20065001,   0xff40009c,
   0x007fd200,   0x3fffffff,   0x800fffff,   0xffe00000,
   0x00000000,   0x00000000,   0x00000000,   0x00000000,
   0xffff0000,   0x00000000,   0xf0000000,   0x00000000,
   0xffffffff,   0xffffffff,   0xffffffff,   0xffffffff,
   0xfffffc00,   0x00000000,   0xffffffff,   0xffffffff,
   0xffffffff,   0xffffffff,   0xfffffc00,   0x00000000,
   0xffffffff,   0xffffffff,   0xf3ffffff,   0xffffffff,
   0xfdffffff,   0xffffffff,   0xfe000000,   0x00000000,
   0xffffffff,   0xffffffff,   0xf3ffffff,   0xffffffff,
   0xfdffffff,   0xffffffff,   0xfe000000,   0x00000000,
   0xffffffff,   0xfffff9ff,   0xfe000000,   0x00000000,
   0xffffffff,   0xfffff9ff,   0xfe000000,   0x00000000,
   0x00030000,   0x00000000,   0xffffffff,   0xffffffff,
   0xffffffff,   0xffffffff,   0xffffffff,   0xffffffff,
   0xffffffff,   0xffffffff,   0xffffffff,   0xffffffff,
   0xffffffff,   0xffffffff,   0xffffffff,   0xffffffff,
   0xffffffff,   0xffffffff
   }
};
#define PCXW_IMAGE_SIZE 576

static uint32_t cuda_images[][PCXW_IMAGE_SIZE/sizeof(uint32_t)] = {
/*
 * CPI:     FROM CPI.IDF (Image 0)
 *
 * Counts the following:
 *
 * ctr0 : total cycles
 * ctr1 : total cycles where nothing retired
 * ctr2 : total instructions retired, including nullified
 * ctr3 : total instructions retired, less nullified instructions
 */
   {
   0x4c00c000,   0x00000000,   0x00060000,   0x00000000, 
   0xe0e0e0e0,   0x00001fff,   0xfc00007f,   0xfff00001, 
   0xffffc000,   0x07ffff00,   0x07ffffff,   0x6007ffff, 
   0xff0007ff,   0xffff0007,   0xffffff00,   0x00000000, 
   0x60f00000,   0x0fffff00,   0x000fffff,   0x00000fff, 
   0xff00000f,   0xffff0000,   0x00000000,   0x00ffffff, 
   0xfffff000,   0x0000000f,   0xffffffff,   0xff000000, 
   0x0000ffff,   0xfffffff0,   0x00000000,   0x0fffffff, 
   0xffff0000,   0x00000000,   0x00000000,   0x00000000, 
   0x00000000,   0x00000000,   0x00270000,   0x00000055, 
   0x0200000e,   0x4d300000,   0x00000000,   0x0ff00002, 
   0x70000000,   0x00000020,   0x0000e400,   0x00000ff0, 
   0x00000000,   0x00000000,   0x00000055,   0xffffff00, 
   0x00000000,   0x0000ff00,   0x00000000,   0x0f000000, 
   0x0000055f,   0xfffff000,   0x00000000,   0x000ff000, 
   0x00000000,   0x00000000,   0x000055ff,   0xffff0000, 
   0x00000000,   0x00ff0000,   0x00000000,   0xf0000000, 
   0x000055ff,   0xffff0000,   0x00000000,   0x00ff0000, 
   0x00000000,   0x00000000,   0x00055fff,   0xfff00000, 
   0x00000000,   0x0ff00000,   0x00000030,   0x00000000, 
   0x00157fff,   0xffc00000,   0x034c0000,   0x00000000, 
   0x03fc0000,   0x00000000,   0x6fff0000,   0x00000000, 
   0x60000000,   0x00000000,   0x00ffffff,   0xff3fffff, 
   0xffffffff,   0xffcfffff,   0xfff7fbfc,   0x00000000, 
   0x00ffffff,   0xff3fffff,   0xffffffff,   0xffcfffff, 
   0xfff7fbfc,   0x00000000,   0xffffafff,   0xffffff3f, 
   0xffffffff,   0xffffff7f,   0xffffffff,   0xfffffefc, 
   0x00000000,   0x00000000,   0xffffafff,   0xffffff3f, 
   0xffffffff,   0xffffff7f,   0xffffffff,   0xfffffefc, 
   0x00000000,   0x00000000,   0xffffffff,   0xfffff9ff, 
   0xfe000000,   0x00000000,   0xffffffff,   0xfffff9ff, 
   0xfe000000,   0x00000000,   0x00030000,   0x00000000, 
   0xffffffff,   0xffffffff,   0xffffffff,   0xffffffff, 
   0xffffffff,   0xffffffff,   0xffffffff,   0xffffffff, 
   0xffffffff,   0xffffffff,   0xffffffff,   0xffffffff, 
   0xffffffff,   0xffffffff,   0xffffffff,   0xffffffff,
   },

/* Bus utilization image   FROM BUS_UTIL.IDF (Image 1)
 *
 * ctr0 : counts address valid cycles
 * ctr1 : counts data valid cycles
 * ctr2 : counts overflow from counter 0
 * ctr3 : counts overflow from counter 1
 */
         {
	 0x0c01e000, 0x00000000, 0x00060000, 0x00000000,
	 0xefefefef, 0xffffffff, 0xffffffff, 0xffffffff,
	 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
	 0xffffffff, 0xffffffff, 0xffffff00, 0x00000000,
	 0xf0ffffff, 0xffffffff, 0xffffffff, 0xffffffff,
	 0xffffffff, 0xffff0000, 0xffffffff, 0xffffffff,
	 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
	 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
	 0xffff0000, 0x00000000, 0x00000000, 0x00000000,
	 0x00000000, 0x00000000, 0x00001b00, 0xaa000000,
	 0x00000001, 0x30700000, 0x00055aaf, 0xf0000000,
	 0x01b00000, 0x00000000, 0x00001037, 0x00000000,
	 0x55aaff00, 0x00c00000, 0x1b55aa00, 0x00000000,
	 0x0001fff0, 0xcfffff00, 0x00000000, 0x0f0fffff,
	 0xffffffff, 0xffffffff, 0x30ffff0c, 0xfffff000,
	 0x00000000, 0x00ffffff, 0xffffffff, 0xfffffff3,
	 0x0ffff0cf, 0xffff0000, 0x00000000, 0x00ffffff,
	 0xffffffff, 0xfffffff3, 0x0ffff0cf, 0xffff0000,
	 0x00000000, 0x0fffffff, 0xffffffff, 0xffffff30,
	 0xfff70000, 0x000055aa, 0xff000000, 0x000006d5,
	 0x40000000, 0x00000000, 0x731c0000, 0x000156ab,
	 0xfc000000, 0x00000000, 0xffff0000, 0x00000000,
	 0xf0000000, 0x00000000, 0x00ffffff, 0xff3fffff,
	 0xffffffff, 0xffcfffff, 0xfff7fbfc, 0x00000000,
	 0x00ffffff, 0xff3fffff, 0xffffffff, 0xffcfffff,
	 0xfff7fbfc, 0x00000000, 0xffffffff, 0xffffff3f,
	 0xffffffff, 0xffffff7f, 0xffffffff, 0xfffffefc,
	 0x00000000, 0x00000000, 0xffffffff, 0xffffff3f,
	 0xffffffff, 0xffffff7f, 0xffffffff, 0xfffffefc,
	 0x00000000, 0x00000000, 0xffffffff, 0xfffff9ff,
	 0xfe000000, 0x00000000, 0xffffffff, 0xfffff9ff,
	 0xfe000000, 0x00000000, 0x00100000, 0x00000000,
	 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
	 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
	 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
	 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
   },

/*
 * TLB counts:    FROM TLBSTATS.IDF (Image 2)
 *
 * Counts the following:
 *
 * ctr0: DTLB misses
 * ctr1: ITLB misses
 * ctr2: total cycles in the miss handlers
 * ctr3: total cycles
 */

   {
   0x0c00c000,   0x00000000,   0x00060000,   0x00000000, 
   0xe7e7e0e0,   0x00001fff,   0xfc00007f,   0xfff00001, 
   0xfff00000,   0x07ffff00,   0x07ffffff,   0x6007ffff, 
   0xa00007ff,   0xffff0007,   0xffffff00,   0x00000000, 
   0x603001c1,   0xe0000001,   0xc0c00000,   0x00000fff, 
   0xff00000f,   0xffff0000,   0x00000000,   0x00400000, 
   0x00001000,   0x00000004,   0x00000000,   0x01000000, 
   0x0000ffff,   0xfffffff0,   0x00000000,   0x0fffffff, 
   0xffff0000,   0x00000000,   0x00000000,   0x00000000, 
   0x00000000,   0x00000000,   0x00800000,   0x00153f7f, 
   0x55000000,   0xaf800000,   0xc0000000,   0x0403f240, 
   0x00000000,   0x00001010,   0x00004700,   0x00000ff0, 
   0x00000000,   0x00000000,   0x00000055,   0xffffff00, 
   0x00000000,   0x0000ff00,   0x00000000,   0x0f000000, 
   0x0000055f,   0xfffff000,   0x00000000,   0x000ff000, 
   0x00000000,   0x00000000,   0x000055ff,   0xffff0000, 
   0x00000000,   0x00ff0000,   0x00000000,   0xf0000000, 
   0x000055ff,   0xffff0000,   0x00000000,   0x00ff0000, 
   0x00000000,   0x00000000,   0x00055fff,   0xfff00000, 
   0x00000000,   0x0ff00000,   0x00000000,   0x00000000, 
   0x00157fff,   0xffc00000,   0x00000000,   0x3fc00000, 
   0x00040000,   0x00000000,   0x6fff0000,   0x00000000, 
   0x60000000,   0x00000000,   0x00ffffff,   0xff3fffff, 
   0xffffffff,   0xffcfffff,   0xfff7fbfc,   0x00000000, 
   0x00ffffff,   0xff3fffff,   0xffffffff,   0xffcfffff, 
   0xfff7fbfc,   0x00000000,   0xffffafff,   0xffffff3f, 
   0xffffffff,   0xffffff7f,   0xffffffff,   0xfffffefc, 
   0x00000000,   0x00000000,   0xffffafff,   0xffffff3f, 
   0xffffffff,   0xffffff7f,   0xffffffff,   0xfffffefc, 
   0x00000000,   0x00000000,   0xffffffff,   0xfffff9ff, 
   0xfe000000,   0x00000000,   0xffffffff,   0xfffff9ff, 
   0xfe000000,   0x00000000,   0x00030000,   0x00000000, 
   0xffffffff,   0xffffffff,   0xffffffff,   0xffffffff, 
   0xffffffff,   0xffffffff,   0xffffffff,   0xffffffff, 
   0xffffffff,   0xffffffff,   0xffffffff,   0xffffffff, 
   0xffffffff,   0xffffffff,   0xffffffff,   0xffffffff,
   },

/* tlbhandler  FROM tlbHandMiss.idf (Image 3)
 *
 * ctr0: TLB misses
 * ctr1: dmisses inside the TLB miss handler
 * ctr2: cycles in the TLB miss handler
 * ctr3: overflow of ctr2
 */
   {
   0x1c00c000,   0x00000000,   0x00060000,   0x00000000, 
   0xe7e7e0e0,   0x00001fff,   0xfc00007f,   0xfff00001, 
   0xfff00000,   0x07ffff00,   0x07ffffff,   0x6007ffff, 
   0xa00007ff,   0xffff0007,   0xffffff00,   0x00000000, 
   0x603001c1,   0xe0000001,   0xc0c00000,   0x00000fff, 
   0xff00000f,   0xffff0000,   0x00000000,   0x00400000, 
   0x00001000,   0x00000004,   0x00000000,   0x01000000, 
   0x0000ffff,   0xfffffff0,   0x00000000,   0x0fffffff, 
   0xffff0000,   0x00000000,   0x00000000,   0x00000000, 
   0x00000000,   0x00000000,   0x006c0000,   0x01000054, 
   0x02000002,   0xc3200000,   0xc00aa000,   0x0c03f240, 
   0x00000000,   0x00001010,   0x000044f4,   0x00000c00, 
   0xaa0000f0,   0x0f0000b0,   0x00005005,   0x0f5f0000, 
   0x0001f000,   0x0000ff00,   0x00000000,   0x0f000000, 
   0x0000055f,   0xfffff000,   0x00000000,   0x000ff000, 
   0x00000000,   0x00000000,   0x000055ff,   0xffff0000, 
   0x00000000,   0x00ff0000,   0x00000000,   0xf0000000, 
   0x000055ff,   0xffff0000,   0x00000000,   0x00ff0000, 
   0x00000000,   0x00000000,   0x00055fff,   0xfff00000, 
   0x00000000,   0x0ff00a00,   0x000f0000,   0x24004000, 
   0x15400001,   0x40c00003,   0x3da00000,   0x0002a800, 
   0x00ff0000,   0x00000000,   0x6fff0000,   0x00000000, 
   0x60000000,   0x00000000,   0x00ffffff,   0xff3fffff, 
   0xffffffff,   0xffcfffff,   0xfff7fbfc,   0x00000000, 
   0x00ffffff,   0xff3fffff,   0xffffffff,   0xffcfffff, 
   0xfff7fbfc,   0x00000000,   0xffffafff,   0xffffff3f, 
   0xffffffff,   0xffffff7f,   0xffffffff,   0xfffffefc, 
   0x00000000,   0x00000000,   0xffffafff,   0xffffff3f, 
   0xffffffff,   0xffffff7f,   0xffffffff,   0xfffffefc, 
   0x00000000,   0x00000000,   0xffffffff,   0xfffff9ff, 
   0xfe000000,   0x00000000,   0xffffffff,   0xfffff9ff, 
   0xfe000000,   0x00000000,   0x00030000,   0x00000000, 
   0xffffffff,   0xffffffff,   0xffffffff,   0xffffffff, 
   0xffffffff,   0xffffffff,   0xffffffff,   0xffffffff, 
   0xffffffff,   0xffffffff,   0xffffffff,   0xffffffff, 
   0xffffffff,   0xffffffff,   0xffffffff,   0xffffffff,
   },

/* branch_taken image  FROM PTKN.IDF (Image 4)
 *
 * ctr0: mispredicted branches
 * ctr1: predicted taken branches, actually taken
 * ctr2: predicted taken branches (includes nullfied)
 * ctr3: all branches
 */

   {
   0xcc01e000,   0x00000000,   0x00000000,   0x00000000, 
   0xa08080a0,   0xffffffff,   0xffffffff,   0xffffffff, 
   0xffffffff,   0xfffffeff,   0xfffeffff,   0xffffffff, 
   0xffffffff,   0xffffffff,   0xffffff00,   0x00000000, 
   0xf4ffffff,   0xffffffff,   0xffffffff,   0xffffffff, 
   0xffffffff,   0xffff0000,   0xffffffff,   0xffffffff, 
   0xffffffff,   0xffffffff,   0xffffffff,   0xffffffff, 
   0xffffffff,   0xffffffff,   0xffffffff,   0xffffffff, 
   0xffff0000,   0x00000000,   0x00000000,   0x00000000, 
   0x00000000,   0x00000000,   0xd22d0000,   0x00000000, 
   0x0000000b,   0x46000000,   0x00000000,   0x0ffff900, 
   0x90000000,   0x00000000,   0x0000907e,   0x00000000, 
   0x000000ff,   0xff00bfdf,   0x03030303,   0x03030000, 
   0x000dbfff,   0xffffff00,   0x00000000,   0x0f0fffff, 
   0xffffffff,   0xffffffff,   0xffffffff,   0xfffff000, 
   0x00000000,   0x00ffffff,   0xffffffff,   0xffffffff, 
   0xffffffff,   0xffff0000,   0x00000000,   0xf0ffffff, 
   0xffffffff,   0xffffffff,   0xffffffff,   0xffff0000, 
   0x00000000,   0x0fffffff,   0xffffffff,   0xffffffff, 
   0xffff5555,   0x55500000,   0x003f3ff0,   0x2766c000, 
   0x00000000,   0x00000002,   0x67840000,   0x00000000, 
   0x03fffc00,   0x00000000,   0xffff0000,   0x00000000, 
   0xf0000000,   0x00000000,   0x00ffffff,   0xff3fffff, 
   0xffffffff,   0xffcfffff,   0xfff7fbfc,   0x00000000, 
   0x00ffffff,   0xff3fffff,   0xffffffff,   0xffcfffff, 
   0xfff7fbfc,   0x00000000,   0xffffffff,   0xffffff3f, 
   0xffffffff,   0xffffff7f,   0xffffffff,   0xfffffefc, 
   0x00000000,   0x00000000,   0xffffffff,   0xffffff3f, 
   0xffffffff,   0xffffff7f,   0xffffffff,   0xfffffefc, 
   0x00000000,   0x00000000,   0xffffffff,   0xfffff9ff, 
   0xfe000000,   0x00000000,   0xffffffff,   0xfffff9ff, 
   0xfe000000,   0x00000000,   0x00030000,   0x00000000, 
   0xffffffff,   0xffffffff,   0xffffffff,   0xffffffff, 
   0xffffffff,   0xffffffff,   0xffffffff,   0xffffffff, 
   0xffffffff,   0xffffffff,   0xffffffff,   0xffffffff, 
   0xffffffff,   0xffffffff,   0xffffffff,   0xffffffff,
   },

/* branch_nottaken  FROM PNTKN.IDF (Image 5)
 *
 * ctr0: mispredicted branches
 * ctr1: branches predicted not-taken, but actually taken
 * ctr2: branches predicted not-taken (includes nullified)
 * ctr3: all branches
 */
   {
   0xcc01e000,   0x00000000,   0x00000000,   0x00000000, 
   0xe0c0c0e0,   0xffffffff,   0xffffffff,   0xffefffff, 
   0xffffbfff,   0xfffffeff,   0xfffeffff,   0xfffffeff, 
   0xfffffffe,   0xffffffff,   0xffffff00,   0x00000000, 
   0xf4ffffff,   0xffffffff,   0xffffffff,   0xffffffff, 
   0xffffffff,   0xffff0000,   0xffffffff,   0xffffffff, 
   0xffffffff,   0xffffffff,   0xffffffff,   0xffffffff, 
   0xffffffff,   0xffffffff,   0xffffffff,   0xffffffff, 
   0xffff0000,   0x00000000,   0x00000000,   0x00000000, 
   0x00000000,   0x00000000,   0xd22d0000,   0x00000000, 
   0x0000000b,   0x46000000,   0x00000000,   0x0ffff900, 
   0x90000000,   0x00000000,   0x0000907e,   0x00000000, 
   0x000000ff,   0xff00bfdf,   0x03030303,   0x03030000, 
   0x000dbfff,   0xffffff00,   0x00000000,   0x0f0fffff, 
   0xffffffff,   0xffffffff,   0xffffffff,   0xfffff000, 
   0x00000000,   0x00ffffff,   0xffffffff,   0xffffffff, 
   0xffffffff,   0xffff0000,   0x00000000,   0xf0ffffff, 
   0xffffffff,   0xffffffff,   0xffffffff,   0xffff0000, 
   0x00000000,   0x0fffffff,   0xffffffff,   0xffffffff, 
   0xffff5555,   0x55500000,   0x003f3ff0,   0x2766c000, 
   0x00000000,   0x00000002,   0x67840000,   0x00000000, 
   0x03fffc00,   0x00000000,   0xffff0000,   0x00000000, 
   0xf0000000,   0x00000000,   0x00ffffff,   0xff3fffff, 
   0xffffffff,   0xffcfffff,   0xfff7fbfc,   0x00000000, 
   0x00ffffff,   0xff3fffff,   0xffffffff,   0xffcfffff, 
   0xfff7fbfc,   0x00000000,   0xffffffff,   0xffffff3f, 
   0xffffffff,   0xffffff7f,   0xffffffff,   0xfffffefc, 
   0x00000000,   0x00000000,   0xffffffff,   0xffffff3f, 
   0xffffffff,   0xffffff7f,   0xffffffff,   0xfffffefc, 
   0x00000000,   0x00000000,   0xffffffff,   0xfffff9ff, 
   0xfe000000,   0x00000000,   0xffffffff,   0xfffff9ff, 
   0xfe000000,   0x00000000,   0x00030000,   0x00000000, 
   0xffffffff,   0xffffffff,   0xffffffff,   0xffffffff, 
   0xffffffff,   0xffffffff,   0xffffffff,   0xffffffff, 
   0xffffffff,   0xffffffff,   0xffffffff,   0xffffffff, 
   0xffffffff,   0xffffffff,   0xffffffff,   0xffffffff,
   },
   
/* IMISS image (Image 6)
 *
 * ctr0 : icache misses for retired instructions
 * ctr1 : total cycles
 * ctr2 : dcache misses for retired instructions
 * ctr3 : number of retired instructions
 */
   {
   0x2801e000,   0x00000000,   0x00010000,   0x00000000, 
   0x00001000,   0xffffffff,   0xffffffff,   0xfff00fff, 
   0xfffa3fff,   0xffffffff,   0xffffffff,   0xffffffff, 
   0xffffffff,   0xffffffff,   0xffffff00,   0x00000000, 
   0xf0ffffff,   0xffffffff,   0xffffffff,   0xffffffff, 
   0xffffffff,   0xffff0000,   0xffffffff,   0xffffffff, 
   0xffffffff,   0xffffffff,   0xffffffff,   0xffffffff, 
   0xffffffff,   0xffffffff,   0xffffffff,   0xffffffff, 
   0xffff0000,   0x00000000,   0x00000000,   0x00000000, 
   0x00000000,   0x00000000,   0xf2fdf0f0,   0xf0f0f0f0, 
   0xffffffff,   0xf6c00000,   0x00000000,   0x0ff55800, 
   0x90000000,   0x00000000,   0x0000b0ff,   0xfffffff0, 
   0x00000003,   0x0100bfff,   0x3f3f3f3f,   0x3f3f5555, 
   0x555fffff,   0xffffff00,   0x00000000,   0x000fffff, 
   0xffffffff,   0xffffffff,   0xffffffff,   0xfffff000, 
   0x00000000,   0x00ffffff,   0xffffffff,   0xffffffff, 
   0xffffffff,   0xffff0000,   0x00000000,   0xf0ffffff, 
   0xffffffff,   0xffffffff,   0xffffffff,   0xffff0000, 
   0x00000000,   0x0fffffff,   0xffffffff,   0xffffffff, 
   0xffffffff,   0xfff00000,   0x000301b0,   0x2fefcfcf, 
   0xcfcfcfcf,   0xd5555557,   0xf7b40000,   0x00000000, 
   0x03c14000,   0x00000000,   0xffff0000,   0x00000000, 
   0xf0000000,   0x00000000,   0x00ffffff,   0xff3fffff, 
   0xffffffff,   0xffcfffff,   0xfff6fb7c,   0x00000000, 
   0x00ffffff,   0xff3fffff,   0xffffffff,   0xffcfffff, 
   0xfff6fb7c,   0x00000000,   0xffff0fff,   0xffffff3f, 
   0xffffffff,   0xffffff7f,   0xffffffff,   0xfffffefc, 
   0x00000000,   0x00000000,   0xffff0fff,   0xffffff3f, 
   0xffffffff,   0xffffff7f,   0xffffffff,   0xfffffefc, 
   0x00000000,   0x00000000,   0xffffffff,   0xfffff9ff, 
   0xfe000000,   0x00000000,   0xffffffff,   0xfffff9ff, 
   0xfe000000,   0x00000000,   0x00130000,   0x00000000, 
   0xffffffff,   0xffffffff,   0xffffffff,   0xffffffff, 
   0xffffffff,   0xffffffff,   0xffffffff,   0xffffffff, 
   0xffffffff,   0xffffffff,   0xffffffff,   0xffffffff, 
   0xffffffff,   0xffffffff,   0xffffffff,   0xffffffff,
   },

/* DMISS image (Image 7)
 *
 * ctr0 : icache misses for retired instructions
 * ctr1 : total cycles
 * ctr2 : dcache misses for retired instructions
 * ctr3 : number of retired instructions
 */
   {
   0x2801e000,   0x00000000,   0x00010000,   0x00000000, 
   0x00001000,   0xffffffff,   0xffffffff,   0xfff00fff, 
   0xfffa3fff,   0xffffffff,   0xffffffff,   0xffffffff, 
   0xffffffff,   0xffffffff,   0xffffff00,   0x00000000, 
   0xf0ffffff,   0xffffffff,   0xffffffff,   0xffffffff, 
   0xffffffff,   0xffff0000,   0xffffffff,   0xffffffff, 
   0xffffffff,   0xffffffff,   0xffffffff,   0xffffffff, 
   0xffffffff,   0xffffffff,   0xffffffff,   0xffffffff, 
   0xffff0000,   0x00000000,   0x00000000,   0x00000000, 
   0x00000000,   0x00000000,   0xf2fdf0f0,   0xf0f0f0f0, 
   0xffffffff,   0xf6c00000,   0x00000000,   0x0ff55800, 
   0x90000000,   0x00000000,   0x0000b0ff,   0xfffffff0, 
   0x00000003,   0x0100bfff,   0x3f3f3f3f,   0x3f3f5555, 
   0x555fffff,   0xffffff00,   0x00000000,   0x000fffff, 
   0xffffffff,   0xffffffff,   0xffffffff,   0xfffff000, 
   0x00000000,   0x00ffffff,   0xffffffff,   0xffffffff, 
   0xffffffff,   0xffff0000,   0x00000000,   0xf0ffffff, 
   0xffffffff,   0xffffffff,   0xffffffff,   0xffff0000, 
   0x00000000,   0x0fffffff,   0xffffffff,   0xffffffff, 
   0xffffffff,   0xfff00000,   0x000301b0,   0x2fefcfcf, 
   0xcfcfcfcf,   0xd5555557,   0xf7b40000,   0x00000000, 
   0x03c14000,   0x00000000,   0xffff0000,   0x00000000, 
   0xf0000000,   0x00000000,   0x00ffffff,   0xff3fffff, 
   0xffffffff,   0xffcfffff,   0xfff6fb7c,   0x00000000, 
   0x00ffffff,   0xff3fffff,   0xffffffff,   0xffcfffff, 
   0xfff6fb7c,   0x00000000,   0xffff0fff,   0xffffff3f, 
   0xffffffff,   0xffffff7f,   0xffffffff,   0xfffffefc, 
   0x00000000,   0x00000000,   0xffff0fff,   0xffffff3f, 
   0xffffffff,   0xffffff7f,   0xffffffff,   0xfffffefc, 
   0x00000000,   0x00000000,   0xffffffff,   0xfffff9ff, 
   0xfe000000,   0x00000000,   0xffffffff,   0xfffff9ff, 
   0xfe000000,   0x00000000,   0x00130000,   0x00000000, 
   0xffffffff,   0xffffffff,   0xffffffff,   0xffffffff, 
   0xffffffff,   0xffffffff,   0xffffffff,   0xffffffff, 
   0xffffffff,   0xffffffff,   0xffffffff,   0xffffffff, 
   0xffffffff,   0xffffffff,   0xffffffff,   0xffffffff,
   },

/* dmiss_access image    FROM DMISS_RATIO.IDF  (Image 8)
 * 
 * ctr0 : all loads and stores that retire (even lines)
 * ctr1 : all loads and stores that retire (odd lines)
 * ctr2 : dcache misses of retired loads/stores
 * ctr3 : all READ_PRIV and READ_SHAR_OR_PRIV on Runway
 *        (Speculative and Non-Speculative)
 */
   {
   0x2d81e000,   0x00000000,   0x00000000,   0x00000000, 
   0x10101010,   0x00ffffff,   0xa003ffff,   0xfe800fff, 
   0xfffa003f,   0xffffe8ff,   0xffffffff,   0xffffffff, 
   0xffffffff,   0xffffffff,   0xffffff00,   0x00000000, 
   0xf0ffffff,   0xffffffff,   0xffffffff,   0xffffffff, 
   0xffffffff,   0xffff0000,   0xffffffff,   0xffffffff, 
   0xffffffff,   0xffffffff,   0xffffffff,   0xffffffff, 
   0xffffffff,   0xffffffff,   0xffffffff,   0xffffffff, 
   0xffff0000,   0x00000000,   0x00000000,   0x00000000, 
   0x00000000,   0x00000000,   0xd2280a00,   0x00000000, 
   0x0000000b,   0x46000000,   0x00000005,   0x555ff900, 
   0x80200000,   0x00000000,   0x0000907e,   0x00000000, 
   0x00005555,   0xff80bf8b,   0xab030303,   0x03030000, 
   0x000dbfff,   0xffffff00,   0x00000000,   0x000fffff, 
   0xffffffff,   0xffffffff,   0xffffffff,   0xfffff000, 
   0x00000000,   0x00ffffff,   0xffffffff,   0xffffffff, 
   0xffffffff,   0xffff0000,   0x00000000,   0xf0ffffff, 
   0xffffffff,   0xffffffff,   0xffffffff,   0xffff0000, 
   0x00000000,   0x0fffffff,   0xffffffff,   0xffffffff, 
   0xffff5555,   0x55500000,   0x15153fe0,   0x27628880, 
   0x00000000,   0x00000002,   0x67840000,   0x00000001, 
   0x5557fc00,   0x00000000,   0xffff0000,   0x00000000, 
   0xf0000000,   0x00000000,   0x00ffffff,   0xff3fffff, 
   0xffffffff,   0xffcfffff,   0xfff6fb7c,   0x00000000, 
   0x00ffffff,   0xff3fffff,   0xffffffff,   0xffcfffff, 
   0xfff6fb7c,   0x00000000,   0xffff0fff,   0xffffff3f, 
   0xffffffff,   0xffffff7f,   0xffffffff,   0xfffffefc, 
   0x00000000,   0x00000000,   0xffff0fff,   0xffffff3f, 
   0xffffffff,   0xffffff7f,   0xffffffff,   0xfffffefc, 
   0x00000000,   0x00000000,   0xffffffff,   0xfffff9ff, 
   0xfe000000,   0x00000000,   0xffffffff,   0xfffff9ff, 
   0xfe000000,   0x00000000,   0x00110000,   0x00000000, 
   0xf4ffffff,   0xffffffff,   0xffffffff,   0xffffffff, 
   0xf8ffffff,   0xffffffff,   0xffffffff,   0xffffffff, 
   0x00ffffff,   0xffffffff,   0xffffffff,   0xffffffff, 
   0x00ffffff,   0xffffffff,   0xffffffff,   0xffffffff,
   },


/* big_cpi image  (Image 9)
 * 
 * ctr0 : Total number of CPU clock cycles. 
 * ctr1 : Unused 
 * ctr2 : Unused
 * ctr3 : Total number of Non-Nullified instructions retired. 
 */
   {
   0x0c00c000,   0x00000000,   0x00060000,   0x00000000,
   0xe7e7e0e0,   0x00001fff,   0xfc00007f,   0xfff00001,
   0xfff00000,   0x07ffff00,   0x07ffffff,   0x6007ffff,
   0xa00007ff,   0xffff0007,   0xffffff00,   0x00000000,
   0x603001c1,   0xe0000001,   0xc0c00000,   0x00000fff,
   0xff00000f,   0xffff0000,   0x00000000,   0x00400000,
   0x00001000,   0x00000004,   0x00000000,   0x01000000,
   0x0000ffff,   0xfffffff0,   0x00000000,   0x0fffffff,
   0xffff0000,   0x00000000,   0x00000000,   0x00000000,
   0x00000000,   0x00000000,   0x00550005,   0x00220000,
   0x0000000c,   0x71f00000,   0x00f00aa0,   0x0aaff000,
   0x00005002,   0x20000000,   0x0000c413,   0x00000c0f,
   0x00aa0000,   0xff00b600,   0x000500a0,   0x00000300,
   0x000cc3f0,   0x0000c0f0,   0x0aa0000f,   0xff000000,
   0x011000a0,   0x05503000,   0x00d03700,   0x00000f00,
   0xaa005500,   0x00000000,   0x000055ff,   0xffff0000,
   0x00000000,   0x00ff0000,   0x00000000,   0xf000aa00,
   0x11000a00,   0x55000000,   0x0d037000,   0x00c0f00a,
   0xa0055000,   0x0db00005,   0x5002a000,   0x00300000,
   0xf40f0000,   0x0c0f00aa,   0x0000ff10,   0x27400000,
   0x00008000,   0x00c00003,   0x037c0000,   0x003c02a8,
   0x02abfc00,   0x00000000,   0x6fff0000,   0x00000000,
   0x60000000,   0x00000000,   0x00ffffff,   0xff3fffff,
   0xffffffff,   0xffcfffff,   0xfff7fbfc,   0x00000000,
   0x00ffffff,   0xff3fffff,   0xffffffff,   0xffcfffff,
   0xfff7fbfc,   0x00000000,   0xffffafff,   0xffffff3f,
   0xffffffff,   0xffffff7f,   0xffffffff,   0xfffffefc,
   0x00000000,   0x00000000,   0xffffafff,   0xffffff3f,
   0xffffffff,   0xffffff7f,   0xffffffff,   0xfffffefc,
   0x00000000,   0x00000000,   0xffffffff,   0xfffff9ff,
   0xfe000000,   0x00000000,   0xffffffff,   0xfffff9ff,
   0xfe000000,   0x00000000,   0x00030000,   0x00000000,
   0xffffffff,   0xffffffff,   0xffffffff,   0xffffffff,
   0xffffffff,   0xffffffff,   0xffffffff,   0xffffffff,
   0xffffffff,   0xffffffff,   0xffffffff,   0xffffffff,
   0xffffffff,   0xffffffff,   0xffffffff,   0xffffffff,
   },

/* big_ls image  (Image 10)
 * 
 * ctr0 : Total number of CPU clock cycles during which local_stall_A1 is asserted 
 * ctr1 : Overflow of Counter 0 
 * ctr2 : Total number of IFLUSH_AV 
 * ctr3 : Overflow of Counter 2 
 */
   {
   0x0c000000,   0x00000000,   0x00060000,   0x00000000,
   0xefefefef,   0xffffffff,   0xffffffff,   0xffffffff,
   0xffffffff,   0xffffffff,   0xffffffff,   0xffffffff,
   0xffffffff,   0xffffffff,   0xffffff00,   0x00000000,
   0x00ffffff,   0xffffffff,   0xffffffff,   0xffffffff,
   0xffffffff,   0xffff0000,   0xffffffff,   0xffffffff,
   0xffffffff,   0xffffffff,   0xffffffff,   0xffffffff,
   0xffffffff,   0xffffffff,   0xffffffff,   0xffffffff,
   0xffff0000,   0x00000000,   0x00000000,   0x00000000,
   0x00000000,   0x00000000,   0x28880001,   0x54000000,
   0x00000004,   0xb6200000,   0x000aaaa0,   0x05555288,
   0x80000010,   0x00000000,   0x0000486e,   0x00000000,
   0xaaaa0055,   0x55002888,   0x00545401,   0x03030000,
   0x0007b000,   0x0000ff00,   0x00000000,   0x05000000,
   0x0000055f,   0xfffff000,   0x00000000,   0x000ff000,
   0x00000000,   0x00000000,   0x000055ff,   0xffff0000,
   0x00000000,   0x00ff0000,   0x00000000,   0x00000000,
   0x000055ff,   0xffff0000,   0x00000000,   0x00ff0000,
   0x00000000,   0xa0000000,   0x00055fff,   0xfff00000,
   0x00aa0000,   0x05502a2a,   0x00151500,   0x0a220015,
   0x40400000,   0x00000001,   0xe2980000,   0x0002aaa8,
   0x01555400,   0x00000000,   0x0df70000,   0x00000000,
   0x00000000,   0x00000000,   0x00ffffff,   0xff3fffff,
   0xffffffff,   0xffcfffff,   0xfff7fbfc,   0x00000000,
   0x00ffffff,   0xff3fffff,   0xffffffff,   0xffcfffff,
   0xfff7fbfc,   0x00000000,   0xffffffff,   0xffffff3f,
   0xffffffff,   0xffffff7f,   0xffffffff,   0xfffffefc,
   0x00000000,   0x00000000,   0xffffffff,   0xffffff3f,
   0xffffffff,   0xffffff7f,   0xffffffff,   0xfffffefc,
   0x00000000,   0x00000000,   0xffffffff,   0xfffff9ff,
   0xfe000000,   0x00000000,   0xffffffff,   0xfffff9ff,
   0xfe000000,   0x00000000,   0x00030000,   0x00000000,
   0xffffffff,   0xffffffff,   0xffffffff,   0xffffffff,
   0xffffffff,   0xffffffff,   0xffffffff,   0xffffffff,
   0xffffffff,   0xffffffff,   0xffffffff,   0xffffffff,
   0xffffffff,   0xffffffff,   0xffffffff,   0xffffffff,
   },

/* br_abort image  (Image 12)
 * 
 * ctr0 : Total number of BRAD_STALLH
 * ctr1 : Total number of ONE_QUAD
 * ctr2 : Total number of BR0_ABRT
 * ctr3 : Total number of BR1_ABRT
 */

   {
   0x0c002000,   0x00000000,   0x00060000,   0x00000000,
   0xe0e0e0e0,   0xffffffff,   0xffffffff,   0xff0fffff,
   0xffffffff,   0xffffffff,   0xffffffff,   0xffffffff,
   0xffffffff,   0xffffffff,   0xffffff00,   0x00000000,
   0x1077ffff,   0xffffffff,   0xffffffff,   0xffffffff,
   0xffffffff,   0xffff0000,   0xffffffff,   0xffffffff,
   0xffffffff,   0xffffffff,   0xffffffff,   0xffffffff,
   0xffffffff,   0xffffffff,   0xffffffff,   0xffffffff,
   0xffff0000,   0x00000000,   0x00000000,   0x00000000,
   0x00000000,   0x00000000,   0x551b0000,   0x00000000,
   0x0000000c,   0xd4f00000,   0x00000000,   0x0ffff001,
   0xb0000000,   0x00000000,   0x0000fd4c,   0x00000000,
   0x000000ff,   0xff00ff1b,   0x00000000,   0x00000000,
   0x0000d000,   0x0000ff00,   0x00000000,   0x0e0fffff,
   0xffffffff,   0xfffff000,   0x00000000,   0x000ff000,
   0x00000000,   0x00ffffff,   0xffffffff,   0xffff0000,
   0x00000000,   0x00ff0000,   0x00000000,   0x00ffffff,
   0xffffffff,   0xffff0000,   0x00000000,   0x00ff0000,
   0x00000000,   0xffffffff,   0xffffffff,   0xfff00000,
   0x00400000,   0x00000000,   0x00ffff00,   0x2a86c000,
   0x00000000,   0x00000000,   0xf50c0000,   0x00000000,
   0x03fffc00,   0x00000000,   0x1a250000,   0x00000000,
   0x10000000,   0x00000000,   0x00ffffff,   0xff3fffff,
   0xffffffff,   0xffcfffff,   0xfff7fbfc,   0x00000000,
   0x00ffffff,   0xff3fffff,   0xffffffff,   0xffcfffff,
   0xfff7fbfc,   0x00000000,   0xffffafff,   0xffffff3f,
   0xffffffff,   0xffffff7f,   0xffffffff,   0xfffffefc,
   0x00000000,   0x00000000,   0xffffafff,   0xffffff3f,
   0xffffffff,   0xffffff7f,   0xffffffff,   0xfffffefc,
   0x00000000,   0x00000000,   0xffffffff,   0xfffff9ff,
   0xfe000000,   0x00000000,   0xffffffff,   0xfffff9ff,
   0xfe000000,   0x00000000,   0x00030000,   0x00000000,
   0xffffffff,   0xffffffff,   0xffffffff,   0xffffffff,
   0xffffffff,   0xffffffff,   0xffffffff,   0xffffffff,
   0xffffffff,   0xffffffff,   0xffffffff,   0xffffffff,
   0xffffffff,   0xffffffff,   0xffffffff,   0xffffffff,
   },


/* isnt image  (Image 13)
 * 
 * ctr0 : Total number of cycles for which iside_notrans is asserted. 
 * ctr1 : Total number of times iside_notrans is asserted for 1-4 cycles. 
 * ctr2 : Total number of times iside_notrans is asserted for 5-7 cycles. 
 * ctr3 : Total number of times iside_notrans is asserted for > 7 cycles. 
 */

   {
   0x0c018000,   0x00000000,   0x00060000,   0x00000000,
   0xefefefef,   0xffffffff,   0xffffffff,   0xffffffff,
   0xffffffff,   0xffffffff,   0xffffffff,   0xffffffff,
   0xffffffff,   0xffffffff,   0xffffff00,   0x00000000,
   0xc0ffffff,   0xffffffff,   0xffffffff,   0xffffffff,
   0xffffffff,   0xffff0000,   0xffffffff,   0xffffffff,
   0xffffffff,   0xffffffff,   0xffffffff,   0xffffffff,
   0xffffffff,   0xffffffff,   0xffffffff,   0xffffffff,
   0xffff0000,   0x00000000,   0x00000000,   0x00000000,
   0x00000000,   0x00000000,   0x22000000,   0x000001bc,
   0x10000006,   0x00900000,   0x50000000,   0x00055a20,
   0x00000000,   0x00016060,   0x0000c021,   0x00000540,
   0x00000000,   0x55002200,   0x00000000,   0x56bc4000,
   0x00048000,   0x0000ff00,   0x00000000,   0x17000000,
   0x0000055f,   0xfffff000,   0x00000000,   0x000ff000,
   0x00000000,   0x00000000,   0x000055ff,   0xffff0000,
   0x00000000,   0x00ff0000,   0x00000000,   0x00000000,
   0x000055ff,   0xffff0000,   0x00000000,   0x00ff0000,
   0x00000000,   0x80000000,   0x00015bf3,   0xf5500000,
   0x02210000,   0x00100000,   0x00005500,   0x08800000,
   0x00001545,   0x85000001,   0x80240000,   0x11000000,
   0x00015400,   0x00000000,   0xcdff0000,   0x00000000,
   0xc0000000,   0x00000000,   0x00ffffff,   0xff3fffff,
   0xffffffff,   0xffcfffff,   0xfff7fbfc,   0x00000000,
   0x00ffffff,   0xff3fffff,   0xffffffff,   0xffcfffff,
   0xfff7fbfc,   0x00000000,   0xffffffff,   0xffffff3f,
   0xffffffff,   0xffffff7f,   0xffffffff,   0xfffffefc,
   0x00000000,   0x00000000,   0xffffffff,   0xffffff3f,
   0xffffffff,   0xffffff7f,   0xffffffff,   0xfffffefc,
   0x00000000,   0x00000000,   0xffffffff,   0xfffff9ff,
   0xfe000000,   0x00000000,   0xffffffff,   0xfffff9ff,
   0xfe000000,   0x00000000,   0x00030000,   0x00000000,
   0xffffffff,   0xffffffff,   0xffffffff,   0xffffffff,
   0xffffffff,   0xffffffff,   0xffffffff,   0xffffffff,
   0xffffffff,   0xffffffff,   0xffffffff,   0xffffffff,
   0xffffffff,   0xffffffff,   0xffffffff,   0xffffffff,
   },

/* quadrant image  (image 14)
 * 
 * ctr0 : Total number of instructions in quadrant 0. 
 * ctr1 : Total number of instructions in quadrant 1. 
 * ctr2 : Total number of instructions in quadrant 2. 
 * ctr3 : Total number of instructions in quadrant 3. 
 *
 * Only works for 32-bit applications.
 */

   {
   0x0c01e000,   0x00000000,   0x00060000,   0x00000000,
   0xe0e0e0e0,   0x00001fff,   0xfc00007f,   0xfff00001,
   0xffffc000,   0x07ffff00,   0x07ffffff,   0x0007ffff,
   0xff0007ff,   0xffff0007,   0xffffff00,   0x00000000,
   0xf0000000,   0x0fffff00,   0x000fffff,   0x00000fff,
   0xff00000f,   0xffff0000,   0x00000000,   0x00ffffff,
   0xffcff000,   0x0000040f,   0xfffffffc,   0xff000000,
   0x0080ffff,   0xffffcff0,   0x0000000c,   0x0fffffff,
   0xfcff0000,   0x00000000,   0x00000000,   0x00000000,
   0x00000000,   0x00000000,   0x551b0000,   0x00000000,
   0x00000003,   0x17000000,   0x00000000,   0x0ffff001,
   0xb0000000,   0x00000000,   0x00000173,   0x00000000,
   0x000000ff,   0xff00ff1b,   0x00000000,   0x00000000,
   0x000f1ff0,   0xcfffff00,   0x00000000,   0x0f0fffff,
   0xffffffff,   0xffffffff,   0x30ffff0c,   0xfffff000,
   0x00000000,   0x00ffffff,   0xffffffff,   0xfffffff3,
   0x0ffff0cf,   0xffff0000,   0x00000000,   0xf0ffffff,
   0xffffffff,   0xfffffff3,   0x0ffff0cf,   0xffff0000,
   0x00000000,   0x0fffffff,   0xffffffff,   0xffffff30,
   0xff7f0000,   0x00000000,   0x00fffff0,   0x2a86c000,
   0x00000000,   0x00000003,   0x05f00000,   0x00000000,
   0x03fffc00,   0x00000000,   0xffff0000,   0x00000000,
   0xf0000000,   0x00000000,   0x00ffffff,   0xff3fffff,
   0xffffffff,   0xffcfffff,   0xfff7fbfc,   0x00000000,
   0x00ffffff,   0xff3fffff,   0xffffffff,   0xffcfffff,
   0xfff7fbfc,   0x00000000,   0xffffffff,   0xffffff3f,
   0xffffffff,   0xffffff7f,   0xffffffff,   0xfffffefc,
   0x00000000,   0x00000000,   0xffffffff,   0xffffff3f,
   0xffffffff,   0xffffff7f,   0xffffffff,   0xfffffefc,
   0x00000000,   0x00000000,   0xffffffff,   0xfffff9ff,
   0xfe000000,   0x00000000,   0xffffffff,   0xfffff9ff,
   0xfe000000,   0x00000000,   0x00030000,   0x00000000,
   0xffffffff,   0xffffffff,   0xffffffff,   0xffffffff,
   0xffffffff,   0xffffffff,   0xffffffff,   0xffffffff,
   0xffffffff,   0xffffffff,   0xffffffff,   0xffffffff,
   0xffffffff,   0xffffffff,   0xffffffff,   0xffffffff,
   },

/* rw_pdfet image (Image 15)
 * 
 * ctr0 : Total of all READ_PRIV address valid cycles. 
 * ctr1 : Total of all READ_PRIV data valid cycles. 
 * ctr2 : Overflow of Counter 0. 
 * ctr3 : Overflow of Counter 1. 
 */

   {
   0x0c01e000,   0x00000000,   0x00060000,   0x00000000,
   0xefefefef,   0xffffffff,   0xffffffff,   0xffffffff,
   0xffffffff,   0xffffffff,   0xffffffff,   0xffffffff,
   0xffffffff,   0xffffffff,   0xffffff00,   0x00000000,
   0xf0ffffff,   0xffffffff,   0xffffffff,   0xffffffff,
   0xffffffff,   0xffff0000,   0xffffffff,   0xffffffff,
   0xffffffff,   0xffffffff,   0xffffffff,   0xffffffff,
   0xffffffff,   0xffffffff,   0xffffffff,   0xffffffff,
   0xffff0000,   0x00000000,   0x00000000,   0x00000000,
   0x00000000,   0x00000000,   0x00001b00,   0xaa000000,
   0x00000001,   0x30700000,   0x00055aaf,   0xf0000000,
   0x01b00000,   0x00000000,   0x00001037,   0x00000000,
   0x55aaff00,   0x00c00000,   0x1b55aa00,   0x00000000,
   0x0001fff0,   0xcfffff00,   0x00000000,   0x0f0fffff,
   0xffffffff,   0xffffffff,   0x30ffff0c,   0xfffff000,
   0x00000000,   0x00ffffff,   0xffffffff,   0xfffffff3,
   0x0ffff0cf,   0xffff0000,   0x00000000,   0x00ffffff,
   0xffffffff,   0xfffffff3,   0x0ffff0cf,   0xffff0000,
   0x00000000,   0x0fffffff,   0xffffffff,   0xffffff30,
   0xfff70000,   0x000055aa,   0xff000000,   0x000006d5,
   0x40000000,   0x00000000,   0x731c0000,   0x000156ab,
   0xfc000000,   0x00000000,   0xffff0000,   0x00000000,
   0xf0000000,   0x00000000,   0x00ffffff,   0xff3fffff,
   0xffffffff,   0xffcfffff,   0xfff7fbfc,   0x00000000,
   0x00ffffff,   0xff3fffff,   0xffffffff,   0xffcfffff,
   0xfff7fbfc,   0x00000000,   0xffffffff,   0xffffff3f,
   0xffffffff,   0xffffff7f,   0xffffffff,   0xfffffefc,
   0x00000000,   0x00000000,   0xffffffff,   0xffffff3f,
   0xffffffff,   0xffffff7f,   0xffffffff,   0xfffffefc,
   0x00000000,   0x00000000,   0xffffffff,   0xfffff9ff,
   0xfe000000,   0x00000000,   0xffffffff,   0xfffff9ff,
   0xfe000000,   0x00000000,   0x00100000,   0x00000000,
   0xf8000000,   0x00000000,   0x00000000,   0x00000000,
   0x00000000,   0x00000000,   0xffffffff,   0xffffffff,
   0x00ffffff,   0xffffffff,   0x00000000,   0x00000000,
   0x00000000,   0x00000000,   0xffffffff,   0xffffffff,
   },


/* rw_wdfet image  (Image 16)
 * 
 * ctr0 : Counts total number of writeback transactions. 
 * ctr1 : Total number of data valid Runway cycles. 
 * ctr2 : Overflow of Counter 0. 
 * ctr3 : Overflow of Counter 1. 
 */

   {
   0x0c01e000,   0x00000000,   0x00060000,   0x00000000,
   0xefefefef,   0xffffffff,   0xffffffff,   0xffffffff,
   0xffffffff,   0xffffffff,   0xffffffff,   0xffffffff,
   0xffffffff,   0xffffffff,   0xffffff00,   0x00000000,
   0xf0ffffff,   0xffffffff,   0xffffffff,   0xffffffff,
   0xffffffff,   0xffff0000,   0xffffffff,   0xffffffff,
   0xffffffff,   0xffffffff,   0xffffffff,   0xffffffff,
   0xffffffff,   0xffffffff,   0xffffffff,   0xffffffff,
   0xffff0000,   0x00000000,   0x00000000,   0x00000000,
   0x00000000,   0x00000000,   0x00001b00,   0xaa000000,
   0x00000001,   0x30700000,   0x00055aaf,   0xf0000000,
   0x01b00000,   0x00000000,   0x00001037,   0x00000000,
   0x55aaff00,   0x00c00000,   0x1b55aa00,   0x00000000,
   0x0001fff0,   0xcfffff00,   0x00000000,   0x0f0fffff,
   0xffffffff,   0xffffffff,   0x30ffff0c,   0xfffff000,
   0x00000000,   0x00ffffff,   0xffffffff,   0xfffffff3,
   0x0ffff0cf,   0xffff0000,   0x00000000,   0x00ffffff,
   0xffffffff,   0xfffffff3,   0x0ffff0cf,   0xffff0000,
   0x00000000,   0x0fffffff,   0xffffffff,   0xffffff30,
   0xfff70000,   0x000055aa,   0xff000000,   0x000006d5,
   0x40000000,   0x00000000,   0x731c0000,   0x000156ab,
   0xfc000000,   0x00000000,   0xffff0000,   0x00000000,
   0xf0000000,   0x00000000,   0x00ffffff,   0xff3fffff,
   0xffffffff,   0xffcfffff,   0xfff7fbfc,   0x00000000,
   0x00ffffff,   0xff3fffff,   0xffffffff,   0xffcfffff,
   0xfff7fbfc,   0x00000000,   0xffffffff,   0xffffff3f,
   0xffffffff,   0xffffff7f,   0xffffffff,   0xfffffefc,
   0x00000000,   0x00000000,   0xffffffff,   0xffffff3f,
   0xffffffff,   0xffffff7f,   0xffffffff,   0xfffffefc,
   0x00000000,   0x00000000,   0xffffffff,   0xfffff9ff,
   0xfe000000,   0x00000000,   0xffffffff,   0xfffff9ff,
   0xfe000000,   0x00000000,   0x00100000,   0x00000000,
   0x98000000,   0x00000000,   0x00000000,   0x00000000,
   0x00000000,   0x00000000,   0xffffffff,   0xffffffff,
   0x00ffffff,   0xffffffff,   0x00000000,   0x00000000,
   0x00000000,   0x00000000,   0xffffffff,   0xffffffff,
   },

/* shlib_cpi image  (Image 17)
 * 
 * ctr0 : Total number of instructions in quadrant 0. 
 * ctr1 : Total number of CPU clock cycles in quadrant 0. 
 * ctr2 : Total number of Non-Nullified instructions retired. 
 * ctr3 : Total number of CPU clock cycles. 
 *
 * Only works for 32-bit shared libraries.
 */

   {
   0x0c01e000,   0x00000000,   0x00060000,   0x00000000,
   0xe0e0e0e0,   0x00001fff,   0xfc00007f,   0xfff00001,
   0xffffc000,   0x07ffff00,   0x07ffffff,   0x0007ffff,
   0xff0007ff,   0xffff0007,   0xffffff00,   0x00000000,
   0xf0150000,   0x0fffff00,   0x000fffff,   0xffffffff,
   0xffffffff,   0xffff0000,   0x00000000,   0x00ffffff,
   0xffcff000,   0x0000000f,   0xfffffffc,   0xffffffff,
   0xffffffff,   0xffffffff,   0xffffffff,   0xffffffff,
   0xffff0000,   0x00000000,   0x00000000,   0x00000000,
   0x00000000,   0x00000000,   0x27000000,   0x00000055,
   0x02000005,   0x7f500000,   0xc0000000,   0x000ff270,
   0x00000000,   0x00000000,   0x00007700,   0x00000ff0,
   0x00000000,   0x0000ffff,   0xffffffff,   0xffffff00,
   0x00000000,   0x0000ff00,   0x00000000,   0x0f0fffff,
   0xffffffff,   0xfffff000,   0x00000000,   0x000ff000,
   0x00000000,   0x00ffffff,   0xffffffff,   0xffff0000,
   0x00000000,   0x00ff0000,   0x00000000,   0xf0ffffff,
   0xffffffff,   0xffff0000,   0x00000000,   0x00ff0000,
   0x00000000,   0x0fffffff,   0xffffffff,   0xfff00000,
   0x00000000,   0x0ff00000,   0x000000a0,   0x3fffffff,
   0xffffffff,   0xffc00000,   0x03d40000,   0x20000000,
   0x0003fc00,   0x00000000,   0xffff0000,   0x00000000,
   0xf0000000,   0x00000000,   0x00ffffff,   0xff3fffff,
   0xffffffff,   0xffcfffff,   0xfff7fbfc,   0x00000000,
   0x00ffffff,   0xff3fffff,   0xffffffff,   0xffcfffff,
   0xfff7fbfc,   0x00000000,   0xffffffff,   0xffffff3f,
   0xffffffff,   0xffffff7f,   0xffffffff,   0xfffffefc,
   0x00000000,   0x00000000,   0xffffffff,   0xffffff3f,
   0xffffffff,   0xffffff7f,   0xffffffff,   0xfffffefc,
   0x00000000,   0x00000000,   0xffffffff,   0xfffff9ff,
   0xfe000000,   0x00000000,   0xffffffff,   0xfffff9ff,
   0xfe000000,   0x00000000,   0x00030000,   0x00000000,
   0xffffffff,   0xffffffff,   0xffffffff,   0xffffffff,
   0xffffffff,   0xffffffff,   0xffffffff,   0xffffffff,
   0xffffffff,   0xffffffff,   0xffffffff,   0xffffffff,
   0xffffffff,   0xffffffff,   0xffffffff,   0xffffffff,
   },

/* flop image  (Image 18)
 * 
 * ctr0 : Total number of floating point instructions (opcode = 0xc). 
 * ctr1 : Total number of floating point instructions (opcode = 0xe, 0x6, 0x2e, 0x26). 
 * ctr2 : Unused
 * ctr3 : Unused 
 */

   {
   0x0001e000,   0x00000000,   0x00000000,   0x00000000,
   0x00001010,   0x33ffffff,   0x006fffff,   0xfc5fffff,
   0xffffffff,   0xffffffff,   0xffffffff,   0xffffffff,
   0xffffffff,   0xffffffff,   0xffffff00,   0x00000000,
   0xf0ffffff,   0xffffffff,   0xffffffff,   0xffffffff,
   0xffffffff,   0xffff0000,   0xffffffff,   0xffffffff,
   0xffffffff,   0xffffffff,   0xffffffff,   0xffffffff,
   0xffffffff,   0xffffffff,   0xffffffff,   0xffffffff,
   0xffff0000,   0x00000000,   0x00000000,   0x00000000,
   0x00000000,   0x00000000,   0xd22d0000,   0x00000000,
   0x0000000b,   0x46000000,   0x00000000,   0x0ffff900,
   0x90000000,   0x00000000,   0x0000907e,   0x00000000,
   0x000000ff,   0xff00bfdf,   0x03030303,   0x03030000,
   0x000dbfff,   0xffffff00,   0x00000000,   0x000fffff,
   0xffffffff,   0xffffffff,   0xffffffff,   0xfffff000,
   0x00000000,   0x00ffffff,   0xffffffff,   0xffffffff,
   0xffffffff,   0xffff0000,   0x00000000,   0xf0ffffff,
   0xffffffff,   0xffffffff,   0xffffffff,   0xffff0000,
   0x00000000,   0x0fffffff,   0xffffffff,   0xffffffff,
   0xffff5555,   0x55500000,   0x003f3ff0,   0x2766c000,
   0x00000000,   0x00000002,   0x67840000,   0x00000000,
   0x03fffc00,   0x00000000,   0xffff0000,   0x00000000,
   0xf0000000,   0x00000000,   0x00ffffff,   0xff3fffff,
   0xffffffff,   0xffcfffff,   0xfff6fb7c,   0x00000000,
   0x00ffffff,   0xff3fffff,   0xffffffff,   0xffcfffff,
   0xfff6fb7c,   0x00000000,   0xffff0fff,   0xffffff3f,
   0xffffffff,   0xffffff7f,   0xffffffff,   0xfffffefc,
   0x00000000,   0x00000000,   0xffff0fff,   0xffffff3f,
   0xffffffff,   0xffffff7f,   0xffffffff,   0xfffffefc,
   0x00000000,   0x00000000,   0xffffffff,   0xfffff9ff,
   0xfe000000,   0x00000000,   0xffffffff,   0xfffff9ff,
   0xfe000000,   0x00000000,   0x00130000,   0x00000000,
   0xffffffff,   0xffffffff,   0xffffffff,   0xffffffff,
   0xffffffff,   0xffffffff,   0xffffffff,   0xffffffff,
   0xffffffff,   0xffffffff,   0xffffffff,   0xffffffff,
   0xffffffff,   0xffffffff,   0xffffffff,   0xffffffff,
   },

/* cachemiss image    FROM I_D_MISSES.IDF  (Image 19)
 *
 * ctr0 : icache misses for retired instructions
 * ctr1 : total cycles
 * ctr2 : dcache misses for retired instructions
 * ctr3 : number of retired instructions
 */
   {
   0x2801e000,   0x00000000,   0x00010000,   0x00000000, 
   0x00001000,   0xffffffff,   0xffffffff,   0xfff00fff, 
   0xfffa3fff,   0xffffffff,   0xffffffff,   0xffffffff, 
   0xffffffff,   0xffffffff,   0xffffff00,   0x00000000, 
   0xf0ffffff,   0xffffffff,   0xffffffff,   0xffffffff, 
   0xffffffff,   0xffff0000,   0xffffffff,   0xffffffff, 
   0xffffffff,   0xffffffff,   0xffffffff,   0xffffffff, 
   0xffffffff,   0xffffffff,   0xffffffff,   0xffffffff, 
   0xffff0000,   0x00000000,   0x00000000,   0x00000000, 
   0x00000000,   0x00000000,   0xf2fdf0f0,   0xf0f0f0f0, 
   0xffffffff,   0xf6c00000,   0x00000000,   0x0ff55800, 
   0x90000000,   0x00000000,   0x0000b0ff,   0xfffffff0, 
   0x00000003,   0x0100bfff,   0x3f3f3f3f,   0x3f3f5555, 
   0x555fffff,   0xffffff00,   0x00000000,   0x000fffff, 
   0xffffffff,   0xffffffff,   0xffffffff,   0xfffff000, 
   0x00000000,   0x00ffffff,   0xffffffff,   0xffffffff, 
   0xffffffff,   0xffff0000,   0x00000000,   0xf0ffffff, 
   0xffffffff,   0xffffffff,   0xffffffff,   0xffff0000, 
   0x00000000,   0x0fffffff,   0xffffffff,   0xffffffff, 
   0xffffffff,   0xfff00000,   0x000301b0,   0x2fefcfcf, 
   0xcfcfcfcf,   0xd5555557,   0xf7b40000,   0x00000000, 
   0x03c14000,   0x00000000,   0xffff0000,   0x00000000, 
   0xf0000000,   0x00000000,   0x00ffffff,   0xff3fffff, 
   0xffffffff,   0xffcfffff,   0xfff6fb7c,   0x00000000, 
   0x00ffffff,   0xff3fffff,   0xffffffff,   0xffcfffff, 
   0xfff6fb7c,   0x00000000,   0xffff0fff,   0xffffff3f, 
   0xffffffff,   0xffffff7f,   0xffffffff,   0xfffffefc, 
   0x00000000,   0x00000000,   0xffff0fff,   0xffffff3f, 
   0xffffffff,   0xffffff7f,   0xffffffff,   0xfffffefc, 
   0x00000000,   0x00000000,   0xffffffff,   0xfffff9ff, 
   0xfe000000,   0x00000000,   0xffffffff,   0xfffff9ff, 
   0xfe000000,   0x00000000,   0x00130000,   0x00000000, 
   0xffffffff,   0xffffffff,   0xffffffff,   0xffffffff, 
   0xffffffff,   0xffffffff,   0xffffffff,   0xffffffff, 
   0xffffffff,   0xffffffff,   0xffffffff,   0xffffffff, 
   0xffffffff,   0xffffffff,   0xffffffff,   0xffffffff,
   },

/* branch   FROM br_report3.idf 
 *
 * ctr0 : Total number of mispredicted branches. 
 * ctr1 : Some Non-Nullified unpredictable branches. 
 * ctr2 : Total number of branches (Nullified + Non-Nullified)
 *        (Unpredicted+ Predicted Taken +Predicted Not Taken). 
 *	  Total of All Branches.
 * ctr3 : Remaining Non-Nullified unpredictable branches.
 */
   {
   0x4001e000,   0x00000000,   0x00000000,   0x00000000, 
   0x00000000,   0xffffffff,   0xff9fffff,   0xfe0fffff, 
   0xffffbaff,   0xfdffc0ff,   0xfffdffff,   0xfffffeff, 
   0xffffffff,   0xffffffff,   0xffffff00,   0x00000000, 
   0xf4ffffff,   0xffffffff,   0xffffffff,   0xffffffff, 
   0xffffffff,   0xffff0000,   0xffffffff,   0xffffffff, 
   0xffffffff,   0xffffffff,   0xffffffff,   0xffffffff, 
   0xffffffff,   0xffffffff,   0xffffffff,   0xffffffff, 
   0xffff0000,   0x00000000,   0x00000000,   0x00000000, 
   0x00000000,   0x00000000,   0xd22d0000,   0x00000000, 
   0x0000000b,   0x46000000,   0x00000000,   0x0ffff900, 
   0x90000000,   0x00000000,   0x0000907e,   0x00000000, 
   0x000000ff,   0xff00bfdf,   0x03030303,   0x03030000, 
   0x000dbfff,   0xffffff00,   0x00000000,   0x000fffff, 
   0xffffffff,   0xffffffff,   0xffffffff,   0xfffff000, 
   0x00000000,   0x00ffffff,   0xffffffff,   0xffffffff, 
   0xffffffff,   0xffff0000,   0x00000000,   0xf0ffffff, 
   0xffffffff,   0xffffffff,   0xffffffff,   0xffff0000, 
   0x00000000,   0x0fffffff,   0xffffffff,   0xffffffff, 
   0xffff5555,   0x55500000,   0x003f3ff0,   0x2766c000, 
   0x00000000,   0x00000002,   0x67840000,   0x00000000, 
   0x03fffc00,   0x00000000,   0xffff0000,   0x00000000, 
   0xf0000000,   0x00000000,   0x00ffffff,   0xff3fffff, 
   0xffffffff,   0xffcfffff,   0xfff6fb7c,   0x00000000, 
   0x00ffffff,   0xff3fffff,   0xffffffff,   0xffcfffff, 
   0xfff6fb7c,   0x00000000,   0xffff0fff,   0xffffff3f, 
   0xffffffff,   0xffffff7f,   0xffffffff,   0xfffffefc, 
   0x00000000,   0x00000000,   0xffff0fff,   0xffffff3f, 
   0xffffffff,   0xffffff7f,   0xffffffff,   0xfffffefc, 
   0x00000000,   0x00000000,   0xffffffff,   0xfffff9ff, 
   0xfe000000,   0x00000000,   0xffffffff,   0xfffff9ff, 
   0xfe000000,   0x00000000,   0x00130000,   0x00000000, 
   0xffffffff,   0xffffffff,   0xffffffff,   0xffffffff, 
   0xffffffff,   0xffffffff,   0xffffffff,   0xffffffff, 
   0xffffffff,   0xffffffff,   0xffffffff,   0xffffffff, 
   0xffffffff,   0xffffffff,   0xffffffff,   0xffffffff,
   },

/* crstack  FROM crs_report.idf
 *
 * ctr0: correctly predicted branches by the pop_latch
 * ctr1: some procedure returns
 * ctr2: all branches, (includes nullified)
 * ctr3: remaining procedure returns
 */
   {
   0x4001e000,   0x00000000,   0x00000000,   0x00000000, 
   0x00000000,   0xffffffff,   0xffa10300,   0x000fffff, 
   0xffffbaf8,   0x3000007f,   0xffffffff,   0xfffffeff, 
   0xff7fffff,   0xffffffff,   0xffffff00,   0x00000000, 
   0xf2ffffff,   0xffffffff,   0xffffffff,   0xffffffff, 
   0xffffffff,   0xffff0000,   0xffffffff,   0xffffffff, 
   0xffffffff,   0xffffffff,   0xffffffff,   0xffffffff, 
   0xffffffff,   0xffffffff,   0xffffffff,   0xffffffff, 
   0xffff0000,   0x00000000,   0x00000000,   0x00000000, 
   0x00000000,   0x00000000,   0xd22d0000,   0x00000000, 
   0x0000000b,   0x46000000,   0x00000000,   0x0ffff900, 
   0x90000000,   0x00000000,   0x0000907e,   0x00000000, 
   0x000000ff,   0xff00bfdf,   0x03030303,   0x03030000, 
   0x000dbfff,   0xffffff00,   0x00000000,   0x000fffff, 
   0xffffffff,   0xffffffff,   0xffffffff,   0xfffff000, 
   0x00000000,   0x00ffffff,   0xffffffff,   0xffffffff, 
   0xffffffff,   0xffff0000,   0x00000000,   0xf0ffffff, 
   0xffffffff,   0xffffffff,   0xffffffff,   0xffff0000, 
   0x00000000,   0x0fffffff,   0xffffffff,   0xffffffff, 
   0xffff5555,   0x55500000,   0x003f3ff0,   0x2766c000, 
   0x00000000,   0x00000002,   0x67840000,   0x00000000, 
   0x03fffc00,   0x00000000,   0xffff0000,   0x00000000, 
   0xf0000000,   0x00000000,   0x00ffffff,   0xff3fffff, 
   0xffffffff,   0xffcfffff,   0xfff6fb7c,   0x00000000, 
   0x00ffffff,   0xff3fffff,   0xffffffff,   0xffcfffff, 
   0xfff6fb7c,   0x00000000,   0xffff0fff,   0xffffff3f, 
   0xffffffff,   0xffffff7f,   0xffffffff,   0xfffffefc, 
   0x00000000,   0x00000000,   0xffff0fff,   0xffffff3f, 
   0xffffffff,   0xffffff7f,   0xffffffff,   0xfffffefc, 
   0x00000000,   0x00000000,   0xffffffff,   0xfffff9ff, 
   0xfe000000,   0x00000000,   0xffffffff,   0xfffff9ff, 
   0xfe000000,   0x00000000,   0x00130000,   0x00000000, 
   0xffffffff,   0xffffffff,   0xffffffff,   0xffffffff, 
   0xffffffff,   0xffffffff,   0xffffffff,   0xffffffff, 
   0xffffffff,   0xffffffff,   0xffffffff,   0xffffffff, 
   0xffffffff,   0xffffffff,   0xffffffff,   0xffffffff,
   },

/* icache_report image 
 * 
 * ctr0 : Icache misses actually used by the core. 
 * ctr1 : ICORE_AV (Icache misses the core THINKS it needs, including fetching down speculative paths). 
 * ctr2 : READs on Runway (Icache misses that made it out to Runway, including
 *	  prefetches).
 * ctr3 : Prefetch returns (1x and 2x). 
 */
   {
   0x00000000,   0x00000000,   0x00010000,   0x00000000,
   0x00000000,   0xffffffff,   0xffffffff,   0xffffffff,
   0xffffffff,   0xffffffff,   0xffffffff,   0xffffffff,
   0xffffffff,   0xffffffff,   0xffffff00,   0x00000000,
   0x00ffffff,   0xffffffff,   0xffffffff,   0xffffffff,
   0xffffffff,   0xffff0000,   0xffffffff,   0xffffffff,
   0xffffffff,   0xffffffff,   0xffffffff,   0xffffffff,
   0xffffffff,   0xffffffff,   0xffffffff,   0xffffffff,
   0xffff0000,   0x00000000,   0x00000000,   0x00000000,
   0x00000000,   0x00000000,   0xd2002d00,   0x00000000,
   0x0000000b,   0x46000000,   0x0000000f,   0xf00ff900,
   0x00900000,   0x00000000,   0x0000907e,   0x00000000,
   0x0000ff00,   0xff83bf03,   0xdf030303,   0x03030000,
   0x000dbfff,   0xffffff00,   0x00000000,   0x000fffff,
   0xffffffff,   0xffffffff,   0xffffffff,   0xfffff000,
   0x00000000,   0x00ffffff,   0xffffffff,   0xffffffff,
   0xffffffff,   0xffff0000,   0x00000000,   0x80ffffff,
   0xffffffff,   0xffffffff,   0xffffffff,   0xffff0000,
   0x00000000,   0x4fffffff,   0xffffffff,   0xffffffff,
   0xffff5555,   0x55500000,   0x3f003f80,   0x274026c0,
   0x00000000,   0x00000002,   0x67840000,   0x00000003,
   0xfc03fc00,   0x00000000,   0x0eff0000,   0x00000000,
   0x00000000,   0x00000000,   0x00ffffff,   0xff3fffff,
   0xffffffff,   0xffcfffff,   0xfff6fb7c,   0x00000000,
   0x00ffffff,   0xff3fffff,   0xffffffff,   0xffcfffff,
   0xfff6fb7c,   0x00000000,   0xffff0fff,   0xffffff3f,
   0xffffffff,   0xffffff7f,   0xffffffff,   0xfffffefc,
   0x00000000,   0x00000000,   0xffff0fff,   0xffffff3f,
   0xffffffff,   0xffffff7f,   0xffffffff,   0xfffffefc,
   0x00000000,   0x00000000,   0xffffffff,   0xfffff9ff,
   0xfe000000,   0x00000000,   0xffffffff,   0xfffff9ff,
   0xfe000000,   0x00000000,   0x00130000,   0x00000000,
   0xd0ffffff,   0xffffffff,   0xffffffff,   0xffffffff,
   0xffffffff,   0xffffffff,   0xffffffff,   0xffffffff,
   0x00ffffff,   0xffffffff,   0xffffffff,   0xffffffff,
   0xffffffff,   0xffffffff,   0xffffffff,   0xffffffff,
   
   }

};

#endif
