/*
 *  linux/arch/arm/mach-clps711x/mm.c
 *
 *  Generic MM setup for the CLPS711x-based machines.
 *
 *  Copyright (C) 2001 Deep Blue Solutions Ltd
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
#include <linux/sched.h>
#include <linux/mm.h>
#include <linux/init.h>
#include <linux/config.h>
#include <linux/bootmem.h>

#include <asm/hardware.h>
#include <asm/pgtable.h>
#include <asm/page.h>
#include <asm/mach/map.h>
#include <asm/hardware/clps7111.h>

#if 0 //def CONFIG_DISCONTIGMEM
  
/*
 * The assumption of maximum 4 discontiguous memory banks is present
 * in several places in the ARM kernel, including the parameter block
 * (this affects boot loaders, too).  Banks do not necessarily
 * correspond 1:1 with NUMA nodes, although they usually will,
 * especially if they are widely discontiguous.
 *
 *  - note that the parameter block is depreciated for new implementations
 *  - also note that discontig_node_data is actually used
 *    -- rmk 
 */

static bootmem_data_t node_bootmem_data[4];

pg_data_t clps711x_node_data[4] = {
        { bdata: &node_bootmem_data[0] },
        { bdata: &node_bootmem_data[1] },
        { bdata: &node_bootmem_data[2] },
        { bdata: &node_bootmem_data[3] },
};

#endif

/*
 * This maps the generic CLPS711x registers
 */
static struct map_desc clps711x_io_desc[] __initdata = {
 { CLPS7111_VIRT_BASE,	CLPS7111_PHYS_BASE,	1048576, DOMAIN_IO, 0, 1 },
 LAST_DESC
};

void __init clps711x_map_io(void)
{
	iotable_init(clps711x_io_desc);
}
