/* $Id: linux_logo.h,v 1.1 1999/08/19 22:56:34 ralf Exp $
 *
 * include/asm-mips/linux_logo.h: This is a linux logo
 *                                to be displayed on boot.
 *
 * Copyright (C) 1996 Larry Ewing (lewing@isc.tamu.edu)
 * Copyright (C) 1998 Jakub Jelinek (jj@sunsite.mff.cuni.cz)
 *
 * You can put anything here, but:
 * LINUX_LOGO_COLORS has to be less than 224
 * image size has to be 80x80
 * values have to start from 0x20
 * (i.e. RGB(linux_logo_red[0],
 *	     linux_logo_green[0],
 *	     linux_logo_blue[0]) is color 0x20)
 * BW image has to be 80x80 as well, with MS bit
 * on the left
 * Serial_console ascii image can be any size,
 * but should contain %s to display the version
 */
 
#include <linux/init.h>
#include <linux/version.h>

#define linux_logo_banner "Linux/MIPS64 version " UTS_RELEASE

#define LINUX_LOGO_COLORS 212

#ifdef INCLUDE_LINUX_LOGO_DATA

unsigned char linux_logo_red[] __initdata = {
  0x03, 0x82, 0xE9, 0xBF, 0x42, 0xC9, 0x7E, 0xC0,
  0xE9, 0xE3, 0xC2, 0x24, 0xA4, 0x65, 0xEC, 0xC4,
  0x82, 0x9F, 0xF3, 0x12, 0x5F, 0xA0, 0xC2, 0xED,
  0x3E, 0xD5, 0xDB, 0xA0, 0x1C, 0xF4, 0xEB, 0xA4,
  0xCD, 0x0A, 0x9A, 0x51, 0xCC, 0xBE, 0xC0, 0xBA,
  0x74, 0xDC, 0xAA, 0xF6, 0xD3, 0xC5, 0xE6, 0x26,
  0xC2, 0x83, 0x38, 0xEA, 0x49, 0xB0, 0xED, 0xE5,
  0xF4, 0x96, 0x96, 0x1B, 0xFA, 0xCC, 0xF2, 0x0F,
  0xCD, 0xE5, 0xF4, 0xD3, 0x50, 0x7A, 0xB5, 0xDE,
  0xD5, 0xB6, 0x60, 0x0A, 0x6A, 0xEA, 0xD4, 0xEB,
  0xC1, 0xCA, 0xEA, 0xEC, 0x2A, 0x96, 0x95, 0xDC,
  0xE4, 0xCE, 0xEC, 0x1E, 0xDC, 0x8A, 0xD1, 0xF6,
  0x3C, 0x5E, 0xC6, 0xB4, 0xB2, 0xAC, 0xBA, 0x9E,
  0x0F, 0x59, 0xBA, 0xFA, 0xCC, 0xBF, 0x82, 0xCE,
  0xE6, 0x4F, 0xAA, 0x4C, 0xCA, 0x8E, 0x8E, 0xDF,
  0x2C, 0xB6, 0x3B, 0xDE, 0xCE, 0xEE, 0x46, 0x4A,
  0x6F, 0x7A, 0x82, 0xE4, 0xAA, 0x88, 0xE2, 0xCE,
  0xAE, 0xB6, 0x70, 0xC2, 0x9A, 0xDA, 0x35, 0x9E,
  0x95, 0xC0, 0x7E, 0x8C, 0xC2, 0xB6, 0xCE, 0xB9,
  0xD5, 0xAA, 0xC1, 0xF4, 0xC7, 0xB6, 0xB6, 0xA3,
  0xF2, 0x68, 0xDB, 0x76, 0xDC, 0x57, 0xD3, 0xA8,
  0xC0, 0xEF, 0x46, 0xF4, 0x2F, 0xD7, 0x53, 0x36,
  0xE6, 0xA7, 0xCA, 0xCB, 0x7E, 0xE4, 0x86, 0x9A,
  0xCE, 0x94, 0xB4, 0x1D, 0xDA, 0xCE, 0x6C, 0xE6,
  0x9E, 0xC6, 0xDA, 0x16, 0xFA, 0xAA, 0x56, 0xB6,
  0xFE, 0x6E, 0xEA, 0xCE, 0xE5, 0xCC, 0xDB, 0xD3,
  0xED, 0xDC, 0xF4, 0x72
};

unsigned char linux_logo_green[] __initdata = {
  0x03, 0x82, 0xC4, 0x83, 0x42, 0xA2, 0x4A, 0xA4,
  0xE5, 0xA6, 0xC2, 0x24, 0xA4, 0x65, 0xB4, 0x94,
  0x66, 0x87, 0xB6, 0x12, 0x44, 0x6C, 0x96, 0xD4,
  0x36, 0x95, 0xB2, 0x92, 0x0E, 0xF4, 0xBC, 0x77,
  0xA5, 0x0A, 0x92, 0x52, 0xB4, 0x9A, 0x8C, 0xB2,
  0x74, 0xC2, 0x8E, 0xBD, 0xA2, 0xCA, 0xD2, 0x12,
  0xB6, 0x61, 0x24, 0xDA, 0x33, 0x79, 0xCB, 0xAC,
  0xDA, 0x84, 0x7A, 0x1B, 0xFA, 0x8D, 0xBE, 0x06,
  0x93, 0xBB, 0xBC, 0xAB, 0x44, 0x62, 0x83, 0xDA,
  0x9B, 0xA2, 0x4C, 0x04, 0x6A, 0xB6, 0xC8, 0xBD,
  0x8D, 0xB6, 0xAD, 0xEC, 0x2A, 0x68, 0x62, 0x9D,
  0xC4, 0xC4, 0xB4, 0x13, 0xA3, 0x8A, 0xD2, 0xD6,
  0x3C, 0x5D, 0x8C, 0x7E, 0x82, 0xAC, 0x96, 0x7E,
  0x0D, 0x5A, 0xBA, 0xBB, 0xCC, 0xBE, 0x76, 0xB6,
  0xDE, 0x4E, 0x9A, 0x3C, 0xBE, 0x8E, 0x6E, 0xCB,
  0x1C, 0xAA, 0x2E, 0xBE, 0xAA, 0xDE, 0x3E, 0x4B,
  0x4D, 0x7A, 0x54, 0xE4, 0x8E, 0x6E, 0xCA, 0x9B,
  0x70, 0x9E, 0x5A, 0xAA, 0x9A, 0xBE, 0x34, 0x9E,
  0x71, 0x9E, 0x7E, 0x5F, 0xAA, 0x8A, 0xBE, 0x91,
  0xCE, 0x88, 0x92, 0xDB, 0xC6, 0xAB, 0x8A, 0x72,
  0xE2, 0x44, 0xC3, 0x54, 0xAA, 0x45, 0xBB, 0x92,
  0xBA, 0xC4, 0x46, 0xCA, 0x2D, 0xD6, 0x3B, 0x1A,
  0xC2, 0x7E, 0xA6, 0xCB, 0x7A, 0xDC, 0x86, 0x72,
  0xB6, 0x94, 0xB4, 0x1C, 0xBC, 0xAE, 0x4C, 0xD6,
  0x62, 0x86, 0xD3, 0x16, 0xF6, 0x7A, 0x55, 0x79,
  0xFE, 0x6E, 0xC6, 0xC6, 0xAA, 0x93, 0xDC, 0x9D,
  0xAE, 0xA4, 0xD4, 0x56
};

unsigned char linux_logo_blue[] __initdata = {
  0x04, 0x84, 0x10, 0x0C, 0x41, 0x14, 0x04, 0x78,
  0xC7, 0x0E, 0xC4, 0x24, 0xA4, 0x64, 0x0C, 0x0D,
  0x17, 0x24, 0x0D, 0x13, 0x11, 0x07, 0x40, 0x22,
  0x0C, 0x0C, 0x11, 0x78, 0x06, 0xF4, 0x0B, 0x0A,
  0x47, 0x0B, 0x7C, 0x54, 0x6C, 0x0C, 0x0D, 0x9C,
  0x73, 0x54, 0x14, 0x0C, 0x0F, 0xC7, 0x94, 0x04,
  0x94, 0x17, 0x0A, 0x6C, 0x08, 0x0F, 0x14, 0x0B,
  0x12, 0x68, 0x28, 0x11, 0xFA, 0x0A, 0x34, 0x09,
  0x0A, 0x2F, 0x15, 0x19, 0x14, 0x3C, 0x06, 0xC4,
  0x0B, 0x84, 0x24, 0x08, 0x69, 0x38, 0xBC, 0x15,
  0x1F, 0xA0, 0x0A, 0xEC, 0x2A, 0x0C, 0x0C, 0x0C,
  0x2C, 0xA0, 0x15, 0x07, 0x0B, 0x8C, 0xD3, 0x10,
  0x3B, 0x5C, 0x0C, 0x04, 0x3C, 0xAC, 0x54, 0x1C,
  0x0B, 0x5B, 0xBB, 0x0A, 0xC1, 0xBB, 0x5C, 0x3C,
  0xBC, 0x4D, 0x74, 0x10, 0x8C, 0x8C, 0x14, 0x91,
  0x0C, 0x74, 0x17, 0x0C, 0x48, 0x9C, 0x3C, 0x4C,
  0x09, 0x7C, 0x05, 0xE4, 0x34, 0x38, 0x6C, 0x11,
  0x08, 0x7C, 0x18, 0x2C, 0x9C, 0x4C, 0x34, 0x9C,
  0x29, 0x54, 0x7C, 0x0C, 0x78, 0x18, 0x9C, 0x14,
  0xBA, 0x30, 0x27, 0x31, 0xC2, 0x97, 0x24, 0x09,
  0xB4, 0x04, 0x87, 0x0C, 0x14, 0x1F, 0x7C, 0x64,
  0xB0, 0x0F, 0x45, 0x10, 0x2C, 0xD4, 0x0A, 0x04,
  0x44, 0x1F, 0x2C, 0xCC, 0x7C, 0xD8, 0x84, 0x0C,
  0x8C, 0x94, 0xB4, 0x1D, 0x20, 0x5C, 0x18, 0xB4,
  0x04, 0x09, 0xBC, 0x14, 0xF4, 0x08, 0x54, 0x07,
  0xFC, 0x6C, 0x24, 0xB4, 0x15, 0x18, 0xDB, 0x17,
  0x17, 0x18, 0x21, 0x24
};

unsigned char linux_logo[] __initdata = {
  0xBC, 0xAC, 0x7D, 0x95, 0xAF, 0x85, 0x2C, 0x2C,
  0xAC, 0xD9, 0x95, 0x7D, 0x95, 0xAC, 0x2C, 0xAF,
  0x7D, 0x48, 0xB2, 0xAC, 0x85, 0xDA, 0xDA, 0x2C,
  0x7D, 0x48, 0x21, 0x2C, 0x8D, 0x2A, 0x8A, 0xDA,
  0x85, 0x2C, 0xD9, 0xAC, 0x2C, 0x2C, 0xD9, 0xD9,
  0xAF, 0x85, 0x85, 0x85, 0x8D, 0xBC, 0x2A, 0x2A,
  0xBC, 0x8C, 0xBC, 0xAC, 0x7D, 0x95, 0xAF, 0x85,
  0x2C, 0x2C, 0xAC, 0xD9, 0x95, 0x7D, 0x95, 0xAC,
  0x2C, 0xAF, 0x7D, 0x48, 0xB2, 0xAC, 0x85, 0xDA,
  0xDA, 0x2C, 0x7D, 0x48, 0x21, 0x2C, 0x8D, 0x2A,
  0xAF, 0xA1, 0x48, 0x7D, 0xAF, 0x2C, 0x2C, 0xAC,
  0xD9, 0xD9, 0x95, 0x7D, 0x95, 0xAC, 0xD9, 0x7D,
  0x48, 0xE9, 0x21, 0xAF, 0xDA, 0xDA, 0x85, 0x2C,
  0xD9, 0xD9, 0xAC, 0xDA, 0x8A, 0xDA, 0x85, 0x2C,
  0x2C, 0xAC, 0xD9, 0xAC, 0xAF, 0xAF, 0x2C, 0x2C,
  0x2C, 0x85, 0x2C, 0x2C, 0x85, 0xDA, 0xDA, 0xDA,
  0xDA, 0xDA, 0xAF, 0xA1, 0x48, 0x7D, 0xAF, 0x2C,
  0x2C, 0xAC, 0xD9, 0xD9, 0x95, 0x7D, 0x95, 0xAC,
  0xD9, 0x7D, 0x48, 0xE9, 0x21, 0xAF, 0xDA, 0xDA,
  0x85, 0x2C, 0xD9, 0xD9, 0xAC, 0xDA, 0x8A, 0xDA,
  0x7D, 0x48, 0x48, 0x7D, 0x2C, 0x85, 0x2C, 0xAF,
  0xD9, 0xD9, 0x7D, 0x95, 0xD9, 0xD9, 0xD9, 0x7D,
  0xB2, 0x21, 0xD9, 0x85, 0xDA, 0xDA, 0x85, 0x2C,
  0xAF, 0x2C, 0x2C, 0xDA, 0x85, 0x85, 0x2C, 0x2C,
  0xAC, 0xD9, 0xD9, 0xAF, 0xDA, 0x85, 0x2C, 0x2C,
  0x85, 0xDA, 0xDA, 0x85, 0x85, 0xDA, 0x85, 0x85,
  0x85, 0xAF, 0x7D, 0x48, 0x48, 0x7D, 0x2C, 0x85,
  0x2C, 0xAF, 0xD9, 0xD9, 0x7D, 0x95, 0xD9, 0xD9,
  0xD9, 0x7D, 0xB2, 0x21, 0xD9, 0x85, 0xDA, 0xDA,
  0x85, 0x2C, 0xAF, 0x2C, 0x2C, 0xDA, 0xDA, 0x85,
  0xA1, 0xE9, 0x48, 0x95, 0x85, 0xDA, 0x85, 0xAF,
  0xD9, 0xD9, 0x95, 0x95, 0xD9, 0xD9, 0x95, 0x95,
  0xD9, 0xAC, 0x85, 0x85, 0xDA, 0xDA, 0x85, 0x2C,
  0xAC, 0xAC, 0x2C, 0x2C, 0x85, 0x2C, 0x2C, 0xAC,
  0xD9, 0xD9, 0x2C, 0x91, 0x41, 0x20, 0x6B, 0x20,
  0x6B, 0x20, 0x6B, 0xAE, 0x2C, 0x85, 0x2C, 0x2C,
  0xAC, 0xD9, 0xA1, 0xE9, 0x48, 0x95, 0x85, 0xDA,
  0x85, 0xAF, 0xD9, 0xD9, 0x95, 0x95, 0xD9, 0xD9,
  0x95, 0x95, 0xD9, 0xAC, 0x85, 0x85, 0xDA, 0xDA,
  0x85, 0x2C, 0xAC, 0xAC, 0x2C, 0x2C, 0x2C, 0x2C,
  0xA1, 0xA1, 0xD6, 0xAF, 0xDA, 0xDA, 0x85, 0x2C,
  0xD9, 0xD9, 0x95, 0x95, 0xD9, 0xD9, 0xD9, 0xD9,
  0x2C, 0x2C, 0xDA, 0xDA, 0xDA, 0x85, 0x2C, 0xD9,
  0xD9, 0xD9, 0xD9, 0xAC, 0xAC, 0xAC, 0xAF, 0xAC,
  0x2C, 0xB2, 0x88, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x6B, 0x80, 0x85, 0x2C,
  0xD9, 0xD6, 0xA1, 0xA1, 0xD6, 0xAF, 0xDA, 0xDA,
  0x85, 0x2C, 0xD9, 0xD9, 0x95, 0x95, 0xD9, 0xD9,
  0xD9, 0xD9, 0x2C, 0x2C, 0xDA, 0xDA, 0xDA, 0x85,
  0x2C, 0xD9, 0xD9, 0xD9, 0xD9, 0xAF, 0xAF, 0xAF,
  0xD6, 0xD6, 0xD9, 0x2C, 0xDA, 0xDA, 0x2C, 0xAC,
  0xD9, 0x7D, 0x95, 0xD9, 0xD9, 0xD9, 0xAF, 0x2C,
  0x85, 0x85, 0x85, 0x85, 0x2C, 0x2C, 0xAC, 0xD9,
  0xD9, 0xD9, 0xAF, 0xAF, 0x2C, 0x2C, 0xAF, 0xDA,
  0xAE, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x41, 0xE3, 0x20, 0x6B, 0x48,
  0xAC, 0x95, 0xD6, 0xD6, 0xD9, 0x2C, 0xDA, 0xDA,
  0x2C, 0xAC, 0xD9, 0x7D, 0x95, 0xD9, 0xD9, 0xD9,
  0xAF, 0x2C, 0x85, 0x85, 0x85, 0x85, 0x2C, 0x2C,
  0xAC, 0xD9, 0xD9, 0xD9, 0xAF, 0xAF, 0xAF, 0xAF,
  0xD9, 0xD9, 0xD9, 0x2C, 0x85, 0x85, 0x2C, 0xD9,
  0x7D, 0x21, 0xD6, 0xD9, 0xAF, 0x2C, 0x85, 0x85,
  0x85, 0x85, 0x85, 0x85, 0x2C, 0xAF, 0xAF, 0xAC,
  0xAF, 0x2C, 0x2C, 0x2C, 0x2C, 0x2C, 0x2C, 0x89,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x74, 0x43, 0x80, 0x41, 0x20,
  0x9F, 0x2C, 0xD9, 0xD9, 0xD9, 0x2C, 0x85, 0x85,
  0x2C, 0xD9, 0x7D, 0x21, 0xD6, 0xD9, 0xAF, 0x2C,
  0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x2C, 0xAF,
  0xAF, 0xAC, 0xAF, 0x2C, 0x2C, 0x2C, 0x2C, 0x2C,
  0xD9, 0x7D, 0xD9, 0xAF, 0x85, 0x85, 0x2C, 0xD9,
  0xB2, 0x21, 0x7D, 0xD9, 0xAF, 0x2C, 0x85, 0x85,
  0x85, 0x2C, 0x2C, 0x2C, 0x2C, 0xAF, 0xAF, 0xAC,
  0xAF, 0xAC, 0xAF, 0xAF, 0xAC, 0xAC, 0x85, 0x41,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0xAE, 0x48, 0x89, 0x74, 0x41,
  0x6B, 0xD6, 0xD9, 0x7D, 0xD9, 0xAF, 0x85, 0x85,
  0x2C, 0xD9, 0xB2, 0x21, 0x7D, 0xD9, 0xAF, 0x2C,
  0x85, 0x85, 0x85, 0x2C, 0x2C, 0x2C, 0x2C, 0xAF,
  0xAF, 0xAC, 0xAF, 0xAC, 0xAC, 0x2C, 0xAF, 0xAC,
  0x2C, 0x7D, 0xD9, 0x2C, 0xDA, 0x85, 0x2C, 0x7D,
  0xB2, 0xD6, 0xD9, 0xAF, 0x85, 0x85, 0x85, 0x85,
  0xAF, 0xAC, 0xAC, 0xAF, 0xAF, 0xAC, 0xAC, 0xD9,
  0x95, 0x7D, 0x95, 0x95, 0xD9, 0xD9, 0x48, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x6B, 0xAE, 0xE6, 0x80, 0x2B, 0x88,
  0x20, 0x33, 0xDA, 0x95, 0xD9, 0x2C, 0xDA, 0x85,
  0x2C, 0x7D, 0xB2, 0xD6, 0xD9, 0xAF, 0x85, 0x85,
  0x85, 0x85, 0xAF, 0xAC, 0xAC, 0xAF, 0xAF, 0xAC,
  0xAC, 0xD9, 0x95, 0x95, 0x7D, 0x95, 0x95, 0xD9,
  0x85, 0xD9, 0x2C, 0x85, 0xDA, 0xDA, 0xD9, 0x21,
  0xA1, 0xD9, 0xAF, 0x2C, 0x85, 0xDA, 0x85, 0xAF,
  0xD9, 0xD9, 0xAC, 0xAC, 0xAC, 0xD9, 0x7D, 0xD6,
  0xD6, 0x7D, 0x95, 0xD9, 0xD9, 0x85, 0xDB, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0xDB, 0xE3, 0x6B, 0x20, 0x20,
  0x20, 0x20, 0xE9, 0xD9, 0x2C, 0x85, 0xDA, 0xDA,
  0xD9, 0x21, 0xA1, 0xD9, 0xAF, 0x2C, 0x85, 0xDA,
  0x85, 0xAF, 0xD9, 0xD9, 0xAC, 0xAC, 0xAC, 0xD9,
  0x7D, 0xD6, 0xD6, 0x7D, 0x95, 0xD9, 0xD9, 0xD9,
  0xDA, 0x2C, 0x85, 0xDA, 0xDA, 0x85, 0x95, 0x21,
  0x21, 0xD9, 0x85, 0x85, 0x85, 0x2C, 0x2C, 0xD9,
  0x95, 0x95, 0xD9, 0xD9, 0xD9, 0xD9, 0xD9, 0xD9,
  0xAC, 0xAC, 0x2C, 0xAF, 0x2C, 0x85, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x88, 0xDA, 0x85, 0xDA, 0xDA, 0x85,
  0x95, 0x21, 0x21, 0xD9, 0x85, 0x85, 0x85, 0x2C,
  0x2C, 0xD9, 0x95, 0x95, 0xD9, 0xD9, 0xD9, 0xD9,
  0xD9, 0xD9, 0xD9, 0xAF, 0x2C, 0x2C, 0x2C, 0x2C,
  0xDA, 0x2C, 0x85, 0x85, 0x2C, 0xD9, 0xD6, 0xB2,
  0x95, 0x2C, 0x85, 0x85, 0xAF, 0xAC, 0x95, 0x95,
  0x7D, 0xD9, 0xD9, 0xD9, 0xD9, 0xD9, 0x2C, 0x85,
  0x85, 0x85, 0x85, 0x85, 0x85, 0xAC, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0xAC, 0x85, 0x85, 0x2C, 0xD9,
  0xD6, 0xB2, 0x95, 0x2C, 0x85, 0x85, 0xAF, 0xAC,
  0x95, 0x95, 0x7D, 0xD9, 0xD9, 0xD9, 0xD9, 0xD9,
  0x2C, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85,
  0x85, 0x2C, 0x2C, 0x2C, 0xAC, 0x95, 0xD6, 0x7D,
  0xD9, 0x2C, 0x2C, 0xAF, 0x95, 0x7D, 0x7D, 0x95,
  0x95, 0xD9, 0xD9, 0x95, 0xD9, 0xD9, 0x2C, 0x85,
  0xDA, 0xDA, 0xDA, 0x85, 0x85, 0x21, 0x20, 0x20,
  0x6B, 0x41, 0xDB, 0x6B, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x41, 0xDB, 0xDB, 0x20, 0x20,
  0x20, 0x20, 0x20, 0xE6, 0x2C, 0x2C, 0xAC, 0x95,
  0xD6, 0x7D, 0xD9, 0x2C, 0x2C, 0xAF, 0x95, 0x7D,
  0x7D, 0x95, 0x95, 0xD9, 0xD9, 0x95, 0xD9, 0xD9,
  0x2C, 0x85, 0xDA, 0xDA, 0xDA, 0x85, 0x2C, 0x2C,
  0x2C, 0xAF, 0xAC, 0xD9, 0x95, 0xD6, 0xD6, 0xD9,
  0x2C, 0x2C, 0x2C, 0xD9, 0xD6, 0xD6, 0xD9, 0xAF,
  0xAC, 0x95, 0xD6, 0x7D, 0x7D, 0xD9, 0x2C, 0x85,
  0xDA, 0xDA, 0x2C, 0xAF, 0xAF, 0x21, 0x20, 0x20,
  0x88, 0x2B, 0x88, 0x74, 0x20, 0x20, 0x20, 0x20,
  0x20, 0xAE, 0x2D, 0x2D, 0x74, 0x74, 0x88, 0x20,
  0x20, 0x20, 0x20, 0x80, 0xAC, 0xD9, 0x95, 0xD6,
  0xD6, 0xD9, 0x2C, 0x2C, 0x2C, 0xD9, 0xD6, 0xD6,
  0xD9, 0xAF, 0xAC, 0x95, 0xD6, 0x7D, 0x7D, 0xD9,
  0x2C, 0xDA, 0xDA, 0x85, 0x2C, 0xAF, 0xAF, 0xAF,
  0x2C, 0xAF, 0xD9, 0x95, 0xD6, 0xD6, 0x95, 0xAF,
  0x2C, 0x2C, 0xD9, 0x95, 0xD6, 0x95, 0xAF, 0x2C,
  0xAC, 0x7D, 0x21, 0x95, 0xD9, 0x2C, 0x85, 0x85,
  0x85, 0xAF, 0xD9, 0x95, 0xD9, 0x7D, 0x20, 0x33,
  0x7D, 0x8A, 0x7D, 0x5B, 0x6B, 0x20, 0x20, 0x6B,
  0xE6, 0xD9, 0x85, 0x2A, 0xDA, 0x2B, 0x41, 0x20,
  0x20, 0x20, 0x6B, 0x74, 0xD9, 0x95, 0xD6, 0xD6,
  0x95, 0xAF, 0x2C, 0x2C, 0xD9, 0x95, 0xD6, 0x95,
  0xAF, 0x2C, 0xAC, 0x7D, 0x21, 0x95, 0xD9, 0x2C,
  0x85, 0x85, 0x85, 0x2C, 0xD9, 0xD9, 0xD9, 0xD9,
  0x85, 0xD9, 0x7D, 0x21, 0x21, 0x7D, 0xAC, 0x2C,
  0x2C, 0xAC, 0xD9, 0x7D, 0xD9, 0xAF, 0x2C, 0x85,
  0xAC, 0x7D, 0x7D, 0xAC, 0x85, 0xDA, 0x8A, 0xDA,
  0x85, 0xAF, 0xD9, 0x7D, 0xD9, 0x95, 0x20, 0x91,
  0xBC, 0x73, 0xEE, 0x7D, 0x20, 0x20, 0x20, 0x80,
  0x4D, 0x3D, 0x73, 0x73, 0xA3, 0xD6, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x2B, 0x7D, 0x21, 0x21, 0x7D,
  0xAC, 0x2C, 0x2C, 0xAC, 0xD9, 0x7D, 0xD9, 0xAF,
  0x2C, 0x85, 0xAC, 0x7D, 0x7D, 0xAC, 0x85, 0xDA,
  0x8A, 0x8A, 0x85, 0xAC, 0xD9, 0x7D, 0xD9, 0xAC,
  0x2C, 0xD9, 0xD6, 0xB2, 0xB2, 0x7D, 0xAF, 0x85,
  0x2C, 0xD9, 0x95, 0x95, 0xAF, 0x2C, 0x2C, 0x2C,
  0xD9, 0xD9, 0xAC, 0x85, 0x8D, 0x2A, 0x2A, 0xDA,
  0xAF, 0xD9, 0x95, 0x95, 0xD9, 0xAC, 0x20, 0xAF,
  0x2C, 0xE6, 0x8D, 0x73, 0xE3, 0x20, 0x20, 0x48,
  0x5C, 0xDA, 0x5B, 0x43, 0xBC, 0x73, 0x2B, 0x20,
  0x20, 0x20, 0x20, 0x41, 0xD6, 0xB2, 0xB2, 0x7D,
  0xAF, 0x85, 0x2C, 0xD9, 0x95, 0x95, 0xAF, 0x2C,
  0x2C, 0x2C, 0xD9, 0xD9, 0xAC, 0x85, 0x8A, 0x2A,
  0x8D, 0xDA, 0xAF, 0xD9, 0x95, 0x95, 0xD9, 0xAF,
  0xAC, 0xD9, 0xD6, 0xB2, 0x21, 0xD9, 0x2C, 0x85,
  0x2C, 0xD9, 0x95, 0xD9, 0xAF, 0x2C, 0x2C, 0xAC,
  0xAC, 0xAF, 0x85, 0x8D, 0xBC, 0xBC, 0xDA, 0xD9,
  0xD6, 0xA1, 0xA1, 0x21, 0xD9, 0xAC, 0x20, 0x2A,
  0xCC, 0xAE, 0x9F, 0xE4, 0xAE, 0x5B, 0x74, 0xA1,
  0xE4, 0xAE, 0x20, 0x9F, 0x89, 0xE8, 0xE6, 0x20,
  0x20, 0x20, 0x20, 0x41, 0xD6, 0xB2, 0x21, 0xD9,
  0x2C, 0x85, 0x2C, 0xD9, 0x95, 0xD9, 0xAF, 0x2C,
  0x2C, 0xAC, 0xAC, 0xAF, 0x85, 0x8D, 0xBC, 0x2A,
  0xDA, 0xD9, 0xD6, 0xA1, 0xA1, 0x21, 0xD9, 0xD9,
  0xD9, 0x95, 0x21, 0xA1, 0x21, 0xAC, 0x85, 0x85,
  0xAC, 0xD9, 0xD9, 0xAF, 0x2C, 0x2C, 0xAF, 0xAC,
  0xAF, 0x85, 0x8A, 0x2A, 0x2A, 0xDA, 0xD9, 0xA1,
  0x48, 0xE9, 0x48, 0x21, 0x95, 0xAC, 0x20, 0x2A,
  0xDB, 0x41, 0x74, 0xBC, 0x2B, 0x7B, 0x7B, 0x80,
  0x73, 0x41, 0x20, 0x6B, 0x2B, 0xE8, 0x2D, 0x20,
  0x20, 0x20, 0x20, 0x33, 0x21, 0xA1, 0x21, 0xAC,
  0x85, 0x85, 0xAC, 0xD9, 0xD9, 0xAF, 0x2C, 0x2C,
  0xAF, 0xAC, 0xAF, 0x85, 0x8A, 0xBC, 0x2A, 0xDA,
  0xD9, 0xA1, 0x48, 0xE9, 0x48, 0x21, 0xD9, 0xD9,
  0xA1, 0xB2, 0xB2, 0x48, 0xD6, 0xAC, 0x2C, 0x2C,
  0xD9, 0x95, 0xAF, 0x2C, 0x2C, 0x2C, 0x2C, 0x2C,
  0x85, 0x8A, 0x8D, 0x8D, 0x85, 0x95, 0xA1, 0x6C,
  0x6C, 0x48, 0xD6, 0xD9, 0x2C, 0x85, 0x20, 0x2C,
  0x89, 0x20, 0x3C, 0xB9, 0xA7, 0x63, 0xD2, 0xB9,
  0xC6, 0x9A, 0x20, 0x20, 0x43, 0x5C, 0xE6, 0x20,
  0x20, 0x20, 0x20, 0x33, 0xB2, 0x48, 0xD6, 0xAC,
  0x2C, 0x2C, 0xD9, 0x95, 0xAF, 0x2C, 0x2C, 0x2C,
  0x2C, 0x2C, 0x85, 0x8A, 0x8D, 0x8D, 0x85, 0x95,
  0xA1, 0x6C, 0x6C, 0x48, 0xD6, 0xD9, 0xAF, 0xAC,
  0xA1, 0xD6, 0x7D, 0xB2, 0xD6, 0xAF, 0x85, 0x85,
  0xD9, 0x95, 0x2C, 0x85, 0xDA, 0x85, 0x85, 0x2C,
  0x85, 0x8A, 0x8D, 0xDA, 0xD9, 0x48, 0x81, 0x2D,
  0x48, 0xD6, 0xD9, 0xAC, 0x2C, 0x85, 0x20, 0x2D,
  0xEE, 0x93, 0xD1, 0xA7, 0x3E, 0x3E, 0x3A, 0x25,
  0x56, 0xAB, 0xAA, 0xC5, 0xEE, 0xEE, 0x33, 0x20,
  0x20, 0x20, 0x20, 0x41, 0xD9, 0xB2, 0xD6, 0xAF,
  0x85, 0x85, 0xD9, 0x95, 0x2C, 0x85, 0xDA, 0x85,
  0x85, 0x2C, 0x85, 0x8A, 0x8D, 0xDA, 0xD9, 0x48,
  0x81, 0x2D, 0x48, 0xD6, 0xD9, 0xAF, 0x2C, 0x2C,
  0xAC, 0xAF, 0xD9, 0x7D, 0xD6, 0x2C, 0x85, 0x2C,
  0xD9, 0xD9, 0x2C, 0xDA, 0xDA, 0xDA, 0x2C, 0x2C,
  0x85, 0x8D, 0x8D, 0x2C, 0x21, 0x2D, 0x2D, 0xE9,
  0xD6, 0xD9, 0xAF, 0x2C, 0x85, 0xDA, 0x20, 0xE3,
  0xB4, 0xBE, 0xF1, 0x3E, 0x9B, 0x22, 0x56, 0xF2,
  0xBB, 0x7F, 0x56, 0xDC, 0x8F, 0x5A, 0x5F, 0x20,
  0x20, 0x20, 0x20, 0x6B, 0x2C, 0x7D, 0xD6, 0x2C,
  0x85, 0x2C, 0xD9, 0xD9, 0x2C, 0xDA, 0xDA, 0xDA,
  0x2C, 0x2C, 0x85, 0x8D, 0x8A, 0x85, 0x21, 0x2D,
  0x2D, 0xE9, 0xD6, 0xD9, 0xAF, 0x2C, 0x85, 0x85,
  0x2A, 0x85, 0xAC, 0x95, 0x95, 0x2C, 0x85, 0x85,
  0xAC, 0xAF, 0x85, 0xDA, 0xDA, 0x85, 0x2C, 0x2C,
  0xDA, 0x8A, 0x8A, 0xAF, 0xA1, 0x2D, 0xE9, 0xD6,
  0xD9, 0xAC, 0x85, 0x85, 0x85, 0xDA, 0x20, 0x52,
  0x55, 0xED, 0x57, 0x3E, 0x22, 0x56, 0x37, 0xBB,
  0xBB, 0x58, 0x7F, 0x7F, 0x56, 0x5E, 0xC5, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x2C, 0x95, 0x95, 0x2C,
  0x85, 0x85, 0xAC, 0xAF, 0x85, 0xDA, 0xDA, 0x85,
  0x2C, 0x2C, 0xDA, 0x8D, 0xDA, 0xAF, 0xA1, 0x2D,
  0xE9, 0xD6, 0xD9, 0xAF, 0x2C, 0x85, 0x85, 0x85,
  0xCD, 0xAF, 0xD9, 0x95, 0xD9, 0x2C, 0xDA, 0x85,
  0xAF, 0xD9, 0x85, 0xDA, 0x85, 0x2C, 0xAC, 0xAF,
  0x85, 0x8A, 0x85, 0xD9, 0x48, 0x48, 0xB2, 0x95,
  0x95, 0xAC, 0x2C, 0x85, 0xDA, 0xDA, 0x6B, 0xB3,
  0x46, 0x7C, 0x2E, 0x9B, 0x22, 0x56, 0xBB, 0x37,
  0x58, 0x58, 0xF2, 0x3A, 0x46, 0x63, 0x64, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x2D, 0x95, 0xD9, 0x2C,
  0xDA, 0x85, 0xAF, 0xD9, 0x85, 0xDA, 0x85, 0x2C,
  0xAC, 0xAF, 0x85, 0xDA, 0x85, 0xD9, 0x48, 0x48,
  0xB2, 0x95, 0x95, 0xD9, 0x85, 0xDA, 0x85, 0x85,
  0xBC, 0xB2, 0xB2, 0x7D, 0xD9, 0x2C, 0xDA, 0x85,
  0xAF, 0xD9, 0x85, 0xDA, 0x85, 0x85, 0xAF, 0x2C,
  0x85, 0xDA, 0x2C, 0x7D, 0xA1, 0x48, 0xB2, 0x21,
  0xD6, 0xD9, 0x85, 0xDA, 0x85, 0xDA, 0x41, 0x51,
  0xB7, 0xEC, 0x2E, 0x22, 0x56, 0x37, 0xBB, 0xF2,
  0x37, 0xEA, 0x2F, 0x2F, 0x77, 0xA7, 0x38, 0x20,
  0x20, 0x6B, 0x20, 0x20, 0x5B, 0x2C, 0xD9, 0x2C,
  0xDA, 0x85, 0xAF, 0xD9, 0x85, 0xDA, 0x85, 0x85,
  0xAF, 0x2C, 0xDA, 0xDA, 0x2C, 0x7D, 0xA1, 0x48,
  0xB2, 0x21, 0xD6, 0xD9, 0x2C, 0xDA, 0x85, 0xAF,
  0x2C, 0x2D, 0x48, 0x7D, 0xAF, 0x2C, 0x85, 0x2C,
  0xD9, 0xAC, 0xAF, 0x85, 0x85, 0x2C, 0x2C, 0x2C,
  0x85, 0x2C, 0xD9, 0xD6, 0xA1, 0xA1, 0x48, 0xA1,
  0x21, 0x2C, 0xDA, 0xDA, 0x2C, 0x85, 0x41, 0x98,
  0xA2, 0xA7, 0x6F, 0xC9, 0x37, 0xF2, 0xF2, 0x9B,
  0xB7, 0x66, 0x60, 0x4C, 0xED, 0x84, 0x3C, 0x20,
  0x5B, 0x2D, 0x2B, 0x6B, 0x20, 0xAF, 0xAF, 0x2C,
  0x85, 0x2C, 0xD9, 0xAC, 0xAF, 0x85, 0x85, 0x2C,
  0x2C, 0x2C, 0x2C, 0x85, 0xD9, 0xD6, 0xA1, 0xA1,
  0x48, 0xA1, 0xD6, 0xAF, 0xDA, 0x8A, 0x2C, 0xD9,
  0xB2, 0x2D, 0x48, 0x95, 0x2C, 0x2C, 0x2C, 0x85,
  0xAC, 0xAC, 0xAF, 0x85, 0xDA, 0x85, 0xAF, 0xAC,
  0xAF, 0x2C, 0xD9, 0xD6, 0xD6, 0xD6, 0x21, 0xD6,
  0xD9, 0xDA, 0x8D, 0xDA, 0xAF, 0x2C, 0x20, 0x88,
  0x42, 0x51, 0x3F, 0x2F, 0x45, 0xB7, 0x66, 0x55,
  0x46, 0x60, 0x5D, 0x36, 0xD8, 0x71, 0x43, 0x20,
  0x20, 0x2D, 0xB2, 0x80, 0x20, 0x2D, 0x2C, 0x2C,
  0x2C, 0x85, 0xAC, 0xAC, 0xAF, 0x85, 0xDA, 0x85,
  0xAF, 0xAC, 0xAC, 0xAF, 0xD9, 0xD6, 0xD6, 0xD6,
  0x21, 0xD6, 0xD9, 0xDA, 0x8D, 0x8A, 0x2C, 0xD9,
  0xB2, 0x48, 0xD6, 0xAC, 0xAF, 0x2C, 0x2C, 0x85,
  0x2C, 0xAC, 0x2C, 0xDA, 0xDA, 0x85, 0xAF, 0xD9,
  0xD9, 0xAC, 0xD9, 0xD9, 0xD9, 0xD9, 0xD9, 0xAC,
  0x85, 0x8D, 0xBC, 0xDA, 0xD9, 0xDA, 0x20, 0xE3,
  0xDA, 0x69, 0x96, 0xB5, 0xF1, 0x68, 0x5D, 0x82,
  0xE1, 0xBE, 0x27, 0x8D, 0x4D, 0xD3, 0x7D, 0x20,
  0x20, 0xDB, 0xA1, 0xCA, 0x20, 0x88, 0x85, 0x2C,
  0x2C, 0x85, 0x2C, 0xAC, 0x2C, 0xDA, 0xDA, 0x85,
  0xAF, 0xD9, 0xAC, 0xAF, 0xD9, 0xD9, 0xD9, 0xD9,
  0xD9, 0xAC, 0xDA, 0x8D, 0xBC, 0xDA, 0xD9, 0x95,
  0xD9, 0x95, 0xAC, 0x2C, 0x2C, 0x2C, 0x2C, 0x85,
  0x85, 0xAF, 0xAF, 0x85, 0x85, 0x2C, 0x2C, 0xAC,
  0xD9, 0xAC, 0xAF, 0x2C, 0x2C, 0x2C, 0x2C, 0x85,
  0x8D, 0x2A, 0x2A, 0x85, 0xD9, 0x95, 0x20, 0xDB,
  0x8D, 0x8D, 0x99, 0xB0, 0x35, 0xE5, 0x3F, 0x35,
  0xB9, 0x50, 0x8A, 0x4D, 0x73, 0xE8, 0xA3, 0xCC,
  0x20, 0x20, 0x33, 0x6B, 0x20, 0x20, 0xCC, 0x85,
  0x2C, 0x85, 0x85, 0xAF, 0xAF, 0x85, 0x85, 0x85,
  0x2C, 0xD9, 0xD9, 0xAC, 0xAF, 0x2C, 0x2C, 0x2C,
  0x2C, 0x85, 0x8A, 0x2A, 0x8D, 0x2C, 0xD9, 0xD9,
  0xAF, 0xAF, 0xAC, 0xAF, 0x2C, 0x2C, 0x2C, 0x85,
  0x2C, 0xAF, 0xAF, 0xAF, 0x2C, 0x2C, 0x2C, 0xAC,
  0xD9, 0xAC, 0xAF, 0x2C, 0x85, 0x85, 0xDA, 0xDA,
  0x8A, 0x8A, 0x85, 0xD9, 0x2C, 0x2B, 0x20, 0xAE,
  0xA3, 0xBC, 0x8D, 0xC8, 0xA9, 0xC7, 0x92, 0x47,
  0x8D, 0x8D, 0x7E, 0xE4, 0xE8, 0xE8, 0x5C, 0x2C,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x6B, 0xAF,
  0x2C, 0x85, 0x2C, 0xAF, 0xAF, 0xAF, 0x2C, 0x2C,
  0x2C, 0xAF, 0xD9, 0xAC, 0x2C, 0x2C, 0x85, 0x85,
  0x85, 0xDA, 0x8D, 0x8A, 0x85, 0xAC, 0x95, 0xD9,
  0xAC, 0xAC, 0xAC, 0xAC, 0x2C, 0xAF, 0xAF, 0x2C,
  0x2C, 0xAF, 0xAF, 0xAC, 0x2C, 0xAF, 0x2C, 0xAF,
  0xD9, 0xAC, 0x2C, 0x2C, 0x85, 0x85, 0x85, 0x85,
  0x85, 0x2C, 0xD9, 0xD9, 0x2D, 0x6B, 0x41, 0x2A,
  0xE8, 0xA3, 0xC8, 0x8D, 0x8A, 0x8A, 0x8A, 0x8D,
  0x4D, 0xA3, 0x3D, 0xE8, 0xE8, 0xE8, 0xE8, 0x5C,
  0xAE, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0xDB,
  0xDA, 0x2C, 0x2C, 0xAF, 0xAF, 0xAC, 0xAC, 0xAF,
  0x2C, 0xAC, 0xD9, 0xAC, 0x2C, 0x2C, 0x85, 0x85,
  0x85, 0x85, 0x85, 0x2C, 0xD9, 0x95, 0x7D, 0xD9,
  0x7D, 0x7D, 0xD9, 0xAC, 0xAC, 0xAF, 0xAF, 0xAF,
  0x2C, 0x2C, 0xAC, 0xAC, 0xD9, 0xAC, 0xAC, 0xD9,
  0x95, 0xD9, 0xAC, 0xAF, 0xAF, 0xAC, 0xAF, 0xAC,
  0xD9, 0x7D, 0x7D, 0x7D, 0x33, 0x41, 0x2D, 0xE8,
  0xE8, 0x5C, 0xD3, 0x8D, 0x8D, 0x8D, 0x8D, 0x7E,
  0x3D, 0xE8, 0xE8, 0xE8, 0xE8, 0xE8, 0xE8, 0xE8,
  0xDA, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x81, 0x2C, 0x2C, 0x2C, 0xAC, 0xAC, 0xAC, 0xAC,
  0xAC, 0xD9, 0x95, 0x95, 0xAC, 0xAF, 0xAF, 0xAF,
  0xAF, 0xAC, 0xD9, 0x95, 0x7D, 0xD6, 0xD6, 0x7D,
  0x21, 0xD6, 0x95, 0xD9, 0xD9, 0xAC, 0xAF, 0xAF,
  0x2C, 0xAF, 0xAC, 0xAC, 0xD9, 0xD9, 0xD9, 0xD9,
  0x21, 0x21, 0x7D, 0x95, 0x95, 0x7D, 0xD6, 0x21,
  0xB2, 0xA1, 0x2C, 0x88, 0x20, 0xE3, 0xA3, 0xE8,
  0xE8, 0xE8, 0xE4, 0xEE, 0xD3, 0x7E, 0x73, 0x5C,
  0xE8, 0xE8, 0xE8, 0xE8, 0xE8, 0xE8, 0xE8, 0xE8,
  0x5C, 0x2B, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x2C, 0xAF, 0xAF, 0xAC, 0xD9, 0xD9, 0xD9,
  0xD9, 0xD9, 0xD6, 0x21, 0x7D, 0x95, 0x95, 0x7D,
  0xD6, 0xB2, 0xA1, 0xA1, 0xB2, 0xD6, 0x21, 0x21,
  0x21, 0xD9, 0xD9, 0xD9, 0xAC, 0xAF, 0xAC, 0xAF,
  0x2C, 0x2C, 0xAC, 0xD9, 0xD9, 0xD9, 0xD9, 0x95,
  0x7D, 0xB2, 0xD6, 0x95, 0xD9, 0x95, 0xD6, 0xA1,
  0xA1, 0xAF, 0x5B, 0x20, 0x20, 0xD6, 0xE8, 0xE8,
  0xE8, 0xE8, 0xE8, 0xE8, 0x5C, 0xE8, 0xE8, 0xE8,
  0xE8, 0xE8, 0xE8, 0xE8, 0xE8, 0xE8, 0xE8, 0xE8,
  0xE8, 0x48, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0xE3, 0x8A, 0x2C, 0xAC, 0xAC, 0xD9, 0xD9,
  0xD9, 0x95, 0xD6, 0xB2, 0xD6, 0x95, 0xD9, 0x95,
  0x21, 0xB2, 0xA1, 0xB2, 0xD6, 0xD6, 0xD6, 0xA1,
  0xD9, 0x2C, 0x2C, 0x2C, 0xAF, 0xAF, 0xAC, 0xAF,
  0x2C, 0x2C, 0xAF, 0xAC, 0xD9, 0xAC, 0xD9, 0xD9,
  0xD9, 0x95, 0xAC, 0x2C, 0x2C, 0xAC, 0x95, 0x7D,
  0xD9, 0x91, 0x20, 0x20, 0xE3, 0xA3, 0xE8, 0xE8,
  0xE8, 0xE8, 0xE8, 0xE8, 0xE8, 0xE8, 0xE8, 0xE8,
  0xE8, 0xE8, 0xE8, 0xE8, 0xE8, 0xE8, 0xE8, 0xE8,
  0xE8, 0x85, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x2B, 0x8A, 0xAF, 0xAC, 0xD9, 0xAC,
  0xD9, 0xD9, 0xD9, 0x95, 0xAC, 0x2C, 0x2C, 0xAC,
  0x95, 0x7D, 0x95, 0x95, 0xD9, 0x95, 0x7D, 0x21,
  0x2C, 0xDA, 0xDA, 0x85, 0x2C, 0xAF, 0xAF, 0xAF,
  0xAF, 0xAF, 0x2C, 0xAF, 0xAF, 0xAC, 0xAC, 0xAC,
  0xD9, 0xAF, 0x85, 0x85, 0x2C, 0xAF, 0xD9, 0xAF,
  0x48, 0x20, 0x20, 0x20, 0xE6, 0xA3, 0xE8, 0xE8,
  0xE8, 0xE8, 0xE8, 0xE8, 0xE8, 0xE8, 0xE8, 0xE8,
  0xE8, 0xE8, 0xE8, 0xE8, 0xE8, 0xE8, 0xE8, 0x5C,
  0xE4, 0x73, 0x41, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x2B, 0xDA, 0xAF, 0xAF, 0xAC,
  0xAC, 0xAF, 0xD9, 0x2C, 0x85, 0x85, 0x2C, 0xAF,
  0xD9, 0xD9, 0xAC, 0xAF, 0xAC, 0xD9, 0xD9, 0xD9,
  0x85, 0xDA, 0xDA, 0x85, 0x2C, 0x2C, 0xAC, 0xAF,
  0xAF, 0xAF, 0xAF, 0x2C, 0xAF, 0xAF, 0xAC, 0xAC,
  0xAF, 0x2C, 0x2C, 0x2C, 0xAC, 0x95, 0x95, 0xA1,
  0x20, 0x20, 0x20, 0x20, 0xE9, 0x8C, 0x5C, 0xE8,
  0xE8, 0xE8, 0xE8, 0x3D, 0x73, 0x73, 0xE8, 0xE8,
  0xE8, 0xE8, 0xE8, 0xE4, 0x73, 0x73, 0x73, 0xCD,
  0x7E, 0xA3, 0x74, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x24, 0x85, 0xAF, 0xAF,
  0xAC, 0xAC, 0xAC, 0xAF, 0x85, 0x2C, 0xAC, 0x95,
  0x95, 0xD9, 0xAC, 0xAC, 0xAC, 0xD9, 0xAC, 0xAF,
  0x8A, 0x8A, 0xDA, 0xDA, 0x85, 0x2C, 0x2C, 0x2C,
  0x2C, 0x2C, 0x2C, 0xAF, 0xAF, 0xAC, 0xAF, 0xAC,
  0xAC, 0xAF, 0xAF, 0xD9, 0xD6, 0xD6, 0x2C, 0x88,
  0x20, 0x20, 0x20, 0x88, 0xB2, 0xDA, 0x7E, 0x73,
  0xE8, 0xE8, 0xE8, 0x3D, 0x73, 0xE8, 0xE8, 0xE8,
  0xE8, 0xE8, 0xE8, 0xA3, 0xCD, 0xD3, 0x2A, 0x2A,
  0x2A, 0x8C, 0x8D, 0x88, 0x20, 0xE3, 0x6B, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x41, 0x85, 0xAF, 0xAC,
  0xAC, 0xAC, 0xAC, 0xAF, 0xAC, 0xD9, 0x7D, 0xD6,
  0x7D, 0x7D, 0xD9, 0x95, 0xD9, 0xAC, 0xAC, 0xAF,
  0xD3, 0x8D, 0xDA, 0xDA, 0x85, 0x85, 0x2C, 0x2C,
  0x2C, 0xAF, 0xAF, 0xAC, 0xD9, 0xD9, 0xD9, 0xD9,
  0xAF, 0xAF, 0xAC, 0xD9, 0x95, 0x7D, 0xAC, 0x20,
  0x20, 0x20, 0x20, 0xDB, 0x2C, 0xA3, 0x5C, 0xE8,
  0xE8, 0xE8, 0xE8, 0x5C, 0x3D, 0x3D, 0xE8, 0xE8,
  0xE8, 0xE4, 0xE8, 0xE8, 0xE8, 0xE4, 0x73, 0xEE,
  0xD3, 0x2A, 0xEE, 0xAC, 0x20, 0x33, 0x2B, 0xE3,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x9F, 0xAF, 0xD9,
  0xD9, 0xAC, 0xAF, 0xAF, 0xAC, 0xD9, 0x95, 0x7D,
  0xD9, 0x95, 0x95, 0x95, 0x95, 0xD9, 0xAF, 0xAF,
  0x7E, 0x85, 0x85, 0x2C, 0x85, 0x85, 0x85, 0x2C,
  0x2C, 0x2C, 0xAF, 0xD9, 0xD9, 0x95, 0xD9, 0xAC,
  0xAC, 0xAF, 0xAF, 0xAC, 0xAC, 0xAC, 0x91, 0x20,
  0x33, 0xE3, 0x41, 0x48, 0x73, 0x5C, 0xE8, 0xE8,
  0xE8, 0xE8, 0xE8, 0xA3, 0xD6, 0x6C, 0x85, 0xE8,
  0xDA, 0xAE, 0xB2, 0xA3, 0x5C, 0xE8, 0xE8, 0xE8,
  0x3D, 0xEE, 0x4D, 0xA3, 0x24, 0x20, 0x6B, 0xDB,
  0x2B, 0x20, 0x20, 0x20, 0x20, 0x20, 0x85, 0x95,
  0xD9, 0xD9, 0xAC, 0xAF, 0xAF, 0xAC, 0xD9, 0xAC,
  0xD9, 0xD9, 0xD9, 0xD9, 0xD9, 0xAC, 0xD9, 0xAC,
  0x8A, 0xD9, 0xAC, 0xD9, 0xAC, 0xAC, 0x2C, 0x2C,
  0xAF, 0xAF, 0xAF, 0xAC, 0xD9, 0xD9, 0xD9, 0xD9,
  0xAF, 0xAF, 0xAF, 0xAC, 0xAC, 0x85, 0x33, 0x20,
  0xCC, 0x20, 0xE3, 0xA3, 0xE8, 0xE8, 0xE8, 0xE8,
  0xE8, 0xA3, 0xD9, 0x81, 0xAC, 0xDA, 0x2D, 0x5C,
  0x48, 0x41, 0x88, 0x74, 0x21, 0xA3, 0xE8, 0xE8,
  0xE8, 0xE8, 0x73, 0x8C, 0x8A, 0x20, 0x20, 0x20,
  0xDB, 0x33, 0x20, 0x20, 0x20, 0x20, 0xE6, 0xD9,
  0xD9, 0xAC, 0xAC, 0xAF, 0xAC, 0xAF, 0xAC, 0xAF,
  0xAF, 0xAC, 0xD9, 0xAF, 0xD9, 0xAC, 0xAC, 0xAF,
  0x85, 0xD9, 0x95, 0xD9, 0x95, 0xD9, 0xD9, 0xAC,
  0xAF, 0xAC, 0xAF, 0xAF, 0x2C, 0xAF, 0x2C, 0x2C,
  0xAF, 0xAF, 0xAF, 0xAC, 0xAC, 0x2C, 0x20, 0x5B,
  0x33, 0x20, 0xD6, 0xE8, 0xE8, 0xE8, 0xE8, 0x73,
  0xAF, 0x2D, 0xD9, 0xDA, 0xB2, 0x81, 0x81, 0xE4,
  0xA1, 0x91, 0x2B, 0x88, 0x33, 0x80, 0xAF, 0x73,
  0xE8, 0xE8, 0xE8, 0x5C, 0xA3, 0x80, 0x41, 0xCC,
  0x2B, 0xCC, 0x20, 0x20, 0x20, 0x20, 0x88, 0xDA,
  0x2C, 0x2C, 0x2C, 0xAF, 0xAF, 0xAC, 0xAC, 0xAF,
  0xAF, 0xAF, 0xAF, 0xAC, 0xAF, 0xAF, 0xAF, 0x2C,
  0x85, 0xD9, 0xD9, 0xD9, 0xD9, 0xAC, 0xAC, 0xD9,
  0xD9, 0xD9, 0xAC, 0x2C, 0x2C, 0x2C, 0x85, 0x85,
  0x85, 0x2C, 0x2C, 0xAF, 0x2C, 0x91, 0x20, 0xAE,
  0x20, 0xDB, 0x3D, 0xE8, 0xE8, 0x5C, 0xB2, 0x80,
  0xB2, 0xAF, 0x48, 0xB2, 0x48, 0x89, 0x89, 0x3D,
  0x21, 0x48, 0x6C, 0x2D, 0x2B, 0x41, 0xE3, 0xAE,
  0xD9, 0x5C, 0xE8, 0xE8, 0xE8, 0x95, 0x33, 0x80,
  0xAE, 0x33, 0x2B, 0x20, 0x20, 0x20, 0x20, 0x95,
  0x85, 0x2C, 0x85, 0x2C, 0x2C, 0xAF, 0x2C, 0x2C,
  0x2C, 0xAF, 0xAC, 0xAF, 0xAF, 0x2C, 0x2C, 0x2C,
  0xDA, 0xAF, 0xD9, 0xD9, 0xAF, 0x2C, 0x2C, 0x2C,
  0xAC, 0xD9, 0xAC, 0xAF, 0x2C, 0x85, 0x2C, 0x85,
  0x85, 0x2C, 0x2C, 0x2C, 0x8A, 0x41, 0xDB, 0x33,
  0x20, 0x95, 0xE8, 0xE8, 0xE8, 0xA3, 0xDB, 0x88,
  0xDB, 0x80, 0xD6, 0x7E, 0x85, 0x2D, 0xE6, 0x5C,
  0x21, 0x48, 0xD9, 0x7E, 0xD6, 0x2B, 0xCC, 0xAC,
  0x85, 0xBC, 0xE8, 0xE8, 0xE8, 0xCD, 0x88, 0x5B,
  0x41, 0x20, 0xAE, 0x20, 0x20, 0x20, 0x20, 0x74,
  0xDA, 0x85, 0x85, 0x85, 0x2C, 0x2C, 0x2C, 0x2C,
  0xAF, 0xAC, 0xD9, 0xD9, 0xAC, 0xAC, 0xAC, 0xD9,
  0x8A, 0xAF, 0xAC, 0xAC, 0x2C, 0x85, 0x2C, 0xAF,
  0xD9, 0xD9, 0xAF, 0xAF, 0xAF, 0x2C, 0xAF, 0x2C,
  0x2C, 0x2C, 0x2C, 0xAF, 0x95, 0x20, 0x74, 0x20,
  0x33, 0xA3, 0xE8, 0xE8, 0xE8, 0xE4, 0x7D, 0xCC,
  0x6B, 0x33, 0xAE, 0x2C, 0x85, 0x2D, 0x9F, 0x73,
  0xA1, 0x2D, 0x2C, 0xDA, 0x89, 0x48, 0xD3, 0xD9,
  0x21, 0xA3, 0xE8, 0xE8, 0xE8, 0xE8, 0xE3, 0x20,
  0x20, 0x20, 0xDB, 0x41, 0x20, 0x20, 0x20, 0x20,
  0xDA, 0x2C, 0x2C, 0x2C, 0x2C, 0xAF, 0xAC, 0xAC,
  0xD9, 0xD9, 0xD9, 0xD9, 0xD9, 0x95, 0x95, 0xD9,
  0x2C, 0xD9, 0xD9, 0xAC, 0x2C, 0x2C, 0x85, 0xAF,
  0xAF, 0xAF, 0xAC, 0xAC, 0xD9, 0xAC, 0xAF, 0xAC,
  0xAC, 0x95, 0xD6, 0x7D, 0xAE, 0x88, 0x2B, 0x20,
  0x6C, 0xE8, 0xE8, 0xE8, 0x73, 0xEE, 0x73, 0x2C,
  0x89, 0x2B, 0x41, 0x33, 0xCC, 0xCC, 0x80, 0x3D,
  0x2D, 0x74, 0x80, 0x48, 0x8D, 0x95, 0x48, 0x95,
  0xEE, 0x5C, 0x5C, 0xE8, 0xE8, 0xE8, 0x24, 0x20,
  0x20, 0x20, 0x5B, 0xDB, 0x20, 0x20, 0x20, 0x20,
  0xAF, 0xAC, 0xD9, 0x95, 0xD6, 0xD6, 0xD6, 0x7D,
  0x95, 0x95, 0x95, 0x95, 0x95, 0x95, 0xD9, 0xAC,
  0xAC, 0xD9, 0xD9, 0xAC, 0x2C, 0x2C, 0x2C, 0xAF,
  0xAC, 0xAC, 0xAC, 0xAC, 0xD9, 0xAC, 0xAC, 0xD9,
  0xD6, 0x48, 0xE9, 0x95, 0x20, 0x2B, 0x41, 0x6B,
  0x8D, 0xE8, 0xE8, 0xCD, 0x2B, 0x2B, 0x2C, 0x73,
  0xCD, 0x48, 0xCA, 0x5B, 0x41, 0x5B, 0x74, 0xDA,
  0x80, 0xE6, 0xC8, 0x85, 0xA1, 0x7D, 0x8D, 0x3D,
  0x7E, 0xE9, 0x7D, 0xEE, 0xE8, 0xE8, 0x81, 0x20,
  0x20, 0x20, 0xE3, 0xE3, 0x20, 0x20, 0x20, 0x20,
  0x2D, 0xD9, 0xD6, 0x48, 0x6C, 0xE9, 0xA1, 0xD6,
  0xD9, 0xD9, 0xAC, 0xD9, 0xD9, 0x95, 0xAC, 0x2C,
  0x2C, 0x2C, 0x2C, 0xD9, 0xAC, 0x2C, 0x2C, 0x2C,
  0xAF, 0x2C, 0xAF, 0xD9, 0xAC, 0xAF, 0xAF, 0x95,
  0xB2, 0xE9, 0x21, 0x2B, 0x41, 0x2B, 0x20, 0x5B,
  0x3D, 0xE8, 0xE8, 0x8D, 0x2B, 0x88, 0x5B, 0xE6,
  0xBC, 0x73, 0x85, 0x89, 0x80, 0x5B, 0xE3, 0xAE,
  0x2C, 0x8A, 0xD6, 0xB2, 0x2C, 0xA3, 0xA3, 0xD9,
  0xA1, 0x2C, 0x85, 0x8D, 0xE8, 0xE8, 0x48, 0x20,
  0x20, 0x20, 0xE3, 0x88, 0x20, 0x20, 0x20, 0x20,
  0xAE, 0xD9, 0xB2, 0xE9, 0x6C, 0x48, 0xD6, 0xD9,
  0x2C, 0x85, 0x2C, 0xD9, 0x7D, 0xD9, 0x2C, 0x85,
  0x8D, 0x85, 0x2C, 0xAC, 0xAF, 0x2C, 0x2C, 0x85,
  0x2C, 0x2C, 0xAF, 0xAC, 0xAC, 0xAF, 0xAF, 0xD9,
  0xB2, 0x48, 0xB2, 0x20, 0x20, 0xCC, 0x20, 0x9F,
  0xE8, 0xE8, 0xE8, 0xCD, 0x48, 0x89, 0xDB, 0x88,
  0x2B, 0xE9, 0xCD, 0x2A, 0x48, 0x80, 0xAE, 0xAE,
  0x7D, 0x48, 0x21, 0xEE, 0x3D, 0x2C, 0x48, 0x85,
  0x2C, 0x95, 0x7D, 0x8C, 0xE8, 0xE8, 0xB2, 0x20,
  0x20, 0x20, 0xDB, 0x20, 0x20, 0x20, 0x20, 0x20,
  0xDB, 0x2C, 0xB2, 0x48, 0x48, 0x7D, 0xD9, 0xAF,
  0x85, 0x8A, 0x85, 0x7D, 0xB2, 0x95, 0x85, 0xDA,
  0xD3, 0x85, 0xAF, 0xAC, 0x2C, 0x85, 0x85, 0x2C,
  0xAC, 0xAC, 0xAC, 0xD9, 0xD9, 0xAC, 0x2C, 0x2C,
  0xD9, 0xAC, 0x5B, 0x20, 0x20, 0xAE, 0x20, 0x2D,
  0xE8, 0xE8, 0xE8, 0x7E, 0xD6, 0x48, 0xE9, 0xAE,
  0x88, 0x5B, 0x80, 0x6C, 0xAE, 0xCA, 0x91, 0xE9,
  0x43, 0x9F, 0xE6, 0x2C, 0x48, 0x21, 0xBC, 0x95,
  0x95, 0xD6, 0x21, 0x7E, 0xE8, 0xE8, 0x7D, 0x20,
  0x20, 0x20, 0x2B, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x6B, 0xDA, 0xD9, 0x48, 0xB2, 0xD9, 0x2C, 0x85,
  0xDA, 0xDA, 0x2C, 0xA1, 0x48, 0xAC, 0xDA, 0x8D,
  0x2A, 0xAC, 0x7D, 0x95, 0xAF, 0x85, 0x2C, 0x2C,
  0xAC, 0xD9, 0x95, 0x7D, 0x95, 0xAC, 0x2C, 0xAF,
  0x7D, 0xD6, 0x20, 0x20, 0x88, 0x9F, 0x20, 0xA1,
  0xE8, 0xE8, 0xE8, 0xA3, 0xD6, 0x6C, 0xB2, 0x2C,
  0x89, 0xE3, 0x88, 0xDB, 0xCC, 0x24, 0x7D, 0xEE,
  0xB2, 0xCC, 0xAE, 0x2D, 0xDA, 0x2C, 0xD6, 0x2C,
  0xB2, 0x2D, 0xD6, 0xEE, 0xE8, 0xE8, 0x95, 0x20,
  0x20, 0x20, 0xDB, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x6B, 0xDA, 0x95, 0xA1, 0xB2, 0xAC, 0x85, 0x85,
  0xDA, 0x2C, 0x95, 0xA1, 0x21, 0x2C, 0x8A, 0x2A,
  0xAF, 0xA1, 0x48, 0xD6, 0xAF, 0x2C, 0x2C, 0xAC,
  0xD9, 0xD9, 0x95, 0x7D, 0x95, 0xAC, 0xD9, 0x7D,
  0x48, 0xE6, 0x20, 0x20, 0x33, 0x89, 0x6B, 0x95,
  0xE8, 0xE8, 0xE8, 0xA3, 0x21, 0x48, 0xAF, 0xAF,
  0x9F, 0xE9, 0x43, 0x33, 0x33, 0x2D, 0xDA, 0xCD,
  0xD6, 0xAE, 0x85, 0x2C, 0x7D, 0xD6, 0x91, 0xB8,
  0xD4, 0x48, 0x7D, 0xA3, 0xE8, 0xE8, 0x95, 0x20,
  0x20, 0x33, 0xE3, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x2C, 0x48, 0x6C, 0xB2, 0xAF, 0xDA, 0xDA,
  0x85, 0xAF, 0xD9, 0x95, 0xAC, 0xDA, 0x8A, 0xDA,
  0x7D, 0x48, 0x48, 0x7D, 0x2C, 0x85, 0x2C, 0xAF,
  0xD9, 0xD9, 0x7D, 0x95, 0xD9, 0xD9, 0x95, 0xD6,
  0x21, 0x24, 0x20, 0x20, 0x20, 0x5B, 0xDB, 0xAC,
  0xE8, 0xE8, 0xE8, 0x3D, 0x7D, 0x48, 0xE6, 0x2D,
  0x85, 0x81, 0x81, 0x48, 0xAE, 0xCA, 0x89, 0xCC,
  0xAE, 0xDB, 0x2D, 0x95, 0x21, 0xCC, 0xDB, 0xAE,
  0x91, 0xE9, 0x7D, 0x73, 0xE8, 0xE8, 0x48, 0x20,
  0x6B, 0x74, 0x41, 0x88, 0x6B, 0x20, 0x20, 0x20,
  0x6B, 0x95, 0xB2, 0xD6, 0xD9, 0x85, 0xDA, 0xDA,
  0xDA, 0x2C, 0xAF, 0xAF, 0x2C, 0xDA, 0xDA, 0x85,
  0xA1, 0xE9, 0x48, 0x95, 0x85, 0xDA, 0x85, 0xAC,
  0xD9, 0xD9, 0x95, 0x95, 0xD9, 0xD9, 0xD9, 0x95,
  0x95, 0x6C, 0x41, 0x93, 0x93, 0x41, 0xDB, 0x95,
  0xE8, 0xE8, 0xE8, 0x3D, 0x95, 0xD4, 0x6C, 0x21,
  0x2D, 0x95, 0xCD, 0x2C, 0xD6, 0xD9, 0x6C, 0x91,
  0x89, 0x7D, 0xAC, 0x2A, 0x8D, 0xE6, 0xCC, 0x88,
  0x74, 0x48, 0xD9, 0xE4, 0xE8, 0xE8, 0xE6, 0x88,
  0x2B, 0x88, 0x20, 0x33, 0xDB, 0x2B, 0xDB, 0x20,
  0x91, 0x7D, 0xD9, 0xD9, 0x85, 0x85, 0xDA, 0xDA,
  0x85, 0xAF, 0xAC, 0xAF, 0x2C, 0x2C, 0x2C, 0x2C,
  0xA1, 0xA1, 0xD6, 0xAF, 0x85, 0xDA, 0x85, 0x2C,
  0xD9, 0xD9, 0x95, 0x95, 0xD9, 0xD9, 0xD9, 0xAC,
  0x2C, 0x47, 0x87, 0x3E, 0x3E, 0xA4, 0x7B, 0x80,
  0xA3, 0xE8, 0xE8, 0x5C, 0x7D, 0x48, 0xE6, 0xD9,
  0xBC, 0xEE, 0x7D, 0x43, 0xD6, 0x21, 0x43, 0x6C,
  0x43, 0x7D, 0x7D, 0xB2, 0x8A, 0xEE, 0x2C, 0xCA,
  0xAE, 0x48, 0x2C, 0xE4, 0xE8, 0x5C, 0xCC, 0x88,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x41, 0x91, 0xE3,
  0x21, 0xD9, 0x2C, 0x2C, 0xDA, 0xDA, 0xDA, 0x85,
  0x2C, 0xAC, 0xD9, 0xD9, 0xAC, 0xAF, 0xAF, 0xAF,
  0xD6, 0x7D, 0xD9, 0x2C, 0xDA, 0xDA, 0x85, 0xAC,
  0xD9, 0x7D, 0x7D, 0xD9, 0xD9, 0xD9, 0x2C, 0x2C,
  0xB8, 0x9C, 0xEC, 0x62, 0x6F, 0x62, 0x70, 0x3C,
  0xAE, 0xCD, 0xE8, 0xE8, 0x8C, 0x7D, 0xC8, 0x3D,
  0x8A, 0xE9, 0x2D, 0x9E, 0xA1, 0xD6, 0x48, 0x73,
  0x81, 0xD6, 0xD6, 0xAE, 0x5B, 0x2D, 0xA3, 0xA3,
  0x21, 0x21, 0xCD, 0xE8, 0xC0, 0x56, 0x31, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x33, 0xCC, 0xDB,
  0x42, 0x85, 0x85, 0x85, 0x85, 0x85, 0x2C, 0x2C,
  0xAC, 0xD9, 0xD9, 0xD9, 0xAC, 0xAF, 0xAF, 0xAF,
  0xD9, 0x95, 0xAC, 0x2C, 0x85, 0x85, 0x2C, 0xD9,
  0x7D, 0xD6, 0xD6, 0xD9, 0xAC, 0xAF, 0x8A, 0xBC,
  0xC2, 0x68, 0x2E, 0x4B, 0xC9, 0x8B, 0x62, 0x87,
  0x3C, 0x74, 0xBC, 0xE8, 0xE8, 0xE4, 0xEE, 0xA1,
  0xE9, 0x21, 0xE6, 0x89, 0x48, 0x7D, 0xB2, 0x5C,
  0x6C, 0x7D, 0x21, 0x80, 0xE3, 0x33, 0xCC, 0x2C,
  0x3D, 0x3D, 0xE8, 0xE8, 0xEC, 0xCB, 0x5A, 0x6B,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x88, 0x41, 0x51,
  0x49, 0x28, 0x85, 0x85, 0x85, 0x85, 0x2C, 0xAF,
  0xAC, 0xAC, 0xAF, 0x2C, 0x2C, 0x2C, 0x2C, 0x2C,
  0xD9, 0x95, 0xD9, 0x2C, 0x85, 0x85, 0x2C, 0xD9,
  0xB2, 0xB2, 0x2C, 0x2A, 0x79, 0x79, 0x97, 0x44,
  0xED, 0x29, 0x32, 0x62, 0x4B, 0x62, 0x6F, 0x22,
  0xF3, 0x6B, 0x33, 0x85, 0x73, 0xE4, 0x2D, 0x2B,
  0xCC, 0x9F, 0xDA, 0xBC, 0x48, 0xD6, 0xA1, 0xE4,
  0xE9, 0xD6, 0xD9, 0x2A, 0xB2, 0x2B, 0x2B, 0xA1,
  0xB8, 0xE8, 0xE8, 0xE8, 0xEC, 0x3E, 0x30, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x6B, 0x54, 0xDC,
  0xC9, 0x53, 0xBC, 0x2C, 0x2C, 0x2C, 0xAF, 0xAF,
  0xAF, 0xAC, 0xAF, 0xAC, 0xAC, 0x2C, 0xAF, 0xAC,
  0x2C, 0x7D, 0xD9, 0x2C, 0x85, 0xDA, 0xAF, 0x7D,
  0xB2, 0xAC, 0xC6, 0xBA, 0x4C, 0xEF, 0xA7, 0xEF,
  0xEC, 0x7A, 0x62, 0x4B, 0x62, 0x4B, 0x8B, 0x4B,
  0x3A, 0x52, 0x20, 0x6B, 0x21, 0x73, 0xAC, 0x2B,
  0x41, 0x33, 0x48, 0x67, 0xA1, 0xD6, 0xD6, 0x5C,
  0xE9, 0xD6, 0x2C, 0xEE, 0xB2, 0x9F, 0x8A, 0x95,
  0x4D, 0xE8, 0xE8, 0x3D, 0x7A, 0x57, 0xD1, 0x7B,
  0x20, 0x20, 0x20, 0x20, 0x6B, 0xCF, 0xBA, 0x3E,
  0x3E, 0xD0, 0xBC, 0xAC, 0xAC, 0x2C, 0x2C, 0xAC,
  0xD9, 0xD9, 0x95, 0x95, 0x7D, 0x95, 0x95, 0xD9,
  0x85, 0xD9, 0xAF, 0xDA, 0xDA, 0x85, 0xAC, 0x21,
  0xB2, 0x2A, 0xBA, 0x57, 0x2E, 0x2E, 0x2E, 0x7A,
  0x32, 0x62, 0x8B, 0x4B, 0x8B, 0x4B, 0x4B, 0x4B,
  0xC9, 0x4A, 0x5F, 0x20, 0x20, 0x2D, 0xA3, 0xD9,
  0xCA, 0x88, 0xDB, 0x24, 0x48, 0x7D, 0xB2, 0xE4,
  0x2D, 0x7D, 0x7D, 0x81, 0xA1, 0xDA, 0x21, 0xDA,
  0xE4, 0xE8, 0xEE, 0xF1, 0x2E, 0x57, 0x82, 0x76,
  0x52, 0x4F, 0x4F, 0x98, 0xDE, 0xB5, 0xEC, 0x2E,
  0x3E, 0x6D, 0x85, 0x2C, 0xAC, 0xAC, 0xD9, 0xD9,
  0x95, 0xD6, 0x7D, 0x7D, 0x95, 0xD9, 0xD9, 0xD9,
  0xDA, 0x2C, 0x85, 0xDA, 0xDA, 0x2C, 0x95, 0xB2,
  0x21, 0xB8, 0xED, 0x2E, 0x3E, 0x4B, 0xC9, 0x4B,
  0x8B, 0x62, 0x4B, 0x4B, 0x4B, 0x4B, 0x4B, 0x4B,
  0x22, 0x6F, 0xCE, 0x20, 0x20, 0x20, 0x80, 0xCD,
  0xDA, 0x2D, 0x2B, 0xDB, 0xE9, 0xD6, 0x95, 0x5C,
  0x2D, 0x7D, 0x7D, 0xAF, 0xAF, 0xAC, 0xEE, 0x5C,
  0xE8, 0xE8, 0xEB, 0x25, 0x7A, 0x57, 0x39, 0xE1,
  0x83, 0xA8, 0x55, 0x83, 0x82, 0x57, 0x32, 0x8B,
  0x62, 0x6D, 0xEB, 0x95, 0xD9, 0xD9, 0xD9, 0xD9,
  0xD9, 0xD9, 0xD9, 0xAF, 0x2C, 0x2C, 0x2C, 0x2C,
  0xDA, 0x2C, 0x85, 0x85, 0x85, 0xAC, 0xD6, 0x21,
  0x95, 0x6E, 0xED, 0x57, 0x62, 0x4B, 0x8B, 0x4B,
  0x4B, 0x62, 0x4B, 0x4B, 0x4B, 0x4B, 0x4B, 0x62,
  0x62, 0x62, 0x25, 0x3C, 0x20, 0x20, 0x20, 0xE3,
  0x2A, 0xBC, 0x7D, 0xCA, 0x6C, 0xD6, 0x95, 0x3D,
  0x81, 0x7D, 0xD6, 0xD6, 0xDA, 0x73, 0xE8, 0xE8,
  0xE8, 0x4D, 0x94, 0xED, 0x72, 0x3A, 0xF1, 0xA7,
  0x39, 0xED, 0x39, 0xEF, 0x57, 0x32, 0x8B, 0x4B,
  0x62, 0x62, 0xA6, 0x2A, 0xD9, 0xD9, 0xD9, 0xD9,
  0x2C, 0x2C, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85,
  0x85, 0x2C, 0x2C, 0xAF, 0xAC, 0x95, 0x21, 0x7D,
  0xAC, 0x8C, 0x46, 0xC4, 0x62, 0x8B, 0x4B, 0x4B,
  0x4B, 0x4B, 0x4B, 0x4B, 0x4B, 0x4B, 0x4B, 0x4B,
  0x4B, 0x62, 0xC9, 0x30, 0x7B, 0x20, 0x20, 0x20,
  0x41, 0x4D, 0x3D, 0x85, 0x48, 0x21, 0xDA, 0x3D,
  0xE9, 0xD6, 0xD9, 0xCD, 0x5C, 0xE8, 0xE8, 0xE8,
  0xE8, 0x4D, 0x71, 0x46, 0xEC, 0x2E, 0x72, 0xEC,
  0x29, 0x29, 0x7C, 0x29, 0x2E, 0x4B, 0x4B, 0x62,
  0x62, 0x4B, 0x3A, 0xAD, 0xE2, 0xAF, 0xD9, 0xD9,
  0x2C, 0xDA, 0xDA, 0xDA, 0xDA, 0x85, 0x2C, 0x2C,
  0x2C, 0xAF, 0xAC, 0xD9, 0x95, 0xD6, 0xD6, 0xD9,
  0x2C, 0x8C, 0xBA, 0x7C, 0x2E, 0x4B, 0x4B, 0x4B,
  0x4B, 0x4B, 0x4B, 0x4B, 0x4B, 0x4B, 0x4B, 0x4B,
  0x4B, 0x62, 0xC9, 0xDC, 0x34, 0x20, 0x20, 0x20,
  0x20, 0xAC, 0xE8, 0x5C, 0x8C, 0xBC, 0xE4, 0xE8,
  0xEE, 0x2A, 0xA3, 0xE8, 0xE8, 0xE8, 0xE8, 0xE8,
  0xE4, 0x7E, 0x65, 0x46, 0x29, 0x62, 0x62, 0x2E,
  0x2E, 0x72, 0x2E, 0x2E, 0x32, 0x4B, 0x4B, 0x62,
  0x4B, 0x4B, 0x4B, 0x32, 0x61, 0x9D, 0x2C, 0xD9,
  0x2C, 0x85, 0xDA, 0x85, 0x2C, 0xAF, 0xAF, 0xAF,
  0x2C, 0xAC, 0xD9, 0x95, 0xD6, 0x7D, 0x95, 0xAC,
  0x2C, 0xDA, 0x40, 0x7C, 0x2E, 0x4B, 0x4B, 0x4B,
  0x4B, 0x4B, 0x4B, 0x4B, 0x4B, 0x4B, 0x4B, 0x4B,
  0x4B, 0x62, 0x62, 0x22, 0xB7, 0xCE, 0x20, 0x20,
  0x20, 0x95, 0xE8, 0xE8, 0xE8, 0xE8, 0xE8, 0xE8,
  0xE8, 0xE8, 0xE8, 0xE8, 0xE8, 0xE8, 0xE8, 0x5C,
  0x3D, 0xE9, 0x9A, 0x46, 0x7C, 0x32, 0x8B, 0x62,
  0x4B, 0x8B, 0x8B, 0x4B, 0x4B, 0x4B, 0x4B, 0x62,
  0x4B, 0x4B, 0x4B, 0x4B, 0x62, 0x61, 0x4E, 0xDA,
  0x85, 0x85, 0x85, 0x2C, 0xD9, 0xD9, 0xD9, 0xD9,
  0x85, 0xD9, 0x7D, 0x21, 0x21, 0xD6, 0xAC, 0x2C,
  0x2C, 0xDA, 0xDD, 0x77, 0x8B, 0x62, 0x4B, 0x4B,
  0x4B, 0x4B, 0x4B, 0x4B, 0x4B, 0x4B, 0x4B, 0x4B,
  0x3E, 0x8B, 0x32, 0xC9, 0x22, 0x68, 0x88, 0x33,
  0xA1, 0x73, 0xE8, 0xE8, 0xE8, 0xE8, 0xE8, 0xE8,
  0xE8, 0xE8, 0xE8, 0x5C, 0x5C, 0x5C, 0x5C, 0x3D,
  0x89, 0x20, 0x54, 0x23, 0x29, 0x2E, 0x4B, 0x62,
  0x4B, 0x3E, 0x4B, 0x62, 0x4B, 0x4B, 0x4B, 0x8B,
  0x8B, 0xC9, 0x6F, 0x4B, 0x8B, 0x4B, 0x78, 0xE2,
  0x8A, 0x8A, 0x85, 0xAC, 0xD9, 0x7D, 0xD9, 0xAC,
  0x2C, 0xD9, 0xD6, 0xB2, 0x21, 0x7D, 0xAF, 0x85,
  0x2C, 0xDA, 0x40, 0xEF, 0x62, 0x62, 0x4B, 0x4B,
  0x4B, 0x4B, 0x4B, 0x4B, 0x4B, 0x4B, 0x4B, 0x4B,
  0x4B, 0x4B, 0x8B, 0x4B, 0xC9, 0x63, 0xB4, 0x5C,
  0xE8, 0xE8, 0xE8, 0xE8, 0xE8, 0xE8, 0xE8, 0xE8,
  0xE8, 0xE8, 0xE8, 0xE8, 0x5C, 0x5C, 0xCD, 0xAE,
  0x20, 0x20, 0xCE, 0xE1, 0x57, 0x32, 0x4B, 0x4B,
  0x8B, 0x4B, 0x4B, 0x4B, 0x4B, 0x4B, 0x4B, 0x4B,
  0x8B, 0x4B, 0x62, 0x4B, 0x62, 0x2E, 0x61, 0x28,
  0x8D, 0xDA, 0xAF, 0xD9, 0x95, 0x95, 0xD9, 0xAF,
  0xAF, 0xD9, 0xD6, 0xB2, 0x21, 0xD9, 0x2C, 0x85,
  0xAF, 0xEB, 0xE1, 0x57, 0x2E, 0x62, 0x4B, 0x4B,
  0x4B, 0x4B, 0x4B, 0x4B, 0x4B, 0x4B, 0x4B, 0x4B,
  0x4B, 0x4B, 0x4B, 0x4B, 0x3E, 0x9B, 0x31, 0x6E,
  0xE8, 0xE8, 0xE8, 0xE8, 0xE8, 0xE8, 0xE8, 0xE8,
  0x5C, 0xE8, 0xE8, 0xE8, 0x3D, 0x7D, 0x33, 0x6B,
  0x20, 0x20, 0x34, 0x23, 0x29, 0x3E, 0x4B, 0x4B,
  0x4B, 0x4B, 0x4B, 0x4B, 0x4B, 0x4B, 0x4B, 0x4B,
  0x4B, 0x3E, 0x62, 0x62, 0x2E, 0xC4, 0x49, 0xD5,
  0xDA, 0xD9, 0xD6, 0xA1, 0xA1, 0x21, 0xD9, 0xD9,
  0xD9, 0x95, 0x21, 0x48, 0xD6, 0xAC, 0x85, 0x85,
  0xAF, 0xB6, 0x5D, 0x2E, 0x32, 0x4B, 0x4B, 0x4B,
  0x4B, 0x4B, 0x62, 0x4B, 0x4B, 0x4B, 0x4B, 0x4B,
  0x4B, 0x4B, 0x4B, 0x4B, 0x62, 0x2E, 0x45, 0xDE,
  0xDA, 0x5C, 0xE8, 0x5C, 0xE8, 0xE8, 0x5C, 0xE8,
  0x5C, 0x5C, 0xA3, 0xAC, 0x2B, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x34, 0x23, 0x29, 0x62, 0x4B, 0x4B,
  0x4B, 0x4B, 0x4B, 0x4B, 0x62, 0x4B, 0x4B, 0x4B,
  0x4B, 0x3E, 0x3E, 0x63, 0x40, 0x97, 0x28, 0xDA,
  0xD9, 0xA1, 0x48, 0xE9, 0x48, 0x21, 0xD9, 0xD9,
  0xA1, 0xB2, 0xB2, 0xA1, 0x21, 0xAC, 0x85, 0x2C,
  0xDA, 0x36, 0x77, 0x72, 0x62, 0x8B, 0x62, 0x4B,
  0x4B, 0x4B, 0x4B, 0x4B, 0x4B, 0x4B, 0x4B, 0x4B,
  0x4B, 0x4B, 0x4B, 0x4B, 0x3E, 0xEC, 0x2F, 0x51,
  0xE3, 0xAE, 0x48, 0x2C, 0xDA, 0xDA, 0x85, 0xAC,
  0x48, 0x9E, 0x88, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x41, 0xA0, 0x23, 0x72, 0x2E, 0x4B, 0x4B,
  0x4B, 0x62, 0x62, 0x4B, 0x4B, 0x4B, 0x2E, 0x8B,
  0xF0, 0x4C, 0x40, 0xC2, 0x90, 0x8D, 0x85, 0xD9,
  0xA1, 0x6C, 0x6C, 0x48, 0xD6, 0xD9, 0xAF, 0xAC,
  0xA1, 0xD6, 0xD6, 0xB2, 0xD6, 0xAC, 0x85, 0x85,
  0x4D, 0xBE, 0x39, 0x4C, 0x57, 0x2E, 0x2E, 0x2E,
  0x3E, 0x3E, 0x62, 0x3E, 0x4B, 0x4B, 0x4B, 0x4B,
  0x4B, 0x4B, 0x4B, 0x8B, 0x8B, 0x57, 0x60, 0x76,
  0x52, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x3C, 0xA0, 0x23, 0x7C, 0x2E, 0x4B, 0x4B,
  0x8B, 0x62, 0x4B, 0x4B, 0x3E, 0x7A, 0xF0, 0x29,
  0x36, 0x97, 0xBC, 0x8A, 0x8D, 0xDA, 0xD9, 0x48,
  0x81, 0x2D, 0x48, 0xD6, 0xD9, 0xAF, 0x2C, 0x2C,
  0xAC, 0xAF, 0xD9, 0x7D, 0x7D, 0x2C, 0x85, 0x85,
  0x85, 0xB4, 0x66, 0x23, 0x46, 0x2F, 0x60, 0x68,
  0x77, 0x29, 0x29, 0xF0, 0x2E, 0x2E, 0x62, 0x4B,
  0x4B, 0x4B, 0x4B, 0x4B, 0x32, 0x7C, 0x83, 0xB3,
  0x54, 0x6B, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x6B, 0x7B, 0xC3, 0xE7, 0x39, 0x72, 0x62, 0x62,
  0x62, 0x62, 0x62, 0x2E, 0x29, 0x77, 0xA7, 0x36,
  0xB8, 0x85, 0x85, 0x8D, 0x8D, 0x85, 0xB2, 0x2D,
  0x2D, 0xE9, 0xD6, 0xD9, 0xAF, 0x2C, 0x85, 0x85,
  0x2A, 0x85, 0xAC, 0x95, 0x95, 0xAF, 0x85, 0x85,
  0xAF, 0x8C, 0xDF, 0xC6, 0xB1, 0xD1, 0xE5, 0xE7,
  0x83, 0x23, 0x5D, 0x60, 0x39, 0x77, 0xEC, 0x2E,
  0x2E, 0x32, 0x32, 0x2E, 0x7C, 0x5D, 0x35, 0xA2,
  0x54, 0x6B, 0x6B, 0x20, 0x6B, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x6B, 0x88, 0xC1, 0x35, 0xE1, 0x77, 0x57, 0x2E,
  0x2E, 0x72, 0x29, 0x77, 0x60, 0xB5, 0x44, 0xE2,
  0x2C, 0x2C, 0xDA, 0x8A, 0xDA, 0xAF, 0xA1, 0x2D,
  0xE9, 0xD6, 0xD9, 0xAF, 0x2C, 0x85, 0x85, 0x85,
  0xEE, 0xAF, 0xD9, 0x7D, 0xD9, 0x2C, 0xDA, 0x85,
  0xAC, 0xAF, 0x85, 0xDA, 0x8A, 0x2A, 0xE2, 0x50,
  0x86, 0xD7, 0x75, 0x35, 0xA8, 0xE7, 0xE1, 0x5D,
  0x68, 0x7C, 0xF1, 0x68, 0xE1, 0xBF, 0xA2, 0xC1,
  0x52, 0x2B, 0x7D, 0xAC, 0xAF, 0x2C, 0x2C, 0x2C,
  0x2C, 0x85, 0x85, 0x85, 0x2C, 0x2C, 0x2C, 0x95,
  0xE9, 0x74, 0xCE, 0xE0, 0xE7, 0x60, 0x77, 0x77,
  0x7C, 0xEF, 0x5D, 0x23, 0x3F, 0xB6, 0x8A, 0x2C,
  0xAC, 0xAF, 0x85, 0x8A, 0x85, 0xD9, 0x48, 0x48,
  0xB2, 0x95, 0x95, 0xD9, 0x85, 0xDA, 0x85, 0x85,
  0xD3, 0xB2, 0x21, 0x7D, 0xAC, 0x2C, 0xDA, 0x85,
  0xAC, 0xAC, 0x85, 0x85, 0x85, 0x2C, 0xAF, 0x2C,
  0xDA, 0x8C, 0x79, 0xC7, 0xB0, 0x51, 0xB3, 0x35,
  0xBF, 0xE5, 0xE7, 0xA8, 0xE0, 0xA2, 0xC1, 0x34,
  0x7D, 0x85, 0xAC, 0xD9, 0xAC, 0xAF, 0xAC, 0xAC,
  0xAF, 0x2C, 0x2C, 0x2C, 0x2C, 0xAF, 0xAF, 0x85,
  0xC8, 0xCD, 0x6A, 0x26, 0x35, 0x3F, 0x83, 0x23,
  0x23, 0xE7, 0xBF, 0x96, 0xEB, 0xDA, 0xDA, 0x2C,
  0x2C, 0x2C, 0x85, 0xDA, 0x2C, 0x7D, 0xA1, 0x48,
  0xB2, 0x21, 0xD6, 0xD9, 0x2C, 0xDA, 0x85, 0xAF,
  0xAF, 0x2D, 0xE9, 0x7D, 0xAC, 0x2C, 0x85, 0x2C,
  0xD9, 0xD9, 0xAF, 0x85, 0x85, 0x85, 0x2C, 0x2C,
  0x2C, 0x85, 0xD9, 0x21, 0xAC, 0x2C, 0xBD, 0xA5,
  0xC3, 0xA2, 0xA2, 0xA2, 0x26, 0xC1, 0xCE, 0x2A,
  0xAF, 0x95, 0xD9, 0x2C, 0x2C, 0x85, 0x2C, 0xAF,
  0xAC, 0x2C, 0x85, 0x2C, 0xAF, 0x2C, 0x85, 0xDA,
  0x8D, 0x2A, 0x85, 0x34, 0xC1, 0xB3, 0x76, 0x35,
  0xE0, 0x30, 0xA5, 0xB6, 0x2C, 0x85, 0x85, 0x85,
  0xAF, 0x2C, 0x85, 0x85, 0xD9, 0xD6, 0xA1, 0xA1,
  0x48, 0xA1, 0xD6, 0xAF, 0xDA, 0x8A, 0x2C, 0xD9,
  0xB2, 0x2D, 0x48, 0xD9, 0xAF, 0x2C, 0x2C, 0x85,
  0xAF, 0xAC, 0x2C, 0x85, 0x85, 0x85, 0xAF, 0xAC,
  0xAC, 0x2C, 0xD9, 0xD6, 0xD6, 0x21, 0xB2, 0x2C,
  0xC8, 0x3B, 0x65, 0xC5, 0xCE, 0x8E, 0xC8, 0x2C,
  0xD9, 0x95, 0xAC, 0x2C, 0x2C, 0x2C, 0xAF, 0xAC,
  0xAC, 0xAF, 0x2C, 0x85, 0x2C, 0x2C, 0x2C, 0x85,
  0xDA, 0x2C, 0xD6, 0xAF, 0x59, 0x65, 0xDE, 0xF3,
  0xF3, 0x59, 0xBC, 0xAC, 0xAF, 0x85, 0x85, 0x85,
  0xAF, 0xD9, 0xAF, 0x2C, 0xD9, 0xD6, 0xD6, 0xD6,
  0x21, 0xD6, 0xD9, 0xDA, 0x8D, 0x8A, 0x2C, 0xD9,
  0xB2, 0xA1, 0xD6, 0xAC, 0x2C, 0x2C, 0x2C, 0x85,
  0x2C, 0xAC, 0x2C, 0xDA, 0xDA, 0x85, 0xAF, 0xD9,
  0xD9, 0xAC, 0xD9, 0xD9, 0xD9, 0xD9, 0xD9, 0xAC,
  0x85, 0x2A, 0x4D, 0xBC, 0x85, 0xAC, 0xAF, 0xAF,
  0xAC, 0xD9, 0xAF, 0x2C, 0xAF, 0xD9, 0xD9, 0xAC,
  0xAC, 0xAF, 0x85, 0x2C, 0x85, 0x2C, 0x2C, 0x2C,
  0x2C, 0xD9, 0xB2, 0xD4, 0xD6, 0x2C, 0x8A, 0xDA,
  0xC8, 0x85, 0x2C, 0xAC, 0x2C, 0xDA, 0xDA, 0x85,
  0xAF, 0xAC, 0xD9, 0xAC, 0xD9, 0xD9, 0xD9, 0xD9,
  0xD9, 0xAC, 0xDA, 0x8D, 0xBC, 0xDA, 0xD9, 0x95,
  0x95, 0xD9, 0xD9, 0xAF, 0x2C, 0x2C, 0x2C, 0x85,
  0x2C, 0xAF, 0xAF, 0x85, 0x85, 0x85, 0x2C, 0xAC,
  0xD9, 0xAF, 0xAF, 0xAF, 0x2C, 0x2C, 0x2C, 0x85,
  0x8A, 0x2A, 0x8D, 0x2C, 0xD9, 0x95, 0xAC, 0xAC,
  0xD9, 0xD9, 0xD9, 0xD9, 0x95, 0x95, 0xD9, 0xAF,
  0xAF, 0x2C, 0x85, 0x85, 0x85, 0x85, 0x85, 0x2C,
  0x85, 0x2C, 0xD9, 0xD9, 0xD9, 0x2C, 0x2C, 0x2C,
  0x2C, 0x85, 0x85, 0xAF, 0xAF, 0x85, 0x85, 0x85,
  0xAF, 0xD9, 0xD9, 0xAC, 0xAF, 0x2C, 0x2C, 0x2C,
  0x2C, 0x85, 0x8A, 0x2A, 0x8D, 0x2C, 0xD9, 0xD9,
  0x2C, 0xAC, 0xAF, 0x2C, 0x2C, 0x2C, 0x2C, 0x2C,
  0x85, 0xAF, 0xAC, 0x2C, 0x2C, 0x2C, 0x2C, 0xAC,
  0xD9, 0xD9, 0xAF, 0x85, 0x85, 0x85, 0xDA, 0xDA,
  0x8A, 0x8A, 0x85, 0xAC, 0xD9, 0xD9, 0xAC, 0xD9,
  0xD6, 0xD6, 0x7D, 0x95, 0x7D, 0xD9, 0xAF, 0xAF,
  0xAF, 0x2C, 0x85, 0x85, 0xDA, 0x85, 0x2C, 0x85,
  0x85, 0x2C, 0xAF, 0xAC, 0xAF, 0xAF, 0x2C, 0x2C,
  0x2C, 0x2C, 0x2C, 0xAF, 0xAC, 0x2C, 0x2C, 0x2C,
  0x2C, 0xAF, 0xD9, 0xAC, 0xAF, 0x2C, 0x85, 0x85,
  0x85, 0xDA, 0x8D, 0x8A, 0x85, 0xAC, 0x95, 0xD9
};

#define INCLUDE_LINUX_LOGOBW
#define INCLUDE_LINUX_LOGO16
#include <linux/linux_logo.h>

#else

/* prototypes only */
extern unsigned char linux_logo_red[];
extern unsigned char linux_logo_green[];
extern unsigned char linux_logo_blue[];
extern unsigned char linux_logo[];
extern unsigned char linux_logo_bw[];
extern unsigned char linux_logo16_red[];
extern unsigned char linux_logo16_green[];
extern unsigned char linux_logo16_blue[];
extern unsigned char linux_logo16[];

#endif
