/*  $Id: aty128.h,v 1.1 1999/10/12 11:00:40 geert Exp $
 *  linux/drivers/video/aty128.h
 *  Register definitions for ATI Rage128 boards
 *
 *  Anthony Tong <atong@uiuc.edu>, 1999
 */

#ifndef REG_RAGE128_H
#define REG_RAGE128_H

#define MM_INDEX				0x0000
#define MM_DATA					0x0004
#define CLOCK_CNTL_INDEX			0x0008
#define CLOCK_CNTL_DATA				0x000c
#define BIOS_0_SCRATCH				0x0010
#define BIOS_1_SCRATCH				0x0014
#define BIOS_2_SCRATCH				0x0018
#define BIOS_3_SCRATCH				0x001c
#define BUS_CNTL				0x0030
#define BUS_CNTL1				0x0034
#define MEM_VGA_WP_SEL				0x0038
#define MEM_VGA_RP_SEL				0x003c
#define GEN_INT_CNTL				0x0040
#define GEN_INT_STATUS				0x0044
#define CRTC_GEN_CNTL				0x0050
#define CRTC_EXT_CNTL				0x0054
#define DAC_CNTL				0x0058
#define CRTC_STATUS				0x005c
#define GPIO_MONID				0x0068
#define I2C_CNTL_1				0x0094
#define PALETTE_INDEX				0x00b0
#define PALETTE_DATA				0x00b4
#define CONFIG_CNTL				0x00e0
#define CONFIG_XSTRAP				0x00e4
#define CONFIG_BONDS				0x00e8
#define GEN_RESET_CNTL				0x00f0
#define GEN_STATUS				0x00f4
#define CONFIG_MEMSIZE				0x00f8
#define CONFIG_APER_0_BASE			0x0100
#define CONFIG_APER_1_BASE			0x0104
#define CONFIG_APER_SIZE			0x0108
#define CONFIG_REG_1_BASE			0x010c
#define CONFIG_REG_APER_SIZE			0x0110
#define CONFIG_MEMSIZE_EMBEDDED			0x0114
#define TEST_DEBUG_CNTL				0x0120
#define TEST_DEBUG_MUX				0x0124
#define HW_DEBUG				0x0128
#define TEST_DEBUG_OUT				0x012c
#define HOST_PATH_CNTL				0x0130
#define SW_SEMAPHORE				0x013c
#define MEM_CNTL				0x0140
#define EXT_MEM_CNTL				0x0144
#define MEM_ADDR_CONFIG				0x0148
#define MEM_INTF_CNTL				0x014c
#define MEM_STR_CNTL				0x0150
#define MEM_INIT_LAT_TIMER			0x0154
#define MEM_SDRAM_MODE_REG			0x0158
#define AGP_BASE				0x0170
#define AGP_CNTL				0x0174
#define AGP_APER_OFFSET				0x0178
#define PCI_GART_PAGE				0x017c
#define PC_NGUI_MODE				0x0180
#define PC_NGUI_CTLSTAT				0x0184
#define VIDEOMUX_CNTL				0x0190
#define MPP_TB_CONFIG				0x01C0
#define MPP_GP_CONFIG				0x01C8
#define VIPH_CONTROL				0x01D0
#define CRTC_H_TOTAL_DISP			0x0200
#define CRTC_H_SYNC_STRT_WID			0x0204
#define CRTC_V_TOTAL_DISP			0x0208
#define CRTC_V_SYNC_STRT_WID			0x020c
#define CRTC_VLINE_CRNT_VLINE			0x0210
#define CRTC_CRNT_FRAME				0x0214
#define CRTC_GUI_TRIG_VLINE			0x0218
#define CRTC_DEBUG				0x021c
#define CRTC_OFFSET				0x0224
#define CRTC_OFFSET_CNTL			0x0228
#define CRTC_PITCH				0x022c
#define OVR_CLR					0x0230
#define OVR_WID_LEFT_RIGHT			0x0234
#define OVR_WID_TOP_BOTTOM			0x0238
#define SNAPSHOT_VH_COUNTS			0x0240
#define SNAPSHOT_F_COUNT			0x0244
#define N_VIF_COUNT				0x0248
#define SNAPSHOT_VIF_COUNT			0x024c
#define CUR_OFFSET				0x0260
#define CUR_HORZ_VERT_POSN			0x0264
#define CUR_HORZ_VERT_OFF			0x0268
#define CUR_CLR0				0x026c
#define CUR_CLR1				0x0270
#define DAC_CRC_SIG				0x02cc
#define DDA_CONFIG				0x02e0
#define DDA_ON_OFF				0x02e4
#define VGA_DDA_CONFIG				0x02e8
#define VGA_DDA_ON_OFF				0x02ec
#define OV0_Y_X_START				0x0400
#define OV0_Y_X_END				0x0404
#define OV0_EXCLUSIVE_HORZ			0x0408
#define OV0_EXCLUSIVE_VERT			0x040c
#define OV0_REG_LOAD_CNTL			0x0410
#define OV0_SCALE_CNTL				0x0420
#define OV0_V_INC				0x0424
#define OV0_P1_V_ACCUM_INIT			0x0428
#define OV0_P23_V_ACCUM_INIT			0x042c
#define OV0_P1_BLANK_LINES_AT_TOP		0x0430
#define OV0_P23_BLANK_LINES_AT_TOP		0x0434
#define OV0_VID_BUF0_BASE_ADRS			0x0440
#define OV0_VID_BUF1_BASE_ADRS			0x0444
#define OV0_VID_BUF2_BASE_ADRS			0x0448
#define OV0_VID_BUF3_BASE_ADRS			0x044c
#define OV0_VID_BUF4_BASE_ADRS			0x0450
#define OV0_VID_BUF5_BASE_ADRS			0x0454
#define OV0_VID_BUF_PITCH0_VALUE		0x0460
#define OV0_VID_BUF_PITCH1_VALUE		0x0464
#define OV0_OCTWORDS_PER_LINE_M1		0x046c
#define OV0_AUTO_FLIP_CNTRL			0x0470
#define OV0_DEINTERLACE_PATTERN			0x0474
#define OV0_H_INC				0x0480
#define OV0_STEP_BY				0x0484
#define OV0_P1_H_ACCUM_INIT			0x0488
#define OV0_P23_H_ACCUM_INIT			0x048c
#define OV0_P1_X_START_END			0x0494
#define OV0_P2_X_START_END			0x0498
#define OV0_P3_X_START_END			0x049c
#define OV0_FILTER_CNTL				0x04a0
#define OV0_FOUR_TAP_COEF_0			0x04b0
#define OV0_FOUR_TAP_COEF_1			0x04b4
#define OV0_FOUR_TAP_COEF_2			0x04b8
#define OV0_FOUR_TAP_COEF_3			0x04bc
#define OV0_FOUR_TAP_COEF_4			0x04c0
#define OV0_COLOR_CNTL				0x04e0
#define OV0_VIDEO_KEY_CLR			0x04e4
#define OV0_VIDEO_KEY_MASK			0x04e8
#define OV0_GRAPHICS_KEY_CLR			0x04ec
#define OV0_GRAPHICS_KEY_MASK			0x04f0
#define OV0_KEY_CNTL				0x04f4
#define OV0_TEST				0x04f8
#define SUBPIC_CNTL				0x0540
#define PM4_BUFFER_OFFSET			0x0700
#define PM4_BUFFER_CNTL				0x0704
#define PM4_BUFFER_WM_CNTL			0x0708
#define PM4_BUFFER_DL_RPTR_ADDR			0x070c
#define PM4_BUFFER_DL_RPTR			0x0710
#define PM4_BUFFER_DL_WPTR			0x0714
#define PM4_VC_FPU_SETUP			0x071c
#define PM4_FPU_CNTL				0x0720
#define PM4_VC_FORMAT				0x0724
#define PM4_VC_CNTL				0x0728
#define PM4_VC_I01				0x072c
#define PM4_VC_VLOFF				0x0730
#define PM4_VC_VLSIZE				0x0734
#define PM4_IW_INDOFF				0x0738
#define PM4_IW_INDSIZE				0x073c
#define PM4_FPU_FPX0				0x0740
#define CRC_CMDFIFO_ADDR			0x0740
#define PM4_FPU_FPY0				0x0744
#define CRC_CMDFIFO_DOUT			0x0744
#define PM4_FPU_FPX1				0x0748
#define PM4_FPU_FPY1				0x074c
#define PM4_FPU_FPX2				0x0750
#define PM4_FPU_FPY2				0x0754
#define PM4_FPU_FPY3				0x0758
#define PM4_FPU_FPY4				0x075c
#define PM4_FPU_FPY5				0x0760
#define PM4_FPU_FPY6				0x0764
#define PM4_FPU_FPR				0x0768
#define PM4_FPU_FPG				0x076c
#define PM4_FPU_FPB				0x0770
#define PM4_FPU_FPA				0x0774
#define PM4_FPU_INTXY0				0x0780
#define PM4_FPU_INTXY1				0x0784
#define PM4_FPU_INTXY2				0x0788
#define PM4_FPU_INTARGB				0x078c
#define PM4_FPU_FPTWICEAREA			0x0790
#define PM4_FPU_DMAJOR01			0x0794
#define PM4_FPU_DMAJOR12			0x0798
#define PM4_FPU_DMAJOR02			0x079c
#define PM4_FPU_STAT				0x07a0
#define PM4_STAT				0x07b8
#define PM4_TEST_CNTL				0x07d0
#define PM4_MICROCODE_ADDR			0x07d4
#define PM4_MICROCODE_RADDR			0x07d8
#define PM4_MICROCODE_DATAH			0x07dc
#define PM4_MICROCODE_DATAL			0x07e0
#define PM4_CMDFIFO_ADDR			0x07e4
#define PM4_CMDFIFO_DATAH			0x07e8
#define PM4_CMDFIFO_DATAL			0x07ec
#define PM4_BUFFER_ADDR				0x07f0
#define PM4_BUFFER_DATAH			0x07f4
#define PM4_BUFFER_DATAL			0x07f8
#define PM4_MICRO_CNTL				0x07fc
#define VID_BUFFER_CONTROL			0x0900
#define CAP_INT_CNTL				0x0908
#define CAP_INT_STATUS				0x090c
#define CAP0_BUF0_OFFSET			0x0920
#define CAP0_BUF1_OFFSET			0x0924
#define CAP0_BUF0_EVEN_OFFSET			0x0928
#define CAP0_BUF1_EVEN_OFFSET			0x092c
#define CAP0_BUF_PITCH				0x0930
#define CAP0_V_WINDOW				0x0934
#define CAP0_H_WINDOW				0x0938
#define CAP0_VBI_ODD_OFFSET			0x093c
#define CAP0_VBI_EVEN_OFFSET			0x0940
#define CAP0_VBI_V_WINDOW			0x0944
#define CAP0_VBI_H_WINDOW			0x0948
#define CAP0_PORT_MODE_CNTL			0x094c
#define CAP0_TRIG_CNTL				0x0950
#define CAP0_DEBUG				0x0954
#define CAP0_CONFIG				0x0958
#define CAP0_ANC_ODD_OFFSET			0x095c
#define CAP0_ANC_EVEN_OFFSET			0x0960
#define CAP0_ANC_H_WINDOW			0x0964
#define CAP0_VIDEO_SYNC_TEST			0x0968
#define CAP0_ONESHOT_BUF_OFFSET			0x096c
#define CAP0_BUF_STATUS				0x0970
#define CAP0_DWNSC_XRATIO			0x0978
#define CAP0_XSHARPNESS				0x097c
#define CAP1_BUF0_OFFSET			0x0990
#define CAP1_BUF1_OFFSET			0x0994
#define CAP1_BUF0_EVEN_OFFSET			0x0998
#define CAP1_BUF1_EVEN_OFFSET			0x099c
#define CAP1_BUF_PITCH				0x09a0
#define CAP1_V_WINDOW				0x09a4
#define CAP1_H_WINDOW				0x09a8
#define CAP1_VBI_ODD_OFFSET			0x09ac
#define CAP1_VBI_EVEN_OFFSET			0x09b0
#define CAP1_VBI_V_WINDOW			0x09b4
#define CAP1_VBI_H_WINDOW			0x09b8
#define CAP1_PORT_MODE_CNTL			0x09bc
#define CAP1_TRIG_CNTL				0x09c0
#define CAP1_DEBUG				0x09c4
#define CAP1_CONFIG				0x09c8
#define CAP1_ANC_ODD_OFFSET			0x09cc
#define CAP1_ANC_EVEN_OFFSET			0x09d0
#define CAP1_ANC_H_WINDOW			0x09d4
#define CAP1_VIDEO_SYNC_TEST			0x09d8
#define CAP1_ONESHOT_BUF_OFFSET			0x09dc
#define CAP1_BUF_STATUS				0x09e0
#define CAP1_DWNSC_XRATIO			0x09e8
#define CAP1_XSHARPNESS				0x09ec
#define BM_FRAME_BUF_OFFSET			0x0a00
#define BM_SYSTEM_MEM_ADDR			0x0a04
#define BM_COMMAND				0x0a08
#define BM_STATUS				0x0a0c
#define BM_QUEUE_STATUS				0x0a10
#define BM_QUEUE_FREE_STATUS			0x0A14
#define BM_CHUNK_0_VAL				0x0a18
#define BM_CHUNK_1_VAL				0x0a1C
#define BM_VIP0_BUF				0x0A20
#define BM_VIP0_ACTIVE				0x0A24
#define BM_VIP1_BUF				0x0A30
#define BM_VIP1_ACTIVE				0x0A34
#define BM_VIP2_BUF				0x0A40
#define BM_VIP2_ACTIVE				0x0A44
#define BM_VIP3_BUF				0x0A50
#define BM_VIP3_ACTIVE				0x0A54
#define BM_VIDCAP_BUF0				0x0a60
#define BM_VIDCAP_BUF1				0x0a64
#define BM_VIDCAP_BUF2				0x0a68
#define BM_VIDCAP_ACTIVE			0x0a6c
#define BM_GUI					0x0a80
#define SURFACE_DELAY				0x0b00

/******************************************************************************
 *                  GUI Block Memory Mapped Registers                         *
 *                     These registers are FIFOed.                            *
 *****************************************************************************/
#define PM4_FIFO_DATA_EVEN			0x1000
#define PM4_FIFO_DATA_ODD			0x1004

#define DST_OFFSET				0x1404
#define DST_PITCH				0x1408
#define DST_WIDTH				0x140c
#define DST_HEIGHT				0x1410
#define SRC_X					0x1414
#define SRC_Y					0x1418
#define DST_X					0x141c
#define DST_Y					0x1420
#define SRC_PITCH_OFFSET			0x1428
#define DST_PITCH_OFFSET			0x142c
#define SRC_Y_X					0x1434
#define DST_Y_X					0x1438
#define DST_HEIGHT_WIDTH			0x143c
#define DP_GUI_MASTER_CNTL			0x146c
#define BRUSH_SCALE				0x1470
#define BRUSH_Y_X				0x1474
#define DP_BRUSH_BKGD_CLR			0x1478
#define DP_BRUSH_FRGD_CLR			0x147c
#define BRUSH_DATA0				0x1480
#define BRUSH_DATA1				0x1484
#define BRUSH_DATA2				0x1488
#define BRUSH_DATA3				0x148c
#define BRUSH_DATA4				0x1490
#define BRUSH_DATA5				0x1494
#define BRUSH_DATA6				0x1498
#define BRUSH_DATA7				0x149c
#define BRUSH_DATA8				0x14a0
#define BRUSH_DATA9				0x14a4
#define BRUSH_DATA10				0x14a8
#define BRUSH_DATA11				0x14ac
#define BRUSH_DATA12				0x14b0
#define BRUSH_DATA13				0x14b4
#define BRUSH_DATA14				0x14b8
#define BRUSH_DATA15				0x14bc
#define BRUSH_DATA16				0x14c0
#define BRUSH_DATA17				0x14c4
#define BRUSH_DATA18				0x14c8
#define BRUSH_DATA19				0x14cc
#define BRUSH_DATA20				0x14d0
#define BRUSH_DATA21				0x14d4
#define BRUSH_DATA22				0x14d8
#define BRUSH_DATA23				0x14dc
#define BRUSH_DATA24				0x14e0
#define BRUSH_DATA25				0x14e4
#define BRUSH_DATA26				0x14e8
#define BRUSH_DATA27				0x14ec
#define BRUSH_DATA28				0x14f0
#define BRUSH_DATA29				0x14f4
#define BRUSH_DATA30				0x14f8
#define BRUSH_DATA31				0x14fc
#define BRUSH_DATA32				0x1500
#define BRUSH_DATA33				0x1504
#define BRUSH_DATA34				0x1508
#define BRUSH_DATA35				0x150c
#define BRUSH_DATA36				0x1510
#define BRUSH_DATA37				0x1514
#define BRUSH_DATA38				0x1518
#define BRUSH_DATA39				0x151c
#define BRUSH_DATA40				0x1520
#define BRUSH_DATA41				0x1524
#define BRUSH_DATA42				0x1528
#define BRUSH_DATA43				0x152c
#define BRUSH_DATA44				0x1530
#define BRUSH_DATA45				0x1534
#define BRUSH_DATA46				0x1538
#define BRUSH_DATA47				0x153c
#define BRUSH_DATA48				0x1540
#define BRUSH_DATA49				0x1544
#define BRUSH_DATA50				0x1548
#define BRUSH_DATA51				0x154c
#define BRUSH_DATA52				0x1550
#define BRUSH_DATA53				0x1554
#define BRUSH_DATA54				0x1558
#define BRUSH_DATA55				0x155c
#define BRUSH_DATA56				0x1560
#define BRUSH_DATA57				0x1564
#define BRUSH_DATA58				0x1568
#define BRUSH_DATA59				0x156c
#define BRUSH_DATA60				0x1570
#define BRUSH_DATA61				0x1574
#define BRUSH_DATA62				0x1578
#define BRUSH_DATA63				0x157c
#define DST_WIDTH_X				0x1588
#define DST_HEIGHT_WIDTH_8			0x158c
#define SRC_X_Y					0x1590
#define DST_X_Y					0x1594
#define DST_WIDTH_HEIGHT			0x1598
#define DST_WIDTH_X_INCY			0x159c
#define DST_HEIGHT_Y				0x15a0
#define DST_X_SUB				0x15a4
#define DST_Y_SUB				0x15a8
#define SRC_OFFSET				0x15ac
#define SRC_PITCH				0x15b0
#define DST_HEIGHT_WIDTH_BW			0x15b4
#define CLR_CMP_CNTL				0x15c0
#define CLR_CMP_CLR_SRC				0x15c4
#define CLR_CMP_CLR_DST				0x15c8
#define CLR_CMP_MASK				0x15cc
#define DP_SRC_FRGD_CLR				0x15d8
#define DP_SRC_BKGD_CLR				0x15dc
#define GUI_SCRATCH_REG0			0x15e0
#define GUI_SCRATCH_REG1			0x15e4
#define GUI_SCRATCH_REG2			0x15e8
#define GUI_SCRATCH_REG3			0x15ec
#define GUI_SCRATCH_REG4			0x15f0
#define GUI_SCRATCH_REG5			0x15f4
#define LEAD_BRES_ERR				0x1600
#define LEAD_BRES_INC				0x1604
#define LEAD_BRES_DEC				0x1608
#define TRAIL_BRES_ERR				0x160c
#define TRAIL_BRES_INC				0x1610
#define TRAIL_BRES_DEC				0x1614
#define TRAIL_X					0x1618
#define LEAD_BRES_LNTH				0x161c
#define TRAIL_X_SUB				0x1620
#define LEAD_BRES_LNTH_SUB			0x1624
#define DST_BRES_ERR				0x1628
#define DST_BRES_INC				0x162c
#define DST_BRES_DEC				0x1630
#define DST_BRES_LNTH				0x1634
#define DST_BRES_LNTH_SUB			0x1638
#define SC_LEFT					0x1640
#define SC_RIGHT				0x1644
#define SC_TOP					0x1648
#define SC_BOTTOM				0x164c
#define SRC_SC_RIGHT				0x1654
#define SRC_SC_BOTTOM				0x165c
#define AUX_SC_CNTL				0x1660
#define AUX1_SC_LEFT				0x1664
#define AUX1_SC_RIGHT				0x1668
#define AUX1_SC_TOP				0x166c
#define AUX1_SC_BOTTOM				0x1670
#define AUX2_SC_LEFT				0x1674
#define AUX2_SC_RIGHT				0x1678
#define AUX2_SC_TOP				0x167c
#define AUX2_SC_BOTTOM				0x1680
#define AUX3_SC_LEFT				0x1684
#define AUX3_SC_RIGHT				0x1688
#define AUX3_SC_TOP				0x168c
#define AUX3_SC_BOTTOM				0x1690
#define GUI_DEBUG0				0x16a0
#define GUI_DEBUG1				0x16a4
#define GUI_TIMEOUT				0x16b0
#define GUI_TIMEOUT0				0x16b4
#define GUI_TIMEOUT1				0x16b8
#define GUI_PROBE				0x16bc
#define DP_CNTL					0x16c0
#define DP_DATATYPE				0x16c4
#define DP_MIX					0x16c8
#define DP_WRITE_MASK				0x16cc
#define DP_CNTL_XDIR_YDIR_YMAJOR		0x16d0
#define DEFAULT_OFFSET				0x16e0
#define DEFAULT_PITCH				0x16e4
#define DEFAULT_SC_BOTTOM_RIGHT			0x16e8
#define SC_TOP_LEFT				0x16ec
#define SC_BOTTOM_RIGHT				0x16f0
#define SRC_SC_BOTTOM_RIGHT			0x16f4
#define WAIT_UNTIL				0x1720
#define CACHE_CNTL				0x1724
#define GUI_STAT				0x1740
#define PC_GUI_MODE				0x1744
#define PC_GUI_CTLSTAT				0x1748
#define PC_DEBUG_MODE				0x1760
#define BRES_DST_ERR_DEC			0x1780
#define TRAIL_BRES_T12_ERR_DEC			0x1784
#define TRAIL_BRES_T12_INC			0x1788
#define DP_T12_CNTL				0x178c
#define DST_BRES_T1_LNTH			0x1790
#define DST_BRES_T2_LNTH			0x1794
#define HOST_DATA0				0x17c0
#define HOST_DATA1				0x17c4
#define HOST_DATA2				0x17c8
#define HOST_DATA3				0x17cc
#define HOST_DATA4				0x17d0
#define HOST_DATA5				0x17d4
#define HOST_DATA6				0x17d8
#define HOST_DATA7				0x17dc
#define HOST_DATA_LAST				0x17e0
#define SECONDARY_SCALE_PITCH			0x1980
#define SECONDARY_SCALE_X_INC			0x1984
#define SECONDARY_SCALE_Y_INC			0x1988
#define SECONDARY_SCALE_HACC			0x198c
#define SECONDARY_SCALE_VACC			0x1990
#define SCALE_SRC_HEIGHT_WIDTH			0x1994
#define SCALE_OFFSET_0				0x1998
#define SCALE_PITCH				0x199c
#define SCALE_X_INC				0x19a0
#define SCALE_Y_INC				0x19a4
#define SCALE_HACC				0x19a8
#define SCALE_VACC				0x19ac
#define SCALE_DST_X_Y				0x19b0
#define SCALE_DST_HEIGHT_WIDTH			0x19b4
#define SCALE_3D_CNTL				0x1a00
#define SCALE_3D_DATATYPE			0x1a20
#define SETUP_CNTL				0x1bc4
#define SOLID_COLOR				0x1bc8
#define WINDOW_XY_OFFSET			0x1bcc
#define DRAW_LINE_POINT				0x1bd0
#define SETUP_CNTL_PM4				0x1bd4
#define DST_PITCH_OFFSET_C			0x1c80
#define DP_GUI_MASTER_CNTL_C			0x1c84
#define SC_TOP_LEFT_C				0x1c88
#define SC_BOTTOM_RIGHT_C			0x1c8c

#define CLR_CMP_MASK_3D				0x1A28
#define MISC_3D_STATE_CNTL_REG			0x1CA0
#define MC_SRC1_CNTL				0x19D8
#define TEX_CNTL				0x1800

/* CONSTANTS */
#define GUI_ACTIVE				0x80000000
#define ENGINE_IDLE				0x0

#define PLL_WR_EN				0x00000080

#define CLK_PIN_CNTL				0x0001
#define PPLL_CNTL				0x0002
#define PPLL_REF_DIV				0x0003
#define PPLL_DIV_0				0x0004
#define PPLL_DIV_1				0x0005
#define PPLL_DIV_2				0x0006
#define PPLL_DIV_3				0x0007
#define VCLK_ECP_CNTL				0x0008
#define HTOTAL_CNTL				0x0009
#define X_MPLL_REF_FB_DIV			0x000a
#define XPLL_CNTL				0x000b
#define XDLL_CNTL				0x000c
#define XCLK_CNTL				0x000d
#define MPLL_CNTL				0x000e
#define MCLK_CNTL				0x000f
#define AGP_PLL_CNTL				0x0010
#define FCP_CNTL				0x0012
#define PLL_TEST_CNTL				0x0013

#define PPLL_RESET				0x01
#define PPLL_ATOMIC_UPDATE_EN			0x10000
#define PPLL_VGA_ATOMIC_UPDATE_EN		0x20000
#define PPLL_REF_DIV_MASK			0x3FF
#define PPLL_FB3_DIV_MASK			0x7FF
#define PPLL_POST3_DIV_MASK			0x70000
#define PPLL_ATOMIC_UPDATE_R			0x8000
#define PPLL_ATOMIC_UPDATE_W			0x8000
#define MEM_CFG_TYPE_MASK			0x3
#define XCLK_SRC_SEL_MASK			0x7
#define XPLL_FB_DIV_MASK			0xFF00
#define X_MPLL_REF_DIV_MASK			0xFF

/* CRTC control values (CRTC_GEN_CNTL) */
#define CRTC_CSYNC_EN				0x00000010

#define CRTC_PIX_WIDTH_MASK			0x00000700
#define CRTC_PIX_WIDTH_4BPP			0x00000100
#define CRTC_PIX_WIDTH_8BPP			0x00000200
#define CRTC_PIX_WIDTH_15BPP			0x00000300
#define CRTC_PIX_WIDTH_16BPP			0x00000400
#define CRTC_PIX_WIDTH_24BPP			0x00000500
#define CRTC_PIX_WIDTH_32BPP			0x00000600

/* DAC_CNTL bit constants */                       
#define DAC_8BIT_EN				0x00000100

/* GEN_RESET_CNTL bit constants */
#define SOFT_RESET_GUI				0x00000001
#define SOFT_RESET_VCLK				0x00000100
#define SOFT_RESET_PCLK				0x00000200
#define SOFT_RESET_ECP				0x00000400
#define SOFT_RESET_DISPENG_XCLK			0x00000800

/* PC_GUI_CTLSTAT bit constants */
#define PC_BUSY_INIT				0x10000000                 
#define PC_BUSY_GUI				0x20000000                 
#define PC_BUSY_NGUI				0x40000000
#define PC_BUSY					0x80000000

#define BUS_MASTER_DIS				0x00000040
#define PM4_BUFFER_CNTL_NONPM4			0x00000000

/* DP_GUI_MASTER_CNTL bit constants */
#define	GMC_SRC_PITCH_OFFSET_DEFAULT		0x00000000
#define GMC_DST_PITCH_OFFSET_DEFAULT		0x00000000
#define GMC_SRC_CLIP_DEFAULT			0x00000000
#define GMC_DST_CLIP_DEFAULT			0x00000000
#define GMC_BRUSH_SOLIDCOLOR			0x000000d0
#define GMC_SRC_DSTCOLOR			0x00003000
#define GMC_BYTE_ORDER_MSB_TO_LSB		0x00000000
#define GMC_DP_SRC_RECT				0x02000000
#define GMC_3D_FCN_EN_CLR			0x00000000
#define GMC_AUX_CLIP_CLEAR			0x20000000
#define GMC_DST_CLR_CMP_FCN_CLEAR		0x10000000
#define GMC_WRITE_MASK_SET			0x40000000
#define GMC_DP_CONVERSION_TEMP_6500		0x00000000

/* DP_GUI_MASTER_CNTL ROP3 named constants */
#define	ROP3_PATCOPY				0x00f00000
#define ROP3_SRCCOPY				0x00cc0000   // S

#define SRC_DSTCOLOR				0x00030000

/* DP_CNTL bit constants */
#define DST_X_RIGHT_TO_LEFT			0x00000000
#define DST_X_LEFT_TO_RIGHT			0x00000001
#define DST_Y_BOTTOM_TO_TOP			0x00000000
#define DST_Y_TOP_TO_BOTTOM			0x00000002
#define DST_X_MAJOR				0x00000000
#define DST_Y_MAJOR				0x00000004
#define DST_X_TILE				0x00000008
#define DST_Y_TILE				0x00000010
#define DST_LAST_PEL				0x00000020
#define DST_TRAIL_X_RIGHT_TO_LEFT		0x00000000
#define DST_TRAIL_X_LEFT_TO_RIGHT		0x00000040
#define DST_TRAP_FILL_RIGHT_TO_LEFT		0x00000000
#define DST_TRAP_FILL_LEFT_TO_RIGHT		0x00000080
#define DST_BRES_SIGN				0x00000100
#define DST_HOST_BIG_ENDIAN_EN			0x00000200
#define DST_POLYLINE_NONLAST			0x00008000
#define DST_RASTER_STALL			0x00010000
#define DST_POLY_EDGE				0x00040000

/* DP_MIX bit constants */
#define DP_SRC_RECT				0x00000200
#define DP_SRC_HOST				0x00000300
#define DP_SRC_HOST_BYTEALIGN			0x00000400

#endif /* REG_RAGE128_H */
