#include <stdio.h>

extern long ce_exec_config[];

main(int argc, char *argv[])
{
	int i, cnt, pos, len;
	unsigned char *lp;
	unsigned char buf[8192];
	if (argc != 1)
	{
		fprintf(stderr, "usage: %s <in-file >out-file\n", argv[0]);
		exit(1);
	}
	fprintf(stdout, "#\n");
	fprintf(stdout, "# Miscellaneous data structures:\n");
	fprintf(stdout, "# WARNING - this file is automatically generated!\n");
	fprintf(stdout, "#\n");
	fprintf(stdout, "\n");
	fprintf(stdout, "\t.data\n");
	fprintf(stdout, "\t.globl input_data\n");
	fprintf(stdout, "input_data:\n");
	pos = 0;
	while ((len = read(0, buf, sizeof(buf))) > 0)
	{
		cnt = 0;
		lp = (unsigned char *)buf;
		len = (len + 3) & ~3;  /* Round up to longwords */
		for (i = 0;  i < len;  i += 4)
		{
			if (cnt == 0)
			{
				fprintf(stdout, "\t.long\t");
			}
			fprintf(stdout, "0x%02X%02X%02X%02X", lp[0], lp[1], lp[2], lp[3]);
			lp += 4;
			if (++cnt == 4)
			{
				cnt = 0;
				fprintf(stdout, " # %x \n", pos+i-12);
				fflush(stdout);
			} else
			{
				fprintf(stdout, ",");
			}
		}
		if (cnt)
		{
			fprintf(stdout, "0\n");
		}
		pos += len;
	}
	fprintf(stdout, "\t.globl input_len\n");
	fprintf(stdout, "input_len:\t.long\t0x%x\n", pos);
	fflush(stdout);
	fclose(stdout);
	exit(0);
}

