/*
 * Decompiled with CFR 0.152.
 */
package org.dvb.io.ixc;

import java.rmi.AlreadyBoundException;
import java.rmi.NotBoundException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import javax.tv.xlet.XletContext;
import org.videolan.IxcRegistryImpl;

public class IxcRegistry {
    private static final Object instanceLock = new Object();
    private static IxcRegistryImpl registry = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static IxcRegistryImpl getIxcRegistry() {
        Object object = instanceLock;
        synchronized (object) {
            if (registry == null) {
                registry = new IxcRegistryImpl();
            }
            return registry;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void shutdown() {
        IxcRegistryImpl r;
        Object object = instanceLock;
        synchronized (object) {
            r = registry;
            registry = null;
        }
        if (r != null) {
            r.unbindAll();
        }
    }

    public static Remote lookup(XletContext xc, String path) throws NotBoundException, RemoteException {
        int appid;
        int orgid;
        if (path.charAt(0) != '/') {
            throw new IllegalArgumentException();
        }
        int s1 = path.indexOf(47, 1);
        if (s1 <= 1) {
            throw new IllegalArgumentException();
        }
        try {
            orgid = Integer.parseInt(path.substring(1, s1), 16);
        }
        catch (Exception e) {
            throw new IllegalArgumentException();
        }
        int s2 = path.indexOf(47, ++s1);
        if (s2 <= s1) {
            throw new IllegalArgumentException();
        }
        try {
            appid = Integer.parseInt(path.substring(s1, s2), 16);
        }
        catch (Exception e) {
            throw new IllegalArgumentException();
        }
        String key = "/" + Integer.toHexString(orgid) + "/" + Integer.toHexString(appid) + "/" + path.substring(s2 + 1, path.length());
        return IxcRegistry.getIxcRegistry().lookup(xc, key);
    }

    public static void bind(XletContext xc, String name, Remote obj) throws AlreadyBoundException {
        if (xc == null || name == null || obj == null) {
            throw new NullPointerException();
        }
        String key = "/" + (String)xc.getXletProperty("dvb.org.id") + "/" + (String)xc.getXletProperty("dvb.app.id") + "/" + name;
        IxcRegistry.getIxcRegistry().bind(xc, key, obj);
    }

    public static void unbind(XletContext xc, String name) throws NotBoundException {
        if (xc == null || name == null) {
            throw new NullPointerException();
        }
        String key = "/" + (String)xc.getXletProperty("dvb.org.id") + "/" + (String)xc.getXletProperty("dvb.app.id") + "/" + name;
        IxcRegistry.getIxcRegistry().unbind(key);
    }

    public static void rebind(XletContext xc, String name, Remote obj) {
        if (xc == null || name == null || obj == null) {
            throw new NullPointerException();
        }
        String key = "/" + (String)xc.getXletProperty("dvb.org.id") + "/" + (String)xc.getXletProperty("dvb.app.id") + "/" + name;
        try {
            IxcRegistry.getIxcRegistry().unbind(key);
        }
        catch (NotBoundException e) {
            // empty catch block
        }
        try {
            IxcRegistry.getIxcRegistry().bind(xc, key, obj);
        }
        catch (AlreadyBoundException e) {
            // empty catch block
        }
    }

    public static String[] list(XletContext xc) {
        return IxcRegistry.getIxcRegistry().list();
    }

    public static void unbindAll(XletContext xc) {
        IxcRegistry.getIxcRegistry().unbindAll(xc);
    }
}

